;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: wasm-opt %s --generate-global-effects --vacuum -all -S -o - | filecheck %s

(module
 ;; CHECK:      (func $nop (type $0) (param $0 i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $nop (param $0 i32)
  (nop)
 )

 ;; CHECK:      (func $test (type $1)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT: )
 (func $test
  (local $x i32)
  (local.set $x
   (i32.const 0)
  )
  ;; After we compute global effects, we see that this call has no effects. We
  ;; can then remove it, and all of its contents have no effects as well. The
  ;; rest of the function is also removable and the entire body can be a nop.
  ;;
  ;; This is a regression testcase for a crash in TypeUpdater, which involved
  ;; the call being discovered as having no effects, and then when we started
  ;; to remove its children we'd remove the br first; that removal would make
  ;; the block seem to have no brs that reach it any more (since the only one
  ;; was removed). But as the br was still in the tree, and had type
  ;; unreachable, we thought the block should become unreachable, which then
  ;; propagated out to the call and the toplevel block. (Users of TypeUpdater
  ;; should first remove things from the tree, and then do the update.)
  (call $nop
   (block $block (result i32)
    (br $block
     (i32.const 4)
    )
   )
  )
  (drop
    (local.get $x)
  )
 )
)

