#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by create.cc

// static
void MemoryAccess::cptSizes(size_t *nBlocks, size_t *blockSize,
                            string const &bufSize)
{
    size_t pos;
    size_t factor = stoul(bufSize, &pos);   // get the factor (e.g. 12 of 12kB)
    
    switch ((pos == string::npos) ? 'k' : tolower(bufSize[pos]))
    {
        default:    // kB
            kiloBytes(nBlocks, blockSize, factor);
        return;

        case 'm':
            megaBytes(nBlocks, blockSize, factor);
        return;

        case 'g':
            gigaBytes(nBlocks, blockSize, factor);
        return;
    }
}
