Logic, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), provides `boost::logic::tribool` for 3-state boolean logic.

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++03
* Header Only

### Build Status

<!-- boost-ci/tools/makebadges.sh --project logic --appveyor 8mtghg32sqgc2syg --codecov 2RCqoPxHln --coverity 16173 -->
| Branch          | GHA CI | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
| :-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
| [`master`](https://github.com/boostorg/logic/tree/master) | [![Build Status](https://github.com/boostorg/logic/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/logic/actions?query=branch:master) | [![Build status](https://ci.appveyor.com/api/projects/status/8mtghg32sqgc2syg/branch/master?svg=true)](https://ci.appveyor.com/project/cppalliance/logic/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16173/badge.svg)](https://scan.coverity.com/projects/boostorg-logic) | [![codecov](https://codecov.io/gh/boostorg/logic/branch/master/graph/badge.svg?token=2RCqoPxHln)](https://codecov.io/gh/boostorg/logic/tree/master) | [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/logic.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](https://www.boost.org/doc/libs/master/libs/logic) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://www.boost.org/development/tests/master/developer/logic.html)
| [`develop`](https://github.com/boostorg/logic/tree/develop) | [![Build Status](https://github.com/boostorg/logic/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/logic/actions?query=branch:develop) | [![Build status](https://ci.appveyor.com/api/projects/status/8mtghg32sqgc2syg/branch/develop?svg=true)](https://ci.appveyor.com/project/cppalliance/logic/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16173/badge.svg)](https://scan.coverity.com/projects/boostorg-logic) | [![codecov](https://codecov.io/gh/boostorg/logic/branch/develop/graph/badge.svg?token=2RCqoPxHln)](https://codecov.io/gh/boostorg/logic/tree/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/logic.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](https://www.boost.org/doc/libs/develop/libs/logic) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://www.boost.org/development/tests/develop/developer/logic.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `example`   | examples                       |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](https://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-logic)
* [Report bugs](https://github.com/boostorg/logic/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](https://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](https://www.boost.org/community/policy.html) before posting and add the `[logic]` tag at the beginning of the subject line.
