// ************************************************************************** //
//
//  BornAgain: simulate and fit scattering at grazing incidence
//
//! @file      Sample/SoftParticle/SoftParticles.h
//! @brief     Includes all soft-particle form-factor definitions.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
// ************************************************************************** //

#ifndef BORNAGAIN_CORE_SOFTPARTICLE_SOFTPARTICLES_H
#define BORNAGAIN_CORE_SOFTPARTICLE_SOFTPARTICLES_H

#include "Sample/SoftParticle/FormFactorGauss.h"
#include "Sample/SoftParticle/FormFactorSphereGaussianRadius.h"
#include "Sample/SoftParticle/FormFactorSphereLogNormalRadius.h"

#endif // BORNAGAIN_CORE_SOFTPARTICLE_SOFTPARTICLES_H
