# CiviCRM 5.6.0

Released October 3, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Activity display, switch to more performance getActivities function (from
  deprecatedGetActivities)
  ([12559](https://github.com/civicrm/civicrm-core/pull/12559))**

  This change improves performance and alignment on the activity tab.

- **Upgrade symfony in lockfile to be 2.8 which is supported version of 2…
  ([12633](https://github.com/civicrm/civicrm-core/pull/12633))**

  This change upgrades symfony from 2.6 to 2.8.44.

- **Improve styling of address block on summary screen
  ([12723](https://github.com/civicrm/civicrm-core/pull/12723))**

  This changes the display of the address block to be more consistent with the
  way that email and website are displayed on a contact.

- **Foreign key for civicrm_custom_field.option_group_id
  ([12706](https://github.com/civicrm/civicrm-core/pull/12706))**

  This change adds a foreign key for option group id to the custom field table.

- **Added Pseudoconstant for phone and website type
  ([12727](https://github.com/civicrm/civicrm-core/pull/12727))**

  This Adds a Pseudoconstant for phone and website type.

- **Contact summary - adjust block width when editing
  ([12708](https://github.com/civicrm/civicrm-core/pull/12708))**

  This makes it so that on the inline Contact edit form, when a user clicks to
  edit a section that section grows to allow the edit fields to be full sized.

- **Added Pseudoconstant tag for visibility
  ([12705](https://github.com/civicrm/civicrm-core/pull/12705))**

  This change improves the API Explorer by adding a Pseudoconstant tag for
  visibility. This makes it so that civicrm_option_value.visibility_id is now a
  dropdown field with the visibility option group options.

- **Use static cache for UFMatch lookups to improve performance
  ([12628](https://github.com/civicrm/civicrm-core/pull/12628))**

  This is a performance improvement, specifically it cuts down on load time for
  the contact summary page.

- **Replicate fix on PR #12643 for pledge report
  ([12685](https://github.com/civicrm/civicrm-core/pull/12685))**

  This change makes it so on the "Pledged not Paid" report one can filter by
  smart groups.

- **[dev/core#217](https://lab.civicrm.org/dev/core/issues/217) Allow
  replacement of PrevNextCache implementation (for search screens)
  ([12664](https://github.com/civicrm/civicrm-core/pull/12664) and
  [12663](https://github.com/civicrm/civicrm-core/pull/12663)) (Preliminary Work)**

  This change makes it so for the purposes of search-caching CiviCRM no longer
  fills or reads the columns 'entity_table' and 'entity_id2' in the
  civicrm_prevnext_cache table and makes the cacheKey column simpler and more
  consistent.

- **[dev/core#302](https://lab.civicrm.org/dev/core/issues/302) End of life
  plans for 5.x php versions & planning for 7.0 EOL
  ([12625](https://github.com/civicrm/civicrm-core/pull/12625)) (preliminary
  work)**

  This change Bumps the recommended php version to 7.1 and min recommended to
  7.0

- **Add SQL modes to developer tab
  ([12656](https://github.com/civicrm/civicrm-core/pull/12656))**

  This change adds SQL Mode info to the developer tab on reports.

- **don't add query to developer tab if we are downloading the data
  ([12666](https://github.com/civicrm/civicrm-core/pull/12666))**

  This is a performance improvement for downloading reports for users who have
  permission to view the developer tab on reports.

- **filter current employer report by all groups
  ([12643](https://github.com/civicrm/civicrm-core/pull/12643))**

  This change makes it so one can filter the Current Employer report by all
  groups. Prior to this change one could onlt filter this report by static
  groups.

### CiviCase

- **Make contact name into a link on Manage Case for single client
  ([12619](https://github.com/civicrm/civicrm-core/pull/12619))**

  On the Manage Case page for a single client, this change makes the contact
  name linked to that contact's summary page.

### CiviContribute

- **Remove net_amount from the Back office contribution form.
  ([12662](https://github.com/civicrm/civicrm-core/pull/12662))**

  This change removes the net amount field from the back office contribution
  form. The net amount is calculated in the BAO.

- **API : Set current domain as a sensible default for payment processor
  ([12595](https://github.com/civicrm/civicrm-core/pull/12595))**

  This change improves the PaymentProcessor.create api action by making
  domain_id optional and setting it to use the current domain as the default if
  a domain_id is not sent.

### CiviMember

- **Enable custom data display on MembershipType form
  ([12738](https://github.com/civicrm/civicrm-core/pull/12738))**

  This makes it so if Membership Type custom fields are configured they are
  displayed on the Membership Type form.

### Drupal Integration

- **[dev/core#237](https://lab.civicrm.org/dev/core/issues/237) Hide Drupal8
  Administer Menu bar on CiviCRM pages
  ([12463](https://github.com/civicrm/civicrm-core/pull/12463))**

  This change hides the Drupal8 menu bar when a user is on a civi backend page.

- **Drupal Views CiviCRM: Allow Participant record to be used from Event.
  ([539](https://github.com/civicrm/civicrm-drupal/pull/539))**

  This change makes it so in Drupal Views one can configure a relationship
  between CiviCRM Events and CiviCRM Participants.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Handle smart groups created in previous Civis which include
  relation_permission
  ([12804](https://github.com/civicrm/civicrm-core/pull/12804))**

  This change fixes a bug where smart groups created in CiviCRM 5.4 based on a
  search using a relationship break in CiviCRM 5.5 so that they work as
  expected.

- **[dev/core#346](https://lab.civicrm.org/dev/core/issues/346) Online Pay Now
  error when used from dashboard checksum link
  ([12745](https://github.com/civicrm/civicrm-core/pull/12745))**

  This change fixes a bug where when a user accessed the CiviCRM user dashboard
  using a checksum and then clicked the paynow link, the paynow link would
  break, so that the pay now link takes you to pay now as expected.

- **Show ext version status even when directory not writeable
  ([12757](https://github.com/civicrm/civicrm-core/pull/12757))**

  This change fixes a bug where extension updates were not showing if the
  extension directory was not writable so that information about extension
  updates are shown on the extensions tab regardless of whether the extension
  directory is writabale.

- **Remove mcrypt warning except for affected sites.
  ([12733](https://github.com/civicrm/civicrm-core/pull/12733))**

  This change makes it so that the System Check that warns people that mcrypt is
  not available only shows on sites that store smtp passwords in their database
  (the only users for whom this warning is applicable).

- **[dev/core#367](https://lab.civicrm.org/dev/core/issues/367) Fatal error /
  SQL timeout in A-Z pager for advanced search by relationship with target group
  for reciprocal relationship types
  ([12740](https://github.com/civicrm/civicrm-core/pull/12740))**

  This change fixes a bug where advanced searches on reciprocal relationships
  (ex: "spouse") and using the criteria "target contact is in group" on sites
  with large numbers of relationships of that type would take a long time,
  occasionally timing out entirely.

- **[dev/core#343](https://lab.civicrm.org/dev/core/issues/343) Long lines in
  contact name or address overflow mailing labels
  ([12691](https://github.com/civicrm/civicrm-core/pull/12691))**

  This change fixes a bug where PDF Mailing Labels generated by civi were not
  wrapping appropriately so that they wrap and do run off the label.

- **[dev/core#351](https://lab.civicrm.org/dev/core/issues/351) ERROR: LoadForm
  Pop-up w/out Params in URL
  ([12735](https://github.com/civicrm/civicrm-core/pull/12735))**

  This change fixes a bug where the load form function used to open a form in a
  pop up window was throwing an error if no parameters were included in the URL
  so no error is thrown if no parameters are sent (and no parameters are
  necessary).

- **[dev/core#349](https://lab.civicrm.org/dev/core/issues/349) Scheduled
  reminders list default sort does not work
  ([12701](https://github.com/civicrm/civicrm-core/pull/12701))**

  This change fixes the default sort of the Scheduled reminders list so that it
  sorts by title.

- **[dev/translation#14](https://lab.civicrm.org/dev/translation/issues/14)
  InnoDB Advanced Logging cannot be enabled on multi-lingual
  ([12667](https://github.com/civicrm/civicrm-core/pull/12667))**

  This change makes it so that InnoDB Advanced Logging can be enabled on
  multi-lingual sites using:
  https://github.com/eileenmcnaughton/nz.co.fuzion.innodbtriggers

- **Fix recent item deduping & call hooks
  ([12704](https://github.com/civicrm/civicrm-core/pull/12704))**

  This change fixes a bug where sometimes the same item would be added twice to
  the "recent items" list.

- **Wrap long labels onto multiple lines to prevent text being cut off
  ([12716](https://github.com/civicrm/civicrm-core/pull/12716))**

  This change makes it so that on front facing forms, long labels wrap on to
  multiple lines.

- **Navigation - Don't reprocess fully-formed urls
  ([12702](https://github.com/civicrm/civicrm-core/pull/12702))**

  This change fixes an edge case where fully-formed urls in the menubar were
  getting garbled so that relative urls, absolute urls and local urls are all
  processed correctly.

- **Fix CRM_ACL_API::whereClause to respect $contactId param
  ([12576](https://github.com/civicrm/civicrm-core/pull/12576))**

  This adds support to the CMS based permission checking and ensures that
  CRM_ACL_API::whereClause checks the permissions for the contact Id it is sent
  (before this change it checked the permissions of the logged in user).

- **[dev/accessibility#10](https://lab.civicrm.org/dev/accessibility/issues/10)
  Make datepicker
  accessible ([12631](https://github.com/civicrm/civicrm-core/pull/12631)) (Preliminary Work)**

  This change moves CiviCRM towards making the date picker accessible (one could
  select a date from the calendar using control keys without using a mouse) by
  moving the datepicker functionality to its own file.

- **[dev/core#295](https://lab.civicrm.org/dev/core/issues/295) Default 'from'
  mail address is not the default one showing in 'send email'
 ([12603](https://github.com/civicrm/civicrm-core/pull/12603))**

  This change makes it so that when sending an email using the "send email"
  action if "Allow Mail to be sent from logged in contact's email address" is
  disabled in settings the default from address is loaded into the from address
  field.

- **Further removal of instance of using LOWER() rather than relying on mysql
  non-case-sensitivity.
  ([12612](https://github.com/civicrm/civicrm-core/pull/12612))**

  This change improves performance when searching on email_greeting,
  postal_greeting, address.

- **Fix ReportInstance BAO to call post hook after save (instead of calling pre
  twice). ([12722](https://github.com/civicrm/civicrm-core/pull/12722))**

  This change improves the hook functionality in the ReportInstance BAO so that
  one can call post hook after save and so that the pre hook is only called
  once.

### CiviCase

- **[dev/core#297](https://lab.civicrm.org/dev/core/issues/297) permission
  "access my cases and activities" is broken by CRM-21461
  ([12613](https://github.com/civicrm/civicrm-core/pull/12613))**

  This change fixes the permission "access my cases and activites".

- **[dev/core#361](https://lab.civicrm.org/dev/core/issues/361) Mistake in Case
  api spec description
  ([12726](https://github.com/civicrm/civicrm-core/pull/12726))**

  This changes the text in the API Explorer for the entity Case for the
  parameter Tags to read "Find cases with specified tags." before this change it
  read "Find activities with specified tags.".

- **[dev/core#245](https://lab.civicrm.org/dev/core/issues/245) Duplicate
  activities shown on case tab
  ([12444](https://github.com/civicrm/civicrm-core/pull/12444))**

  This change fixes a bug where If there were multiple assignee/target contacts on
  an activity, the activities were being duplicated on the case activities tab.
  Additionally this change fixes a bug where if the activity is only allowed a
  single instance and the user tried to add another, the link had an invalid
  activity Id.

- **Don't duplicate activity when filing on case
  ([12620](https://github.com/civicrm/civicrm-core/pull/12620))**

  This change fixes a bug where filing an activity on a case using the "File On
  Case" link on the actvitytab/activity detail view  would result in two
  activities one related to the case and one not.

### CiviContribute

- **[dev/core#299](https://lab.civicrm.org/dev/core/issues/299) Decimal point
  error. ([12684](https://github.com/civicrm/civicrm-core/pull/12684))
  (Continuation of work)**

  This change localizes the display of the amount on the update payment details
  form.

- **[dev/core#334](https://lab.civicrm.org/dev/core/issues/334) Public
  contribution form and Checksums: billing information not loaded if using
  multiple processors
  ([12679](https://github.com/civicrm/civicrm-core/pull/12679))**

  This fixes a bug where when a user goes to a contribution page that is
  configured to use multiple payment processors via a checksum link the billing
  address section was not pre-populating so that the billing section does
  pre-populate.

- **[dev/core#119](https://lab.civicrm.org/dev/core/issues/119) Notice error
  ([12626](https://github.com/civicrm/civicrm-core/pull/12626))**

  When recording a payment on a site that is configured not to use decimal
  thousand separators, that configuration was not being respected for the
  default amount. This change fixes the default amount to be localized
  appropriately.

- **[dev/core#322](https://lab.civicrm.org/dev/core/issues/322) Contribution
  page, completing this form on behalf of someone else: JavaScript error for
  checkbox field ([12652](https://github.com/civicrm/civicrm-core/pull/12652))**

  This fixes a bug on contribution pages configured to accept donations onbehalf
  of someone else and to include a profile with a checkbox where checking the
  checkbox in the profile would result in a javascript error, additionally it
  ensures that the form is  populated with the onbehalf of contact's data.

- **Use cached version of payment processor.
  ([12627](https://github.com/civicrm/civicrm-core/pull/12627))**

  This change fixes a bug where some payment processors when combined with Redis
  were failing to complete transactions because Redis was caching the call to
  completetransaction.

- **[dev/core#325](https://lab.civicrm.org/dev/core/issues/325) Fatal error 'DB Error: no
  such field' on Contribution detail report
  ([12660](https://github.com/civicrm/civicrm-core/pull/12660))**

  This change fixes a bug where on the Contribution Detail report, selecting the
  "Age" column would result in a fatal error so that the report includes Age as
  expected.

- **[dev/core#386](https://lab.civicrm.org/dev/core/issues/386)
  Contribution Detail Report shows no amount if set to Soft Credit Only
  ([12860](https://github.com/civicrm/civicrm-core/pull/12860))**

- **[dev/core#341](https://lab.civicrm.org/dev/core/issues/341) "Contributions
  made in Year X and not Year Y" custom search ignores date field
  ([12686](https://github.com/civicrm/civicrm-core/pull/12686))**

  This fixes a bug where custom searches using the "Contributions made in Year X
  and not Year Y" were not respecting the date parameters, so that date
  parameters are respected.

- **[dev/core#327](https://lab.civicrm.org/dev/core/issues/327) PHP Fatal error:
  Call to undefined method - Contribution Details report
  ([12661](https://github.com/civicrm/civicrm-core/pull/12661))**

  This fixes a bug where checking the Gender column field on the Contribution
  Details report resulted in a fatal error so that one can include a gender
  column in this report.

### CiviEvent

- **Fix Undefined index: params in CRM_Event_BAO_Event::buildCustomProfile()
  ([12678](https://github.com/civicrm/civicrm-core/pull/12678))**

  This change suppresses an undefined index notice that was showing when one
  comes to an Event from an online payment provider.

- **[dev/core#344](https://lab.civicrm.org/dev/core/issues/344) Tell a Friend
  mail does not include event title
  ([12699](https://github.com/civicrm/civicrm-core/pull/12699))**

  This fixes a bug where when using the Tell-A-Friend option to send an email
  the title of the event was appearing in the subject of the email, so that the
  title of the event does appear in the subject of the email.

- **Ensure users with the perm "CiviEvent: access CiviEvent " can edit events
  they have created.
  ([12424](https://github.com/civicrm/civicrm-core/pull/12424))**

  This change fixes a bug where users with the permission "CiviEvent: access
  CiviEvent" could create but not edit their events so that they can create and
  edit their events.

- **GL-44 Admin price field options on event info page
  ([11923](https://github.com/civicrm/civicrm-core/pull/11923))**

  This change ensures that on event info pages price set field options with the
  visibility "admin" are only shown to admins.

### CiviMail

- **[dev/mail#20](https://lab.civicrm.org/dev/mail/issues/20) Preview screen
  don't open until recipients list is built on mail compose screen
  ([12509](https://github.com/civicrm/civicrm-core/pull/12509))**

  This change fixes a bug where when drafting a mailing one could not open the
  preview mailing screen until the recipient count query had completed.

- **[dev/core#352](https://lab.civicrm.org/dev/core/issues/352) Ensure that when
  adding recipients of previous mailings that contacts who are being excluded
  are removed ([12712](https://github.com/civicrm/civicrm-core/pull/12712))**

  This change makes sure when using recipients from a previous mailing as the
  recipients of a mailing That any exclusions are respected.

- **[dev/mail#21](https://lab.civicrm.org/dev/mail/issues/21) "Send test email"
  may create duplicate contacts
  ([12599](https://github.com/civicrm/civicrm-core/pull/12599))**

  This change fixes a bug where sending a test email to two contacts seperated
  by a space and a comma would sometimes result in a duplicate contact being
  created.

- **pass mailingJobId to hook_tokenValues
  ([12026](https://github.com/civicrm/civicrm-core/pull/12026))**

  This change ensures the mailingJobId is sent to hook_tokenValues.

### CiviMember

- **BASW-240: 'Network Error' when creating membership type from contact
  membership tab ([12700](https://github.com/civicrm/civicrm-core/pull/12700))**

  This Change fixes a Network Error that was appearing when creating a membership
  type from a contacts membership tab.

### Drupal Integration

- **[dev/core#311](https://lab.civicrm.org/dev/core/issues/311) Upgrading
  multilingual site causes DB Error
  ([12636](https://github.com/civicrm/civicrm-core/pull/12636))**

  This change fixes a bug where upgrading a multilingual drupal site from
  CiviCRM 4.4.7 to 5.4.0 causes a DB error so that one can upgrade a
  multilingual drupal site without a DB error.

### Joomla Integration

- **[dev/joomla#2](https://lab.civicrm.org/dev/joomla/issues/2) Joomla
  cron.php/cli.php fail on Windows server
  ([12692](https://github.com/civicrm/civicrm-core/pull/12692))**

  This fixes a bug where on Joomla sites on Windows cron was failing so that
  cron works for Joomla stes on Windows.

- **Make sure Joomla timezone is set for cron jobs
  ([12609](https://github.com/civicrm/civicrm-core/pull/12609))**

  This change ensures that the CRON job is executed using the same timezone as
  Joomla (and the same timezone that is configured for Joomla/CiviCRM/database
  when running via web). Prior to this change the CRON job was being executed
  with timezone set to UTC.

## <a name="misc"></a>Miscellany

- **Stop passing imProviders & phoneTypes - use CRM_Core_PseudoConstant:getLabel
  ([12608](https://github.com/civicrm/civicrm-core/pull/12608))**

- **Remove unused variables from process_participants job
  ([12621](https://github.com/civicrm/civicrm-core/pull/12621))**

- **Follow up on #12611 - adding in three data-integrity assertions.
  ([12629](https://github.com/civicrm/civicrm-core/pull/12629))**

- **Minor refactor, use sales tax trait to simplify sales tax functions
  ([12594](https://github.com/civicrm/civicrm-core/pull/12594))**

- **Drop custom CSS for Joomla CiviCRM menu so it works with shoreditch theme
  ([12632](https://github.com/civicrm/civicrm-core/pull/12632))**

- **Export minor refactor Move household relationship types to the processor
  ([12579](https://github.com/civicrm/civicrm-core/pull/12579))**

- **Code cleanup on Membership form when freezing fields in a recurring exists
  situation ([12642](https://github.com/civicrm/civicrm-core/pull/12642))**

- **Add test for new rounded money format functions
  ([12689](https://github.com/civicrm/civicrm-core/pull/12689))**

- **Minor comment and typo cleanup
  ([12715](https://github.com/civicrm/civicrm-core/pull/12715))**

- **Towards rationalising settings form & preferences form (partial of 12731)
  ([12732](https://github.com/civicrm/civicrm-core/pull/12732))**  

- **Fix compatibility problem with CRM_Extendedreport_Form_Report_ExtendedReport
  ([12749](https://github.com/civicrm/civicrm-core/pull/12749))**

- **Fix teeny typo
  ([12618](https://github.com/civicrm/civicrm-core/pull/12618))**

- **[PHPUnit test only] Adding in assertions re: Line Item and Contribution
  data-integrity.
  ([12611](https://github.com/civicrm/civicrm-core/pull/12611))**

- **[NFC] comment fixes relating to doc blocks, spelling
  ([12630](https://github.com/civicrm/civicrm-core/pull/12630))**

- **[phpunit test only] - Add one additional data integrity check to ensure that
  after Edit Fin…
  ([12645](https://github.com/civicrm/civicrm-core/pull/12645))**

- **NFC Add/update two comments
  ([12680](https://github.com/civicrm/civicrm-core/pull/12680))**

- **[NFC] Minor function extraction in report class.
  ([12658](https://github.com/civicrm/civicrm-core/pull/12658))**

- **(NFC) Fix incorrect reference of doTransferCheckout() in comments
  ([12720](https://github.com/civicrm/civicrm-core/pull/12720))**

- **NFC cleanup to Membership/Renewal form classes.
  ([12696](https://github.com/civicrm/civicrm-core/pull/12696))**

- **[CRM-21677](https://issues.civicrm.org/jira/browse/CRM-21677) Report
  improvements ([12703](https://github.com/civicrm/civicrm-core/pull/12703) and
  [12698](https://github.com/civicrm/civicrm-core/pull/12698))**

- **Deduplicate setting of mailSent message
  ([12694](https://github.com/civicrm/civicrm-core/pull/12694))**

- **Setting form - function extraction
  ([12744](https://github.com/civicrm/civicrm-core/pull/12744))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Andrew Thompson; Australian Greens -
Seamus Lee; Calbasi - Joan Cervan Andreu; Calibrate - Wouter Hechtermans; Chris
Burgess; Circle Interactive - Dave Jenkins; CiviCoop - Klaas Eikelboom; CiviCRM -
Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CiviFirst - John Kirk;
CompuCorp - Vinu Varshith Sekar; Coop SymbioTIC - Mathieu Lutfy; Fuzion -
Jitendra Purohit; JMA Consulting - Monish Deb; John Kingsnorth; Joinery - Allen
Shaw; Lemniscus - Noah Miller; Lighthouse Design and Consulting - Brian
Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MillerTech - Chamil
Wijesooriya; MJW Consulting - Matthew Wire; PHD Computer Consultants - Chris
Cant; Pradeep Nayak; Progressive Technology Project - Jamie McClelland; Richard
van Oosterhout; Selwyn Tang; Semper IT - Karin Gerritsen; Third Sector Design -
Michael McAndrew; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Fuzion - Peter Davis; JMA Consulting - Joe Murray;
MillerTech - Chamil Wijesooriya; Oxfam Germany - Thomas Schüttler; sleewok;
Squiffle Consulting - Aidan Saunders

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
