@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-association-list: List your ECtrans Associations
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;
use Term::ReadKey;

my %opt = ( gateway => undef, version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  gateway=s
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $associationName = $ARGV[0];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# If no Gateway is specified then use the default Gateway
$opt{gateway} = $controlChannel->getGatewayName()->result if ( not $opt{gateway} );

if ( not($associationName) ) {

	# Get the list of associations
	my $associations = $controlChannel->getAssociationList( $token, $opt{gateway} );

	# Display the information for each association
	foreach $association ( $associations->valueof('//getAssociationListResponse/return') ) {
		printf "%-20s %-20s %-10s %s\n", $association->{name}, $association->{hostName}, ( $association->{active} eq 'true' ? 'active' : 'not-active' ),
		  $association->{comment};
	}
}
else {

	# Get the detail for the specified associationName
	my $association = $controlChannel->getAssociation( $token, $opt{gateway}, $associationName )->valueof('//getAssociationResponse/return');
	print "     Name: " . $association->{name} . "\n";
	print "    Owner: " . $association->{owner} . "\n";
	print "   Active: " . ( $association->{active} eq 'true' ? 'yes' : 'no' ) . "\n";
	print "  Comment: " . $association->{comment} . "\n";
	print "Directory: " . $association->{directory} . "\n";
	print "Host Name: " . $association->{hostName} . "\n";
	print "    Login: " . $association->{login} . "\n";
	print " Protocol: " . $association->{protocol} . "\n";
}

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-association-list - List your ECtrans Associations

=head1 SYNOPSIS

B<ecaccess-association-list -version|-help|-manual>

B<ecaccess-association-list [-debug] [-gateway> I<name>B<] [>I<association-name>B<]>

=head1 DESCRIPTION

List all your ECtrans Associations. When an I<association-name> is specified
then the details for this Association is displayed.

=head1 ARGUMENTS

=over 8

=item I<association-name> (optional)

The name of the Association to retrieve the details.

=back

=head1 OPTIONS

=over 8

=item B<-gateway> I<name>

This is the name of the ECaccess Gateway where the Associations are installed.
It is by default the Gateway you are connected to. In order to get the name
of your current Gateway you can use the B<ecaccess-gateway-name> command. When
using the commands at ECMWF the default Gateway is always "ecaccess.ecmwf.int".

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-association-list>

List all your Associations on your default Gateway.

B<ecaccess-association-list -gateway> I<ecaccess.ecmwf.int> I<ginko>

List the details of the Association I<ginko> on the I<ecaccess.ecmwf.int> Gateway.

=head1 SEE ALSO

B<ecaccess-association-delete>, B<ecaccess-association-get>, B<ecaccess-association-protocol>,
B<ecaccess-association-put> and B<ecaccess>.

=cut

__END__
:endofperl
