/*
// $Id: //open/dev/farrago/src/net/sf/farrago/type/OJTypedClass.java#11 $
// Farrago is an extensible data management system.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.type;

import openjava.mop.*;

import openjava.ptree.*;

import org.eigenbase.reltype.*;


/**
 * OJTypeClass is a synthetic OJClass generated by FarragoTypeFactory as the
 * Java representation of a FarragoType.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/net/sf/farrago/type/OJTypedClass.java#11 $
 */
class OJTypedClass
    extends OJClass
{
    //~ Instance fields --------------------------------------------------------

    /**
     * Wrapped type.
     */
    RelDataType type;

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new OJTypedClass object.
     *
     * @param declarer scope in which synthetic class is declared
     * @param decl synthetic class declaration
     * @param type type being represented
     */
    OJTypedClass(
        OJClass declarer,
        ClassDeclaration decl,
        RelDataType type)
    {
        super(
            declarer.getEnvironment(),
            declarer,
            decl);
        this.type = type;
    }

    //~ Methods ----------------------------------------------------------------

    // NOTE:  we can use type object identity for equals/hashCode because
    // an OJTypeClass instance is only created for canonical type instances
    public boolean equals(Object o)
    {
        return (o instanceof OJTypedClass)
            && (((OJTypedClass) o).type == type);
    }

    // implement Object
    public int hashCode()
    {
        return type.hashCode();
    }
}

// End OJTypedClass.java
