# セキュリティ入門

セキュリティ、認証、認可を扱うには多くの方法があります。

そして、通常、それは複雑で「難しい」トピックです。

多くのフレームワークやシステムでは、セキュリティと認証を処理するだけで、膨大な労力とコードが必要になります（多くの場合、書かれた全コードの50%以上を占めることがあります）。

**FastAPI** は、セキュリティの仕様をすべて勉強して学ぶことなく、標準的な方法で簡単に、迅速に**セキュリティ**を扱うためのツールをいくつか提供します。

しかし、その前に、いくつかの小さな概念を確認しましょう。

## お急ぎですか？

もし、これらの用語に興味がなく、ユーザー名とパスワードに基づく認証でセキュリティを**今すぐ**確保する必要がある場合は、次の章に進んでください。

## OAuth2

OAuth2は、認証と認可を処理するためのいくつかの方法を定義した仕様です。

かなり広範囲な仕様で、いくつかの複雑なユースケースをカバーしています。

これには「サードパーティ」を使用して認証する方法が含まれています。

これが、「Facebook、Google、Twitter、GitHubを使ってログイン」を使用したすべてのシステムの背後で使われている仕組みです。

### OAuth 1

OAuth 1というものもありましたが、これはOAuth2とは全く異なり、通信をどのように暗号化するかという仕様が直接的に含まれており、より複雑なものとなっています。

現在ではあまり普及していませんし、使われてもいません。

OAuth2は、通信を暗号化する方法を指定せず、アプリケーションがHTTPSで提供されることを想定しています。

/// tip | 豆知識

**デプロイ**のセクションでは、TraefikとLet's Encryptを使用して、無料でHTTPSを設定する方法が紹介されています。

///

## OpenID Connect

OpenID Connectは、**OAuth2**をベースにした別の仕様です。

これはOAuth2を拡張したもので、OAuth2ではやや曖昧だった部分を明確にし、より相互運用性を高めようとしたものです。

例として、GoogleのログインはOpenID Connectを使用しています（これはOAuth2がベースになっています）。

しかし、FacebookのログインはOpenID Connectをサポートしていません。OAuth2を独自にアレンジしています。

### OpenID (「OpenID Connect」ではない)

また、「OpenID」という仕様もありました。それは、**OpenID Connect**と同じことを解決しようとしたものですが、OAuth2に基づいているわけではありませんでした。

つまり、完全な追加システムだったのです。

現在ではあまり普及していませんし、使われてもいません。

## OpenAPI

OpenAPI（以前はSwaggerとして知られていました）は、APIを構築するためのオープンな仕様です（現在はLinux Foundationの一部になっています）。

**FastAPI**は、**OpenAPI**をベースにしています。

それが、複数の自動対話型ドキュメント・インターフェースやコード生成などを可能にしているのです。

OpenAPIには、複数のセキュリティ「スキーム」を定義する方法があります。

それらを使用することで、これらの対話型ドキュメントシステムを含む、標準ベースのツールをすべて活用できます。

OpenAPIでは、以下のセキュリティスキームを定義しています:

* `apiKey`: アプリケーション固有のキーで、これらのものから取得できます。
    * クエリパラメータ
    * ヘッダー
    * クッキー
* `http`: 標準的なHTTP認証システムで、これらのものを含みます。
    * `bearer`: ヘッダ `Authorization` の値が `Bearer ` で、トークンが含まれます。これはOAuth2から継承しています。
    * HTTP Basic認証
    * HTTP ダイジェスト認証など
* `oauth2`: OAuth2のセキュリティ処理方法（「フロー」と呼ばれます）のすべて。
    * これらのフローのいくつかは、OAuth 2.0認証プロバイダ（Google、Facebook、Twitter、GitHubなど）を構築するのに適しています。
        * `implicit`
        * `clientCredentials`
        * `authorizationCode`
    * しかし、同じアプリケーション内で認証を直接処理するために完全に機能する特定の「フロー」があります。
        * `password`: 次のいくつかの章では、その例を紹介します。
* `openIdConnect`: OAuth2認証データを自動的に発見する方法を定義できます。
    * この自動検出メカニズムは、OpenID Connectの仕様で定義されているものです。


/// tip | 豆知識

Google、Facebook、Twitter、GitHubなど、他の認証/認可プロバイダを統合することも可能で、比較的簡単です。

最も複雑な問題は、それらのような認証/認可プロバイダを構築することですが、**FastAPI**は、あなたのために重い仕事をこなしながら、それを簡単に行うためのツールを提供します。

///

## **FastAPI** ユーティリティ

FastAPIは `fastapi.security` モジュールの中で、これらのセキュリティスキームごとにいくつかのツールを提供し、これらのセキュリティメカニズムを簡単に使用できるようにします。

次の章では、**FastAPI** が提供するこれらのツールを使って、あなたのAPIにセキュリティを追加する方法について見ていきます。

また、それがどのようにインタラクティブなドキュメントシステムに自動的に統合されるかも見ていきます。
