/**********************************************************************
  Copyright(c) 2024 Intel Corporation All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

#include "aead_test.h"
const struct aead_test sm4_gcm_test_json[] = {
        /* Generated vectors by 3rd party library */
        { 128, 128, 128, 1, "\x22\x04\xb5\x07\x83\x5a\xf3\x3e\xb1\x07\xa2\x71\x31\x4a\x65\x8c",
          "\x25\xc1\xe9\xce\x6e\x61\xe7\xf4\x7c\xcf\x2c\xe7", "",
          "\xf1\x7b\xe7\x3b\x74\x08\x40\x66\xd1\x5f\x0f\x9e\xd6\xcf\x29\xd3",
          "\x27\xd5\x79\x8a\x80\x45\x9e\xee\x00\x56\xb4\x93\xda\x8d\x4d\x3d",
          "\x13\xc4\xe1\xda\x30\xd0\xad\x72\x55\x7c\xb7\xe4\x9f\xad\xd8\xae", 1, 0, 128 },
        { 128, 128, 128, 2, "\x1f\x52\x3c\x62\x96\xcf\xee\x91\x4c\x54\x28\xda\xdd\x6a\xa9\xad",
          "\xe3\x94\xea\x81\x82\x30\x16\x4b\xea\x28\xeb\x3d", "\x3f\x89\x42\x20",
          "\x0f\xd2\x41\x06\x07\x52\x06\xf3\xff\x36\x37\x68\x2e\x59\x33\xfd",
          "\x64\xa7\x9c\x9d\xd4\xeb\xec\x07\x2b\xe3\xd2\x47\xf1\xce\x54\x80",
          "\x06\x70\x8c\x2c\x8a\x52\xd1\x7e\x35\x53\x43\x31\xea\x1a\xe6\xdc", 1, 32, 128 },
        { 128, 128, 128, 3, "\x4f\xae\xca\xe5\x31\xaf\xc0\xed\x41\xf4\xaf\xe4\xb4\x3a\x68\xcd",
          "\x6c\x2a\xf4\x2c\xb0\xca\x71\x5a\x54\xc5\xb5\xfc", "\x36\x94\xf6\x7b\x8a\x58\x4d\xed",
          "\x51\x71\xc0\xf1\x11\xaa\xd7\xe3\xdd\x03\xfa\x65\x3e\xfa\x38\xe6",
          "\xf9\xff\xb9\xbf\x8b\xcb\xba\xd9\x28\x8d\x9e\x7b\x53\x77\x24\x6c",
          "\x51\x72\xbb\x14\xdb\x45\xc8\x1e\x55\x7a\x24\x0d\xa8\x39\x06\x86", 1, 64, 128 },
        { 128, 128, 128, 4, "\x17\xc4\x8b\x7a\x40\x2d\xc0\x4b\x26\xe4\x45\x47\x72\x08\x5f\x20",
          "\xf0\x1e\x3a\xcd\x3b\xfd\x25\x71\xb4\x02\xa9\x5b", "\xd5\x66\x06\x8f\xbc\x11\xb8",
          "\xe9\xec\x00\x14\x57\x99\xb0\xc6\x05\xa0\xfa\x01\x8f\xcf\x82\xd8",
          "\x62\xae\x61\x4d\xcc\xb6\x2f\xce\xe7\x81\x61\x87\xe6\x95\xbc\x39",
          "\xbf\x20\x8d\xda\x95\xc5\x63\xa8\x13\xf2\x4c\xaf\xef\xab\xa1\x38", 1, 56, 128 },
        { 128, 128, 128, 5, "\xc4\xc5\xa7\x1c\xef\xba\x2f\x10\x59\x2e\xd7\x19\x0e\xdf\xe5\xe0",
          "\x40\xa7\x92\xa1\x9b\x29\x15\x3b\x1b\xfc\x29\x6e", "",
          "\x6e\x3d\xce\x73\x73\xe9\x30\xf1\x83\x26\x7e\xeb\x8a\x16\xa5\xb6",
          "\x1c\x97\x37\xc3\x2c\xb6\x6c\x3c\xb1\xbc\x49\x9c\x32\x2b\x95\xca",
          "\x8d\xa3\x12\xa0\x68\xa0\x8c\xd7\xf1\x72\x72\xc0\xe3\x90\x3b\x50", 1, 0, 128 },
        { 128, 128, 128, 6, "\x96\x89\x6f\xae\x4b\x9f\x16\x8a\x61\xa2\xef\x71\x7f\xee\xde\x61",
          "\xad\x94\x73\x37\x14\x2e\x60\x24\x28\xcf\xfd\x5b", "\x1b\xcd",
          "\x64\xdd\x83\x7e\xb7\x4a\x98\x0a\x5e\xe0\xba\x48\xd4\xc7\x91\x86",
          "\x53\xcf\x5f\x9b\x39\x40\x63\x33\x3f\x1b\xbb\xb3\x95\xd1\x3e\xa7",
          "\xd7\x52\x13\x2a\xb7\xe3\x5a\xaf\xf2\x8c\x8a\x0b\xa6\xab\x0c\x8e", 1, 16, 128 },
        { 128, 128, 128, 7, "\x79\x86\x37\x4a\x61\xea\x12\x4b\xa8\x0c\xc4\xf8\xd7\x20\xd6\x71",
          "\x3f\x2b\x3a\x8b\x4d\x61\x84\xe1\x36\xfe\x9e\x35", "\x6c\xac\xc4",
          "\x87\xc8\x7b\xa1\xc2\xf9\x58\x44\x19\x87\xd3\x43\xd9\x1a\x2f\xba",
          "\x36\xe2\x4f\x1d\xa0\xfa\xb8\x6e\x07\xc1\x31\xd7\x0a\x07\x0e\xcb",
          "\xd3\xf0\x78\x87\x90\x80\x52\xcf\x69\xb6\x6d\xd4\x59\x59\x61\x05", 1, 24, 128 },
        { 128, 128, 128, 8, "\x34\xce\x5b\x8d\x57\x57\xd0\x1b\x8b\x96\xd7\x38\x25\x44\x51\xd6",
          "\x0f\xc7\x27\xb8\x5a\x32\x09\x70\xe5\x46\x62\xa0", "\x76\xb3\xad\x45\x78",
          "\xc2\x32\xfa\x82\xe1\x49\xda\x2e\x2c\x9a\xc4\x87\x4c\xdc\x45\x42",
          "\xa3\xac\xf5\xb4\xbe\xf7\x20\xdc\xe9\x20\xf4\x21\x63\xdf\xf4\x8c",
          "\x60\x32\x24\x47\x0b\xae\xba\xfb\x3f\xea\xc3\xf6\x92\x69\x1a\xa7", 1, 40, 128 },
        { 128, 128, 128, 9, "\xc3\xa6\x1f\xff\xe6\x36\x44\x6a\xc5\xc0\x87\xeb\x1a\xe5\x0d\xc4",
          "\xc6\x4d\x6a\xde\x76\xc6\xca\xe0\x57\x5e\x2c\xd0", "\x29",
          "\x3e\x4a\xac\x5b\x89\xec\x2a\x83\x2e\x7e\x93\x2b\x56\xb4\x0b\xce",
          "\x99\xf0\x47\x8e\x8f\x92\x64\x83\xc4\xb6\x01\x2a\x4c\x17\xaa\xb5",
          "\x73\x84\xf9\xb7\xe2\xb9\x04\xc6\x4f\xe5\x5d\x69\x3c\xdd\xfb\xbd", 1, 8, 128 },
        { 128, 128, 128, 10, "\xa8\xbe\xf3\x0b\x73\x1e\xfb\x64\x9a\x28\x58\x55\x2c\xe2\x99\x4c",
          "\x3f\xa7\x24\x18\x2e\xc1\xaf\xae\xe1\xb9\x70\x48", "",
          "\x2b\x85\x74\x6a\xd0\x2b\x6c\x79\x4a\x93\x97\x39\xfc\xa1\x65\x96",
          "\x5a\x3c\xb9\x84\x17\x5a\x2c\xed\x75\xd8\x97\x60\xfa\x9b\xc2\xe8",
          "\xb9\xe3\xd7\x80\x7d\xea\x7a\x09\xdc\x21\x18\x3c\x8f\xfb\xe7\x63", 1, 0, 128 },
        { 128, 128, 128, 11, "\xb9\x03\xef\xa4\xfe\x8d\x97\xe4\x20\xce\xcc\xa0\x97\xbb\x5b\x7d",
          "\xc2\x91\xe7\x14\xad\xbf\x8a\x12\x67\x86\xa5\x61", "\x80\x95",
          "\x1f\x48\x99\x9f\x1c\x6a\x0c\xa0\x5d\x5d\xdc\xf1\x37\xf0\xca\xbe",
          "\x9b\x98\xa0\xd0\x2e\x92\xbe\xe1\x47\x1a\x7c\x3d\xdc\xb2\xbb\xdd",
          "\x6d\x67\xea\x47\xc0\xb3\x9f\x78\x87\xa2\x4a\x92\x71\x40\x8c\x7a", 1, 16, 128 },
        { 128, 128, 128, 12, "\x9a\xc9\x87\xbb\x30\x63\xad\x07\x4a\x1f\x44\x2a\x4f\x69\x29\x9b",
          "\x13\x62\x49\x33\x2f\xa4\xae\x63\x8f\xf8\x0e\xd5", "\x4d\x7c",
          "\x88\x32\xbb\xef\x16\x30\x81\xf7\x4b\x06\x74\xa8\xba\x9c\xac\x2e",
          "\x6b\xd7\x28\xcc\x7f\x92\x05\x96\x73\x89\x4e\x19\x76\xc7\x2f\xc2",
          "\x60\xc7\x19\x00\xbc\x44\xb1\x09\x6d\xe3\x01\xbe\x4f\xc7\x28\x54", 1, 16, 128 },
        { 128, 128, 128, 13, "\xa6\x34\xce\xad\x93\xe5\x7b\x81\xcc\x57\xcb\xab\xd6\x59\xa1\xbe",
          "\x1c\x46\xd6\xda\x0f\x33\x1a\x6a\xec\xdf\xda\xc3",
          "\xb1\xdf\x03\x24\x26\x42\xe3\xfc\x6f",
          "\x32\xdd\x97\x86\x65\xf6\xf4\x70\x5c\xc4\xb4\xc9\xf2\xb3\x78\xe2",
          "\x51\x81\xa8\x79\x1d\x49\x7a\xe9\xa5\xdc\x52\xb8\x77\x54\xb2\x2b",
          "\x3a\xcc\xb0\x81\x45\x24\x30\xc3\xf0\x44\x10\xe4\x1f\x64\x02\x44", 1, 72, 128 },
        { 128, 128, 128, 14, "\x68\x3d\x78\x61\x40\x52\xb7\x38\xf0\x66\x0b\xcf\x85\xf7\x3e\x48",
          "\x39\x67\x9b\xb7\xc1\x79\x21\x88\x6a\x55\x29\xf4", "\xbf\x53\xc8\xd4",
          "\xfb\xa4\xae\xa9\x12\x40\x25\x5e\xab\x5c\x5b\x1a\xe5\x09\x40\x9e",
          "\x0f\x40\xd2\x10\xd3\x70\x11\xde\x13\x53\xae\xf1\xe5\xbc\x6e\xbc",
          "\x0a\x65\x2c\xa1\xcf\x82\x35\x40\x25\xb0\xc7\x9f\x56\x17\xf8\xaf", 1, 32, 128 },
        { 128, 128, 128, 15, "\x15\x37\x42\x3e\x20\xc2\xf7\xd3\x7f\x09\x45\xc4\xce\xab\x69\xc1",
          "\xf3\x6e\x6e\xc3\x53\xbb\xa3\x04\x99\x22\x49\x92", "\x1f\xc5",
          "\x15\x07\x31\x2c\x2b\xa7\xda\x0d\xc2\x2a\x5f\x1b\xbd\x06\xdd\xd9",
          "\x69\xf5\xb9\xaa\xd0\x4f\x1e\x9f\xed\xa3\x23\x5c\x68\x5c\x1d\x47",
          "\x40\x03\x45\x3c\xa1\xc6\x5d\x99\xbf\xca\x4c\x43\xe1\x26\x59\xbd", 1, 16, 128 },
        { 128, 128, 128, 16, "\xc0\x18\xe3\xc9\x85\x55\xea\xa6\x52\xd1\xab\xda\xf2\xf4\x98\x44",
          "\x8a\x42\xaa\xdb\x88\xa8\x4b\xe7\x5d\x27\x46\x5d", "\xa7\xa6\x10\x5f\x8c\xf6",
          "\xa3\xe6\xe1\x8c\x10\xd3\x5d\xaa\x43\x86\xac\xea\xc8\x92\x0d\xf7",
          "\x8f\xef\x8e\x88\xea\x43\xe4\x97\x1b\x81\x69\xc4\xb6\x6f\x0c\x61",
          "\xd3\x2b\xb1\x01\xec\xb8\x93\xa8\xf1\xce\xc8\xc6\x3b\xc4\xe4\x85", 1, 48, 128 },
        { 128, 128, 128, 17, "\x23\x35\x05\xc7\xdb\xd5\xff\x66\xac\xd4\x0f\x8b\x3d\x3f\xab\x38",
          "\xee\x08\x42\xae\x63\x92\x42\x27\x3f\xb0\x1d\x37", "\xda\xcd\x7a\xeb\x44\xef\xc0",
          "\xa9\xce\x34\x42\xde\x8e\x77\x3f\x5c\x18\x23\x68\xab\x42\xfd\x27",
          "\x7f\x82\x23\x7d\xda\x2a\xac\xb9\x3e\x65\x12\x94\x84\xd4\x85\x49",
          "\xa6\xea\xb1\xf6\x09\x15\xc4\x02\xe2\xf0\x8b\x1c\xb6\x38\xc8\x89", 1, 56, 128 },
        { 128, 128, 128, 18, "\xd1\x19\xc4\x11\xa6\xb9\xe1\xe1\xdc\x0a\xbf\xfe\x08\x89\xb5\x7c",
          "\xe7\xc0\x74\x07\xa2\x8c\x45\x06\x40\xec\x58\xd7", "\x57\x77\x33\x81\x09\x32\x78\xca",
          "\x06\x6d\x08\x95\xed\xc9\xcc\xb9\x0c\xa9\x11\x97\x46\x04\x0d\xee",
          "\xf2\xed\x6f\x19\x6d\x2c\x9a\x2a\x5a\x3e\xa4\x61\x11\x6b\xf2\x1e",
          "\x0d\xb0\x26\x2a\xba\x24\x79\x3e\xc6\xb5\xac\x85\xf0\x4a\x01\x3b", 1, 64, 128 },
        { 128, 128, 128, 19, "\x3d\x08\xb4\x71\x44\xb7\x0a\x22\x2f\x6f\x6e\x87\x2a\x37\x52\xbf",
          "\x44\x9a\x2c\x4b\xe2\xe8\x97\x46\xee\x6a\xa3\x4d",
          "\x18\xb0\xb9\x47\xa4\x46\x43\x56\xfd\xe1\x52",
          "\xe8\x85\x83\x35\x68\xb8\x8c\xd5\x17\x56\xe7\xfc\xe1\x3e\x2a\x4a",
          "\x8d\xac\x4a\xa8\x51\x3d\x62\xe8\xad\x28\x8c\xeb\x44\x1e\xbc\x7f",
          "\xa6\x46\x91\x36\x65\x10\x13\xce\xb2\xa9\x56\xa7\xc3\x61\x9d\xfc", 1, 88, 128 },
        { 128, 128, 128, 20, "\x1a\x49\x0f\xb6\xb4\xcf\x31\x7b\x56\xbb\x53\xb6\xf4\x01\x2d\x02",
          "\xbe\x44\xe8\xb9\x6a\xf2\x97\x5d\xb4\xe8\x20\x4c", "\xbb",
          "\xea\x26\x0b\xb2\x26\x87\x7e\xf8\xbc\x9c\x75\x2a\x00\x4f\x5b\xa4",
          "\x87\x49\xaa\xc8\xf8\x91\x9b\x61\xb9\xe9\xe0\x04\xff\x2b\xb8\x2d",
          "\x7d\xf5\xc3\x5c\x0e\x4b\x49\x12\x64\x88\x4b\x98\xd9\x89\xdb\xf4", 1, 8, 128 },
        { 128, 128, 128, 21, "\x27\x9c\xc0\x34\x84\x3b\x74\xc0\xc8\x4c\x25\xaf\x0f\xa5\x57\x73",
          "\xb8\x95\xd5\x73\x04\x18\x40\x21\xdc\x79\x66\x64",
          "\x33\x4f\xd9\x0d\x23\x4e\x7b\x91\x3a\x5c\x34",
          "\x3c\x63\x62\x21\x31\x68\x25\xca\xca\xa7\xc7\xaa\x7c\x34\xf9\xce",
          "\x72\x8d\x1d\x26\x3f\x80\x70\xf4\xe4\x4e\x2a\xab\x03\xfe\x38\x61",
          "\x41\xe7\xbb\x0c\x32\x82\x0f\xce\x78\xf0\xe3\xfd\xbb\x3e\xc5\xc1", 1, 88, 128 },
        { 128, 128, 128, 22, "\x1d\xfd\x14\xa9\x70\x0b\xe9\xff\x7c\xad\x73\xb6\x62\x4a\xd2\x87",
          "\xa6\x05\xd4\x91\x76\xe9\xc7\x1b\x50\xea\x2c\xd6",
          "\xa2\x48\x85\x67\x98\xa9\xdd\x2e\x3d",
          "\x26\xee\x9d\xc6\xd0\xf4\x2b\xd5\x75\x45\x28\x17\x43\x17\x00\xf4",
          "\x8a\xfe\x33\x43\xf5\xab\x99\x35\x9b\xed\xdf\x0d\x39\xde\xa2\x37",
          "\xfb\x6f\x3a\xf6\xb1\x79\xd2\x95\xee\x7a\xb1\x3a\xf8\xf9\xf3\x02", 1, 72, 128 },
        { 128, 128, 128, 23, "\xfc\x5f\xab\xb1\x3c\x7d\x51\xdb\xd6\x3c\x29\x84\x99\xe3\xf1\x64",
          "\x03\x7f\x97\x67\x43\x30\x2c\x2f\x75\x46\x40\x3e", "",
          "\x5e\x78\xaa\x33\x42\x2c\xdf\xe2\xa4\xba\xb9\x13\x44\x8d\xa9\x69",
          "\xbb\xfa\x65\x9c\xc5\xb9\x33\xe3\x6c\x44\xa1\x24\x28\x8b\xe9\xd4",
          "\x1d\xa3\x41\x8d\x48\xe2\xa0\x99\x10\xa5\x05\xd7\x58\xbb\x45\xa3", 1, 0, 128 },
        { 128, 128, 128, 24, "\x6e\x1e\xa7\x86\x2d\x34\x04\xa7\xe8\x08\x76\xd1\x3e\x99\x67\xa9",
          "\x50\x7a\x91\xe6\x13\x77\x5c\x0d\x63\xd1\x07\x9d",
          "\xdb\xf1\x58\xd9\x12\x06\xb1\x77\xf5\xa1",
          "\xb5\x6c\x17\x20\x59\xf1\x46\xb7\xfe\xb7\x61\x65\x85\xd2\xc9\x68",
          "\xa3\xae\xf5\x2b\x4a\x19\x2f\xa6\xcf\x95\x8a\x5c\x1c\xac\x72\xa4",
          "\x5e\x9d\xa0\x52\x06\x33\x75\x10\xbf\xec\xe2\xe0\x0e\xa2\xc7\xab", 1, 80, 128 },
        { 128, 128, 128, 25, "\xc3\xda\x2b\x8e\x79\x6c\xd9\xfc\x05\x28\x94\x0d\x83\xd9\xe2\x78",
          "\x24\xa8\x7a\x26\x24\x5c\x0d\x23\xa5\xc5\x83\x1d", "\x06\xa0",
          "\xaf\xbe\x9a\xe5\x11\xb9\x8f\xec\x5d\x0e\x0b\x83\xb3\x32\x41\x99",
          "\x6d\x58\xf7\x6f\xdb\x27\x06\x1a\x4b\xee\xe6\xe8\x60\xe3\x10\x26",
          "\x49\xc7\x16\x70\xa3\x5b\xe8\x29\x66\x78\xb4\x45\x29\x25\x96\x89", 1, 16, 128 },
        { 128, 128, 128, 26, "\xe3\x0a\xfd\xb4\x87\x6c\x2f\x13\x80\x62\x32\xfb\xd0\x61\xfe\x3e",
          "\xe7\x13\x76\x61\x90\xe4\x7f\xdf\x42\x72\xe1\x7d", "\x63\xbc",
          "\x44\x18\x41\x86\x7d\x0a\xba\x03\xe7\x28\xc3\x9b\xc6\x1f\x6f\xa3",
          "\x39\x09\x7c\x69\xca\xba\xc0\xf7\x29\x4a\x16\xf8\x47\xbd\xe7\xcb",
          "\xb5\x1b\xd7\x3d\x3b\xf4\x8d\xde\x0c\xc8\x2a\x66\x2f\x96\xb2\x2e", 1, 16, 128 },
        { 128, 128, 128, 27, "\x92\xb9\x0d\x08\x3b\xbd\x5e\xe1\xf0\x67\xd8\xef\xa5\xab\x1c\x9b",
          "\x85\x58\x59\x01\x2d\xf1\x10\x22\xbf\xd0\xa4\x05", "\x2e\x42",
          "\x13\xf3\x1f\x10\xec\x42\x52\x8f\xe2\x17\x5d\xd1\x99\xdb\x9c\xbf",
          "\x66\x0d\x6e\x3f\x83\xfb\x3d\x5f\x4b\xa0\x90\xec\xec\x27\xd0\x33",
          "\xf5\x97\x38\x65\xd6\x0b\xaf\x25\x6a\x9f\x97\x36\xe1\xe0\x2c\x59", 1, 16, 128 },
        { 128, 128, 128, 28, "\x0f\xb9\x40\xbd\xb9\x30\x9c\x27\x5f\x59\x18\x1b\x72\xf3\x6e\xac",
          "\x00\xa7\xa4\xe1\xe7\xe4\xc6\xde\x3a\x48\xe9\x64",
          "\x97\x4d\x72\x59\x24\x79\x8a\x33\xb3\x46",
          "\xd0\x19\xba\x45\x82\x6b\x16\xa9\x29\xcf\xcb\xf9\x51\x21\xab\x47",
          "\xcf\xbd\x45\x38\x8e\x76\x84\x07\x2a\x3e\x7a\xe0\x6f\xdd\x4c\x89",
          "\x58\x37\xa8\xae\xcb\x12\xb0\xec\x42\x88\x06\xaf\xc0\x31\xda\x60", 1, 80, 128 },
        { 128, 128, 128, 29, "\xfa\x6a\x4e\x90\xb3\x5e\x25\xe4\x26\xcc\xad\x7f\xd1\xa3\x7e\xa8",
          "\x4e\x43\xa5\x65\xd8\xb8\xb2\xd0\x45\x35\xd8\xfe", "\x06\xfd\x44\x16",
          "\x9e\x56\x05\x7e\x1f\xe3\xc8\xc3\x70\x80\xd5\xf9\xdc\x32\x70\xa0",
          "\x80\x09\x44\xeb\xdf\x28\xdd\x7c\x95\x69\x8f\x2b\xf5\xdf\x4e\xca",
          "\x9b\x1f\xa0\x1e\xbd\x08\xa6\x7b\xfd\x77\xf4\x02\xc0\x08\xeb\x5a", 1, 32, 128 },
        { 128, 128, 128, 30, "\xfd\x9a\x59\x92\x26\x27\xc8\x57\x44\x80\xa0\x05\x42\xca\x79\x17",
          "\x9e\x50\xa2\x04\x3c\x13\x17\xde\xa4\xc3\x68\x4f", "",
          "\xcb\xd5\x23\x31\x76\x92\x77\x17\x7a\xdc\x5a\x32\xf5\xb2\x96\x5b",
          "\x88\x13\x91\x40\x77\x3a\xe4\x08\x82\x83\x07\x92\xa3\x55\xe0\x83",
          "\xee\x4f\x15\x7f\x00\xb8\xb5\xf9\x0f\xc1\x75\xaf\x96\x1a\x76\xa4", 1, 0, 128 },
        { 128, 128, 128, 31, "\x1c\x2c\x0e\x54\xb3\x09\x4e\xc2\x7a\x15\x15\xf0\xf6\xfe\x69\xed",
          "\xae\x07\xd7\xe5\x77\xcd\xb9\x5a\x32\x57\x27\x21",
          "\x1d\x1e\xd8\x7c\x66\xb0\x27\x47\x5c\x54\xc2",
          "\x78\xb6\xc3\xd2\x78\x0d\x6a\x0a\x64\xfc\xb6\xc7\xc7\x0c\xb8\x4d",
          "\xad\x2c\x63\xc8\x89\x23\x65\xcc\x4f\x8b\x52\x16\x76\x0d\x32\x26",
          "\xa6\x41\x1a\x5e\x6c\xc2\x67\x5d\xea\x76\xfd\x2c\x44\x28\xaf\xaa", 1, 88, 128 },
        { 128, 128, 128, 32, "\xf2\xa0\xdb\x50\x31\xdf\xd0\x5e\xc7\x24\xa2\x86\x6e\xd8\xac\x2a",
          "\x40\xf6\x0b\x39\xbb\x43\xda\x16\xbb\xac\x08\xcf", "\x50\xad\x44",
          "\xb5\x0f\x19\x37\x04\xd9\x31\x23\x00\xc2\x4d\x18\xcf\x11\x34\xb0",
          "\xea\xf6\xb4\x8c\x81\x2d\x76\x35\xa1\x8d\x05\x42\x71\xa5\x17\x7e",
          "\xaa\xdf\xf9\x06\x2c\xfd\xe4\x2f\x71\x2c\xb4\x19\x32\x1f\xba\xb6", 1, 24, 128 },
        { 128, 128, 128, 33, "\x50\x51\x1d\x1d\xde\xe8\x88\x41\x36\x0b\xf8\x56\x9e\x29\x81\x71",
          "\xc9\x76\x6f\x12\xa1\x74\x75\x44\xa6\x9d\xd2\x64", "",
          "\xee\x0c\x50\xa8\x1f\x11\xd9\xec\x7c\x5b\x00\xd3\x3d\xa7\x64\x0e",
          "\xff\x46\xd6\xe0\xe0\x38\x87\xe8\x24\x9a\x46\x06\xff\xe7\x7e\x39",
          "\x40\x83\x8a\x5f\x5a\xc4\x54\x04\xc1\x25\x15\xf1\x3f\x44\x0f\x36", 1, 0, 128 },
        { 128, 128, 128, 34, "\x88\xd4\xc4\xa2\x9d\x17\x8a\x66\x3d\x06\xf4\xea\x16\x7e\x0a\x78",
          "\x77\x2c\xf3\xe4\x4b\xb8\x0c\x3a\xb9\x23\xa6\xc3", "\xac\xdb\x6f\x5c\x8d\x37\xbd\x84",
          "\x0b\x31\x51\x5d\x4f\x33\x8c\x0e\x7e\xc6\x12\x36\x38\xb2\x95\xaa",
          "\x3d\xc6\xb9\x23\x46\x6f\x9b\x0a\x72\x60\xed\x9f\x88\x7b\x84\xbc",
          "\x1a\x2e\x69\xa6\xad\x72\xa0\x03\xd3\xa8\xf9\xcd\xc0\xf0\x3e\x3c", 1, 64, 128 },
        { 128, 128, 128, 35, "\xce\x5c\x04\xce\x0a\xd6\xa9\x23\xf5\xef\xc7\x99\x8e\x95\xcd\xb7",
          "\x78\x16\x7c\x09\xd5\xb2\x18\x8b\x18\x7b\x15\x1e", "\x6a",
          "\x76\x1e\x39\x16\xa9\x8e\xe4\x26\x27\x01\xf8\x43\x7a\x82\x64\xac",
          "\x88\xbc\xbd\x4b\x65\x7d\x3e\xad\x5b\x16\x88\x3e\x7d\x36\x32\xd6",
          "\x5e\x98\xfd\xc5\x41\x4a\x30\x41\x4e\x3a\xef\xd9\x61\x96\x17\x25", 1, 8, 128 },
        { 128, 128, 128, 36, "\x5a\xeb\xdf\x7a\x1c\xce\x62\xe8\x64\xb9\xe4\x5f\x50\x5a\x9f\x69",
          "\x47\x18\x95\x84\xa1\xb8\xf6\x26\x30\x1c\x67\x4e", "\x04\x55",
          "\x62\x09\x27\x57\xbd\xdb\x95\x9c\xdd\x19\x21\x3a\xc2\x6c\xfd\x11",
          "\xbd\xe7\x03\x0a\x2e\x4b\x5f\xfc\x2c\xb3\x30\xb3\x7a\x5e\xf1\x0b",
          "\x20\xd4\xcd\x04\xec\xc2\x13\xba\xe0\x4e\x8b\xf4\xab\x0d\xee\x48", 1, 16, 128 },
        { 128, 128, 128, 37, "\x71\x80\xb4\xbc\xb6\x75\xa8\xe4\x9c\x99\x82\x7a\x93\xb0\x10\x53",
          "\x43\xf7\x6b\x74\xc2\x8f\xb3\xc0\x28\x44\xa1\x17", "\x99\xd6\x1e",
          "\x2c\xe4\xd3\x04\xb6\xae\x05\x90\x05\x32\xdf\x57\xec\xc0\x67\xd6",
          "\x88\xea\xb5\x77\xb3\x15\x3a\xfe\xfd\x60\xb8\xee\xf7\x82\x45\xb1",
          "\x2c\xe9\x29\x4f\x9c\x85\x11\xe0\xbd\xa8\xaa\x16\xb7\xb9\xc7\x76", 1, 24, 128 },
        { 128, 128, 128, 38, "\xcc\x1f\x82\x11\xa0\x2e\xfd\xdb\x6e\x7e\x66\x1c\x4b\xd1\x9e\xf5",
          "\x4f\xb5\x58\x56\xd1\x51\xc3\x87\xb3\x1c\x20\x47", "\xb9\x6e\xf0\xb4",
          "\xc1\x69\xae\xb1\x24\xf3\x2b\xb9\x73\x0b\x97\x25\xc6\x7d\x94\x56",
          "\x8b\xeb\xf7\x25\xa6\xcc\x90\x1a\xa5\xd2\x6c\xfa\x58\xe9\xf0\x1e",
          "\x17\xdf\x4c\xf8\xd8\x65\xc0\x0a\xda\xab\x7b\x2b\x23\xe1\xc3\x9d", 1, 32, 128 },
        { 128, 128, 128, 39, "\x6f\x10\x2c\x7c\x75\x35\x16\x87\xdb\x0b\x41\xb1\xbc\xb2\x71\xd2",
          "\x67\x37\x39\x38\x10\x1f\xe9\xa8\xe4\x48\xbd\xaa", "\x38\x93\xe5\x79\x63\x2a\x09",
          "\x62\x76\xcf\x57\xba\x07\xff\xff\x37\xa4\xcb\xdc\xca\xc4\x12\x8e",
          "\xb4\xaf\x9f\x46\xf3\x17\xca\xe2\x9b\x0c\xee\x57\xeb\xe0\x37\x68",
          "\x73\xfe\xff\x7b\x78\xcc\x37\x73\x29\x9a\x50\xf8\xac\x08\x53\x1c", 1, 56, 128 },
        { 128, 128, 128, 40, "\x1c\x30\x13\x60\xfc\xa6\xca\x8b\x53\x26\x09\xb9\xb1\x0a\x3e\x4c",
          "\x60\x5b\xd6\xab\xcc\x1a\x7d\x17\xa8\x46\x82\x26", "\xd3",
          "\x1b\xef\x29\xc5\xf4\x71\xac\xfb\x7f\x8b\x65\x6d\xf0\xae\x1c\x83\xd0\x88\x72\x90\xc4\xb5"
          "\x60\x94\xf7\xcc\xd3\x8f\x23\x08\xe5\x25",
          "\xf0\xd5\xc3\x50\xdf\xae\x7b\x0c\xd5\xba\xe1\x87\x8f\x6f\xff\x5c\xaa\x83\x83\x1f\x54\x04"
          "\x99\xe1\x48\xb1\xf8\xa0\x98\xec\x37\x7c",
          "\xc7\x76\x30\x0c\x09\xc3\x87\x61\x87\x9c\xca\xad\xe0\xcb\xd5\xc7", 1, 8, 256 },
        { 128, 128, 128, 41, "\xc3\x8b\x4e\x8d\x2b\xa1\x65\x71\xf9\x1e\xb3\xc5\x53\xd7\x91\x83",
          "\x14\x2d\xed\xc2\x47\xd3\xaf\xa7\xa8\x0f\x56\xca", "\xa6\x31",
          "\x31\xc7\xa4\x86\x63\x3a\xa3\x28\xb1\xc1\xb2\xb1\x3e\xe0\x7d\xfc",
          "\xbb\x68\xb6\x07\xc1\x32\x03\x07\x3b\x79\xb8\xb9\x50\xca\x2a\x20",
          "\x8e\x60\xee\xde\x7c\xd9\xc3\xd3\xcb\x5d\xd8\xa3\x35\x30\xa5\x9b", 1, 16, 128 },
        { 128, 128, 128, 42, "\x1f\x03\x06\x67\xc9\x2b\x3d\x98\xd5\xff\xe6\xdb\x8b\x70\x0f\xaa",
          "\xe8\x4b\xb8\x7e\x45\x5f\x28\xfe\x44\xc4\x16\xf9", "\xeb\x3a\x42\x8e\xc3\x90\x79\xb0",
          "\x23\x3b\xac\x9f\x3d\x2a\xd6\x38\x52\x9a\xfc\x38\x18\x0f\x62\x4d",
          "\xa8\xfc\xe5\x27\x3d\x35\xfe\xef\x48\x5a\x15\x05\xb3\xab\x9b\xbb",
          "\xd6\x02\xec\x01\xea\xb5\xab\x71\xe1\xa6\x12\xb2\x8c\xd9\x89\xac", 1, 64, 128 },
        { 128, 128, 128, 43, "\x06\x25\x5a\x31\x2a\x5a\xc3\x09\x08\x35\x2d\x80\x8d\xbd\x89\xe8",
          "\xab\xd0\x13\xbf\x75\x6b\x41\x90\xaa\x4c\xa0\x99",
          "\xd9\x23\x41\xec\xb1\x28\xe5\x67\xc7",
          "\xb9\xa9\xe3\x81\x3c\x4c\xc9\xec\xac\x10\x3f\xcb\x35\x46\x98\xf7",
          "\xcb\x96\xce\xfb\x9a\xb6\x94\x6e\x03\x31\x73\x45\x4f\x46\x03\xad",
          "\x75\x2c\x31\x4f\x71\x4a\x93\xee\x0f\x2a\xb3\x7e\xc7\x4e\x8a\x3c", 1, 72, 128 },
        { 128, 128, 128, 44, "\x80\x8d\x0b\x7e\x46\x5e\x00\xa0\x70\x50\xac\x7c\x92\x72\x45\xb7",
          "\xb1\x68\x09\xae\x25\x11\x28\x03\x0e\x7c\x38\xbd", "\xd3\xc3\x9a\x63\x69",
          "\xf5\x09\x3e\xe3\x90\xa5\x3a\x1c\xe8\x08\x28\x56\xb8\xbe\xe1\x38",
          "\x26\x5c\xb5\xcb\xc3\x4e\x46\xe9\xd0\x5d\x71\xcd\x61\x0a\x9c\x46",
          "\x3f\x05\xa7\x4f\xbc\x6c\x71\x11\x5d\x1d\xf1\xa2\xd5\xca\x80\xe3", 1, 40, 128 },
        { 128, 128, 128, 45, "\x06\x03\x4a\xbd\xac\xdb\x23\x79\x71\x6f\x4c\x0d\xfa\xe5\xa4\x2f",
          "\x77\x51\xa3\x86\xe6\x0b\xbf\xf6\xd9\x52\x3e\xa0",
          "\x96\xff\xf2\x53\x0a\xec\xc8\x26\xba",
          "\x62\x14\x74\x87\x16\xdd\x34\x93\x60\x8e\xb7\xb6\x6b\x44\xa6\x07",
          "\x1e\x34\x29\xd8\x52\x8a\xf4\x57\xfb\xeb\xf3\x94\x36\x72\x95\xa4",
          "\x3a\x98\xc0\xb2\x2e\x6a\xeb\xd8\xfa\xab\x0b\x47\x16\xa3\xd8\x9c", 1, 72, 128 },
        { 128, 128, 128, 46, "\x8b\xa2\x1e\xcf\x2e\xa3\x53\xd8\x6b\x4c\xaf\xa6\xe4\xfc\x01\xc0",
          "\xe0\xe2\x74\x53\xca\x06\xa0\x88\xbb\xf0\x6e\x25",
          "\xd3\x1a\x49\x52\xdb\x1f\x49\x6c\xfa",
          "\x49\x10\x5c\x3f\x30\x8f\xfc\x72\xd1\xcc\xc5\xcc\x58\x36\x60\xbf",
          "\xa1\x1f\xfd\x2f\xf1\xdc\x1e\xf8\x44\x04\x58\x74\xe7\xe0\x3f\xa8",
          "\xda\xb0\xd0\x63\x6f\x0a\x17\xd9\xfd\x66\x8a\x00\xa6\x97\x04\xce", 1, 72, 128 },
        { 128, 128, 128, 47, "\x3d\xe4\xb4\x8b\x95\xb7\x1e\x9c\xb0\x98\x41\xe2\x8c\xd7\x37\x76",
          "\xbc\x88\x72\x7f\xdd\xda\x28\xda\x21\x1a\x1d\x30",
          "\x3b\x74\xc1\xca\x69\xfb\xcf\x06\xd0",
          "\x04\x76\xe2\xc4\x6d\x58\x50\x9e\x67\x3f\x60\x56\x4a\x26\x36\x20",
          "\x34\xa3\xf5\x38\x85\xcc\xbd\x86\x72\xe6\x3e\x3c\x60\xd0\x62\x95",
          "\xc1\x15\x22\x54\x26\x26\xd8\x3d\x0b\xb6\x7a\x2a\xf3\x01\x5d\xa2", 1, 72, 128 },
        { 128, 128, 128, 48, "\xce\xc6\x66\x4b\xc8\x55\x54\xd7\xbf\xe3\x62\xa9\xb3\x3e\xb1\x19",
          "\x09\x5d\x8c\x7a\xca\xfd\xba\x52\x5b\x78\xa1\x22",
          "\x0e\xee\x88\x0f\x25\x2f\x08\x8a\x4a",
          "\x86\xca\x33\x31\xb8\x0b\xef\x64\x62\xa2\xdf\xcd\x06\x4a\xe3\xf3",
          "\x51\x48\x26\xc4\xb4\xe4\x8d\x73\xc0\x99\x5e\x25\x2e\x39\x57\x99",
          "\x6e\x28\x04\x6b\xb5\x62\x32\x0a\x1f\x20\xc9\x4d\x06\x74\xca\xad", 1, 72, 128 },
        { 128, 128, 128, 49, "\xfe\x5a\xc6\x67\x81\xe3\xc0\xf0\x07\x5a\x43\x09\x57\x5b\x5b\x02",
          "\xa0\xa1\xf6\xe7\xd6\x42\xe8\x4d\xee\x67\xf7\x24",
          "\x6d\xab\x92\x6c\x47\x4b\x0f\xb1\xa8\xa7\x1b\x0c",
          "\x76\x8a\x66\xf0\x06\x5d\x8a\x7e\x84\x6b\x88\xac\x46\xb5\x8e\x05",
          "\x4a\x30\x1f\xba\x1c\x51\x15\xb9\xd8\xde\x36\xc1\xc8\x3d\x4a\x46",
          "\x74\x71\xc9\xf2\x68\x88\x67\x0b\x8c\xd7\x19\x00\xe3\x00\x7d\xdb", 1, 96, 128 },
        { 128, 128, 128, 50, "\xd6\x68\x57\x2f\x4f\xd8\x81\x60\x09\x84\xb4\xd0\xeb\xcb\x01\xb1",
          "\x94\xb4\x42\x48\x42\xea\x06\x88\x3e\x8e\xd8\x30", "\x16\x54\x0c\x42\x11",
          "\x26\xc6\xff\xc0\x36\xdb\xd4\x4d\xe1\x90\xca\x96\x5e\x33\x85\x4f",
          "\xfe\x04\xd4\x73\xe0\xd7\xed\x18\x07\x1e\x3f\xfb\x4c\x8e\x2d\xcd",
          "\x09\x1e\xf0\x51\x4b\x76\x47\xa0\x4d\x10\xee\x6f\x82\x78\xed\xeb", 1, 40, 128 },
        { 128, 128, 128, 51, "\x22\x8f\x1a\xa3\x49\xb9\xaa\x25\xf2\x3c\x7b\xcf\x46\x6f\x9f\xa7",
          "\xdf\x72\xe7\xbb\x8c\x33\x0f\x99\x14\x4d\x68\x37", "\x98\xd2\xa2\x82\x3f\x0a",
          "\x31\xd0\x36\xee\xad\xee\xce\x1b\x36\x96\x1c\x96\x7b\xce\x5a\xf6",
          "\xe4\xba\x1e\xc7\x06\xa3\xfa\xe0\x8b\xe9\xe5\xa6\x76\xe3\xf4\x4c",
          "\x73\xff\xb3\x1f\x58\x0b\x10\xae\xf1\x73\x7f\xb6\x0f\xf8\x65\x50", 1, 48, 128 },
        { 128, 128, 128, 52, "\x91\x7b\x6d\x4e\x4c\x48\x30\xc7\x93\x64\xac\x4c\xac\xb8\xc6\xc3",
          "\xf0\x0f\x43\xde\xe2\xb3\x9d\x33\x85\xf4\x62\xaf",
          "\xbb\xec\x4a\x33\xad\x6d\x2b\xb0\xe1\xd1",
          "\x25\x7e\x7d\xd1\xf3\xa5\xd6\x4d\xac\xfc\xaa\x02\xe8\x93\xca\x8d",
          "\x86\xfa\x51\x1d\x49\xe4\x3d\xfa\x43\x88\x2d\xdd\x34\x6d\x3c\x2c",
          "\x87\x45\xda\xd0\x02\x6b\x0a\x52\x1b\xaf\x79\xf2\xab\xe2\x1b\x7c", 1, 80, 128 },
        { 128, 128, 128, 53, "\x2c\xe8\xcf\x7b\x35\x7e\x4d\xe7\xbc\x17\xc8\xc7\xb4\x8a\x71\x6b",
          "\xb6\x7b\x39\x6a\xbd\x38\x1a\x53\x6a\xda\x22\x47", "",
          "\x42\x71\x6b\x4d\x29\xcc\x18\x76\xe3\xb4\x8f\x96\x49\xb5\x66\x74",
          "\xd7\xd3\x6c\xc4\x81\x64\x15\x84\xd5\x00\x42\xc3\xdc\x1c\xe5\x0c",
          "\x2a\x1e\x5d\xc6\xe0\xb4\x81\x1b\xea\xcd\x39\xe0\x62\x0c\xcb\x2f", 1, 0, 128 },
        { 128, 128, 128, 54, "\x6d\x60\xd9\xef\x84\x44\xef\x4a\xc9\x73\x46\xa5\xdf\xed\x38\x43",
          "\xa8\x13\xc7\xc5\x84\x69\xaa\xa2\xb0\xf3\x0d\x31", "\x2c\x1a\x69",
          "\x9d\x44\x3d\xc4\xa1\x74\x60\x9f\x44\xb5\x61\x84\xc4\xe7\x1b\xed",
          "\x47\xfc\xb5\xb6\x8e\x11\x02\xb1\xb5\xa7\x91\xa0\xfd\x71\xc2\x74",
          "\x9f\xa1\xcc\x32\x86\x99\x71\x57\xc3\xb7\xb4\x1a\x52\x9a\x7f\xea", 1, 24, 128 },
        { 128, 128, 128, 55, "\xec\x90\x95\x52\xdf\x00\x60\x02\x48\xe1\x8b\x36\x80\xc5\xc3\x22",
          "\x25\xc6\x16\x0b\x9b\x28\x52\x93\x97\x9a\x12\xd4",
          "\x1e\x6c\x8e\xd3\x3c\x4d\x6b\xe1\x08\xdb\xf1\xa7",
          "\x8f\xe7\x23\x01\x6d\xf2\x6d\x3d\xcd\x44\x3e\x0d\xf8\xe4\x9d\x5f",
          "\x79\xd9\xa4\x02\x63\xa0\xd4\x5b\xd6\x10\x21\xb7\xde\x63\x56\x04",
          "\xbc\x5a\xc1\xa2\xbe\xa1\x52\xdc\x44\xb9\x14\x24\x66\x06\x74\x3a", 1, 96, 128 },
        { 128, 128, 128, 56, "\x05\xea\x37\xa0\x52\x48\x3b\x97\x2b\x33\x81\xe8\xf2\x6f\xf3\xed",
          "\x85\x3a\xf6\x43\x43\x84\x0e\x38\x71\xc2\x03\x57",
          "\x66\x68\x99\xf8\xb7\xaf\xbf\xaf\x00\x82\x6a\x92",
          "\x8c\x7b\x18\x26\x37\xf7\xaa\x93\xc6\xec\xd9\x69\x39\xd5\x61\x78",
          "\x10\x87\xed\xea\x57\xed\x30\x6d\xe1\x32\x16\x36\xbe\x78\x02\x89",
          "\x5c\xfb\x7e\x08\x6a\x62\x8b\x5d\x3b\x81\x2e\xc3\xf6\x8c\xe8\x40", 1, 96, 128 },
        { 128, 128, 128, 57, "\x21\xe5\xd2\xbe\x88\xe0\x96\xb2\x14\xa2\xfd\xb9\x34\xbb\x62\xda",
          "\x82\xdf\x23\xf8\xc4\x90\x10\x5b\x6e\x61\xa9\x33",
          "\x78\x22\xfe\xb6\x5a\x4a\xe6\xdd\x8c\xdd",
          "\x4d\x2b\x34\xc9\x23\x2b\x0b\x20\x12\x2b\x7c\x4b\x2d\x1b\x83\x67",
          "\x02\xda\xc0\x41\x7f\x7d\xe3\x2e\xce\x56\xfd\x0f\x84\x5b\x73\x25",
          "\xd9\x7f\x3d\x52\x9e\x01\x21\x20\xbd\x06\xd1\x69\xfd\xa6\x47\x5d", 1, 80, 128 },
        { 128, 128, 128, 58, "\xcf\xb6\x5b\xb3\x1b\x52\xf7\x83\x48\x08\x13\x2f\xae\x63\xbc\x0e",
          "\x1f\x2d\x14\x86\x62\x57\x74\x2a\x30\xe7\x7e\xc7", "\x9a\x26",
          "\x67\x21\x5b\x18\xf8\x66\x6b\xa4\xca\xb3\x92\x61\x92\x9d\xb0\xb1",
          "\xdb\x99\x97\x6c\x58\x6a\xf2\x46\x3b\x8a\x2b\x12\x74\xd1\xcd\x3b",
          "\x2c\x6c\x4c\x99\x45\x93\xb4\x71\x48\x14\x50\xf5\x5c\xbd\xc4\xa4", 1, 16, 128 },
        { 128, 128, 128, 59, "\xf5\x1b\xed\x58\x75\x4f\x12\xc1\xdd\x4b\xc6\x40\xfd\x0f\xd8\x11",
          "\xee\x9e\xd8\x64\xd9\x54\xf4\xc0\x24\xa6\x95\xec", "\x14",
          "\xef\xd7\xf7\xe8\x23\x25\x59\xa1\xbd\x1e\x89\x45\x64\x32\xf7\x92",
          "\x19\x5d\x74\x10\xac\xe9\xd2\xf2\xf5\xb8\x01\x45\x60\xe8\x3d\x38",
          "\xd9\xe1\x68\x20\x9e\x03\xdf\x2a\x02\x29\x2a\x33\xd8\x7c\x4a\x7e", 1, 8, 128 },
        { 128, 128, 128, 60, "\x86\x80\xf6\xb7\x5e\xf1\x97\x07\xfa\xfd\x1f\x2c\xa3\x58\x03\xc8",
          "\xca\x40\xb5\x1f\x84\x08\x73\xec\xfd\xd7\x66\x37",
          "\x43\x9b\x71\x83\x05\x8c\x06\x51\xad\xc5",
          "\x25\xa5\x84\x87\x6f\x1e\x3a\xf9\xd9\xcc\x23\x6f\x77\x2c\x02\x52",
          "\x5a\x30\xd0\xcb\x59\x89\x30\xdc\x03\x82\x68\x90\xcd\xb7\x3a\xce",
          "\x3d\xc0\xef\x21\xff\xab\x58\x32\x06\xd2\x33\xb9\x15\x96\x61\x9c", 1, 80, 128 },
        { 128, 128, 128, 61, "\xa1\xfa\x91\x81\x50\x90\xe9\x7d\xb8\x3c\x17\x43\x23\x88\x73\xb2",
          "\x23\xc6\x2a\x04\x05\xb4\xaa\xdc\x44\x22\x49\x85", "\x40\x8c\x52\x73\x77\xde\x62\x43",
          "\x47\xad\x91\x06\x27\x19\x1d\x9e\x33\x33\x8f\x9a\x03\x2e\x22\xc5",
          "\xa4\xbd\x60\x97\x66\x80\x45\x2f\x61\x47\x18\x5b\x39\x75\xb6\x4c",
          "\xf6\xc6\x0e\x02\x9b\x3b\x42\x11\x37\x05\xf1\xbd\x80\x94\x1e\x3a", 1, 64, 128 },
        { 128, 128, 128, 62, "\x73\xe9\xc8\x36\xac\x69\x36\x7d\x62\x35\x7c\x4d\x0e\x7a\xec\xa9",
          "\x02\x8a\x37\x78\x65\x3e\xdb\x85\xca\x4c\xe3\xc2", "\xa5\xf5\x51",
          "\xbd\x29\x97\x5e\xe1\xc6\x1d\x9a\xa1\x7b\xbc\x0f\x2a\x22\x4d\x37",
          "\x89\x42\x00\x7c\x79\xff\xee\xef\xf3\x00\xe9\x7f\xb8\x68\x6e\x6a",
          "\x50\x8b\x12\x7f\xec\x1a\xf5\x14\x98\x99\x86\x28\x96\x98\x88\x2a", 1, 24, 128 },
        { 128, 128, 128, 63, "\xea\x40\x88\x88\xf0\x4b\x0e\x00\xa6\xaa\xf8\xf3\x6d\x33\x73\x68",
          "\xc2\xa3\x47\x08\x00\xaa\x79\xe8\xfa\xbb\x6f\xd3", "\x22\x68\xee\xcd\x92",
          "\x9b\x76\x96\x9c\xa5\xd3\xc2\xcd\x21\xcf\x25\x0e\x25\x6e\xdc\x06",
          "\x22\x69\xc2\xcd\x1b\xdd\x73\x3d\x6a\x85\x7a\x37\x22\xf6\x1d\xf9",
          "\x71\xac\x60\x2d\xd7\x6b\x24\x11\xc4\x1a\xce\x56\x74\x3d\x3a\x79", 1, 40, 128 },
        { 128, 128, 128, 64, "\x3c\xfa\xeb\xac\x46\x0e\x2c\xe3\xde\x29\x0a\x5f\x64\xd0\x01\xac",
          "\x38\x16\x98\x06\x60\x9b\x42\x4a\x35\xcc\x29\xe1",
          "\x77\x7c\xf7\xaa\xa2\xb2\x9a\x95\xf6\xfa\x0c",
          "\x1a\x78\x1e\x20\xef\xf9\xed\x7f\xe2\x0a\xec\xef\xfc\xad\x30\x3f",
          "\xc1\x29\x38\xaa\xcf\xef\x31\x9e\x44\x77\x44\xfb\xca\x1d\xe9\xb5",
          "\xf9\x1d\x3a\xf4\xbb\xfc\xa0\x69\x4e\xbf\xf5\xc9\x02\x77\x11\x54", 1, 88, 128 },
        { 128, 128, 128, 65, "\x28\xbc\xed\x74\x40\x52\x1a\xf6\xaf\xd5\x35\xa5\xab\xee\xe2\xbd",
          "\xed\xd9\x4e\x8f\x8c\x27\x54\x70\xd1\x8c\xdd\x86", "\xf2",
          "\x9a\x97\x44\xd9\xb7\x37\x50\x2c\xcb\x6c\x7c\xe8\xc9\x0b\xb6\x46",
          "\x80\xc9\x45\x14\xd5\xcb\x1f\x94\xf1\xbd\x32\x0c\x2f\x28\x8b\x88",
          "\x32\x25\x60\x15\xe0\xec\x50\xbd\x8b\x08\x93\xe7\x93\x65\xfa\xbc", 1, 8, 128 },
        { 128, 128, 128, 66, "\x6e\xfc\xae\x2b\x32\x27\xbd\x00\x09\x73\xbf\x3c\x7f\x53\xf1\xb4",
          "\x9d\x9a\xbf\xec\x72\xd4\x7b\x80\xc2\xc2\x1d\x16",
          "\x09\xc2\x3d\x43\x6d\x1f\x91\xf7\x5a\x89\x04",
          "\xdd\xbf\xb2\xbf\xf4\xb7\xe7\x1e\x5a\x11\x0f\xa8\x5c\x1e\xdf\x92\xbd\x76\x9b\x78\x64\x93"
          "\x2a\x50\x90\xe9\x4a\xe2\x15\xa4\x66\x9b",
          "\x29\x1d\x9d\x73\x40\xf5\xa6\xfb\x03\x62\xaf\xd6\x48\x59\x12\xd0\xbd\x0d\x53\x24\xa4\x7d"
          "\x99\x6d\x46\xd4\x4a\xc8\x59\xfd\xd2\x54",
          "\x9f\x70\xc9\xd1\x70\x50\x04\x5e\xe7\x49\x13\x37\xe9\x44\x38\x2b", 1, 88, 256 },
        { 128, 128, 128, 67, "\xcf\xe9\x69\x96\x7c\x66\x2c\xf8\x78\x85\xb2\x28\xbc\xdc\x45\x6e",
          "\xb0\x8f\x12\x87\x67\xa7\x8f\x14\xe3\xc7\xf6\x79", "\xa9\xd7\xdd\x48\xa3",
          "\xbe\x15\xd9\x58\xb6\x2e\xa8\xd7\x49\x26\xad\xfc\x90\xe8\x1a\x82",
          "\xe4\x9e\x21\x7a\x11\xd7\x80\xda\x42\x3a\x2f\xce\x4e\xf3\x7d\xc7",
          "\x68\x48\x02\xe7\x32\x57\x58\xa4\x24\x59\x1e\x74\x87\x7b\xb6\xcd", 1, 40, 128 },
        { 128, 128, 128, 68, "\x7c\xa5\x21\x34\x6d\xc8\x71\x80\x36\x0e\x1a\x3d\x40\xab\xac\x8f",
          "\x0a\xfc\xd2\x48\xb4\x25\x1e\xac\x6c\x58\x53\x43", "\x3f",
          "\x02\x60\xcc\xde\x07\xe2\x1e\x1e\x56\xd7\xcf\x68\xa5\x31\x3f\x14",
          "\x5d\x21\xff\x5c\x17\x7c\xe4\xc4\x3a\xd8\x20\xd2\x3d\x21\x77\x71",
          "\xfe\x77\x3f\x26\x6e\xd2\x7d\x37\x2d\xe7\xf4\xb0\x98\x34\xcc\x7b", 1, 8, 128 },
        { 128, 128, 128, 69, "\xeb\xa4\x9a\xd7\x47\x7b\x54\x4d\x09\x4f\xd1\xeb\x56\xd5\xd2\x9d",
          "\x5e\x95\xbb\x14\xb3\xf7\x0f\x4a\xae\x10\xaf\xd3", "\xc9\xfc",
          "\xe1\x71\x2e\x76\xfd\x81\xb8\x40\x65\x8c\x6b\x62\xc1\x9d\x45\x5e",
          "\x56\x02\xe6\x88\x02\x2f\xfa\xe2\x3e\x38\xcc\xf6\x0f\xcf\x5f\xe5",
          "\xea\x76\x28\xa4\xa3\x5d\x6d\xcb\x7e\x78\xb0\xca\x4b\xde\x0d\x88", 1, 16, 128 },
        { 128, 128, 128, 70, "\x40\xac\x4c\x0f\xdb\x02\xb8\x61\xa2\x42\xf7\xfe\x51\x6e\x49\x56",
          "\x66\x14\x95\xd0\x19\x40\x8d\x3d\xf8\x0e\x19\xaa", "\x68",
          "\xee\x86\x77\xd8\xbe\x4c\xf0\x5d\x4a\xe7\x46\xdb\xd6\xcd\x6b\x22",
          "\x3d\xb6\x4d\x99\x52\x70\x78\xdb\x28\xe1\x6f\x0e\xde\x22\x64\xc0",
          "\xf1\x8d\xfd\x93\xca\x19\x17\xef\xb1\xae\xf2\x8d\x0a\x30\xda\x61", 1, 8, 128 },
        { 128, 128, 128, 71, "\xb8\x9e\x3a\xaa\x8d\x89\x95\xa1\x92\xb3\x95\xcd\x37\xde\x30\x6a",
          "\x45\x49\x28\xac\x41\x61\x48\xcb\xfb\x11\xf2\x29", "",
          "\x5a\xda\x49\x1e\xf6\x6a\x58\x83\x14\xf2\x2b\xd3\xc7\x40\xbe\x14",
          "\x6d\x27\x78\x5b\x70\x11\x87\x11\x6b\x39\x02\xe0\xb5\xe2\xc0\x40",
          "\x56\x6e\x8a\xdd\xd6\x3f\x50\x01\xbe\x66\x45\x1b\xac\x9c\x06\xc3", 1, 0, 128 },
        { 128, 128, 128, 72, "\xf7\x9e\xc2\xad\x05\x21\x1b\xd2\x2d\xd3\xef\xfd\x3e\x93\xc7\x62",
          "\xc7\x7e\x21\x60\x46\xcb\x87\x64\x94\x12\x89\xa6", "\x4c\x2c\xa9\x46\xd3",
          "\x59\x3b\x5d\x61\xe7\x01\x1f\x85\x6e\x80\x84\x6c\xc0\xd3\x79\xa0",
          "\xf0\xb4\xa9\x42\x21\x06\x32\x57\x08\x8a\xe4\x02\x5e\x6d\xb0\x12",
          "\x85\x0d\x9d\xd5\x3e\xc1\x62\xee\x5c\x36\xff\x10\x89\x21\x76\x6a", 1, 40, 128 },
        { 128, 128, 128, 73, "\x35\x39\xb7\x1d\xb6\x34\x56\xf8\xd3\xc4\xd4\x7e\x30\xcb\x3b\x46",
          "\xd5\xa1\x16\x95\x32\xc0\x56\xdb\x4e\x04\x10\xc5", "",
          "\x61\xe3\x22\x4e\x45\xdc\x87\x27\xad\x11\x91\xdf\x9c\x33\x3e\x32",
          "\x3b\x20\x76\x19\xe4\x7a\x1d\x83\xc3\x8c\xac\x4d\xe9\x05\x87\x13",
          "\x4c\x35\xdb\x61\xd0\xe8\xc7\xa3\xf7\x05\x20\x99\x1e\x70\x4c\xad", 1, 0, 128 },
        { 128, 128, 128, 74, "\x8f\x68\x2f\x10\x6a\x94\xb2\x7b\xa2\xf1\xf9\xeb\x11\x5d\xb7\xe2",
          "\xc3\x53\xf8\x02\x3c\x8f\xc5\x2f\xe8\xd6\x4e\xd1",
          "\x5d\xb6\x7e\xd9\xef\xf6\x1c\xc8\x6b\x18\xf7\x41",
          "\x30\xa1\xf1\xe4\x8b\xf5\x17\x59\x1a\xe0\xdb\x02\xcd\x76\x5d\x3f",
          "\xe9\x36\xae\x10\x25\xcf\xff\xe8\xb0\x02\xa7\x88\xd2\xaa\xb3\xbf",
          "\x7b\xd0\xca\x14\xb0\x82\x6f\x75\x68\x50\x49\x74\xa8\x78\xa7\xbb", 1, 96, 128 },
        { 128, 128, 128, 75, "\xfe\x52\xb4\x48\x21\xa0\xae\xdc\x13\xa1\xcb\x11\x53\xe9\xfe\xd8",
          "\x30\x4e\x57\x4d\x55\x26\x5d\xb8\x7e\xf2\x31\x09",
          "\x68\x22\x6c\x35\x86\x81\x9f\xae\x4a\x70\x93",
          "\x24\xcd\xf5\x71\x5c\x50\x75\x18\x4c\xd4\x1f\xd5\xd3\xe1\x14\x14",
          "\x11\x13\x42\x87\x4e\x06\xe5\x0d\x40\x2e\x51\xe8\xcb\x31\x08\x65",
          "\xf0\x1e\xae\xc9\xda\x58\x38\xea\xb2\x6d\x55\xbf\x05\x59\x6c\x9f", 1, 88, 128 },
        { 128, 128, 128, 76, "\x40\xcf\x8a\x8d\xfd\x91\x06\x3d\x64\x13\x4c\x05\xcb\x7b\x42\xc5",
          "\xe2\xa2\x43\x26\xb1\xb8\x3f\x81\x2d\xba\x6c\xd1", "\x53\x47\x86\x64\xa4\xe0\x54",
          "\x56\x79\xe6\xd7\x95\x7e\x3e\x61\x55\x79\xbd\x18\xe3\x0e\x4d\x53",
          "\xc5\xcb\x89\xab\x1c\x0c\xcd\xe7\x38\x9e\x5f\x70\x03\x0d\xa9\x15",
          "\x67\x34\x2f\xb4\x28\x2f\x6e\x3c\x6e\x25\x2b\x98\xdd\x27\x43\x52", 1, 56, 128 },
        { 128, 128, 128, 77, "\x2d\x58\x84\x1a\x3e\x8f\x9a\x6c\x81\x2c\x87\x6f\x8e\xb6\xbe\xe6",
          "\x53\xa8\x28\xe6\x69\x5f\x59\x4b\x9e\x95\x7f\x76",
          "\x86\xa2\x72\x01\x46\x7f\x07\xa8\xac",
          "\x52\x95\xd2\x78\xf6\xb0\xe4\x59\xce\xf1\xf0\xd5\x23\x1a\xe5\x7b",
          "\x1d\x96\x72\x5a\xbc\xba\xa5\xb5\xb6\x47\x2f\x75\x9a\xc4\xba\x8a",
          "\x41\x36\x46\x3c\x4f\x4c\x47\x1e\xbc\x54\x81\x7f\xec\x94\x7f\x8e", 1, 72, 128 },
        { 128, 128, 128, 78, "\x40\x9d\x46\x46\x25\x94\x11\xa8\x13\xba\xbc\x5a\x59\xca\x6d\xf3",
          "\xdb\xf9\x00\x33\x4f\x46\x2a\xfe\x9b\x10\x5b\x60",
          "\xc4\xa6\xf5\xa8\xef\x6f\x98\xfe\x9d\x05\xac\x91",
          "\xc5\x50\x1d\x2c\x5c\x03\x0d\x4d\x9d\x5a\xb5\xc1\x4f\xdc\xde\x5e",
          "\x36\xc7\xb3\xe5\xc8\x64\x43\x1e\x80\xec\x54\x79\xd0\x4d\xf0\x6c",
          "\x9f\xf0\xb4\xa1\xbb\xe1\xd1\x50\x56\x97\xf6\xb9\x6b\x8b\x38\xab", 1, 96, 128 },
        { 128, 128, 128, 79, "\xb5\x22\xc6\x94\x6a\xfb\xb4\xc6\x23\x75\xe1\x2f\x90\xe0\x03\x9a",
          "\xd4\x83\xcd\xad\x1e\xc1\x41\xf6\x92\x7e\x89\x1e",
          "\x86\x4c\x8c\xb3\x2f\x9b\x1b\x04\x84\x56\xa9",
          "\x0a\x3c\x4f\x0c\x40\x88\x99\xdb\x20\x1b\x62\xc1\x1a\xec\x67\x02",
          "\x6c\xb6\xdf\xd7\x00\x84\xb1\x77\x84\x10\x83\x52\x8a\x4b\x56\x0d",
          "\xc0\xf7\x2a\x55\xbd\x64\x3c\x32\x54\x13\xf7\x23\xe4\xd6\xab\x56", 1, 88, 128 },
        { 128, 128, 128, 80, "\xa9\xaf\x84\x62\xcb\x1d\x56\x55\x77\x63\xfe\x10\x2d\xc5\x97\xe2",
          "\x0f\x94\x1f\xac\xa0\x72\x66\xe1\xdc\xa2\xd5\x83", "\x23\xef\xac\x22\x50\x1f",
          "\x58\x9d\x6b\x44\x67\xb6\x12\x31\x67\x71\xda\x9e\x76\xca\x33\x4e",
          "\xe3\x5b\x87\x0d\x11\xab\x6e\x8f\x5b\x3e\xb1\x9a\xff\x7d\xb2\x1a",
          "\x66\x3b\xb3\x16\x26\x00\x8b\x78\x10\xcf\x7f\xcd\xcf\xb9\x75\x63", 1, 48, 128 },
        { 128, 128, 128, 81, "\x8a\xce\x28\x51\x5e\x89\x16\x00\x8c\xd7\xe9\x52\x61\x44\x7b\x5b",
          "\xb3\x8d\xc9\x48\x54\xb1\x06\x12\x5e\x17\xb8\x10",
          "\x89\xd1\x19\xc8\xc8\xcc\x05\x60\x0e\x7e\x4c",
          "\x32\x62\x25\x4a\x4e\xa6\xcb\xdc\x31\x3d\x8a\x55\xf3\x3b\xf3\xb8",
          "\x70\x9b\xd8\x9a\xab\x38\xfd\xe7\x54\x24\xe3\x5f\xfb\x41\x7d\x53",
          "\xdb\xb8\x1a\x38\x8e\xbc\x0b\x37\x68\x3b\xb8\x45\x20\x55\x1b\x62", 1, 88, 128 },
        { 128, 128, 128, 82, "\xa6\x95\x7d\x52\x1a\x4a\x98\x38\x53\x95\x3d\x2d\x2a\xf8\x11\x81",
          "\xd5\xc7\x31\xf3\x9a\xf0\x0e\x4b\x2b\xff\x2b\xe1",
          "\xa9\x04\x59\x14\xb1\xca\xf4\x99\x10\x14\x58",
          "\x2d\x7e\xc2\x6e\x0b\x8d\x56\x6a\xcc\xe3\xfb\x93\x59\x62\x0a\x01",
          "\x21\x39\xff\xfb\xff\x37\xb8\xef\xa8\xaf\x65\xf3\x92\xc7\x76\xb0",
          "\x54\xf3\x73\x92\xc0\x53\xae\x8f\xd8\x0a\xc1\xd0\x1b\xdd\x2d\x13", 1, 88, 128 },
        { 128, 128, 128, 83, "\x7a\xc6\xe5\x4f\x72\x00\xb0\xc4\xaf\xea\xcf\x93\x04\x81\xfd\x28",
          "\xe3\x3a\xe0\x04\x0e\x9e\xf3\x31\xa3\xeb\xd1\xd2", "\x3a\x14\x07\x75\x5f\x5b\xdd",
          "\x09\x99\x4b\x06\x53\xd7\x25\xc5\x34\x55\x28\xff\xc7\xb9\x6e\x59",
          "\xac\x35\x2c\x34\x64\xf5\x77\x1d\x07\x8e\x3f\x6a\xbe\xd0\x98\x88",
          "\x5a\xdd\xa1\x72\xc5\xb2\x79\x40\x68\xc3\xcb\x2b\x50\x4a\x9f\x6e", 1, 56, 128 },
        { 128, 128, 128, 84, "\xd3\x6e\x32\x23\x0f\x07\x4e\xba\x7c\xf1\x74\xfc\x16\x43\x76\x80",
          "\x8b\xfe\x36\x16\x28\x44\x30\x8f\xab\x93\x63\x5f",
          "\xb6\x1c\x3b\x33\xb9\x85\xb5\x72\x1a",
          "\xf1\xe0\x2a\xfc\x08\x96\x2f\x23\x95\x34\x37\x25\x40\xd7\x1e\xae\xe8\x06\xd0\x2f\x10\x96"
          "\xf4\xd1\x33\xa3\x78\xcb\x18\x3c\x1b\x32",
          "\xcd\xad\xcd\xb1\x47\xbd\x7b\x9b\x60\x3e\x4b\x55\x71\x1c\x1a\xd7\x44\x88\x92\xbf\xd2\xfa"
          "\xef\x04\x09\x8b\xa9\xea\xdd\xce\x5e\xa2",
          "\x96\xe2\x4d\xc2\x57\x77\x25\xdf\x50\x31\x23\xe2\xfa\x28\x76\x50", 1, 72, 256 },
        { 128, 128, 128, 85, "\xee\x9e\x9d\x8c\x05\x1a\x7b\xce\x60\xd0\x62\xf4\x5d\x43\xcb\x2e",
          "\x9d\xef\xbf\x4b\x4d\x20\x29\x69\xda\x63\xdd\x71", "",
          "\xac\xba\x0a\xdc\x9b\x00\x81\x05\xe5\x88\x7f\xaa\xd1\x04\x45\x1f\x8c\x79\xb6\xbb\xcc\x72"
          "\x52\xa0\x50\x7b\x1c\xd5\x42\x16\x89\x68",
          "\x42\x57\x3b\x4c\xea\x1b\xfe\xdf\x61\xd5\xcd\xbe\x59\xe9\x02\x23\xff\x79\x22\xec\x26\xa5"
          "\x3d\x54\xf8\x06\x3a\xbc\x2e\x4e\x54\xc2",
          "\xed\x28\x22\xe5\x83\xef\x7c\x59\x0c\xaa\xc5\x79\x2f\x8b\x48\x47", 1, 0, 256 },
        { 128, 128, 128, 86, "\xd5\xd1\x85\x32\xbc\x3d\x3d\x7c\x87\x7c\xcf\x66\xf5\x98\x94\x33",
          "\x3e\x86\xf5\x2b\x55\x9d\x09\x76\x68\x6f\x0f\x86", "\x81\xef\x0d\x35\x55\x8f\xb7\x8f",
          "\xa5\x0a\xc3\x29\x8d\xce\xe3\xf5\xa0\xdf\x5b\xaf\xee\xea\x3c\x34",
          "\x06\xd8\x23\x2d\xab\x83\x43\xde\xf7\xbe\x75\xc6\x3c\x42\x0e\xc6",
          "\xcd\x0d\xf1\x76\x8e\xbe\x49\x40\x82\xf4\x94\xf6\x07\xe3\xec\x83", 1, 64, 128 },
        { 128, 128, 128, 87, "\x39\xc9\x3b\x34\x84\x88\xee\xa5\xf0\xa9\x8e\x0e\xde\x63\x1b\x5c",
          "\x6e\xc1\x00\x57\x0e\x17\x80\x25\x23\x2a\x74\x95", "\xa1\xea\x41",
          "\x93\xae\xee\xd7\xc9\x9d\x68\x47\x76\x37\xaa\x63\x86\x1f\x26\xac",
          "\x8c\xc2\x00\x2f\x59\xe8\xec\xc6\xfc\xaa\xef\x68\xcc\xdb\xde\x98",
          "\x9d\x7f\x5d\x44\x7e\x40\xd8\x64\x43\x30\xdf\xce\x9c\xb0\xcf\xf6", 1, 24, 128 },
        { 128, 128, 128, 88, "\x87\x32\x9c\xc0\x75\x7c\xcc\x24\x08\x3e\x7f\x2e\xe3\x46\xe1\x5c",
          "\x66\x09\x66\xbc\xc2\x77\x43\x25\x48\x84\x4d\x9d", "\xfe",
          "\x0a\xc4\x5a\xfe\x91\x1a\x89\x22\xa7\x62\xa5\xf7\x42\x42\x0b\x1c",
          "\xc2\x24\xed\xe6\xdd\x2a\x5d\xa8\xb6\x77\xe5\x67\x3e\xea\x60\xdb",
          "\x52\xd2\x85\x56\xae\xcb\x2e\xe7\x1b\xef\x32\x6e\x5f\x30\x5d\xed", 1, 8, 128 },
        { 128, 128, 128, 89, "\x07\x40\x02\x97\xf4\xdb\x36\x3b\x68\x8f\x80\x63\x45\x7e\xe3\x25",
          "\x13\x1c\xf8\xaf\x2d\xc2\x8f\x26\x42\x63\x7a\x61",
          "\xd7\xa2\xff\x75\xbb\x78\x7d\x75\x3c\x27\x48\x53",
          "\x55\xc1\x3b\x3e\x17\xaf\xf0\xb5\x0e\xe0\x5c\x9a\x8b\x53\x85\x86",
          "\x64\xd7\x40\xae\x0c\x77\x52\x1b\x0a\x71\x76\x92\xad\x43\x89\xcb",
          "\x8e\x4f\x0b\x8b\x3d\xef\xad\x87\x79\xc8\x35\x1f\xb8\xa0\x7e\x5b", 1, 96, 128 },
        { 128, 128, 128, 90, "\xa4\xab\xce\x29\xc1\x80\xf3\x99\x61\x4f\xee\x43\x0b\xf5\xe4\x4c",
          "\xe3\x6a\x67\x5c\xdc\x16\xb4\xc9\x91\x37\xd9\xb2", "\x56\x9e\x67\xb0\x0b\x37\x08",
          "\xa1\xbc\x6f\x96\x34\x67\xb8\x80\x22\x46\xb5\xdc\xa3\x14\xe1\x8c",
          "\xae\x5a\x96\xb8\x09\xd2\x8e\x81\xab\x64\xb3\xbb\x93\x62\xdc\xee",
          "\x40\xc6\x06\x83\x51\x72\xd3\xe1\x3c\xc7\x4b\xba\x7b\x3e\x3a\xbf", 1, 56, 128 },
        { 128, 128, 128, 91, "\x3e\x01\x3b\x2f\x50\xd9\xfe\x34\x13\xc8\xed\x82\x84\x85\x27\x19",
          "\xd7\x8f\xd4\x1e\x6a\x73\x91\x09\xcf\x25\x0b\x4a", "\x7e\x63\x12\x44\x7a\x35\xa1\xec",
          "\x86\xb9\xd6\x75\x56\x44\xe0\x23\x79\x5e\xcc\x9a\x66\x6b\x30\xcf",
          "\x23\xa8\xb1\x3f\xb0\xc4\x42\xcd\x09\xc5\x03\xdd\x59\x7f\x05\x02",
          "\x82\xc5\xb2\xa1\x1d\x6c\x99\xa0\x2d\xd8\x18\x00\x5e\x3d\xa0\x32", 1, 64, 128 },
        { 128, 128, 128, 92, "\x71\x55\x45\xd5\xa0\xcc\x88\xc4\xd6\xba\xc6\x66\xc3\x95\x77\x4d",
          "\x04\xef\x88\x31\xd3\x8f\x1e\xaa\x51\xc2\x3d\x20",
          "\x4c\x53\x7c\x8b\x85\x99\xa3\xf4\xe9\x5a\x00\x4e",
          "\x10\x55\x18\x10\x8d\x25\x19\xd0\xb9\x2c\x32\x39\xb1\x46\x25\xe8",
          "\xdf\xba\x30\x51\xbf\x57\xdd\xac\x70\x3c\x0b\xb0\x6a\x20\xa5\x21",
          "\xbc\xe2\xdc\x6b\xfb\x14\x5e\xd3\x19\x7f\xcf\x07\x75\x48\x5d\xe2", 1, 96, 128 },
        { 128, 128, 128, 93, "\x10\xee\xa1\xcb\x39\x5f\xca\xa8\x66\x50\x5d\x65\x64\x7e\xf3\x5c",
          "\xb8\x74\xe4\x38\x16\x7d\x19\x68\x13\x7a\x5e\x19",
          "\x7a\x42\xf6\xeb\x96\x78\x0e\x42\xf0\x5f\x76\x3f",
          "\x93\x85\xd0\xa0\x7b\x2f\xf5\x7f\xb2\x9e\x77\xb3\x43\x7e\xa0\xe1",
          "\x31\x99\xfb\x55\x14\xab\x38\x6c\xeb\x64\xd0\xc2\x7d\xdd\x18\x53",
          "\xca\x0a\x81\xc8\xa9\x81\x2f\xb5\x26\x1e\x25\xf0\x80\xdf\xce\x49", 1, 96, 128 },
        { 128, 128, 128, 94, "\x9e\x76\x26\x03\xbc\x5f\x35\x2b\x53\xcf\x09\x83\xe8\x18\x2b\x65",
          "\x60\xb4\x2f\x9b\xcc\x27\xfe\xd7\x1f\x9f\x4b\x66", "\x51\x82\x2f",
          "\x72\xf2\x49\x2f\x82\x5c\x81\xfc\x96\x6f\x8c\x1e\x21\x8b\xe1\x1d",
          "\xfb\x36\x4a\xdb\x1d\x16\x5e\x28\xbd\x0c\xe3\xb5\xea\xfd\xf3\x52",
          "\x3b\x23\x2c\xcb\x99\x87\x75\x18\xa0\x59\x17\x91\x5a\xc8\xec\xdd", 1, 24, 128 },
        { 128, 128, 128, 95, "\x39\x9c\xfc\x40\xaa\xa0\xcb\x4e\xd5\xec\x9b\x52\xe2\xbc\xd0\xfe",
          "\xc2\x92\x56\xd1\xbb\xf0\x2a\x58\x95\xc5\xbf\x47", "\xd0\xb6\x69",
          "\xd3\xbe\x4a\x0f\xeb\x8b\x7d\x20\xf9\xa4\x3f\x58\x9e\xde\xd2\xf1",
          "\xea\x80\x58\x30\xd1\x1b\xbe\x32\xf4\x05\xc6\x8a\x2c\x50\x06\x1f",
          "\xa7\xee\x34\x20\x8c\x16\xd1\x31\x2d\x0a\xe7\x8c\xc2\x4c\x3d\xcd", 1, 24, 128 },
        { 128, 128, 128, 96, "\x75\xaa\x6f\x5c\x6a\xaf\x82\x6d\x81\xa3\x41\x7d\x86\xb1\x5c\x6b",
          "\xad\xcc\xe7\x5a\xcc\x00\xb7\x35\x41\xc0\x63\x34", "\x05\xd5\xe1",
          "\x6b\x35\x56\x1b\x3a\x30\xf0\x92\xa6\x96\x33\x4d\xdc\xa5\xfe\xca",
          "\x8f\xb4\xfb\x48\x00\xc3\x56\x01\x19\xbe\xd5\xde\xe3\x19\x69\x5a",
          "\xd0\x3a\x39\x7c\xc8\x58\xc9\x62\x29\xaf\x99\x7d\xa4\xd9\xf9\x05", 1, 24, 128 },
        { 128, 128, 128, 97, "\x88\x14\xd4\xa0\xb9\xdb\xbb\x0e\x93\xfb\xa1\x4d\xde\xd1\xbe\x3c",
          "\xfa\x45\xe9\x15\x1e\x2d\x02\x43\x3d\xa2\x4a\x8c", "\x2a",
          "\x78\x22\xb3\x44\xda\xdd\x0e\x86\xdb\x5f\x35\x3e\xbf\x2f\x63\x77",
          "\x53\x50\x4e\xb0\x12\xc7\x8c\xdd\xe3\xa3\x62\xe0\x69\x62\xe0\x5c",
          "\x00\xaf\x6c\xb0\x50\xcc\x59\x69\x73\xf7\x16\x24\x4d\x96\x0a\xd1", 1, 8, 128 },
        { 128, 128, 128, 98, "\xab\x92\xb4\xd3\x04\xc2\xa9\x6f\x89\x88\xf8\xd7\x1e\x69\xfd\x14",
          "\xe9\xa0\xbb\x0e\x30\x28\x63\x43\x28\xda\xa5\x2b",
          "\x99\x14\xac\x42\xf0\xb3\x27\x82\xf9\xc9",
          "\x20\xcb\x88\x9c\x9e\x4a\x81\x1b\x38\x0d\x1a\xeb\x16\x66\x57\xdf",
          "\xc8\x56\xfe\x0b\x15\x24\x19\x5c\x1f\x2e\x1d\x54\xa3\xe2\x89\xcf",
          "\x53\xed\xa6\xea\xc1\x5c\x03\x41\xd6\x46\xc9\xb6\xf8\x3c\xfd\x29", 1, 80, 128 },
        { 128, 128, 128, 99, "\x44\x12\xb5\xc6\xdb\xd6\x41\x90\x4e\xec\xa3\xcc\xb7\x48\x4c\x5f",
          "\xed\x2c\xa0\x26\xe6\xb5\x28\xdc\x96\x83\x47\x0b", "\xce",
          "\xeb\xe4\xca\xc4\x0c\x72\x8b\x91\x50\xec\xc1\x1c\x00\xb0\xf4\xf1",
          "\x0b\xbf\xe3\x44\x3c\xc0\xe5\x5a\x0b\x9c\x7c\xb4\x34\x87\x97\x17",
          "\xe2\xcd\x58\xa6\xf9\xe1\x5a\xbb\x2c\x7f\x68\x9e\x17\x62\x73\xf9", 1, 8, 128 },
        { 128, 128, 128, 100, "\xce\x3f\x15\xec\xb5\x90\xd1\x82\x7c\x10\x11\x7e\x6f\x43\x3c\x7e",
          "\x97\x11\xb7\x02\xaa\x69\xf8\x75\x56\x53\x21\xd2", "\x31\x44\xb8\x1c\x0b",
          "\x29\xd8\x00\xf5\x0c\x36\xea\xc2\x5f\x66\xde\xa7\x48\x73\x15\x90",
          "\x49\x97\x01\x41\xce\x84\xbb\xee\x43\xb2\x58\x1d\x0a\x5f\x8a\x54",
          "\xf0\x42\x8e\xa1\x86\x0d\xe0\xba\x41\xd5\xff\x7f\x4c\xcc\x03\x27", 1, 40, 128 },
        { 128, 128, 128, 101, "\x5a\x7c\xee\xbb\x07\x50\xaf\xcb\xa5\xcb\x90\xeb\xaf\xe8\x9e\x8a",
          "\x1b\x8d\xdc\x27\xea\xc9\xfc\xb0\x91\x6d\x5a\x56", "\x0b\x55\x38\x00\x11",
          "\x53\xbe\xfa\xaf\x98\xb8\x94\x94\x66\x6c\x6b\x37\x33\x61\x84\xdb",
          "\x49\xc3\xd4\x10\x81\x68\x48\x83\x8b\xf3\x2d\x56\xd2\xfb\x8d\xe3",
          "\xa5\xdd\xff\x2f\xb8\x63\xb4\x51\x5d\xaf\x12\x6f\x24\x84\x62\xbe", 1, 40, 128 },
        { 128, 128, 128, 102, "\xe5\x54\x43\x2e\xb7\x38\x5c\x8f\x5e\xe5\x06\xf6\x27\x45\x63\xaf",
          "\xe4\xe8\xe5\xb1\x41\x6f\x89\xa0\x2e\x86\x63\x57", "\xef\xea\xa5\x52\x4e\x4e",
          "\x7a\xab\xc7\xfd\x5c\x09\x4c\xee\xd3\x81\xd6\x9c\xd8\x18\x08\xd6",
          "\xbc\xed\x1d\xfd\x11\x6f\x55\xec\xa0\xd8\xb0\xc8\x89\x29\x1e\x64",
          "\xc1\xc0\xbc\x1f\xb9\x4d\x24\xa4\xd1\xae\xff\x80\xdf\x3c\x0e\xa4", 1, 48, 128 },
        { 128, 128, 128, 103, "\x4a\x25\x7c\xc8\x8e\xb1\x11\x77\x7f\xd5\xb0\xc4\x78\xba\xf8\x74",
          "\x18\xf6\xb5\xd2\x06\x89\x2a\xb6\x60\xb0\x11\xf1", "\xd6\x9c\x0d",
          "\xee\x02\x23\x69\xd5\x85\x51\xff\x98\x48\xd3\x33\xc0\x3a\xaf\xff",
          "\x40\xcc\x04\x2b\x30\x2d\x09\xae\x78\x67\x69\xde\xd5\x9d\x35\x15",
          "\x03\x9a\x62\xd3\x54\x93\x3e\x46\xd2\x95\x6f\x54\xb6\xaf\xd2\xab", 1, 24, 128 },
        { 128, 128, 128, 104, "\x32\xac\x11\xda\xd0\x1a\x6b\xb4\x05\x12\x6a\x31\x41\x00\x37\xb7",
          "\x54\xe0\xd8\x9b\x90\x50\x27\xa7\x77\x9f\xcf\x6f", "\xb7\xda\x2b\x11\xaf\xf6\xef",
          "\x0e\x02\x5a\x5d\x39\x96\x32\x6a\x9a\x2d\x85\xd4\xce\xca\xe9\x26",
          "\x03\x9f\x9d\xb7\x58\x18\x75\x6c\x2c\x22\x59\xea\x3c\xe1\x07\xa8",
          "\xbf\xc0\x6b\x5b\x6e\x1b\x88\xb5\x54\xd0\xef\x43\x30\xda\x2e\x66", 1, 56, 128 },
        { 128, 128, 128, 105, "\xd1\x3a\x99\x5a\x5e\x43\x78\x59\x6b\x26\x34\xfc\x87\xbd\xf7\x65",
          "\xd3\x13\xf3\xcb\xd8\xc4\xc5\x0b\x17\x07\x45\x44", "\x2d\xf3\x67\x60\xba\xcb",
          "\xdc\x50\xfd\xb8\xec\x91\x32\xa8\x5b\x57\xb9\x32\x4d\x1f\xc4\xc2\xde\x81\xf0\x3b\x75\xca"
          "\x61\x02\x51\xdb\xd7\xba\xed\x67\x71\x50",
          "\xcb\x9d\x13\xc2\x34\xcc\xca\x99\x3a\xb3\xfa\x3f\xd0\x52\x0f\x07\x7b\x3a\x92\xd3\x24\xfb"
          "\x76\x7a\xac\x35\x7c\xa2\x71\x28\x6e\x18",
          "\xf7\x54\x8f\xf8\xb9\x1c\xea\x64\x32\x60\xce\x2c\x60\xfe\xec\x1b", 1, 48, 256 },
        { 128, 128, 128, 106, "\x1b\x8b\x1a\x41\x4f\xf1\xac\x22\x85\xde\xc8\xda\x41\x7d\xa3\x65",
          "\xec\x59\xc2\xbb\xf6\x26\x0f\xa9\xab\x83\x79\x55", "\xaf\x1c\x90\x9a\xe9\x95\x00",
          "\xdf\x2b\x42\x73\x00\x5e\x51\x32\x25\xa0\xf4\x49\x94\xd4\x02\x1b",
          "\x3e\xae\x62\xa3\x6a\x11\x1f\x29\x44\x76\x48\xf3\x58\x36\x93\x1a",
          "\x3e\x3a\x79\x31\x20\x8e\x55\x3b\x48\x93\x4f\xef\x5f\x7d\x3a\xd9", 1, 56, 128 },
        { 128, 128, 128, 107, "\x51\xb7\x93\xfc\x4d\x0b\x87\xad\x43\xf3\xa3\x24\xa5\xca\x16\x24",
          "\x29\xf5\xd9\x10\xa7\xad\xf6\x13\x64\xac\xe3\x17", "",
          "\x03\xa2\x02\x35\x76\xf6\x3b\x3f\xf2\x5f\xa0\x2b\xf8\x72\x8a\xe1",
          "\xc3\x7f\x1b\x9d\x17\x57\xcc\x4f\xb6\x71\x1b\x15\xb8\x62\x7f\xce",
          "\x07\x28\x11\x12\xfc\xe9\x73\x5a\x55\x4b\x10\x0b\x2f\xeb\x80\xce", 1, 0, 128 },
        { 128, 128, 128, 108, "\xf1\x92\x35\x48\x60\xf6\x70\x1b\x64\x23\x9e\x82\xf6\x3c\x4e\xc9",
          "\x8b\x49\xcf\x53\xc4\xd6\x24\x94\x2d\xfc\xf9\xf5", "\x5f\x30\x24\x7e\xae",
          "\x89\x2a\xdf\xd2\x47\xaf\x95\x0f\xb2\x6f\xdd\x9b\xc3\xda\x29\x08",
          "\x3c\x63\xb1\xbf\xa9\x3f\x25\xd7\xa6\x47\x85\xeb\x9d\x86\x01\xda",
          "\x99\x93\x89\x2b\xbe\x10\xc5\x6c\xc8\x78\xbb\x38\xc8\xad\x30\x3c", 1, 40, 128 },
        { 128, 128, 128, 109, "\x78\x98\x93\xd5\xaa\xd9\x01\x83\x2c\xa9\x33\x9a\x0f\x18\xab\x92",
          "\xe7\x71\x93\x97\x15\x17\x62\x2b\x92\xf1\x19\x67", "\xf3\x0e\x97\xd7\x74\x49",
          "\xc7\x56\x86\xf2\x2f\x10\xbd\xa9\x65\x65\x14\xd5\x9b\x81\xd1\x9b",
          "\xcf\xee\xc4\x96\x6c\xde\xe0\x0b\x7b\xdf\xf3\xc3\x07\x62\x71\xf9",
          "\xe2\x5f\x25\x18\x7d\x2c\x09\x46\xf2\x69\x67\xa4\x03\xfc\x94\xa0", 1, 48, 128 },
        { 128, 128, 128, 110, "\x1a\x50\xf6\x3a\x11\x2b\xc1\x0f\xb9\xcc\xd7\x51\x23\x1a\x9f\xbf",
          "\xaf\x7e\x7c\x6c\xac\x53\xd8\xa6\xb9\xdf\xcc\x27", "\xb9\x25\x2b\xb5\xa4\x1e\xdc\x76",
          "\x5f\x76\x5b\x7c\x0c\xe4\x0a\x2c\x84\x51\x13\x80\x76\xc5\x3d\x21",
          "\x75\x86\xc0\x77\xa7\xa0\x00\x14\x08\xcf\x49\xa4\x8e\xaa\x0e\x9b",
          "\x8d\xe1\x62\x31\x0c\x52\x13\x23\xdd\x93\x12\xb3\x0a\xe6\x7e\x23", 1, 64, 128 },
        { 128, 128, 128, 111, "\xa7\x7a\xc3\xf0\xdc\x29\xca\x6f\xcb\x82\x31\x26\xce\xb2\x73\xc3",
          "\x4d\x27\xbc\x5c\x13\x4a\xbe\xbb\xc6\x17\xae\x85", "\x5b\xba\xd9\x47\xcc\x1f\x87\xcd",
          "\x43\x63\x8a\xd3\xac\x02\xe9\xe9\x62\x09\xa8\x13\x0d\x48\xce\xa0\x6e\x69\x51\xcb\xd1\x4a"
          "\x14\xc9\x59\x20\x3e\x5e\x7f\x7a\xa8\x24",
          "\x30\xdc\xd7\x25\xec\x5b\x91\x5a\xbe\x49\xc4\xa4\x2c\x0c\x32\xd1\x26\xf9\xe8\xbd\xa3\xc6"
          "\xb1\xd1\x7c\x00\x63\xa4\xf7\x73\x86\x87",
          "\xf4\xff\x29\x67\x76\x5c\x62\xa9\x56\xda\x40\x5f\x7e\xde\xfc\x46", 1, 64, 256 },
        { 128, 128, 128, 112, "\xdd\x37\xff\xfc\x14\xd9\xd8\xf4\xd4\x27\xc5\xa5\x32\xc7\x73\x88",
          "\x9b\x9d\xc8\xf6\xe9\x69\x4d\x63\x66\x2e\x4c\x11",
          "\xcb\x89\xc7\x20\xed\x68\xfe\xf2\x9c\x63\xd0\x94",
          "\x8d\x0f\x82\x2d\x86\x5e\x5f\x92\x03\xfc\x9b\xf3\xc8\x85\xdc\x07",
          "\xe8\xe7\xd8\x91\x13\xe2\x9b\x10\xb6\xf8\xec\x00\xd3\x44\xe1\x6b",
          "\x7b\x0b\x1c\x92\xd4\x9f\x0d\xf3\x47\x18\x78\x96\x42\xb2\x72\x46", 1, 96, 128 },
        { 128, 128, 128, 113, "\x1d\x41\xf3\x55\x6b\xb2\x66\x2b\xf3\x4a\x3e\x09\x5a\xbd\xe1\x03",
          "\x7e\x97\xd9\x80\xfb\x34\xa5\xca\x2c\xd3\x8d\xe3",
          "\xa1\xdd\x1f\x99\xd5\xbe\xda\xc9\xa9\xe1",
          "\xae\x1a\xce\x36\x5d\x62\x50\x08\xb2\x1b\xf0\x2f\x00\x9d\xf0\x7b",
          "\xe5\x2c\x1f\xd6\x39\xef\x2f\xf8\x9a\xf6\x33\x8d\x11\x34\xfc\xfa",
          "\xc8\xb4\xb4\x17\x2f\x97\xb9\x9d\x59\xa7\xc0\x6f\x7f\x26\xf5\xe4", 1, 80, 128 },
        { 128, 128, 128, 114, "\xd4\x9e\x4f\x37\xe8\x6a\x96\x46\xe0\xa5\x8d\x42\xdc\xc7\x0d\xe8",
          "\x28\x15\xa4\xd1\x31\xc6\xec\x98\xd2\xba\x09\xa7", "\x69\x7e\x41\xfc\x3f\x96\xcb\xfe",
          "\x3d\x49\xf8\x49\x49\xb3\xcd\x18\x5d\x19\x8a\xaf\xc7\x2f\x79\x7b\xf6\x90\xde\x58\xc2\xb5"
          "\x74\x63\x43\x41\xb6\x94\x2f\xd6\xec\xb2",
          "\x0b\x96\xfd\x05\x0f\xce\xf2\xb8\x18\xff\x61\x79\x07\xcc\xc4\x1f\xb1\x35\xd5\x66\x36\x70"
          "\xbe\xb4\x2d\xe4\x13\x32\xd7\x7e\x50\x5d",
          "\xca\xfc\x0f\x5b\x94\x03\x9f\x6a\x1c\x64\xbb\x72\x8d\x99\x43\x42", 1, 64, 256 },
        { 128, 128, 128, 115, "\xb7\xae\xd5\x2e\x82\x24\x2d\x60\xa7\xc3\x37\xad\xf8\xfe\x4b\x40",
          "\x07\xfe\xbe\x77\x7d\xdb\xcd\x9d\xee\xb6\xbd\x94", "\xa3\x27",
          "\xcf\xbe\x92\xaa\x74\xc7\x1a\xa8\xea\x49\xb2\x10\x0a\xf2\x1a\xa0",
          "\x7d\xe9\x30\xab\xa9\xac\x49\xbb\x63\x97\x71\xd3\xe7\x5f\xc5\x6a",
          "\xa5\x5b\x2c\xa0\x75\xc9\x2c\xa5\x85\x48\x76\x55\xa7\x36\x6a\x64", 1, 16, 128 },
        { 128, 128, 128, 116, "\xe3\x6a\x67\x35\x4b\x8b\xad\x5b\x94\xed\xf4\x16\x84\x99\xe1\xaa",
          "\xa8\x6b\x59\x72\x77\x2f\x30\xa0\x35\xaf\x56\x20", "",
          "\x7c\x80\xd7\x5a\x51\xda\x80\x7c\xdf\x96\x07\x95\x47\x64\x5d\x7a",
          "\xda\xc1\xe0\x89\xf4\x70\xbc\x0e\xf2\x79\xf4\x53\x77\x97\xf3\xd7",
          "\x30\xbd\x95\x64\x86\x92\x85\x79\x43\x3e\x41\x34\xc4\x5a\x9e\xf5", 1, 0, 128 },
        { 128, 128, 128, 117, "\x36\xe9\xf7\x87\x4a\x9a\xc6\x71\x78\x1b\x48\x98\xfa\x93\x33\xc9",
          "\x24\xf6\x2d\x86\x32\xab\xab\xdd\x91\x66\xdc\xa9", "\xde\xfa\xa9\xa0",
          "\x53\xff\xaf\x94\xf3\x09\x2d\x76\x55\x55\x6d\xed\x34\xb5\xde\xf3",
          "\xca\x3d\x6c\xdb\x2c\x95\x2b\x15\x1a\x25\x21\x48\x85\xb9\x1e\x8e",
          "\x55\xfa\xdf\xb1\x15\x55\xb9\x27\x7b\x5b\xb2\xa8\xa7\x56\xdb\x45", 1, 32, 128 },
        { 128, 128, 128, 118, "\xd0\xb1\xe5\x3b\x90\x75\x74\xfd\x71\xcf\x29\x1c\x84\xd8\xa7\x14",
          "\xc2\x4e\xbf\x53\x6c\x61\xbe\x10\x7d\x59\xb6\x0f",
          "\x28\xea\xb1\x87\x37\x63\x01\xb1\x78\x5a\x3e\xe0",
          "\x3a\xc4\x88\x33\xce\x67\xcc\x43\x00\x22\xf6\x1d\x08\x44\x02\x22\xe7\x65\x3c\x4c\x16\x33"
          "\xa6\xa1\x8d\xac\x02\x04\x8d\x8e\x66\x0f",
          "\x61\x6d\x18\xb3\x8a\x7b\x96\xd4\x7f\x20\x57\x6b\xb7\xc6\xbf\xe9\x3d\x1e\x81\x24\x78\xa6"
          "\xf4\x53\x96\x5c\x1d\x3a\xc7\xa0\x5f\x90",
          "\x33\xd8\x01\x62\x29\xc9\x60\x33\xdd\x43\x06\xac\x4f\xf0\x7a\x81", 1, 96, 256 },
        { 128, 128, 128, 119, "\x35\xe7\xa4\x7e\x7f\x27\x81\x91\x07\xde\x29\x75\x1c\xcf\x84\x24",
          "\xa0\x24\x0e\xdb\x0a\xaa\xef\xe2\xb9\xd8\x0d\x12", "\xb2\x9b\x5e\x2b\x20\x1d\x7c\x23",
          "\xa2\xad\x18\xec\x7c\x9c\x8f\x4a\x66\x96\x4f\x8f\x9b\xa4\x24\x9c",
          "\x3b\x96\x37\x21\x74\x49\xc9\x0f\x34\x48\xe5\x57\x85\xad\xd5\x90",
          "\xd8\x8b\x88\x13\xc6\xab\x0e\x21\xd3\x12\x2e\x9b\x48\xc1\x31\x9e", 1, 64, 128 },
        { 128, 128, 128, 120, "\x05\x3f\xe5\x18\x51\xe7\x1e\xae\x30\xd1\x3e\x2e\x38\x87\x7b\xe2",
          "\x94\x57\x44\x51\x75\xd6\xb7\x70\x34\xcc\x9c\x64", "\xac\x91\xba\x5c\xdf\x93\xb5\x13",
          "\x4c\x6d\x47\x59\x31\x0a\x92\x8b\x00\x9b\x8a\x2a\x07\x2c\xa3\x1d",
          "\x42\xab\xd8\xbe\x53\x03\xdd\xc3\x2b\x9c\x2f\xbe\xa3\x64\x4e\x5b",
          "\x22\xf7\xb7\x48\x05\xfe\xe7\x66\xb5\xac\x08\xe0\xb7\xaa\x84\xf1", 1, 64, 128 },
        { 128, 128, 128, 121, "\x2f\x56\x2a\x74\x1a\x2f\xcb\xbd\x13\xc5\xab\x74\x2f\x1b\x57\x65",
          "\xe9\xf2\x02\x04\xfa\x03\xa3\xc9\x08\x2c\x24\xeb", "\x91\xec\x76",
          "\x0e\xba\x95\x3c\xa2\x7e\xb4\x00\x98\x93\xdf\x43\x74\x80\xcf\xa8",
          "\x36\xee\xeb\x00\xe1\xa8\x5d\x89\x1a\x6e\x9d\xde\x5b\xb4\xad\x4c",
          "\x58\x41\xca\x40\x74\xaa\x4c\x05\x89\x76\x6e\xc8\xdb\xd6\x2b\x00", 1, 24, 128 },
        { 128, 128, 128, 122, "\x18\xb0\xa8\xc9\xbb\xc8\x21\xed\x30\x2d\x61\x13\xe9\x57\x7e\x17",
          "\xd7\xe2\x27\x24\x79\x43\xd0\xfc\x45\x26\xee\x0d", "\xb6\xe7",
          "\x13\xad\xef\x86\xef\xc8\xca\xc2\x5c\xf0\x13\x1a\x77\x2e\xb5\x47",
          "\x68\xce\x46\x14\x68\x74\xbf\x2c\x85\x90\x49\x74\x01\xd7\x07\x2f",
          "\x87\x68\xc5\xbd\x76\x62\x30\x2d\x12\x4f\xc0\x3e\x68\x80\xd5\xbf", 1, 16, 128 },
        { 128, 128, 128, 123, "\xa9\xa5\x96\xaa\x61\x2b\xaa\x21\xb1\xd5\x31\xa3\xec\xec\xd4\xb2",
          "\x74\x62\x50\x3e\xff\x96\xc0\x46\xcb\x8e\x86\x87",
          "\xd3\xf2\x79\x9c\x69\x6b\x41\x68\xd3\x1c\xbc",
          "\xb8\x32\x54\x90\xcc\x77\x58\x65\xac\x6e\x06\xcd\xb4\x21\xb4\x90",
          "\x70\x24\x57\x35\x25\xf5\x88\x43\x66\x61\x02\x14\xd6\x86\x3b\xb1",
          "\x34\xa4\x60\xe8\x6d\x3d\xd4\xfc\xf4\x1c\xc3\xd6\x4a\xdd\x3a\xfc", 1, 88, 128 },
        { 128, 128, 128, 124, "\x10\x6b\x0d\xdb\x13\xed\x14\x1c\x52\xd6\x98\x76\x25\x5c\x4e\xb1",
          "\x3b\x1b\x0f\xc8\x20\x7c\xf8\xbc\x5f\xdc\x07\x3d", "\x23\x34\xaa\x79",
          "\x61\x4d\x37\x44\x9e\x60\x18\x0c\x24\xa0\x61\x3e\x91\x88\x58\x06",
          "\x04\xec\x16\x1d\xf2\xba\xee\x1e\x32\x02\x8a\x7d\xcf\xdb\xcf\x0f",
          "\xfb\x28\x29\xe6\xaa\x3c\xb3\x64\x4a\xca\x57\x7a\x7d\x0b\x27\x00", 1, 32, 128 },
        { 128, 128, 128, 125, "\xf8\xda\xdf\x7e\x8c\xaa\x7f\xb6\xf8\xa4\x3a\x1b\x30\x2e\x32\x1c",
          "\x4d\x77\x4c\x9c\x62\xff\xb1\x91\x96\x2a\xaf\xc9", "\x6f\x1e\xda\x9d\x5b\xb4\x69",
          "\x28\x34\x38\xa1\xb2\xaa\x18\x3d\x36\xea\xfd\x3f\xf7\x2c\xdc\x8b",
          "\x3b\xbe\xcb\x1e\x9c\x71\x9c\x73\x4c\xbe\xa7\xaa\x32\x31\xbf\xb7",
          "\xa9\x2b\x16\xad\x48\x6d\xdb\xf8\x00\x1b\xb4\x50\x25\xc3\x5f\x18", 1, 56, 128 },
        { 128, 128, 128, 126, "\x09\x37\x3a\x84\x05\x35\xda\x36\x96\x5d\x1d\xa7\x9e\xf4\xf0\xde",
          "\x17\x7e\x79\x89\x9c\xfd\x71\xf1\x01\x16\x7b\xf0",
          "\x60\xe0\x2f\xf2\x4c\x77\x5a\x10\x10\x78",
          "\xa1\x7b\x1f\x5f\x74\xf5\x9e\xc9\x44\x18\xaa\xe1\x08\xeb\xfc\xc5",
          "\x56\xbd\x93\xf7\x63\xad\x06\x25\xde\xe0\x86\xaf\x7e\xc1\xfe\xd6",
          "\x68\x5c\xa2\xf4\x4a\x9d\x76\x1a\x55\x56\xc8\xea\x40\x29\xdd\xaa", 1, 80, 128 },
        { 128, 128, 128, 127, "\xd9\x58\xbd\x01\xac\x6c\xa7\x78\xfc\xda\xee\x6e\x5f\xd1\x9b\xae",
          "\x00\x8e\x63\x92\x38\x39\x47\x8e\xc9\x04\x05\x6e",
          "\xc7\x65\x9b\x69\xd3\xc0\xf8\xd3\xd1\xca",
          "\x70\xcc\xc5\x3a\x4d\xd4\x27\xfd\x5f\xee\xf0\xc1\x61\x21\xb5\xed",
          "\x47\xe3\x96\x94\x41\x34\x75\x8f\xbd\x55\x79\x7b\x6c\x51\x2e\x17",
          "\x9b\xcd\xc5\x42\x77\x99\xe4\x09\xfe\xce\x08\xe3\x0f\xe1\xb5\x74", 1, 80, 128 },
        /* Vector from RFC-8998
          https://datatracker.ietf.org/doc/html/rfc8998
        */
        { 96, 128, 128, 128,
          "\x01\x23\x45\x67\x89\xAB\xCD\xEF"
          "\xFE\xDC\xBA\x98\x76\x54\x32\x10",
          "\x00\x00\x12\x34\x56\x78\x00\x00"
          "\x00\x00\xAB\xCD",
          "\xFE\xED\xFA\xCE\xDE\xAD\xBE\xEF"
          "\xFE\xED\xFA\xCE\xDE\xAD\xBE\xEF"
          "\xAB\xAD\xDA\xD2",
          "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA"
          "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB"
          "\xCC\xCC\xCC\xCC\xCC\xCC\xCC\xCC"
          "\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD"
          "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE"
          "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF"
          "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE"
          "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA",
          "\x17\xF3\x99\xF0\x8C\x67\xD5\xEE"
          "\x19\xD0\xDC\x99\x69\xC4\xBB\x7D"
          "\x5F\xD4\x6F\xD3\x75\x64\x89\x06"
          "\x91\x57\xB2\x82\xBB\x20\x07\x35"
          "\xD8\x27\x10\xCA\x5C\x22\xF0\xCC"
          "\xFA\x7C\xBF\x93\xD4\x96\xAC\x15"
          "\xA5\x68\x34\xCB\xCF\x98\xC3\x97"
          "\xB4\x02\x4A\x26\x91\x23\x3B\x8D",
          "\x83\xDE\x35\x41\xE4\xC2\xB5\x81"
          "\x77\xE0\x65\xA9\xBF\x7B\x62\xEC",
          1, 160, 512 },
        /* No plaintext, no AAD vector */
        { 96, 128, 128, 129,
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00",
          "", "", "",
          "\x23\x2f\x0c\xfe\x30\x8b\x49\xea"
          "\x6f\xc8\x82\x29\xb5\xdc\x85\x8d",
          1, 0, 0 },
        /* 16-byte plaintext with all zeros, no AAD */
        { 96, 128, 128, 130,
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00",
          "",
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x7d\xe2\xaa\x7f\x11\x10\x18\x82"
          "\x18\x06\x3b\xe1\xbf\xeb\x6d\x89",
          "\xb8\x51\xb5\xf3\x94\x93\x75\x2b"
          "\xe5\x08\xf1\xbb\x44\x82\xc5\x57",
          1, 0, 128 },
        /* No plaintext, 20-byte AAD */
        { 96, 128, 128, 131,
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00",
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00\x00\x00\x00\x00"
          "\x00\x00\x00\x00",
          "", "",
          "\x97\x20\x01\xb2\xd6\x04\xac\xcd"
          "\x37\x6d\x82\x9d\x35\x89\xf3\xd3",
          1, 160, 0 },
        /* Variable sized plaintext, AAD */
        { 96, 128, 128, 132,
          "\x69\x73\x51\xff\x4a\xec\x29\xcd"
          "\xba\xab\xf2\xfb\xe3\x46\x7c\xc2",
          "\x54\xf8\x1b\xe8\xe7\x8d\x76\x5a"
          "\x2e\x63\x33\x9f",
          "\xc9\x9a\x66\x32\x0d\xb7\x31\x58"
          "\xa3\x5a\x25\x5d\x05\x17\x58\xe9"
          "\x5e\xd4\xab\xb2\xcd\xc6\x9b\xb4"
          "\x54\x11\x0e\x82\x74\x41\x21\x3d"
          "\xdc\x87\x70\xe9\x3e\xa1\x41",
          "\xe1\xfc\x67\x3e\x01\x7e", "\x79\x0c\x5b\x40\xcb\xbe",
          "\x81\x96\xee\x15\x59\xac\xc9\x3d"
          "\xac\xc0\xdc\x7c\x9a\x40\x0e\x8d",
          1, 312, 48 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};
