<!--===- docs/GettingInvolved.md

   Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
   See https://llvm.org/LICENSE.txt for license information.
   SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

-->
# Getting Involved

```eval_rst
.. contents::
   :local:
```

The Flang Project welcomes contributions of all kinds.
Please feel free to join the mailing list or the slack channel for discussions related to development of Flang.
To understand the status of various developments in Flang please join the respective call.

## Mailing Lists

[Developer's List (flang-dev)](http://lists.llvm.org/mailman/listinfo/flang-dev)

  This list is for people who want to be included in technical discussions related to Flang. People post to this list when they have questions about writing code
  for or using the Flang tools. It is relatively low volume.


[Commits Archive (flang-commits)](http://lists.llvm.org/pipermail/flang-commits)

  This list contains all commit messages that are made when Flang developers
  commit code changes to the repository. It also serves as a forum for
  patch review (i.e. send patches here). It is useful for those who want to
  stay on the bleeding edge of Flang development. This list is high
  volume.

## Chat

### Flang Slack Workspace

-   There is a Slack workspace dedicated to Flang.
-   There are a number of topic-oriented channels available (e.g., #driver, #f18-semantics, #fir).
-   Add yourself via the *[invitation link](https://join.slack.com/t/flang-compiler/shared_invite/zt-2pcn51lh-VrRQL_YUOkxA_1CEfMGQhw "title")*

## Calls

### Flang Community Biweekly Call

-   General updates on the Flang Project, both LLVM Flang and current Flang.
-   Join [Flang Community Biweekly Call](https://nvmeet.webex.com/nvmeet/j.php?MTID=mb4edb8c799f69ec2dc0554acc969a162)
-   Time: On Wednesdays 8:30 Pacific Time, on the weeks alternating with regular Flang Community Technical Biweekly Call.
-   Minutes: They are sent to [flang-dev](http://lists.llvm.org/mailman/listinfo/flang-dev). Search for `Flang Biweekly Sync - Notes`.

### Flang Community Technical Biweekly Call

-   Technical topics call.
-   Join [Flang Community Technical Biweekly Call](https://bluejeans.com/625064848?src=join_info)
-   Time: On Mondays 8:30 Pacific Time, on the weeks alternating with regular Flang Community Biweekly Call.
-   The agenda is in this [Google Doc](https://docs.google.com/document/d/1Z2U5UAtJ-Dag5wlMaLaW1KRmNgENNAYynJqLW2j2AZQ/).

### LLVM Alias Analysis Technical Call

-   For people working on improvements to LLVM alias analysis.
-   Join [LLVM Alias Analysis Technical Call](https://bluejeans.com/101176001?src=join_info)
-   Time: Tuesdays 10:00 AM Pacific Time, every 4 weeks.
-   The agenda is in this [Google Doc](https://docs.google.com/document/d/1ybwEKDVtIbhIhK50qYtwKsL50K-NvB6LfuBsfepBZ9Y/).

### OpenMP Technical Call

-   Development updates on OpenMP and OpenACC in the Flang Project.
-   Join [OpenMP Technical Call](https://bit.ly/39eQW3o)
-   Time: Weekly call on every Thursdays 8:00 AM Pacific time.
-   Meeting minutes are [here](https://docs.google.com/document/d/1yA-MeJf6RYY-ZXpdol0t7YoDoqtwAyBhFLr5thu5pFI).
-   Status tracking [page](https://docs.google.com/spreadsheets/d/1FvHPuSkGbl4mQZRAwCIndvQx9dQboffiD-xD0oqxgU0/edit#gid=0).
