/*
 * Copyright (C) 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.4
import QtQuick.Layouts 1.1
import Lomiri.Components 1.3
import Lomiri.Components.Popups 1.3

Dialog {
    objectName: "vpnPreviewDialog"
    id: preview

    // A connection we assume to be installed.
    property var connection: null

    // A configuration we assume is not installed.
    // A configuration is expected to have a set of
    // properties, just like a connection.
    property var configuration: null

    function getConnection () {
        return connection ? connection : configuration;
    }

    function isInstalled () {
        return !!connection;
    }

    signal changeClicked(var connection)
    signal installClicked(var configuration)

    Component.onCompleted: {
        var source;
        var conn = getConnection();

        switch (conn.type) {
            case 0: // Openvpn
                source = "Openvpn/Preview.qml";
                // TRANSLATORS: %1 is the hostname of a VPN connection
                if (conn.remote) title = i18n.dtr("lomiri-settings-components", "VPN “%1”").arg(conn.remote);
                break;
            case 1: // PPTP
                source = "Pptp/Preview.qml";
                // TRANSLATORS: %1 is the hostname of a VPN connection
                if (conn.gateway) title = i18n.dtr("lomiri-settings-components", "VPN “%1”").arg(conn.gateway);
                break;
            default: // Unknown
                source = "";
                break;
        }

        contentLoader.setSource(source, {
            connection: getConnection(),
            installed: isInstalled()
        });
        if (!title) title = i18n.dtr("lomiri-settings-components", "VPN");
    }

    Loader {
        id: contentLoader
        anchors { left: parent.left; right: parent.right; }
    }

    RowLayout {
        spacing: units.gu(2)

        Button {
            objectName: "vpnPreviewRemoveButton"
            Layout.fillWidth: true
            visible: connection !== null
            text: i18n.dtr("lomiri-settings-components", "Remove")
            onClicked: {
                connection.remove();
                PopupUtils.close(preview);
            }
        }

        Button {
            objectName: "vpnPreviewChangeButton"
            Layout.fillWidth: true
            visible: connection !== null
            text: i18n.dtr("lomiri-settings-components", "Change")
            color: theme.palette.normal.positive
            onClicked: changeClicked(connection)
        }

        Button {
            objectName: "vpnPreviewCancelButton"
            Layout.fillWidth: true
            visible: configuration !== null
            text: i18n.dtr("lomiri-settings-components", "Cancel")
            onClicked: PopupUtils.close(preview)
        }

        Button {
            objectName: "vpnPreviewInstallButton"
            Layout.fillWidth: true
            visible: configuration !== null
            text: i18n.dtr("lomiri-settings-components", "Install")
            color: theme.palette.normal.positive
            onClicked: installClicked(configuration)
        }
    }
}
