/*
 * Autogenerated from the following JSON policy
 */

#if 0
	{
	  "release":			"01234567",
	  "product":			"myproduct",
	  "schema-version":			1,

	  "retry": [
		  {"default": {
			"backoff": [	 1000,
						 2000,
						 3000,
						 5000,
						10000
				],
			"conceal":		25,
			"jitterpc":		20,
			"svalidping":	30,
			"svalidhup":	35
		}}
	  ],
	  "certs": [
		{"isrg_root_x1":
	"MIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4WhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJuZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBYMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygch77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6UA5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sWT8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyHB5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UCB5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUvKBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWnOlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTnjh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbwqHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CIrU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkqhkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZLubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KKNFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5ORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7UrTkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdCjNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVcoyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPAmRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57demyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc="
		},
		{"LEX3_isrg_root_x1":
	"MIIFjTCCA3WgAwIBAgIRANOxciY0IzLc9AUoUSrsnGowDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTYxMDA2MTU0MzU1WhcNMjExMDA2MTU0MzU1WjBKMQswCQYDVQQGEwJVUzEWMBQGA1UEChMNTGV0J3MgRW5jcnlwdDEjMCEGA1UEAxMaTGV0J3MgRW5jcnlwdCBBdXRob3JpdHkgWDMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCc0wzwWuUuR7dyXTeDs2hjMOrXNSYZJeG9vjXxcJIvt7hLQQWrqZ41CFjssSrEaIcLo+N15Obzp2JxunmBYB/XkZqf89B4Z3HIaQ6Vkc/+5pnpYDxIzH7KTXcSJJ1HG1rrueweNwAcnKx7pwXqzkrrvUHlNpi5y/1tPJZo3yMqQpAMhnRnyH+lmrhSYRQTP2XpgofL2/oOVvaGifOFP5eGr7DcGu9rDZUWfcQroGWymQQ2dYBrrErzG5BJeC+ilk8qICUpBMZ0wNAxzY8xOJUWuqgzuEPxsR/DMH+ieTETPS02+OP88jNquTkxxa/EjQ0dZBYzqvqEKbbUC8DYfcOTAgMBAAGjggFnMIIBYzAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADBUBgNVHSAETTBLMAgGBmeBDAECATA/BgsrBgEEAYLfEwEBATAwMC4GCCsGAQUFBwIBFiJodHRwOi8vY3BzLnJvb3QteDEubGV0c2VuY3J5cHQub3JnMB0GA1UdDgQWBBSoSmpjBH3duubRObemRWXv86jsoTAzBgNVHR8ELDAqMCigJqAkhiJodHRwOi8vY3JsLnJvb3QteDEubGV0c2VuY3J5cHQub3JnMHIGCCsGAQUFBwEBBGYwZDAwBggrBgEFBQcwAYYkaHR0cDovL29jc3Aucm9vdC14MS5sZXRzZW5jcnlwdC5vcmcvMDAGCCsGAQUFBzAChiRodHRwOi8vY2VydC5yb290LXgxLmxldHNlbmNyeXB0Lm9yZy8wHwYDVR0jBBgwFoAUebRZ5nu25eQBc4AIiMgaWPbpm24wDQYJKoZIhvcNAQELBQADggIBABnPdSA0LTqmRf/Q1eaM2jLonG4bQdEnqOJQ8nCqxOeTRrToEKtwT++36gTSlBGxA/5dut82jJQ2jxN8RI8L9QFXrWi4xXnA2EqA10yjHiR6H9cj6MFiOnb5In1eWsRMUM2v3e9tNsCAgBukPHAg1lQh07rvFKm/Bz9BCjaxorALINUfZ9DD64j2igLIxle2DPxW8dI/F2loHMjXZjqG8RkqZUdoxtID5+90FgsGIfkMpqgRS05f4zPbCEHqCXl1eO5HyELTgcVlLXXQDgAWnRzut1hFJeczY1tjQQno6f6s+nMydLN26WuU4s3UYvOuOsUxRlJu7TSRHqDC3lSE5XggVkzdaPkuKGQbGpny+01/47hfXXNB7HntWNZ6N2Vwp7G6OfY+YQrZwIaQmhrIqJZuigsrbe3W+gdn5ykE9+Ky0VgVUsfxo52mwFYs1JKY2PGDuWx8M6DlS6qQkvHaRUo0FMd8TsSlbF0/v965qGFKhSDeQoMpYnwcmQilRh/0ayLThlHLN81gSkJjVrPI0Y8xCVPB4twb1PFUd2fPM3sA1tJ83sZ5v8vgFv2yofKRPB0t6JzUA81mSqM3kxl5e+IZwhYAyO0OTg3/fs8HqGTNKd9BqoUwSRBzp06JMg5brUCGwbCUDI0mxadJ3Bz4WxR6fyNpBK2yAinWEsikxqEt"}
	  ],
	  "trust_stores": [
		{
			"name": "le_via_isrg",
			"stack": [
				"isrg_root_x1",
				"LEX3_isrg_root_x1"
			]
		}
	  ],
	  "s": [

		{"test_stream": {
			"endpoint":		"warmcat.com",
			"port":			443,
			"protocol":		"h2",
			"http_method":		"GET",
			"http_url":		"index.html",
			"tls":			true,
			"opportunistic":	true,
			"retry":		"default",
			"tls_trust_store":	"le_via_isrg"
		}},{
		    "captive_portal_detect": {
                        "endpoint":		"connectivitycheck.android.com",
			"http_url":		"generate_204",
			"port":			80,
                        "protocol":		"h1",
                        "http_method":		"GET",
                        "opportunistic":	true,
                        "http_expect":		204,
			"http_fail_redirect":	true
                }}
	]}


 Original JSON size: 4903
#endif

static const uint32_t _rbo_bo_0[] = {
 1000,  2000,  3000,  5000,  10000, 
};
static const lws_retry_bo_t _rbo_0 = {
	.retry_ms_table = _rbo_bo_0,
	.retry_ms_table_count = 5,
	.conceal_count = 25,
	.secs_since_valid_ping = 30,
	.secs_since_valid_hangup = 35,
	.jitter_percent = 20,
};
static const uint8_t _ss_der_isrg_root_x1[] = {
	/* 0x  0 */ 0x30, 0x82, 0x05, 0x6B, 0x30, 0x82, 0x03, 0x53, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x11, 0x00, 
	/* 0x 10 */ 0x82, 0x10, 0xCF, 0xB0, 0xD2, 0x40, 0xE3, 0x59, 
	/* 0x 18 */ 0x44, 0x63, 0xE0, 0xBB, 0x63, 0x82, 0x8B, 0x00, 
	/* 0x 20 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x 28 */ 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 
	/* 0x 30 */ 0x4F, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 
	/* 0x 38 */ 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x29, 
	/* 0x 40 */ 0x30, 0x27, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 
	/* 0x 48 */ 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 0x65, 
	/* 0x 50 */ 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 
	/* 0x 58 */ 0x74, 0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 0x61, 
	/* 0x 60 */ 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F, 0x75, 
	/* 0x 68 */ 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 
	/* 0x 70 */ 0x04, 0x03, 0x13, 0x0C, 0x49, 0x53, 0x52, 0x47, 
	/* 0x 78 */ 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x58, 0x31, 
	/* 0x 80 */ 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x35, 0x30, 0x36, 
	/* 0x 88 */ 0x30, 0x34, 0x31, 0x31, 0x30, 0x34, 0x33, 0x38, 
	/* 0x 90 */ 0x5A, 0x17, 0x0D, 0x33, 0x35, 0x30, 0x36, 0x30, 
	/* 0x 98 */ 0x34, 0x31, 0x31, 0x30, 0x34, 0x33, 0x38, 0x5A, 
	/* 0x a0 */ 0x30, 0x4F, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 
	/* 0x a8 */ 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 
	/* 0x b0 */ 0x29, 0x30, 0x27, 0x06, 0x03, 0x55, 0x04, 0x0A, 
	/* 0x b8 */ 0x13, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 
	/* 0x c0 */ 0x65, 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 
	/* 0x c8 */ 0x69, 0x74, 0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 
	/* 0x d0 */ 0x61, 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F, 
	/* 0x d8 */ 0x75, 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 
	/* 0x e0 */ 0x55, 0x04, 0x03, 0x13, 0x0C, 0x49, 0x53, 0x52, 
	/* 0x e8 */ 0x47, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x58, 
	/* 0x f0 */ 0x31, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0D, 0x06, 
	/* 0x f8 */ 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 
	/* 0x100 */ 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02, 0x0F, 
	/* 0x108 */ 0x00, 0x30, 0x82, 0x02, 0x0A, 0x02, 0x82, 0x02, 
	/* 0x110 */ 0x01, 0x00, 0xAD, 0xE8, 0x24, 0x73, 0xF4, 0x14, 
	/* 0x118 */ 0x37, 0xF3, 0x9B, 0x9E, 0x2B, 0x57, 0x28, 0x1C, 
	/* 0x120 */ 0x87, 0xBE, 0xDC, 0xB7, 0xDF, 0x38, 0x90, 0x8C, 
	/* 0x128 */ 0x6E, 0x3C, 0xE6, 0x57, 0xA0, 0x78, 0xF7, 0x75, 
	/* 0x130 */ 0xC2, 0xA2, 0xFE, 0xF5, 0x6A, 0x6E, 0xF6, 0x00, 
	/* 0x138 */ 0x4F, 0x28, 0xDB, 0xDE, 0x68, 0x86, 0x6C, 0x44, 
	/* 0x140 */ 0x93, 0xB6, 0xB1, 0x63, 0xFD, 0x14, 0x12, 0x6B, 
	/* 0x148 */ 0xBF, 0x1F, 0xD2, 0xEA, 0x31, 0x9B, 0x21, 0x7E, 
	/* 0x150 */ 0xD1, 0x33, 0x3C, 0xBA, 0x48, 0xF5, 0xDD, 0x79, 
	/* 0x158 */ 0xDF, 0xB3, 0xB8, 0xFF, 0x12, 0xF1, 0x21, 0x9A, 
	/* 0x160 */ 0x4B, 0xC1, 0x8A, 0x86, 0x71, 0x69, 0x4A, 0x66, 
	/* 0x168 */ 0x66, 0x6C, 0x8F, 0x7E, 0x3C, 0x70, 0xBF, 0xAD, 
	/* 0x170 */ 0x29, 0x22, 0x06, 0xF3, 0xE4, 0xC0, 0xE6, 0x80, 
	/* 0x178 */ 0xAE, 0xE2, 0x4B, 0x8F, 0xB7, 0x99, 0x7E, 0x94, 
	/* 0x180 */ 0x03, 0x9F, 0xD3, 0x47, 0x97, 0x7C, 0x99, 0x48, 
	/* 0x188 */ 0x23, 0x53, 0xE8, 0x38, 0xAE, 0x4F, 0x0A, 0x6F, 
	/* 0x190 */ 0x83, 0x2E, 0xD1, 0x49, 0x57, 0x8C, 0x80, 0x74, 
	/* 0x198 */ 0xB6, 0xDA, 0x2F, 0xD0, 0x38, 0x8D, 0x7B, 0x03, 
	/* 0x1a0 */ 0x70, 0x21, 0x1B, 0x75, 0xF2, 0x30, 0x3C, 0xFA, 
	/* 0x1a8 */ 0x8F, 0xAE, 0xDD, 0xDA, 0x63, 0xAB, 0xEB, 0x16, 
	/* 0x1b0 */ 0x4F, 0xC2, 0x8E, 0x11, 0x4B, 0x7E, 0xCF, 0x0B, 
	/* 0x1b8 */ 0xE8, 0xFF, 0xB5, 0x77, 0x2E, 0xF4, 0xB2, 0x7B, 
	/* 0x1c0 */ 0x4A, 0xE0, 0x4C, 0x12, 0x25, 0x0C, 0x70, 0x8D, 
	/* 0x1c8 */ 0x03, 0x29, 0xA0, 0xE1, 0x53, 0x24, 0xEC, 0x13, 
	/* 0x1d0 */ 0xD9, 0xEE, 0x19, 0xBF, 0x10, 0xB3, 0x4A, 0x8C, 
	/* 0x1d8 */ 0x3F, 0x89, 0xA3, 0x61, 0x51, 0xDE, 0xAC, 0x87, 
	/* 0x1e0 */ 0x07, 0x94, 0xF4, 0x63, 0x71, 0xEC, 0x2E, 0xE2, 
	/* 0x1e8 */ 0x6F, 0x5B, 0x98, 0x81, 0xE1, 0x89, 0x5C, 0x34, 
	/* 0x1f0 */ 0x79, 0x6C, 0x76, 0xEF, 0x3B, 0x90, 0x62, 0x79, 
	/* 0x1f8 */ 0xE6, 0xDB, 0xA4, 0x9A, 0x2F, 0x26, 0xC5, 0xD0, 
	/* 0x200 */ 0x10, 0xE1, 0x0E, 0xDE, 0xD9, 0x10, 0x8E, 0x16, 
	/* 0x208 */ 0xFB, 0xB7, 0xF7, 0xA8, 0xF7, 0xC7, 0xE5, 0x02, 
	/* 0x210 */ 0x07, 0x98, 0x8F, 0x36, 0x08, 0x95, 0xE7, 0xE2, 
	/* 0x218 */ 0x37, 0x96, 0x0D, 0x36, 0x75, 0x9E, 0xFB, 0x0E, 
	/* 0x220 */ 0x72, 0xB1, 0x1D, 0x9B, 0xBC, 0x03, 0xF9, 0x49, 
	/* 0x228 */ 0x05, 0xD8, 0x81, 0xDD, 0x05, 0xB4, 0x2A, 0xD6, 
	/* 0x230 */ 0x41, 0xE9, 0xAC, 0x01, 0x76, 0x95, 0x0A, 0x0F, 
	/* 0x238 */ 0xD8, 0xDF, 0xD5, 0xBD, 0x12, 0x1F, 0x35, 0x2F, 
	/* 0x240 */ 0x28, 0x17, 0x6C, 0xD2, 0x98, 0xC1, 0xA8, 0x09, 
	/* 0x248 */ 0x64, 0x77, 0x6E, 0x47, 0x37, 0xBA, 0xCE, 0xAC, 
	/* 0x250 */ 0x59, 0x5E, 0x68, 0x9D, 0x7F, 0x72, 0xD6, 0x89, 
	/* 0x258 */ 0xC5, 0x06, 0x41, 0x29, 0x3E, 0x59, 0x3E, 0xDD, 
	/* 0x260 */ 0x26, 0xF5, 0x24, 0xC9, 0x11, 0xA7, 0x5A, 0xA3, 
	/* 0x268 */ 0x4C, 0x40, 0x1F, 0x46, 0xA1, 0x99, 0xB5, 0xA7, 
	/* 0x270 */ 0x3A, 0x51, 0x6E, 0x86, 0x3B, 0x9E, 0x7D, 0x72, 
	/* 0x278 */ 0xA7, 0x12, 0x05, 0x78, 0x59, 0xED, 0x3E, 0x51, 
	/* 0x280 */ 0x78, 0x15, 0x0B, 0x03, 0x8F, 0x8D, 0xD0, 0x2F, 
	/* 0x288 */ 0x05, 0xB2, 0x3E, 0x7B, 0x4A, 0x1C, 0x4B, 0x73, 
	/* 0x290 */ 0x05, 0x12, 0xFC, 0xC6, 0xEA, 0xE0, 0x50, 0x13, 
	/* 0x298 */ 0x7C, 0x43, 0x93, 0x74, 0xB3, 0xCA, 0x74, 0xE7, 
	/* 0x2a0 */ 0x8E, 0x1F, 0x01, 0x08, 0xD0, 0x30, 0xD4, 0x5B, 
	/* 0x2a8 */ 0x71, 0x36, 0xB4, 0x07, 0xBA, 0xC1, 0x30, 0x30, 
	/* 0x2b0 */ 0x5C, 0x48, 0xB7, 0x82, 0x3B, 0x98, 0xA6, 0x7D, 
	/* 0x2b8 */ 0x60, 0x8A, 0xA2, 0xA3, 0x29, 0x82, 0xCC, 0xBA, 
	/* 0x2c0 */ 0xBD, 0x83, 0x04, 0x1B, 0xA2, 0x83, 0x03, 0x41, 
	/* 0x2c8 */ 0xA1, 0xD6, 0x05, 0xF1, 0x1B, 0xC2, 0xB6, 0xF0, 
	/* 0x2d0 */ 0xA8, 0x7C, 0x86, 0x3B, 0x46, 0xA8, 0x48, 0x2A, 
	/* 0x2d8 */ 0x88, 0xDC, 0x76, 0x9A, 0x76, 0xBF, 0x1F, 0x6A, 
	/* 0x2e0 */ 0xA5, 0x3D, 0x19, 0x8F, 0xEB, 0x38, 0xF3, 0x64, 
	/* 0x2e8 */ 0xDE, 0xC8, 0x2B, 0x0D, 0x0A, 0x28, 0xFF, 0xF7, 
	/* 0x2f0 */ 0xDB, 0xE2, 0x15, 0x42, 0xD4, 0x22, 0xD0, 0x27, 
	/* 0x2f8 */ 0x5D, 0xE1, 0x79, 0xFE, 0x18, 0xE7, 0x70, 0x88, 
	/* 0x300 */ 0xAD, 0x4E, 0xE6, 0xD9, 0x8B, 0x3A, 0xC6, 0xDD, 
	/* 0x308 */ 0x27, 0x51, 0x6E, 0xFF, 0xBC, 0x64, 0xF5, 0x33, 
	/* 0x310 */ 0x43, 0x4F, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 
	/* 0x318 */ 0x42, 0x30, 0x40, 0x30, 0x0E, 0x06, 0x03, 0x55, 
	/* 0x320 */ 0x1D, 0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 
	/* 0x328 */ 0x02, 0x01, 0x06, 0x30, 0x0F, 0x06, 0x03, 0x55, 
	/* 0x330 */ 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x05, 0x30, 
	/* 0x338 */ 0x03, 0x01, 0x01, 0xFF, 0x30, 0x1D, 0x06, 0x03, 
	/* 0x340 */ 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x79, 
	/* 0x348 */ 0xB4, 0x59, 0xE6, 0x7B, 0xB6, 0xE5, 0xE4, 0x01, 
	/* 0x350 */ 0x73, 0x80, 0x08, 0x88, 0xC8, 0x1A, 0x58, 0xF6, 
	/* 0x358 */ 0xE9, 0x9B, 0x6E, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
	/* 0x360 */ 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 
	/* 0x368 */ 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x55, 
	/* 0x370 */ 0x1F, 0x58, 0xA9, 0xBC, 0xB2, 0xA8, 0x50, 0xD0, 
	/* 0x378 */ 0x0C, 0xB1, 0xD8, 0x1A, 0x69, 0x20, 0x27, 0x29, 
	/* 0x380 */ 0x08, 0xAC, 0x61, 0x75, 0x5C, 0x8A, 0x6E, 0xF8, 
	/* 0x388 */ 0x82, 0xE5, 0x69, 0x2F, 0xD5, 0xF6, 0x56, 0x4B, 
	/* 0x390 */ 0xB9, 0xB8, 0x73, 0x10, 0x59, 0xD3, 0x21, 0x97, 
	/* 0x398 */ 0x7E, 0xE7, 0x4C, 0x71, 0xFB, 0xB2, 0xD2, 0x60, 
	/* 0x3a0 */ 0xAD, 0x39, 0xA8, 0x0B, 0xEA, 0x17, 0x21, 0x56, 
	/* 0x3a8 */ 0x85, 0xF1, 0x50, 0x0E, 0x59, 0xEB, 0xCE, 0xE0, 
	/* 0x3b0 */ 0x59, 0xE9, 0xBA, 0xC9, 0x15, 0xEF, 0x86, 0x9D, 
	/* 0x3b8 */ 0x8F, 0x84, 0x80, 0xF6, 0xE4, 0xE9, 0x91, 0x90, 
	/* 0x3c0 */ 0xDC, 0x17, 0x9B, 0x62, 0x1B, 0x45, 0xF0, 0x66, 
	/* 0x3c8 */ 0x95, 0xD2, 0x7C, 0x6F, 0xC2, 0xEA, 0x3B, 0xEF, 
	/* 0x3d0 */ 0x1F, 0xCF, 0xCB, 0xD6, 0xAE, 0x27, 0xF1, 0xA9, 
	/* 0x3d8 */ 0xB0, 0xC8, 0xAE, 0xFD, 0x7D, 0x7E, 0x9A, 0xFA, 
	/* 0x3e0 */ 0x22, 0x04, 0xEB, 0xFF, 0xD9, 0x7F, 0xEA, 0x91, 
	/* 0x3e8 */ 0x2B, 0x22, 0xB1, 0x17, 0x0E, 0x8F, 0xF2, 0x8A, 
	/* 0x3f0 */ 0x34, 0x5B, 0x58, 0xD8, 0xFC, 0x01, 0xC9, 0x54, 
	/* 0x3f8 */ 0xB9, 0xB8, 0x26, 0xCC, 0x8A, 0x88, 0x33, 0x89, 
	/* 0x400 */ 0x4C, 0x2D, 0x84, 0x3C, 0x82, 0xDF, 0xEE, 0x96, 
	/* 0x408 */ 0x57, 0x05, 0xBA, 0x2C, 0xBB, 0xF7, 0xC4, 0xB7, 
	/* 0x410 */ 0xC7, 0x4E, 0x3B, 0x82, 0xBE, 0x31, 0xC8, 0x22, 
	/* 0x418 */ 0x73, 0x73, 0x92, 0xD1, 0xC2, 0x80, 0xA4, 0x39, 
	/* 0x420 */ 0x39, 0x10, 0x33, 0x23, 0x82, 0x4C, 0x3C, 0x9F, 
	/* 0x428 */ 0x86, 0xB2, 0x55, 0x98, 0x1D, 0xBE, 0x29, 0x86, 
	/* 0x430 */ 0x8C, 0x22, 0x9B, 0x9E, 0xE2, 0x6B, 0x3B, 0x57, 
	/* 0x438 */ 0x3A, 0x82, 0x70, 0x4D, 0xDC, 0x09, 0xC7, 0x89, 
	/* 0x440 */ 0xCB, 0x0A, 0x07, 0x4D, 0x6C, 0xE8, 0x5D, 0x8E, 
	/* 0x448 */ 0xC9, 0xEF, 0xCE, 0xAB, 0xC7, 0xBB, 0xB5, 0x2B, 
	/* 0x450 */ 0x4E, 0x45, 0xD6, 0x4A, 0xD0, 0x26, 0xCC, 0xE5, 
	/* 0x458 */ 0x72, 0xCA, 0x08, 0x6A, 0xA5, 0x95, 0xE3, 0x15, 
	/* 0x460 */ 0xA1, 0xF7, 0xA4, 0xED, 0xC9, 0x2C, 0x5F, 0xA5, 
	/* 0x468 */ 0xFB, 0xFF, 0xAC, 0x28, 0x02, 0x2E, 0xBE, 0xD7, 
	/* 0x470 */ 0x7B, 0xBB, 0xE3, 0x71, 0x7B, 0x90, 0x16, 0xD3, 
	/* 0x478 */ 0x07, 0x5E, 0x46, 0x53, 0x7C, 0x37, 0x07, 0x42, 
	/* 0x480 */ 0x8C, 0xD3, 0xC4, 0x96, 0x9C, 0xD5, 0x99, 0xB5, 
	/* 0x488 */ 0x2A, 0xE0, 0x95, 0x1A, 0x80, 0x48, 0xAE, 0x4C, 
	/* 0x490 */ 0x39, 0x07, 0xCE, 0xCC, 0x47, 0xA4, 0x52, 0x95, 
	/* 0x498 */ 0x2B, 0xBA, 0xB8, 0xFB, 0xAD, 0xD2, 0x33, 0x53, 
	/* 0x4a0 */ 0x7D, 0xE5, 0x1D, 0x4D, 0x6D, 0xD5, 0xA1, 0xB1, 
	/* 0x4a8 */ 0xC7, 0x42, 0x6F, 0xE6, 0x40, 0x27, 0x35, 0x5C, 
	/* 0x4b0 */ 0xA3, 0x28, 0xB7, 0x07, 0x8D, 0xE7, 0x8D, 0x33, 
	/* 0x4b8 */ 0x90, 0xE7, 0x23, 0x9F, 0xFB, 0x50, 0x9C, 0x79, 
	/* 0x4c0 */ 0x6C, 0x46, 0xD5, 0xB4, 0x15, 0xB3, 0x96, 0x6E, 
	/* 0x4c8 */ 0x7E, 0x9B, 0x0C, 0x96, 0x3A, 0xB8, 0x52, 0x2D, 
	/* 0x4d0 */ 0x3F, 0xD6, 0x5B, 0xE1, 0xFB, 0x08, 0xC2, 0x84, 
	/* 0x4d8 */ 0xFE, 0x24, 0xA8, 0xA3, 0x89, 0xDA, 0xAC, 0x6A, 
	/* 0x4e0 */ 0xE1, 0x18, 0x2A, 0xB1, 0xA8, 0x43, 0x61, 0x5B, 
	/* 0x4e8 */ 0xD3, 0x1F, 0xDC, 0x3B, 0x8D, 0x76, 0xF2, 0x2D, 
	/* 0x4f0 */ 0xE8, 0x8D, 0x75, 0xDF, 0x17, 0x33, 0x6C, 0x3D, 
	/* 0x4f8 */ 0x53, 0xFB, 0x7B, 0xCB, 0x41, 0x5F, 0xFF, 0xDC, 
	/* 0x500 */ 0xA2, 0xD0, 0x61, 0x38, 0xE1, 0x96, 0xB8, 0xAC, 
	/* 0x508 */ 0x5D, 0x8B, 0x37, 0xD7, 0x75, 0xD5, 0x33, 0xC0, 
	/* 0x510 */ 0x99, 0x11, 0xAE, 0x9D, 0x41, 0xC1, 0x72, 0x75, 
	/* 0x518 */ 0x84, 0xBE, 0x02, 0x41, 0x42, 0x5F, 0x67, 0x24, 
	/* 0x520 */ 0x48, 0x94, 0xD1, 0x9B, 0x27, 0xBE, 0x07, 0x3F, 
	/* 0x528 */ 0xB9, 0xB8, 0x4F, 0x81, 0x74, 0x51, 0xE1, 0x7A, 
	/* 0x530 */ 0xB7, 0xED, 0x9D, 0x23, 0xE2, 0xBE, 0xE0, 0xD5, 
	/* 0x538 */ 0x28, 0x04, 0x13, 0x3C, 0x31, 0x03, 0x9E, 0xDD, 
	/* 0x540 */ 0x7A, 0x6C, 0x8F, 0xC6, 0x07, 0x18, 0xC6, 0x7F, 
	/* 0x548 */ 0xDE, 0x47, 0x8E, 0x3F, 0x28, 0x9E, 0x04, 0x06, 
	/* 0x550 */ 0xCF, 0xA5, 0x54, 0x34, 0x77, 0xBD, 0xEC, 0x89, 
	/* 0x558 */ 0x9B, 0xE9, 0x17, 0x43, 0xDF, 0x5B, 0xDB, 0x5F, 
	/* 0x560 */ 0xFE, 0x8E, 0x1E, 0x57, 0xA2, 0xCD, 0x40, 0x9D, 
	/* 0x568 */ 0x7E, 0x62, 0x22, 0xDA, 0xDE, 0x18, 0x27, 
};
static const lws_ss_x509_t _ss_x509_isrg_root_x1 = {
	.vhost_name = "isrg_root_x1",
	.ca_der = _ss_der_isrg_root_x1,
	.ca_der_len = 1391,
};
static const uint8_t _ss_der_LEX3_isrg_root_x1[] = {
	/* 0x  0 */ 0x30, 0x82, 0x05, 0x8D, 0x30, 0x82, 0x03, 0x75, 
	/* 0x  8 */ 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x11, 0x00, 
	/* 0x 10 */ 0xD3, 0xB1, 0x72, 0x26, 0x34, 0x23, 0x32, 0xDC, 
	/* 0x 18 */ 0xF4, 0x05, 0x28, 0x51, 0x2A, 0xEC, 0x9C, 0x6A, 
	/* 0x 20 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x 28 */ 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x30, 
	/* 0x 30 */ 0x4F, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 
	/* 0x 38 */ 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x29, 
	/* 0x 40 */ 0x30, 0x27, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 
	/* 0x 48 */ 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 0x65, 
	/* 0x 50 */ 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 
	/* 0x 58 */ 0x74, 0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 0x61, 
	/* 0x 60 */ 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F, 0x75, 
	/* 0x 68 */ 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 
	/* 0x 70 */ 0x04, 0x03, 0x13, 0x0C, 0x49, 0x53, 0x52, 0x47, 
	/* 0x 78 */ 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x58, 0x31, 
	/* 0x 80 */ 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x36, 0x31, 0x30, 
	/* 0x 88 */ 0x30, 0x36, 0x31, 0x35, 0x34, 0x33, 0x35, 0x35, 
	/* 0x 90 */ 0x5A, 0x17, 0x0D, 0x32, 0x31, 0x31, 0x30, 0x30, 
	/* 0x 98 */ 0x36, 0x31, 0x35, 0x34, 0x33, 0x35, 0x35, 0x5A, 
	/* 0x a0 */ 0x30, 0x4A, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 
	/* 0x a8 */ 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 
	/* 0x b0 */ 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 
	/* 0x b8 */ 0x13, 0x0D, 0x4C, 0x65, 0x74, 0x27, 0x73, 0x20, 
	/* 0x c0 */ 0x45, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 0x31, 
	/* 0x c8 */ 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 
	/* 0x d0 */ 0x13, 0x1A, 0x4C, 0x65, 0x74, 0x27, 0x73, 0x20, 
	/* 0x d8 */ 0x45, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 0x20, 
	/* 0x e0 */ 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 
	/* 0x e8 */ 0x79, 0x20, 0x58, 0x33, 0x30, 0x82, 0x01, 0x22, 
	/* 0x f0 */ 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
	/* 0x f8 */ 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 
	/* 0x100 */ 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82, 0x01, 0x0A, 
	/* 0x108 */ 0x02, 0x82, 0x01, 0x01, 0x00, 0x9C, 0xD3, 0x0C, 
	/* 0x110 */ 0xF0, 0x5A, 0xE5, 0x2E, 0x47, 0xB7, 0x72, 0x5D, 
	/* 0x118 */ 0x37, 0x83, 0xB3, 0x68, 0x63, 0x30, 0xEA, 0xD7, 
	/* 0x120 */ 0x35, 0x26, 0x19, 0x25, 0xE1, 0xBD, 0xBE, 0x35, 
	/* 0x128 */ 0xF1, 0x70, 0x92, 0x2F, 0xB7, 0xB8, 0x4B, 0x41, 
	/* 0x130 */ 0x05, 0xAB, 0xA9, 0x9E, 0x35, 0x08, 0x58, 0xEC, 
	/* 0x138 */ 0xB1, 0x2A, 0xC4, 0x68, 0x87, 0x0B, 0xA3, 0xE3, 
	/* 0x140 */ 0x75, 0xE4, 0xE6, 0xF3, 0xA7, 0x62, 0x71, 0xBA, 
	/* 0x148 */ 0x79, 0x81, 0x60, 0x1F, 0xD7, 0x91, 0x9A, 0x9F, 
	/* 0x150 */ 0xF3, 0xD0, 0x78, 0x67, 0x71, 0xC8, 0x69, 0x0E, 
	/* 0x158 */ 0x95, 0x91, 0xCF, 0xFE, 0xE6, 0x99, 0xE9, 0x60, 
	/* 0x160 */ 0x3C, 0x48, 0xCC, 0x7E, 0xCA, 0x4D, 0x77, 0x12, 
	/* 0x168 */ 0x24, 0x9D, 0x47, 0x1B, 0x5A, 0xEB, 0xB9, 0xEC, 
	/* 0x170 */ 0x1E, 0x37, 0x00, 0x1C, 0x9C, 0xAC, 0x7B, 0xA7, 
	/* 0x178 */ 0x05, 0xEA, 0xCE, 0x4A, 0xEB, 0xBD, 0x41, 0xE5, 
	/* 0x180 */ 0x36, 0x98, 0xB9, 0xCB, 0xFD, 0x6D, 0x3C, 0x96, 
	/* 0x188 */ 0x68, 0xDF, 0x23, 0x2A, 0x42, 0x90, 0x0C, 0x86, 
	/* 0x190 */ 0x74, 0x67, 0xC8, 0x7F, 0xA5, 0x9A, 0xB8, 0x52, 
	/* 0x198 */ 0x61, 0x14, 0x13, 0x3F, 0x65, 0xE9, 0x82, 0x87, 
	/* 0x1a0 */ 0xCB, 0xDB, 0xFA, 0x0E, 0x56, 0xF6, 0x86, 0x89, 
	/* 0x1a8 */ 0xF3, 0x85, 0x3F, 0x97, 0x86, 0xAF, 0xB0, 0xDC, 
	/* 0x1b0 */ 0x1A, 0xEF, 0x6B, 0x0D, 0x95, 0x16, 0x7D, 0xC4, 
	/* 0x1b8 */ 0x2B, 0xA0, 0x65, 0xB2, 0x99, 0x04, 0x36, 0x75, 
	/* 0x1c0 */ 0x80, 0x6B, 0xAC, 0x4A, 0xF3, 0x1B, 0x90, 0x49, 
	/* 0x1c8 */ 0x78, 0x2F, 0xA2, 0x96, 0x4F, 0x2A, 0x20, 0x25, 
	/* 0x1d0 */ 0x29, 0x04, 0xC6, 0x74, 0xC0, 0xD0, 0x31, 0xCD, 
	/* 0x1d8 */ 0x8F, 0x31, 0x38, 0x95, 0x16, 0xBA, 0xA8, 0x33, 
	/* 0x1e0 */ 0xB8, 0x43, 0xF1, 0xB1, 0x1F, 0xC3, 0x30, 0x7F, 
	/* 0x1e8 */ 0xA2, 0x79, 0x31, 0x13, 0x3D, 0x2D, 0x36, 0xF8, 
	/* 0x1f0 */ 0xE3, 0xFC, 0xF2, 0x33, 0x6A, 0xB9, 0x39, 0x31, 
	/* 0x1f8 */ 0xC5, 0xAF, 0xC4, 0x8D, 0x0D, 0x1D, 0x64, 0x16, 
	/* 0x200 */ 0x33, 0xAA, 0xFA, 0x84, 0x29, 0xB6, 0xD4, 0x0B, 
	/* 0x208 */ 0xC0, 0xD8, 0x7D, 0xC3, 0x93, 0x02, 0x03, 0x01, 
	/* 0x210 */ 0x00, 0x01, 0xA3, 0x82, 0x01, 0x67, 0x30, 0x82, 
	/* 0x218 */ 0x01, 0x63, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x220 */ 0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 
	/* 0x228 */ 0x01, 0x86, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1D, 
	/* 0x230 */ 0x13, 0x01, 0x01, 0xFF, 0x04, 0x08, 0x30, 0x06, 
	/* 0x238 */ 0x01, 0x01, 0xFF, 0x02, 0x01, 0x00, 0x30, 0x54, 
	/* 0x240 */ 0x06, 0x03, 0x55, 0x1D, 0x20, 0x04, 0x4D, 0x30, 
	/* 0x248 */ 0x4B, 0x30, 0x08, 0x06, 0x06, 0x67, 0x81, 0x0C, 
	/* 0x250 */ 0x01, 0x02, 0x01, 0x30, 0x3F, 0x06, 0x0B, 0x2B, 
	/* 0x258 */ 0x06, 0x01, 0x04, 0x01, 0x82, 0xDF, 0x13, 0x01, 
	/* 0x260 */ 0x01, 0x01, 0x30, 0x30, 0x30, 0x2E, 0x06, 0x08, 
	/* 0x268 */ 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x02, 0x01, 
	/* 0x270 */ 0x16, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 
	/* 0x278 */ 0x2F, 0x63, 0x70, 0x73, 0x2E, 0x72, 0x6F, 0x6F, 
	/* 0x280 */ 0x74, 0x2D, 0x78, 0x31, 0x2E, 0x6C, 0x65, 0x74, 
	/* 0x288 */ 0x73, 0x65, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 
	/* 0x290 */ 0x2E, 0x6F, 0x72, 0x67, 0x30, 0x1D, 0x06, 0x03, 
	/* 0x298 */ 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0xA8, 
	/* 0x2a0 */ 0x4A, 0x6A, 0x63, 0x04, 0x7D, 0xDD, 0xBA, 0xE6, 
	/* 0x2a8 */ 0xD1, 0x39, 0xB7, 0xA6, 0x45, 0x65, 0xEF, 0xF3, 
	/* 0x2b0 */ 0xA8, 0xEC, 0xA1, 0x30, 0x33, 0x06, 0x03, 0x55, 
	/* 0x2b8 */ 0x1D, 0x1F, 0x04, 0x2C, 0x30, 0x2A, 0x30, 0x28, 
	/* 0x2c0 */ 0xA0, 0x26, 0xA0, 0x24, 0x86, 0x22, 0x68, 0x74, 
	/* 0x2c8 */ 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x63, 0x72, 0x6C, 
	/* 0x2d0 */ 0x2E, 0x72, 0x6F, 0x6F, 0x74, 0x2D, 0x78, 0x31, 
	/* 0x2d8 */ 0x2E, 0x6C, 0x65, 0x74, 0x73, 0x65, 0x6E, 0x63, 
	/* 0x2e0 */ 0x72, 0x79, 0x70, 0x74, 0x2E, 0x6F, 0x72, 0x67, 
	/* 0x2e8 */ 0x30, 0x72, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 
	/* 0x2f0 */ 0x05, 0x07, 0x01, 0x01, 0x04, 0x66, 0x30, 0x64, 
	/* 0x2f8 */ 0x30, 0x30, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 
	/* 0x300 */ 0x05, 0x07, 0x30, 0x01, 0x86, 0x24, 0x68, 0x74, 
	/* 0x308 */ 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6F, 0x63, 0x73, 
	/* 0x310 */ 0x70, 0x2E, 0x72, 0x6F, 0x6F, 0x74, 0x2D, 0x78, 
	/* 0x318 */ 0x31, 0x2E, 0x6C, 0x65, 0x74, 0x73, 0x65, 0x6E, 
	/* 0x320 */ 0x63, 0x72, 0x79, 0x70, 0x74, 0x2E, 0x6F, 0x72, 
	/* 0x328 */ 0x67, 0x2F, 0x30, 0x30, 0x06, 0x08, 0x2B, 0x06, 
	/* 0x330 */ 0x01, 0x05, 0x05, 0x07, 0x30, 0x02, 0x86, 0x24, 
	/* 0x338 */ 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x63, 
	/* 0x340 */ 0x65, 0x72, 0x74, 0x2E, 0x72, 0x6F, 0x6F, 0x74, 
	/* 0x348 */ 0x2D, 0x78, 0x31, 0x2E, 0x6C, 0x65, 0x74, 0x73, 
	/* 0x350 */ 0x65, 0x6E, 0x63, 0x72, 0x79, 0x70, 0x74, 0x2E, 
	/* 0x358 */ 0x6F, 0x72, 0x67, 0x2F, 0x30, 0x1F, 0x06, 0x03, 
	/* 0x360 */ 0x55, 0x1D, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 
	/* 0x368 */ 0x14, 0x79, 0xB4, 0x59, 0xE6, 0x7B, 0xB6, 0xE5, 
	/* 0x370 */ 0xE4, 0x01, 0x73, 0x80, 0x08, 0x88, 0xC8, 0x1A, 
	/* 0x378 */ 0x58, 0xF6, 0xE9, 0x9B, 0x6E, 0x30, 0x0D, 0x06, 
	/* 0x380 */ 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 
	/* 0x388 */ 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 
	/* 0x390 */ 0x00, 0x19, 0xCF, 0x75, 0x20, 0x34, 0x2D, 0x3A, 
	/* 0x398 */ 0xA6, 0x45, 0xFF, 0xD0, 0xD5, 0xE6, 0x8C, 0xDA, 
	/* 0x3a0 */ 0x32, 0xE8, 0x9C, 0x6E, 0x1B, 0x41, 0xD1, 0x27, 
	/* 0x3a8 */ 0xA8, 0xE2, 0x50, 0xF2, 0x70, 0xAA, 0xC4, 0xE7, 
	/* 0x3b0 */ 0x93, 0x46, 0xB4, 0xE8, 0x10, 0xAB, 0x70, 0x4F, 
	/* 0x3b8 */ 0xEF, 0xB7, 0xEA, 0x04, 0xD2, 0x94, 0x11, 0xB1, 
	/* 0x3c0 */ 0x03, 0xFE, 0x5D, 0xBA, 0xDF, 0x36, 0x8C, 0x94, 
	/* 0x3c8 */ 0x36, 0x8F, 0x13, 0x7C, 0x44, 0x8F, 0x0B, 0xF5, 
	/* 0x3d0 */ 0x01, 0x57, 0xAD, 0x68, 0xB8, 0xC5, 0x79, 0xC0, 
	/* 0x3d8 */ 0xD8, 0x4A, 0x80, 0xD7, 0x4C, 0xA3, 0x1E, 0x24, 
	/* 0x3e0 */ 0x7A, 0x1F, 0xD7, 0x23, 0xE8, 0xC1, 0x62, 0x3A, 
	/* 0x3e8 */ 0x76, 0xF9, 0x22, 0x7D, 0x5E, 0x5A, 0xC4, 0x4C, 
	/* 0x3f0 */ 0x50, 0xCD, 0xAF, 0xDD, 0xEF, 0x6D, 0x36, 0xC0, 
	/* 0x3f8 */ 0x80, 0x80, 0x1B, 0xA4, 0x3C, 0x70, 0x20, 0xD6, 
	/* 0x400 */ 0x54, 0x21, 0xD3, 0xBA, 0xEF, 0x14, 0xA9, 0xBF, 
	/* 0x408 */ 0x07, 0x3F, 0x41, 0x0A, 0x36, 0xB1, 0xA2, 0xB0, 
	/* 0x410 */ 0x0B, 0x20, 0xD5, 0x1F, 0x67, 0xD0, 0xC3, 0xEB, 
	/* 0x418 */ 0x88, 0xF6, 0x8A, 0x02, 0xC8, 0xC6, 0x57, 0xB6, 
	/* 0x420 */ 0x0C, 0xFC, 0x56, 0xF1, 0xD2, 0x3F, 0x17, 0x69, 
	/* 0x428 */ 0x68, 0x1C, 0xC8, 0xD7, 0x66, 0x3A, 0x86, 0xF1, 
	/* 0x430 */ 0x19, 0x2A, 0x65, 0x47, 0x68, 0xC6, 0xD2, 0x03, 
	/* 0x438 */ 0xE7, 0xEF, 0x74, 0x16, 0x0B, 0x06, 0x21, 0xF9, 
	/* 0x440 */ 0x0C, 0xA6, 0xA8, 0x11, 0x4B, 0x4E, 0x5F, 0xE3, 
	/* 0x448 */ 0x33, 0xDB, 0x08, 0x41, 0xEA, 0x09, 0x79, 0x75, 
	/* 0x450 */ 0x78, 0xEE, 0x47, 0xC8, 0x42, 0xD3, 0x81, 0xC5, 
	/* 0x458 */ 0x65, 0x2D, 0x75, 0xD0, 0x0E, 0x00, 0x16, 0x9D, 
	/* 0x460 */ 0x1C, 0xEE, 0xB7, 0x58, 0x45, 0x25, 0xE7, 0x33, 
	/* 0x468 */ 0x63, 0x5B, 0x63, 0x41, 0x09, 0xE8, 0xE9, 0xFE, 
	/* 0x470 */ 0xAC, 0xFA, 0x73, 0x32, 0x74, 0xB3, 0x76, 0xE9, 
	/* 0x478 */ 0x6B, 0x94, 0xE2, 0xCD, 0xD4, 0x62, 0xF3, 0xAE, 
	/* 0x480 */ 0x3A, 0xC5, 0x31, 0x46, 0x52, 0x6E, 0xED, 0x34, 
	/* 0x488 */ 0x91, 0x1E, 0xA0, 0xC2, 0xDE, 0x54, 0x84, 0xE5, 
	/* 0x490 */ 0x78, 0x20, 0x56, 0x4C, 0xDD, 0x68, 0xF9, 0x2E, 
	/* 0x498 */ 0x28, 0x64, 0x1B, 0x1A, 0x99, 0xF2, 0xFB, 0x4D, 
	/* 0x4a0 */ 0x7F, 0xE3, 0xB8, 0x5F, 0x5D, 0x73, 0x41, 0xEC, 
	/* 0x4a8 */ 0x79, 0xED, 0x58, 0xD6, 0x7A, 0x37, 0x65, 0x70, 
	/* 0x4b0 */ 0xA7, 0xB1, 0xBA, 0x39, 0xF6, 0x3E, 0x61, 0x0A, 
	/* 0x4b8 */ 0xD9, 0xC0, 0x86, 0x90, 0x9A, 0x1A, 0xC8, 0xA8, 
	/* 0x4c0 */ 0x96, 0x6E, 0x8A, 0x0B, 0x2B, 0x6D, 0xED, 0xD6, 
	/* 0x4c8 */ 0xFA, 0x07, 0x67, 0xE7, 0x29, 0x04, 0xF7, 0xE2, 
	/* 0x4d0 */ 0xB2, 0xD1, 0x58, 0x15, 0x52, 0xC7, 0xF1, 0xA3, 
	/* 0x4d8 */ 0x9D, 0xA6, 0xC0, 0x56, 0x2C, 0xD4, 0x92, 0x98, 
	/* 0x4e0 */ 0xD8, 0xF1, 0x83, 0xB9, 0x6C, 0x7C, 0x33, 0xA0, 
	/* 0x4e8 */ 0xE5, 0x4B, 0xAA, 0x90, 0x92, 0xF1, 0xDA, 0x45, 
	/* 0x4f0 */ 0x4A, 0x34, 0x14, 0xC7, 0x7C, 0x4E, 0xC4, 0xA5, 
	/* 0x4f8 */ 0x6C, 0x5D, 0x3F, 0xBF, 0xDE, 0xB9, 0xA8, 0x61, 
	/* 0x500 */ 0x4A, 0x85, 0x20, 0xDE, 0x42, 0x83, 0x29, 0x62, 
	/* 0x508 */ 0x7C, 0x1C, 0x99, 0x08, 0xA5, 0x46, 0x1F, 0xF4, 
	/* 0x510 */ 0x6B, 0x22, 0xD3, 0x86, 0x51, 0xCB, 0x37, 0xCD, 
	/* 0x518 */ 0x60, 0x4A, 0x42, 0x63, 0x56, 0xB3, 0xC8, 0xD1, 
	/* 0x520 */ 0x8F, 0x31, 0x09, 0x53, 0xC1, 0xE2, 0xDC, 0x1B, 
	/* 0x528 */ 0xD4, 0xF1, 0x54, 0x77, 0x67, 0xCF, 0x33, 0x7B, 
	/* 0x530 */ 0x00, 0xD6, 0xD2, 0x7C, 0xDE, 0xC6, 0x79, 0xBF, 
	/* 0x538 */ 0xCB, 0xE0, 0x16, 0xFD, 0xB2, 0xA1, 0xF2, 0x91, 
	/* 0x540 */ 0x3C, 0x1D, 0x2D, 0xE8, 0x9C, 0xD4, 0x03, 0xCD, 
	/* 0x548 */ 0x66, 0x4A, 0xA3, 0x37, 0x93, 0x19, 0x79, 0x7B, 
	/* 0x550 */ 0xE2, 0x19, 0xC2, 0x16, 0x00, 0xC8, 0xED, 0x0E, 
	/* 0x558 */ 0x4E, 0x0D, 0xFF, 0x7E, 0xCF, 0x07, 0xA8, 0x64, 
	/* 0x560 */ 0xCD, 0x29, 0xDF, 0x41, 0xAA, 0x85, 0x30, 0x49, 
	/* 0x568 */ 0x10, 0x73, 0xA7, 0x4E, 0x89, 0x32, 0x0E, 0x5B, 
	/* 0x570 */ 0xAD, 0x40, 0x86, 0xC1, 0xB0, 0x94, 0x0C, 0x8D, 
	/* 0x578 */ 0x26, 0xC5, 0xA7, 0x49, 0xDC, 0x1C, 0xF8, 0x5B, 
	/* 0x580 */ 0x14, 0x7A, 0x7F, 0x23, 0x69, 0x04, 0xAD, 0xB2, 
	/* 0x588 */ 0x02, 0x29, 0xD6, 0x12, 0xC8, 0xA4, 0xC6, 0xA1, 
	/* 0x590 */ 0x2D, 
};
static const lws_ss_x509_t _ss_x509_LEX3_isrg_root_x1 = {
	.vhost_name = "LEX3_isrg_root_x1",
	.ca_der = _ss_der_LEX3_isrg_root_x1,
	.ca_der_len = 1425,
};
static const lws_ss_trust_store_t _ss_ts_le_via_isrg = {
	.name = "le_via_isrg",
	.ssx509 = {
		&_ss_x509_LEX3_isrg_root_x1,
		&_ss_x509_isrg_root_x1,
	}
};

static const lws_ss_policy_t _ssp_captive_portal_detect = {
	.streamtype = "captive_portal_detect",
	.endpoint = "connectivitycheck.android.com",
	.u = {
		.http = {
			.method = "GET",
			.url = "generate_204",
			.resp_expect = 204,
			.fail_redirect = 1,
		}
	},
	.flags = 0x1,
	.port = 80,
	.protocol = 0,
},
_ssp_test_stream = {
	.next = (void *)&_ssp_captive_portal_detect,
	.streamtype = "test_stream",
	.endpoint = "warmcat.com",
	.u = {
		.http = {
			.method = "GET",
			.url = "index.html",
		}
	},
	.retry_bo = &_rbo_0,
	.flags = 0x11,
	.port = 443,
	.protocol = 1,
	.trust = {.store = &_ss_ts_le_via_isrg},
};
#define _ss_static_policy_entry _ssp_test_stream
/* estimated footprint 3412 (when sizeof void * = 8) */
