// This software is released into the Public Domain.  See copying.txt for details.
package org.openstreetmap.osmosis.core.pipeline.v0_6;

import java.util.Map;

import org.openstreetmap.osmosis.core.pipeline.common.PassiveTaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.PipeTasks;
import org.openstreetmap.osmosis.core.task.v0_6.SinkMultiSource;
import org.openstreetmap.osmosis.core.task.v0_6.Source;


/**
 * A task manager implementation for task performing sink and multi source
 * functionality.
 * 
 * @author Brett Henderson
 */
public class SinkMultiSourceManager extends PassiveTaskManager {
	private SinkMultiSource task;
	
	
	/**
	 * Creates a new instance.
	 * 
	 * @param taskId
	 *            A unique identifier for the task. This is used to produce
	 *            meaningful errors when errors occur.
	 * @param task
	 *            The task instance to be managed.
	 * @param pipeArgs
	 *            The arguments defining input and output pipes for the task,
	 *            pipes are a logical concept for identifying how the tasks are
	 *            connected together.
	 */
	public SinkMultiSourceManager(String taskId, SinkMultiSource task, Map<String, String> pipeArgs) {
		super(taskId, pipeArgs);
		
		this.task = task;
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void connect(PipeTasks pipeTasks) {
		Source source;
		int taskSourceCount;
		
		// Get the input task. A sink only has one input, this corresponds to
		// pipe index 0.
		source = (Source) getInputTask(pipeTasks, 0, Source.class);
		
		// Cast the input feed to the correct type.
		// Connect the tasks.
		source.setSink(task);
		
		// Register all the sources provided by this task as outputs.
		taskSourceCount = task.getSourceCount();
		for (int i = 0; i < taskSourceCount; i++) {
			setOutputTask(pipeTasks, task.getSource(i), i);
		}
	}
}
