/* 
 * +-------------------------------------------------------+
 * |                                                       |
 * |     videogen                                          |
 * |                                                       |
 * |     a simple XFree86 Modeline calculator              |
 * |     (c) 1997-2003, Szabolcs Rumi                      |   
 * |                                                       |
 * |     http://www.dynaweb.hu/opensource/videogen         |
 * |                                                       |
 * |     the videogen package is distributed under the     |
 * |     GNU General Public License Version 2 (GPLv2)      |
 * |                                                       |
 * +-------------------------------------------------------+   
 */

#ifndef VIDEOGEN_H
# define VIDEOGEN_H





#define ERR_SYSTEM	100	/* environmental or system error */
#define ERR_CMDLINE	101	/* command line error */
#define ERR_CFGFILE	102	/* config file error */
#define ERR_RES		103	/* bad resolution */
#define ERR_MDC		104	/* bad max dot clock */
#define ERR_MHF		105	/* bad max horizontal freq */
#define ERR_MVF		106	/* bad max vertical freq */



#define VL_QUIET	0
#define VL_VERBOSE	1
#define VL_DEBUG	2





typedef struct {
	unsigned int hres;
	unsigned int vres;
} resolution_t;

extern char *cfgfile;
extern unsigned int verbose;
extern unsigned int fbset;
extern unsigned int nvidia;
extern unsigned int num_modes;
extern resolution_t modes[];
extern double max_dotclk;
extern double max_hfreq;
extern double max_vfreq;
extern double desired_vfreq;
extern double hvisible;
extern double vvisible;
extern double hfporch;
extern double hbporch;
extern double hsync;
extern double vfporch;
extern double vbporch;
extern double vsync;



extern void banner (void);
extern void usage (void);

extern int pmsg (int, char *, ...);
extern char *tpathexp (char *, char *);





#define ARG_FOUND		0x1
#define ARG_FOUND_PARM		0x2

typedef struct
{
	char *ao_option;		/* option string to be matched */
	char *ao_parameter;		/* argument parameter parsed */
	int ao_flags;			/* flags */
}
arg_opt_t;

typedef struct
{
	int aindex;			/* command line argument currently examined */
	int oindex;			/* option the current argument is believed to match */

	int argc;			/* argc to be parsed */
	char **argv;			/* argv to be parsed */

	arg_opt_t (*options)[];		/* pre-defined options list */
}
arg_parse_t;

extern arg_opt_t opts[];
extern int arg_action (arg_parse_t *);
extern int arg_parse (arg_parse_t *, int (*) (arg_parse_t *));



extern int commit_verbose (int, unsigned int *, unsigned int);
extern int commit_fbset (int, unsigned int *, unsigned int);
extern int commit_nvidia (int, unsigned int *, unsigned int);
extern int commit_mode (int, resolution_t (*)[], unsigned int *, unsigned int, unsigned int);
extern int commit_max_dotclk (int, double *, double);
extern int commit_max_hfreq (int, double *, double);
extern int commit_max_vfreq (int, double *, double);
extern int commit_desired_vfreq (int, double *, double);
extern int commit_hvisible (int, double *, double);
extern int commit_vvisible (int, double *, double);
extern int commit_hfporch (int, double *, double);
extern int commit_hbporch (int, double *, double);
extern int commit_hsync (int, double *, double);
extern int commit_vfporch (int, double *, double);
extern int commit_vbporch (int, double *, double);
extern int commit_vsync (int, double *, double);





#endif /* !VIDEOGEN_H */
/* EOF */
