/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DifferenceEvaluator;

public final class DifferenceEvaluators {
    private static final Short CDATA = 3;
    private static final Short TEXT = 4;
    public static final DifferenceEvaluator Accept = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            return outcome;
        }
    };
    public static final DifferenceEvaluator Default = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (outcome == ComparisonResult.DIFFERENT) {
                switch (comparison.getType()) {
                    case NODE_TYPE: {
                        Short control = (Short)comparison.getControlDetails().getValue();
                        Short test = (Short)comparison.getTestDetails().getValue();
                        if ((!control.equals(TEXT) || !test.equals(CDATA)) && (!control.equals(CDATA) || !test.equals(TEXT))) break;
                        outcome = ComparisonResult.SIMILAR;
                        break;
                    }
                    case HAS_DOCTYPE_DECLARATION: 
                    case DOCTYPE_SYSTEM_ID: 
                    case SCHEMA_LOCATION: 
                    case NO_NAMESPACE_SCHEMA_LOCATION: 
                    case NAMESPACE_PREFIX: 
                    case ATTR_VALUE_EXPLICITLY_SPECIFIED: 
                    case CHILD_NODELIST_SEQUENCE: 
                    case XML_ENCODING: {
                        outcome = ComparisonResult.SIMILAR;
                    }
                }
            }
            return outcome;
        }
    };

    private DifferenceEvaluators() {
    }

    public static DifferenceEvaluator first(final DifferenceEvaluator ... evaluators) {
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                for (DifferenceEvaluator ev : evaluators) {
                    ComparisonResult evaluated = ev.evaluate(comparison, orig);
                    if (evaluated == orig) continue;
                    return evaluated;
                }
                return orig;
            }
        };
    }

    public static DifferenceEvaluator chain(final DifferenceEvaluator ... evaluators) {
        return new DifferenceEvaluator(){

            @Override
            public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
                ComparisonResult finalResult = orig;
                for (DifferenceEvaluator ev : evaluators) {
                    ComparisonResult evaluated;
                    finalResult = evaluated = ev.evaluate(comparison, finalResult);
                }
                return finalResult;
            }
        };
    }
}

