[
  [
    "https://cas.cgcent.miami.edu/idp/shibboleth", 
    {
      "entity_id": "https://cas.cgcent.miami.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cas.cgcent.miami.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cas.cgcent.miami.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cas.cgcent.miami.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "miami.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "zTest_University of Miami", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDOzCCAiOgAwIBAgIUENN7pIAppEM5kpFqfJ0yapfX/lgwDQYJKoZIhvcNAQEF\nBQAwHzEdMBsGA1UEAxMUY2FzLmNnY2VudC5taWFtaS5lZHUwHhcNMTEwNjE1MTMy\nNjExWhcNMzEwNjE1MTMyNjExWjAfMR0wGwYDVQQDExRjYXMuY2djZW50Lm1pYW1p\nLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJ+Y4nj/hU3gkyyy\nDrXqooTIuSZfnlNORDNhhiBHlDZ6hZuMfxeQ2Rlq00lkSS7bNHGZBlf9Wj2dtkDZ\n7xqyqtLFT1Pfnn+wQ3ordhAagOx1sh8Re/clsbPDfH6lhnf669uNxR3uoCM2/kLV\n9WKWXjhYgq6bP7521sGNYJrz7dDB+Kk1zRiYnT8NtbcBoWyWpHffbnPY3nqhiyvL\ncd9dyQdcfymMf6HLnQZmcOdZJSdpgQRJ7vUKTLqKn6lEVgweqTJscURo89Ef73Bs\nNOLXZ3gaKp40wxUmYv2u5EG9vazigo5A8E7L3ahmEIULkQS2wBxiYDIyGUYQXnB2\nSW45bJMCAwEAAaNvMG0wTAYDVR0RBEUwQ4IUY2FzLmNnY2VudC5taWFtaS5lZHWG\nK2h0dHBzOi8vY2FzLmNnY2VudC5taWFtaS5lZHUvaWRwL3NoaWJib2xldGgwHQYD\nVR0OBBYEFCX0KLFqcbwPHS4lBV5ynBkOjkJdMA0GCSqGSIb3DQEBBQUAA4IBAQAE\n+INXRGUhPoYzJuRcmhmAMXqpMVPcZGJm4jx/Kd4JE7bYgpWgLULLm4nVAptIOS6y\nZ6kaQpf0wQApCLb5mqofcqfzIVsqhcQ9jpzcP1cMFgRkl2D8WbgSnT4PoObCjsU/\n7vEkNaAQ5EZz1+N/5fzvUs8kLJagjyTMTNcMxvGlAVE7OY/SF8aN6InvKH8L440z\nC0CCRFh4Nv4ABEh4J9zCETIuv5x5X+73JBTm/Lqv77wlHDIo5u3gQMKRC8zHn7xv\nIsLKXZxJPuY1fEpWPmB2KT8oMw7oTbO92Jskpie62r7N3dnb2J1OMHevgm7DOP+D\nRPbHcgoMCemXOUYD6n4c", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cas.cgcent.miami.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cas.cgcent.miami.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Miami", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "zTest_University of Miami", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.miami.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Anil Kadiyala", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "akadiyala@miami.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://srrs.library.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://srrs.library.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Kenneth Rose", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kr2e@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://srrs.library.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Library Room Reservation Server", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDAzCCAeugAwIBAgIJAIOfpvBRiCUaMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFHNycnMubGlicmFyeS5jbXUuZWR1MB4XDTEzMDYyMDE0NTMwMloXDTIzMDYx\nODE0NTMwMlowHzEdMBsGA1UEAxMUc3Jycy5saWJyYXJ5LmNtdS5lZHUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNtBNUfeVShYQS0AVRxBFivP9cjm/K\nsoyL+FO/1POtLUySEQe6RxBrFcPOiAzuTTWMCSJUHM1RKXBUmFZvztqV5JH8Wrb5\nnLPyHgOvf5iBbdmhDM9GJJwLOywydgms46ZoSC8eaZohEPsE/z9N67xkDzQpcFTX\npKL9bHXdVRN2j76CA3TYzectWpvExQ9AmQ4RuAVWy4dZw8RA/I85Bpe/F+kKqSug\nZsw2yWxBGzdf6XCN3BvQ+3jjdPgcD1+RZoJrZjDNwKme3KRmjHBGTX6d+mFny0oT\nbig9R16AK8ubx1pVC+PSTT7h9U5zpljkHKcdYVew/2+thfVBbU+gY2IZAgMBAAGj\nQjBAMB8GA1UdEQQYMBaCFHNycnMubGlicmFyeS5jbXUuZWR1MB0GA1UdDgQWBBR5\n93qH2TbG8OaaUUmTmHbJ3tDeLzANBgkqhkiG9w0BAQUFAAOCAQEARjQ+piH8YsBQ\np7o4DHmRWjDoXvMLrP4clnLQCn7roH6lCsXTDAtcNFBGLuDkhm906vodxBAWFKGJ\nTDisKE5fEIPM+cpYQDvFAkG1zd8ZHYNjbzm2mhYRN5lWoKOIB2P1PHpIWHsa820k\nq/fVUs9bYa5yaScsbz4kAUZgD6UAT1mmV3NUP7ASCWe3JzGN2haeZ1KCE6qOU/PI\nyYQo68O1jsmOA3pn0VByeNRyxASQUjOYEn3wNyLatUnyq1t4/9W4db2jphLyFaqn\nJ8flAp03m8ZSLR+ydHb+VjW/BD2UhLPnxXFfcGyR7FgLTTPoCmzBJ/1Tj0BjlDLm\nzfwYf43xnQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://srrs.library.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://srrs.library.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://srrs.library.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://srrs.library.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://srrs.library.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://srrs.library.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://secure.stevenson.edu/idp/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Stevenson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Stevenson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://stevenson.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://secure.stevenson.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "contact_person": [
        {
          "given_name": {
            "text": "Philip Desrosiers", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "pdesrosiers@stevenson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Philip Desrosiers", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "pdesrosiers@stevenson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://secure.stevenson.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://secure.stevenson.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://secure.stevenson.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://secure.stevenson.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "stevenson.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Stevenson University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDPDCCAiSgAwIBAgIVAKgovFDN1fBUWFA+v7d4R+4C2FLWMA0GCSqGSIb3DQEB\nBQUAMB8xHTAbBgNVBAMTFHNlY3VyZS5zdGV2ZW5zb24uZWR1MB4XDTEyMDcxODE4\nNDUyNFoXDTMyMDcxODE4NDUyNFowHzEdMBsGA1UEAxMUc2VjdXJlLnN0ZXZlbnNv\nbi5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCSvX4t9W3UxKym\nQv9OKQzPSE2f/a6e5AjIa+a8A7V/Zt7u5AzFMyRsfARKGI24GrWTer9fJHvI4wTD\nOhqufNOjV3fNu570+HL1W9d/1ueM4ztmoh5jiWF4JxhxVTjJwBPkx2bkv7R10nI5\nl2HaRNyPSUSOSH3U9L0jN/a/KY97rOuM66fQ4V79L+g09C6XVxyqJrKBvryjk0f0\n5E/Ua8JcAZlgf0y200x5YdcZADjF8DwUtfEItUJ1FdxOnwXjbVDIcK02+J4Os3vT\nveZ0gmeRxsj9jAvZh44qjJlW2aFElFiE+PvE5QPhheSAx7LahyRM8Y9JWAhUD4JU\ngzsimD8xAgMBAAGjbzBtMEwGA1UdEQRFMEOCFHNlY3VyZS5zdGV2ZW5zb24uZWR1\nhitodHRwczovL3NlY3VyZS5zdGV2ZW5zb24uZWR1L2lkcC9zaGliYm9sZXRoMB0G\nA1UdDgQWBBR5zC5WIV6lZzMAYwPbhfWgZN2omTANBgkqhkiG9w0BAQUFAAOCAQEA\nEpMtRKoKGLYWI+5ltPGqL7nhMzsqnlwLXP5cMLFN+FCxwa7kBi1fk//NCleLoaf7\nBiYxMqq3cDh1vhaklyr+NC3iwXGAbi6/D74rFksOhePX05xdAIi83s+6ImJXC+Gk\njPgB9Pyd+NV6S1CkehB2fCDRE8bMBOInspa1eszMqUUmJcfOg3jqYfnUMsk6rgKG\nQUqhM9TAwowIJzUEfJcwkNrCkBAzuUIG/R9zgi/wWARXSBdpvRwTeh2feHIoRrlL\nBVngyd850gsxHeIyUveI6rZDsRI6MozOP7ApzA482aHh8YHlekMh+mDafbuYDtMV\nvcW4oD4N2OIPcMam+7V1yw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://secure.stevenson.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://secure.stevenson.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth-wustl-csm.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-wustl-csm.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFtzCCBJ+gAwIBAgICAmgwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgwNTE3NTYzOFoXDTExMDgw\nNjE3NTYzOFowLjEsMCoGA1UEAxMjc2hpYmJvbGV0aC13dXN0bC1jc20uc3ltcGxp\nY2l0eS5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCmGtOp9IM6\nZswZbY32miCFM3ZneF7t1y6ltOSh5rThdmys/fdVLXrmJeuX7ZjX6qIfWx5ImQRf\nb7J2yaEfCqCuXPFF4fHBze7D4gLYqA/N4yIOluVnTFjKekq8FaGqKyW7XUf9Lk54\nY3e5pM6adThYxT8v1Cr92B1HhzTi9+C6hFhf8R35+qCTa62bJeLBawCl6xzB85FJ\nHVcarjOcoHbTm3u+jZ9YRWxIyTTIgHy11jV00LpPua2pDpJ/PKnrGHSgS2bJstXR\nztdBexj1H8/lWaPGmu1bEinX5e/dvql/IsoDOphfxtcF7VPpuGeRN68+Jbvp3MZJ\nIipJnKfpRx31AgMBAAGjggK1MIICsTAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/\nBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFLk5\nAgPYEBcD3S5VoAQ4qQK2qLhpMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rn\nymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJh\ndGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmC\nAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21t\nb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2Vy\ndHMucDdiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3Js\nMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARX\nMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9u\nY2EuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMC4GA1UdEQQn\nMCWCI3NoaWJib2xldGgtd3VzdGwtY3NtLnN5bXBsaWNpdHkuY29tMA0GCSqGSIb3\nDQEBBQUAA4IBAQA5tk1tgWCW61TgPaqDKA2vyMtV33xY3YTpUmCfg/qBJreXKJ4N\npGGu66ZE1dIxPjnJdYSb3cjfN5gjVFDe6f87nwEa48e4i/7EqCDQGwlbRyJrQdKR\nVn+2WyXhUSE9j/TOMutK9GUfazv4ZQabEDOcQWIwgdtSvFMDEVAs9iMDRAXPjhKX\niv/9WRA3n9sCOebinOrGCVIJlQG761u3GgOHMTUROs3x80jetrYThboJKnDRQyjt\n0Tn1dckQzJpkZELuDerD9SfQGZbrw9mD6Q1m+kzYzWGzkYoCmHW4eleARgIpnZc8\nJdLlMx1hDCSTZ7aqhbD6TlkxNSg6Jd3b1lrK", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-wustl-csm.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-wustl-csm.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://sp-dev.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://sp-dev.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jeffrey Eaton", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jeaton@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "SP Development Server", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDBjCCAe6gAwIBAgIJANXq2K1GVoZxMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXNwLWRldi5hbmRyZXcuY211LmVkdTAeFw0xMjA4MjQxNTM2MjhaFw0yMjA4\nMjIxNTM2MjhaMCAxHjAcBgNVBAMTFXNwLWRldi5hbmRyZXcuY211LmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOEFhsXXx1YLz4HkPYJV50qXeuUB\nsMatKxRXp6hNNgo8gjzIytQxIi8v6C1fPtG8TrwmotXh8HPcRCQ30vweMOozXcfN\ngDoMc5wb5GtkgaeFwaQmWX6a0gDtF/SVf1P2gKjKDW1mtAh67bYhh26CgfSKAqaT\nC+rSoIH3dQ6v92I05ls6U2GR4kdDL6Zw+Zo8X9855nlNBNQ6dyPU0NQI2lw6Dd3t\nBWA67SYyxLs0+VJzl2tT7afVhyUNJAb+vD3qIIF6F3hi4Mtq3w/KV3ZWhgfLyO1G\n4xO4rKK93yz9NftOk02eE1iTU1SZXh4gmGhnehyiL4xmTcuXRvwWHccadCkCAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVc3AtZGV2LmFuZHJldy5jbXUuZWR1MB0GA1UdDgQW\nBBSIMr9ZbNUjjtMttZArR2o+3BHsQTANBgkqhkiG9w0BAQUFAAOCAQEAIg7T0c+B\nDRHNJ6KXZkw+KA5quM/fTaLOaDWXMqywpUIqpLEFvKimkLv26Vm3gniaFEOUy3+Z\nphgjeDqCW/PzexF0GFaRD9xj3mMYD2CmuvWDR/BRvJOqB2D6VcCrMKgNrio9NkOI\nBLMPElVazN4xGEXbfk1AYdo1AYhJwKQB0o2CxTHNaIWrTdU4eirBFdApoqPeF37t\nJI03vbmgl6CZ7RMNSQo9TgEnVcXWCWK/0BNCSqSPdNcGsUFkwCf7lANPDUMu1I9X\n7Jj46D6STH4+CmVzPtqf78kSLRKwIDNmyocSfO4PIxqvbWU+PjVW4x4VwJ2sL4kN\n0tOOoa56TyAPuw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp-dev.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "http://baylor.instructure.com/saml2", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Instructure, Inc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Instructure, Inc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.instructure.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "http://baylor.instructure.com/saml2", 
      "contact_person": [
        {
          "given_name": {
            "text": "Lowe, John D", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "John_Lowe@baylor.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Lowe, John D", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "John_Lowe@baylor.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Lowe, John D", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "John_Lowe@baylor.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Lowe, John D", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "contact_type": "other", 
          "email_address": [
            {
              "text": "John_Lowe@baylor.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://baylor.instructure.com/saml_logout"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://baylor.instructure.com/saml_consume"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://baylor.test.instructure.com/saml_consume"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://baylor.beta.instructure.com/saml_consume"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Baylor University (Canvas)", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE8TCCA9mgAwIBAgIJAITusxON60cKMA0GCSqGSIb3DQEBBQUAMIGrMQswCQYD\nVQQGEwJVUzENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMOU2FsdCBMYWtlIENpdHkx\nGTAXBgNVBAoTEEluc3RydWN0dXJlLCBJbmMxEzARBgNVBAsTCk9wZXJhdGlvbnMx\nIDAeBgNVBAMTF0NhbnZhcyBTQU1MIENlcnRpZmljYXRlMSIwIAYJKoZIhvcNAQkB\nFhNvcHNAaW5zdHJ1Y3R1cmUuY29tMB4XDTEzMDQyMjE3NDQ0M1oXDTE1MDQyMjE3\nNDQ0M1owgasxCzAJBgNVBAYTAlVTMQ0wCwYDVQQIEwRVdGFoMRcwFQYDVQQHEw5T\nYWx0IExha2UgQ2l0eTEZMBcGA1UEChMQSW5zdHJ1Y3R1cmUsIEluYzETMBEGA1UE\nCxMKT3BlcmF0aW9uczEgMB4GA1UEAxMXQ2FudmFzIFNBTUwgQ2VydGlmaWNhdGUx\nIjAgBgkqhkiG9w0BCQEWE29wc0BpbnN0cnVjdHVyZS5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDHRYRp/slsoqD7iPFo+8UFjqd+LgSQ062x09CG\nm5uW9smY/x2ig8hxfd05Dtk42wrA9frRh6QiEhtoy8qL/4g/LOmYq5USDdzLXsPF\n/nqTVPkTOhGcuSpfJbxucRsMfGL6IvrGqLNxpyfroyV1dv9/fim+d6bs7js5k1i5\nEkKksgVlnnpUpOx5pswWVcZICeIJwTMe1C0KHcpUMycZxMHueJ+Y7tWHtWW+R75T\nQWdWjL+TevEL57B3cW19+9Sud2Y63DcwP6V0aDrwArxQwmp73uUb5ol6gSSvD+Ol\nCIsf6S/5gqMdgqxJJsWqzBOTeDsVr8m2Dx3VX7Plho7pk06FAgMBAAGjggEUMIIB\nEDAdBgNVHQ4EFgQUQy1zIfZP/NZKPYLGugNSjjBnTYgwgeAGA1UdIwSB2DCB1YAU\nQy1zIfZP/NZKPYLGugNSjjBnTYihgbGkga4wgasxCzAJBgNVBAYTAlVTMQ0wCwYD\nVQQIEwRVdGFoMRcwFQYDVQQHEw5TYWx0IExha2UgQ2l0eTEZMBcGA1UEChMQSW5z\ndHJ1Y3R1cmUsIEluYzETMBEGA1UECxMKT3BlcmF0aW9uczEgMB4GA1UEAxMXQ2Fu\ndmFzIFNBTUwgQ2VydGlmaWNhdGUxIjAgBgkqhkiG9w0BCQEWE29wc0BpbnN0cnVj\ndHVyZS5jb22CCQCE7rMTjetHCjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUA\nA4IBAQC1dgkv3cT4KRMR42mIKgJRp4Jf7swUrtoAFOdOr1R6fjI/9bFNSVNgauiQ\nflN6q8QA5B2sbDihiSqAylm9F34hpI3C3PvzSWzuIk+Z2FPHcA05CZtwrUWj1M0c\neBXxXragtR7ZYtIbEb0srzBfwoFYvWnLU7tM8t6wM6+1rxvOuQFVCCSXyptsGoBl\nD9qyzAbyYDgJZYpbTjaA9bqhpkn/9CLN3JhNHLyBVr03fp3hQqNwZ2do9bFZBnW0\nc5Dx9pbKTvC3TAUb2cwUD69yTYS1oq7//yIC2ha2ouzkV/VpB1fcF5YEj2pc6uaj\nlOTDX4Eg7OBEkTzU8cX04b15bJfE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Baylor University (Canvas)", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://bionimbus-pdc.opensciencedatacloud.org/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Open Cloud Consortium (OCC)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Open Cloud Consortium (OCC)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.opencloudconsortium.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://bionimbus-pdc.opensciencedatacloud.org/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Cindy Rogowski", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@opensciencedatacloud.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Raymond Powell", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@opensciencedatacloud.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://bionimbus-pdc.opensciencedatacloud.org/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Bionimbus PDC Console", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "We provide and support cloud computing and storage services for the scientific research community. The OSDC is run by the Open Cloud Consortium, a non-profit organization whose primary goal is to support scientific advances by working with researchers in a variety of disciplines.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "https://bionimbus-pdc.opensciencedatacloud.org", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://bionimbus-pdc.opensciencedatacloud.org/misc/privacy.txt", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://bionimbus-pdc.opensciencedatacloud.org/misc/logo_sm.png", 
                    "width": "205", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "35"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEwDCCAqgCAQEwDQYJKoZIhvcNAQEFBQAwgaExCzAJBgNVBAYTAlVTMQswCQYD\nVQQIDAJJTDEQMA4GA1UEBwwHQ2hpY2FnbzEgMB4GA1UECgwXT3BlbiBTY2llbmNl\nIERhdGEgQ2xvdWQxKjAoBgNVBAsMIUxhYm9yYXRvcnkgZm9yIEFkdmFuY2VkIENv\nbXB1dGluZzElMCMGA1UEAwwcY2Eub3BlbnNjaWVuY2VkYXRhY2xvdWQub3JnIDAe\nFw0xMjExMzAxNzMxMTJaFw0yMjExMjgxNzMxMTJaMIGpMQswCQYDVQQGEwJVUzEL\nMAkGA1UECAwCSUwxEDAOBgNVBAcMB0NoaWNhZ28xHjAcBgNVBAoMFVVuaXZlcnNp\ndHkgb2YgQ2hpY2FnbzEqMCgGA1UECwwhTGFib3JhdG9yeSBmb3IgQWR2YW5jZWQg\nQ29tcHV0aW5nMS8wLQYDVQQDDCZiaW9uaW1idXMtcGRjLm9wZW5zY2llbmNlZGF0\nYWNsb3VkLm9yZzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALw5kh3r\nGktkcNlRBJAMsIt1cSgQQS6ZLnY7fLveTeEzwyfIwfoib/DUCIHhdR4ITE3vqhjj\nd+Hri5ngrMe/BLgJVwUORNXoDzySn9aeEXNXZYizrcdAztenc+Wor81F6+RdZEHZ\n//JuYZ95CAZwsYpQlVSXMFbz0LJ2qSu8XAG6SE8BE06tqCQBy1/4u6HedTYmHpum\n93s6v6+1JTryYZ9zMyD2wbILaQArz81Oo4DR8FoTRDOd4oSvGRyGWMIHYaDE265n\ntUqpQ7lGYTifNn0g0HnqZu57w1UFmjcvwSaIykEq1/GfgFYd2A+SJcFYIaBlh7tK\nb3i7IR1oHpABLNECAwEAATANBgkqhkiG9w0BAQUFAAOCAgEAPQo1XMn3c75OuVQt\n1yEAhra9g8sP+xkunpfC6oVYasWRQFwYz/a/YkMDzFTKEEeFJOzONtVzoJ60utRK\nUZYjVs6fGn9U/HuHSIgqur/Bg8T8K+cJu+n+ZDTl187+9oldWRCqEq65kzOQYm8O\nkKzh5w5cWij0DgQlLASdAvR8VTn26nDJfYBUPCBhJePhBS89wCao+gFxXWTqVQg4\nW+MG7+rxM+7HzVS0exf/SwmEZRw6euIHDbzylSSpYdWEa35U/6UBpxVEaGpAFJ/u\ng7Bmae6HqUh+50az3JRZmYtcnbHsboEW5aUTPYU3vaH0RZocN/er2fAESFD7hjbN\nFv0+zP8rg4Wc5sM3r9/I54W/XUf261OD9+o3D8lZP6nxHDmH7djiqXrwr6nKHb1D\nxSEDVwgWtDhmQMjNPGbffx7qv+N4nBqOIIqChC4losAPNAbhbzMyT5OiQDiRCGAa\nOBdHgP3RL2aYkP4uzhWkhBtLbXXVwRDDhqvd2sPQpORUNW/XTgbN92nv+VC2c7sF\nfNiBaNCdo56LAh2G4EpFsNyGC9+kVIArrnU10F6oMrCcWK7nb80X+tu3jj0+7A3s\nWUawO7Vl/fgD4zkQpLN+vHlTIBNyVrou6rR5Z5iwP4187GcWsqqsShDFmKfu+Yix\nNnYpDN3ysi+SE6e2W68UFXtN3tQ=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "We provide and support cloud computing and storage services for the scientific research community. The OSDC is run by the Open Cloud Consortium, a non-profit organization whose primary goal is to support scientific advances by working with researchers in a variety of disciplines.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Bionimbus PDC Console", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://moodletest2.calstatela.edu/sp/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "California State University, Los Angeles", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "California State University, Los Angeles", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.calstatela.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://moodletest2.calstatela.edu/sp/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Bill Chang", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bchang@cslanet.calstatela.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://moodletest2.calstatela.edu"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "https://moodletest.calstatela.edu", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Moodle Test 2 v2.4", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDRzCCAi+gAwIBAgIJAKK2TqmcpzDeMA0GCSqGSIb3DQEBBQUAMCUxIzAhBgNV\nBAMTGm1vb2RsZXRlc3QyLmNhbHN0YXRlbGEuZWR1MB4XDTEzMDMyMDIzMzg0OVoX\nDTE4MDMxOTIzMzg0OVowJTEjMCEGA1UEAxMabW9vZGxldGVzdDIuY2Fsc3RhdGVs\nYS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDeF0s/cfcLdmPK\nOdr+fTfSv97KYcO1gI8tXZvwyRODl7bd3ETwp4Oe24EYXj2lDazXgEd6FxOECnNL\nTjLBKc75EQH1RbK6toSW/R3R8mctn9Qr4tlS09FM1QCitlCXtgtiG3ZI2Wx/j6d5\njsrAh1Y29KCzWJr1tKpxknlWxbERgYFIzuWr6n1UsY4rlnC/fsxhKuJsdJkWRSiW\nlTuisoijXDBAT4GGrUUMXQV9ea5cN57xjxNxnwTGczhPHF996nr7kEQr1kHsmsh2\npBPuyusYln3feN49mZqjkX1K1kK0ZawJ9mTnUx3sdsNdkjm6kMazBtPGzQ2nxtkE\ni2oenNcBAgMBAAGjejB4MFcGA1UdEQRQME6CGm1vb2RsZXRlc3QyLmNhbHN0YXRl\nbGEuZWR1hjBodHRwczovL21vb2RsZXRlc3QyLmNhbHN0YXRlbGEuZWR1L3NwL3No\naWJib2xldGgwHQYDVR0OBBYEFL4fdLBBb6vq1/CK1E1CBuZl2J2MMA0GCSqGSIb3\nDQEBBQUAA4IBAQAFibOdf+QyWNnk6V4XVENk1/s8gVRtcjF3DeHsLVONJYDNAAu8\n+WScrc+PNmihKzkGh9j/IKWp1TAV46JxFR+hjYe1zlcjt2le8/1sSQXVvIXsyggS\nqaR4Jq/2X1+iJ/mJ/bhXZRkzMsBc7n6h8nDcRztK7VUm5GvaH+l/ue42HUu4v+8E\njG2sjeTHaAy4Zkj5rP7eBShngywEE78nMZ0nJ4gAPNIHzgNv99evdDWgmLckFIPa\nFbeMd/bu+A45W6kk9OVJhtMsVIsusAkFQUze6/fq4PVI6oH81fJsiGzlI9iwmqCz\nf+nar212WI+ekdTBGGpkx1ylvrbaV2Z1g/F+", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://moodletest2.calstatela.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://moodletest2.calstatela.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://moodletest2.calstatela.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://moodletest2.calstatela.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://moodletest2.calstatela.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://moodletest2.calstatela.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://cnics.cirg.washington.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Washington", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Washington", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.washington.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://cnics.cirg.washington.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Bill Lober", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lober@u.washington.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Vince Szopa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "vszopa@uw.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "CFAR Network of Integrated Clinical Systems", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDXzCCAkegAwIBAgIJAOJx0frTOmqWMA0GCSqGSIb3DQEBBQUAMEYxCzAJBgNV\nBAYTAlVTMRMwEQYDVQQIDApXYXNoaW5ndG9uMSIwIAYDVQQDDBljbmljcy5jaXJn\nLndhc2hpbmd0b24uZWR1MB4XDTEyMDkxODIxNDQxNFoXDTIyMDkxNjIxNDQxNFow\nRjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCldhc2hpbmd0b24xIjAgBgNVBAMMGWNu\naWNzLmNpcmcud2FzaGluZ3Rvbi5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQDwMQ/PqFQE+nimBeGk88w7eWLH/Y7lCLuErNzSM/FMq7nj1UbhZorr\nto7nPfpJWaVvHvRWFKOGZckqftUWzsXX7Lz9+8XMzLKoYOgnt6kRGQg/JZM40lSu\nublvE85xgMZ/XLm9jyH+lZsd8KpdVZSNBlWpyd6ChGgNXVPQQ8f2aeemuBNx6igb\n3bOVlSEUqkcikocmM22SiBr4pkwN9mEOe+lShwnvTs12YtAhQ65VFkqWtt98H2U+\nhTf4ob2nFFYoy2ZzVabS+Iqtc0VRRGI54lKFGONf5wu+RdzV9ekOzs4VrEEK3i4M\nGTgNtba5R+X51FD9UY1KGngmAc1JqplHAgMBAAGjUDBOMB0GA1UdDgQWBBR8VXEe\nBKt1F3vLzm5G6lVkm3PDczAfBgNVHSMEGDAWgBR8VXEeBKt1F3vLzm5G6lVkm3PD\nczAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCwY+6JPawUk1wY6m7O\nyG6fPlRkEdLBP9tjdhre9rlj6GrmmyegthcaLp1vlcdnCilBn6G5AE4navmV5Qoy\nQBwjdqRVf8zzPbfBf5uZHKJ9wCz0lKxLJxisITgNrq9+h42vuzPfPU8MipGI+pcO\nZKl5dAw5PEMxl0gQ1ZATu1dM17FWMjrxxFzUFv9xr4CUpcsy9iGuDDhINr1o4z4H\ndovBsZeZQlvF1DO6EozMU9XeafNaUQKyJhigV8LEAR8HC110hHZ0jE3CHUQjZWLH\nelYDVzXnw0oYF5JniN9pn+2PP8pGGB6mg2KTvWNwxlQqDDVzZuC0TGhx9tdNE7Tq\nPvML", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cnics.cirg.washington.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cnics.cirg.washington.edu/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://mail-db.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://mail-db.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Gretchen R Beck", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "grm@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Mail System DB", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDCTCCAfGgAwIBAgIJAPwbWyOTrTBkMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFm1haWwtZGIuYW5kcmV3LmNtdS5lZHUwHhcNMTIwNzAzMTUyOTUzWhcNMjIw\nNzAxMTUyOTUzWjAhMR8wHQYDVQQDExZtYWlsLWRiLmFuZHJldy5jbXUuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsQDp0Zgs5ZwFEFANeqdiiFkQ\nkl46r4Fxr/awLFcUkxGL4qqkXGHvUJ5h+pZM5teKyeo61bjqdtF9KnqjPsbxs3BF\nGaKyyvrJanfjVbCAQvQ+swoEkHLxWMMtCY05SheK9HF9Y7MbRlCKDePNC7qJPrqG\n7QwDD+YjveYTmqhpys+9aMEuQ6J2GBUACr7AOexnrm/3qP5N2DyG0gZ4hyskf7NX\n8MMDWULpzNM0fZu3MrohxPSQwho8QRflgIXe7fyAlsUL5vRZ/hPWT0CNgrt7I3Z+\nDakcXnud0abvIWyJwOmQ6zEzHCJyA4AKbw5Lh6EQk4Hz4kjJI5xpWDredMcRHwID\nAQABo0QwQjAhBgNVHREEGjAYghZtYWlsLWRiLmFuZHJldy5jbXUuZWR1MB0GA1Ud\nDgQWBBRO07waXYSVXsuzdSdCsuOTPIl10jANBgkqhkiG9w0BAQUFAAOCAQEAHGR0\nDVYaU91ixAuiGLnx/Ib2xLj8PKHKu0fqHJ/virKE5kXzfmWk/hpCYnLAh3FaKUPK\nUYxEFB/cFy7DenHK8v7/GtWNPBfn2h/DHAxCUWJ6IcaKwwxjUf6yxy6bdpB9/JpK\nK8vBx7YlPsob1bmLyRArCcUIJ1QVI4Mw5+ylxxSsKE7b+kiP+kla46r9Rs27qem/\nvhzAyKiPakzMZCMdb7MvMYIN6/OJap7oFkzNMSfr1OB9jlwBFBDmFmVOii2SimwO\nT9frD+OxHy1hY7rq+DpbarZ/rG1ULeGQaz1/bZkK4iGaOU4A/l5uOI0cn68F+2fk\nd+KIf81TSigtWf5/jA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mail-db.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://sp.wepanow.com/am", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "WEPA, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "WEPA, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://wepanow.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://sp.wepanow.com/am", 
      "contact_person": [
        {
          "given_name": {
            "text": "Raj Batchu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "RBatchu@wepaNow.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "WEPA IT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "it@wepanow.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.wepanow.com:443/am/Consumer/metaAlias/sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.wepanow.com/am/Consumer/ECP/metaAlias/sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.wepanow.com:443/am/Consumer/metaAlias/sp"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "WEPANow", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Print Better at WEPAnow.com", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "https://www.wepanow.com/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://www.wepanow.com/privacy-policy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.wepanow.com/images/logo.png", 
                    "width": "285", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "125"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFUzCCBDugAwIBAgIHBAejT4K4yDANBgkqhkiG9w0BAQUFADCByjELMAkGA1UEBhMCVVMxEDAO\nBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoTEUdvRGFkZHkuY29t\nLCBJbmMuMTMwMQYDVQQLEypodHRwOi8vY2VydGlmaWNhdGVzLmdvZGFkZHkuY29tL3JlcG9zaXRv\ncnkxMDAuBgNVBAMTJ0dvIERhZGR5IFNlY3VyZSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTERMA8G\nA1UEBRMIMDc5NjkyODcwHhcNMTEwNzA1MTU0MDM3WhcNMTYwODI3MTMxMDQ2WjBTMRYwFAYDVQQK\nDA0qLndlcGFub3cuY29tMSEwHwYDVQQLDBhEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQxFjAUBgNV\nBAMMDSoud2VwYW5vdy5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDwNTU75f1s\nxjId08ydW9x/DcEx/+D10RViFKaFk6i2F86vvbBAWB9Iz9Io27jxURyUu9EmId1tC67Ge0n8U12Z\nv5NP78nF3i4OZa9rCiqT175FkkFDXs2oto6aw/uXAI5w6WhLwXf2isYVPLafY9owWhz7v3A67iO4\no0zb41wEcGX3viJ76uF2vXh7K1GpxLHqHF2fTFHAV6ge+1NiqHilQTkc5u1LoPfn5nr4ot9Rgqs8\nLYrIUTy6VFGMkgOXheaf2glLqcfl3wLiQpymv641uWpx8W2wW8BAn3vligxhKVbgTvrhETyZt2Ny\nfcDVpqoMXnrcAqYNsZantiFWheFnAgMBAAGjggGyMIIBrjAPBgNVHRMBAf8EBTADAQEAMB0GA1Ud\nJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAOBgNVHQ8BAf8EBAMCBaAwMwYDVR0fBCwwKjAooCag\nJIYiaHR0cDovL2NybC5nb2RhZGR5LmNvbS9nZHMxLTUyLmNybDBNBgNVHSAERjBEMEIGC2CGSAGG\n/W0BBxcBMDMwMQYIKwYBBQUHAgEWJWh0dHBzOi8vY2VydHMuZ29kYWRkeS5jb20vcmVwb3NpdG9y\neS8wgYAGCCsGAQUFBwEBBHQwcjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZ29kYWRkeS5jb20v\nMEoGCCsGAQUFBzAChj5odHRwOi8vY2VydGlmaWNhdGVzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkv\nZ2RfaW50ZXJtZWRpYXRlLmNydDAfBgNVHSMEGDAWgBT9rGEyk2xF1uLuhV+auud2mWjM5zAlBgNV\nHREEHjAcgg0qLndlcGFub3cuY29tggt3ZXBhbm93LmNvbTAdBgNVHQ4EFgQU4yqMa0kWMORN/uTt\n/rOkU5xluL0wDQYJKoZIhvcNAQEFBQADggEBABnHzDZV5iviqM+dipqShHMalSG6ahf0+B4X6tJ+\ncm+8huJ2/91D0GXfr+b3BEBHNL77Flf79BTtbIdk3LO/ldQdGU58reXfHdUvmpJzgspF4vLDwocv\nVdpWFSezZvTBsLbGwAonft2uuXgF2m2xSMgkMauIc+5Xs9KqbWJofFO6H/XtAvK7coix3KYPg2C2\n93eltW345g5aOrEdJ/EZUp01F0yGz2amAUE4OEr2xQEOgRqmYJpPOODP8MDBspkqOMYSwndP+RlH\ndQ0J7cuYI8afxfCRKoiMTPfNvoteub8faLFdd95xr2Dtv1apIDHYx1Ndfbk879DLZmlwhFiFpJA=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Print Better at WEPAnow.com", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "o", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:o"
                }, 
                {
                  "friendly_name": "o", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "WEPANow", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://calendar-failover.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://calendar-failover.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Erin Peszko", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "peszko@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Calendar Failover Server", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDJzCCAg+gAwIBAgIJAJg3U6DTvtqxMA0GCSqGSIb3DQEBBQUAMCsxKTAnBgNV\nBAMTIGNhbGVuZGFyLWZhaWxvdmVyLmFuZHJldy5jbXUuZWR1MB4XDTEyMDEyNTE5\nMTU0MFoXDTIyMDEyMjE5MTU0MFowKzEpMCcGA1UEAxMgY2FsZW5kYXItZmFpbG92\nZXIuYW5kcmV3LmNtdS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQCjx1OBweNdUOJjtluflGTHRrLKzIkj94PkRgNMcfQrDSFxwTpcezbQBTcgfkdC\nbdyDdcxpyRy6DL+Zj5CwYpYmh0HjrxmnXBVZ2wIcuOoHojE2GUfW5I/YjIxLcW/6\n7bprWVSZHJ2S9k4u4hC/BMGT0PGMr4/WElGItPznQnPnl8/T6h+nb5mCu97BBT8O\nchMasO5NID6smGaf2WSnfUsVqFOmNw/Gzm1d2eg0ALK6qaBT2kDbPC8Kp15tgcFL\n2tEJaPURo8wckCDpmC2VejLf9bmM/mJ8l0IDjvf4u7ptnyRuEG7W+1BNtPFIE2tf\n/Uw29QrE/1VWdhDxam90I+b1AgMBAAGjTjBMMCsGA1UdEQQkMCKCIGNhbGVuZGFy\nLWZhaWxvdmVyLmFuZHJldy5jbXUuZWR1MB0GA1UdDgQWBBTJ/aNwptgI7Wj5uKOu\n1bEOSRWPmTANBgkqhkiG9w0BAQUFAAOCAQEAgqZrDcQGN5WeShUxW1F6hapd9Zxx\njFbxHGdi9XPjL4SocmMRBWEAq69SXPIh7y5vR7rNh+knBaaxoih6Og4ZJDK2kjJa\nVGXBJih+5S+n+0WOna/h8o+O5TczeR7ac4YKN4Q7BUXfBQ94F07u1kSdpq9xn/k3\ns3/bqIFHlIfaR9kxqcA40opmC/RZRRuZEMbgyO0tv6tmwdfswXK9td3Is+bgG5PM\ndFFZlh6h1FRXmN2uovkFgcqcVXrzPSy9UC0OxaUZrJhLCdndySK792478rKBbQuQ\nEB4hGaj5lXqBHIp0kLaUiO3ipgfjwgAzw7j5gB6WOX8PRJInao5MknrpqA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://calendar-failover.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ubonline.ubalt.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Baltimore", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Baltimore", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ubalt.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ubonline.ubalt.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "George Weitzel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gweitzel@ubalt.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ubonline.ubalt.edu/Shibboleth.sso/DS"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDJDCCAgygAwIBAgIJAKqsasD8HWf8MA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEnVib25saW5lLnViYWx0LmVkdTAeFw0xMTAyMDIyMzEzMTJaFw0yMTAxMzAy\nMzEzMTJaMB0xGzAZBgNVBAMTEnVib25saW5lLnViYWx0LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAK+pBhfoExVuDcMXXBKUk+dG6emdOb6GUM68\nBeCnoRt7CBvk3zayUSzo/hzTnqjTsdl6A+pFGtTFELRq8EtxfwbsggLg+zE/BrMc\n7qrQgzV6wP6bRDTZOlH9i0NM0pSOPiDQRh9YuAdeviMGvwEIaCaNpOmE/0cKuFsr\n3lpEPxUSdqYzW3rNgsL6ht/XyGXxVqh7IbvEarU9Zh5uIOWMYjhJfTRhtG5zn9qp\nX6/lFG+YB+sbIQ+YzErvLJSZeUjqxOoFhYzE3rjphELr6TvxtblXOXOc5jXdWsj6\noa2/7/p4mk3pKmxDd3euuK5z0nWzwI8imVCZLZo7ouA5mSslKZECAwEAAaNnMGUw\nRAYDVR0RBD0wO4ISdWJvbmxpbmUudWJhbHQuZWR1hiVodHRwczovL3Vib25saW5l\nLnViYWx0LmVkdS9zaGliYm9sZXRoMB0GA1UdDgQWBBQV6gCMVM5BKVS4JjYNlLH3\nsqMIPTANBgkqhkiG9w0BAQUFAAOCAQEArUrVE+Jye/8422nWCxR/HzEFo73AQ0kW\n4CWMpE9QtSWDgQmjeQvz1y8UUvuS5jsbxbNbgYotDlhcK9QPttkE5Tnjg7r+VE/F\nk4K0m9MSHFMfTFBRe9WH7mPGDN5pWIDidEteBVrYYKAbSR1RWzHYSyaYEBSsduya\nXAPqqeetcBaMApLNo7a7xv3nlRqswFNLWBHkE+LnLZKDSL7wXVyHRkrdW/NOLxyB\nDWqiENjfUZW0s9PewM4nYbekcB8a0u7+IHLV+BdX+W9xTYRJBocv+e5B0hpNzkoF\nZXRXZLDPH7nxh+naUKgOAH2Rx5ej3MMOKULE2BW1Ddi2KibAx1NZcA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ubonline.ubalt.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ubonline.ubalt.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ubonline.ubalt.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ubonline.ubalt.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ubonline.ubalt.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ubonline.ubalt.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://upitt.peopleadmin.com/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "PeopleAdmin, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "PeopleAdmin, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://upitt.peopleadmin.com/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Bryan Garner", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bryan.garner@peopleadmin.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Praveen Pinto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "praveen.pinto@peopleadmin.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "PeopleAdmin 5.8 UPITT", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDODCCAiCgAwIBAgIJAMo/C+BBrv0aMA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTETIucGVvcGxlYWRtaW4uY29tMB4XDTEwMDgwNTEzMzExMloXDTEzMDgwNDEz\nMzExMlowHDEaMBgGA1UEAxMRMi5wZW9wbGVhZG1pbi5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDG6Lo5ouylhXl7Nm4FJYXdqT0pJEFYsCLI6wOd\nmA1jupta7BxtE1K7hwkt6sqtlQ4jZW2/jYZ3wLSVleSNVM853CcH5E9jdeIqONZ/\nCGFMY0t2oMKHGsPtcYNTm096zJZzuyeuNdQ4zD1rOWk2MhgaPZszzXrpaymnB3OS\nZk1fg49phnyoVNcNu6Y20CZxfYwTE1FdDnV9wZIjowDktWRaY1B4lVSc+aC2/hru\nq5w+Y6WhyI4IXTvTh6QQrv+t2BuDzVay01Q2Zwz5GBHagIx17m4XeCbQxj5BSGCc\n4l23WRAe4FoB0OSLqZFYr2mRbnesfNiJxNInVkBMacxF3pRvAgMBAAGjfTB7MB0G\nA1UdDgQWBBT1Qw1cZsbnIxuodvvQw79nBSVpvzBMBgNVHSMERTBDgBT1Qw1cZsbn\nIxuodvvQw79nBSVpv6EgpB4wHDEaMBgGA1UEAxMRMi5wZW9wbGVhZG1pbi5jb22C\nCQDKPwvgQa79GjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCoVyjD\nBT7XnRTfip5k8MkMCwl35VSVyGsAhBACtyc7mP4RmivtkiVfpjm72JDGbbyk8+hO\naLADxXFTwPt+vdt/BClgGHrd8DpCzsKMpnYuLYeRUvsP547ZvX7eSyVnw1XxdNjz\nf+wcxNnG+JEunTqMGkEKx96nMVD0uIRlH4ckjPUcfoK3M84jPwWshiGvWfeHShRb\n4cFZSCGJ1RTzHH2YhGvl8JRdOwhtYghlsfiiIEeiwymd6TiQd8XiyrTg+EAAHp/Q\neu1pTzhghjLzymbyXkDuI2YNeHMAxU+Z/HWWaNApw6w4L857/cBNuDSNA82LDAKr\nEZDtJM0XgtYgeXey", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.pittsource.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://upitt-training.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://upitt-sb.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://upgrade032.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://upgrade032-training.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://uro.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://uro.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "System Admin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "unix-request@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "URO Application Server (SURG/Pentaho) - Production", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC/TCCAeWgAwIBAgIJAMVMuJ5Z4C7IMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEnVyby5hbmRyZXcuY211LmVkdTAeFw0xMzA2MjExODE3NDFaFw0yMzA2MTkx\nODE3NDFaMB0xGzAZBgNVBAMTEnVyby5hbmRyZXcuY211LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANRd3EpdydzTJaU6R9fcvBh3zXbfQnvIgQZG\n82FaQjLEo4rATc7I4TCg8wGpqmLrKObG38NY4B4mMOMSGxFnDXZRneRns1bVmgd7\nR4WOZXAcxvDv/cRhZ/O4ZL5mryjMWwGxm56ebiAMYsfkOmPvSosskGA/Wi4rykdC\nFyOL5ULd6ud2V5q3fo3GyX7AI42cMywwoYRAznOSlAji20h+m27W4PjOlviDosJB\nEJOyFSbCiDfr00k1UoOaOvf/+Mz0oEJ87Um7TRZp36LSYvKJrzPl7fsTwRcnJR4g\nWftSMvgWfJgyyS/8Yw6tI82GPBFdljgcyaS0+NUChfRX1KSF/tMCAwEAAaNAMD4w\nHQYDVR0RBBYwFIISdXJvLmFuZHJldy5jbXUuZWR1MB0GA1UdDgQWBBSblULV1X35\nujCtZRYnW4w5H4BONzANBgkqhkiG9w0BAQUFAAOCAQEAFb3iT4ZOM3p3PJ1umWdu\nBOdU4KLAF6NHBxxn4LB/+n/f70bbm3rDsFK2yeYt9lhiYJgwBN+/UCJtDORIetp7\nV0VBasoXR8Q0jB8BGT6n34N+vM2I9ioEXsfy0Jm5dPkka8vQ6ygDiSVfrX14+D6O\nAuxXs4fStclkaB2UHM3ShaGLpspQny/3SSQS+ajj2B62MDwbfvUPYW6s/HiQqRHA\nysd0XfqVPKAAaU89ADutv/mjkGbVhjm6xlMdsBM6LtgCYjEzVv1DUFftdEWF0R4C\nq1q0qZUbkgx+hKrwWDMfQ2MlFSPy8t2/wptRyVS38jjARNNZ1KKqnzuYpwyW+hD5\ntA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uro.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://demo.co.internet2.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Internet2", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Internet2", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://demo.co.internet2.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Benn Oshrin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "benno@internet2.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Benn Oshrin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "benno@internet2.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Benn Oshrin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "benno@internet2.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://demo.co.internet2.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://demo.co.internet2.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://demo.co.internet2.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://demo.co.internet2.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://demo.co.internet2.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://demo.co.internet2.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://demo.co.internet2.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "COmanage Showcase", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "A showcase instance of the COmanage platform", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.internet2.edu/comanage", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.internet2.edu/privacy.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.internet2.edu/images/COmanage_logos_color.png", 
                    "width": "454", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "83"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFnzCCA4egAwIBAgIBADANBgkqhkiG9w0BAQUFADCBkjELMAkGA1UEBhMCVVMx\nETAPBgNVBAgTCE1pY2hpZ2FuMRIwEAYDVQQHEwlBbm4gQXJib3IxEjAQBgNVBAoT\nCUludGVybmV0MjEeMBwGA1UEAxMVZGVtby5jby5pbnRlcm5ldDIuZWR1MSgwJgYJ\nKoZIhvcNAQkBFhl0ZWNoc3VwcG9ydEBpbnRlcm5ldDIuZWR1MB4XDTEyMDgxNjE3\nNTAwN1oXDTIyMDgxNDE3NTAwN1owgZIxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhN\naWNoaWdhbjESMBAGA1UEBxMJQW5uIEFyYm9yMRIwEAYDVQQKEwlJbnRlcm5ldDIx\nHjAcBgNVBAMTFWRlbW8uY28uaW50ZXJuZXQyLmVkdTEoMCYGCSqGSIb3DQEJARYZ\ndGVjaHN1cHBvcnRAaW50ZXJuZXQyLmVkdTCCAiIwDQYJKoZIhvcNAQEBBQADggIP\nADCCAgoCggIBAL5dLHSfQEwgCnaDiN+/JgJJRppB1vHbkULVCbKBXyB8MPRnE7kB\nveOmdLBmlotRk3U1Si9Fr1CpyNNqblUZ7wImMVKoEZ9AX5m3GivsL8pbNJOpZlg8\nG2ZK4pa5/OR9Icu5J8dNFU1piIRx9yP/1bCUNVHWAM7vMkOqkcPUUd9OPTm5lUfk\nQ2IlrSxroAaCBiRRrpXUin1PYl/YntJOO1p1Vf0idAHjiRt7d/Hb+4w8Avth3iD2\n5sWhJdZuQCbK1zAyqAAAGQ8HeU5ZAwaxrnSOc/ItX0NCnucYx3WugVuyDE7q4k/2\n+QuJy5Ucas4zcoljh6xthrupCZbU5efXIRzBpYdM7A0eQrRNN+bZzcElmUr0bur4\nYnQx4nP6PsityudShCe8uUNQqP54ay9cs1cqykRrPXD5K37lsC97Uqn/9zKz9W+V\n9Tt1t/R+N7jC6OECTSJNsIzIxYd/Qu2OrKohifBArqXnBTfOIIylq8llhIqNI/ff\nd7ZarV2/aDtDvGX2MNEmHdO4wGF6W14T3GsJ7RKDQA03tD4D9gNPlkGpwyu8ynkW\nItXlYj42f893usB/DUncoYyoGPpYfeJBmKBljV46CqRuAmDfJ9Ewlq/dpyXUY8dY\n1Ffom3brKd3KGXHbdFgizy08udt4LPyxz5K26/ybbV+oviwjUBkF6KhnAgMBAAEw\nDQYJKoZIhvcNAQEFBQADggIBAIWdg4p3g91cOyTogb+1nyqyi0j/7KAA3xPm8YOq\nn5Lsc7/i7K/kglT5U+8U25joHtWnwiSZawkYng3f1isV2P7FED0Upnf0SbqmYPQG\nNjbjmv1DVR/DcTuf1moeItMSKHLfEkuDPMwrEbT3iEqN865ldj7QUJojr/l8J33C\nvcJR7qKxVVenPfBDVODEU9lu6lhUvpGE+NhKOPwf0L0qFh6DqOj7oSnZTeDfjLy2\nxh8KEYSqckt2BZNFiH6NTn2n7hYJnbyhXpHYs1O/7F/vRRid7GqJaoIQ2yQC16iY\n5IWJgDoNXlv+uMrnAbygFG1+C+f2E81ocpT1/8DQ7skUJBEsgDpLdC34hfuadcg0\npbmK1k1+1AklpxLq0in9/fV8OocHxy7TXy8E8rXb6z5EFPXWNcrEWGphhlDlJPTf\nyl7UKGyNZ6gaTeLwpCBfXdVXjmujZLR1LtL2lArzPVb416EGjsJgypmVPdDyi+06\nVtz7Dp6w0ek35c3VeWMf38y0RQQRg9fei7o9leVTK7Z+S9rJnHVyeYGIHlhUPQ8g\nNghP0C+jVvDIS6FMW3BjF32OCIccUQ1WGUBr7cXelYPDJKbSdE7b3zPtZ9wBU1as\nN4tuAWUuJSHlLtazLu7wFZbHY3WmjaruXcQFaG42hkDCl59/EAK2iZ7MAHa0nY93\nG9Yy", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "A showcase instance of the COmanage platform", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "COmanage Showcase", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://casl-d01.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://casl-d01.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Charles Slivkoff", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "casl@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "casl-d01.andrew.cmu.edu", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDDDCCAfSgAwIBAgIJAJgEDsS54rrrMA0GCSqGSIb3DQEBBQUAMCIxIDAeBgNV\nBAMTF2Nhc2wtZDAxLmFuZHJldy5jbXUuZWR1MB4XDTEyMDMwNjIxMDUyMFoXDTIy\nMDMwNDIxMDUyMFowIjEgMB4GA1UEAxMXY2FzbC1kMDEuYW5kcmV3LmNtdS5lZHUw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDAvyf5+xkW6r5G4wAKOFev\nq6hx2fSjiOeUI31EjISbgfqoOEyeqiNtIp/qmSPe7icEdoJW56PyVdQ0GlTwiZvu\nBV8pXpZE6txUXEC/vUNgsFCSrKr5fnma5eBHOT4/c8o1YJE8V1nEJJ2Wpx1YXLvx\nQni0P5EfYKoghM3320i0r+yRL1zwbylwe8jKF3oD7c/BdeCPJaI4ChAV66y0qzy5\nE/wHzdLQEZf9vrUkvb6aP6SejWFJ84+34n3ARCaBgvq9vHC6j83nFkwW5bMUnHPg\nwWx+vTNsA2ViZQaFfqH5INxF6N8sU3ZUOqMaedif+uazwrtMw41cLEO21M1XoNIR\nAgMBAAGjRTBDMCIGA1UdEQQbMBmCF2Nhc2wtZDAxLmFuZHJldy5jbXUuZWR1MB0G\nA1UdDgQWBBTj9L2Qqx5nk1hJzNsT0V3AO3j7jzANBgkqhkiG9w0BAQUFAAOCAQEA\nY3o/IID65Zq+RRLgE6FcHUyShJpgn09wX4fm9PetonXDLSLfh8bfNow/MRP/3tJz\niC4+Udomgf3/p4gmU0KbM2mEl7DBdCHkhXqic4sqk7zRxvIIKI3y5tAUvV2dwFNT\n82XNAljS/FoVMrZ4wuvEh4OAxw1FX5IMntILS3+RYxEYd+ihTsCLMeZMYjWZ+LOl\nDOiKLcTGciBs0VjngZD9DTYd4RJiem5JU1MvEWDLSmxzgL3ya6cel1GzcefPBQh2\nOxLwTk6nPOZxyIVG8bOYqs5QAmGFmKd+np/uER/A8i/Ej601svNwgiAl81ekUzVb\nNnfVKcbmdi0QIPkQVDs6NQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://casl-d01.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://pa1404.peopleadmin.com/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "PeopleAdmin, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "PeopleAdmin, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://pa1404.peopleadmin.com/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Praveen Pinto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "praveen.pinto@peopleadmin.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Bryan Garner", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bryan.garner@peopleadmin.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "PeopleAdmin 7 Medical Univ of South Carolina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC9DCCAdygAwIBAgIJAK9qYIpSXmuLMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3Blb3BsZWFkbWluLmNvbTAeFw0xMzA4MDYwNDExMjJaFw0yMzA4MDQwNDEx\nMjJaMBoxGDAWBgNVBAMTD3Blb3BsZWFkbWluLmNvbTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAPNJA6keJeqd1d8rBtHYenYT+2Z5p14STKAMxI+OHzTF\n1ILCp/tXfaTeWggztaCCSGYFwSJkCaKeaLC4+easqoqS18zen4j6OEG6UWF5sUd7\nj6GumoZmFa4bYTcTpkdpa9ENG+0OKLRzWz/TTyzSdBhR3J1b1Vt+6fF/clKR1CWT\npdHsRYwGCn9jBRN7gZkNEagh4hrjfpIMgfJ7K6FRiXb5yj5pEusFm9T9ZElMFat3\npy7PQEv9F78wKbgqqFSTnnE3rWRPy8+5tTa5kpNd6GlzqiwlhY/Yqbof1lgABcNP\nN+AX1ZRRybQheE/2e53y+5/J/F4aIUHx1WJaInD35zECAwEAAaM9MDswGgYDVR0R\nBBMwEYIPcGVvcGxlYWRtaW4uY29tMB0GA1UdDgQWBBRojmrNNN8S7AEfM20TF5MI\nRPnSnDANBgkqhkiG9w0BAQUFAAOCAQEA0yEXDmrQwS7s2gSMqMm7NXlMAAwzNDhI\nOujZiSHZ1KL71bKzKHQVz5oenjJwVem/gxo7GVsuIdIZ3vKe8PYsnLu1QDTp4ZHv\nmzgRlx4kuqGjwSNs2ub2NlVc9wy9uC0pjJL58RaOxPpHDddCAs+xINF2S1ZJEM2D\nXkMvb1xhaOLox1HGhENf99ka10jWMdMt2bj1lT8WM/Qg+XgOnoQvTyjOtELM/QuA\nOVuT1bTdGg4K398O7jlTzoo7LFhPBl99HDx3cDhhhX9NdWyFyQ32MhYa6361v+eG\nDvoszRsTTKZLYbNvWoo8BZMCxK5tQ6EqNyQTmekHxw+peNCaQ+nDKw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDODCCAiCgAwIBAgIJAMo/C+BBrv0aMA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTETIucGVvcGxlYWRtaW4uY29tMB4XDTEwMDgwNTEzMzExMloXDTEzMDgwNDEz\nMzExMlowHDEaMBgGA1UEAxMRMi5wZW9wbGVhZG1pbi5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDG6Lo5ouylhXl7Nm4FJYXdqT0pJEFYsCLI6wOd\nmA1jupta7BxtE1K7hwkt6sqtlQ4jZW2/jYZ3wLSVleSNVM853CcH5E9jdeIqONZ/\nCGFMY0t2oMKHGsPtcYNTm096zJZzuyeuNdQ4zD1rOWk2MhgaPZszzXrpaymnB3OS\nZk1fg49phnyoVNcNu6Y20CZxfYwTE1FdDnV9wZIjowDktWRaY1B4lVSc+aC2/hru\nq5w+Y6WhyI4IXTvTh6QQrv+t2BuDzVay01Q2Zwz5GBHagIx17m4XeCbQxj5BSGCc\n4l23WRAe4FoB0OSLqZFYr2mRbnesfNiJxNInVkBMacxF3pRvAgMBAAGjfTB7MB0G\nA1UdDgQWBBT1Qw1cZsbnIxuodvvQw79nBSVpvzBMBgNVHSMERTBDgBT1Qw1cZsbn\nIxuodvvQw79nBSVpv6EgpB4wHDEaMBgGA1UEAxMRMi5wZW9wbGVhZG1pbi5jb22C\nCQDKPwvgQa79GjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCoVyjD\nBT7XnRTfip5k8MkMCwl35VSVyGsAhBACtyc7mP4RmivtkiVfpjm72JDGbbyk8+hO\naLADxXFTwPt+vdt/BClgGHrd8DpCzsKMpnYuLYeRUvsP547ZvX7eSyVnw1XxdNjz\nf+wcxNnG+JEunTqMGkEKx96nMVD0uIRlH4ckjPUcfoK3M84jPwWshiGvWfeHShRb\n4cFZSCGJ1RTzHH2YhGvl8JRdOwhtYghlsfiiIEeiwymd6TiQd8XiyrTg+EAAHp/Q\neu1pTzhghjLzymbyXkDuI2YNeHMAxU+Z/HWWaNApw6w4L857/cBNuDSNA82LDAKr\nEZDtJM0XgtYgeXey", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.jobs.musc.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://muscuniv-training.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://muscuniv-sb.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://uaz.evanced.info/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Evanced Solutions, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Evanced Solutions, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://evancedsolutions.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://uaz.evanced.info/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Neil Michalares", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "nmichalares@evancedsolutions.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://uaz.evanced.info/dibs/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "EvancedSolutions", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDHDCCAgSgAwIBAgIJANWEcDjuOPZJMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHVhei5ldmFuY2VkLmluZm8wHhcNMTIwODAyMTkwNDEwWhcNMjIwNzMxMTkw\nNDEwWjAbMRkwFwYDVQQDExB1YXouZXZhbmNlZC5pbmZvMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAviPIEW0/0udQMujM2ysBofgyDfrN7ljHim3KZhkU\nTRIleI2USNX+cOfv5XuabACdf9Hkao5d6++amSmJupzmwnw7bce5Pqn2VQXI4pnY\nSsKbvqOxZ4AKBegDtMIXYCx9gQpjj5K0Ou+KmJo0nAFL2npcqF6SMFW7AWpNZr//\n/LvAeUP5NuM076ovGbGmKXgzZgM/0B0DC8RqQqY8Ue50gI/ebvMyfPSSCRExzLpi\nBW6hwapgnAXd6yXpXNctb7nxerBVZApE21YsmUWJcUGEn1KwHt8O6bhTWzxHEKlt\nCUsDS5cb7R+o4cRHEos/C3IkmineaBidQ0JtTYUzr+0TBwIDAQABo2MwYTBABgNV\nHREEOTA3ghB1YXouZXZhbmNlZC5pbmZvhiNodHRwczovL3Vhei5ldmFuY2VkLmlu\nZm8vc2hpYmJvbGV0aDAdBgNVHQ4EFgQU56kFnFr5rau/cSsmi87RhlCDy6UwDQYJ\nKoZIhvcNAQEFBQADggEBAAQQh+DNX2e3SNfXn+ZjcDJ5uAsrD1HxLHq9zdUfL4uv\nSlaDP4Ez7HLPca4QNyNku62LBcNinw/zICDiNlszycEaMkXyxIjzWfUf7HJoAx8p\npr9m8L3l7iPfg+s+Y1JVqPuZwbggzArcthfZhXYss6WrIHq5NkjoHGf9a88JOyoA\nP9DPzgxEBo32cemYJCi/MvERiWnesiJeJ4pqucWVKEAFkhVFQM182AaHjJ25b+u6\npoNoDHJoob3RmWiCKAQRV4eWlfmDrmYMwa6tAt4fFxIXV+vf0XC6aBv1tBJeMsVH\nwvcM8Sr/Rt6TzNhNyd5XVkE6MiAxra5g5duFhPLhjJg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonAffiliation"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "EvancedSolutions", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://jira.sc-ctsi.org/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Southern California", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Southern California", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.usc.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://jira.sc-ctsi.org/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Shib Admin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib-admin-l@usc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Laura Perlman", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "laura@isi.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jira.sc-ctsi.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jira.sc-ctsi.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jira.sc-ctsi.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jira.sc-ctsi.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jira.sc-ctsi.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jira.sc-ctsi.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://jira.sc-ctsi.org/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "ISI CTSI Jira", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDCTCCAfGgAwIBAgIJAOuUbPNjv0DOMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFmN0c2ktamlyYS1hcHAxLnVzYy5lZHUwHhcNMTEwNzI2MTk0NTM4WhcNMjEw\nNzIzMTk0NTM4WjAhMR8wHQYDVQQDExZjdHNpLWppcmEtYXBwMS51c2MuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1s/pA+U+ehIgqQbH/o/YNM0m\njpHIT+gBa6Kkb4ROsYrzZ6FgvKEfCSsN1PcirW+9P+maXEst3WA3r+ZWUo3nb+t5\nzXHIG+55vt1Wq7bsD4cTA3o9ThJjTgDwJIs8qRPZaHKiLFg3jWONMaxoEb3+QMYU\neBbQxbbvRoAB9zFTioE38tHt3rRdCsD7qBS0zl1PVa+toK2l/iK4lvDNdKNgatqS\n3WMl7ubGbTsVK9QLFaVV2l0Ucl3KEQ1W2PrBiV548HtkmeCrbeqgFad+TscbOdpQ\nBwU7j3YUo1OYzGWpU3iC6t7tGplxYb+HSs0W2SOJZvT8jivZlP51VsKbKW6zfQID\nAQABo0QwQjAhBgNVHREEGjAYghZjdHNpLWppcmEtYXBwMS51c2MuZWR1MB0GA1Ud\nDgQWBBRkbnGUZkUyGi2fAt+c2SgQKsoiRTANBgkqhkiG9w0BAQUFAAOCAQEAGv/X\nshqYXF0cDpYSu/RULOQ1MrYrynGT6sREHzWJLQuQapuH0ufH6AwS5GUSy0CK9Wos\nKbaDlWc73+aPFh7PF70d3k4/I9VeL9W6sfgZBlyL+OHGaHF86VONxWiX+rUas+AW\n47ArXmoglqgcUk11W2eadrPyoh2rgSifA5IVPLqFm3RUSnCZHztQHG9CSrIlxt/0\nL5xoJkVmv5j5jhFyJRpAXmnVFPAcg4Y2EEuVlQksOWnt95BT1MR+Utqf3JfpFzAM\nd4j4gO2gEbqmWXIYdOcZQpC+OvTaIDORvvc77dWlK+04hg8AYvgB/+m/SEejShOd\ntInqC+uz6mQ7BU7icg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "ISI CTSI Jira", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://oeadev1.cac.washington.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Washington", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Washington", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.washington.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://oeadev1.cac.washington.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Trevor Leffler", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tleffler@uw.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "OEA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "oea@u.washington.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:3002/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:3002/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:3002/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:3002/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:3002/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:3002/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "13", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:1223/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "14", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:1223/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "15", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:1223/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "16", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:1223/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "17", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:1223/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "18", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev1.cac.washington.edu:1223/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "19", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "20", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "21", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "22", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "23", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "24", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "25", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "26", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "27", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "28", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "29", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "30", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "31", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "32", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "33", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "34", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "35", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "36", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "37", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "38", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "39", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "40", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "41", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "42", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:3002/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "43", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:3002/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "44", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:3002/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "45", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:3002/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "46", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:3002/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "47", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:3002/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "48", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:3002/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "49", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:3002/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "50", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:3002/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "51", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:3002/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "52", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:3002/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "53", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:3002/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "54", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:3002/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "55", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:1223/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "56", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:1223/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "57", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:1223/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "58", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:1223/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "59", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:1223/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "60", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uw.iasysdev.org:1223/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "61", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:1223/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "62", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:1223/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "63", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:1223/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "64", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:1223/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "65", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:1223/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "66", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwt.iasysdev.org:1223/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "67", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:1223/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "68", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:1223/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "69", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:1223/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "70", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:1223/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "71", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:1223/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "72", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uaf.iasysdev.org:1223/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "73", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://iasysdev.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "74", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://iasysdev.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "75", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://iasysdev.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "76", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://iasysdev.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "77", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://iasysdev.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "78", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://iasysdev.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "79", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev.s.uw.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "80", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev.s.uw.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "81", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev.s.uw.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "82", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev.s.uw.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "83", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev.s.uw.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "84", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://oeadev.s.uw.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://oeadev1.cac.washington.edu/Shibboleth.sso/Login"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.washington.edu/online/privacy/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://oeadev1.cac.washington.edu", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Office of Educational Assessment", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Office of Educational Assessment", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDFTCCAf2gAwIBAgIJAKylLPqMSWFCMA0GCSqGSIb3DQEBBQUAMCUxIzAhBgNV\nBAMTGm9lYWRldjEuY2FjLndhc2hpbmd0b24uZWR1MB4XDTEzMDkzMDE4MDAwOFoX\nDTIzMDkyODE4MDAwOFowJTEjMCEGA1UEAxMab2VhZGV2MS5jYWMud2FzaGluZ3Rv\nbi5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDB9JFWwpmDMqSF\n/o6m9D0hOiq2JmaYukYUxd9f5dDBXFRnLvYguZ3bvhsq0IyeqmZbjR9D/WAh7sPn\neQI/30SdraJD9ScsKzoHeW4BlJmNMyD6pLEQRCfNEMvptUW9KiSCt2ZFXQ2qEA6b\n9ulXCMZ7gYnex4Mp7RjoHX48G3T4tZ0gTkuqNImPs4rP9dpbggBjgpbdbs0/QIjH\nrL286x7AGiklGfwdZg6aJiYffNlX9l5/yNayRoGdJhR0ITZ+41yMrKeHKiag+CFN\np4FlTn7E3m3RZ4BLKUYGBqKCbXzHkDsEU7GzJKBBaCxmSFBmAML5yqy//1mac4AY\nyVT1IE3nAgMBAAGjSDBGMCUGA1UdEQQeMByCGm9lYWRldjEuY2FjLndhc2hpbmd0\nb24uZWR1MB0GA1UdDgQWBBQ9m+daWiXZf+xOx9iFiVfbHx8RwzANBgkqhkiG9w0B\nAQUFAAOCAQEAMSrM+BMA56C3fozo+/uCEo9CfZp0WlJFfTmLeQTiqfXaVGkCdyhv\nDOpkIXFvme9cNFQTNMtSndbWCOHLYwFYsdDi5UXIihi8rgajaMrhv/UmPJQfgVhA\nut7a6MGLsmmgtCqkV/7JZ88bdhBGM50sx08eAYcT0qBxFTmd1Gh0/jImtLbEAUcZ\nbr5MKlmNOCOsHYubYnvtnsBsd2zLxp1ZzBvq9KGVLoD/I0hhnfBk7RtV7FMj0UMP\nKGhHukPp3EYpyk0HwaMXWTaP+ccIq5IkqmdI0K+uPEzeu4+WqiY7OZscd/QJNvgn\nQKwYtMlb7D35kgQn8IA8OXAcsfyb1tD5wA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://servicehub.coursesmart.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "CourseSmart, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "CourseSmart, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.coursesmart.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://servicehub.coursesmart.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "John Tibbetts", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "john.tibbetts@coursesmart.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://servicehub.coursesmart.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://servicehub.coursesmart.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://servicehub.coursesmart.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://servicehub.coursesmart.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://servicehub.coursesmart.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://servicehub.coursesmart.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://servicehub.coursesmart.com/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "CourseSmart ServiceHub", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDRzCCAi+gAwIBAgIJALGEgduQzA3wMA0GCSqGSIb3DQEBBQUAMCUxIzAhBgNV\nBAMTGnNlcnZpY2VodWIuY291cnNlc21hcnQuY29tMB4XDTExMDgwOTIyMjYzNloX\nDTIxMDgwNjIyMjYzNlowJTEjMCEGA1UEAxMac2VydmljZWh1Yi5jb3Vyc2VzbWFy\ndC5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDBiTdDdpch56jn\nuhvRu5KXP55bVTZ8z8+xIYYxaecd2WMBjcaHfdIQK3iSCJNm6ngIPgjYPVu8Xuvn\n0MBK8eunOZxScFtPwaNpi06mK+dq3uitjSIisICEmeEff/97QzvXeH9uoyEe9Fis\nXnPAZ1eZWTqa49ySvm3LvG+MQawTIi+bs5ekxnalBLg7NLjQgVrQIHnti8CXEM9P\nT/vx9dLVvSPBWDwJocdALHIXProXg/CtaE9MjyjBWLbOlitzcSED/nF9zDcaOgUH\nwet5blJxFbClPXy+ZnUC+sFj0B1e888bl1tpCTqNADd1lQAzYaTazSvPr23VYw2J\ns2WRDUMfAgMBAAGjejB4MFcGA1UdEQRQME6CGnNlcnZpY2VodWIuY291cnNlc21h\ncnQuY29thjBodHRwczovL3NlcnZpY2VodWIuY291cnNlc21hcnQuY29tL3NoaWJi\nb2xldGgtc3AwHQYDVR0OBBYEFMFJ+w12M5FarxP+NAw3yAt2lSUJMA0GCSqGSIb3\nDQEBBQUAA4IBAQAptssH5i7LmS91GB/rSo04ez336CUT3jPavVXqitvtSLjgxX/S\n1KnisWHbXo7HWV1YSz825RQijKyRZVtJwJxNA3LXAZCa8KXw3yO7NuZHHByZOaOI\nR36GuCWC03cz2XwllM/SNXN3H+zIUWBWIRCUMgs0jeTyGd/TWY2IBREn6gZzWtVQ\nWWEjR+v+bC5ucK/DEcntlq22aOcOZOZP5oqI5Rk3gVh0WlYq98Qt46srFiYiDgA7\n2KhFWFq3TUXUptg0tmiQgFQPCYMbCipI4QownU4A/sMUeieGgdd7nad+heRTJvPw\npdbx39cJg5x6WRH5kDVKW6FnHz/2B9QZXqzs", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "CourseSmart ServiceHub", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://sonny.furman.edu/idp", 
    {
      "entity_id": "https://sonny.furman.edu/idp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "error_url": "https://sonny.furman.edu/idp/error.jsp", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sonny.furman.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "furman.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://furman.edu/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Furman University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDAzCCAeugAwIBAgIVAI1H0QkWz5jLIhTXfA7tHGhkNvo5MA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEHNvbm55LmZ1cm1hbi5lZHUwHhcNMTIwMzIxMTYyNDQ1\nWhcNMzIwMzIxMTYyNDQ1WjAbMRkwFwYDVQQDExBzb25ueS5mdXJtYW4uZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsbvr70tE2cpMZ7095I5tEPYV\nfoyJL9RWpwwnDMEMFH2fT74Tl8s1WRXe6xwEaAMT+5dx0qcZbgQC27mF0l2+zmMx\n6GvUeLC6CIgDLJtRumTtsRV9E8UsvRswRJnYtYT9eE2CAkUvbjkJZEGSRfZG2o0P\nl8S1munBzQFBD+fFEZYFl4FBxDxpRtkUxM2ylJ0NbqF+mQUCFYhCD+XbCw4IAkwb\nTBHd3cQ/6EMIfdzvVcCBMB3l8Fm2X/CGDlVcLB5boILGYEDX7HPxDLy6DJ0K4I3B\n7T8pxyK8jE6eyWl1S1tUXoi40CQJAbQzy7E2DtL0cZx9Ry1ql6bbIgSXpHiQBQID\nAQABoz4wPDAbBgNVHREEFDASghBzb25ueS5mdXJtYW4uZWR1MB0GA1UdDgQWBBRU\nMLOp0m88ZTOTShxkqeb0GrEL1DANBgkqhkiG9w0BAQUFAAOCAQEAEeOSGj3CBLqs\nWcdXSvyYK9geRTiML+uVZldoHn0yotZcexIgAA+Kwi59TUeRigsC2AAq+rXnJSY3\nJD/wJjdPhWD31bp0C7UFqv5VWiDxMXLPgVNrEZRHvWEwBusUEHkmD95eQoBNAEuB\nyABPQE3LJxQ1tyOFRVYjxNbh9P7fR8bqEtLSPOZyiElyc+eV1Y6sQF6edXY1hyuK\n+0B+9FngV0Wq63/lVLFeuazD+3tI/WugahzvVXleoG49TsFMyjgpFERkcFj9SC6A\n6t98O1ZdhVRiz7VlYeAspGvww4oDGKQUZiKTL7VWvPhIlDNv5kcakfZSRcN/QCf9\ncmzZA1pJew==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "furman.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDAzCCAeugAwIBAgIVAI1H0QkWz5jLIhTXfA7tHGhkNvo5MA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEHNvbm55LmZ1cm1hbi5lZHUwHhcNMTIwMzIxMTYyNDQ1\nWhcNMzIwMzIxMTYyNDQ1WjAbMRkwFwYDVQQDExBzb25ueS5mdXJtYW4uZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsbvr70tE2cpMZ7095I5tEPYV\nfoyJL9RWpwwnDMEMFH2fT74Tl8s1WRXe6xwEaAMT+5dx0qcZbgQC27mF0l2+zmMx\n6GvUeLC6CIgDLJtRumTtsRV9E8UsvRswRJnYtYT9eE2CAkUvbjkJZEGSRfZG2o0P\nl8S1munBzQFBD+fFEZYFl4FBxDxpRtkUxM2ylJ0NbqF+mQUCFYhCD+XbCw4IAkwb\nTBHd3cQ/6EMIfdzvVcCBMB3l8Fm2X/CGDlVcLB5boILGYEDX7HPxDLy6DJ0K4I3B\n7T8pxyK8jE6eyWl1S1tUXoi40CQJAbQzy7E2DtL0cZx9Ry1ql6bbIgSXpHiQBQID\nAQABoz4wPDAbBgNVHREEFDASghBzb25ueS5mdXJtYW4uZWR1MB0GA1UdDgQWBBRU\nMLOp0m88ZTOTShxkqeb0GrEL1DANBgkqhkiG9w0BAQUFAAOCAQEAEeOSGj3CBLqs\nWcdXSvyYK9geRTiML+uVZldoHn0yotZcexIgAA+Kwi59TUeRigsC2AAq+rXnJSY3\nJD/wJjdPhWD31bp0C7UFqv5VWiDxMXLPgVNrEZRHvWEwBusUEHkmD95eQoBNAEuB\nyABPQE3LJxQ1tyOFRVYjxNbh9P7fR8bqEtLSPOZyiElyc+eV1Y6sQF6edXY1hyuK\n+0B+9FngV0Wq63/lVLFeuazD+3tI/WugahzvVXleoG49TsFMyjgpFERkcFj9SC6A\n6t98O1ZdhVRiz7VlYeAspGvww4oDGKQUZiKTL7VWvPhIlDNv5kcakfZSRcN/QCf9\ncmzZA1pJew==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://sonny.furman.edu/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Furman University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Furman University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www2.furman.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Randy Dill", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "randy.dill@furman.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Clayton Burton", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "clayton.burton@furman.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Service Center", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "service.center@furman.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://ctsabbc.uth.tmc.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Texas Health Science Center At Houston", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Texas Health Science Center At Houston", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uth.tmc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ctsabbc.uth.tmc.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Fagon Istre", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Fagon.M.Istre@uth.tmc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "OAC Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@uth.tmc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/DS"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDADCCAeigAwIBAgIJAJaiYQTj7FJ7MA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE2N0c2FiYmMudXRoLnRtYy5lZHUwHhcNMDkwMzIwMDgxNjMwWhcNMTkwMzE4\nMDgxNjMwWjAeMRwwGgYDVQQDExNjdHNhYmJjLnV0aC50bWMuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAviHX2Y48UW+wM8H2fGNJSoaENAXJkgID\n+/zZytL0IzvKoy0IlNai/GpkWbYP3Ree6T3YOvZ4wq3b/+KsMCXfFMutkXeAxJ7q\nY9+g9hPlV/ocDhOBxluz3mtO6FL9L1Xh0EIItEQLkbEEqMbAIfnf1hEoteJUo02V\nji9yWC1EpAqq8hhzkpmfI+0cao6DpNQ6ZsEVkO0OCWwv0/2/NwGK9gj5L1aQpyYU\nGdlsIHa0buTRi4L5Gux6oK1vFrQ/kdAhaA89k5INI/K8veKr0udqacYwkeFRKs+E\ngP6rXN3ZT3Qf8+6qs70FvNzIFx6jzf3A79hQM82u0RptFKaShIirtwIDAQABo0Ew\nPzAeBgNVHREEFzAVghNjdHNhYmJjLnV0aC50bWMuZWR1MB0GA1UdDgQWBBQAISNx\nfvgHw+drUdczCtZ5Rh6liTANBgkqhkiG9w0BAQUFAAOCAQEAqSNBEnKNC2VuGDSA\nrQZik+0qQb+Mrsvuwgr5AZy5B6zBuEPjixeUy6pLJNrC1NLC3kphiGczno4l/ZSh\nibO7evEh2Iel5yIujs9QhY2HwioJDYnIkA7PegcDCowZdt95aZ/F0QHcCrR6mO/o\nZIbllhfeJjyThgAq/hEnzCFwNX6e7KIX4WXfinsRg/TnJaY3qGvslvwyNj3KA6ZM\nH+HtJYLVweMn1QdfPCRHi8stm6Bq4VXI808Y5GL3CSVY3BVfwvwSerFsG1gnZs7N\njFETksl3dj/ldSTIxVSrWbgBPnjnrl4krdxPQhDHEBsz7zfNKP9/gIj5B59V5/da\niPsxBA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibidp.moxiesoft.com/idp/shibboleth", 
    {
      "entity_id": "https://shibidp.moxiesoft.com/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.moxiesoft.com/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.moxiesoft.com/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.moxiesoft.com/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "moxiesoft.com", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Moxie Software, Inc.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Shibboleth IdP for Moxie Software, formerly nGenera.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDPzCCAiegAwIBAgIUMkJsiF5HCGTNYBBi7SW/JkrgnxUwDQYJKoZIhvcNAQEF\nBQAwIDEeMBwGA1UEAxMVc2hpYmlkcC5tb3hpZXNvZnQuY29tMB4XDTEyMDYxMTIz\nMTEzMVoXDTMyMDYxMTIzMTEzMVowIDEeMBwGA1UEAxMVc2hpYmlkcC5tb3hpZXNv\nZnQuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwrWP4b4WSTrt\niDsZpaxyb6r4yqp4Lng36tiVW8aN5IVPc0u873oSDFdFsJZbjOqYeUHn+wBnRkf/\ntUqNYDDsNmiTTzlDky2lgO73K9eUV4pYluQlBU3EaUCqJMTePtcyTAD85TeUby4E\nUp4cnn8E1b9JqsEgTHcRTldFiMifnaOtX8GjkQMJlfb72WSJD88QpVM3yqxsogdq\niCwTP/28T7WheBt9aSj8LKMystlXskWMOIrV4Wk9bnBS58HRGZJX/5yMXMn3z3eg\n2U8b2eeTTw92GSzwyPXtMfTgcKUBj4BFNARJsSqBXdAtIPNyIn69yiLy1Xahc1TJ\n62rrZjqlyQIDAQABo3EwbzBOBgNVHREERzBFghVzaGliaWRwLm1veGllc29mdC5j\nb22GLGh0dHBzOi8vc2hpYmlkcC5tb3hpZXNvZnQuY29tL2lkcC9zaGliYm9sZXRo\nMB0GA1UdDgQWBBTVdZHcIJ4cTEBvRAn8EdDj3s+78jANBgkqhkiG9w0BAQUFAAOC\nAQEAenwZcXdyN8RI+1BVyMBrC+8vY9z/3R+6y8Wr7le3blTPp8m1QLexYzFiZyEm\ncNUsyKsjrOslWfh4oSapkXx3fHsSMoLDdt7C0y2z9ggzEJbY+b4bzLydR7d5Wuml\nGaHV4R6EA75iCwGWZ87Te+U7DL/pbKu8WyXJN7PPelfJy4mWflflc/5TvwBlIlf8\nmFFGC3IJn4851tj8rYXH+yHRrP0+RMAt+ie9acijVyAUrF4H0sH882baWUzN76v4\nJ71492czitn1JIH4xATfYiOIOFzf5ohIJ4o0xs139m+UgZ+YjARX5NyhpbYrh5nE\nIbSSiTHsYeb6qvm6YVVxrh6vTg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibidp.moxiesoft.com:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibidp.moxiesoft.com:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Moxie Software, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Moxie Software, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.moxiesoft.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Sam Marx", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "smarx@moxiesoft.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://samldev.rightanswers.com/portal/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "RightAnswers, Inc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "RightAnswers, Inc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://rightanswers.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://samldev.rightanswers.com/portal/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Keith Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kberg@rightanswers.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@rightanswers.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Keith Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Kberg@rightanswers.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samldev.rightanswers.com/portal/SAML2/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "RightAnswers Unified Knowledge Platform", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "RightAnswers Unified Knowledge Platform delivers a cloud-based or on-premise enterprise knowledge management platform to optimize customer service and IT support operations.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.rightanswers.com/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.rightanswers.com/privacy-policy.htm", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.rightanswers.com/Collateral/Templates/English-US/images/top_logo.gif", 
                    "width": "153", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "68"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDcjCCAlqgAwIBAgIET1//sTANBgkqhkiG9w0BAQUFADB7MQswCQYDVQQGEwJVUzELMAkGA1UE\nCBMCTkoxDzANBgNVBAcTBkVkaXNvbjEVMBMGA1UEChMMUmlnaHRBbnN3ZXJzMR4wHAYDVQQLExVQ\ncm9mZXNzaW9uYWwgU2VydmljZXMxFzAVBgNVBAMTDkltcGxlbWVudGF0aW9uMB4XDTEyMDMxNDAy\nMTcyMVoXDTMyMDMwOTAyMTcyMVowezELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAk5KMQ8wDQYDVQQH\nEwZFZGlzb24xFTATBgNVBAoTDFJpZ2h0QW5zd2VyczEeMBwGA1UECxMVUHJvZmVzc2lvbmFsIFNl\ncnZpY2VzMRcwFQYDVQQDEw5JbXBsZW1lbnRhdGlvbjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC\nAQoCggEBAOew7rWdr18P62K3m8jy8PvzAAsl18fDUntGHY6XSodj1pfw45VSbG2U6B8WpCB8+rEA\nGcWPQ6JK3qEpw/0n1RYR3biuP6uMrcssGyzb3k1RSq17/q9d1hHJDWyDjT/wRCfwcW8PTfwLlRbJ\nDQQsSWb1LZKbv0ewwBbt8xldZjGdpICRzPWhxsrfg34N1Qgp9K7EoXNqIKJTs1oEEmkikwmzH/4p\n1cZn0ff7YVnqhQzqdx8dgke2MG9aWQFVwJ/11KyxTfomHkNXsHTM1n8eSVK3btGM04qCVRLQkTZ+\nLoy0uTTLMr2FAvWl+CcSnemMySZ/EE3Smj+rO7eb26ZKqmECAwEAATANBgkqhkiG9w0BAQUFAAOC\nAQEAFFzywSsRHXoShclkugp5IUmEObfC7kOy/iG6k8/QVHEq8M2ObTMWdm0H1mCMAhCU0jZih0bb\nT35g6K+ZFES85v1l1ufSruVbrmCBPy6a+BWJ0L87gCWwO2tfPKiDBoWjRiZ10TrJvdTQGnXIx+CB\nNwfLjfozqTlQQ6AjQf2HOPHcCdjVfc813tOCc2wM86hYSw1Nt7JFypdC3dmGhBb581dQuM9dAxWH\nomUi2rbViYef+sO8AizGRQU5UfEG3f5w2zUPMa5GLuijvTz3cCd30Fdt05dt1N1hi/+kcMaCo5Nd\nRVA3lbsmhX+0uPsjpQHJLfVX/+nVtTk4G6ayLwKSKA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "RightAnswers Unified Knowledge Platform delivers a cloud-based or on-premise enterprise knowledge management platform to optimize customer service and IT support operations.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonAffiliation"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "RightAnswers Unified Knowledge Platform", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shib.alexanderstreet.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Alexander Street Press", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Alexander Street Press", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://alexanderstreet.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shib.alexanderstreet.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Aaron Wood", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "awood@astreetpress.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "John Field", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jfield@astreetpress.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Brandon Saunders", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "brandon.saunders@idmintegration.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Alexander Street Press", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDbjCCAlYCCQDBNjJ+wWhziDANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJV\nUzERMA8GA1UECBMIVmlyZ2luaWExEzARBgNVBAcTCkFsZXhhbmRyaWExHzAdBgNV\nBAoTFkFsZXhhbmRlciBTdHJlZXQgUHJlc3MxITAfBgNVBAMTGHNoaWIuYWxleGFu\nZGVyc3RyZWV0LmNvbTAeFw0xMTEwMjcxMzQ5NDNaFw0xNDEwMjExMzQ5NDNaMHkx\nCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhWaXJnaW5pYTETMBEGA1UEBxMKQWxleGFu\nZHJpYTEfMB0GA1UEChMWQWxleGFuZGVyIFN0cmVldCBQcmVzczEhMB8GA1UEAxMY\nc2hpYi5hbGV4YW5kZXJzdHJlZXQuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEAm7HquS72lySd0gXBNERWazSe97ShgPJwSldxjqBuQ1BvBRp9kdlC\noAZcHmlmsleyIFPOvbc+zaZcYprMj8vmwq3aUE8U5bmpo3WFk8DlrFgzPEIFXuHF\n3/On24Id+WSpajoTOMoopw4uDG2FHbpEKnbMB9MAHK0eVVXfnj/PfwjIEZfw5kBg\n3jpJri3fZME7VQFP6pGS1TlEWslw2PcGlhkQjyiHHzZpHMmfwUKm0QzBMY49HecX\nweB8PmIS5Pnrydx3x09/De8GTJn6rGuYhu7aF0GTw9kC0oToJAF8A2xN9vyXcMtx\nbaMAro05qxlTIOWC1yNeGk9dfcdcTsFeBQIDAQABMA0GCSqGSIb3DQEBBQUAA4IB\nAQBziIy25B83PAlHfpZroG4o6kVdyHKtr26IIb7+8l/5xOg+DZZAqP9KMbScBN1T\nXnKZf7nWfg0CPgrkZFx/M4jCrJgY5eQVlKcxhHGA3b7dXT36DK6gpcxWyB0Hkm1c\n9F++liEzSYao5HItr9epelUvzoQjY/aLT+rGzj0TmufvNxIULojZcWP/CZ1VWVVK\nk4/vgLZs88Ow9eY0GVRAO0g47xPsI4Ozu7HFVZeUsrhouwJKUOdBdHx75mxfoQDP\n68FuNHZ4/rGoVHSJlPjW9zgnNHa3yfGfPN4axlzscowZV/7yGJxeoeBLmicXr+mW\nIeRCblzZC+JMvA/j4d6Mi/s8", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://trs.it.ucla.edu/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California-Los Angeles", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California-Los Angeles", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucla.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://trs.it.ucla.edu/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Anet Avanessian", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aavanessian@it.ucla.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "David H. Lee", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dhlee@ais.ucla.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "IT Services Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sdhelp@it.ucla.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://trs.it.ucla.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Time Reporting System (TRS)", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "The TRS application handles employee time and attendance.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDBzCCAe+gAwIBAgIJAJ9jua5PJ4xzMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMMD3Rycy5pdC51Y2xhLmVkdTAeFw0xMjAxMTIyMjUyNDZaFw0yMjAxMDkyMjUy\nNDZaMBoxGDAWBgNVBAMMD3Rycy5pdC51Y2xhLmVkdTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMg7Fp5pQlQmKm8zqBZPVQdvpDjYkWy5GCe08UYOw8X6\n8SclMw1xYryISDRLWfAHN2Qf8RwI1yvT2zr6F4fMUMqtpx00z0LKBst+bSmnjYXA\n1DMeS98Rwb+/O0i2j6+S7W65OGRyH31rSg4yyyBzHagYGuH2tTKZB5ivQU2kWNkJ\njI8ibTx/g/0wQP3EbitUVGOQLqPMgd2uyK3Nm2uBtI2/gYTFDnCIqe3mhNZW9vtF\np4Jt8lYV3jXclmuw0IOACvnY2uVMPzkjhGwEGLVT45J5xTGUtsXiOZbEdSGOFgBr\nyB+SQxM8nVh0D+EYhbaAd1NBWT9G4Ytf2m9C75OUx9sCAwEAAaNQME4wHQYDVR0O\nBBYEFP4fEl4zjXGn/5DDHVNCRqXDYSSqMB8GA1UdIwQYMBaAFP4fEl4zjXGn/5DD\nHVNCRqXDYSSqMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAAxfzT2b\nHMIAM+Ar6i3XfnQv5Wajma0uWL4+y7hF7nbMIArPpkFlOcnXiI0Hj93ML0wgYgTC\nMRD47fOppwyOGUT5+sG19KdnZUpZYFKmLCV6iOfbxSWPxSYCkQSW9G4GTvo8V2Wr\nvdCZ+N3Ch5lCj911UE8OiTo4HrqzeU6iRtVxKnKpnSHss2JEAzBSgiKa2LAZk2ID\nMhzYTvrT+0TZYaHN6+0NRvNIJt51Q45AIxgQbkfgcMSiZcVN2spYxyENh0ncFOts\nJxOO8nZwdITo838J7uwzwJn3ogeywaWoJl3O9Qmew7mQLwBRXDq7vUWoT5HGdYqG\ndT0MwpTS4w21gvY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://trs.it.ucla.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://trs.it.ucla.edu/Shibboleth.sso/SAML/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://auth.pathbrite.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Pathbrite, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Pathbrite, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.pathbrite.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://auth.pathbrite.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Christopher Gray", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "christopher@pathbrite.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "David Hodnett", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "david@pathbrite.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://auth.pathbrite.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://auth.pathbrite.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://auth.pathbrite.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://auth.pathbrite.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://auth.pathbrite.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://auth.pathbrite.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://auth.pathbrite.com/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Pathbrite Portfolios", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Pathbrite helps you collect, track, and share a lifetime of experiences, bringing you closer to your dream school, internship, or career.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.pathbrite.com", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.pathbrite.com/privacy-policy/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://pr-pathbrite.s3.amazonaws.com/images/pathbrite-logo.jpg", 
                    "width": "320", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "75"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC0zCCAbugAwIBAgIJAKveOjdueT0BMA0GCSqGSIb3DQEBBQUAMA8xDTALBgNV\nBAMTBGF1dGgwHhcNMTMwNTE2MjE0MDM3WhcNMjMwNTE0MjE0MDM3WjAPMQ0wCwYD\nVQQDEwRhdXRoMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApvazeIsJ\n/EnTGTHLeuJxQ6FBBvL97djzWQpQRH6KTZwYiDQIGaGwGeb00IRxPGtJ2SYFqAPB\n+CFV+qyEHSKZVF5AmT019xMtWcNDiO3WZzJazvmMQf3EqD7RjZpuag8mokBtdceE\nvRpBQH7ZNpT43fza0iSQHub+PA1DhoS1T7FauXwJ0BLaueRoTZTjz8MPT7n0J5vl\nxliBj4xyDK4jQ9WEc83ayUx8Lo5+8lIked6poC+tdMNW3aanEXhqNtAb8pzsnhz9\n5uTy21wMrvMwOFS0dpw+zJpcYcOz88rbJsjWv3ZihiZgg3XQ26CqwtJ4a4Vr/ZKe\n+yFwefN0hTrnUwIDAQABozIwMDAPBgNVHREECDAGggRhdXRoMB0GA1UdDgQWBBR/\nzKG2ECxMadrdIGnXlUByydkHhDANBgkqhkiG9w0BAQUFAAOCAQEAJCvfsapkYQ44\nYFmeVxH6RwaudnX8W3Qe7tzYjOL3As+IbD1ibvpC/WmiS6br6RNGGuoS/AVFq1ML\nCnDvWlnibJ0opaL39x2g42rFXH4gx4jkgOUGzPRS6tGWCZQlRKidYU+VdPoSNoTH\nvIqBPF/FOo972NmupVQ7SiI7cJ4jvtTBIQHesOB4TXn1M80HL1Hl2km0kR/D/HRg\nxENRHUwcGajuEYlhraXIhvOmqwUeM76kwMX7zlv6HHnyy87XLEd1MMSVL16eEyAE\nILWNY2gxBp+siMFHgxoNJLymsoxJs10XgbWLvebcF+9/zP2+3qF84oernUsR7fFz\nPe8ibxl07w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Pathbrite helps you collect, track, and share a lifetime of experiences, bringing you closer to your dream school, internship, or career.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Pathbrite Portfolios", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ios-enterprise.uchicago.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Chicago", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Chicago", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uchicago.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ios-enterprise.uchicago.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Cornelia Bailey", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cornelia@uchicago.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Nick Burgess", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "nburgess@uchicago.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "iOS Enterprise", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIICyzCCAbOgAwIBAgIBADANBgkqhkiG9w0BAQUFADAPMQ0wCwYDVQQDEwRnb2F0\nMB4XDTA5MDcwNjE1MzUwOFoXDTE5MDcwNDE1MzUwOFowDzENMAsGA1UEAxMEZ29h\ndDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANQ3+D5cO+cw7yNlh5cV\nAmaBZb67X7AZqdA16LQp/4x9Kz+/O98OLPmGM2fHMRr5hrummdlF8bJo0fP/ivNv\nKCvLoPWyYw1a5v6AMAybd73OBHfn774zsEPhjADpNHSxR/ts7i5mhicPnEr0AWan\nVXUdNWmSnnNtJc1/rWvhxTlFk6XPxWCPZcrMniCL8TSQgV/xFeZKnDLozvhGBNpa\nvxR9p4SDMkBSX58jMRNYGglPKHAalhlC3c5SpMQHZjMWo6M4ADT+ElUPL6JbHcKH\nStAeo5SbT4D1f2Xw3tO+Ad+WtVnQxOzgDoPcSRkkpdnBei/lLQ+bRotoxhcHnPeN\nmKkCAwEAAaMyMDAwDwYDVR0RBAgwBoIEZ29hdDAdBgNVHQ4EFgQU1Rkki39jPqoC\na2L9gz+q67DZ74kwDQYJKoZIhvcNAQEFBQADggEBACMRpWfIIxJoj9YPo6t1D9B8\nvDFgqEfBv0KYO2za1R6Tdm7kq79EA5iQmUkjyKtyt7zOds+QWXz6c6+Sp/h2ZMr0\n0ySmllX/KeNASVl+LOJKnSLacwX/NYM4ukmqztUQCKCsykp0x7uHp7PwvniG0sNa\nTw1qqeN7RixXD+2F6WWDPdqeuya3ydH1bJJIMla/VxBgEb75KGM3yZ/Fe2gxidD8\n7/UfN3oq0cxNwQID0r0Pcmn+Oy3RMttKndgdgdWEZp1t/G6VvPQzHqUxzacQOco6\nyoqxNLl26eihzgZrQcCrp5oY0/LMtosX9LGypBWNTAeVcuttN+smcqpuaWuu65A=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ios-enterprise.uchicago.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://wwwdev.ece.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://wwwdev.ece.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Chad Ziccardi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ziccardi@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "www.ece development", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC/TCCAeWgAwIBAgIJALAaDIVIzmz6MA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEnd3d2Rldi5lY2UuY211LmVkdTAeFw0xMjEwMjUyMTE1NTJaFw0yMjEwMjMy\nMTE1NTJaMB0xGzAZBgNVBAMTEnd3d2Rldi5lY2UuY211LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBALkt6kuyOgPYllBl90m38hqH1B0DuJWwT7QR\n02RjV86mg2Gas6fERbPMlGzzjNAfjiQrOGORSnZ/BQGXgf2cm108tkG9JyIjTZVV\n8/Nl874LQg6CbNu05TkW4Z4fIZsg04SryhxfFREbzjQo+fGSow0OeJxSsEVUR+HN\n2MG8R3l6idgK4X+ZCdXV9gf8XyJXdom+guiKkTUsowQcf+ywaK3etguXNhraad7Z\nWFVetBwBAHvrpjqRt6TE1DqK/uEQIGov5OIqymr8CNcwFDOxI7+2u50e6cUpgsHU\nezaNfyQoqeUJJhcweB0w+lDCw8oqr/froWKHo+AoBBCB6S2HSPcCAwEAAaNAMD4w\nHQYDVR0RBBYwFIISd3d3ZGV2LmVjZS5jbXUuZWR1MB0GA1UdDgQWBBQHkjE38G5m\nLdf6pKrR1lozc0Qj8jANBgkqhkiG9w0BAQUFAAOCAQEAjnqJQonox2TutJnhXVWv\nvJhZcaYk5aY4uU8CcSXdBvxXtatmVRJiGroBwM/imJYRmcp3ZKeOerbh2AqOE/6v\nZJUQSzuTfz2wu2soTysoOpp93aGtAFL+LIttfNMwgqccM7SkKjMAYmme3EOxgkjq\noA6ORDT4VAGpM988KKCsQwX/238sd4lUhAlkgjJxiWmUiUhrSLOwN22L9ZFKEWiy\n6dTyZqgtaCtqbAlRJG+0VIK5NwnaHz9yHVUNOXuBvguwl5akuo3HPo0D5ZVvu4J0\nARfHN4a8WT+B3snhdK62kyL8K92QJw74tb0SK8IMLywxqUPPZcabur6sSMyVr/H9\nTw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wwwdev.ece.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://alynch.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://alynch.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://alynch.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://elgersma.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://elgersma.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://elgersma.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "13", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ddecker.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "14", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ddecker.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "15", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ddecker.wwwdev.ece.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://dl3-psu.decisionlens.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Decision Lens", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Decision Lens", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.decisionlens.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://dl3-psu.decisionlens.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Tony Bennett", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tbennett@decisionlens.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Tony Bennett", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tbennett@decisionlens.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dl3-psu.decisionlens.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dl3-psu.decisionlens.com/Shibboleth.sso/SAML/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://dl3-psu.decisionlens.com/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Decision Lens", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Single Sign-On to the DL3 application for PSU users.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.decisionlens.com/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.decisionlens.com/privacy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.decisionlens.com/InCommon/DL3_FULL.jpg", 
                    "width": "200", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "24"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID1jCCAr4CCQDSh6ILQfutqDANBgkqhkiG9w0BAQUFADCBrDELMAkGA1UEBhMC\nVVMxETAPBgNVBAgMCFZpcmdpbmlhMRIwEAYDVQQHDAlBcmxpbmd0b24xHDAaBgNV\nBAoME0RlY2lzaW9uIExlbnMsIEluYy4xCzAJBgNVBAsMAklUMSEwHwYDVQQDDBhk\nbDMtcHN1LmRlY2lzaW9ubGVucy5jb20xKDAmBgkqhkiG9w0BCQEWGXRiZW5uZXR0\nQGRlY2lzaW9ubGVucy5jb20wHhcNMTIwNzE4MjEyNjQ1WhcNMzIwODIwMjEyNjQ1\nWjCBrDELMAkGA1UEBhMCVVMxETAPBgNVBAgMCFZpcmdpbmlhMRIwEAYDVQQHDAlB\ncmxpbmd0b24xHDAaBgNVBAoME0RlY2lzaW9uIExlbnMsIEluYy4xCzAJBgNVBAsM\nAklUMSEwHwYDVQQDDBhkbDMtcHN1LmRlY2lzaW9ubGVucy5jb20xKDAmBgkqhkiG\n9w0BCQEWGXRiZW5uZXR0QGRlY2lzaW9ubGVucy5jb20wggEiMA0GCSqGSIb3DQEB\nAQUAA4IBDwAwggEKAoIBAQDFkAqfB7lEX5pRQGMop/MlMdVGEbdRHC9GEMW+D8ZZ\ny6AT2aT4Ht7QVZpNvbyICND/5UC13LA075PCJ7KJcYAcI3G+Q+Gv9jDHEtLAXwYS\nhmSY4Qshs2FzFp031bhnclF31jWsgwmLQhvThLKW6Q32HBaNadOS2Iw3J1/CVYoA\nVmntFbRbscKxdGEnrR27z2pwfKbHFwBEKjU6UA2HtVXcZExNTUb+QuLCOGyp1/9w\nbAhUvFTr3TPZz7etKNe/oHQpGBueUA25M+6jOXjRUFeMtT2Su0EBbYwr4YhWb5E9\nx24hFqE9xqZtxBAbmvIqaitJVUjabndOT0liLvifp+8BAgMBAAEwDQYJKoZIhvcN\nAQEFBQADggEBACJqy3rkxjMt5l8mOgwK1gjxyo7sEaxVvcbgKLyzhl0GZkj56R5S\nGlYT+wZmsfZElpMX5piBS8lmpIqqdaAzLnCpXDQC4bZa6UGMBjTrhMiir95ni16V\nBIkryLGnPSwrQIVw9MHtQ2OoBgbVuxxkyHwwqo8SmfWcqEWsM+ovuHG6YzbUmP8p\neXsX2w23KwxjOxkuHmpHQtw2WCMmsDK9M4aH7gdL8vQlUwwuHSUgTKX8ahBGq0Or\nhN5IX8hp0lgS2i9zjMiBxMIS5ZXXx6Sif7JKHxCX5e87R0b97AlgKhAmscLRs0B3\nI8YxUd4VKc/0lzzU6tzCtNtje4sdk/Y5uiU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Single Sign-On to the DL3 application for PSU users.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Decision Lens", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://cms-dev.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://cms-dev.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "CMS Help", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cms-help@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Development Environment for Content Management System", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDCTCCAfGgAwIBAgIJAJewEJxAh8u3MA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFmNtcy1kZXYuYW5kcmV3LmNtdS5lZHUwHhcNMTMwNjI2MjAwOTUwWhcNMjMw\nNjI0MjAwOTUwWjAhMR8wHQYDVQQDExZjbXMtZGV2LmFuZHJldy5jbXUuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxtBaMosdECiFWOm/IfXlq6Cw\njF0zH5EqtQNo9y6M3eJA1jjKn2EvCFyK0YmRomSpfPPUsZQ6YgjYpeEdJ2wYS9TW\nox01BFJijwZajZMqhBcFIul1JrT0bGXzah6jZwrMy+ZJJ/z4s0RqPTrmGQ7pXJbV\noL4EVqv2aYr/ZjsACO6JS7JyParL9EwZuG3TUmDzHWdGma5u+zzTx3qFrxK78oxk\ni1y84u87lt8VxUxMevyzxFRth1eLmuQkl/1S0vGulsq+JDio4hmBhnPqnTeDqSRW\n+MDiZQYwpkcwNjb4hTEAXJQeYueoPELVCFtvLI4UYxM7LtjN28nq4brXJBxJ3QID\nAQABo0QwQjAhBgNVHREEGjAYghZjbXMtZGV2LmFuZHJldy5jbXUuZWR1MB0GA1Ud\nDgQWBBTpoXPIT6F5tRz01wms98o4Ex9EFTANBgkqhkiG9w0BAQUFAAOCAQEAi118\n+XEt8GXRQvbzspemGCtnnyGgXoOYqCyAR9/bCeydX7fF2mOBjosp43R8C1QJ2Zyv\nxsaKEpgeg6vPhcGqAO0TADvqapSq86SfKyAFAbFlEmKe7L61SFFav6mfL2xeOagx\n7p1h9CNCMD8GXG2PMkpRY1G5lG4BZS7XXbAbm5UMdGqfwexxGcWpHk4bcblx/eUM\n/nl98pU4KGsC9wS+zUwtikxYSnHBRZEfsQ7jYI+eRJx4V+89/gV6E16pcJWWf1KO\nLSjbKwOYX7nbQ/ldWFTkCFi5nB/Psufy0lNLyvAsU3T+jTSvke3kT1TGO8rX18R3\n9wJeCDspdjZJhU1sGQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cms-dev.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://wiki-stg.iu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Indiana University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Indiana University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.indiana.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://wiki-stg.iu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "ESI Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "esireq@indiana.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "KB Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kbwiki@indiana.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/Wiki"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://kb.iu.edu/data/axlf.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "IU Knowledge Commons Staging", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Online collaborative environment for sharing information in support of the Indiana University community", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAiigAwIBAgIJAJr1w59/tY1lMA0GCSqGSIb3DQEBBQUAMCYxJDAiBgNV\nBAMTG2h0dHBzOi8vdGVzdC51aXNhcHAyLml1LmVkdTAeFw0xMjA1MjQxMzE5MTJa\nFw0yMjA1MjIxMzE5MTJaMCYxJDAiBgNVBAMTG2h0dHBzOi8vdGVzdC51aXNhcHAy\nLml1LmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK3oE8Zvq26P\n8QcXcLpJ9p2meX7sI0G58zhlIagRb7B8FNGAMTsUm3KT5RkKferhkxmVcb4k870i\nIMi26i1JfmoFAcwCJDKd1ALjNn0BhqGqVzT9F/uztwxHkocxZ0lAf1H7zzQDqSJg\n6HOuFe6na+2Vg4m/Y0TwlR3X6YgEvtdyvQj4Et3blY2RtHc0rcRZ+nVyEXDbLbwT\nVvM+cwEog3kKaoHqaAh6+9orWKlHQ9OpEb3yQ07kZA84jWmz2tUvMvjo32s8vypU\nkTl2LQ4SFzbBudO6Foi6nFmExgcgKmAhRcQaDVo523X+NdSWBxUfklE0XM3HMs/Z\nAiwBXjUmkrcCAwEAAaNxMG8wTgYDVR0RBEcwRYIbaHR0cHM6Ly90ZXN0LnVpc2Fw\ncDIuaXUuZWR1hiZodHRwczovL3Rlc3QudWlzYXBwMi5pdS5lZHUvc2hpYmJvbGV0\naDAdBgNVHQ4EFgQUc7qIZSlNWDRqHwcT/oZznHaRLlYwDQYJKoZIhvcNAQEFBQAD\nggEBAC+UR6mTJWS9F+PluC1t7VGm6mjoTtMphTzX9hjFN+4Iz2fcZstSA/OTy4dM\nWXOqSo1u5NrcgQpEwuzQK2bIqyFx0zbHvG7Uf5BNkXglT4Z/Kd4M9J8rtbt+sZfu\nTznmoEOJ2BvPA2qn69j3Vl/QUvfGiRbfkPK+davKHzVD1zzv6ftzSY+eyxKzkJRS\nLM5PGvOHROkNZcVmMw/r6YQCUbRFlZvBJ4V/uWwohGSlM32V+aeJIZJkdnkZtVTq\nqWmnHpRebQjrAMqPbfFRgv112d5P262GwfbKuzsfgpLrdLDQtbdXjci9UNBia1RD\nnxs/FG20MKeAdMX9vqIrC3f9FfI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki-stg.iu.edu/iukc-stg/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "http://myreviewroom.com/saml2/metadata/v2/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Fluidware Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Fluidware Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.fluidware.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "http://myreviewroom.com/saml2/metadata/v2/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Nate Beacham", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "nate@chide.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://myreviewroom.com/saml2/ls/"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://myreviewroom.com/saml2/acs/"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://fluidreview.com/privacy/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "FluidReview", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://fluidreview.com/wp-content/uploads/2013/11/FluidReviewLogo.jpg", 
                    "width": "39", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "167"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFbTCCBFWgAwIBAgIHJ/h4A9UqWTANBgkqhkiG9w0BAQUFADCByjELMAkGA1UE\nBhMCVVMxEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAY\nBgNVBAoTEUdvRGFkZHkuY29tLCBJbmMuMTMwMQYDVQQLEypodHRwOi8vY2VydGlm\naWNhdGVzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkxMDAuBgNVBAMTJ0dvIERhZGR5\nIFNlY3VyZSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTERMA8GA1UEBRMIMDc5Njky\nODcwHhcNMTIxMTE5MTM1ODU2WhcNMTMxMTE5MTM1ODU2WjBdMRswGQYDVQQKDBIq\nLm15cmV2aWV3cm9vbS5jb20xITAfBgNVBAsTGERvbWFpbiBDb250cm9sIFZhbGlk\nYXRlZDEbMBkGA1UEAwwSKi5teXJldmlld3Jvb20uY29tMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAw/Q7nYoCpYeV5L4lgB0tO+7Bmwzsa6+FgOB5BC+Q\nJaZ51AljJNsSGyp+Vkl/BSD1dgpB0lutT4PE2B8RrZZK8I7muXDwaVa7GXryT9hC\nXMkRKIrqxtpC6DV7/FetWbIgFlAAX6PcmvmJ5hzIp0iCDJFwxwNe8UZCZFXPeLid\n5nfyJJ7d6tH/S+K7883M/XzEQPPzlivE9jIzBCYToOogO9ci2/QeGLJWk9o/Fv2Y\nVUiVV6lUxjAVDKK6vWTVVamjk+GCI9tV1tDHchIiFVuxfJJGfyjrrAraMWkdiePw\nmAN3KRE1p9E48Ur56G81nnWV1ykFB5VyAPRAv3QaIY6NNQIDAQABo4IBwjCCAb4w\nDwYDVR0TAQH/BAUwAwEBADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIw\nDgYDVR0PAQH/BAQDAgWgMDMGA1UdHwQsMCowKKAmoCSGImh0dHA6Ly9jcmwuZ29k\nYWRkeS5jb20vZ2RzMS04MC5jcmwwUwYDVR0gBEwwSjBIBgtghkgBhv1tAQcXATA5\nMDcGCCsGAQUFBwIBFitodHRwOi8vY2VydGlmaWNhdGVzLmdvZGFkZHkuY29tL3Jl\ncG9zaXRvcnkvMIGABggrBgEFBQcBAQR0MHIwJAYIKwYBBQUHMAGGGGh0dHA6Ly9v\nY3NwLmdvZGFkZHkuY29tLzBKBggrBgEFBQcwAoY+aHR0cDovL2NlcnRpZmljYXRl\ncy5nb2RhZGR5LmNvbS9yZXBvc2l0b3J5L2dkX2ludGVybWVkaWF0ZS5jcnQwHwYD\nVR0jBBgwFoAU/axhMpNsRdbi7oVfmrrndplozOcwLwYDVR0RBCgwJoISKi5teXJl\ndmlld3Jvb20uY29tghBteXJldmlld3Jvb20uY29tMB0GA1UdDgQWBBRlh5zTW1Vq\nFyZofFAwhCl0sHd/XjANBgkqhkiG9w0BAQUFAAOCAQEAczjSQ2XKoQRiO16hn7b1\nvquoqk+JX3J83BpND2bPhruilQc7YslPIyDcO4GLFoozUuxOdcrR+QohWnCDXSN2\nKNMJlaOUBOHp7Lv3/Eh0d4QOSGbXyBJcnJKGV7M1JYSDYpKcSpKkCICjz+ax6xKL\npCB7TVW8vyMOvPQnznAtdnR0pogMFZLpfuPWXwK+vzmKb9/iAk0FAJiSfeVVNSKI\ncHnh4AOUPWeRDtX0z/HgGsf8Di5Q9vdxJrk0z4YazeVeNyKhNpnswkKx90PvbOR1\nTsojiCaZQHVJvaPeJDUrXeG1m96f3/PTz6GDeI+JPK4NQdNBZKctQlgYiJvEx7uZ\n6w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "FluidReview", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ncedcloud.mcnc.org/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "MCNC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "MCNC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.mcnc.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ncedcloud.mcnc.org/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "MCNC Technical Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@mcnc.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "NCEdCloud Web Site", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC/TCCAeWgAwIBAgIJAP/VOyOneRX1MA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEm5jZWRjbG91ZC5tY25jLm9yZzAeFw0xMzA5MjcxOTQ5NDNaFw0yMzA5MjUx\nOTQ5NDNaMB0xGzAZBgNVBAMTEm5jZWRjbG91ZC5tY25jLm9yZzCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAM2EcQHENn94+GQTaGQJpg4EnbKnb1wtTkVz\neX3JDfhK5OfzJ4AnbCYddmd81axFAz2cjq7vLPBc91NWCT3wDK2Ga8BZldDIA3m6\nzpo5T6EgAdzn9by3+ahf6P7PKWNqFwZgt83eR4rpZtIR0ry59NGhLLynFexSXJrF\n+BRINyc8TLbGi5nlZrYVAEfUVzgptrsfaKyF7DMyAyO4o70qjosKymtjW5heJ6hk\nJ1y0IaQ3Nw4RFIPp2YOtz+ygRlQpzakUr2nM6EpwPc17tM4CT22/+cEEpvkCTWcg\nsnb3M/9WtlB3h4DpxAXIozE1KDR1whJT0E4akIZ8mqLsHiLBVPkCAwEAAaNAMD4w\nHQYDVR0RBBYwFIISbmNlZGNsb3VkLm1jbmMub3JnMB0GA1UdDgQWBBS9qJOT24oF\n7+PSh5czURLtkLkEPjANBgkqhkiG9w0BAQUFAAOCAQEAJuttmX+RUvnognx2Zpyx\nq4XbjOr4JwDhtwhudOYmKrjGDVp9ubMHhT8nKFBx6HWtlAtyGVLWpeTPe0MMXTs7\naezS9vZaZq9qghmfikN95RpNmG1Fdq1PPwramEwJUT6Rpbs2J6Wqz6VH9kmnUbeU\nazvyoKLDkiKWGgo8SHFBkF2oH8lHhquU7t7WdhZbSiBOezOhipSGFQncv9VlEhTo\nsgCw8wus9WCrkh+/pnUtRSyDpQkllJ7FQQxi1NMRBbM9X5rhBCFmS0QG0Xy/wE8O\netY3OlvEo1zIQgkI40GlIf1HNCUGx5luX2DPzm6iVpUhCSzdtuvNbJu02tNZ75Pt\nJA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ncedcloud.mcnc.org/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://karims-rhel-netreg-dev.net.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://karims-rhel-netreg-dev.net.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Karim Benbourenane", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kbenbour@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Karim's NetReg Dev", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLTCCAhWgAwIBAgIJANQaYEHGfIMEMA0GCSqGSIb3DQEBBQUAMC0xKzApBgNV\nBAMTImthcmltcy1yaGVsLW5ldHJlZy1kZXYubmV0LmNtdS5lZHUwHhcNMTMwMjI3\nMjA0NDU0WhcNMjMwMjI1MjA0NDU0WjAtMSswKQYDVQQDEyJrYXJpbXMtcmhlbC1u\nZXRyZWctZGV2Lm5ldC5jbXUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAz8VRkxzAj8zEg8qJvuAPgdao3MsixajH9GwUgrV6oxlNV3yhOAfYjKgO\ntDqwcuy67WoeaL/i9L6/laoa3yIACAV5LdaEbwnGeU1vIa06xbyL3wfg/RrQuRBM\nsVd3AvUjACqPRit4A9Pl+e4DjsLLyuuijAHjWLtVTd7Mfqfv5EKMXARqu2CGQ51t\nq5WfVC7wW443E7gYUmvbyyxnpuwFiAZDFhRT9tvTXumEqwVlWtkd9CSnUlQRORhL\n4uW/0gQJn7VqDsqKo4UTs53fjOaZPR6IAo1mobo9MY0/fNtvjQctsKYu3VBV1Fj2\nLtS//0eYlBqV+wSQXuL9CU4vUae7kwIDAQABo1AwTjAtBgNVHREEJjAkgiJrYXJp\nbXMtcmhlbC1uZXRyZWctZGV2Lm5ldC5jbXUuZWR1MB0GA1UdDgQWBBTfZ0bjlqeW\njioHcGbXhvjfwOTUHDANBgkqhkiG9w0BAQUFAAOCAQEALaNYwDmgeiqYAANpZqzA\n2aA+x5TCpVmNqMH/qscgV4oiCTc16iHWZZ72Qhjt2AZP11Dl3ZP/dj5RGMh8ZQ5O\nBPopdy7CJxPxm0SVBgmcwFx/SL63QgvdFttfOzuNrf1UCG9dHoM+wDcsl8GlO0xP\nooWqdW7y86CPhPG2pt2vL3R0le5x8ak8ujSL9tnMjW4Wjo41gs0PT2ZHS7Kn/RZu\nEUS9Wu2v1x/ID/ABlMCfzmw/8omd7QHQYa+9hkZEvuhHVg2M4bC8AdXM6PA43HFt\n3SBJnQXi5MVCkQlMEjs5Vh6wAWdT8VLz6r994jXxWY5s7xR5ayQcE14gA7RWjQnO\nRA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://karims-rhel-netreg-dev.net.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.webassign.net/Shibboleth2", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "WebAssign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "WebAssign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.webassign.net/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://www.webassign.net/Shibboleth2", 
      "contact_person": [
        {
          "given_name": {
            "text": "Shibboleth Administrator", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@webassign.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.webassign.net/Shibboleth2.sso/DS"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDODCCAiCgAwIBAgIJAOfetz1Aiz1dMA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTEXd3dy53ZWJhc3NpZ24ubmV0MB4XDTEwMDUyNzEzNDAyNVoXDTEzMDUyNjEz\nNDAyNVowHDEaMBgGA1UEAxMRd3d3LndlYmFzc2lnbi5uZXQwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDI11HbE1+xp3Mo85efCVaWF2bs6c7LYt0l7eyh\nuhbIpRtUs7p+dNUB3WlkqS4s0Zzh3a8yYK8SWwxq0lO1oTANj9D4o4/vogmmWeXx\nWOh1144UsT46WtmmV6+HnXICVZlUne2JS9PPqovSH2N2q1KNAzUvUmowW7ivfVdO\nx1c4ZfNEh4nkSX1Zu/BvtAARBrSxBsFA2vZMHS0bUJKE+107zbxhW4gr/6mOibTn\nj6XgWF2Rv1kvv84rgS/3Gm/TSUcteyeWBT/Ty+eRz31jNjLIBmNByx85BvW/xDWW\njZKKBJEu2S6BmL5fVxxhdSLnyOe0NuCWeFteqJb0SDFA8XPvAgMBAAGjfTB7MB0G\nA1UdDgQWBBTub9YYg8jr1vRZcvh0heb+6J8WDDBMBgNVHSMERTBDgBTub9YYg8jr\n1vRZcvh0heb+6J8WDKEgpB4wHDEaMBgGA1UEAxMRd3d3LndlYmFzc2lnbi5uZXSC\nCQDn3rc9QIs9XTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCZ0/vS\nr9uAVWZ5IYIJRu9qwsQ7I9PyO6kHQjNZREazHl7CpTChZc//6XiJ3TBU1NY12g9H\nWbd9WLLXAeXmxesGuSHltW3FuuVWztr8iibrACRM7XtPMyVMneXF1IZhslGY6ibQ\n9OIn9cCPmWjevEKg7izlWw7IibSGbUi7wjdvzAuqUc3CEILNQVcFW+s80sfNmCZa\nTWd9vYicxQfuSsx/og23lMb8UgQGATzfjqNeewp+lzaxNtMGIGttSNcwmjXehwnd\n73cHgc5xLUeYKuFKku2XzDq4XrnN5tMz/pF0KdoLATqHvZ6AnpiJmHqhxI1CkXDO\ns0WsDZkzPWbGwYhP", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.webassign.net/Shibboleth2.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.webassign.net/Shibboleth2.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.webassign.net/Shibboleth2.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.webassign.net/Shibboleth2.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.webassign.net/Shibboleth2.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.webassign.net/Shibboleth2.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibidp.colostate.edu/idp/shibboleth", 
    {
      "entity_id": "https://shibidp.colostate.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.colostate.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.colostate.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.colostate.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.colostate.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "colostate.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFADCCA+igAwIBAgIJAKgd911n52t3MA0GCSqGSIb3DQEBBQUAMIGwMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMIQ29sb3JhZG8xFTATBgNVBAcTDEZvcnQgQ29sbGlu\nczEiMCAGA1UEChMZQ29sb3JhZG8gU3RhdGUgVW5pdmVyc2l0eTEzMDEGA1UECxMq\nQWNhZGVtaWMgQ29tcHV0aW5nIGFuZCBOZXR3b3JraW5nIFNlcnZpY2VzMR4wHAYD\nVQQDExVzaGliaWRwLmNvbG9zdGF0ZS5lZHUwHhcNMTIxMDE1MTk0MDA1WhcNMTQx\nMjAxMTk0MDA1WjCBsDELMAkGA1UEBhMCVVMxETAPBgNVBAgTCENvbG9yYWRvMRUw\nEwYDVQQHEwxGb3J0IENvbGxpbnMxIjAgBgNVBAoTGUNvbG9yYWRvIFN0YXRlIFVu\naXZlcnNpdHkxMzAxBgNVBAsTKkFjYWRlbWljIENvbXB1dGluZyBhbmQgTmV0d29y\na2luZyBTZXJ2aWNlczEeMBwGA1UEAxMVc2hpYmlkcC5jb2xvc3RhdGUuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAraUAjd/Ievtea/RsN1SC67gC\n1DsoWW5MDnkCySMu3zU5zgJpS5mlJXdk7UwefHvfRlloYnS+oK+a8bv0ZRkbl3Gu\ns+R2RjVpasoajGCP7R+Wu3jLSHgTvEAGu2FD/7Fi3zGOonPspje3TjO5jMOXT0FK\nUH/SLd6/VF51jrXHoKiQCM6mDtzeJPONeCrJaQ87ljZQ8PvpXgdRaOH65vYB5tBG\nvgWkRgE7rT7Qvf7NaXAhY87s79bZiD0WGqr6HKaXPH2GV6hgK3HjNbQvwIiWG+R/\nueyKarFp21ThtAM7uZD+xc8HLSriRCkj/hupl7l/J8dRE91/SZndZoAqj7/M2wID\nAQABo4IBGTCCARUwHQYDVR0OBBYEFL0sOTkizYUO1PkTjTSUGgLd7KaVMIHlBgNV\nHSMEgd0wgdqAFL0sOTkizYUO1PkTjTSUGgLd7KaVoYG2pIGzMIGwMQswCQYDVQQG\nEwJVUzERMA8GA1UECBMIQ29sb3JhZG8xFTATBgNVBAcTDEZvcnQgQ29sbGluczEi\nMCAGA1UEChMZQ29sb3JhZG8gU3RhdGUgVW5pdmVyc2l0eTEzMDEGA1UECxMqQWNh\nZGVtaWMgQ29tcHV0aW5nIGFuZCBOZXR3b3JraW5nIFNlcnZpY2VzMR4wHAYDVQQD\nExVzaGliaWRwLmNvbG9zdGF0ZS5lZHWCCQCoHfddZ+drdzAMBgNVHRMEBTADAQH/\nMA0GCSqGSIb3DQEBBQUAA4IBAQA9NH43mvqtCB7aS8Z4CVrf+C15Mj90LscY/w+B\n80uXUke070aQp57r9xRkdIng6kBLQqZB/IZrq9zTjDm6xlDDZ3Qf4EQAVjM9GI1u\nI9Yg3uZmnABkR8ioYGCtmlfyqyWekXsFEYEi035kpxH4bmXLKeNH/JGPr/3o85Sl\nO0I6nOsH6DIEQBVFqndPBeMo1Cd+E5arWLHAff0evjkGK58tALqGanrdmiFQOiIY\ntp3vBFIF/Ehnxgwwgqd2/GvkKK2ln5nr3u1RT4YI2yC7JXI28thCnAf4pQnb+XxP\nM9e0DzCKCZ3WezRoLS/5bHUOkUMwioecOv605C7zZUA6LIbK", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibidp.colostate.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibidp.colostate.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category-support"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "colostate.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFADCCA+igAwIBAgIJAKgd911n52t3MA0GCSqGSIb3DQEBBQUAMIGwMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMIQ29sb3JhZG8xFTATBgNVBAcTDEZvcnQgQ29sbGlu\nczEiMCAGA1UEChMZQ29sb3JhZG8gU3RhdGUgVW5pdmVyc2l0eTEzMDEGA1UECxMq\nQWNhZGVtaWMgQ29tcHV0aW5nIGFuZCBOZXR3b3JraW5nIFNlcnZpY2VzMR4wHAYD\nVQQDExVzaGliaWRwLmNvbG9zdGF0ZS5lZHUwHhcNMTIxMDE1MTk0MDA1WhcNMTQx\nMjAxMTk0MDA1WjCBsDELMAkGA1UEBhMCVVMxETAPBgNVBAgTCENvbG9yYWRvMRUw\nEwYDVQQHEwxGb3J0IENvbGxpbnMxIjAgBgNVBAoTGUNvbG9yYWRvIFN0YXRlIFVu\naXZlcnNpdHkxMzAxBgNVBAsTKkFjYWRlbWljIENvbXB1dGluZyBhbmQgTmV0d29y\na2luZyBTZXJ2aWNlczEeMBwGA1UEAxMVc2hpYmlkcC5jb2xvc3RhdGUuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAraUAjd/Ievtea/RsN1SC67gC\n1DsoWW5MDnkCySMu3zU5zgJpS5mlJXdk7UwefHvfRlloYnS+oK+a8bv0ZRkbl3Gu\ns+R2RjVpasoajGCP7R+Wu3jLSHgTvEAGu2FD/7Fi3zGOonPspje3TjO5jMOXT0FK\nUH/SLd6/VF51jrXHoKiQCM6mDtzeJPONeCrJaQ87ljZQ8PvpXgdRaOH65vYB5tBG\nvgWkRgE7rT7Qvf7NaXAhY87s79bZiD0WGqr6HKaXPH2GV6hgK3HjNbQvwIiWG+R/\nueyKarFp21ThtAM7uZD+xc8HLSriRCkj/hupl7l/J8dRE91/SZndZoAqj7/M2wID\nAQABo4IBGTCCARUwHQYDVR0OBBYEFL0sOTkizYUO1PkTjTSUGgLd7KaVMIHlBgNV\nHSMEgd0wgdqAFL0sOTkizYUO1PkTjTSUGgLd7KaVoYG2pIGzMIGwMQswCQYDVQQG\nEwJVUzERMA8GA1UECBMIQ29sb3JhZG8xFTATBgNVBAcTDEZvcnQgQ29sbGluczEi\nMCAGA1UEChMZQ29sb3JhZG8gU3RhdGUgVW5pdmVyc2l0eTEzMDEGA1UECxMqQWNh\nZGVtaWMgQ29tcHV0aW5nIGFuZCBOZXR3b3JraW5nIFNlcnZpY2VzMR4wHAYDVQQD\nExVzaGliaWRwLmNvbG9zdGF0ZS5lZHWCCQCoHfddZ+drdzAMBgNVHRMEBTADAQH/\nMA0GCSqGSIb3DQEBBQUAA4IBAQA9NH43mvqtCB7aS8Z4CVrf+C15Mj90LscY/w+B\n80uXUke070aQp57r9xRkdIng6kBLQqZB/IZrq9zTjDm6xlDDZ3Qf4EQAVjM9GI1u\nI9Yg3uZmnABkR8ioYGCtmlfyqyWekXsFEYEi035kpxH4bmXLKeNH/JGPr/3o85Sl\nO0I6nOsH6DIEQBVFqndPBeMo1Cd+E5arWLHAff0evjkGK58tALqGanrdmiFQOiIY\ntp3vBFIF/Ehnxgwwgqd2/GvkKK2ln5nr3u1RT4YI2yC7JXI28thCnAf4pQnb+XxP\nM9e0DzCKCZ3WezRoLS/5bHUOkUMwioecOv605C7zZUA6LIbK", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibidp.colostate.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibidp.colostate.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Colorado State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Colorado State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.colostate.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Randy Miotke", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@colostate.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Kevin Swab", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@colostate.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Scott Baily", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@colostate.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://wiki.ligo.org/shibboleth-sp", 
    {
      "entity_id": "https://wiki.ligo.org/shibboleth-sp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "LIGO Scientific Collaboration", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "LIGO Scientific Collaboration", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ligo.caltech.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Scott Koranda", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "scott.koranda@ligo.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Warren Anderson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "warren.anderson@ligo.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "LIGO Identity Management Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "rt-auth@ligo.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "LIGO Security Committee", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "contact_type": "other", 
          "email_address": [
            {
              "text": "lsc-seccomm@ligo.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.ligo.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.ligo.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.ligo.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wiki.ligo.org/Shibboleth.sso/SAML2/ECP"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://wiki.ligo.org/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "LIGO Wiki", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Primary LIGO Scientific Collaboration wiki", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "https://wiki.ligo.org/Main/SPInformationURL", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://dcc.ligo.org/cgi-bin/DocDB/ShowDocument?docid=89243", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://login.ligo.org/SAML2/metadata/ui/ligologo80x60.png", 
                    "width": "80", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "60"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEVjCCAz6gAwIBAgIBATANBgkqhkiG9w0BAQUFADCBhzETMBEGCgmSJomT8ixk\nARkWA29yZzEUMBIGCgmSJomT8ixkARkWBGxpZ28xDTALBgNVBAoTBExJR08xIDAe\nBgNVBAsTF0NlcnRpZmljYXRlIEF1dGhvcml0aWVzMRUwEwYDVQQLEwxXZWIgU2Vy\ndmljZXMxEjAQBgNVBAMTCUxJR08gQ0EgMTAeFw0xMDAyMDMyMDAyMTBaFw0yMDAy\nMDMyMDAyMTBaMGkxEzARBgoJkiaJk/IsZAEZFgNvcmcxFDASBgoJkiaJk/IsZAEZ\nFgRsaWdvMQ0wCwYDVQQKEwRMSUdPMRUwEwYDVQQLEwxXZWIgU2VydmljZXMxFjAU\nBgNVBAMTDXdpa2kubGlnby5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQCsizfsa9/YZeLqX0vLLrPxFG0M1cRzSOGOpfxwo3iYPbsw08uFuYjufCaT\nfDQr9T+ZimAlpBP4+yETnYa9R/A65Zmv7ydyge8SfKIdMRY2U23PSBQKMRTp/EdC\n+LFAVZQWlKNmfb9ajrFo776dWU1ZU9NHFkX3dMTeH+BI+kRIMZnlPp7urSutuLMj\nDhoT41XufOUeJUwFm+7g1lf+cbCSPmgRGEa46gHBI+572mOCck7GN0+Zj0H74o5i\nesZrMDf08E6qsH6KnahuMuZH22L25KHULq4P9ByNFGDScvgj34HlLo91J4SzHTjS\nwx/JNBwg4V1bV4o9SGvCrRLBrSr/AgMBAAGjgekwgeYwDAYDVR0TAQH/BAIwADAO\nBgNVHQ8BAf8EBAMCBLAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMBkG\nA1UdIAQSMBAwDgYMKwYBBAGB+kYCAQIBMDkGA1UdHwQyMDAwLqAsoCqGKGh0dHA6\nLy9jYS5saWdvLm9yZy81NDE0MDRjMy81NDE0MDRjMy5jcmwwHwYDVR0jBBgwFoAU\nUm7de6pvhVwIItOXn61/I1YeatEwMAYDVR0RBCkwJ4INd2lraS5saWdvLm9yZ4EW\nc2NvdHQua29yYW5kYUBMSUdPLk9SRzANBgkqhkiG9w0BAQUFAAOCAQEAnrDCVAKE\nsv/StHC2c6VwYtrW14rgn/gmOYTWvfioYmteCuS5bqADuCN1qdNxi5nHsgXhX7UE\naaLeOKBqhNbqu+YiS/va0Kk3Azq7BS+KC0iBhHMM+ZZ86jl93ItV/xsuBc5v/AWx\njqqsEN8CN35bvZaNwm0mBARfhVll2b2T3r80mdmVbekcJKEry4H0ogGgYWNkcBt3\nrlVaEUap5FC3UzyTmKCkL65y0emhsR+6CEnmyTq5qOlMeyrgKlIJ8YXf/xj6oUaD\n6Zqf7DNzVW6gez9VkUlhivSgXaAfAZ9aJJn/aOsK3BUjJTmUCvps1F6THRr4tc0+\nfMO5DI9dhv07eg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Primary LIGO Scientific Collaboration wiki", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "LIGO Wiki", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ehs.ucop.edu/bss", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucop.edu/welcome.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ehs.ucop.edu/bss", 
      "contact_person": [
        {
          "given_name": {
            "text": "SDSC Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@sdsc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "SDSC Web/DB", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "webdb@sdsc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC3DCCAcSgAwIBAgIJAMORXLOSlITaMA0GCSqGSIb3DQEBBQUAMBIxEDAOBgNV\nBAMTB2Jzcy13ZWIwHhcNMTExMDI3MjEzNTA0WhcNMjExMDI0MjEzNTA0WjASMRAw\nDgYDVQQDEwdic3Mtd2ViMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\n6PAnQVa8jK1pciFgiCkXKRplpQfwoMat8H0z8Jx6kTxOpdQ5miHOakoOoqjp/Lzz\nJKVuqdMovZIddEOM2M8F+praT1SdQVDlpk7JenTiwWlwkgWornSMGyq2ABLYDgf2\nlsB485RBIEGgn9KR6CkNyx19DfNcaK6v5xiFCdRrpU6mDZMemYnk8ajh8qO5MB8D\nnsC70kicjloO8CbCmYe9Yxz20gBqAvw9a5uTqQu3i/rAL2MY8S7kgi6Tf2/cld+S\nnC80CwYqbpQfe6t9TlnUOmfNNKNll/Ov2B8UZ7Sa5m47DQx6YxZntWDR+RoUObMX\nBlNHIsVl7gvhUwGKIHQoWQIDAQABozUwMzASBgNVHREECzAJggdic3Mtd2ViMB0G\nA1UdDgQWBBTjuO36MDQx2h/x5Ibq3wLC6WmuvTANBgkqhkiG9w0BAQUFAAOCAQEA\nV3o9AvLvVe0nhX9+mKbHaC8DX+8MZGxseRED4TZj9EbJHnT2jItZEfYAsQxNXWgJ\nROsUMMXGsksOzPZ5jgGgjL5YXLU4G8MqDUnUKUaRXvc8UlubdvdMhPK0G9HCgVRt\nllnXqkOn3c2OUXGLg7jfQv1YXCHOW0PQMQ9SpOa1d5A5SoAZy3NDykVdUH0gEh8+\nS/aAUpJ05U0d6xYPQKLUkd4Q5bBuIFR/e/Tg+QEjjfARtgcp9wTvWJTLXNyc1dtE\nJDaQQ4igkHA0YTZQ81AINEKvS0WAPClYNt8f8hDkj/6dafjm2SFydwC+lY41zyiw\nwPIsRK6zr52jFpEEqiy4Xg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ehs.ucop.edu/bss/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ehs.ucop.edu/bss/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:psu.edu", 
    {
      "entity_id": "urn:mace:incommon:psu.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://as1.fim.psu.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://as1.fim.psu.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://as1.fim.psu.edu/idp/profile/SAML2/SOAP/ECP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://as1.fim.psu.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://as1.fim.psu.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "psu.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.psu.edu/web-privacy-statement", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.psu.edu/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Penn State", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://ait.its.psu.edu/psulogoforincommon.png", 
                    "width": "130", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "70"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE+jCCA+KgAwIBAgIJAL8NZFMAw3T+MA0GCSqGSIb3DQEBBQUAMIGuMQswCQYD\nVQQGEwJVUzEVMBMGA1UECBMMUGVubnN5bHZhbmlhMRgwFgYDVQQHEw9Vbml2ZXJz\naXR5IFBhcmsxKjAoBgNVBAoTIVRoZSBQZW5uc3lsdmFuaWEgU3RhdGUgVW5pdmVy\nc2l0eTEoMCYGA1UECxMfSW5mb3JtYXRpb24gVGVjaG5vbG9neSBTZXJ2aWNlczEY\nMBYGA1UEAxMPYXMxLmZpbS5wc3UuZWR1MB4XDTEyMDQxMTE5MjMzNFoXDTMyMDQw\nNjE5MjMzNFowga4xCzAJBgNVBAYTAlVTMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWEx\nGDAWBgNVBAcTD1VuaXZlcnNpdHkgUGFyazEqMCgGA1UEChMhVGhlIFBlbm5zeWx2\nYW5pYSBTdGF0ZSBVbml2ZXJzaXR5MSgwJgYDVQQLEx9JbmZvcm1hdGlvbiBUZWNo\nbm9sb2d5IFNlcnZpY2VzMRgwFgYDVQQDEw9hczEuZmltLnBzdS5lZHUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDgDw/HyxwqLZGLR1s6ewzwji0fx1dq\nY4GoNycD8brxxnA11BgL0cSIM0WYyfOJBUxBhmkrlWccZDPPOmAC5qlPfLO8GjIS\nyFQrMFyhCynYKlP0Clm/59FkM/Jw2GPFmVXgM+dczk75f0sOaQzmay8pZdnOX3SX\nCX4aiOU+PFUqSuF94Ug/DkSeVHf9x6aV6A/e2iWHsigHTXNL5T5n29iNPRjdQ7NT\nJBnMGMpzjoZkFvmlVsplt6bTT7v81khDQItvTXVz1l9b3P3scYU2a3tRHFuyHRr8\nAHaqRDwIeDP4EaQcMHkD5EktM8RkOiPFYZQwSSrhM5F7gk/rFOXg+ZOvAgMBAAGj\nggEXMIIBEzAdBgNVHQ4EFgQU5I99+kOGxYuGIeGYPeB8BdbR0GUwgeMGA1UdIwSB\n2zCB2IAU5I99+kOGxYuGIeGYPeB8BdbR0GWhgbSkgbEwga4xCzAJBgNVBAYTAlVT\nMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWExGDAWBgNVBAcTD1VuaXZlcnNpdHkgUGFy\nazEqMCgGA1UEChMhVGhlIFBlbm5zeWx2YW5pYSBTdGF0ZSBVbml2ZXJzaXR5MSgw\nJgYDVQQLEx9JbmZvcm1hdGlvbiBUZWNobm9sb2d5IFNlcnZpY2VzMRgwFgYDVQQD\nEw9hczEuZmltLnBzdS5lZHWCCQC/DWRTAMN0/jAMBgNVHRMEBTADAQH/MA0GCSqG\nSIb3DQEBBQUAA4IBAQCE5rt7hCbcrtwqaR6e9Z4nRfWdkQYtGTWi9UaBFhS7MLJB\nt4FyP+ohfRshQGAwJjekQW28GhuoDWngcdZFhE0ktYwct2zKhUDe8ggPWJWPLnlD\nUMiSX6BIn6tgpkpqpwduCoceQqLD2XnT33X7Fur0qohGW2EFPKxKHEVHXtfcHEsZ\nsBGSEC21XV/796AI8JQ4rb8ASWaLSjoGGwlZjsDogIzUJAuMdBPuG/CkbTJDjsii\nu9cF1oLJGzUEXx6B1ugWfWxVeUumOE0PGX3uPijrOd3Ak1gRevg//iyMw+zvL9xL\n4e+XA3Dtyu/I5Riwwv3AF7MFfNpiFhs0ay1ARC8y", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://as1.fim.psu.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://as1.fim.psu.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "psu.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE+jCCA+KgAwIBAgIJAL8NZFMAw3T+MA0GCSqGSIb3DQEBBQUAMIGuMQswCQYD\nVQQGEwJVUzEVMBMGA1UECBMMUGVubnN5bHZhbmlhMRgwFgYDVQQHEw9Vbml2ZXJz\naXR5IFBhcmsxKjAoBgNVBAoTIVRoZSBQZW5uc3lsdmFuaWEgU3RhdGUgVW5pdmVy\nc2l0eTEoMCYGA1UECxMfSW5mb3JtYXRpb24gVGVjaG5vbG9neSBTZXJ2aWNlczEY\nMBYGA1UEAxMPYXMxLmZpbS5wc3UuZWR1MB4XDTEyMDQxMTE5MjMzNFoXDTMyMDQw\nNjE5MjMzNFowga4xCzAJBgNVBAYTAlVTMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWEx\nGDAWBgNVBAcTD1VuaXZlcnNpdHkgUGFyazEqMCgGA1UEChMhVGhlIFBlbm5zeWx2\nYW5pYSBTdGF0ZSBVbml2ZXJzaXR5MSgwJgYDVQQLEx9JbmZvcm1hdGlvbiBUZWNo\nbm9sb2d5IFNlcnZpY2VzMRgwFgYDVQQDEw9hczEuZmltLnBzdS5lZHUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDgDw/HyxwqLZGLR1s6ewzwji0fx1dq\nY4GoNycD8brxxnA11BgL0cSIM0WYyfOJBUxBhmkrlWccZDPPOmAC5qlPfLO8GjIS\nyFQrMFyhCynYKlP0Clm/59FkM/Jw2GPFmVXgM+dczk75f0sOaQzmay8pZdnOX3SX\nCX4aiOU+PFUqSuF94Ug/DkSeVHf9x6aV6A/e2iWHsigHTXNL5T5n29iNPRjdQ7NT\nJBnMGMpzjoZkFvmlVsplt6bTT7v81khDQItvTXVz1l9b3P3scYU2a3tRHFuyHRr8\nAHaqRDwIeDP4EaQcMHkD5EktM8RkOiPFYZQwSSrhM5F7gk/rFOXg+ZOvAgMBAAGj\nggEXMIIBEzAdBgNVHQ4EFgQU5I99+kOGxYuGIeGYPeB8BdbR0GUwgeMGA1UdIwSB\n2zCB2IAU5I99+kOGxYuGIeGYPeB8BdbR0GWhgbSkgbEwga4xCzAJBgNVBAYTAlVT\nMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWExGDAWBgNVBAcTD1VuaXZlcnNpdHkgUGFy\nazEqMCgGA1UEChMhVGhlIFBlbm5zeWx2YW5pYSBTdGF0ZSBVbml2ZXJzaXR5MSgw\nJgYDVQQLEx9JbmZvcm1hdGlvbiBUZWNobm9sb2d5IFNlcnZpY2VzMRgwFgYDVQQD\nEw9hczEuZmltLnBzdS5lZHWCCQC/DWRTAMN0/jAMBgNVHRMEBTADAQH/MA0GCSqG\nSIb3DQEBBQUAA4IBAQCE5rt7hCbcrtwqaR6e9Z4nRfWdkQYtGTWi9UaBFhS7MLJB\nt4FyP+ohfRshQGAwJjekQW28GhuoDWngcdZFhE0ktYwct2zKhUDe8ggPWJWPLnlD\nUMiSX6BIn6tgpkpqpwduCoceQqLD2XnT33X7Fur0qohGW2EFPKxKHEVHXtfcHEsZ\nsBGSEC21XV/796AI8JQ4rb8ASWaLSjoGGwlZjsDogIzUJAuMdBPuG/CkbTJDjsii\nu9cF1oLJGzUEXx6B1ugWfWxVeUumOE0PGX3uPijrOd3Ak1gRevg//iyMw+zvL9xL\n4e+XA3Dtyu/I5Riwwv3AF7MFfNpiFhs0ay1ARC8y", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://as1.fim.psu.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://as1.fim.psu.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "The Pennsylvania State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Penn State", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.psu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Technical Staff", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "root@aset.psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Mark Miller", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "max@psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Nicholas Roy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "nicholas-roy@psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Penn State IT Service Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "itservicedesk@psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://dashboard.net.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://dashboard.net.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Steven Snodgrass", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ssnodgra@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Network Dashboard Service", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDBjCCAe6gAwIBAgIJAMBZjEs6C2FEMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFWRhc2hib2FyZC5uZXQuY211LmVkdTAeFw0xMjAyMDIxOTI1MTNaFw0yMjAx\nMzAxOTI1MTNaMCAxHjAcBgNVBAMTFWRhc2hib2FyZC5uZXQuY211LmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPt35qcdhcm/65mtCkOtZt4joyc7\n4F2EdR3D+0Tnn5FGc7AH74/a/IYuT8XPCUvetiz1uM7pPrl00WYV8NeoI1kQPRUI\nSo9jb1nfU17vHGFNir3ukNs9lRVkqgod3xRnCmQcdJS83sr8bdnF/UR/qfusphL4\nICFr1eKYIFShp8TuwvuWw1Kv0GsrWRmSDmXl1QnSoxKWpChFBFexE4M2IuatVTFj\nYrKCNEBMGZyhLKrEbSvht5eoTFhVsr1FZ/yOwZG4lLdySBhfiNaNlumdwiRR1pom\ng0eRpVWXSJwI94goGNJ+zf7Gb5u6TV1EF5zMr5Ki/igQ4HnCF0GnVbj4HvECAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVZGFzaGJvYXJkLm5ldC5jbXUuZWR1MB0GA1UdDgQW\nBBSpaQ61/A0Cw7gEZ2CYbo65XFypJTANBgkqhkiG9w0BAQUFAAOCAQEA+GD+2Ug6\nSNN4CGbFu7Zdl9pyTRRX/aQLZKtPJbhWZCWzRrS47cYP6NsMoF0OFClaE9mkBfrx\ntcj2oHBTQibuAtG540uOB6aeaIp7sSmrM4hsRSRuKZKF+Y9c40K6FT5Q62vDzoXB\nGs6+ny+89y6TXk464HWUjvpcVCeTklr+BRdavQ53ako/bcmvjeSwcuaIsBkORPKN\n+Egg5jZNAxnGCi1ISnWEsNKjGBGisLYiz1HPmVLzXuD4BwhJOBDN/yf2hwdydQGN\nxV0uqIxA+IJsugGGtbCcWXfnPB9UOxAhRjSbLEU/05r5GeMY7eP8gLKdl1Q1WgeE\nBSWFnKmETpniAg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dashboard.net.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth-uncg-advocate.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-uncg-advocate.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UNCG Advocate", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID1DCCArwCCQCxjIK+luI0VTANBgkqhkiG9w0BAQUFADCBqzELMAkGA1UEBhMC\nVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQHEwlBcmxpbmd0b24xHzAdBgNV\nBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xMDAuBgNVBAMTJ3NoaWJib2xldGgt\ndW5jZy1hZHZvY2F0ZS5zeW1wbGljaXR5LmNvbTEiMCAGCSqGSIb3DQEJARYTc2hp\nYkBzeW1wbGljaXR5LmNvbTAeFw0xMzEwMjgxOTMxMThaFw0xNjEwMjcxOTMxMTha\nMIGrMQswCQYDVQQGEwJVUzERMA8GA1UECBMIVmlyZ2luaWExEjAQBgNVBAcTCUFy\nbGluZ3RvbjEfMB0GA1UEChMWU3ltcGxpY2l0eSBDb3Jwb3JhdGlvbjEwMC4GA1UE\nAxMnc2hpYmJvbGV0aC11bmNnLWFkdm9jYXRlLnN5bXBsaWNpdHkuY29tMSIwIAYJ\nKoZIhvcNAQkBFhNzaGliQHN5bXBsaWNpdHkuY29tMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAnPaq5I/e9HhpA9wlOklMviugoefpa8fCqicH0TvqUcyS\n96PRBqjgOeXh28HhGgsWLR6wH22vs84Y4fmIIreA8ejspa2aqPcpdf4TnM5Lrw1+\nu0d4xKVEn1ACXBCDtQbmJKUlucRi6uFgN1/aqZW4p0NIDKSFChulcHxr6MgycRrp\nJ7JKKPgxh2+ExlQWhVDJOz0Vo5jH/gXCnF531AUbZR9o3Fzw4fpK0Ly8oB153DJI\nWVIl5qDdJ0mfeq/eAfSDpJD1EXqDaAqoiTjOdwF9/pP3LnroaF/8Wvez7UHqEM+W\nRQlq3GdO2t9aseMiJnaErvd+7xLNYEW6QbgvXvdmGQIDAQABMA0GCSqGSIb3DQEB\nBQUAA4IBAQCRrR4XkoMSPJs6/DqGlz7mJYaqC5X5Cdi1lXM/4zfMhktqe6kzkyz2\nCede4mYfDsv6XwHnI2owq+CH+DB6BIPUXOLUrKx879oLcBO2y4H/l0w2OYKMGZLU\nvQNQh28jsFwfpKns6CQ478GnP7/N8Mtismrq25KVrJVSiL5Ug1Y8wDjos6LkYaav\nqxI4hzrt3iv8kki5YxVny6hm2/AM0ogZ/HfP43fpGw0YspQWPwJLOLQ8QzsCUJNp\n1Fnwyva0N/9W8Kja5FYCP/BcAJYnYy/eWdpahKF5lpOy/S6EL53EJXwUZ8VGFBmm\nwDBsxPTRu/LTorfV+30rVerwJv+dEUOr", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-uncg-advocate.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-uncg-advocate.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth-wustl-accommodate.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-wustl-accommodate.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "shibboleth-wustl-accommodate", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID3DCCAsQCCQDlgsfIlhpTATANBgkqhkiG9w0BAQUFADCBrzELMAkGA1UEBhMC\nVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQHEwlBcmxpbmd0b24xHzAdBgNV\nBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xNDAyBgNVBAMTK3NoaWJib2xldGgt\nd3VzdGwtYWNjb21tb2RhdGUuc3ltcGxpY2l0eS5jb20xIjAgBgkqhkiG9w0BCQEW\nE3NoaWJAc3ltcGxpY2l0eS5jb20wHhcNMTMwODI2MTI0MTM0WhcNMTYwODI1MTI0\nMTM0WjCBrzELMAkGA1UEBhMCVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQH\nEwlBcmxpbmd0b24xHzAdBgNVBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xNDAy\nBgNVBAMTK3NoaWJib2xldGgtd3VzdGwtYWNjb21tb2RhdGUuc3ltcGxpY2l0eS5j\nb20xIjAgBgkqhkiG9w0BCQEWE3NoaWJAc3ltcGxpY2l0eS5jb20wggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDFDRojCCIWUaAClNH5mT3IFQ7vPoTPuIqQ\n3ZWiS+DbFGuVN0TyDG0k3dT0uI3JWVIylSFxEWkCOBHHQypG6ysMsP0JiCb3gcYH\n8D6bkNEPxzSeWRheGiNas8VnImu7Rkn5dQXOWy19/S5q705pbKyCNsqqDj9v1b6J\n47Zw/0Fe19chb1KVwYeWyEvRVK09gvXA20nawEd/f1B93AM0RyASCBGoKLnOC+WK\n4iN1ts1EqYs5GX75VBLUkLtMVlrj/3lDzNp6NXZS7GJl1k8fDfe8Q/aj6GZb7vYf\nfkKpg6MrbI9Kx81lMGDQhUSx+jwBRD+f5btUi+nLt8NyM6CFnmTTAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggEBAGI54ulLT6LpGMxL67+jbs69Eogw+q1f5JjsNHg0qwKt\nOjW3T8iupAFgtPgQ3lnYI29W7vGNWCJiiRJ04exLx5xipZ4oAMqKZh1CKQ4DVIFM\nKB0cZ7t2TeNow/2WiL8iiDT8Zfa1gWw8vurgCyt3UoyElLD7UmV5Zi4RIH2LGYwQ\n2o1rXLwLoqqyJkVGkekGggfcNWDt5M/5yDwcS6C9R0KBkBSC7Ufu0XI0+1TCmUWf\nzjmiZw6ZSZV3Tqefj/wN52rdm3X6oyzIs5pQZlotKwyg8zSD1pNzLRGqgULnRdVj\nxxh4QdBY8iVu9GzXRZgzq7XS+f9Uz+UgiEpAWEwdFgU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-wustl-accommodate.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-wustl-accommodate.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://legislation.uiowa.edu/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Iowa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Iowa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uiowa.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://legislation.uiowa.edu/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Iowa federation requests", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "iowa-federation-requests@uiowa.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Kerri Mead", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kerri-mead@uiowa.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://legislation.uiowa.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://legislation.uiowa.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://legislation.uiowa.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://legislation.uiowa.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://legislation.uiowa.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Iowa Regents' Government Relations", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "State of Iowa Board of Regents government relations application for regents institutions", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDDzCCAfegAwIBAgIJAIx4mdGYUIprMA0GCSqGSIb3DQEBBQUAMCMxITAfBgNV\nBAMTGGl0c250MTAzMy5pb3dhLnVpb3dhLmVkdTAeFw0xMTEyMDIxOTAxMTRaFw0y\nMTExMjkxOTAxMTRaMCMxITAfBgNVBAMTGGl0c250MTAzMy5pb3dhLnVpb3dhLmVk\ndTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMeiAELN6qqGfQDLqobj\n4u6E1kY+h/QQN2tn7J3RVXshxAkio9oRychRGzXNbQO6+fD3UbkpiMbOLlqbVwRu\nmBNudxmjjeFlQJGGDdSUIbPb1LB3zTO12pFiGhUZAD7UgD0LxITJAEaIMLLXF2h9\nY134VAnHybyeSU+2+z3jIaRao/oCvCRhYfA3JY4BwziyOBZsqKkzUH5jj74XqGGL\nQ1qWczN8XaiIbNEuLZCXL+pqjFFDyL037sm6b1e6vRRRocL3j4GWNzC5H9S6migI\n2a+0ddzzLJew9dQKc72U9Ba3qchBu05+94euQenKKpgapFGLD3h2o7Ty/flYv6L4\nfnECAwEAAaNGMEQwIwYDVR0RBBwwGoIYaXRzbnQxMDMzLmlvd2EudWlvd2EuZWR1\nMB0GA1UdDgQWBBSsL7pUOuJ857spCY2fwPOcgpmMAjANBgkqhkiG9w0BAQUFAAOC\nAQEAFRz1TQmgffiLe7pCi63G+0w2n8p6DVOzCYs5lSyrOdGg2qBsXQkMe0+f1LSL\nA13H2Z42+x+HrgDtGzv0l7FfrXu4CYEi+js0nWpP9GU5aHUq1Gb9ZJ6ORYNXjDWE\ndkXSWAPyh8HPZRA5r5im6mHK9SFRK4mn1k/w86OZDlrt8H0WCKV4L499uyE2hKrZ\nIz2Crm43ZYkU+L9FfN8xYBPKu76ahAWzU2coNk72SBknFshHcgy0hSxF9dzN6Ry3\nhx9AxQsj/RY9tnycOYCW+w4KhdBi3REHkyRZuTYBKchh9tCWAe2jXlx1RUsptQNn\nrC7o+nh2fcKN5Pnag3Gmffy1Ig==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "State of Iowa Board of Regents government relations application for regents institutions", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Iowa Regents' Government Relations", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "http://northwestern.instructure.com/saml2", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Instructure, Inc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Instructure, Inc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.instructure.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "http://northwestern.instructure.com/saml2", 
      "contact_person": [
        {
          "given_name": {
            "text": "Canvas Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@instructure.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Canvas Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@instructure.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Canvas Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@instructure.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Canvas Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "contact_type": "other", 
          "email_address": [
            {
              "text": "support@instructure.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://northwestern.instructure.com/saml_logout"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://northwestern.instructure.com/saml_consume"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://northwestern.beta.instructure.com/saml_consume"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://northwestern.test.instructure.com/saml_consume"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://www.instructure.com/privacy-policy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.instructure.com/about-us", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Northwestern University Canvas", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE8TCCA9mgAwIBAgIJAITusxON60cKMA0GCSqGSIb3DQEBBQUAMIGrMQswCQYD\nVQQGEwJVUzENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMOU2FsdCBMYWtlIENpdHkx\nGTAXBgNVBAoTEEluc3RydWN0dXJlLCBJbmMxEzARBgNVBAsTCk9wZXJhdGlvbnMx\nIDAeBgNVBAMTF0NhbnZhcyBTQU1MIENlcnRpZmljYXRlMSIwIAYJKoZIhvcNAQkB\nFhNvcHNAaW5zdHJ1Y3R1cmUuY29tMB4XDTEzMDQyMjE3NDQ0M1oXDTE1MDQyMjE3\nNDQ0M1owgasxCzAJBgNVBAYTAlVTMQ0wCwYDVQQIEwRVdGFoMRcwFQYDVQQHEw5T\nYWx0IExha2UgQ2l0eTEZMBcGA1UEChMQSW5zdHJ1Y3R1cmUsIEluYzETMBEGA1UE\nCxMKT3BlcmF0aW9uczEgMB4GA1UEAxMXQ2FudmFzIFNBTUwgQ2VydGlmaWNhdGUx\nIjAgBgkqhkiG9w0BCQEWE29wc0BpbnN0cnVjdHVyZS5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDHRYRp/slsoqD7iPFo+8UFjqd+LgSQ062x09CG\nm5uW9smY/x2ig8hxfd05Dtk42wrA9frRh6QiEhtoy8qL/4g/LOmYq5USDdzLXsPF\n/nqTVPkTOhGcuSpfJbxucRsMfGL6IvrGqLNxpyfroyV1dv9/fim+d6bs7js5k1i5\nEkKksgVlnnpUpOx5pswWVcZICeIJwTMe1C0KHcpUMycZxMHueJ+Y7tWHtWW+R75T\nQWdWjL+TevEL57B3cW19+9Sud2Y63DcwP6V0aDrwArxQwmp73uUb5ol6gSSvD+Ol\nCIsf6S/5gqMdgqxJJsWqzBOTeDsVr8m2Dx3VX7Plho7pk06FAgMBAAGjggEUMIIB\nEDAdBgNVHQ4EFgQUQy1zIfZP/NZKPYLGugNSjjBnTYgwgeAGA1UdIwSB2DCB1YAU\nQy1zIfZP/NZKPYLGugNSjjBnTYihgbGkga4wgasxCzAJBgNVBAYTAlVTMQ0wCwYD\nVQQIEwRVdGFoMRcwFQYDVQQHEw5TYWx0IExha2UgQ2l0eTEZMBcGA1UEChMQSW5z\ndHJ1Y3R1cmUsIEluYzETMBEGA1UECxMKT3BlcmF0aW9uczEgMB4GA1UEAxMXQ2Fu\ndmFzIFNBTUwgQ2VydGlmaWNhdGUxIjAgBgkqhkiG9w0BCQEWE29wc0BpbnN0cnVj\ndHVyZS5jb22CCQCE7rMTjetHCjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUA\nA4IBAQC1dgkv3cT4KRMR42mIKgJRp4Jf7swUrtoAFOdOr1R6fjI/9bFNSVNgauiQ\nflN6q8QA5B2sbDihiSqAylm9F34hpI3C3PvzSWzuIk+Z2FPHcA05CZtwrUWj1M0c\neBXxXragtR7ZYtIbEb0srzBfwoFYvWnLU7tM8t6wM6+1rxvOuQFVCCSXyptsGoBl\nD9qyzAbyYDgJZYpbTjaA9bqhpkn/9CLN3JhNHLyBVr03fp3hQqNwZ2do9bFZBnW0\nc5Dx9pbKTvC3TAUb2cwUD69yTYS1oq7//yIC2ha2ouzkV/VpB1fcF5YEj2pc6uaj\nlOTDX4Eg7OBEkTzU8cX04b15bJfE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Northwestern University Canvas", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:uab.edu", 
    {
      "entity_id": "urn:mace:incommon:uab.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.dpo.uab.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.dpo.uab.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.dpo.uab.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.dpo.uab.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uab.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDNTCCAh2gAwIBAgIJAKhbYAyHDVilMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHNoaWIuZHBvLnVhYi5lZHUwHhcNMTMwNTA3MTczMzQ4WhcNMjMwNTE1MTcz\nMzQ4WjAbMRkwFwYDVQQDExBzaGliLmRwby51YWIuZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAyMC9Q5de3dVyc+TrIsiKuAMo/hB/fOS5ZCBTs/Dg\nKX3bYXa3VBcJCQjZSCAXXcOY+xZjzUr7UZnQh4zsizwahMA2xTCHPV2ioUUvXbBr\nrG/8rTYe130jeP+mcLxfph15JPM2n9zs6/9bn+xjlQM8eKu+Es8JaxjUnG7LzBjb\nZQxbZrBkec5ppFg1a3bhAHkf4XK71GKWffW+Hyw8HzqXNkOUEUO778TLbEIB4Xmd\nPOL88pYgVWp9Li7CAlWN/UsBLwy1y+sCCHfWunbI2Myf+QMLafs4JYFTFeo+00H4\nUy0MRcatmnDSkq0r0L7ZZosnDE0lJwC3fnvECOqKHLZ5XQIDAQABo3wwejAdBgNV\nHQ4EFgQUbkGLbZqs4yNGXzx2btBzJdrpU3MwSwYDVR0jBEQwQoAUbkGLbZqs4yNG\nXzx2btBzJdrpU3OhH6QdMBsxGTAXBgNVBAMTEHNoaWIuZHBvLnVhYi5lZHWCCQCo\nW2AMhw1YpTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAZAZq6u3DL\nAKOr/dzOaynGI4VmEbgjtOM20nkwpeHYNJUO+fd4gZH3QkxPkATqSVQ3UFMEACJw\n7Hz5LgswpiRiaBTD/27jJxqG/ZOzPJfu08L1Ljx0+j3hMuaNA1KDENvkNOBGulCk\nQI8Qdm3Jj2bfGC0qnmiQ9rZ/IMleVXcjVBdEi9WnIS9Lu960FwJTsaYNvpYTJPGZ\nqsnFmVVeDfVtegKUOtE/p/hZZ0rAqilBeCz0jyqEG7cjW4Zwd3ULfb32F1sv00Zp\n+ap/RFh5amo3UF0raAflMUYKy64pgOBlsW4cqYsZ+ou8aqrcJVfPPTlWIQtdPFXS\nFFBTvHwNAQ9P", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.dpo.uab.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.dpo.uab.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category-support"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uab.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDNTCCAh2gAwIBAgIJAKhbYAyHDVilMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHNoaWIuZHBvLnVhYi5lZHUwHhcNMTMwNTA3MTczMzQ4WhcNMjMwNTE1MTcz\nMzQ4WjAbMRkwFwYDVQQDExBzaGliLmRwby51YWIuZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAyMC9Q5de3dVyc+TrIsiKuAMo/hB/fOS5ZCBTs/Dg\nKX3bYXa3VBcJCQjZSCAXXcOY+xZjzUr7UZnQh4zsizwahMA2xTCHPV2ioUUvXbBr\nrG/8rTYe130jeP+mcLxfph15JPM2n9zs6/9bn+xjlQM8eKu+Es8JaxjUnG7LzBjb\nZQxbZrBkec5ppFg1a3bhAHkf4XK71GKWffW+Hyw8HzqXNkOUEUO778TLbEIB4Xmd\nPOL88pYgVWp9Li7CAlWN/UsBLwy1y+sCCHfWunbI2Myf+QMLafs4JYFTFeo+00H4\nUy0MRcatmnDSkq0r0L7ZZosnDE0lJwC3fnvECOqKHLZ5XQIDAQABo3wwejAdBgNV\nHQ4EFgQUbkGLbZqs4yNGXzx2btBzJdrpU3MwSwYDVR0jBEQwQoAUbkGLbZqs4yNG\nXzx2btBzJdrpU3OhH6QdMBsxGTAXBgNVBAMTEHNoaWIuZHBvLnVhYi5lZHWCCQCo\nW2AMhw1YpTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAZAZq6u3DL\nAKOr/dzOaynGI4VmEbgjtOM20nkwpeHYNJUO+fd4gZH3QkxPkATqSVQ3UFMEACJw\n7Hz5LgswpiRiaBTD/27jJxqG/ZOzPJfu08L1Ljx0+j3hMuaNA1KDENvkNOBGulCk\nQI8Qdm3Jj2bfGC0qnmiQ9rZ/IMleVXcjVBdEi9WnIS9Lu960FwJTsaYNvpYTJPGZ\nqsnFmVVeDfVtegKUOtE/p/hZZ0rAqilBeCz0jyqEG7cjW4Zwd3ULfb32F1sv00Zp\n+ap/RFh5amo3UF0raAflMUYKy64pgOBlsW4cqYsZ+ou8aqrcJVfPPTlWIQtdPFXS\nFFBTvHwNAQ9P", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.dpo.uab.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.dpo.uab.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Alabama at Birmingham", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Alabama at Birmingham", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uab.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Landy Manderson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "landy@uab.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "UABIT User Services", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "UserServices@uab.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Robert Cloud", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "recloud@uab.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://shibboleth-wustl-insight.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-wustl-insight.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "WUSTL Insight", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID1DCCArwCCQDF6UH4xx37oDANBgkqhkiG9w0BAQUFADCBqzELMAkGA1UEBhMC\nVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQHEwlBcmxpbmd0b24xHzAdBgNV\nBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xMDAuBgNVBAMTJ3NoaWJib2xldGgt\nd3VzdGwtaW5zaWdodC5zeW1wbGljaXR5LmNvbTEiMCAGCSqGSIb3DQEJARYTc2hp\nYkBzeW1wbGljaXR5LmNvbTAeFw0xMzEwMzAxNTI5MzNaFw0xNjEwMjkxNTI5MzNa\nMIGrMQswCQYDVQQGEwJVUzERMA8GA1UECBMIVmlyZ2luaWExEjAQBgNVBAcTCUFy\nbGluZ3RvbjEfMB0GA1UEChMWU3ltcGxpY2l0eSBDb3Jwb3JhdGlvbjEwMC4GA1UE\nAxMnc2hpYmJvbGV0aC13dXN0bC1pbnNpZ2h0LnN5bXBsaWNpdHkuY29tMSIwIAYJ\nKoZIhvcNAQkBFhNzaGliQHN5bXBsaWNpdHkuY29tMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAujiljPOitSfVYwJDlQ9/4tynlxpLb0Yp93TCVSMDeEvt\nZHpLyw+HQRH7QVc6XoLyDrAdPl8d7SWb4EeR+zZso4Q6bzfiWKq+P5/eL4v5jSmn\nTjYDr7qRSeWV1pa2ol4e+Q9wM6ixuiA50wfN2OrlXZiEOd778weWZLmvGStVzATB\nc/PijXNcBLn/XqzPlBm2EuiH3G5dX4FPAPgsgRk5jqyIxwf/zuC7Ncbb+x8mKkza\n+1g+GlN6UoHrGBF9hOBiur0RZfc+zHo1pjdiFtvZjKjkpiZxOw5anq34j4Bavb+A\nn2W4DDzXmE3l7y2Nzu5lCSTLbBj+NoYdj/Jc430bRQIDAQABMA0GCSqGSIb3DQEB\nBQUAA4IBAQARTDDVYGXWD6I65JoF9yRsLyl0M77eKyJIyygd4zYP61jcpQNeRIQw\n6Vfs0K19UcInPJuC/EKekylX3PCLslIsCPt6CBv/A0emOzLZA+jTYs6KOnmy0szN\n8Z8o0oZvV97VeruYckqN3NFyVtRW7E+mABrQBs3DFsLg3zryiR9gU7fh+ydGfGlS\nSVKhmkmuO7fnEWHcyw309ktxkPoOKWSCyV1TruwFUzGNouir/KQrlovOJbq+2Amr\n6o0inc2b9UzNyBzoS8JY2j2RiGzCTiYiWbuePWaq8ckkBB1pF+6cQYKt4ErjqBeF\nidI0wv4DAGcP1YwXLBNEKq4nuf3mG1wN", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-wustl-insight.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-wustl-insight.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:rutgers.edu", 
    {
      "entity_id": "urn:mace:incommon:rutgers.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.oirt.rutgers.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.oirt.rutgers.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.oirt.rutgers.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.oirt.rutgers.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "rutgers.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAiigAwIBAgIVAOTYftoWG9W/AvT7rTrVdDCpXO4RMA0GCSqGSIb3DQEB\nBQUAMCAxHjAcBgNVBAMTFXNoaWIub2lydC5ydXRnZXJzLmVkdTAeFw0xMzA5MTEy\nMDIwMjRaFw0zMzA5MTEyMDIwMjRaMCAxHjAcBgNVBAMTFXNoaWIub2lydC5ydXRn\nZXJzLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMfg5MXL8GWK\nzQ8e4eSixF5KQRsw+xjrbECuPR0hKXU+gAi9rIBX35VmBHTaTqOU3jWYK7MOJg4C\nCoVQdgB8z0wfFefcuDdeK5IdTPXA0slYZbkjM4Rqa896a0Z4ZDXcsZoH1/tLGcOy\n7WgILHlZaMv2pnYoXn4K/TAGW/dN1AqC027n7iiZAiv9MFU/rkULOKkVEQMdWMgF\n3QpVGGB5FQW7Cul6uhpoChPD1sucdqUYdKPoMtoFRZBGDC4NKDS9jW8RTFJbrqP/\n7KFaYLguSQOINSLITJvFHDWQh+PitHHfMU0S5A1Pe5R4u4oPn/trghch4vlp7r/a\nNpo/0B3Xoy8CAwEAAaNxMG8wTgYDVR0RBEcwRYIVc2hpYi5vaXJ0LnJ1dGdlcnMu\nZWR1hixodHRwczovL3NoaWIub2lydC5ydXRnZXJzLmVkdS9pZHAvc2hpYmJvbGV0\naDAdBgNVHQ4EFgQUFli4zyOx/sujMoYan3mtmvJlrrkwDQYJKoZIhvcNAQEFBQAD\nggEBACEULFPT0JlJyy+70AKed4pbpJI6xpujTqBSqQF0KWaCfzrYHj5o+Jf6O+NH\nzbMcDT52D8wdIYR9tRfim5RHGa9KB6yHGRjYTUUs4pWwg+eTxPjBOKGuNGGDYL8+\nRer4N3tq/406sxErmH3iAa0iJIKD9RHlfdKqpBxsHVgm4tF4tf4nvKJJ0Htr/iG/\nPt4R1i6XhTrkL6noEiUY0wfVtA7JFe+beGB3jgmtAo8tV/uFO703ZHotLq+F2tx9\n79bLcfGy+NHx/95l7BNs6olcWipRkoQaSxmorqt2gShsvP8uNYSWOzgsAwtDU7J0\nhIzMRisvrfUsWonX0n1qZzmLU64=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDRTCCAi2gAwIBAgIJAKL5nzW/yD3hMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXNoaWIub2lydC5ydXRnZXJzLmVkdTAeFw0xMDA5MjcyMTIyNDlaFw0xMzA5\nMjYyMTIyNDlaMCAxHjAcBgNVBAMTFXNoaWIub2lydC5ydXRnZXJzLmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJnjpOLwGkp/fU6u2s1tl7VTlb5W\n4BrslbD+MOAz/04FOVzbMBwHrffMRuVSATeD0285i8hpu2PvRdCyhK0FniAFFnL8\nWQklcOZEbpqMzLYSAUVnEavZU6S2gme5/GGULnFpbVPva0kbHR2MzSWUJVxgfkvS\nNS6mE0YZ9W60bPVLK1lqhILIdmlvZBqsPujuagI7pqzjaHAQZsPclnjS79rQdZMP\nAZxISKB6uAI+S5tsYMfI6l2QVsSiQGCr9Cmr3ParyeVRj3Qnsn79XKkj5Ag5C5f+\nn2PncVjG9FXtqjGZCTmP8MdM9axPtOEapREXmTehS0v5IrXG/WIXNa+96bcCAwEA\nAaOBgTB/MB0GA1UdDgQWBBQntgwltpzp+hsU37PV3OIXFypGpjBQBgNVHSMESTBH\ngBQntgwltpzp+hsU37PV3OIXFypGpqEkpCIwIDEeMBwGA1UEAxMVc2hpYi5vaXJ0\nLnJ1dGdlcnMuZWR1ggkAovmfNb/IPeEwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B\nAQUFAAOCAQEAG2gptNgQMx6l5TvN5iKAXCLqCbFTrhKdelCTC2ir+v6m27jKf05p\n2UaAIHwVUj+mSXjWbjiBrdRAio1OgFa09FPOyesnyAhg6bT83O6rwfZ5Th8V0xJZ\n3ROJlO+65bmw53uSCJ1zWL3Vrcp+ncWz3GT7C72S0PsYrG4EwU7naX6nnUgaHZnL\no0k7iWRN5QzdkASXGDT6/4T4FzWGliv7obqfzG/MLstwFnR7haHgsWVNFX9X761+\n0cyUtC/ut8Rl3SifbyOoM91MVIg6hGOh2I4qcZO2OZWIui+7DXV8Jb88OtKmOxgT\nYnlJ2VP4+HqggzFa+Vth0GCTBBCFs16HRQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.oirt.rutgers.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.oirt.rutgers.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category-support"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "rutgers.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAiigAwIBAgIVAOTYftoWG9W/AvT7rTrVdDCpXO4RMA0GCSqGSIb3DQEB\nBQUAMCAxHjAcBgNVBAMTFXNoaWIub2lydC5ydXRnZXJzLmVkdTAeFw0xMzA5MTEy\nMDIwMjRaFw0zMzA5MTEyMDIwMjRaMCAxHjAcBgNVBAMTFXNoaWIub2lydC5ydXRn\nZXJzLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMfg5MXL8GWK\nzQ8e4eSixF5KQRsw+xjrbECuPR0hKXU+gAi9rIBX35VmBHTaTqOU3jWYK7MOJg4C\nCoVQdgB8z0wfFefcuDdeK5IdTPXA0slYZbkjM4Rqa896a0Z4ZDXcsZoH1/tLGcOy\n7WgILHlZaMv2pnYoXn4K/TAGW/dN1AqC027n7iiZAiv9MFU/rkULOKkVEQMdWMgF\n3QpVGGB5FQW7Cul6uhpoChPD1sucdqUYdKPoMtoFRZBGDC4NKDS9jW8RTFJbrqP/\n7KFaYLguSQOINSLITJvFHDWQh+PitHHfMU0S5A1Pe5R4u4oPn/trghch4vlp7r/a\nNpo/0B3Xoy8CAwEAAaNxMG8wTgYDVR0RBEcwRYIVc2hpYi5vaXJ0LnJ1dGdlcnMu\nZWR1hixodHRwczovL3NoaWIub2lydC5ydXRnZXJzLmVkdS9pZHAvc2hpYmJvbGV0\naDAdBgNVHQ4EFgQUFli4zyOx/sujMoYan3mtmvJlrrkwDQYJKoZIhvcNAQEFBQAD\nggEBACEULFPT0JlJyy+70AKed4pbpJI6xpujTqBSqQF0KWaCfzrYHj5o+Jf6O+NH\nzbMcDT52D8wdIYR9tRfim5RHGa9KB6yHGRjYTUUs4pWwg+eTxPjBOKGuNGGDYL8+\nRer4N3tq/406sxErmH3iAa0iJIKD9RHlfdKqpBxsHVgm4tF4tf4nvKJJ0Htr/iG/\nPt4R1i6XhTrkL6noEiUY0wfVtA7JFe+beGB3jgmtAo8tV/uFO703ZHotLq+F2tx9\n79bLcfGy+NHx/95l7BNs6olcWipRkoQaSxmorqt2gShsvP8uNYSWOzgsAwtDU7J0\nhIzMRisvrfUsWonX0n1qZzmLU64=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDRTCCAi2gAwIBAgIJAKL5nzW/yD3hMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXNoaWIub2lydC5ydXRnZXJzLmVkdTAeFw0xMDA5MjcyMTIyNDlaFw0xMzA5\nMjYyMTIyNDlaMCAxHjAcBgNVBAMTFXNoaWIub2lydC5ydXRnZXJzLmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJnjpOLwGkp/fU6u2s1tl7VTlb5W\n4BrslbD+MOAz/04FOVzbMBwHrffMRuVSATeD0285i8hpu2PvRdCyhK0FniAFFnL8\nWQklcOZEbpqMzLYSAUVnEavZU6S2gme5/GGULnFpbVPva0kbHR2MzSWUJVxgfkvS\nNS6mE0YZ9W60bPVLK1lqhILIdmlvZBqsPujuagI7pqzjaHAQZsPclnjS79rQdZMP\nAZxISKB6uAI+S5tsYMfI6l2QVsSiQGCr9Cmr3ParyeVRj3Qnsn79XKkj5Ag5C5f+\nn2PncVjG9FXtqjGZCTmP8MdM9axPtOEapREXmTehS0v5IrXG/WIXNa+96bcCAwEA\nAaOBgTB/MB0GA1UdDgQWBBQntgwltpzp+hsU37PV3OIXFypGpjBQBgNVHSMESTBH\ngBQntgwltpzp+hsU37PV3OIXFypGpqEkpCIwIDEeMBwGA1UEAxMVc2hpYi5vaXJ0\nLnJ1dGdlcnMuZWR1ggkAovmfNb/IPeEwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B\nAQUFAAOCAQEAG2gptNgQMx6l5TvN5iKAXCLqCbFTrhKdelCTC2ir+v6m27jKf05p\n2UaAIHwVUj+mSXjWbjiBrdRAio1OgFa09FPOyesnyAhg6bT83O6rwfZ5Th8V0xJZ\n3ROJlO+65bmw53uSCJ1zWL3Vrcp+ncWz3GT7C72S0PsYrG4EwU7naX6nnUgaHZnL\no0k7iWRN5QzdkASXGDT6/4T4FzWGliv7obqfzG/MLstwFnR7haHgsWVNFX9X761+\n0cyUtC/ut8Rl3SifbyOoM91MVIg6hGOh2I4qcZO2OZWIui+7DXV8Jb88OtKmOxgT\nYnlJ2VP4+HqggzFa+Vth0GCTBBCFs16HRQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.oirt.rutgers.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.oirt.rutgers.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Rutgers, The State University of New Jersey", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Rutgers, The State University of New Jersey", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.rutgers.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Charles Hedrick", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hedrick@rutgers.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://usertest.sciquest.com", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "SciQuest, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "SciQuest, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://sciquest.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://usertest.sciquest.com", 
      "contact_person": [
        {
          "given_name": {
            "text": "Dana Tiller", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dtiller@sciquest.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/MiamiOhio"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/SUNYStonyBrook"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/USU"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/UCSF"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/USC"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/OSU"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/UMinn"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://usertest.sciquest.com/apps/Router/ExternalAuth/SAML/Login/MUSC"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "SciQuest Test Environment", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC9DCCAl2gAwIBAgIITH47WRLwirIwDQYJKoZIhvcNAQEEBQAwXzELMAkGA1UEBhMCVVMxETAP\nBgNVBAoTCFNjaVF1ZXN0MRQwEgYDVQQLEwtEZXZlbG9wbWVudDEnMCUGA1UEAxMeU2NpUXVlc3Qg\nQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEzMDkwOTIwMjkzMVoXDTMzMDMzMTIwMjkzMVowYDEV\nMBMGA1UEAxMMc2NpcXVlc3QuY29tMRQwEgYDVQQLEwtEZXZlbG9wbWVudDEXMBUGA1UEChMOU2Np\nUXVlc3QsIEluYy4xCzAJBgNVBAgTAk5DMQswCQYDVQQGEwJVUzCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBAJAwZSK6e1O56akTZTxBKIuDkuUZDyJzSl4xaqPa8C6XWP7I+G6sFUbtHb3I\nfY7FVmYkeS7Rx2hZA+AbNMGA3JdectjGfJoc2DYZ5ZW/Pk/hslSWJ/PGnJmJDomM90NNRYa0NPSK\nXSl9KLEsBj+S5YGrC7NZR6L0NCrLiqRGXCwdqMSl2TORG3DjdVFnyp933vxjhnaJW7ihpIc4Ga0H\nORjj6zk2npzGhq71qmRwfxHFsRivFR1CBH3EVsqLCm3AXhVmqCuwJYmXjo26aZYOV61gvMht0oWq\nhPI3LQXZ6nWwpPOCiyMBJAuhckZQQu0n81tJyII0J+fXJXzObJ9OJxUCAwEAAaM0MDIwDgYDVR0P\nAQH/BAQDAgWgMCAGA1UdJQEB/wQWMBQGCCsGAQUFBwMEBggrBgEFBQcDAjANBgkqhkiG9w0BAQQF\nAAOBgQAj3d6pxxPMxzet05eEemxV0wgP9L0F27/sTPsGioynIclNxKoAC5hoeiHAOVKw+8RTL3D/\nUJxYoO9+3wRbtkiHnfP2W8SP7GoxvZhaJyblGX5PS+xLtCBhwfVbUQC9dNGy/yTOggYvF6oQIXn2\nU7mXMJZfSVNp1vexAK1dV+TJVQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:sn"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "SciQuest Test Environment", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://adeasso-tst.northwestern.edu/simplesaml/module.php/saml/sp/metadata.php/nu_passport", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Northwestern University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Northwestern University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.northwestern.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://adeasso-tst.northwestern.edu/simplesaml/module.php/saml/sp/metadata.php/nu_passport", 
      "contact_person": [
        {
          "given_name": {
            "text": "Phil Tracy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ptracy@northwestern.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Xiaoxia Dong", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "x-dong@northwestern.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "EngageNU Identity Provider", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID+zCCAuOgAwIBAgIJALbxobc/ikiNMA0GCSqGSIb3DQEBBQUAMIGTMQswCQYD\nVQQGEwJVUzERMA8GA1UECAwISWxsaW5vaXMxETAPBgNVBAcMCEV2YW5zdG9uMSAw\nHgYDVQQKDBdOb3J0aHdlc3Rlcm4gVW5pdmVyc2l0eTEVMBMGA1UECwwMUHJvamVj\ndCBDYWZlMSUwIwYDVQQDDBxhZGVhc3NvLWRldi5ub3J0aHdlc3Rlcm4uZWR1MB4X\nDTEzMDEwODIxNTQwN1oXDTIzMDEwODIxNTQwN1owgZMxCzAJBgNVBAYTAlVTMREw\nDwYDVQQIDAhJbGxpbm9pczERMA8GA1UEBwwIRXZhbnN0b24xIDAeBgNVBAoMF05v\ncnRod2VzdGVybiBVbml2ZXJzaXR5MRUwEwYDVQQLDAxQcm9qZWN0IENhZmUxJTAj\nBgNVBAMMHGFkZWFzc28tZGV2Lm5vcnRod2VzdGVybi5lZHUwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQCzg/gDFu8tuaE7E8CFoqdQ3lDGuDBkIsNe4OAJ\nDoelRl6fzGxokxCCyrYoPbT40WOntf12U3tcNaFxnsPEdaGFQiwi3DK3oK6WhvsH\nSXN7sJ19WAFMQB/ydjaQj5KX8pmnJvIhfL8nEWrqVEgq1IsLe/sdevZrghjt9LiY\nXePEIsULOLBgbJwNr+fDlyozIMKZETpOOze5F8+YzV2dYWSTBWk+c9ZjDoqivlXj\nMtJbdexDb3eI5bd2usFEMGtOmBiog209DemIa12+Cvp0XfZ3jBFiyL6AZo47O6me\nu9GsZNSUGuU4iN540JqPMjj1VR/h/f5TNOfbC1aSiduAp4dZAgMBAAGjUDBOMB0G\nA1UdDgQWBBSJBndJ07YFMXQu2mky7c90uB98wTAfBgNVHSMEGDAWgBSJBndJ07YF\nMXQu2mky7c90uB98wTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQB/\nFgjNMYXfPaRS6Pu9y7Q2DU2H3TdcM2ZILZSfpjQlCZlcPtJwmkg/OlYcQyTB/TXz\nycAlm6leAl/jA4ULuUFpMWfQvYhcDLKm9yHKEUpuYw7wxBrNuqFQmov+s0hqUmqD\nm5OPvaYu/UgdUsobBP5Z6qfxFckZoITGjk3wXdIXHHFecvp/OLVIewcXt59pjf7J\n/xKEayTPvMgjUr5tgT2sgdyH1/p2+G4tt7h9pExpCWdtFWZznpBwVwpz768CPAkg\nru1viFIeHgX5tYtl7CWD64U9t5YtaKPnNPjWd3p9W+4ZoW4QbQRDcsXWCqRimvN3\ngh7M/o02M4cL9PuE4xEd", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://adeasso-tst.northwestern.edu/simplesaml/module.php/saml/sp/saml2-acs.php/nu_passport"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://adeasso-tst.northwestern.edu/simplesaml/module.php/saml/sp/saml1-acs.php/nu_passport"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://catalog.lib.uchicago.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Chicago", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Chicago", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uchicago.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://catalog.lib.uchicago.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "UNIX Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "unix-team@lists.uchicago.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Tod Olson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tod@uchicago.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/Login"
              }, 
              {
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.lib.uchicago.edu/e/images/logo_small.png", 
                    "width": "176", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "64"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Library Catalog", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIICyzCCAbOgAwIBAgIBADANBgkqhkiG9w0BAQUFADAPMQ0wCwYDVQQDEwRnb2F0\nMB4XDTA5MDcwNjE1MzUwOFoXDTE5MDcwNDE1MzUwOFowDzENMAsGA1UEAxMEZ29h\ndDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANQ3+D5cO+cw7yNlh5cV\nAmaBZb67X7AZqdA16LQp/4x9Kz+/O98OLPmGM2fHMRr5hrummdlF8bJo0fP/ivNv\nKCvLoPWyYw1a5v6AMAybd73OBHfn774zsEPhjADpNHSxR/ts7i5mhicPnEr0AWan\nVXUdNWmSnnNtJc1/rWvhxTlFk6XPxWCPZcrMniCL8TSQgV/xFeZKnDLozvhGBNpa\nvxR9p4SDMkBSX58jMRNYGglPKHAalhlC3c5SpMQHZjMWo6M4ADT+ElUPL6JbHcKH\nStAeo5SbT4D1f2Xw3tO+Ad+WtVnQxOzgDoPcSRkkpdnBei/lLQ+bRotoxhcHnPeN\nmKkCAwEAAaMyMDAwDwYDVR0RBAgwBoIEZ29hdDAdBgNVHQ4EFgQU1Rkki39jPqoC\na2L9gz+q67DZ74kwDQYJKoZIhvcNAQEFBQADggEBACMRpWfIIxJoj9YPo6t1D9B8\nvDFgqEfBv0KYO2za1R6Tdm7kq79EA5iQmUkjyKtyt7zOds+QWXz6c6+Sp/h2ZMr0\n0ySmllX/KeNASVl+LOJKnSLacwX/NYM4ukmqztUQCKCsykp0x7uHp7PwvniG0sNa\nTw1qqeN7RixXD+2F6WWDPdqeuya3ydH1bJJIMla/VxBgEb75KGM3yZ/Fe2gxidD8\n7/UfN3oq0cxNwQID0r0Pcmn+Oy3RMttKndgdgdWEZp1t/G6VvPQzHqUxzacQOco6\nyoqxNLl26eihzgZrQcCrp5oY0/LMtosX9LGypBWNTAeVcuttN+smcqpuaWuu65A=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://catalog.lib.uchicago.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://odu.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.qualtrics.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://odu.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Michael Page", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@qualtrics.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Qualtrics Labs, Inc.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFbDCCA1QCCQC8OqKPlGUkRDANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJV\nUzENMAsGA1UECBMEVXRhaDEOMAwGA1UEBxMFUHJvdm8xGDAWBgNVBAoTD1F1YWx0\ncmljcywgSW5jLjEgMB4GCSqGSIb3DQEJARYRZGJhQHF1YWx0cmljcy5jb20wHhcN\nMTAwNDA3MTkzMzA0WhcNMjAwNDA3MTkzMzA0WjCBhzELMAkGA1UEBhMCVVMxDTAL\nBgNVBAgTBFV0YWgxDjAMBgNVBAcTBVByb3ZvMRgwFgYDVQQKEw9RdWFsdHJpY3Ms\nIEluYy4xGDAWBgNVBAMMDyoucXVhbHRyaWNzLmNvbTElMCMGCSqGSIb3DQEJARYW\nc3NvYWRtaW5AcXVhbHRyaWNzLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC\nAgoCggIBAM7T6YYEDd91lehKK/51V3Li6zk/wqHZ1OZ4rHw22AtTasl0qrEwdXbL\nsCUmO4rEXhAnjgpIZPFHs+1sFpSCalerYa+ROJX5B5N9MnENYr6E8KHa8spbVBEl\n2/ZE6RlPdHBs+iCDuoTTqOa2sZ8vqTpTF3grVdgeW3KfBOO9yENa04lA6xhPAQs3\nkihDQvPoWnlXtQA3gmtb+sGZmKYXonBVwIDsrDbhpoFcHJJRrFEEawSHOI3IeHBo\nhR1jhfb95E3cQ0s7gQ+FbR+lkzwb3i3WrCkZr3w2KpudJEzy/kT7JBLvfELW8eR4\nj2XRKyRhxNHOKc/AC8fNIrGam0CAqK9elpJnB6zmALQUYXVGddv3sd9ITIfZQ9Ox\ng9ChVqsNAY6VIlg5+/Q3Ega+BR/P/OpMnG9xW+cyLslzjiUf4c0K6I2pObcJkJMw\nqGHOSbD9lGa/WxaEAFC1+6oDNRbC3S2mbo4gW6LPVbtCxC0IMxOyaOKBwe3sW9v+\nrumd02ZuJRtbTbarde7N6aUmm2hXfDQntCIXWUJ+9b+YvjcWUlUN0KvVq8jFn1Z7\nkD1po2eY+lc9VHYoh1jdP08G9H8CZdJTDwR4KDPG0U2rD+xXmxO+9CEeQev1d/Iu\nqcadQxRka7hbhIijtVJgjO3jP6AwiHXFGpBvApyIuuXJU8CyKSsXAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggIBAAcXtiFXJ5Vm0mwhiDRoTGwIGz+Ryg13X6X9w6GfVENt\nNexDExwzPgxnW1gG7u9FUx2tl2geZ8BJOqk3pGnLSZI4QF/nVnB+hTPMLOwXjtMk\nMF5FXlM7QvOKOTzzK7+2wug2ssZi5ZpQVGODhPsytu+GjMJwydLj6RRAnJV/9wmu\nivZhIbQyrOs0XBxuYO0n9OzlOa9JVFtUxnckT93UYIjcCVEu2r+m20Zm8BEofKTr\nTz3vodizFV5uHbmQ19iLxDrZsu9rbpEHojWMgnKnq1XoC7TmlxB1/OQctUnjpRPT\nWySZkTdWX4cKBjQHzCHJyl0Z4hAP4m3fWFLXVK3w8U1e+Mbfm0jUT9+amUfdzL+8\n9ZjwnFvpuFNWsS33yYWp51+rVdtU0jYII1f8XWNRn4EV54MwoOWrEXKDZ0qmbxi5\nnVR/F5QofEGv/ZYMgcFaX5OMP5lRE8IjQu9Eq26zZA6YuR5fZfiTHZppwc6Ey9Zc\nGpRsLwFSwma0/Vtlfxr/KtaKsk2zlOOJ6RF33MUyZvw8N+tybY0yHJ40aBZKFr9r\nr3j//DUU8zi4qvNP5z19kS08sZ7mtNK2sKBPWVSYB2HDtyrBSRupHBYeIxlfGKd6\nuVUusHTyyVjDKbuMHCw+DEp0VXmCIAv5Jf+SKZ7DOkw8cxcdL67gEc9NjAmsfmKy", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://odu.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://odu.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml1-acs.php/default-sp"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth-uncch-csm.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-uncch-csm.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Noc", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDzDCCArQCCQCL84R77qCJNjANBgkqhkiG9w0BAQUFADCBpzELMAkGA1UEBhMC\nVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQHEwlBcmxpbmd0b24xHzAdBgNV\nBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xLDAqBgNVBAMTI3NoaWJib2xldGgt\ndW5jY2gtY3NtLnN5bXBsaWNpdHkuY29tMSIwIAYJKoZIhvcNAQkBFhNzaGliQHN5\nbXBsaWNpdHkuY29tMB4XDTEwMDcyMDE4MzQwMFoXDTEzMDcxOTE4MzQwMFowgacx\nCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhWaXJnaW5pYTESMBAGA1UEBxMJQXJsaW5n\ndG9uMR8wHQYDVQQKExZTeW1wbGljaXR5IENvcnBvcmF0aW9uMSwwKgYDVQQDEyNz\naGliYm9sZXRoLXVuY2NoLWNzbS5zeW1wbGljaXR5LmNvbTEiMCAGCSqGSIb3DQEJ\nARYTc2hpYkBzeW1wbGljaXR5LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC\nAQoCggEBAKqg+CiZhHIqA9Oog67kmIXQXBMsdLc2qO7SJnA4yS13lyrXI6G10n5X\nPIjatYfwDfXpx/OyCPEtsfbPxeYamRR0CKZN4Wtl14EdJ+iKHmJABgA/Oa90jn2n\nDLHjPJ8H53nAuCCMEV7vm7NeiJc7zqEOJDDmzHjpuxoHEDZGFew8wVT6OzzFpWiq\n3f6K8vcEIkyIFMwjt9433XoUZ6PGGnIfG0vXmB55pl4D+3NdrJb+zNGfjrm2lCWr\nOvUIWA4uIxlXpxjo5qsaJaR0AsyT6QN54F9kfgW3uOSsYX9cN3C7u5xUFBvZLTSa\n63PBNn6lGXi5jJ+YX5uaQ95An+vgkoUCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEA\nErZyB5eSQ/RwuykqJhcL8xwJiJ6l9YSfHyaN0ups2I+LclV56VZoLt6WybWMftu4\njBuJ5kBH1p9Uo6d6VZKoynnWhNCaG35xziCFr/YFeUhNANtxwo+D3MjMAttOhRh4\notsCainyhEEWiRpWlYHBTw2OEet02nTPzLZ6xX5A+wGjn3h/6DrN5j+Urvq+Iv3n\n31yoQzyn3dkeNxlz1kkzV6WvCN2ZbbrYAfL5a8EBZXvSpujTdjcRHIZtUVGt6MyW\njzn8tiu2ZZmDxKfprvDPiItV/deJMvwiruqmtl8ku9tOI4rcywTLR4Ws6n51hBET\nr/fRAwOW2xSHNnhR1agjww==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-uncch-csm.symplicity.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-uncch-csm.symplicity.com/Shibboleth.sso/SAML/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://libraries.umd.edu/proxy-fs/sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Maryland College Park", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Maryland College Park", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.umd.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://libraries.umd.edu/proxy-fs/sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "David Barks", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dbarks@umd.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Ben Wallberg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lib-shibboleth@umd.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "John Pfeifer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@umd.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "OCLC EZProxy for Frostburg State University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFIzCCBAugAwIBAgIBCDANBgkqhkiG9w0BAQUFADCBwTEsMCoGA1UEAxMjbG9n\naW4ucHJveHktZnMucmVzZWFyY2hwb3J0LnVtZC5lZHUxCzAJBgNVBAYTAlVTMREw\nDwYDVQQIEwhNYXJ5bGFuZDEVMBMGA1UEBxMMQ29sbGVnZSBQYXJrMR8wHQYDVQQK\nExZVbml2ZXJzaXR5IG9mIE1hcnlsYW5kMRIwEAYDVQQLEwlMaWJyYXJpZXMxJTAj\nBgkqhkiG9w0BCQEWFmxpYi1zaGliYm9sZXRoQHVtZC5lZHUwHhcNMTMwMjIyMTky\nNDU4WhcNMjMwMjIyMTkyNDU4WjCBwTEsMCoGA1UEAxMjbG9naW4ucHJveHktZnMu\ncmVzZWFyY2hwb3J0LnVtZC5lZHUxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhNYXJ5\nbGFuZDEVMBMGA1UEBxMMQ29sbGVnZSBQYXJrMR8wHQYDVQQKExZVbml2ZXJzaXR5\nIG9mIE1hcnlsYW5kMRIwEAYDVQQLEwlMaWJyYXJpZXMxJTAjBgkqhkiG9w0BCQEW\nFmxpYi1zaGliYm9sZXRoQHVtZC5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQDAaSvIUerLkhy4wjos90tb/V7/m9fHycPfIP393aD9PH2a6WeKNbnv\nZqnV2mkY5m9QMIzHl61L/P9R+Bj1uxyPkiknQrU9Zh9PB1d9cU5//+DIDA1q3RS4\nR2m30SdZke5XzT2IJFezBgLuTH87OA4Blr19fjcR54CGDykLLRmYaOnlV1wGsfQJ\ntZAPqUpp0u6vTIM8sRRds8ipIdekRemqwHH308N4shNH7+Svau8rjYQqia6JTQeQ\nkCJEJp2yv36U5FxOgxVPwp0Bd/SfHe4OT/Wsy0UEFA/N+U0dSZ5O30F5nuYtMLkY\nxt2V4T1ZKLXloLKR8qGinL20VY77ZzsvAgMBAAGjggEiMIIBHjAdBgNVHQ4EFgQU\nUcu4S84j8KxpfU24KmJsvpJDUKIwge4GA1UdIwSB5jCB44AUUcu4S84j8KxpfU24\nKmJsvpJDUKKhgcekgcQwgcExLDAqBgNVBAMTI2xvZ2luLnByb3h5LWZzLnJlc2Vh\ncmNocG9ydC51bWQuZWR1MQswCQYDVQQGEwJVUzERMA8GA1UECBMITWFyeWxhbmQx\nFTATBgNVBAcTDENvbGxlZ2UgUGFyazEfMB0GA1UEChMWVW5pdmVyc2l0eSBvZiBN\nYXJ5bGFuZDESMBAGA1UECxMJTGlicmFyaWVzMSUwIwYJKoZIhvcNAQkBFhZsaWIt\nc2hpYmJvbGV0aEB1bWQuZWR1ggEIMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\nBQADggEBAGZtRkK/+ki6XAMZjLC6D2NQzHjdjSAZzIUNgd1kPVXcfFhp2LtcgcXh\nWWCepAaeotY5FFUm9XaFgf6HDxTrT4eHMn3TX6mt1mup6ia5A1rnnJ+o6DInaWB9\ntmKOskJBWekyYyM/yYpVXpzUF8QrHmP1VXkQyhL79zZhgNVmt2Q1LFwNSdd89X09\nvsRWiT7Fm/oL5Y/sU9kG0CQEnJS6QHK8ao7FFG2uIHzw/j+AQCWNooNkc91TlL8u\npBCbvTCZ1Chw/4kg9DkOHjz592E6Pin+7e3uaZxPmh9fQDZi/d/6oDfZyB8TGB8/\nBrvWplcRd+RuCvXa7xno9GvsxhzqtHo=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.proxy-fs.researchport.umd.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.proxy-fs.researchport.umd.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.proxy-fs.researchport.umd.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.proxy-fs.researchport.umd.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://logintest.wustl.edu/idp/shibboleth", 
    {
      "entity_id": "https://logintest.wustl.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://logintest.wustl.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://logintest.wustl.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://logintest.wustl.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://logintest.wustl.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "wustl.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "zTest_Washington University in St. Louis", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Test environment IDP for Washington University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE6DCCA9CgAwIBAgIJANEio5/rU1dtMA0GCSqGSIb3DQEBBAUAMIGoMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMITWlzc291cmkxEjAQBgNVBAcTCVN0LiBMb3VpczEe\nMBwGA1UEChMVV2FzaGluZ3RvbiBVbml2ZXJzaXR5MQwwCgYDVQQLEwNJU1QxJjAk\nBgNVBAMTHWxvZ2ludGVzdC53dXN0bC5lZHUud3VzdGwuZWR1MRwwGgYJKoZIhvcN\nAQkBFg1ub2NAd3VzdGwuZWR1MB4XDTExMDcwNTE1MzM0OVoXDTE3MDcwMzE1MzM0\nOVowgagxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhNaXNzb3VyaTESMBAGA1UEBxMJ\nU3QuIExvdWlzMR4wHAYDVQQKExVXYXNoaW5ndG9uIFVuaXZlcnNpdHkxDDAKBgNV\nBAsTA0lTVDEmMCQGA1UEAxMdbG9naW50ZXN0Lnd1c3RsLmVkdS53dXN0bC5lZHUx\nHDAaBgkqhkiG9w0BCQEWDW5vY0B3dXN0bC5lZHUwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQCtXdvGETGMhnzQp/H5tQfVPhGvhIKyhKVWpOJV/N8zB+Ai\ncdm9Lrlc40ltXywQmfbxZWUE2GQxhzrLn1m00EIqCf7FFZBAsfx6DnL5onhdTBjz\nETD04MleY/fuet7DL5Pi1pldsS2pLjX4Di19vnsawgroxOs5yOlwkTaM4LIP5B7W\nkqm/mmpeNYKwaLC+a9sp2xjotWyLf4SByzHOeoUWKyyLcOcGgsKUddL76OajUer9\nR+G4/1QNJ7MBwSr1DEhZpl1FJHwgD6aDFpfwzAhlv3wFe1lhJt8GeOGxsfZOva2H\ndrHGsMytW1U0IxpR0k2XRsLMjBuyBVmscEv8M7MnAgMBAAGjggERMIIBDTAdBgNV\nHQ4EFgQUAIppxikUt+GX9fgxi4IFmWe4eXowgd0GA1UdIwSB1TCB0oAUAIppxikU\nt+GX9fgxi4IFmWe4eXqhga6kgaswgagxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhN\naXNzb3VyaTESMBAGA1UEBxMJU3QuIExvdWlzMR4wHAYDVQQKExVXYXNoaW5ndG9u\nIFVuaXZlcnNpdHkxDDAKBgNVBAsTA0lTVDEmMCQGA1UEAxMdbG9naW50ZXN0Lnd1\nc3RsLmVkdS53dXN0bC5lZHUxHDAaBgkqhkiG9w0BCQEWDW5vY0B3dXN0bC5lZHWC\nCQDRIqOf61NXbTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQBVeZM9\n8Xi/yA7I7Sa1qku1kL4GtdpKW1x8OCaXK81K1HghF80jjp2QphoaqQJ9mRhJvAlp\nfwFvz2BICFpGlV/sWkYk22ziToqMnqdjoYw9ndvLXTEuxyidDtdk0vz/yu9dqm/p\nzN7xvpfDfN9So1nt/n2WOCFJTI2dpJ3aCLf93y8VA0+WNgVcndhyk68iEiic5gEu\nMpS8JkB0Ya1fK+alfHdLIBVEYo4WrEJ5vEpdUwjS0WPTX6GlvFWGmjUh0eIEvik6\nS6hoVdGAhggRbs+PbFPZGqD9AtjzDruexxC1e1xFomynQrdZ+c1JnEwEk1x/sVhz\ngiNZUjdTENUIEg/R", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://logintest.wustl.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://logintest.wustl.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "wustl.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE6DCCA9CgAwIBAgIJANEio5/rU1dtMA0GCSqGSIb3DQEBBAUAMIGoMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMITWlzc291cmkxEjAQBgNVBAcTCVN0LiBMb3VpczEe\nMBwGA1UEChMVV2FzaGluZ3RvbiBVbml2ZXJzaXR5MQwwCgYDVQQLEwNJU1QxJjAk\nBgNVBAMTHWxvZ2ludGVzdC53dXN0bC5lZHUud3VzdGwuZWR1MRwwGgYJKoZIhvcN\nAQkBFg1ub2NAd3VzdGwuZWR1MB4XDTExMDcwNTE1MzM0OVoXDTE3MDcwMzE1MzM0\nOVowgagxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhNaXNzb3VyaTESMBAGA1UEBxMJ\nU3QuIExvdWlzMR4wHAYDVQQKExVXYXNoaW5ndG9uIFVuaXZlcnNpdHkxDDAKBgNV\nBAsTA0lTVDEmMCQGA1UEAxMdbG9naW50ZXN0Lnd1c3RsLmVkdS53dXN0bC5lZHUx\nHDAaBgkqhkiG9w0BCQEWDW5vY0B3dXN0bC5lZHUwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQCtXdvGETGMhnzQp/H5tQfVPhGvhIKyhKVWpOJV/N8zB+Ai\ncdm9Lrlc40ltXywQmfbxZWUE2GQxhzrLn1m00EIqCf7FFZBAsfx6DnL5onhdTBjz\nETD04MleY/fuet7DL5Pi1pldsS2pLjX4Di19vnsawgroxOs5yOlwkTaM4LIP5B7W\nkqm/mmpeNYKwaLC+a9sp2xjotWyLf4SByzHOeoUWKyyLcOcGgsKUddL76OajUer9\nR+G4/1QNJ7MBwSr1DEhZpl1FJHwgD6aDFpfwzAhlv3wFe1lhJt8GeOGxsfZOva2H\ndrHGsMytW1U0IxpR0k2XRsLMjBuyBVmscEv8M7MnAgMBAAGjggERMIIBDTAdBgNV\nHQ4EFgQUAIppxikUt+GX9fgxi4IFmWe4eXowgd0GA1UdIwSB1TCB0oAUAIppxikU\nt+GX9fgxi4IFmWe4eXqhga6kgaswgagxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhN\naXNzb3VyaTESMBAGA1UEBxMJU3QuIExvdWlzMR4wHAYDVQQKExVXYXNoaW5ndG9u\nIFVuaXZlcnNpdHkxDDAKBgNVBAsTA0lTVDEmMCQGA1UEAxMdbG9naW50ZXN0Lnd1\nc3RsLmVkdS53dXN0bC5lZHUxHDAaBgkqhkiG9w0BCQEWDW5vY0B3dXN0bC5lZHWC\nCQDRIqOf61NXbTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQBVeZM9\n8Xi/yA7I7Sa1qku1kL4GtdpKW1x8OCaXK81K1HghF80jjp2QphoaqQJ9mRhJvAlp\nfwFvz2BICFpGlV/sWkYk22ziToqMnqdjoYw9ndvLXTEuxyidDtdk0vz/yu9dqm/p\nzN7xvpfDfN9So1nt/n2WOCFJTI2dpJ3aCLf93y8VA0+WNgVcndhyk68iEiic5gEu\nMpS8JkB0Ya1fK+alfHdLIBVEYo4WrEJ5vEpdUwjS0WPTX6GlvFWGmjUh0eIEvik6\nS6hoVdGAhggRbs+PbFPZGqD9AtjzDruexxC1e1xFomynQrdZ+c1JnEwEk1x/sVhz\ngiNZUjdTENUIEg/R", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://logintest.wustl.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://logintest.wustl.edu/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Washington University in St. Louis", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "zTest_Washington University in St. Louis", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.wustl.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ken Koch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ken.koch@wustl.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Daniel Zweifel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "DanZ@wustl.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://www.marinegenomics.org/sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://www.marinegenomics.org/sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jill Gemmill", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gemmill@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Barry Johnson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cyclist@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Kathy Wright", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kewrig@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLDCCAhSgAwIBAgIJAMSOgmS8T7AAMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFnd3dy5tYXJpbmVnZW5vbWljcy5vcmcwHhcNMTAwNjAxMTg0OTE1WhcNMjAw\nNTI5MTg0OTE1WjAhMR8wHQYDVQQDExZ3d3cubWFyaW5lZ2Vub21pY3Mub3JnMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvVIkIWidDdH8NuA84bIkvnvk\nhEW+d1oKQbhakB2EUrv+FElBbqG3HhiGVKvoSBqn3dcNMWc5dtIuW7F6ZLSffiSx\nTUBFaj+YsIwoc/2aF2CuoC3o2iH9K+pGmz3oluIDgiIEqsOEj2nlLo2PFpw/Ed6m\n3sDyx0bfFe7eW3nGnH9XKQ6j2k7wtT7T1Is9jfNsXQT01i5NWSQhsVcj1Y5K0QH1\n8NnWWqGsPzmYEQ0Php1OifJPubYNRa3KNTEiV9fPxLqWDhoBiNAJSE7rbBVNXcat\nOAc8bwvl3ojLaHLTUoQrGupKE8PVZ+As9SNlm9Xg7l8sxXncH9V+FFr3SYFWTQID\nAQABo2cwZTBEBgNVHREEPTA7ghZ3d3cubWFyaW5lZ2Vub21pY3Mub3JnhiFodHRw\nczovL3d3dy5tYXJpbmVnZW5vbWljcy5vcmcvc3AwHQYDVR0OBBYEFBnaghHG1Z0J\nOi2WSi1CTygdivq6MA0GCSqGSIb3DQEBBQUAA4IBAQB5AS0OWUepWg11vbqjsbyp\nN8Z+VzCavdV5BVMi0zC0HHuWFYV04+clfOPJq4drEO+12sMrUkJcGfAqdgqGeGT3\nxn88RZtO1Kw7blzVA5XK21axQyzviq9x1zfw72GL+SmAwLmdsUuzAsy2X58VRLQV\n95uLtqT8l6AG681A0yfs+jZ0hconzrO2/w53T38APzkKH+JevS+uU5kexe3L/qv0\n5P2Ys7F7ggfY5v+OtveUstwSRNn0D6WooVpQ3Es0T4L3zUfJNwHQyPaXgAEmtPd3\nknWnw56uGsf56Qbvx4QbDRRbX40FkVBRGSGhjKC+hHLM/gkuxeJRWSQDqllXkttw", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.marinegenomics.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.marinegenomics.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.marinegenomics.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.marinegenomics.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.marinegenomics.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.marinegenomics.org/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.myinterfase.com/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "CSO Research, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "CSO Research, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.csoresearch.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://www.myinterfase.com/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jason Lanham", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jason@csoresearch.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.myinterfase.com/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "CSO", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEqjCCA5KgAwIBAgIJALAy5mejW0XwMA0GCSqGSIb3DQEBBAUAMIGUMQswCQYD\nVQQGEwJVUzEOMAwGA1UECBMFVGV4YXMxDzANBgNVBAcTBkF1c3RpbjEZMBcGA1UE\nChMQQ1NPIFJlc2VhcmNoIEluYzETMBEGA1UECxMKcHJvZHVjdGlvbjEMMAoGA1UE\nAxMDY3NvMSYwJAYJKoZIhvcNAQkBFhdzdXBwb3J0QGNzb3Jlc2VhcmNoLmNvbTAe\nFw0wODA3MjgxODQ3MjdaFw0xODA3MjYxODQ3MjdaMIGUMQswCQYDVQQGEwJVUzEO\nMAwGA1UECBMFVGV4YXMxDzANBgNVBAcTBkF1c3RpbjEZMBcGA1UEChMQQ1NPIFJl\nc2VhcmNoIEluYzETMBEGA1UECxMKcHJvZHVjdGlvbjEMMAoGA1UEAxMDY3NvMSYw\nJAYJKoZIhvcNAQkBFhdzdXBwb3J0QGNzb3Jlc2VhcmNoLmNvbTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAJYDztkLmhjwhZrFuCNLMi5bDoiLm/mdSEih\nyeEl5pTMdaw2ZF4I19+DtKxK7PcWSSXWKJfVfD93kys8eZ+xx9fBNiFVqZdkk7Z9\njUAhG5NB/kvLVNrEP2i4ZryXaLpbes/9HSKP2ZE6Iozdz45Ie7tbig6lN3itqDiE\n/AXDTnpBEB2WXaxlIomCzPbWm3bjFEbTOpzaAeyQBv9paxftSvrOREI18Ubv8OYj\ngWszVWTQLuNg7FCivZTk7REerI5hXNVsB0KY2FeIEUqqajxIxlj+vCZTTOhjeHLA\nQKIMkVFAmWEn6zLQDGI8yV4ooab6P1eZNs/vSmY/Foc6Z4fBrkcCAwEAAaOB/DCB\n+TAdBgNVHQ4EFgQUok5bi4sjD0Ud4emkOVF1Or5db/IwgckGA1UdIwSBwTCBvoAU\nok5bi4sjD0Ud4emkOVF1Or5db/KhgZqkgZcwgZQxCzAJBgNVBAYTAlVTMQ4wDAYD\nVQQIEwVUZXhhczEPMA0GA1UEBxMGQXVzdGluMRkwFwYDVQQKExBDU08gUmVzZWFy\nY2ggSW5jMRMwEQYDVQQLEwpwcm9kdWN0aW9uMQwwCgYDVQQDEwNjc28xJjAkBgkq\nhkiG9w0BCQEWF3N1cHBvcnRAY3NvcmVzZWFyY2guY29tggkAsDLmZ6NbRfAwDAYD\nVR0TBAUwAwEB/zANBgkqhkiG9w0BAQQFAAOCAQEAOUVYBoiWvLmhKqYmMXQAMjUx\nOpJPCel/bjMfW4Wlp+2yOuQcuqc9ZkFUME6tjqOgSuQkkU6R88h9jeeZX+s5TAVF\ndPImqHPM/rcLGnoe1Wa/6UR6Zwcp4rsFSDu0+7Jd3PKG3j6lKWezUXargrJZdG5u\ntXuwJf+f6QUiWWNiQI40kF7FhqlCWJ0CqXvNBGRXmdVwLQrADUUyNs4N3DM3hVDS\n0/G9cmszj6oBd/EQznuxVJVvk6vpGBifh47t/LCWNd3rgPf2Rk3qx1HRoqcheJBK\npFT1skULlbFxWMSbnHzHd5evjh5a5B0pzmlrkXpAtVoIVAur0M8FX8+ts+mTNA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.myinterfase.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.myinterfase.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.myinterfase.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.myinterfase.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.myinterfase.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.myinterfase.com/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://aigappt01.ucop.edu", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucop.edu/welcome.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://aigappt01.ucop.edu", 
      "contact_person": [
        {
          "given_name": {
            "text": "Munish Malik", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Munish.Malik@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "UCOP DataCenter HelpDesk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ucopdatacenter.helpdesk@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEhTCCA22gAwIBAgIBADANBgkqhkiG9w0BAQQFADCBjTELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgTAkNBMRAwDgYDVQQHEwdPYWtsYW5kMQ0wCwYDVQQKEwRVQ09QMQww\nCgYDVQQLEwNBSUcxHjAcBgNVBAMTFXNoaWJib2xldGhzcC51Y29wLmVkdTEiMCAG\nCSqGSIb3DQEJARYTYWlnLWFsZXJ0c0B1Y29wLmVkdTAeFw0xMDAxMTQyMjA3MTBa\nFw0xMzAxMTMyMjA3MTBaMIGNMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEDAO\nBgNVBAcTB09ha2xhbmQxDTALBgNVBAoTBFVDT1AxDDAKBgNVBAsTA0FJRzEeMBwG\nA1UEAxMVc2hpYmJvbGV0aHNwLnVjb3AuZWR1MSIwIAYJKoZIhvcNAQkBFhNhaWct\nYWxlcnRzQHVjb3AuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\no58S+32K6mpCCp/R4r40TwX8z4nqEge6mroIWRDJrFuZ3ZdS4Sw2BJQpcoxakYTF\n4jDynvM3S2zk7yom8ghrlT/IEWdojMkFfZykx/XQq1KKLTOc73LqYMKxFRrLd9/d\npk5LEcRysTDkOIlcRUrjnvG/jnsjKydG2VNLrySQ3/PHcjoB2P2NHGPRQMlInjZV\n1XNUC2mC3aCk3PC+jUaR/PE0LzMQ59qHGy5bTQIqGsGifVgCwrjyGqTGmmm4K8qc\nufZLAI+K27oLGUsh8Q6cewnqz8mRd2FJWsk/QVx6Qerp/CacFjxa7U7JKnnE3O1B\nZdmU+YqCRdTJ0QANH5Xi1QIDAQABo4HtMIHqMB0GA1UdDgQWBBRQFY4qfAX8jUwX\nT16LN/HzGBEjgTCBugYDVR0jBIGyMIGvgBRQFY4qfAX8jUwXT16LN/HzGBEjgaGB\nk6SBkDCBjTELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRAwDgYDVQQHEwdPYWts\nYW5kMQ0wCwYDVQQKEwRVQ09QMQwwCgYDVQQLEwNBSUcxHjAcBgNVBAMTFXNoaWJi\nb2xldGhzcC51Y29wLmVkdTEiMCAGCSqGSIb3DQEJARYTYWlnLWFsZXJ0c0B1Y29w\nLmVkdYIBADAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQAfDDpq+pVi\n3+nN2BLuqz2kASyaose7hZrEyf2qSEMOrYtPA99gILvVSSHuOR4PMj1VPqs1NY2+\nAa40Ova/RNW7Psj9qlskvGnbPVRBvEvIVPlYqKT7eVOwCsyeC7Ae3bnA9+UBVBaV\nlTaHIVTjTgmlpMPkg+kHPTr8JoPm6hEhgHxoqGAAQue4g/0rwLOGxlRqKjH4Q+EU\nwJMWZUo071UC5nuzKL/3IEufjcbzogBwW0OMpcwl6rxkbw36tSqZls4TPvR67FUj\nRgsfv6fwNijCs+jTHt0a3tEucCC2ILtwAT5C0sHXruw0+sWVVs+HoOuBEneXa9Br\nyV8pCTW41z4K", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://aigappt01.ucop.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://aigappt01.ucop.edu/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://uldev.library.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://uldev.library.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Kenneth Rose", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kr2e@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://uldev.library.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Library Statistics Server", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDBjCCAe6gAwIBAgIJALV3CRuLppwpMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXVsZGV2LmxpYnJhcnkuY211LmVkdTAeFw0xMzAzMjExODA3MzFaFw0yMzAz\nMTkxODA3MzFaMCAxHjAcBgNVBAMTFXVsZGV2LmxpYnJhcnkuY211LmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMZekOaWdhXl4xiTtMDgAYHdIx8q\nkSZ0LJFgl5R5r//ynmt22xWQOIdTyjq/QnQBK/Hi+0iopH5zXVxeyy2WkrW7a/vU\nSWfD/r1K1lQNW+0G84N/2kl9wcfGxo/OmFYhfy9+ktLO95X44qa/zVn+dPrr69e5\n2ZV5XhX8zC2PHdXdRPIrZqJzTl5Lmgv7Dityv/DoAjBfjS2zuf8zegh09Z4/DJqD\njErFoXVp/K5l35vAZLcGJyufH3iwpRdOT22LGsPNbugMYaHqWBnNzX28aKqq52Om\nB6Q7d2ceFJgstiVJHfSkArTTycFtxaD0i2cJVVgSMlXAjjs1VHiQa2cPD0cCAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVdWxkZXYubGlicmFyeS5jbXUuZWR1MB0GA1UdDgQW\nBBSk+Gi9ZrBXMu2jqtrjSfHt0XR4tjANBgkqhkiG9w0BAQUFAAOCAQEAfoeCKYA+\nGkFOPrubBfyA8H2c6UUHxGhlhAhbAIZmg66IYbrUcEYkFvhlqQFBfEA8+xrdgZ+e\n0it5Ha31f7FCYnB4BfO2mAtH6FfXNYALfNwInet65AY2e/2Bi7FnTisACDZkREkv\nCFITQhqoFUg19/ggkG+XrDDjc/RJDODL1fbD/2wWJv8LczislpaMRQjUXDGQFpWC\nsskypvedBuRlY2+N3DX6cqPdvAaMp90VQozMIlaBkUMtztf4JFW1zTBJcVnYA1KK\nUzO+FkPw1xXL5t/8ZfMgHgnKTa7G26myTYhP/VPFP/VkiTGmvGSJYuenYgriKu9w\nD6qnh5IVuo1Zsw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uldev.library.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uldev.library.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uldev.library.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uldev.library.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uldev.library.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uldev.library.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ermspqa.ucop.edu", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucop.edu/welcome.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ermspqa.ucop.edu", 
      "contact_person": [
        {
          "given_name": {
            "text": "UCOP DataCenter HelpDesk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ucopdatacenter.helpdesk@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "AIG", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aig@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "ermspqa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEjjCCA3agAwIBAgIBADANBgkqhkiG9w0BAQQFADCBkDELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgTAkNBMRAwDgYDVQQHEwdPYWxMYW5kMQ0wCwYDVQQKEwR1Y29wMQww\nCgYDVQQLEwNBSUcxGTAXBgNVBAMTEGVybXNwcWEudWNvcC5lZHUxKjAoBgkqhkiG\n9w0BCQEWG0hhcmluYXRoLkNoaWRpcG90dUB1Y29wLmVkdTAeFw0xMDEwMTExNjM4\nMTNaFw0xNTEwMTAxNjM4MTNaMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0Ex\nEDAOBgNVBAcTB09hbExhbmQxDTALBgNVBAoTBHVjb3AxDDAKBgNVBAsTA0FJRzEZ\nMBcGA1UEAxMQZXJtc3BxYS51Y29wLmVkdTEqMCgGCSqGSIb3DQEJARYbSGFyaW5h\ndGguQ2hpZGlwb3R1QHVjb3AuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAo7mhIdlBdhci+/1IPPHAp/+HQaTUevRTCdfvIU94+VtJK1X/M5i0YcqA\nlmLFLO4IUwjgLQ0b90HaHQypaWxVL3fXnKJN8y8BC4QAEbcBSGGsg4hqN5rnYpBG\nn7gNsa6qkk/snLk3f0r6N8ceU6h5WckqdpT+8PXXgUfpkdQHd/meOaxqRJXRDFts\nWLLaf+c3RtB49U+INrEkKlry0vOhOLgUnm6wP6jUT+KCnpANnVVRTi+8YLPattzs\ndS6qnEvoE4DnmCb9hs5QpgpVrUvUahas+Jbsnu7cK8A+x2xI3aRO9o10brnNjsrg\nyXgOUadZkM86tXqmrAX75k/JPSExzwIDAQABo4HwMIHtMB0GA1UdDgQWBBQi5SJI\nTGEa79RdcG13ghuf8vYXWTCBvQYDVR0jBIG1MIGygBQi5SJITGEa79RdcG13ghuf\n8vYXWaGBlqSBkzCBkDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRAwDgYDVQQH\nEwdPYWxMYW5kMQ0wCwYDVQQKEwR1Y29wMQwwCgYDVQQLEwNBSUcxGTAXBgNVBAMT\nEGVybXNwcWEudWNvcC5lZHUxKjAoBgkqhkiG9w0BCQEWG0hhcmluYXRoLkNoaWRp\ncG90dUB1Y29wLmVkdYIBADAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IB\nAQBx70jFHwAaTG3+p8WUphR7TGb2HqTush77df9jiqr4HfYgnSAMRB58QnunJA/t\nwWMZw0OW8Z4q2DoUrRzT+6XiuvMABCHDz/OOLZv7Y9e57+H4G9kZym8tjypkmsuV\nyR4Xg34Y8CSfJq5JWGmqwTz3T7namJotK7VopyHfGlXwTiK4UkZELoy+Ijf9bIOU\nw1yGx5t+tKjozcO5WwErQEXwxKMvMIwuz8U6xkuAdDDg08XSJe6BPIPjGRsPuLmT\nmna55qgULe66epHgXVxRWhhJtYJ1PiDQHBu4v4dwsCg0YiLE6+FFj7TnFUmwyHzl\nImvqy9Xe9nPpUakAh0HCx9An", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ermspqa.ucop.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ermspqa.ucop.edu/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://pa1429.peopleadmin.com/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "PeopleAdmin, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "PeopleAdmin, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://pa1429.peopleadmin.com/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Praveen Pinto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "praveen.pinto@peopleadmin.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Bryan Garner", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bryan.garner@peopleadmin.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "PeopleAdmin 7 WIT", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC9DCCAdygAwIBAgIJAK9qYIpSXmuLMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3Blb3BsZWFkbWluLmNvbTAeFw0xMzA4MDYwNDExMjJaFw0yMzA4MDQwNDEx\nMjJaMBoxGDAWBgNVBAMTD3Blb3BsZWFkbWluLmNvbTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAPNJA6keJeqd1d8rBtHYenYT+2Z5p14STKAMxI+OHzTF\n1ILCp/tXfaTeWggztaCCSGYFwSJkCaKeaLC4+easqoqS18zen4j6OEG6UWF5sUd7\nj6GumoZmFa4bYTcTpkdpa9ENG+0OKLRzWz/TTyzSdBhR3J1b1Vt+6fF/clKR1CWT\npdHsRYwGCn9jBRN7gZkNEagh4hrjfpIMgfJ7K6FRiXb5yj5pEusFm9T9ZElMFat3\npy7PQEv9F78wKbgqqFSTnnE3rWRPy8+5tTa5kpNd6GlzqiwlhY/Yqbof1lgABcNP\nN+AX1ZRRybQheE/2e53y+5/J/F4aIUHx1WJaInD35zECAwEAAaM9MDswGgYDVR0R\nBBMwEYIPcGVvcGxlYWRtaW4uY29tMB0GA1UdDgQWBBRojmrNNN8S7AEfM20TF5MI\nRPnSnDANBgkqhkiG9w0BAQUFAAOCAQEA0yEXDmrQwS7s2gSMqMm7NXlMAAwzNDhI\nOujZiSHZ1KL71bKzKHQVz5oenjJwVem/gxo7GVsuIdIZ3vKe8PYsnLu1QDTp4ZHv\nmzgRlx4kuqGjwSNs2ub2NlVc9wy9uC0pjJL58RaOxPpHDddCAs+xINF2S1ZJEM2D\nXkMvb1xhaOLox1HGhENf99ka10jWMdMt2bj1lT8WM/Qg+XgOnoQvTyjOtELM/QuA\nOVuT1bTdGg4K398O7jlTzoo7LFhPBl99HDx3cDhhhX9NdWyFyQ32MhYa6361v+eG\nDvoszRsTTKZLYbNvWoo8BZMCxK5tQ6EqNyQTmekHxw+peNCaQ+nDKw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jobs.wit.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wit-training.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wit-sb.peopleadmin.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:musc.edu", 
    {
      "entity_id": "urn:mace:incommon:musc.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.musc.edu/shibboleth-idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.musc.edu/shibboleth-idp/profile/Shibboleth/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "musc.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDPjCCAiagAwIBAgIJAOhQxRwlMGgIMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3NoaWJib2xldGgubXVzYy5lZHUwHhcNMTMwMTA0MDE1MTAwWhcNMjMwMTAy\nMDE1MTAwWjAeMRwwGgYDVQQDExNzaGliYm9sZXRoLm11c2MuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoW2hT67QlW+YDCrhhjCyIrRpwksNqBvJ\ntKgwDrnQwOyMmThDoQBhcgJUTiavZ6ZP7cC0HAE9+8ComDaUVIewyYWKsgZTp79Q\n9BbEMW/op/kqYVzlHzoC8LfjfyPuttTChXeVvA8zx3eat4LJZEgX2m0D9Tfh0Rco\nVekYx+3hp+xs7DW/jAvHkCeamhR2jLEWGvtMte4cnJclq+yaejytFN6rvXiMI2QA\nsG2+/+I+hvCP22/SS1b30yhszOV8zU80gV8Cq/uSp57PWJVDQ4Rje2Vw99MWvSvA\nos4A+iwRFH9AIfEtCgGmgpMKc1J7KzM9lN9f0Qvql+RSqvrxD9/CXwIDAQABo38w\nfTAdBgNVHQ4EFgQUOyBE+oZl6so/wzN6C1RDnonqZm0wTgYDVR0jBEcwRYAUOyBE\n+oZl6so/wzN6C1RDnonqZm2hIqQgMB4xHDAaBgNVBAMTE3NoaWJib2xldGgubXVz\nYy5lZHWCCQDoUMUcJTBoCDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IB\nAQBmpjbrRMp6XiFyr2+HnD20IKQ7u2A2C2eJAPdAcFZMKGPnEX88TTMxjAO+5+hS\nzLgCUsFvXOMKZF7ncadnocozN6+affODvWU0J1+aSw1xvyemH/QuGSpW77+gBOGl\nuHg/UNKWyAjCpgt2avXkBhjsGLiN8AWj7mGcw8HKHrK7+4BU8L9TWM9ddzfHySn/\n/PXn/XBpzUialyLgS28nAuDF+qgtEhzMaB5T3PkbAacEqzCelRyVocfqjuYinusk\nnlH50wO+ogWqYa7JYPF86r1Lz1FS/qCaWzDtQdf+ZYXvPrcIT5bcY9vQx8gkR1VG\nDxVIAjeM+koyHkSro/jWAJae", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.musc.edu/shibboleth-idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.musc.edu/shibboleth-idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "musc.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDPjCCAiagAwIBAgIJAOhQxRwlMGgIMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE3NoaWJib2xldGgubXVzYy5lZHUwHhcNMTMwMTA0MDE1MTAwWhcNMjMwMTAy\nMDE1MTAwWjAeMRwwGgYDVQQDExNzaGliYm9sZXRoLm11c2MuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoW2hT67QlW+YDCrhhjCyIrRpwksNqBvJ\ntKgwDrnQwOyMmThDoQBhcgJUTiavZ6ZP7cC0HAE9+8ComDaUVIewyYWKsgZTp79Q\n9BbEMW/op/kqYVzlHzoC8LfjfyPuttTChXeVvA8zx3eat4LJZEgX2m0D9Tfh0Rco\nVekYx+3hp+xs7DW/jAvHkCeamhR2jLEWGvtMte4cnJclq+yaejytFN6rvXiMI2QA\nsG2+/+I+hvCP22/SS1b30yhszOV8zU80gV8Cq/uSp57PWJVDQ4Rje2Vw99MWvSvA\nos4A+iwRFH9AIfEtCgGmgpMKc1J7KzM9lN9f0Qvql+RSqvrxD9/CXwIDAQABo38w\nfTAdBgNVHQ4EFgQUOyBE+oZl6so/wzN6C1RDnonqZm0wTgYDVR0jBEcwRYAUOyBE\n+oZl6so/wzN6C1RDnonqZm2hIqQgMB4xHDAaBgNVBAMTE3NoaWJib2xldGgubXVz\nYy5lZHWCCQDoUMUcJTBoCDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IB\nAQBmpjbrRMp6XiFyr2+HnD20IKQ7u2A2C2eJAPdAcFZMKGPnEX88TTMxjAO+5+hS\nzLgCUsFvXOMKZF7ncadnocozN6+affODvWU0J1+aSw1xvyemH/QuGSpW77+gBOGl\nuHg/UNKWyAjCpgt2avXkBhjsGLiN8AWj7mGcw8HKHrK7+4BU8L9TWM9ddzfHySn/\n/PXn/XBpzUialyLgS28nAuDF+qgtEhzMaB5T3PkbAacEqzCelRyVocfqjuYinusk\nnlH50wO+ogWqYa7JYPF86r1Lz1FS/qCaWzDtQdf+ZYXvPrcIT5bcY9vQx8gkR1VG\nDxVIAjeM+koyHkSro/jWAJae", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.musc.edu/shibboleth-idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.musc.edu/shibboleth-idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Medical University of South Carolina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Medical University of South Carolina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.musc.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Richard Gadsden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gadsden@musc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Joshua Staples", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "staplesj@musc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Shibboleth IDP Group", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibidp@musc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://cspluis.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.qualtrics.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://cspluis.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Michael Page", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@qualtrics.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Qualtrics Labs, Inc.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFbDCCA1QCCQC8OqKPlGUkRDANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJV\nUzENMAsGA1UECBMEVXRhaDEOMAwGA1UEBxMFUHJvdm8xGDAWBgNVBAoTD1F1YWx0\ncmljcywgSW5jLjEgMB4GCSqGSIb3DQEJARYRZGJhQHF1YWx0cmljcy5jb20wHhcN\nMTAwNDA3MTkzMzA0WhcNMjAwNDA3MTkzMzA0WjCBhzELMAkGA1UEBhMCVVMxDTAL\nBgNVBAgTBFV0YWgxDjAMBgNVBAcTBVByb3ZvMRgwFgYDVQQKEw9RdWFsdHJpY3Ms\nIEluYy4xGDAWBgNVBAMMDyoucXVhbHRyaWNzLmNvbTElMCMGCSqGSIb3DQEJARYW\nc3NvYWRtaW5AcXVhbHRyaWNzLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC\nAgoCggIBAM7T6YYEDd91lehKK/51V3Li6zk/wqHZ1OZ4rHw22AtTasl0qrEwdXbL\nsCUmO4rEXhAnjgpIZPFHs+1sFpSCalerYa+ROJX5B5N9MnENYr6E8KHa8spbVBEl\n2/ZE6RlPdHBs+iCDuoTTqOa2sZ8vqTpTF3grVdgeW3KfBOO9yENa04lA6xhPAQs3\nkihDQvPoWnlXtQA3gmtb+sGZmKYXonBVwIDsrDbhpoFcHJJRrFEEawSHOI3IeHBo\nhR1jhfb95E3cQ0s7gQ+FbR+lkzwb3i3WrCkZr3w2KpudJEzy/kT7JBLvfELW8eR4\nj2XRKyRhxNHOKc/AC8fNIrGam0CAqK9elpJnB6zmALQUYXVGddv3sd9ITIfZQ9Ox\ng9ChVqsNAY6VIlg5+/Q3Ega+BR/P/OpMnG9xW+cyLslzjiUf4c0K6I2pObcJkJMw\nqGHOSbD9lGa/WxaEAFC1+6oDNRbC3S2mbo4gW6LPVbtCxC0IMxOyaOKBwe3sW9v+\nrumd02ZuJRtbTbarde7N6aUmm2hXfDQntCIXWUJ+9b+YvjcWUlUN0KvVq8jFn1Z7\nkD1po2eY+lc9VHYoh1jdP08G9H8CZdJTDwR4KDPG0U2rD+xXmxO+9CEeQev1d/Iu\nqcadQxRka7hbhIijtVJgjO3jP6AwiHXFGpBvApyIuuXJU8CyKSsXAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggIBAAcXtiFXJ5Vm0mwhiDRoTGwIGz+Ryg13X6X9w6GfVENt\nNexDExwzPgxnW1gG7u9FUx2tl2geZ8BJOqk3pGnLSZI4QF/nVnB+hTPMLOwXjtMk\nMF5FXlM7QvOKOTzzK7+2wug2ssZi5ZpQVGODhPsytu+GjMJwydLj6RRAnJV/9wmu\nivZhIbQyrOs0XBxuYO0n9OzlOa9JVFtUxnckT93UYIjcCVEu2r+m20Zm8BEofKTr\nTz3vodizFV5uHbmQ19iLxDrZsu9rbpEHojWMgnKnq1XoC7TmlxB1/OQctUnjpRPT\nWySZkTdWX4cKBjQHzCHJyl0Z4hAP4m3fWFLXVK3w8U1e+Mbfm0jUT9+amUfdzL+8\n9ZjwnFvpuFNWsS33yYWp51+rVdtU0jYII1f8XWNRn4EV54MwoOWrEXKDZ0qmbxi5\nnVR/F5QofEGv/ZYMgcFaX5OMP5lRE8IjQu9Eq26zZA6YuR5fZfiTHZppwc6Ey9Zc\nGpRsLwFSwma0/Vtlfxr/KtaKsk2zlOOJ6RF33MUyZvw8N+tybY0yHJ40aBZKFr9r\nr3j//DUU8zi4qvNP5z19kS08sZ7mtNK2sKBPWVSYB2HDtyrBSRupHBYeIxlfGKd6\nuVUusHTyyVjDKbuMHCw+DEp0VXmCIAv5Jf+SKZ7DOkw8cxcdL67gEc9NjAmsfmKy", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cspluis.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cspluis.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml1-acs.php/default-sp"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://commons-test.lbl.gov/sp/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Lawrence Berkeley National Laboratory", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Lawrence Berkeley National Laboratory", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.lbl.gov/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://commons-test.lbl.gov/sp/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Julie Petersen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jmpetersen@lbl.gov", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Charlie Verboom", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ceverboom@lbl.gov", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Greg Haverkamp", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gahaverkamp@lbl.gov", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://commons-test.lbl.gov/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://commons-test.lbl.gov/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://commons-test.lbl.gov/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://commons-test.lbl.gov/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://commons-test.lbl.gov/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://commons-test.lbl.gov/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://commons-test.lbl.gov/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "TEST Berkeley Lab Commons", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAMFvgJRFOa3hMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGNvbW1vbnMyLmxibC5nb3YwHhcNMTAxMTA0MDAyMjQ5WhcNMjAxMTAxMDAy\nMjQ5WjAbMRkwFwYDVQQDExBjb21tb25zMi5sYmwuZ292MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAwRm530qhkb6e09J3QHgu7OuhnOeJ3VHN6DGXfmNc\n2b2/5ql79th6kpugJF5/Bxm1OYjK3bdEPGaG8yJ1utWZ14cPqFeHIh951cRkWU7L\nFJQ+yJPFKvMwmXmcGEqy1NFfFmCRQRC3WRkH7/Hp7WGRPkXWiLh4rUBPNKNzAXr4\nGhvQrQ2AN9bhChNa1zY08PvYucM2y78yQ7+FdMVXET2cDIPW6FzSBpHVBLwJ6Irh\nd2cdRUDSBVak+ZhnzpvLlf9LfsdUftHNyak6wCjnK8RjaTwFYrBGUZCE8BcD/yV1\nDGlpBhVNEq9e2EoKf2LBfwyDaMIZ72Eeu0mBdFZQjpWKWQIDAQABoz4wPDAbBgNV\nHREEFDASghBjb21tb25zMi5sYmwuZ292MB0GA1UdDgQWBBQd8cXLi8vWArhLTP46\nW9mLkn2wtTANBgkqhkiG9w0BAQUFAAOCAQEAVKXVe1GfD2rFtVhgA4rveGs6uwqs\n8O0JGBGvmd9FYVjaRQDaOTvqjiszasu+UWi2vFV5EGZxaqTYqjJ4Lhp2wUj2QO5i\nq7EJsdUsN4tLJITWjslojXyRJSWEpZLtV8zwfK+jQSL3x83Hw0odz4rFm0dOSpeP\nYJpo1KfvO/6SkHOHgNILhH7hgl+a0GxaeLslNfdKBrhShuO2biVvr7Z4gJvG+V0A\n8zm3+1KQvoPGwJQpRH1w9JWsereq+l6RO8mL07n3KOf+R18aD1z27hgrB2xnXRvJ\ny5ro/o5ZL+nrpKyCIDL0mIb1ZgA7Zu+R0m1wrHPSQrQjjw1R7aA/7XL8jg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "TEST Berkeley Lab Commons", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://olemiss-sa.terradotta.com/sp/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Terra Dotta, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Terra Dotta, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.terradotta.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://olemiss-sa.terradotta.com/sp/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jason Johnson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jasonj@terradotta.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Terra Dotta Software SP for University of Mississippi", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC4jCCAcqgAwIBAgIJALldpggjWmriMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCTE4OTYxMC0yNDAeFw0xMzA0MTAwMjU3MTJaFw0yMzA0MDgwMjU3MTJaMBQx\nEjAQBgNVBAMTCTE4OTYxMC0yNDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAPZ9So31RPtzb0EFP8tWOhnjKXaKe9IBO175r12EM9bMUNBLgAtfYH49qoea\nDD+/eG988zmZA8ixxZsPUrFR7qi7PJXW5c5iBqZDKPvO3HWBi3cMBoBnWn4zEU9r\ncb/AzMMFjn/0/4yilRmuRCOoiLUH1FcDwQcKhwwqNZiZBQ2tREKiTlcEVzQaOzLJ\nrAPgFZaE/nJzCI5KKWgT36wrbHcqGM4c/dIvwXFyGne2N3BXmRefl6s+wdAEPRPx\nhcqgqekaBYZCF5Og1UnLH0oOZqn0OIAFqtR7pyxxQjF+oZTnBi+LNOB5QF8q7Rd/\noUFh7ZA3HJjy2IZzCG7WttoNx5ECAwEAAaM3MDUwFAYDVR0RBA0wC4IJMTg5NjEw\nLTI0MB0GA1UdDgQWBBQMICIjrW9osFKSLrfuCIpPThXzGzANBgkqhkiG9w0BAQUF\nAAOCAQEAuoFcI1J3tuZ03o1yAWihDNDNFANxlLTc3swxpnQ5+UJmN9/C0t0Gjx5V\n5PWon/+NNXqwP60TrTL+ZeGYVpH0hn4E6iZqCH6vgT1+tiMkOUJiWuo3d3ObCsym\nrp030CFc9DcMSyrQxZpDkQ8FOeJi7R/td1qloHujNVuAXOgdf9Su8vXLA8Xv/2pZ\nlmAD/jn7hhQUpwPhO+7OrBqZVxbFg/twa2l9pmOd2ZrY+KNoUApITDcIHXKsjkeq\ntsESY0foXrbIo7/lqaHpKtbQtTZu6Ik+uBWEoL16okV//gouO/ZtCLAxuUHWXZ41\n3p5sQ6ShQElMY9pzRJ/aza/3I4ySXA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studyabroad.olemiss.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://etan-x.nts.jhu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Johns Hopkins University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Johns Hopkins", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.jhu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://etan-x.nts.jhu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Etan Weintraub", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "eweintra@jhmi.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Andy Baldwin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "andrew.baldwin@jhu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Enterprise Authentication", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "enterpriseauth@jhmi.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Johns Hopkins Test Shibboleth SP", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "A test Shibboleth Service Provider at Johns Hopkins for use with multiple federations and testing of upgrades", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDJDCCAgygAwIBAgIJANllTVjcR1/YMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEmV0YW4teC5udHMuamh1LmVkdTAeFw0wOTA4MjUxODM1MjJaFw0xOTA4MjMx\nODM1MjJaMB0xGzAZBgNVBAMTEmV0YW4teC5udHMuamh1LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAOawg5eUEN/rc1QayopfElT8viATulEOVLmY\nWmeCjSIMWTNIC+Bkc8DmJTKet383QH76RFcboZDiGCncTqdi6gZsWKq6f4HJ78Tj\nQGrib3KSn4cN04NH/zB2vZXTDZvsea587FXfo7HXL2y8qBD72dfRfm3i0F6m8+R5\nBMxbTQuwjSMOUjj/q9dt/DreF60j+2GIHqwBpk+AZHyBxzLd9Z90lDpVTZ71PXF5\nEtzQNL5+6GxbycFtWiLQM4FZWoctRllCZH0CdC5ZDdsDe9ztVe38J6+bfUUaOHOA\nbXd4LcE/Er0BGY9tHTb8lRH1+D7HEmX0qItAGWcnCLKedkTyicsCAwEAAaNnMGUw\nRAYDVR0RBD0wO4ISZXRhbi14Lm50cy5qaHUuZWR1hiVodHRwczovL2V0YW4teC5u\ndHMuamh1LmVkdS9zaGliYm9sZXRoMB0GA1UdDgQWBBR3iRLSOriEWF/0FTbTTtDv\nyVPAkDANBgkqhkiG9w0BAQUFAAOCAQEANGi+VAnzHp6nukTY1Z8HwT/4TUBbRNi0\nZY+n2g/Y+ysHWeSGs6/nKlTh1ftx+IBDp0Gc776vzHrN5ITy4cFdu9iBwK2knkBP\n7BxJqIIQYJ9oy1ThY88475ki7anl9FO6mVS5mF2uqdeJ5M/97DtG7bxXMYAb5U1O\n02zD5i3RTYHr8qOcKZ5uiI1CUQ3+2eY1w3KUfBAhpX0c4sFQvoZRmmg349N5Lykc\nIsL41wehC2DEml/it4dh+NrF6DgbQdV3wQwqHHLjqWsCVHV6Kx8quiz20JGQCMHm\nGviwJimume37ak7z0DzpiRfijkqrAnN1QmXq3ub721/vwZBg2s10Ow==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://etan-x.nts.jhu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://wiki.clemson.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://wiki.clemson.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Barry Johnson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hbj@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Kathy Wright", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kewrig@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Jill Gemmill", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gemmill@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDHDCCAgSgAwIBAgIJAPSKZ75YpLvBMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHdpa2kuY2xlbXNvbi5lZHUwHhcNMDgxMTA2MjAxNzEzWhcNMTgxMTA0MjAx\nNzEzWjAbMRkwFwYDVQQDExB3aWtpLmNsZW1zb24uZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAuejzfYPLJmtRwf+KD41bgT0d/BtLVEqXJhHOIG+P\nUWAyJtel+QYWMqLSuByRHxaSBAropIiKGDIVqk9M0gO1NWgLfVggY4qJCxUDi7/W\n2iF9jU3vsOcmJQGbTxd10ZNet/BVS4adJKccyNK59xRgfseS6iIve0Y3HY/Nmu5e\ny/IM00kQQk3E5jAwRxu6JLhWyQXYq19keHjFwE3aYPpmMg0OFhCZRjIMD0HP7cFb\nwa+lnG0zmbJgpUmpg5c3iyWfhxOFtlL+rNihDB709Ti/a8yLAu6ShaoUrPNmZXuK\nv7/bwj/OE0HFNw9rKhIyALxeWupsAvYM2e2fmIeQWVqSWwIDAQABo2MwYTBABgNV\nHREEOTA3ghB3aWtpLmNsZW1zb24uZWR1hiNodHRwczovL3dpa2kuY2xlbXNvbi5l\nZHUvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUAZNFPiVlNnKKfNyx8yd3gKkrT3UwDQYJ\nKoZIhvcNAQEFBQADggEBAFgxrdH1hLRx+2xlmUfiyJt82VJiIXuRp0sgk/Buyjcj\nTZjU1RMWRasnmXJh6RsirP000IOZ7mK2NWnTlY2zbGWiIqifhiQpn+SqLiL2Fbww\n1cM9fNdI1lXtamIo9m5DGsnN39AirezbwgjMGnW2tHUrw/KYqjDYui9nRhBOE4BB\nD7r3vVW8CJH/sbId/wKyb27H1Ep/9k5l+wr82kOCvtM4Fr2CCArFbablgOykyKA/\nd1rQlfU/3tgwReVT9tHUVAt4vubiHbHvvH5j5o/WRdXJMNiLBzmmMdi8+m5vT4NF\n2XiCrPad9FnZZWLdPApSsmp4N9vhJKaJWAEB+Po1ud4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://upenn.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.qualtrics.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://upenn.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Michael Page", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@qualtrics.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Qualtrics Labs, Inc.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFbDCCA1QCCQC8OqKPlGUkRDANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJV\nUzENMAsGA1UECBMEVXRhaDEOMAwGA1UEBxMFUHJvdm8xGDAWBgNVBAoTD1F1YWx0\ncmljcywgSW5jLjEgMB4GCSqGSIb3DQEJARYRZGJhQHF1YWx0cmljcy5jb20wHhcN\nMTAwNDA3MTkzMzA0WhcNMjAwNDA3MTkzMzA0WjCBhzELMAkGA1UEBhMCVVMxDTAL\nBgNVBAgTBFV0YWgxDjAMBgNVBAcTBVByb3ZvMRgwFgYDVQQKEw9RdWFsdHJpY3Ms\nIEluYy4xGDAWBgNVBAMMDyoucXVhbHRyaWNzLmNvbTElMCMGCSqGSIb3DQEJARYW\nc3NvYWRtaW5AcXVhbHRyaWNzLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC\nAgoCggIBAM7T6YYEDd91lehKK/51V3Li6zk/wqHZ1OZ4rHw22AtTasl0qrEwdXbL\nsCUmO4rEXhAnjgpIZPFHs+1sFpSCalerYa+ROJX5B5N9MnENYr6E8KHa8spbVBEl\n2/ZE6RlPdHBs+iCDuoTTqOa2sZ8vqTpTF3grVdgeW3KfBOO9yENa04lA6xhPAQs3\nkihDQvPoWnlXtQA3gmtb+sGZmKYXonBVwIDsrDbhpoFcHJJRrFEEawSHOI3IeHBo\nhR1jhfb95E3cQ0s7gQ+FbR+lkzwb3i3WrCkZr3w2KpudJEzy/kT7JBLvfELW8eR4\nj2XRKyRhxNHOKc/AC8fNIrGam0CAqK9elpJnB6zmALQUYXVGddv3sd9ITIfZQ9Ox\ng9ChVqsNAY6VIlg5+/Q3Ega+BR/P/OpMnG9xW+cyLslzjiUf4c0K6I2pObcJkJMw\nqGHOSbD9lGa/WxaEAFC1+6oDNRbC3S2mbo4gW6LPVbtCxC0IMxOyaOKBwe3sW9v+\nrumd02ZuJRtbTbarde7N6aUmm2hXfDQntCIXWUJ+9b+YvjcWUlUN0KvVq8jFn1Z7\nkD1po2eY+lc9VHYoh1jdP08G9H8CZdJTDwR4KDPG0U2rD+xXmxO+9CEeQev1d/Iu\nqcadQxRka7hbhIijtVJgjO3jP6AwiHXFGpBvApyIuuXJU8CyKSsXAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggIBAAcXtiFXJ5Vm0mwhiDRoTGwIGz+Ryg13X6X9w6GfVENt\nNexDExwzPgxnW1gG7u9FUx2tl2geZ8BJOqk3pGnLSZI4QF/nVnB+hTPMLOwXjtMk\nMF5FXlM7QvOKOTzzK7+2wug2ssZi5ZpQVGODhPsytu+GjMJwydLj6RRAnJV/9wmu\nivZhIbQyrOs0XBxuYO0n9OzlOa9JVFtUxnckT93UYIjcCVEu2r+m20Zm8BEofKTr\nTz3vodizFV5uHbmQ19iLxDrZsu9rbpEHojWMgnKnq1XoC7TmlxB1/OQctUnjpRPT\nWySZkTdWX4cKBjQHzCHJyl0Z4hAP4m3fWFLXVK3w8U1e+Mbfm0jUT9+amUfdzL+8\n9ZjwnFvpuFNWsS33yYWp51+rVdtU0jYII1f8XWNRn4EV54MwoOWrEXKDZ0qmbxi5\nnVR/F5QofEGv/ZYMgcFaX5OMP5lRE8IjQu9Eq26zZA6YuR5fZfiTHZppwc6Ey9Zc\nGpRsLwFSwma0/Vtlfxr/KtaKsk2zlOOJ6RF33MUyZvw8N+tybY0yHJ40aBZKFr9r\nr3j//DUU8zi4qvNP5z19kS08sZ7mtNK2sKBPWVSYB2HDtyrBSRupHBYeIxlfGKd6\nuVUusHTyyVjDKbuMHCw+DEp0VXmCIAv5Jf+SKZ7DOkw8cxcdL67gEc9NjAmsfmKy", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://upenn.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://upenn.co1.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml1-acs.php/default-sp"
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:starkstate.edu", 
    {
      "entity_id": "urn:mace:incommon:starkstate.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://webauth.starkstate.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://webauth.starkstate.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://webauth.starkstate.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://webauth.starkstate.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "starkstate.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDRDCCAiygAwIBAgIVAMa41Sm2Z43/pbQY6PVnKuY6ZBFCMA0GCSqGSIb3DQEB\nBQUAMCExHzAdBgNVBAMTFndlYmF1dGguc3RhcmtzdGF0ZS5lZHUwHhcNMTIwMjA3\nMTUxMzE0WhcNMzIwMjA3MTUxMzE0WjAhMR8wHQYDVQQDExZ3ZWJhdXRoLnN0YXJr\nc3RhdGUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAraT5iU6p\nRM5dJf1721dGiy1M8XesErWTj4uBH2AJwcRAcpRVEE8FDn9Poz23aIRjhX2T8t6y\nySV7ejGjneWt1WL3WWU6spipcqLXg3AbSLjk6Zd5QNgKWD2MmSZvgU2327Qal76a\ngRKMpoTrdsauiJFzYIvW5Qoe++t4pGiAr2y0Qrq901gr8x15rC71riPQSnumU9gE\nkVQaIkvEw7brJgEORO4h/07vmggpAsDdc+cpTj5UG9lw+eYjEeg+czHTeyl1SFWR\nRyfc6/Ja1gTHScccUPQR6CYUGQhnT+gD9otAxll7wo9suAF5/pxCSdVDJNt5PHfm\n4b6Sxd2506SLzQIDAQABo3MwcTBQBgNVHREESTBHghZ3ZWJhdXRoLnN0YXJrc3Rh\ndGUuZWR1hi1odHRwczovL3dlYmF1dGguc3RhcmtzdGF0ZS5lZHUvaWRwL3NoaWJi\nb2xldGgwHQYDVR0OBBYEFLEGGfGxSOPAgP1liztCzPrCrnzKMA0GCSqGSIb3DQEB\nBQUAA4IBAQAC6YHhSwz/3NCHvonsIOnRu20RANLFiQ7+tCd9p3ZODkEUfNPIq29A\nlrO37cVOQoAxvzdwFdz+qoV1Ipo+4IafhDDl1zdbhSFGYzKUaGkByGw2O3KEvaX5\nA10dI7xKeyJg8BXtumKz5qXiOzA4HN4UVZriCWw7unNdmSGS6PGiZ7t9pPMHUk2H\njipaqfMXAqPK6HA/IHoB5k/PNDgV/hnpYiGYc/coYTL3s4mO80/NCrUHb2WP2Ku0\n/WRmBjNm2r5KIYuUl40A8wEjcR7l/fXJccahiypmtB4BBYlK2v2ktc6sb2+riXk2\nvKC1XL9IeVtw8IvrnaNTZnuW87F6XdEo", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://webauth.starkstate.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://webauth.starkstate.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "starkstate.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDRDCCAiygAwIBAgIVAMa41Sm2Z43/pbQY6PVnKuY6ZBFCMA0GCSqGSIb3DQEB\nBQUAMCExHzAdBgNVBAMTFndlYmF1dGguc3RhcmtzdGF0ZS5lZHUwHhcNMTIwMjA3\nMTUxMzE0WhcNMzIwMjA3MTUxMzE0WjAhMR8wHQYDVQQDExZ3ZWJhdXRoLnN0YXJr\nc3RhdGUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAraT5iU6p\nRM5dJf1721dGiy1M8XesErWTj4uBH2AJwcRAcpRVEE8FDn9Poz23aIRjhX2T8t6y\nySV7ejGjneWt1WL3WWU6spipcqLXg3AbSLjk6Zd5QNgKWD2MmSZvgU2327Qal76a\ngRKMpoTrdsauiJFzYIvW5Qoe++t4pGiAr2y0Qrq901gr8x15rC71riPQSnumU9gE\nkVQaIkvEw7brJgEORO4h/07vmggpAsDdc+cpTj5UG9lw+eYjEeg+czHTeyl1SFWR\nRyfc6/Ja1gTHScccUPQR6CYUGQhnT+gD9otAxll7wo9suAF5/pxCSdVDJNt5PHfm\n4b6Sxd2506SLzQIDAQABo3MwcTBQBgNVHREESTBHghZ3ZWJhdXRoLnN0YXJrc3Rh\ndGUuZWR1hi1odHRwczovL3dlYmF1dGguc3RhcmtzdGF0ZS5lZHUvaWRwL3NoaWJi\nb2xldGgwHQYDVR0OBBYEFLEGGfGxSOPAgP1liztCzPrCrnzKMA0GCSqGSIb3DQEB\nBQUAA4IBAQAC6YHhSwz/3NCHvonsIOnRu20RANLFiQ7+tCd9p3ZODkEUfNPIq29A\nlrO37cVOQoAxvzdwFdz+qoV1Ipo+4IafhDDl1zdbhSFGYzKUaGkByGw2O3KEvaX5\nA10dI7xKeyJg8BXtumKz5qXiOzA4HN4UVZriCWw7unNdmSGS6PGiZ7t9pPMHUk2H\njipaqfMXAqPK6HA/IHoB5k/PNDgV/hnpYiGYc/coYTL3s4mO80/NCrUHb2WP2Ku0\n/WRmBjNm2r5KIYuUl40A8wEjcR7l/fXJccahiypmtB4BBYlK2v2ktc6sb2+riXk2\nvKC1XL9IeVtw8IvrnaNTZnuW87F6XdEo", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://webauth.starkstate.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://webauth.starkstate.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Stark State College of Technology", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Stark State College of Technology", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.starkstate.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Geoff Starnes", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gstarnes@starkstate.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Geoff Starnes", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gstarnes@starkstate.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://learning.outreach.psu.edu/destinyone-sv", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "The Pennsylvania State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Penn State", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.psu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://learning.outreach.psu.edu/destinyone-sv", 
      "contact_person": [
        {
          "given_name": {
            "text": "System Administration Staff", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sysadmin@outreach.psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "System Administration Staff", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sysadmin@outreach.psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "System Administration Staff", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sysadmin@outreach.psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.psu.edu/ur/privacy.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.psu.edu/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Penn State Staff", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://ait.its.psu.edu/psulogoforincommon.png", 
                    "width": "130", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "70"
                  }
                ]
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIErTCCA5WgAwIBAgIJAKf39my5mM01MA0GCSqGSIb3DQEBBQUAMIHsMQswCQYD\nVQQGEwJVUzEVMBMGA1UECAwMUGVubnN5bHZhbmlhMRgwFgYDVQQHDA9Vbml2ZXJz\naXR5IFBhcmsxKjAoBgNVBAoMIVRoZSBQZW5uc3lsdmFuaWEgU3RhdGUgVW5pdmVy\nc2l0eTElMCMGA1UECwwcT3V0cmVhY2ggVGVjaG5vbG9neSBTZXJ2aWNlczEiMCAG\nA1UEAwwZbGVhcm5pbmcub3V0cmVhY2gucHN1LmVkdTE1MDMGCSqGSIb3DQEJARYm\nT1RTX0NlcnRfTm90aWZpY2F0aW9uQG91dHJlYWNoLnBzdS5lZHUwHhcNMTIwNzI2\nMTcyMTUxWhcNMjAxMjE2MTcyMTUxWjCB7DELMAkGA1UEBhMCVVMxFTATBgNVBAgM\nDFBlbm5zeWx2YW5pYTEYMBYGA1UEBwwPVW5pdmVyc2l0eSBQYXJrMSowKAYDVQQK\nDCFUaGUgUGVubnN5bHZhbmlhIFN0YXRlIFVuaXZlcnNpdHkxJTAjBgNVBAsMHE91\ndHJlYWNoIFRlY2hub2xvZ3kgU2VydmljZXMxIjAgBgNVBAMMGWxlYXJuaW5nLm91\ndHJlYWNoLnBzdS5lZHUxNTAzBgkqhkiG9w0BCQEWJk9UU19DZXJ0X05vdGlmaWNh\ndGlvbkBvdXRyZWFjaC5wc3UuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAwiF//aioR8K6piwhQtyljIw1/L9sSGhfiY2irN9I5ZAZidhGFJ66zc0I\nnuXcurPdl/7keCjgNpCXPk1W6LHUNlZT+uMGZOwXmKSVw2MdAZqRcNBJ0u88ThYS\nKLw2NPXk34IjwJLl76dJfU0HKVlWAualkZnSRz2u/O3pODU3VTCyuvSvgV2QRftk\naggB1NP7O9fxNyyKLsayI4znW76Pr6rn4Z8xlqwVnutL9/ivdqbqqtVoncwTUCwe\nJdHwe1THcYx/v7Divx95NUC05lL+ZONoX75LnYiAyFrhRFAAsSWsFAas85RzLLQA\na8tjIfDHf1CVom7pIUpaPG+OGdaR9QIDAQABo1AwTjAdBgNVHQ4EFgQUFO8ugKdy\nn/CxkGD7882/sISq/KgwHwYDVR0jBBgwFoAUFO8ugKdyn/CxkGD7882/sISq/Kgw\nDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEACCqYA8QbfkMIdZkUTmUS\nppXNK7jz1IeMx+sc7rcNnNgusGzbZxwdsQJOPDt6TUxrfD9nTFjfYbLyXsCeR0ZP\nGdYD0nJCYSXSxnbQ/2X0tLuQjdzMJKyQGYxrvnVpG58tk2XQ7HyWyVSW57FaMams\nlQvKntMBRcGQowD6O08cbFmky1viVLlvNuSvQFchA4+1V0lRZyWzrGVuOAuP9Hbv\nrqj3rsPXlJQLVvGISTspolkrzWA4o4Ou1xfPqV43e3c2kjFbA3wKzpvlC4knbrUV\nLCCXJ3dFWsDAVuMrGEcNKNzvpKYnduEPb8vS1J0oBtPAGsAwbykJbgVgfyipHgFe\npg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://learning.outreach.psu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://learning.outreach.psu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://learning.outreach.psu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://learning.outreach.psu.edu/Shibboleth.sso/SAML2/ECP"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ucsd.quacademicworks.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Academic Works, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Academic Works, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.academicworks.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ucsd.quacademicworks.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@academicworks.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ucsd.quacademicworks.com/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "AcademicWorks - University of California, San Diego - QA", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC+jCCAeKgAwIBAgIJAMGf/Z3lHFg0MA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTEWFjYWRlbWljd29ya3MuY29tMB4XDTEyMDYyOTE3MDQwOFoXDTIyMDYyNzE3\nMDQwOFowHDEaMBgGA1UEAxMRYWNhZGVtaWN3b3Jrcy5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDuYwsDHjNntNy9/gEmt4/Zzq9W2T9XSY2IhXEO\n2K7DhYsf7ipSJxtODdtj3oVXP9A5Lf5nkHrVokcQ1HGoCkBgWRmKLNgNRWA4VUJD\naefGvJEgtpkPCORbnByv0V5LjaoRad6T/TLx3BRUbwMrQ/1RevTy5Wv/UZIboTe0\n25URP5lA4L9cna5OjLFMhHqvKUz3jzjmEiZrCtAzDZyqjO4m5OAC5FjGp3589hzB\nqqLkKMX3PJFv6yRkHPBHkRYbKHOVkXJMq+X9ZqeZoMT34HuIu25R5wFIr63EZkCn\nwJK7HyRNtLsIG794+NRymYRI5/f80ot/Co0BAgCnSPk1tpQfAgMBAAGjPzA9MBwG\nA1UdEQQVMBOCEWFjYWRlbWljd29ya3MuY29tMB0GA1UdDgQWBBRSqmxPIcFhLYnt\ndyeB2veb8C4tHjANBgkqhkiG9w0BAQUFAAOCAQEAtnafORhycsB9oWtDuq1GeU7B\n846Jp/XECYMUMeSYQHHeZAZu7K4IPe7tkMSiruOh4gUpt/Tgz7+F0PMEVuSQhTp/\nwBIQMGdI76e9wmEuhAW+HgIdbXWpfAWvG1XqqsG5s+wkZk2TqaY/3xbvKCXgEoQc\nVRiuPjlnZ5KHUSqDIaL1ZzOGF08//NqjhZd8DabVH8v9DOl+yhjGak2ghXDLBuM+\n7YWBPI/1J6quTZKblfobKV2BRQOSl5gHL668yefesaVYDvuAkSQmjItqMcg81agd\n0JEu6ZVvx2kM4UhNJKNe2SRdAi7GzJeyG+9ePc+eR1dkmSyFSWP7pbMfHNG3xQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "AcademicWorks - University of California, San Diego - QA", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:stonybrook.edu", 
    {
      "entity_id": "urn:mace:incommon:stonybrook.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "error_url": "https://sso.cc.stonybrook.edu/idp/error.html", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sso.cc.stonybrook.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sso.cc.stonybrook.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sso.cc.stonybrook.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://sso.cc.stonybrook.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "stonybrook.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAiigAwIBAgIVAM6zo1Tg/Cni0U1ZiS9qUjHwTb0qMA0GCSqGSIb3DQEB\nBQUAMCAxHjAcBgNVBAMTFXNzby5jYy5zdG9ueWJyb29rLmVkdTAeFw0xMjAzMzAy\nMTI4MTBaFw0zMjAzMzAyMTI4MTBaMCAxHjAcBgNVBAMTFXNzby5jYy5zdG9ueWJy\nb29rLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIZH1YAL8Nsb\nZP7r1ZCfT0iXKNeVMUoes4lotQGna8lfAkwbBAOIi8z6Ck1pHtTwZBnRf0HalU2r\n+INFd/U2MQMUl63YrdhjXwkM7LepxMqj1nBRRS7W1qnS4B9N1Gx8h4RwaYVlW7YR\nEFSZjuqVTz3aJqr4IY6OjxHlXKCYy9q0x2QGgJm7z0/0K0K1w1LymoL8smE+7X4T\nfoEKIZohNHxTPoM8tLU3XZhuMQL8TAtbUIz18+gyq0ug8Nf5mXkBPDSIQ92VWTKN\nCbFuu1meG18OXGNQwDsjj3D6WzoV8/h7wsVhf1tyBXfJ6GFfkhdJPJZTCgJzsGEk\nwVmSKNwTwzkCAwEAAaNxMG8wTgYDVR0RBEcwRYIVc3NvLmNjLnN0b255YnJvb2su\nZWR1hixodHRwczovL3Nzby5jYy5zdG9ueWJyb29rLmVkdS9pZHAvc2hpYmJvbGV0\naDAdBgNVHQ4EFgQUoH3ycV3oftfj3WFA33xtpoaRyUYwDQYJKoZIhvcNAQEFBQAD\nggEBAE2vfQbGmZWnFMWylYeLqj7lvX5P1Se9i8DBJjy3tdCTIHdHTSRPLnnroFEb\nAu55cnXU3SeJ4jzHj3k4tOXQQfE+BGER47DtPuJ5Ey2Ug33DCrMoP0yjpwp3uTcy\nNRSzJT6FikcvJbGxzswA6chGOHWtGwe4dq+5Om0q8QQsQMX5o3TUrkL/9e4cSyHV\nbeoZeLMhDf4M7wf971qx6tV+qVQqqSdDbQOPx+IKKXGuHCwKXwi1V1KjmYFqnOm6\nvjLJq/ZYknekwIgXDYdL99d5kwqV6W7vHm5V7j2fv0o+mNu46sL9Y+TVZPAnyw8b\nP5kJpNl6SkvUOjZ4nvr9i9FgmHc=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sso.cc.stonybrook.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sso.cc.stonybrook.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category-support"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "stonybrook.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAiigAwIBAgIVAM6zo1Tg/Cni0U1ZiS9qUjHwTb0qMA0GCSqGSIb3DQEB\nBQUAMCAxHjAcBgNVBAMTFXNzby5jYy5zdG9ueWJyb29rLmVkdTAeFw0xMjAzMzAy\nMTI4MTBaFw0zMjAzMzAyMTI4MTBaMCAxHjAcBgNVBAMTFXNzby5jYy5zdG9ueWJy\nb29rLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIZH1YAL8Nsb\nZP7r1ZCfT0iXKNeVMUoes4lotQGna8lfAkwbBAOIi8z6Ck1pHtTwZBnRf0HalU2r\n+INFd/U2MQMUl63YrdhjXwkM7LepxMqj1nBRRS7W1qnS4B9N1Gx8h4RwaYVlW7YR\nEFSZjuqVTz3aJqr4IY6OjxHlXKCYy9q0x2QGgJm7z0/0K0K1w1LymoL8smE+7X4T\nfoEKIZohNHxTPoM8tLU3XZhuMQL8TAtbUIz18+gyq0ug8Nf5mXkBPDSIQ92VWTKN\nCbFuu1meG18OXGNQwDsjj3D6WzoV8/h7wsVhf1tyBXfJ6GFfkhdJPJZTCgJzsGEk\nwVmSKNwTwzkCAwEAAaNxMG8wTgYDVR0RBEcwRYIVc3NvLmNjLnN0b255YnJvb2su\nZWR1hixodHRwczovL3Nzby5jYy5zdG9ueWJyb29rLmVkdS9pZHAvc2hpYmJvbGV0\naDAdBgNVHQ4EFgQUoH3ycV3oftfj3WFA33xtpoaRyUYwDQYJKoZIhvcNAQEFBQAD\nggEBAE2vfQbGmZWnFMWylYeLqj7lvX5P1Se9i8DBJjy3tdCTIHdHTSRPLnnroFEb\nAu55cnXU3SeJ4jzHj3k4tOXQQfE+BGER47DtPuJ5Ey2Ug33DCrMoP0yjpwp3uTcy\nNRSzJT6FikcvJbGxzswA6chGOHWtGwe4dq+5Om0q8QQsQMX5o3TUrkL/9e4cSyHV\nbeoZeLMhDf4M7wf971qx6tV+qVQqqSdDbQOPx+IKKXGuHCwKXwi1V1KjmYFqnOm6\nvjLJq/ZYknekwIgXDYdL99d5kwqV6W7vHm5V7j2fv0o+mNu46sL9Y+TVZPAnyw8b\nP5kJpNl6SkvUOjZ4nvr9i9FgmHc=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://sso.cc.stonybrook.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://sso.cc.stonybrook.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Stony Brook University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Stony Brook University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.sunysb.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Sanjay Kapur", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Sanjay.Kapur@stonybrook.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Brian Heller", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Brian.Heller@stonybrook.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shib.fortlewis.edu/idp/shibboleth", 
    {
      "entity_id": "https://shib.fortlewis.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.fortlewis.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.fortlewis.edu/idp/profile/Shibboleth/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.fortlewis.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "fortlewis.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDNDCCAhygAwIBAgIVAKAwA2GeOWnox0HE2Cs9vOZ+vGNlMA0GCSqGSIb3DQEB\nBQUAMB0xGzAZBgNVBAMTEnNoaWIuZm9ydGxld2lzLmVkdTAeFw0xMzA4MTYxMzMz\nMzVaFw0yODA4MTYxMzMzMzVaMB0xGzAZBgNVBAMTEnNoaWIuZm9ydGxld2lzLmVk\ndTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIU0/7DIXyuOPF2Wl2Rh\nvSS6WlMwwqq3lSYCzbbuvW958k4Qm18KtqnnEBVvnxj9kOzMJqH1MSwjpKU41J88\nsGlQIdy0Os6DxQXY09NnhNRInSjbgCnw17UEniXUqJpg8IYFebwMkX1UfpqULO8y\nKWv5tB80M4dhvcLswHHBmngRsgSHopN393i/vo/mnjQ6uFDyoZtv4nIn8GP1zaV4\nc2w9QqNa3JoSgAZWDdxfU3Xzu4l0XMzVE3TsI4V6nxVg3K6blTOGIG5qSFevgTFh\nqzqDlIxn2Da9wjEME74ISGPxWbs96zdL7Y5O5LrwySXYyfoXgAmuF7ZGtYe/rlsG\nB8cCAwEAAaNrMGkwSAYDVR0RBEEwP4ISc2hpYi5mb3J0bGV3aXMuZWR1hilodHRw\nczovL3NoaWIuZm9ydGxld2lzLmVkdS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQU\nBYK1Me0MowhhHsiQq//A36KfbJIwDQYJKoZIhvcNAQEFBQADggEBADGo3/7fy+eD\n/iXi2AhSVIHG5vCDL3Mg1hqTMc2A1u9qjVFsLg89zu05QuhgqXldFqW5BY5foJaa\nbvVlQx/2qcbYXiBWLqKwORXDLzoHXaWO2Ipl4zZgehf4PpE3+uZqzdz7zCjJUdMA\nvhm6RvQmet50R0UfTj7VqjFNmjhanu//Z5kEWwrh1ynVa9270EskmcKJBfuGYYDO\nL44iLiEoDtkonZHj80wAxweX2ZKTUV3Zx1rN9izq0/7Wmcs8d7kxK/fUvSRMOLeY\naQ3ZXyJG9G28xL1x7mCjLJ8atZIXr+Y74eG0dH+02TBR8zBwIOwfRORG+2XdydG+\nZw/pUkWhDXU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFFTCCA/2gAwIBAgIRAPUWamBIK1aXyICncL6wac0wDQYJKoZIhvcNAQEFBQAw\nUTELMAkGA1UEBhMCVVMxEjAQBgNVBAoTCUludGVybmV0MjERMA8GA1UECxMISW5D\nb21tb24xGzAZBgNVBAMTEkluQ29tbW9uIFNlcnZlciBDQTAeFw0xMjEwMTcwMDAw\nMDBaFw0xMzEwMTcyMzU5NTlaMIGHMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ08x\nEDAOBgNVBAcTB0R1cmFuZ28xGzAZBgNVBAoTEkZvcnQgTGV3aXMgQ29sbGVnZTEf\nMB0GA1UECxMWSW5mb3JtYXRpb24gVGVjaG5vbG9neTEbMBkGA1UEAxMSc2hpYi5m\nb3J0bGV3aXMuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuHnY\nuLhhYF7y9qcw/IgWJBiKVku2KX9v+boiZ70rY6q2fICxRT+LnP4bYmM32zO1pYvM\n6ljizoeClyDGdfpeEx3tZGTv1BklifTcwlOVPGFGCY1MBbEzdrQpAkGXzUIfz2Lv\nmtfS+AzXiJo7j9dBxhHEnGCLAbZ5ESGmxeqc3famc+sF7PyVNoxj8wZTbE3HMemZ\nBPmgZg6I5yHxUgyCVTKCPveyHdkfuCs5ZFeZ4Sf2BQJrhpquGLyW7CotDh1TBZhk\nyXVpK1+eftzF2hor4FFno+hp4cr+N+vOdkcmBFZ09RymsDTbHpS7me4OAfZsd58G\n/vmgaTuy99fNQTHFRQIDAQABo4IBrzCCAaswHwYDVR0jBBgwFoAUSE9a+i9Kml7g\nUPNre1Wl3vW+NF0wHQYDVR0OBBYEFFoDrA7HuCnwCVx1peQzV9Z/q28mMA4GA1Ud\nDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggr\nBgEFBQcDAjBdBgNVHSAEVjBUMFIGDCsGAQQBriMBBAMBATBCMEAGCCsGAQUFBwIB\nFjRodHRwczovL3d3dy5pbmNvbW1vbi5vcmcvY2VydC9yZXBvc2l0b3J5L2Nwc19z\nc2wucGRmMD0GA1UdHwQ2MDQwMqAwoC6GLGh0dHA6Ly9jcmwuaW5jb21tb24ub3Jn\nL0luQ29tbW9uU2VydmVyQ0EuY3JsMG8GCCsGAQUFBwEBBGMwYTA5BggrBgEFBQcw\nAoYtaHR0cDovL2NlcnQuaW5jb21tb24ub3JnL0luQ29tbW9uU2VydmVyQ0EuY3J0\nMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5pbmNvbW1vbi5vcmcwHQYDVR0RBBYw\nFIISc2hpYi5mb3J0bGV3aXMuZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQAs002TnY7Z\nhyavh81tlkKJf70Dw5MIYaZKEh96nXxX2/7oGnq97s4Bp5ySuY1ys+K7X43Y9mpk\ngT9lm3R/OvGRiANHETfIkZyLOWFbFtELBEpYGlrFpt4q8n0/6+x2+l3JAAkBSlpg\n/rddXNkoefgVAEz+u9C0HKj3fsruXqYBHbIfW9Rf66lQyEp01+QZJlyKIedNFzBL\nVTadJwCCueFoLeybzutNJ4IOELLDRvFcea2IY9C+c31MowYoa+hV75HqXGpgnvGU\nT7QYiZ2Vq8KFk/pYWOQfBPkGVcosrLHHv7I3n8BsdY2I/hcCluZah/E9hNo6nXgC\nCl7+smoK7FL0", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.fortlewis.edu/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.fortlewis.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Fort Lewis College", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Fort Lewis College", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://explore.fortlewis.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "James Bodine", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bodine_j@fortlewis.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Gary Maxwell", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "maxwell_g@fortlewis.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Gary Maxwell", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "maxwell_g@fortlewis.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://auth.unomaha.edu/idp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Nebraska at Omaha", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Nebraska at Omaha", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.unomaha.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://auth.unomaha.edu/idp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "contact_person": [
        {
          "given_name": {
            "text": "Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "unohelpdesk@unomaha.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://auth.unomaha.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://auth.unomaha.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://auth.unomaha.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://auth.unomaha.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unomaha.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://auth.unomaha.edu/html/icon_uno-clr-lrg.png", 
                    "width": "101", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "75"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "University of Nebraska at Omaha", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "IDP for the University of Nebraska Omaha.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLDCCAhSgAwIBAgIVAIsrTZg+xPjnDMlVwxM9j6NGfV7NMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEGF1dGgudW5vbWFoYS5lZHUwHhcNMTMwMTMwMjAzNDE2\nWhcNMzMwMTMwMjAzNDE2WjAbMRkwFwYDVQQDExBhdXRoLnVub21haGEuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuCNfABIJwCrk0t6KjSvEwPEk\ndBtOt0YNBboi9ugoHr8xOxnDeYqy0Wo/N9/ugrkZy/ddw9TVG2QxtNUKLCrF9N9k\n2ZPWU0ME2eO1xJKIejo8EgtXby9lX6UjGX1i+UKpBqTI0z726WNVkOMZKsCMGEVR\nT0FD2KfGzw0MSJymv0Tk7pSw4rw68OlHxpI7w8ZsqWGyFg9bDDjzpgHjg+yQJGfr\noGaBG/S8ej+OLApNf0h5yvOwPwgs1HB1Ga4fu/dnNBmqwnRJ74z3yqsme1hzleyH\nk9NolQV/q2UkGIt55JqQRatftmvyeyUEh3wKXr3qY5BsIuupD6lpRnBrsKf3ywID\nAQABo2cwZTBEBgNVHREEPTA7ghBhdXRoLnVub21haGEuZWR1hidodHRwczovL2F1\ndGgudW5vbWFoYS5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFEBBD69+gK37\nKhGD1aceEkFoIMb+MA0GCSqGSIb3DQEBBQUAA4IBAQCwdlAxULDWyaIUv79253oD\n+mkWSFLF4wxW4iK9TTa2miQ0TSYVyzhaXp97aPxRfx5HRXUHYTnP1s8BEkt38I3m\na9igf9Xl9BTXFl2mjfW3IkHz3i1muQfeaO776QhdoSIMopN0hDsI0dYjXzzay4nY\nKsalIUYcr+E9BfbFa1Y6+wpJXCJPwUK/LMLCI6W9VpVXEJimNtXKg5fRv7/VDKsn\n4W0gTtvxHuZ8B0zQkh9lkqxHI/ZC3GxP6S5hKbAXrHDyHgoRPi4vYhV7G0ijoB7X\nib4AhuWoU4qWPEElH/diNgvMNv0LNXH3A9NBC1womRbTB+OS9nfKsMEfR8Qy3V2p", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://auth.unomaha.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://auth.unomaha.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibidp.syr.edu/idp/shibboleth", 
    {
      "entity_id": "https://shibidp.syr.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.syr.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.syr.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.syr.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibidp.syr.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "syr.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Syracuse University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDJzCCAg+gAwIBAgIUVVcomBH8KzJQ9YGnfZRbSd7sVU4wDQYJKoZIhvcNAQEF\nBQAwGjEYMBYGA1UEAxMPc2hpYmlkcC5zeXIuZWR1MB4XDTEzMDMyNjEyMDMwM1oX\nDTMzMDMyNjEyMDMwM1owGjEYMBYGA1UEAxMPc2hpYmlkcC5zeXIuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnXRD/fcJFieSaqGw8BVPDNtxCf8R\nj+g8VCkN5fD8bMpFo/aPBoxMAsHstvsdxUZVNy66rarz63Yo79lgCG66APGIx0TK\nUFfFTKx/rWHWfMn2k4/mJydQrxElJfGmiJySXZcqprLIjLxk+kfhH24I4eewnuq5\nilgdx9PXl0ZVzOg3klOQKV4xvlgmSpUcuY18ziA5NO9CH+uaXg4rj4poqNu/w58O\njweoQALZiissFa1W6aIiwJswq/XIbTLcxSWc+QhcOIq7c8eAbKRL7i51sZMAYFOd\ngjlAHw8UcSkm9ibah6p3lFYgHbVQ98f5+fQGhJcHbmjaqr1cOj4Mm1weCwIDAQAB\no2UwYzBCBgNVHREEOzA5gg9zaGliaWRwLnN5ci5lZHWGJmh0dHBzOi8vc2hpYmlk\ncC5zeXIuZWR1L2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBRfOAeHe266XIh5TjMW\nVrQ7WVWzvDANBgkqhkiG9w0BAQUFAAOCAQEAOBXMtSTx1Q9DRC8jU5AJX4tB7XML\nGynS/IT2cxHtRHt5bpukveikqh+vokQf3Vq09pUk8HMXqBvdhPIhIt4wTFapdQwy\nrcuH6S22woObDp/piQegOJ85tZO/0vq6oMfwU03o6y9wcZAKpQp+2uWIaVJszXWs\nTRgUSKBwLA0z3ual+MQ5FDr+flqoThn4OFHxXxjyp4MBd2o5eyMGyCiZ0JH+s0Hc\n5WVUMo7am2UIynA+j+rhpm5rQhTXjkEA1lTHtqDOnALwKzGsXh5trle0tBcs1B1M\n2fzviLyo4jkmqs5KbWl2c5jut2uUl8jmJ6588cy0BHKiiJOwd/+bFTJF8Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibidp.syr.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibidp.syr.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "syr.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDJzCCAg+gAwIBAgIUVVcomBH8KzJQ9YGnfZRbSd7sVU4wDQYJKoZIhvcNAQEF\nBQAwGjEYMBYGA1UEAxMPc2hpYmlkcC5zeXIuZWR1MB4XDTEzMDMyNjEyMDMwM1oX\nDTMzMDMyNjEyMDMwM1owGjEYMBYGA1UEAxMPc2hpYmlkcC5zeXIuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnXRD/fcJFieSaqGw8BVPDNtxCf8R\nj+g8VCkN5fD8bMpFo/aPBoxMAsHstvsdxUZVNy66rarz63Yo79lgCG66APGIx0TK\nUFfFTKx/rWHWfMn2k4/mJydQrxElJfGmiJySXZcqprLIjLxk+kfhH24I4eewnuq5\nilgdx9PXl0ZVzOg3klOQKV4xvlgmSpUcuY18ziA5NO9CH+uaXg4rj4poqNu/w58O\njweoQALZiissFa1W6aIiwJswq/XIbTLcxSWc+QhcOIq7c8eAbKRL7i51sZMAYFOd\ngjlAHw8UcSkm9ibah6p3lFYgHbVQ98f5+fQGhJcHbmjaqr1cOj4Mm1weCwIDAQAB\no2UwYzBCBgNVHREEOzA5gg9zaGliaWRwLnN5ci5lZHWGJmh0dHBzOi8vc2hpYmlk\ncC5zeXIuZWR1L2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBRfOAeHe266XIh5TjMW\nVrQ7WVWzvDANBgkqhkiG9w0BAQUFAAOCAQEAOBXMtSTx1Q9DRC8jU5AJX4tB7XML\nGynS/IT2cxHtRHt5bpukveikqh+vokQf3Vq09pUk8HMXqBvdhPIhIt4wTFapdQwy\nrcuH6S22woObDp/piQegOJ85tZO/0vq6oMfwU03o6y9wcZAKpQp+2uWIaVJszXWs\nTRgUSKBwLA0z3ual+MQ5FDr+flqoThn4OFHxXxjyp4MBd2o5eyMGyCiZ0JH+s0Hc\n5WVUMo7am2UIynA+j+rhpm5rQhTXjkEA1lTHtqDOnALwKzGsXh5trle0tBcs1B1M\n2fzviLyo4jkmqs5KbWl2c5jut2uUl8jmJ6588cy0BHKiiJOwd/+bFTJF8Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibidp.syr.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibidp.syr.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Syracuse University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Syracuse University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.syr.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Cynthia Hoalcraft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "clhoalcr@syr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Steve Leonard", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sleonard@syr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Kelly Fallon", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kjfallon@syr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.weber.edu/idp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Weber State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Weber State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.weber.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://idp.weber.edu/idp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jonathan Karras", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jonathankarras@weber.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Systems Admin Services", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sysadmin@weber.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Information Security Office", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "contact_type": "other", 
          "email_address": [
            {
              "text": "security@weber.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }, 
        {
          "given_name": {
            "text": "IT Service Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "csupport@weber.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Nate Henne", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "natehenne@weber.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib.weber.edu/simplesaml/saml2/idp/SingleLogoutService.php?ReturnTo=https%3A%2F%2Fcas.weber.edu%2Flogout"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.weber.edu/simplesaml/saml2/idp/SSOService.php"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.weber.edu/simplesaml/saml2/idp/SSOService.php"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "weber.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.weber.edu/images/WSU_Logo.png", 
                    "width": "238", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "122"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://weber.edu", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Weber State University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDyTCCArGgAwIBAgIJAKivSalalUbnMA0GCSqGSIb3DQEBBQUAMHsxCzAJBgNV\nBAYTAlVTMQ0wCwYDVQQIDARVdGFoMQ4wDAYDVQQHDAVPZ2RlbjEfMB0GA1UECgwW\nV2ViZXIgU3RhdGUgVW5pdmVyc2l0eTELMAkGA1UECwwCSVQxHzAdBgNVBAMMFldl\nYmVyIFN0YXRlIFVuaXZlcnNpdHkwHhcNMTIwNjE4MTc0MjQxWhcNMjIwNjE4MTc0\nMjQxWjB7MQswCQYDVQQGEwJVUzENMAsGA1UECAwEVXRhaDEOMAwGA1UEBwwFT2dk\nZW4xHzAdBgNVBAoMFldlYmVyIFN0YXRlIFVuaXZlcnNpdHkxCzAJBgNVBAsMAklU\nMR8wHQYDVQQDDBZXZWJlciBTdGF0ZSBVbml2ZXJzaXR5MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEA2IopzhBf7c7xCkBOC+JyEq3RmLDtqGJstrUjhsuw\nszaejXvo5wpU3HnO5hIIiHGCB5eLxO9DPZyrCwwn8TeJdyWBw5Zt44DqXzSTXTcf\nBCfxW05QFd1Js3ptREmybgWOmGQgHasUxkyydiPdIdc7ShJJQKY9vgPhTl2p2jrQ\nhpCuie/d9W5sOIPIZAbMfsbW37/AJ7+kCplXwiqxvf+Z/LOCWOB4umT+iHoJYcr9\n5xfi6U0ROzQcaSA0j6a4sGXvS7EgjvaV9jBlBOH0f1/Vmxwq0T/EcDhI67bpT7FN\ndB0tBkonbzUyaQ1eUqW8MD05orP522dzSajXOrSffzItyQIDAQABo1AwTjAdBgNV\nHQ4EFgQUPYFzS5aVRNPzrwImKoJtAeZSQuowHwYDVR0jBBgwFoAUPYFzS5aVRNPz\nrwImKoJtAeZSQuowDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAhaM8\nsGQpkRJj++aFyDimwh5wgmUEtG4wNSiYW+p2Ze+11/k5zefB/Cg9J2n66R9OCJ99\n/yOBsW/bUGGYudv9xAkFoS5Mlm6kVufsjf+/WdogNPv/e+7s4sDK3MS1vu+Mem1W\nm2CwXIRO/y2sqscc84jUV1ESDjjdPsbDYkZTIn0dIEv8QnMFd+DS1Kl/GbH7pF6w\nRTysR81FEkGE/ftL3niiQere3dkZrwTHIBd5wZuLC8dPunxJxGLM6MGytRdThHnD\nS1S10oATr9bZgNj8WEiw7DWG5sHb79+04Sg6gwheKEoHGHupShONIm+JAGHx6sxP\nEeS6iOJIgvPUd0c4sA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://scalepriv.ece.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://scalepriv.ece.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Lujo Bauer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lbauer@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Elli Fragkaki", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "efragkak@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Christian Bravo-Lillo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cbravoli@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "CMU CyLab research project", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDBjCCAe6gAwIBAgIJAMH3/CJytohfMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXNjYWxlcHJpdi5lY2UuY211LmVkdTAeFw0xMjEwMjYxNTAyMTJaFw0yMjEw\nMjQxNTAyMTJaMCAxHjAcBgNVBAMTFXNjYWxlcHJpdi5lY2UuY211LmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMyNPxItAtqdKXuwUL+Yk46+pNLB\nI6MecUEhYcqSIYPiXR7Yr3SmmTuGsbb3jWAjJO0jNvu5xwFepldjRTyTEAbMJwiX\nEXHVnRdCeAjX3GHIdJpjP799mqYqpDftKW6BrZEP/KGZqy4WDfXTfUzt3ujOTkgS\nNkUsHzAt9RsYz1s9A+MVFJoVR7LJbBm0p8Qp+iX5YSwVU+yUgYOiERpDH++e8gPw\n5/Pp8RHeQfEXLLjNm1wqjqb8gWWiypbuWtFCYtpc6lrndMyyio4J7I2Jeacms6zb\nv5UEFsZBPfn9Gz7FbfS/vAOw290y58g9MCoQdv7oio91mR8IrMCPL8G6EN0CAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVc2NhbGVwcml2LmVjZS5jbXUuZWR1MB0GA1UdDgQW\nBBRnC4i+nUm1TbvK1VZ0lcR3eNA7KDANBgkqhkiG9w0BAQUFAAOCAQEAlyw6fz/f\nX7EVgE7XTg/AKQ8yYUzDnVqhs+S7rlroj+95N2w9rKC3JJjXWwvTfTdrHyimdTtD\nkjGzZZTChxYI8PmBMyRd7j6OaIJl5+2Ygz/U399/h1qoyVLnv9pFWM4ZkSzfwAjf\nc1i+cMKrRYqUpV1Wn3ERAmQSGQaEpI+ZMNUXQ9QWO3l+biAlrPbRtGbUpCQK9ES4\nvgQOghrrVLwOEvI9wigi/G8wWfkPCCpkgTRhhByWFtpAIMF6AgYj89tWXJyTDMW1\nUTrIAdhcm2twP56N6k0BtpCBiwKcSInl9kboB0fwaBgnPb+aVWhM197p9nzfeuAf\nxHzEVF67xqDKgQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://scalepriv.ece.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://spsaml2inc.clemson.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://spsaml2inc.clemson.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Kathy E. Wright", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kewrig@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Hugh Barron Johnson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hbj@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://spsaml2inc.clemson.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "spsaml2inc lab machine", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "RHEL 5.8", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDCTCCAfGgAwIBAgIJAPdDsi8vmB6/MA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFnNwc2FtbDJpbmMuY2xlbXNvbi5lZHUwHhcNMTMwNjEzMTgzMjMzWhcNMjMw\nNjExMTgzMjMzWjAhMR8wHQYDVQQDExZzcHNhbWwyaW5jLmNsZW1zb24uZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0G/ckJNvcuwgsPlo3AWyYcsE\nwU8g/3koKAOSkHZfCZbDcnErZXvFTyrI6c6Hp/SAoVPzlyCuGRCnypimWQxW+yRR\nwihCqYjAxJFMHM/xRNl4gxbbm/FuK7fuFq/d7sZqQb9lpwg2G4omNRQJZCUsuVdc\nfk/NqVqWi8mcxWJybL6Nf/hJ5Pf+5nNMEeZt/cOh9zGpHloCLp3ntLCD0TyfhN3b\nz31FDZ5Mz//YLA75qnW7KPmwbuRhBtvtvtPP4/3iSiu2I3yYkSexTsDyMSJsAs8P\nftMe33CYeLpDmvbbi5Wca+fZKuS8H+AmVhBaUFUVXtdv3nlRpRwRmRHDbUzSQQID\nAQABo0QwQjAhBgNVHREEGjAYghZzcHNhbWwyaW5jLmNsZW1zb24uZWR1MB0GA1Ud\nDgQWBBQJl6X1302XsCu3A1C7UiMQ0LQSxDANBgkqhkiG9w0BAQUFAAOCAQEAfmj7\nK+KWUavt/hG5a/QT6NpvFOtlKpScrjINfhTPPfqwq4yCwf/Il/30CMqF3nyKQknl\nvyeFkhsKrDSq9dYpPGscD+ys/J4tkCAxwqmqAFMFGB097/1JI+SEfoJDolJHJTDu\nBZojNaq/Qt83E26uFq9CsADitAWQz2Od+cdG2FJJ9EUiDnPkASELcfrwxaDo53ef\nJqg3wKNgmNhEOYrB4EaBWt6pEvNvofODDXRRVK08R+PBL7ZgcRp/sDVPGVWZ3VVH\ngjYxXMK5wy5wtBSjQ74LsJ/anoI06Jw4NAniDyrlVVv3Z8Bf0B+KIO/bHOhZzmBR\nOjcnvliXkDQ6gb52FA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "RHEL 5.8", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonAffiliation"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "spsaml2inc lab machine", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://idp2.unr.edu/idp/shibboleth", 
    {
      "entity_id": "https://idp2.unr.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "error_url": "https://idp2.unr.edu/idp/error.jsp", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.unr.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.unr.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.unr.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.unr.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unr.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "University of Nevada, Reno", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Founded in 1874 as the Silver State's first university, Nevada is a top-caliber, land-grant research university.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.unr.edu", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.unr.edu/general-information/privacy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://idp2.unr.edu/idp/images/unr-n-400.png", 
                    "width": "400", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "134"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIUZomFfy8uFN6CwFWctxZCqJsnTOMwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwMi51bnIuZWR1MB4XDTEyMDgwNzIwMjIwMloXDTMy\nMDgwNzIwMjIwMlowFzEVMBMGA1UEAxMMaWRwMi51bnIuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlmErn3kjyaTMwkLdG3GWkOfWViznKyQxsjgJ\nZ1fJzKv14wkoqIx5n5V6jJRDfc0sPb4lPos+tG/mkL4cvG2HX9Kmhpx6PnaQEaye\nBYx46pVdrC2vh5j76kjkqXLeMxVFUYqN/JLZ0rYuxpZIu7S+IezQlvMqWoBBfFKx\nz9W2iguf6+56rWBy4ANyH8vIprdfFduqjWShbepkAlIlM7yGhK7IrTXlOJa6ze6T\nGXQt7Gj5H7trRp1Q/lEwi8SrRs+FJdvetg+yjDdudd5W2qpcC6mmGol+s1QfE10l\nJZ0jcpb29xol5F0DraVU/xG/jHO36aYlaAQ2be2a/6Ex3WWpFQIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAyLnVuci5lZHWGI2h0dHBzOi8vaWRwMi51bnIuZWR1L2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBS85y3csRWrHW4YpqpK+zaxrwOUJzANBgkq\nhkiG9w0BAQUFAAOCAQEACAwu+lFf2Z2JxArjTrDUJSbdCNcUY+4wFusrGR6IhZ3W\nPRe5k/rkH8b0AaFoJ03X2r2tomrUd5Z5sP7U0D3nFZ7RdmQ5c4QQepoSk99sZwCT\nauKFbgU6Ck+nrc62ddGfmp6RZklpvmSslFMntBiNp/7HnKvnp3OX/ToXWsdUvhZf\nUzg3mamGpm5ZLIPMryydAMbYJLvwV8XIbP9fZJAn0d0LflznI5FwecrK5Kz3jAbe\nX9jQS0IfHMVsLIV5TQJbluxByKvrBHFQWXAQVuv1r2QsZD6hx4nQo/SFSz5xGhR+\n85F/oeNtrAXqZplexfbC3eBZMWCs2AEhhC9fLI4w3A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.unr.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.unr.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unr.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIUZomFfy8uFN6CwFWctxZCqJsnTOMwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwMi51bnIuZWR1MB4XDTEyMDgwNzIwMjIwMloXDTMy\nMDgwNzIwMjIwMlowFzEVMBMGA1UEAxMMaWRwMi51bnIuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAlmErn3kjyaTMwkLdG3GWkOfWViznKyQxsjgJ\nZ1fJzKv14wkoqIx5n5V6jJRDfc0sPb4lPos+tG/mkL4cvG2HX9Kmhpx6PnaQEaye\nBYx46pVdrC2vh5j76kjkqXLeMxVFUYqN/JLZ0rYuxpZIu7S+IezQlvMqWoBBfFKx\nz9W2iguf6+56rWBy4ANyH8vIprdfFduqjWShbepkAlIlM7yGhK7IrTXlOJa6ze6T\nGXQt7Gj5H7trRp1Q/lEwi8SrRs+FJdvetg+yjDdudd5W2qpcC6mmGol+s1QfE10l\nJZ0jcpb29xol5F0DraVU/xG/jHO36aYlaAQ2be2a/6Ex3WWpFQIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAyLnVuci5lZHWGI2h0dHBzOi8vaWRwMi51bnIuZWR1L2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBS85y3csRWrHW4YpqpK+zaxrwOUJzANBgkq\nhkiG9w0BAQUFAAOCAQEACAwu+lFf2Z2JxArjTrDUJSbdCNcUY+4wFusrGR6IhZ3W\nPRe5k/rkH8b0AaFoJ03X2r2tomrUd5Z5sP7U0D3nFZ7RdmQ5c4QQepoSk99sZwCT\nauKFbgU6Ck+nrc62ddGfmp6RZklpvmSslFMntBiNp/7HnKvnp3OX/ToXWsdUvhZf\nUzg3mamGpm5ZLIPMryydAMbYJLvwV8XIbP9fZJAn0d0LflznI5FwecrK5Kz3jAbe\nX9jQS0IfHMVsLIV5TQJbluxByKvrBHFQWXAQVuv1r2QsZD6hx4nQo/SFSz5xGhR+\n85F/oeNtrAXqZplexfbC3eBZMWCs2AEhhC9fLI4w3A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.unr.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.unr.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Nevada, Reno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Nevada, Reno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.unr.edu/content/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Derek Eiler", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "derek@unr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Jeff Springer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jeffs@unr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Derek Eiler", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "derek@unr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Joshua Hegie", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jhegie@unr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "University of Nevada, Reno Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "help@unr.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://stanford.quacademicworks.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Academic Works, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Academic Works, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.academicworks.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://stanford.quacademicworks.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@academicworks.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://stanford.quacademicworks.com/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "AcademicWorks - Standford University - QA", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC+jCCAeKgAwIBAgIJAMGf/Z3lHFg0MA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTEWFjYWRlbWljd29ya3MuY29tMB4XDTEyMDYyOTE3MDQwOFoXDTIyMDYyNzE3\nMDQwOFowHDEaMBgGA1UEAxMRYWNhZGVtaWN3b3Jrcy5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDuYwsDHjNntNy9/gEmt4/Zzq9W2T9XSY2IhXEO\n2K7DhYsf7ipSJxtODdtj3oVXP9A5Lf5nkHrVokcQ1HGoCkBgWRmKLNgNRWA4VUJD\naefGvJEgtpkPCORbnByv0V5LjaoRad6T/TLx3BRUbwMrQ/1RevTy5Wv/UZIboTe0\n25URP5lA4L9cna5OjLFMhHqvKUz3jzjmEiZrCtAzDZyqjO4m5OAC5FjGp3589hzB\nqqLkKMX3PJFv6yRkHPBHkRYbKHOVkXJMq+X9ZqeZoMT34HuIu25R5wFIr63EZkCn\nwJK7HyRNtLsIG794+NRymYRI5/f80ot/Co0BAgCnSPk1tpQfAgMBAAGjPzA9MBwG\nA1UdEQQVMBOCEWFjYWRlbWljd29ya3MuY29tMB0GA1UdDgQWBBRSqmxPIcFhLYnt\ndyeB2veb8C4tHjANBgkqhkiG9w0BAQUFAAOCAQEAtnafORhycsB9oWtDuq1GeU7B\n846Jp/XECYMUMeSYQHHeZAZu7K4IPe7tkMSiruOh4gUpt/Tgz7+F0PMEVuSQhTp/\nwBIQMGdI76e9wmEuhAW+HgIdbXWpfAWvG1XqqsG5s+wkZk2TqaY/3xbvKCXgEoQc\nVRiuPjlnZ5KHUSqDIaL1ZzOGF08//NqjhZd8DabVH8v9DOl+yhjGak2ghXDLBuM+\n7YWBPI/1J6quTZKblfobKV2BRQOSl5gHL668yefesaVYDvuAkSQmjItqMcg81agd\n0JEu6ZVvx2kM4UhNJKNe2SRdAi7GzJeyG+9ePc+eR1dkmSyFSWP7pbMfHNG3xQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stanford.quacademicworks.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stanford.quacademicworks.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stanford.quacademicworks.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stanford.quacademicworks.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stanford.quacademicworks.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stanford.quacademicworks.com/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://heinz-pool6.heinz.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://heinz-pool6.heinz.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "James Trimbee", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "trimbeej@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Heinz VCL lab", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDEjCCAfqgAwIBAgIJAIhqShd3amOwMA0GCSqGSIb3DQEBBQUAMCQxIjAgBgNV\nBAMTGWhlaW56LXBvb2w2LmhlaW56LmNtdS5lZHUwHhcNMTMwNDI2MTgyMTMyWhcN\nMjMwNDI0MTgyMTMyWjAkMSIwIAYDVQQDExloZWluei1wb29sNi5oZWluei5jbXUu\nZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqoN4J1Fr08QPawax\nIn5+uCAAWfPDFFf6ijloo8H27uul0+HM1neCIN88d8toIIS1vR3fvWRElBVmiqTS\nWwt6iFZ/JLntbevj2jsqk+/8LRNdWv7cD8fcYRfSYBfZH+AYfynx3H0gpMTqk+6K\nm7j5YCdXzyqctHrrLmiiR6QzAWQKNxCjb16Lr1APhqSLWXzF5+Sy61FiQiBjSmGh\nutRAHodjewSXWgcRImc+ql/e+HYplpIwyzCIoO5Hfat7YpDrPqF52Vp+UKcdGg4a\n23cidOEV2DvHkq21cU6Vf+nSwd+35R2RTy8ZQA8nHgw6YQlaFa0y5w1d2kIz1Gkf\n1yaLHwIDAQABo0cwRTAkBgNVHREEHTAbghloZWluei1wb29sNi5oZWluei5jbXUu\nZWR1MB0GA1UdDgQWBBSQBqh9qPFs72rsUWpAboWX/KXQWjANBgkqhkiG9w0BAQUF\nAAOCAQEAjX6jB9UYIsYA1etdW4IVSqvzor9uOOxycrdcQSRUQbRBj2cke2zeQJhh\n08fKtrXBMOZlvL1NFQogIYU7x3e8WwO4PYUUxbwDqI3t90Rrww4hj+H0mz8MkCdD\n5fEo1LB24f5XKUB2QSfKj0ddizfgfekzH5Zf54FZskJxEIArB4d8HSNu2o84lTyg\nPAKL+IMLuvigTQvc6Cr5enbDtHHYnOMzuGYzll5C4Mq1gBeAa8uGtQ2hi+3GIsOi\nbv/rGmpQ49r69g/JMj2tj4wLyH94EriU7ZnwqIV8p5oeDImLRgG5mjL5zXzj0EJ3\npCpDjs5kducsUnIv6U8rIdeDF+PLUQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://heinz-pool6.heinz.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://utdallastickets.universitytickets.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UniversityTickets", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UniversityTickets", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://universitytickets.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://utdallastickets.universitytickets.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "UniversityTickets Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@universitytickets.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utdallastickets.universitytickets.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utdallastickets.universitytickets.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utdallastickets.universitytickets.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utdtickets.universitytickets.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utdallastickets.universitytickets.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utdallastickets.universitytickets.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://utdtickets.universitytickets.com/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UT Dallas + UniversityTickets SSO", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEFzCCAv+gAwIBAgIJAOKNYZKTkGOxMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD\nVQQGEwJVUzELMAkGA1UECAwCTlkxETAPBgNVBAcMCE5ldyBZb3JrMSAwHgYDVQQK\nDBdVbml2ZXJzaXR5VGlja2V0cywgSW5jLjEiMCAGA1UEAwwZVW5pdmVyc2l0eVRp\nY2tldHMgU3VwcG9ydDEsMCoGCSqGSIb3DQEJARYdc3VwcG9ydEB1bml2ZXJzaXR5\ndGlja2V0cy5jb20wHhcNMTAwODI3MTQzNDMwWhcNMTMwODI2MTQzNDMwWjCBoTEL\nMAkGA1UEBhMCVVMxCzAJBgNVBAgMAk5ZMREwDwYDVQQHDAhOZXcgWW9yazEgMB4G\nA1UECgwXVW5pdmVyc2l0eVRpY2tldHMsIEluYy4xIjAgBgNVBAMMGVVuaXZlcnNp\ndHlUaWNrZXRzIFN1cHBvcnQxLDAqBgkqhkiG9w0BCQEWHXN1cHBvcnRAdW5pdmVy\nc2l0eXRpY2tldHMuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\ntuDuyswVfkWKroBS9oOpm2QqRJecNIyZ7DMf9m7jwFFaQiPN3NYTe9C35I3rsmqp\nUvSK075z34uNrBddsz29CnVurUv6geM+mBUZB11oFG6rGxuT3wfYTpA54kbVQps1\nGHL8HV95fB5xEagZd888i7CFmXZMJ3xF4R9h8UDe09ZlQ5sjY/E6Ff0bIaAP6phj\nl0IsIBYRPUeIGMYPqw7azmFy7XS4FPTrQmya1E7wxf/6CXot5EYhyYLr7RKdOjp5\nfoIkedY1ZhjuWZFa6EPaIYqqz8v9nGJx3uW3dZeuXfNrSjvj0RasHNXU84y0FP1S\nex6ywCFhLIVS5ewXXm6b9QIDAQABo1AwTjAdBgNVHQ4EFgQUDCeDghnKlaF2rAwJ\nrB0DSvAOpfwwHwYDVR0jBBgwFoAUDCeDghnKlaF2rAwJrB0DSvAOpfwwDAYDVR0T\nBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAEBt2aRlN01fZYYXwid/k/QaVlJUF\nRjFJouAFyC0N4sjZDEZxnOrLV8QxVABNGwJ78HDeQ7Z2xOeOEvKzORB9RJvsz4ac\nFuEmARQX8QDiSzeCvjiq0VBd46KVYlU0hSXRM99VEexB+V/S5/h4xRHaaRwcWD0k\nrcx+OJkf4WTNRm6t2+LOFcOZ1VV4C3DnPbd0nCJlJSzHYUKGfeoJJJ7ew4KZF4le\n2fdSm7mihM6r2O047IbPr9qkVRDXfaIkXfFvCBPKogZ0pv41ctocTbVvTKoAbe6i\nnpy6/mAHObt21m69If4I8DgLUvCuVIIbt/4TZVqeiN7mHIPk2XtftnMpSw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonAffiliation"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "UT Dallas + UniversityTickets SSO", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://securetranscript.docufide.com/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Parchment, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Parchment, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.parchment.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://securetranscript.docufide.com/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Lou Delzompo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ldelzompo@parchment.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "John Scanlon", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jscanlon@parchment.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Mike Williams", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mwilliams@parchment.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Andrew Lillie", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "alillie@parchment.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Parchment Admin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sysadmin@parchment.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://exchange.parchment.com/Shibboleth.sso/Login"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.parchment.com/privacy-policy/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.parchment.com", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Parchment", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIF9DCCBNygAwIBAgIQfb9u4T2cpVDON3fmjmnfETANBgkqhkiG9w0BAQUFADCB\niTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4G\nA1UEBxMHU2FsZm9yZDEaMBgGA1UEChMRQ09NT0RPIENBIExpbWl0ZWQxLzAtBgNV\nBAMTJkNPTU9ETyBIaWdoLUFzc3VyYW5jZSBTZWN1cmUgU2VydmVyIENBMB4XDTEx\nMDYwMTAwMDAwMFoXDTEyMDYwMTIzNTk1OVowggEWMQswCQYDVQQGEwJVUzEOMAwG\nA1UEERMFOTAwMjUxEzARBgNVBAgTCkNhbGlmb3JuaWExFDASBgNVBAcTC0xvcyBB\nbmdlbGVzMRIwEAYDVQQJEwlTdWl0ZSA3OTAxHDAaBgNVBAkTEzE5OTAgUy4gQnVu\nZHkgRHJpdmUxETAPBgNVBAoTCERvY3VmaWRlMRUwEwYDVQQLEwxEb2N1ZmlkZS5j\nb20xMjAwBgNVBAsTKUhvc3RlZCBieSBOZXR3b3JrIFRoaW5raW5nIFNvbHV0aW9u\ncywgSW5jMSMwIQYDVQQLExpDb21vZG8gUHJlbWl1bVNTTCBXaWxkY2FyZDEXMBUG\nA1UEAxQOKi5kb2N1ZmlkZS5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQDEXmXaO3MmOzdoGxy0NpU2cLB4OGd4Sbe0a+7X5cUN9+6uPQ/djQcVnul1\nH53GT0JCVduURf8MlDe0ys+9hbnt0fgPSCR5zFm/7EctX631OFv4jwE6fvM4FmPF\nHXPNi1g0cUnUhDj5uPiaLEKsADRQn1Joll17eM7nMQ2H8PZhPLuHthiCybYshBJl\n+fju8+vMkZFAhxY+SDCMup4M6yNYHBYHQCtYcP/C5lnN+y+Qg4sojLs11gyDH4/W\nufHAlEY+Q9Na0pMccnXs5p6vjq2mlgVixwNcQrqhRYdaF5szsTBVwqCYJ5F4sfdk\noJp6PVpNsfYTL1hZULryedemWUIfAgMBAAGjggHGMIIBwjAfBgNVHSMEGDAWgBQ/\n1bXQ1kR5UEoXo5uMSty4sCJkazAdBgNVHQ4EFgQUZ3hwONZ9gHFRtMZ/zmTJoBQj\nzfgwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMEYGA1UdIAQ/MD0wOwYMKwYBBAGyMQECAQMEMCswKQYI\nKwYBBQUHAgEWHWh0dHBzOi8vc2VjdXJlLmNvbW9kby5jb20vQ1BTME8GA1UdHwRI\nMEYwRKBCoECGPmh0dHA6Ly9jcmwuY29tb2RvY2EuY29tL0NPTU9ET0hpZ2gtQXNz\ndXJhbmNlU2VjdXJlU2VydmVyQ0EuY3JsMIGABggrBgEFBQcBAQR0MHIwSgYIKwYB\nBQUHMAKGPmh0dHA6Ly9jcnQuY29tb2RvY2EuY29tL0NPTU9ET0hpZ2gtQXNzdXJh\nbmNlU2VjdXJlU2VydmVyQ0EuY3J0MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5j\nb21vZG9jYS5jb20wJwYDVR0RBCAwHoIOKi5kb2N1ZmlkZS5jb22CDGRvY3VmaWRl\nLmNvbTANBgkqhkiG9w0BAQUFAAOCAQEAM2si5MrQl20R/HeCERbno7vmGQFiiasW\nmydiRxZdkBPPvYStGuOKrVglS3T7LvVkLhO+yxZZVUsi7ZJnC/yHWZ4elHu1kyqi\nYv3f/cCB1DTcVMjAXSRRj0T8xpTzhBdDekuVrpaS2MkLMLNa69ysdgsUZIhAFSIJ\nK5DT86SwT2wYtc2FL+D8BKkZVbpp3Y0DcYGLg0pfjk2j5ipOS+2CkyGZL4+wdot7\n3BV7H0slr37kviTzzBk0ECd+6OMc4bRNeN719SBzS3p3hO6NEHy+BuazKvWilVx6\nPa5PWeR/hdoYuFn2WEFnWruLDoaGLhPDoBcqsAgn70i3r5KibQ7cZQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://exchange.parchment.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://exchange.parchment.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://exchange.parchment.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://exchange.parchment.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://exchange.parchment.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://exchange.parchment.com/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://webpub-d01.andrew.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://webpub-d01.andrew.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Unix Request", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "unix-request@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Andrew Web Publishing Development", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDEjCCAfqgAwIBAgIJAJNO/GiDT58IMA0GCSqGSIb3DQEBBQUAMCQxIjAgBgNV\nBAMTGXdlYnB1Yi1kMDEuYW5kcmV3LmNtdS5lZHUwHhcNMTMwMTE4MTkzOTU4WhcN\nMjMwMTE2MTkzOTU4WjAkMSIwIAYDVQQDExl3ZWJwdWItZDAxLmFuZHJldy5jbXUu\nZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu3DJRxDLCw6S20kq\n5PxTIwd6ntKLt0g2tD/auOOTTVmjHRFsqj8/+GA1MdnGlh2JGs1A0TyysJ/Wgvfv\nV03WInWpAsVdtCHjZWfTcnYYV3h5LnDjpVAuQXWmCzFfa+TZIDC/C/eeGl5vqXp5\nCG1DD89dGg1EJGFAb53OJ68HwLK9lpverN9FKYLJe4pFU/+pF9Dw1jXy1ahzDtMO\n5KE4CZEZrpARzOlTEQTKVfMBe/nIM7NEFe1RhN75qgipIQrCMuv811aqrq5KGKGc\n6HeKUJNt5hyeuE7YAFeOIE+u3t5a4SgVMV0nGs1+xDYSkWgOe5MdY18riEOzFqTc\ng9ZL7QIDAQABo0cwRTAkBgNVHREEHTAbghl3ZWJwdWItZDAxLmFuZHJldy5jbXUu\nZWR1MB0GA1UdDgQWBBQbqG1WsQM2KNsuVsDFsHHJJY/uujANBgkqhkiG9w0BAQUF\nAAOCAQEAT3gedwU9pVp1IdeT4YBHyvr3gKNQAFS4uLsBkuSwlc27sEQxuHsAofF7\nAQknOo8h2H5P7GM6NDqlfxTvWc9wh7/1HapAWeP/SwCsZmM5xgwe3cwgrixal01D\ni7bbgq0/xCfDYvEmhUCpTuh1N+g5MKutL3iuz9GJN+9wqCJge1Fmt+CiSqtY7kZ+\nacLjEzziz5eWYVTXnFeBgBCNmwzeZuHvHwmAJxu3nelmiPOC5RQuq5ZPnRUq1sg3\n+wyyi7GtuNqC7fpRwWtH9eJ3tn9wqv+SnQWwZL6qAvCLr6mD1PclthNebXvUOOJm\nhzKvsN/VMhV+Jb5xvM8Xmo4bxU6A6A==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://webpub-d01.andrew.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:berkeley.edu", 
    {
      "entity_id": "urn:mace:incommon:berkeley.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.berkeley.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.berkeley.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.berkeley.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.berkeley.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "berkeley.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE9DCCA9ygAwIBAgIJAPg8VmRSQ3pCMA0GCSqGSIb3DQEBBQUAMIGsMQswCQYD\nVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8GA1UEBxMIQmVya2VsZXkx\nFDASBgNVBAoTC1VDIEJlcmtlbGV5MRMwEQYDVQQLEwpJU1QtQ2FsbmV0MRowGAYD\nVQQDExFzaGliLmJlcmtlbGV5LmVkdTEuMCwGCSqGSIb3DQEJARYfY2FsbmV0LWFk\nbWluQGxpc3RzLmJlcmtlbGV5LmVkdTAeFw0xMTA5MDEwNTU1MzRaFw0zMTA5MDEw\nNTU1MzRaMIGsMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8G\nA1UEBxMIQmVya2VsZXkxFDASBgNVBAoTC1VDIEJlcmtlbGV5MRMwEQYDVQQLEwpJ\nU1QtQ2FsbmV0MRowGAYDVQQDExFzaGliLmJlcmtlbGV5LmVkdTEuMCwGCSqGSIb3\nDQEJARYfY2FsbmV0LWFkbWluQGxpc3RzLmJlcmtlbGV5LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAMEPHLk1prO4Trb9nAgtVYWaqpLi1j0d9rbA\nX6v+/O8zI9ltKshho/r9EWelfxCnVzL2ufs44n+Mgqovl03IJXYKJluHILHppPUW\ntu3FF1D6kD9yXIOqc4vw/GHs5IHEjmm7jWyisNULf9zywjykcswFoBplF4xyhlHA\nk79uN3yYEGlOIQnrQfgMrbrrWTjlbZ/bb3QeFBhFnS6yujyDD1GBl2pWQYFjp+TD\nJBluvuwCe5F7gehqq7mmCWadpVCE/GT2LEgiCMyJxerVwwLjGC63/YF5pJ2NnZhd\nf8g86/GmG3LL/BS4Q1fuZ5A4MBJGT2/iVsGMcmC+/jTzJ3RZC8sCAwEAAaOCARUw\nggERMB0GA1UdDgQWBBRTW0Xhkt2L5j4f8BJ5RmbxtGNQ/TCB4QYDVR0jBIHZMIHW\ngBRTW0Xhkt2L5j4f8BJ5RmbxtGNQ/aGBsqSBrzCBrDELMAkGA1UEBhMCVVMxEzAR\nBgNVBAgTCkNhbGlmb3JuaWExETAPBgNVBAcTCEJlcmtlbGV5MRQwEgYDVQQKEwtV\nQyBCZXJrZWxleTETMBEGA1UECxMKSVNULUNhbG5ldDEaMBgGA1UEAxMRc2hpYi5i\nZXJrZWxleS5lZHUxLjAsBgkqhkiG9w0BCQEWH2NhbG5ldC1hZG1pbkBsaXN0cy5i\nZXJrZWxleS5lZHWCCQD4PFZkUkN6QjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEB\nBQUAA4IBAQBuiTYdJVZE7K20QpIDdRAJb6dQuzaQfz783r3rdk8K4oCEMxclgdIF\nY1kLF0zGKExTuHke5Jn4fPhSDc66273orJwfX8JPRhj0UsD0oJxiZzX1e47udpKO\nRrH0qjwpuWVq69aRQdNvg2ReEP0YLFrGE05GlBtM1wVXRy6N4TofybNVj9VvcIWR\nj+OKY/1E48QNYKEnxTdKbe5HEzm5Qzh9CwDpnWEEPTYVGXkcZr834c5rfCC9eJFW\nDwHJO2iXtfD8CCpYzg2Qm85yQo3LKavIRnDiPFC0SUliC9pyGGrf9Apsxfisx0Um\nqL/5vv0Vxy0Ba8FeI9WOTs3mSavQNGQ/", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.berkeley.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.berkeley.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "berkeley.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE9DCCA9ygAwIBAgIJAPg8VmRSQ3pCMA0GCSqGSIb3DQEBBQUAMIGsMQswCQYD\nVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8GA1UEBxMIQmVya2VsZXkx\nFDASBgNVBAoTC1VDIEJlcmtlbGV5MRMwEQYDVQQLEwpJU1QtQ2FsbmV0MRowGAYD\nVQQDExFzaGliLmJlcmtlbGV5LmVkdTEuMCwGCSqGSIb3DQEJARYfY2FsbmV0LWFk\nbWluQGxpc3RzLmJlcmtlbGV5LmVkdTAeFw0xMTA5MDEwNTU1MzRaFw0zMTA5MDEw\nNTU1MzRaMIGsMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8G\nA1UEBxMIQmVya2VsZXkxFDASBgNVBAoTC1VDIEJlcmtlbGV5MRMwEQYDVQQLEwpJ\nU1QtQ2FsbmV0MRowGAYDVQQDExFzaGliLmJlcmtlbGV5LmVkdTEuMCwGCSqGSIb3\nDQEJARYfY2FsbmV0LWFkbWluQGxpc3RzLmJlcmtlbGV5LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAMEPHLk1prO4Trb9nAgtVYWaqpLi1j0d9rbA\nX6v+/O8zI9ltKshho/r9EWelfxCnVzL2ufs44n+Mgqovl03IJXYKJluHILHppPUW\ntu3FF1D6kD9yXIOqc4vw/GHs5IHEjmm7jWyisNULf9zywjykcswFoBplF4xyhlHA\nk79uN3yYEGlOIQnrQfgMrbrrWTjlbZ/bb3QeFBhFnS6yujyDD1GBl2pWQYFjp+TD\nJBluvuwCe5F7gehqq7mmCWadpVCE/GT2LEgiCMyJxerVwwLjGC63/YF5pJ2NnZhd\nf8g86/GmG3LL/BS4Q1fuZ5A4MBJGT2/iVsGMcmC+/jTzJ3RZC8sCAwEAAaOCARUw\nggERMB0GA1UdDgQWBBRTW0Xhkt2L5j4f8BJ5RmbxtGNQ/TCB4QYDVR0jBIHZMIHW\ngBRTW0Xhkt2L5j4f8BJ5RmbxtGNQ/aGBsqSBrzCBrDELMAkGA1UEBhMCVVMxEzAR\nBgNVBAgTCkNhbGlmb3JuaWExETAPBgNVBAcTCEJlcmtlbGV5MRQwEgYDVQQKEwtV\nQyBCZXJrZWxleTETMBEGA1UECxMKSVNULUNhbG5ldDEaMBgGA1UEAxMRc2hpYi5i\nZXJrZWxleS5lZHUxLjAsBgkqhkiG9w0BCQEWH2NhbG5ldC1hZG1pbkBsaXN0cy5i\nZXJrZWxleS5lZHWCCQD4PFZkUkN6QjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEB\nBQUAA4IBAQBuiTYdJVZE7K20QpIDdRAJb6dQuzaQfz783r3rdk8K4oCEMxclgdIF\nY1kLF0zGKExTuHke5Jn4fPhSDc66273orJwfX8JPRhj0UsD0oJxiZzX1e47udpKO\nRrH0qjwpuWVq69aRQdNvg2ReEP0YLFrGE05GlBtM1wVXRy6N4TofybNVj9VvcIWR\nj+OKY/1E48QNYKEnxTdKbe5HEzm5Qzh9CwDpnWEEPTYVGXkcZr834c5rfCC9eJFW\nDwHJO2iXtfD8CCpYzg2Qm85yQo3LKavIRnDiPFC0SUliC9pyGGrf9Apsxfisx0Um\nqL/5vv0Vxy0Ba8FeI9WOTs3mSavQNGQ/", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.berkeley.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.berkeley.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California, Berkeley", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California, Berkeley", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.berkeley.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Jeff McCullough", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jeffmc@berkeley.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Karl Grose", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "karlgrose@berkeley.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shibboleth.msacademicverify.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Microsoft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Microsoft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.microsoft.com/en/us/default.aspx", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth.msacademicverify.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Tushar Nene", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Tushar.Nene@microsoft.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "AVE Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "avesupp@microsoft.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "AVE Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "avesupp@microsoft.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SLO/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.msacademicverify.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Microsoft Academic Verification Engine", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDXTCCAkWgAwIBAgIJAIPNJpzdV/nXMA0GCSqGSIb3DQEBBQUAMCoxKDAmBgNV\nBAMTH3NoaWJib2xldGgubXNhY2FkZW1pY3ZlcmlmeS5jb20wHhcNMTMwNzEyMDc0\nODEwWhcNMTYwNzExMDc0ODEwWjAqMSgwJgYDVQQDEx9zaGliYm9sZXRoLm1zYWNh\nZGVtaWN2ZXJpZnkuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\ny8xlr8kDHGHgLvfGzdFlV4gWov5IpGy9dtMWjkf5xE5817sGXhBNIt1ejQN6Nj3w\ny3ZwPWaDJ/tOXDhncPJ2+ur2L6a4IuNlTg0FcqEwc/VnofaRC5iyihtSGuttheQY\n6T+ptcdvbLDp4Wsq5hpQJrL3W6f4KfFkDr+3iqzLMFbw1IbhGSmpuS6xfHE7nTdR\nNheBF1pZgeUsNvgacwrKpZN4pdU9kmaEy3Iti59uOwGACOydxE6LHKCYcjVVjOmb\nZ65jPB+P3mnW0gdcz4U26jlThTJ+4E6DbLbeBZ2tGGWNZ9xvSrJzTqrh6wJbpXbg\nZ0F+FUfPtfT1uHBezSolZQIDAQABo4GFMIGCMGEGA1UdEQRaMFiCH3NoaWJib2xl\ndGgubXNhY2FkZW1pY3ZlcmlmeS5jb22GNWh0dHBzOi8vc2hpYmJvbGV0aC5tc2Fj\nYWRlbWljdmVyaWZ5LmNvbS9zaGliYm9sZXRoLXNwMB0GA1UdDgQWBBSl6x2NAW3h\noeUBLh7lSL+yIFmolTANBgkqhkiG9w0BAQUFAAOCAQEAGimMyBN15TiohXYEeg+7\nKy0ggztUQVHcvlZZL+E4bo048H2hZYD2mYwtbYfa9GQdWv+H2qy0Q9rjkWupdz6J\naudemQiHo2otVR/QQLRaj8KJAieheIMfnH9UB4ZJBGPhVlO9eMuU5fpwKtPZMahY\nZ2eUEvuRzidSTbSHWxeQ0lwbeFjEsO+vPTsWG+khGESA9fb/WhndZk+Qvn8Gdlfb\nI36H8KRs3YIJ7eKIg6CS6g1/n1MP65pAvitTtY/yf7Oy5BGDBVJ0c8vhaDx0NMdm\noqv/H3FB0kYoLtSxthUd1GcV2kgO0brHNSobuzYi4yePTH9rkY8Kn/ZF5pDVu4SK\n/Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Microsoft Academic Verification Engine", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://spcpdevsso.ucop.edu/SSO", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucop.edu/welcome.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://spcpdevsso.ucop.edu/SSO", 
      "contact_person": [
        {
          "given_name": {
            "text": "Patrick Rogers", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Patrick.Rogers@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "AIG", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aig@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://spcpdevsso.ucop.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "spcpdevsso", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIElTCCA32gAwIBAgIJAJDbWcYXKLA5MA0GCSqGSIb3DQEBBQUAMIGNMQswCQYD\nVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTEQMA4GA1UEBxMHT2FrbGFuZDEN\nMAsGA1UEChMEVUNPUDEMMAoGA1UECxMDQUlHMRYwFAYDVQQDEw1zaGliYm9sZXRo\nc3AyMSIwIAYJKoZIhvcNAQkBFhNhaWctYWxlcnRzQHVjb3AuZWR1MB4XDTEzMDEw\nOTIyMzcwOFoXDTIyMDEwNzIyMzcwOFowgY0xCzAJBgNVBAYTAlVTMRMwEQYDVQQI\nEwpDYWxpZm9ybmlhMRAwDgYDVQQHEwdPYWtsYW5kMQ0wCwYDVQQKEwRVQ09QMQww\nCgYDVQQLEwNBSUcxFjAUBgNVBAMTDXNoaWJib2xldGhzcDIxIjAgBgkqhkiG9w0B\nCQEWE2FpZy1hbGVydHNAdWNvcC5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQCxIctM9HkPHGpOHG82Ep+BedqPMmIHa0h20n6VuHELRSQxJdrcxclq\nCNL1oqbey/EDQ55PzxaULZB6o0Z+gfNWhmC4eiS6Aop/HKdDN/tCeU8RRVxzBoJm\nFFf/yoP7sdUzGn9U77DRhr50acyfs5Etk5f7vx1r9F48OhNd2L0Q/nsPqJ0HtD20\nYnKu26/aa4gm1myu3hGG7cS2zWQ7yT7jfVkv/4jPHtANnUyORnz+9bNAqrqLp9M6\nQVSMUBk0ZG3wIugfJNjBFb+300f30vQlcuj3rXYXZ+0feWuMhja1JbnD1k2bhca3\nyeyT2q5BgcAPNNuEWuBa7+95rFC8+c/xAgMBAAGjgfUwgfIwHQYDVR0OBBYEFB2E\nW0y9F93V5BDyFSUP1d2yxYGUMIHCBgNVHSMEgbowgbeAFB2EW0y9F93V5BDyFSUP\n1d2yxYGUoYGTpIGQMIGNMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5p\nYTEQMA4GA1UEBxMHT2FrbGFuZDENMAsGA1UEChMEVUNPUDEMMAoGA1UECxMDQUlH\nMRYwFAYDVQQDEw1zaGliYm9sZXRoc3AyMSIwIAYJKoZIhvcNAQkBFhNhaWctYWxl\ncnRzQHVjb3AuZWR1ggkAkNtZxhcosDkwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B\nAQUFAAOCAQEAIPWz5e5mF9gPIjgPZGrrzlA1qERsVWtV5i8yiJ1GVLXlCUeENf+w\noU6HcCr8Vo/NOuaiFrTVhLR9FwwuMVqp3aav34nTtDL1Tfg6CptQJ607rEVaE2hM\nXIq3yceRF2gnVkJ6zfOQ18nX0UrSLO97BvtIRRLWOJsOoWX+obymzz4Jq1JlrQL3\nTDFG5osKHaAVhhIwYfQm9Ez41N0FS6P+6de2Ru4bMeiW6sajNlVNSHu1IeLwoh8Q\nIQjKd6jpPKdWx4iOnJ1qg2wONpiTdQHwR/v7iXn7MHAKwEaPUJWsAllkBuXeZpZw\ndZ/jSOFUlugOqCYLe+lGROe5pG+ETAq67g==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEhTCCA22gAwIBAgIBADANBgkqhkiG9w0BAQQFADCBjTELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgTAkNBMRAwDgYDVQQHEwdPYWtsYW5kMQ0wCwYDVQQKEwRVQ09QMQww\nCgYDVQQLEwNBSUcxHjAcBgNVBAMTFXNoaWJib2xldGhzcC51Y29wLmVkdTEiMCAG\nCSqGSIb3DQEJARYTYWlnLWFsZXJ0c0B1Y29wLmVkdTAeFw0xMDAxMTQyMjA3MTBa\nFw0xMzAxMTMyMjA3MTBaMIGNMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEDAO\nBgNVBAcTB09ha2xhbmQxDTALBgNVBAoTBFVDT1AxDDAKBgNVBAsTA0FJRzEeMBwG\nA1UEAxMVc2hpYmJvbGV0aHNwLnVjb3AuZWR1MSIwIAYJKoZIhvcNAQkBFhNhaWct\nYWxlcnRzQHVjb3AuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\no58S+32K6mpCCp/R4r40TwX8z4nqEge6mroIWRDJrFuZ3ZdS4Sw2BJQpcoxakYTF\n4jDynvM3S2zk7yom8ghrlT/IEWdojMkFfZykx/XQq1KKLTOc73LqYMKxFRrLd9/d\npk5LEcRysTDkOIlcRUrjnvG/jnsjKydG2VNLrySQ3/PHcjoB2P2NHGPRQMlInjZV\n1XNUC2mC3aCk3PC+jUaR/PE0LzMQ59qHGy5bTQIqGsGifVgCwrjyGqTGmmm4K8qc\nufZLAI+K27oLGUsh8Q6cewnqz8mRd2FJWsk/QVx6Qerp/CacFjxa7U7JKnnE3O1B\nZdmU+YqCRdTJ0QANH5Xi1QIDAQABo4HtMIHqMB0GA1UdDgQWBBRQFY4qfAX8jUwX\nT16LN/HzGBEjgTCBugYDVR0jBIGyMIGvgBRQFY4qfAX8jUwXT16LN/HzGBEjgaGB\nk6SBkDCBjTELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRAwDgYDVQQHEwdPYWts\nYW5kMQ0wCwYDVQQKEwRVQ09QMQwwCgYDVQQLEwNBSUcxHjAcBgNVBAMTFXNoaWJi\nb2xldGhzcC51Y29wLmVkdTEiMCAGCSqGSIb3DQEJARYTYWlnLWFsZXJ0c0B1Y29w\nLmVkdYIBADAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IBAQAfDDpq+pVi\n3+nN2BLuqz2kASyaose7hZrEyf2qSEMOrYtPA99gILvVSSHuOR4PMj1VPqs1NY2+\nAa40Ova/RNW7Psj9qlskvGnbPVRBvEvIVPlYqKT7eVOwCsyeC7Ae3bnA9+UBVBaV\nlTaHIVTjTgmlpMPkg+kHPTr8JoPm6hEhgHxoqGAAQue4g/0rwLOGxlRqKjH4Q+EU\nwJMWZUo071UC5nuzKL/3IEufjcbzogBwW0OMpcwl6rxkbw36tSqZls4TPvR67FUj\nRgsfv6fwNijCs+jTHt0a3tEucCC2ILtwAT5C0sHXruw0+sWVVs+HoOuBEneXa9Br\nyV8pCTW41z4K", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spcpdevsso.ucop.edu/SSO/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://spcpdevsso.ucop.edu/SSO/Shibboleth.sso/SAML/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://dsa-dev-web.studentaffairs.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://dsa-dev-web.studentaffairs.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Brian Stuper", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bstuper@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Kate M. Bedell", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kmbedell@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Student Affairs Dev Webapps", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLTCCAhWgAwIBAgIJAKPtUrKi4QNeMA0GCSqGSIb3DQEBBQUAMC0xKzApBgNV\nBAMTImRzYS1kZXYtd2ViLnN0dWRlbnRhZmZhaXJzLmNtdS5lZHUwHhcNMTMwMjAx\nMTcyMjM2WhcNMjMwMTMwMTcyMjM2WjAtMSswKQYDVQQDEyJkc2EtZGV2LXdlYi5z\ndHVkZW50YWZmYWlycy5jbXUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAwUkMG9uolfYfylrs90JQhnUO9c/sRx1x7bP4nunM1U8bF7qTxQX99+2E\nAhrbhCKbmPRffFYH3lDZhU1LijGLHi3MgjIX5K+REX71tRHvkKdj6CO1o5vqiL8p\nnaPXWHbFGwM+8VEWw9ZpyvtB85/6gaoDko7/mR1FDga+xvpOj2jhMNPW9t1hu5TZ\nuKCYjTWbAhgJFT9GLe1e49ye6MWs8lApsBuDnqD1qOgQZICBWQreE62MbKZyW4UE\nW66j3mXSV635LKUbfpo1PY5qnLvNM12LxrMn5gUb44e08AZ4ZKAOKy1ilgY60EGf\nMGgQJcpTnxwbnVCl9l4AJjwBOywQvQIDAQABo1AwTjAtBgNVHREEJjAkgiJkc2Et\nZGV2LXdlYi5zdHVkZW50YWZmYWlycy5jbXUuZWR1MB0GA1UdDgQWBBSmQSzeyDAK\nkBrstEw1ux/0J60cNjANBgkqhkiG9w0BAQUFAAOCAQEAS2uRwUPs9davotx5OUw9\ni5ECjDDMrTKEW/lKd2lr+jzyrp52v+n30I8rjDg8LP9KS7PUxTiqaKz8rB4nzG23\nUGvHxUT4qdCEV+BYTGs2GlCl28dF/UmIFMYWDGTgiXi9OgqBIUsP+5+B0FGgZ1fm\nFbIN8SKmem3QlW9WWUBe5DQ+sbG0etBlowtHIfdcYWNV1NZwJcKkR8VQJ5x/h8Iy\nPGzBSvVb5RU9B30DCx1F7HNGt+cF7IVbuUhIhVUCQ87BZ9c+BK4tpbCqwZwFRqp+\n0Ja38Hn56KJNu3aDT+KXenTJdX3j49OppjZJKNTiYop2ggJE7DpigkKXGV4r3apU\nAw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dsa-dev-web.studentaffairs.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth-business-buffalo.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-business-buffalo.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFxTCCBK2gAwIBAgICAk4wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxMzE4MDc0OFoXDTExMDcx\nNDE4MDc0OFowNTEzMDEGA1UEAxMqc2hpYmJvbGV0aC1idXNpbmVzcy1idWZmYWxv\nLnN5bXBsaWNpdHkuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nphrTqfSDOmbMGW2N9poghTN2Z3he7dcupbTkoea04XZsrP33VS165iXrl+2Y1+qi\nH1seSJkEX2+ydsmhHwqgrlzxReHxwc3uw+IC2KgPzeMiDpblZ0xYynpKvBWhqisl\nu11H/S5OeGN3uaTOmnU4WMU/L9Qq/dgdR4c04vfguoRYX/Ed+fqgk2utmyXiwWsA\npescwfORSR1XGq4znKB205t7vo2fWEVsSMk0yIB8tdY1dNC6T7mtqQ6Sfzyp6xh0\noEtmybLV0c7XQXsY9R/P5VmjxprtWxIp1+Xv3b6pfyLKAzqYX8bXBe1T6bhnkTev\nPiW76dzGSSIqSZyn6Ucd9QIDAQABo4ICvDCCArgwDgYDVR0PAQH/BAQDAgWgMAwG\nA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1Ud\nDgQWBBS5OQID2BAXA90uVaAEOKkCtqi4aTB+BgNVHSMEdzB1gBSTLchhGK1j45tl\ns53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9u\nIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0\naG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDov\nL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRz\nL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCB\njQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNv\nbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBe\nBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9p\nbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjA1\nBgNVHREELjAsgipzaGliYm9sZXRoLWJ1c2luZXNzLWJ1ZmZhbG8uc3ltcGxpY2l0\neS5jb20wDQYJKoZIhvcNAQEFBQADggEBAFYiDHUDcIZmOMSc09Ap6GKeoJo3dPZ6\nNAveyBaeLnlgHS9zmjKBKu+RtHivevmV0Rn7bjreDmk7LvRWEt29uj1EpNqTQYCn\n8lLsuB0tPlFT7EBj2FpT7pvIUTm0JL9/CYelx2Hp5hdLxXMT+8ZPPLGRxt6pEFaj\nyb0oN0qLaHTlQlUop9GjXcjWphHKyRdGcwtMX7czAmKgrqwBQ4T6Tkf70dbJ8dvi\npvOc/BuyWXAOtcI/nexi1WR/zrUb9Eq4/K3VOWQ0Gxqg1vgxmwAJ4yT4fElRqclp\nrV7/h20/0tnnlxZ6gbyLJ289iZ1C7QbaCXJY3LEv8XUZLizu5tyyfyA=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-business-buffalo.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-business-buffalo.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://pqshibboleth.proquest.com:9443/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "ProQuest LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "ProQuest LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.proquest.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://pqshibboleth.proquest.com:9443/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Marion Nalepa, Software Developer Lead, ProQuest (Ann Arbor, MI)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "marion.nalepa@proquest.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://pqshibboleth.proquest.com:9443/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://pqshibboleth.proquest.com:9443/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://search.proquest.com/info/privacy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.proquest.com", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "ProQuest Platform", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "ProQuest provides seamless access to and navigation of billions of digital pages of the world's scholarship, delivering it to the desktop and into the workflow of serious researchers in multiple fields, from arts, literature, and social science to general reference, business, science, technology, and medicine. ProQuest\u2019s vast content is only available to users and researchers that are members of subscribing libraries.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDODCCAiCgAwIBAgIBADANBgkqhkiG9w0BAQUFADAkMSIwIAYDVQQDExlwcXNo\naWJib2xldGgucHJvcXVlc3QuY29tMB4XDTE0MDExMzIwNDQ1NVoXDTI0MDExMTIw\nNDQ1NVowJDEiMCAGA1UEAxMZcHFzaGliYm9sZXRoLnByb3F1ZXN0LmNvbTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANVfSIddTEbP3u5oPG34858vjZyT\nO8sRqPK0jKC4GcGiCVQrzNInKuEwQWwiaVhb53E0fAlcAoJDqel21ruuX28WqcI3\n4IbGPEXBZmTgm/Mqg+CB8L5eAZbl7gxlCfl/tCjz9QrdfLnTcKrEs44RTcpoMsOD\nFLEilH+ze3J/f7gp+wHDM9bu6wai98pybI9of9PWUrjw/LLwkCs6irBXZh3F/hMJ\n0vEbkw+TcMT/ClL1W9WuNFaN4xNYOq00kF8xgWk5zYkI6jtNdGN+idpnkgi6MPov\n3oY/nJ28atafx/IBNCifg5NyfSXJV2feCo43WEUsYV4gqbgytn8OK5OItqECAwEA\nAaN1MHMwUgYDVR0RBEswSYIZcHFzaGliYm9sZXRoLnByb3F1ZXN0LmNvbYYsaHR0\ncHM6Ly9wcXNoaWJib2xldGgucHJvcXVlc3QuY29tL3NoaWJib2xldGgwHQYDVR0O\nBBYEFNBy329C2yFjrr3fruzeIfTrJ8qJMA0GCSqGSIb3DQEBBQUAA4IBAQApEPIa\npdmO3uXlC/uezxmyFy5axI8YmkcBwf08Lm9PLeNXRhezvFZ7M6zlXLIgvX0wAjb4\naOem1sYzg+9BJ5fg0jE41mllm0LIN673iyr1xNZJv6SDOQ3tLCcxte5jgMWPefMK\nvcVawCuroi99B+UPseTdW1m2kdcAHIOyjS/wqkjM/+WMYwh7vW57lKWzcMxtqaJ5\nIZqj0mayuGtFVc7ZwtzhJ8DpRx//cFIpjmFT+WjGTwAt+5Kz883j5jq1FtKKC12T\nTPwAlH/ibmXHxGI2q/FLSqq0ZmgjbqVTIaehNf9RS76abg531Eyj/sp/tnq3a/vh\n/ykrznTClItTtcrn", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAiigAwIBAgIBADANBgkqhkiG9w0BAQQFADAkMSIwIAYDVQQDExlwcXNo\naWJib2xldGgucHJvcXVlc3QuY29tMB4XDTExMDIwMzE2MTg1MVoXDTE0MDIwMjE2\nMTg1MVowJDEiMCAGA1UEAxMZcHFzaGliYm9sZXRoLnByb3F1ZXN0LmNvbTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALxrvtySvrav7TyDYaA3oWzEHImO\n8W4HDmP+xVOD2RNeYi4gDTYkEXryayLEut5rPMnZeqB5MDbEMfk8jrXHi1XdCZR1\nWTXNJHf4j9t7CDWS9rRhe+hVZxS29RLA/QBSs59zLpZQMuXxVTJo4hLRpXeyqoUb\nv672RLssm2CVGRActnih+M16xisjq2nHqXHOTTOeFNpEApeBdiDXPjauw3xp0pfw\n+mJuwgcJnKy1UNFI4uQUlkCvBBIVyuAM2krQcj0/UOFrUVX0Fa/PKJRybCA0TmYn\n6naOky9aUatENGLkmYH67RDDr6PwkWoSGr2hBQqe1Ncs4lZ9jF5lqOzDt2ECAwEA\nAaN9MHswHQYDVR0OBBYEFBNCMwuDe3qpreLgso/wDtNe/nJIMEwGA1UdIwRFMEOA\nFBNCMwuDe3qpreLgso/wDtNe/nJIoSikJjAkMSIwIAYDVQQDExlwcXNoaWJib2xl\ndGgucHJvcXVlc3QuY29tggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQAD\nggEBACgWCNvJq4cy1i0/mE8dXYsoyQ8QRG9QXpx5Av3TQewNv9/w8rkuKKnaVo+9\nCvwShXkigdxxdUYQRpvX/Vso/6UUM8p9VeRh9fk29zHUMh2tsIv6RdR2btlBXSGP\n8ooaXIrZBW4wuSYUFUGKxmsXuC7xJN+ciFuQYPIZ48ayfMwbIjUrvWmvKDt0EHwR\nJP49gfGziQEhv0W+1LtILDhDolE+QuwqDSXUaxhWaGvOE+m/eQKUmMrnQI6Xm7iz\nllRwbl8f8tMfJFfhdcNNJk7KB9uHEKAfGxY6TVDYuTujoEPq3KGkjreAwAuagM7a\nw3TEf0UNS0mkXt4kI5wSMt2ZJP0=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "ProQuest provides seamless access to and navigation of billions of digital pages of the world's scholarship, delivering it to the desktop and into the workflow of serious researchers in multiple fields, from arts, literature, and social science to general reference, business, science, technology, and medicine. ProQuest\u2019s vast content is only available to users and researchers that are members of subscribing libraries.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonEntitlement"
                }, 
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.7"
                }, 
                {
                  "friendly_name": "eduPersonScopedAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonScopedAffiliation"
                }, 
                {
                  "friendly_name": "eduPersonScopedAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "ProQuest Platform", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://geni-portal.co.internet2.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Internet2", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Internet2", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://geni-portal.co.internet2.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Steven Carmody", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Steven_Carmody@brown.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Steven Carmody", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Steven_Carmody@brown.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Steven Carmody", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Steven_Carmody@brown.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/DS"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIJAPtmR5TNmd0AMA0GCSqGSIb3DQEBBQUAMCcxJTAjBgNV\nBAMTHGdlbmktcG9ydGFsLmNvLmludGVybmV0Mi5lZHUwHhcNMTAwNjIyMTQzMTQ2\nWhcNMjAwNjE5MTQzMTQ2WjAnMSUwIwYDVQQDExxnZW5pLXBvcnRhbC5jby5pbnRl\ncm5ldDIuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAshy1wPFp\ncfFmfm4ohjjB0fE6sPuUdEPYOSCOPxCQVIDqsWogj/5mr/gaUA023vpqcM2J2kW1\nK/jnHDGcxsFtlNFD9tJJsWDL8863+ny+a4TgwP+fniEng/34Gd1CBSZjcxW2+9US\n4i38nYmDFpZaxksoTuQaZaJApl85kx4CwacrbHsKzcqJPpdxwlZ4+0wd7oAg0yva\nPhEP+YN9EAbm/a/T9/JoKRRjSK7RftFp8tk7a7xYL5JBydS+Xn5ACHgFGmp6NsEB\n0IuCEMsg5rdQgMoSMUBI0/ua2OuWnBN+nT8JHEk1nINb7uwQLNEDXI8rncH7eJTx\nQV3HZ74xR4BEKwIDAQABo0owSDAnBgNVHREEIDAeghxnZW5pLXBvcnRhbC5jby5p\nbnRlcm5ldDIuZWR1MB0GA1UdDgQWBBTmkcgydk451jSEWctNOn7i7cuKtTANBgkq\nhkiG9w0BAQUFAAOCAQEAFtrrpwZ39xj2UhBojohVCE4MKtRC3jWGCB0JnfOr7Ykq\nM3Y+G2w2KAgaEmmmGJRs8Lx2lr+tFrlu1fzLEiNxJ7xxcrcNvDn8JbbtXdWW7642\nKanr/jRUzN+YfODww8SC5deYe5YXF9QVBG4n1sqZ2QwyuKxbD2ZztWpKaGPi4wzM\n7zJGY2QpYKvoRyAdQCRD0xyB4C2D2S4vJB8HeWxHaW8pPiCyvTPcpvxBB2Y1Naz5\nQdOFhk8NZkYT45fg3ll3zJ8c4vmmm/4s7uOjBgBUhBjvJiA+RrrtpqmXt7C7EtO5\nSwJ6zQaZfmoVT2ZUNq9vJtJnbcneOSg/6hJz1T5aSw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://geni-portal.co.internet2.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://erst1.ais.ucla.edu/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California-Los Angeles", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California-Los Angeles", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucla.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://erst1.ais.ucla.edu/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Wen Tang", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "wtang@ais.ucla.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "David Lee", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dlee@ais.ucla.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "AIS Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hd@ais.ucla.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFlTCCBH2gAwIBAgICAqwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTEwNTE5NTg0NFoXDTExMTEw\nNjE5NTg0NFowHTEbMBkGA1UEAxMSZXJzdDEuYWlzLnVjbGEuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1afiAKBMIqFq7tYVueyTppaG2qrdHMIg\nePmSLK8XJBH/r1SPskaTIs5zXJ5CHhqGUrq4eXFWeUnZL77mPTLUCk24NAF/m3DI\nGca1In1EmepUiU28P4nus9GHEn+yA22Bb7ZtEN72eNMT2Og1DbLSFQMrrhRv4BFS\noA3SG+MJYIvFqgFed1GE4629kHx6LyfxBTyjLdtnNuoOzUOqstmnd54ejT3GwWRQ\nJgmQgmLUvsRKIWtV3lhVlnc6mJHDlnxGRM6s9a+wZnhgs51gXllDqW6TYR3ptIz3\ni62811hmedXFXcApkEqwDPa+M56oskpQiOrO8xHn/eYHBax37hO6MwIDAQABo4IC\npDCCAqAwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYI\nKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQ5XFl8ACZT/Trtm0T41IK78BQF\nKTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UE\nBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIElu\nQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSB\npTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcw\nAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJp\nZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRw\nOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Js\ncy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEB\nMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAdBgNVHREEFjAUghJlcnN0MS5haXMudWNs\nYS5lZHUwDQYJKoZIhvcNAQEFBQADggEBALNvvLbz9gdKe3nluRCRr24S2NQipAoP\nOkMo07XKccJx8eXe3bL6dgQn+DC2DU3cwoj5uJFPmNKFRj/4lYvYUwR8W4djYFa0\nBYTteR2bp4MQbWzyigwS7xkI1qSNV0InFBNS744MOVVtlGyqiv5proHQUnLXzczk\nqaGLwNLnv8GsnaRr6qJcrxiWrCJ51Y4k3BPsZp2KGjzJ8iWVbT2ZRU8UjWXXI7nl\nv5bL9ohWP1BvaJBZlnIpy3JHrLr5UtW8NIfuq8qUIRWj/c8Xe04X7nGuqhEP3k38\nXc9GSkgJ1DfwD9X2djBHLrWTW+eUssmoKEUlta8UgXRGca8ireV9Unc=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://erst1.ais.ucla.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://erst1.ais.ucla.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://erst1.ais.ucla.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://erst1.ais.ucla.edu/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ephemeris.net.cs.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://ephemeris.net.cs.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Dale Shanefelt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shaneda@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Clauss Strauch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cbs@cs.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Net Infrastructure", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDDzCCAfegAwIBAgIJAP5gQfE/sYvDMA0GCSqGSIb3DQEBBQUAMCMxITAfBgNV\nBAMTGGVwaGVtZXJpcy5uZXQuY3MuY211LmVkdTAeFw0xMzA3MjQyMTEwNDZaFw0y\nMzA3MjIyMTEwNDZaMCMxITAfBgNVBAMTGGVwaGVtZXJpcy5uZXQuY3MuY211LmVk\ndTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAONJ4JJzG2L4yghva2jL\nSuy3OHSA/eK/8Sgv6HZtrONmQeuuXJQQ8iZFTRdHs7uUiHyjgEOrtAB/Xm9gEUAT\nm9QFTHa6Jim79+mu9CNRR+9m3CDUurL5GIm6WLBP7msUowkXljudKRwRwjUuqJ32\nI9w+MYJQ4HlgdkSsBvmb0C2v3iNUxvOzlrp+wxbIFfCQHEEu33ZXt7wfwvHVYwUp\nfTIQgrtaXF4VVWoX4/pIzEIwy7VNbJ2XDo87a4xce2TWhOtsuDf9JWASyjOtjMfe\ntjhbi9+RW+kvJFz2CON18RbwFnGK8eNMtpbsOsHEVOGYduZyy6pgtqBP1aDYQLlT\n2icCAwEAAaNGMEQwIwYDVR0RBBwwGoIYZXBoZW1lcmlzLm5ldC5jcy5jbXUuZWR1\nMB0GA1UdDgQWBBRwPLoBVWohDJf1Gx5xX93Wdres4jANBgkqhkiG9w0BAQUFAAOC\nAQEAo+ICmMhmIs3tVqN50w4wWAiNsQGVy6yJDcHrUdVmbpJvZOmIVzpiarNNR7fJ\nSyZ/1BvigL6qEoVkzGudYV0m1v5y6nTsE/RSYR7afHOqfcLbZr0uQse0SUxoB6dX\nx/Vbaq1njQlAvgP28W82WNCYozmov/9mVIArOkmDNYGNm6nFjxTqMHyDOsCzqlYH\nH2kKyGpqomEwyjv39Ps5bK0MwSA8mn7xODEPpxNOPS/pbW+ifHoKTBHpi5CceIpW\nRyvubUYfdq795OwbNCRRJdKEhU3Hmi9Vu2DiVsncwvCWtnVQsN+VjNvBZlfniRmU\n8rrg9Tic2gpojCWGAVrMAgqRMg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ephemeris.net.cs.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sky.net.cs.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://data.fac.cs.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rete.fac.cs.cmu.edu/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:ucop.edu", 
    {
      "entity_id": "urn:mace:incommon:ucop.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://ucopidp.ucop.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://ucopidp.ucop.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://ucopidp.ucop.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://ucopidp.ucop.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ucop.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLDCCAhSgAwIBAgIVAMQjUagrFAAc3mU/MM8Y89753FJsMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEHVjb3BpZHAudWNvcC5lZHUwHhcNMTEwNDE1MjE0NDQy\nWhcNMzEwNDE1MjE0NDQyWjAbMRkwFwYDVQQDExB1Y29waWRwLnVjb3AuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5yWRcAVFF4lApTgaJ6Wiq4HQ\ncnHxfdZwqWwEeyKGcjhzS3mbaNZAjR37wsnK19npCIunzb966PK8BAXhATX5L7x9\n0+F8qTDL9NWGB2usN4ftkxDjCbHSzQP8/C1+nLdj0EuyxXxbn5etiVn5ScQ+xMHc\nMyo+u2+7crKloeUERtgXV9d8wbMZ+5dNeSjIVBq/EldB1xpo1oSQz5LSZoWppjqR\nj+HDHQNY2rGdyJchd6M5QjtV5/yWZsjhd++9AiD+avAcNkWrF+3Yg5mcRzgHhMtb\nYHZXtb69hJfO+vwQ655wlgN25pw4H0wLB5/GehMAi82hnL3PGnwvgFDrt2uTIwID\nAQABo2cwZTBEBgNVHREEPTA7ghB1Y29waWRwLnVjb3AuZWR1hidodHRwczovL3Vj\nb3BpZHAudWNvcC5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFOM/H8+UOT/R\nDmr2WHQCXELzAZztMA0GCSqGSIb3DQEBBQUAA4IBAQBVzHO+GyiTfvkhMqz29wl5\n6wLckOvYuilJqru9jXZOCzBzpjnK2YbAKmbmDs2BDT3cJfJDDAxM7bZG69mFf+0h\n2qIcgCoZd6054kAEe/T9WloBVRWa2AnQlbtkd3YIkmlCpB6jLNUpkgX6PAVPOpBa\nvEMn/hMWxQb10qaOsGyzp3uXz2aYJgZoEv2qAdVtKpuDSOcPt11A7rwZE4XhVwhb\nhdYDgZJ0gVCbr3oNhiccN7cf790QxrUdTjDq2qSl47S/SpOOLSLH0vflygsdASlb\nr5yHRx2chce62RYQtpM9sBEJjMZ9seBMN3J+y29vdvayfD1mo9Ma56VSHLitFJ9N", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://ucopidp.ucop.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://ucopidp.ucop.edu/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ucop.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDLDCCAhSgAwIBAgIVAMQjUagrFAAc3mU/MM8Y89753FJsMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEHVjb3BpZHAudWNvcC5lZHUwHhcNMTEwNDE1MjE0NDQy\nWhcNMzEwNDE1MjE0NDQyWjAbMRkwFwYDVQQDExB1Y29waWRwLnVjb3AuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5yWRcAVFF4lApTgaJ6Wiq4HQ\ncnHxfdZwqWwEeyKGcjhzS3mbaNZAjR37wsnK19npCIunzb966PK8BAXhATX5L7x9\n0+F8qTDL9NWGB2usN4ftkxDjCbHSzQP8/C1+nLdj0EuyxXxbn5etiVn5ScQ+xMHc\nMyo+u2+7crKloeUERtgXV9d8wbMZ+5dNeSjIVBq/EldB1xpo1oSQz5LSZoWppjqR\nj+HDHQNY2rGdyJchd6M5QjtV5/yWZsjhd++9AiD+avAcNkWrF+3Yg5mcRzgHhMtb\nYHZXtb69hJfO+vwQ655wlgN25pw4H0wLB5/GehMAi82hnL3PGnwvgFDrt2uTIwID\nAQABo2cwZTBEBgNVHREEPTA7ghB1Y29waWRwLnVjb3AuZWR1hidodHRwczovL3Vj\nb3BpZHAudWNvcC5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFOM/H8+UOT/R\nDmr2WHQCXELzAZztMA0GCSqGSIb3DQEBBQUAA4IBAQBVzHO+GyiTfvkhMqz29wl5\n6wLckOvYuilJqru9jXZOCzBzpjnK2YbAKmbmDs2BDT3cJfJDDAxM7bZG69mFf+0h\n2qIcgCoZd6054kAEe/T9WloBVRWa2AnQlbtkd3YIkmlCpB6jLNUpkgX6PAVPOpBa\nvEMn/hMWxQb10qaOsGyzp3uXz2aYJgZoEv2qAdVtKpuDSOcPt11A7rwZE4XhVwhb\nhdYDgZJ0gVCbr3oNhiccN7cf790QxrUdTjDq2qSl47S/SpOOLSLH0vflygsdASlb\nr5yHRx2chce62RYQtpM9sBEJjMZ9seBMN3J+y29vdvayfD1mo9Ma56VSHLitFJ9N", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://ucopidp.ucop.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://ucopidp.ucop.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucop.edu/welcome.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "UCOP DataCenter HelpDesk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ucopdatacenter.helpdesk@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Munish Malik", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aig@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Paul Weiss", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Paul.Weiss@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "urn:mace:incommon:uiuc.edu", 
    {
      "entity_id": "urn:mace:incommon:uiuc.edu", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "error_url": "https://shibboleth.illinois.edu/idp/error.jsp", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.illinois.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.illinois.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.illinois.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.illinois.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.illinois.edu/idp/profile/SAML2/SOAP/ECP"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "illinois.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "University of Illinois at Urbana-Champaign", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFMjCCBBqgAwIBAgIQYMsxBFaL4VIrCQq7BEyJHzANBgkqhkiG9w0BAQUFADBR\nMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSW50ZXJuZXQyMREwDwYDVQQLEwhJbkNv\nbW1vbjEbMBkGA1UEAxMSSW5Db21tb24gU2VydmVyIENBMB4XDTExMDgxNzAwMDAw\nMFoXDTE0MDgxNjIzNTk1OVowgaAxCzAJBgNVBAYTAlVTMQ4wDAYDVQQREwU2MTgw\nMTELMAkGA1UECBMCSUwxDzANBgNVBAcTBlVyYmFuYTEfMB0GA1UEChMWVW5pdmVy\nc2l0eSBvZiBJbGxpbm9pczEgMB4GA1UECxMXVXJiYW5hLUNoYW1wYWlnbiBDYW1w\ndXMxIDAeBgNVBAMTF3NoaWJib2xldGguaWxsaW5vaXMuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxTh8hEoHtkJbjyIQupE9iwe61WEH40uJzBCz\n2GD/6SfUN6Va4FhK2MUJmhgFsMrxVrfXuSLHBF4fpOcxRBtIhE9hoZ/WX1V3TOeH\nZhDIObn5OkgxtqoIiMcYB0D5GeUFI8V+6yqNPBlgwPYISXMj7x93UUV7akXJNLKa\nzjI+bKFdCkNOY11ntLJIkFZLBMTEUHi48XfPlxhMxk+s1BhoJo9ZX1RubjgzOx/8\nFXcu859akRXykJSsvG6+26uphT+VyDUxxjpVvj/NV7pQDqWqRkyoepIBiMvAG/cJ\n3VKLVPT1GWJoI16OVyVhVYGsV4PYf3fRCiV6JvbZrgmv/XIeMQIDAQABo4IBtDCC\nAbAwHwYDVR0jBBgwFoAUSE9a+i9Kml7gUPNre1Wl3vW+NF0wHQYDVR0OBBYEFOOa\nf63my9qvDEBHaiyFzGTeYvTkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAA\nMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBdBgNVHSAEVjBUMFIGDCsG\nAQQBriMBBAMBATBCMEAGCCsGAQUFBwIBFjRodHRwczovL3d3dy5pbmNvbW1vbi5v\ncmcvY2VydC9yZXBvc2l0b3J5L2Nwc19zc2wucGRmMD0GA1UdHwQ2MDQwMqAwoC6G\nLGh0dHA6Ly9jcmwuaW5jb21tb24ub3JnL0luQ29tbW9uU2VydmVyQ0EuY3JsMG8G\nCCsGAQUFBwEBBGMwYTA5BggrBgEFBQcwAoYtaHR0cDovL2NlcnQuaW5jb21tb24u\nb3JnL0luQ29tbW9uU2VydmVyQ0EuY3J0MCQGCCsGAQUFBzABhhhodHRwOi8vb2Nz\ncC5pbmNvbW1vbi5vcmcwIgYDVR0RBBswGYIXc2hpYmJvbGV0aC5pbGxpbm9pcy5l\nZHUwDQYJKoZIhvcNAQEFBQADggEBAHLOK3mvT8PiRMV51+Z8xHAE/sIO7uA7rViF\nhNyAvFoEWYS5LWLcr8Nx2d7j3Y35hE2DLs2f8TY09bOr7z7pC9lvXrVfBTXUTClB\n4srZufS6CE3rkspEq5qBmqJddNv9w6JCIyY6EzMMcPDDrkrd7tIa9qGNJ7d6O6Cx\nQCHhgbQtYILegQAcCwyar56RF871YKDTrbVmcC6P4paZGheWYSpveDiXi08489F0\nIlH3EtiB1U+/A/fnHDH9LEERDOuvIG7g1m32Q6T6hHcxds9gV/DjGAGpodhdblpl\noSJbyLAHrZeXHnYm6poGJy+7LqAuBQwuERWP7pfc+eDS0NSr7mc=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.illinois.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.illinois.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category-support"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "illinois.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFMjCCBBqgAwIBAgIQYMsxBFaL4VIrCQq7BEyJHzANBgkqhkiG9w0BAQUFADBR\nMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSW50ZXJuZXQyMREwDwYDVQQLEwhJbkNv\nbW1vbjEbMBkGA1UEAxMSSW5Db21tb24gU2VydmVyIENBMB4XDTExMDgxNzAwMDAw\nMFoXDTE0MDgxNjIzNTk1OVowgaAxCzAJBgNVBAYTAlVTMQ4wDAYDVQQREwU2MTgw\nMTELMAkGA1UECBMCSUwxDzANBgNVBAcTBlVyYmFuYTEfMB0GA1UEChMWVW5pdmVy\nc2l0eSBvZiBJbGxpbm9pczEgMB4GA1UECxMXVXJiYW5hLUNoYW1wYWlnbiBDYW1w\ndXMxIDAeBgNVBAMTF3NoaWJib2xldGguaWxsaW5vaXMuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxTh8hEoHtkJbjyIQupE9iwe61WEH40uJzBCz\n2GD/6SfUN6Va4FhK2MUJmhgFsMrxVrfXuSLHBF4fpOcxRBtIhE9hoZ/WX1V3TOeH\nZhDIObn5OkgxtqoIiMcYB0D5GeUFI8V+6yqNPBlgwPYISXMj7x93UUV7akXJNLKa\nzjI+bKFdCkNOY11ntLJIkFZLBMTEUHi48XfPlxhMxk+s1BhoJo9ZX1RubjgzOx/8\nFXcu859akRXykJSsvG6+26uphT+VyDUxxjpVvj/NV7pQDqWqRkyoepIBiMvAG/cJ\n3VKLVPT1GWJoI16OVyVhVYGsV4PYf3fRCiV6JvbZrgmv/XIeMQIDAQABo4IBtDCC\nAbAwHwYDVR0jBBgwFoAUSE9a+i9Kml7gUPNre1Wl3vW+NF0wHQYDVR0OBBYEFOOa\nf63my9qvDEBHaiyFzGTeYvTkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAA\nMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjBdBgNVHSAEVjBUMFIGDCsG\nAQQBriMBBAMBATBCMEAGCCsGAQUFBwIBFjRodHRwczovL3d3dy5pbmNvbW1vbi5v\ncmcvY2VydC9yZXBvc2l0b3J5L2Nwc19zc2wucGRmMD0GA1UdHwQ2MDQwMqAwoC6G\nLGh0dHA6Ly9jcmwuaW5jb21tb24ub3JnL0luQ29tbW9uU2VydmVyQ0EuY3JsMG8G\nCCsGAQUFBwEBBGMwYTA5BggrBgEFBQcwAoYtaHR0cDovL2NlcnQuaW5jb21tb24u\nb3JnL0luQ29tbW9uU2VydmVyQ0EuY3J0MCQGCCsGAQUFBzABhhhodHRwOi8vb2Nz\ncC5pbmNvbW1vbi5vcmcwIgYDVR0RBBswGYIXc2hpYmJvbGV0aC5pbGxpbm9pcy5l\nZHUwDQYJKoZIhvcNAQEFBQADggEBAHLOK3mvT8PiRMV51+Z8xHAE/sIO7uA7rViF\nhNyAvFoEWYS5LWLcr8Nx2d7j3Y35hE2DLs2f8TY09bOr7z7pC9lvXrVfBTXUTClB\n4srZufS6CE3rkspEq5qBmqJddNv9w6JCIyY6EzMMcPDDrkrd7tIa9qGNJ7d6O6Cx\nQCHhgbQtYILegQAcCwyar56RF871YKDTrbVmcC6P4paZGheWYSpveDiXi08489F0\nIlH3EtiB1U+/A/fnHDH9LEERDOuvIG7g1m32Q6T6hHcxds9gV/DjGAGpodhdblpl\noSJbyLAHrZeXHnYm6poGJy+7LqAuBQwuERWP7pfc+eDS0NSr7mc=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.illinois.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.illinois.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Illinois at Urbana-Champaign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Illinois at Urbana-Champaign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.uiuc.edu/index.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Shibboleth Identity Provider Service Management Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth-mgr@illinois.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Shibboleth Identity Provider Service Management Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth-mgr@illinois.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Shibboleth Identity Provider Service Management Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth-mgr@illinois.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Security Office", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "contact_type": "other", 
          "email_address": [
            {
              "text": "security@illinois.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "extension_attributes": {
            "{http://id.incommon.org/metadata}contactType": "http://id.incommon.org/metadata/contactType/security"
          }
        }
      ]
    }
  ], 
  [
    "https://jabbr.ucdavis.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California, Davis", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California, Davis", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucdavis.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://jabbr.ucdavis.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Scott Kirkland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "srkirkland@ucdavis.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Adam Getchell", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "acgetchell@ucdavis.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://jabbr.ucdavis.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "JabbR Collaborative Chat Client", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDJDCCAgygAwIBAgIJANen0DCubGDFMA0GCSqGSIb3DQEBBQUAMCoxKDAmBgNV\nBAMTH2h1Z2htYW4uY2Flc2RvLmNhZXMudWNkYXZpcy5lZHUwHhcNMTIxMDExMTgy\nNTM4WhcNMjIxMDA5MTgyNTM4WjAqMSgwJgYDVQQDEx9odWdobWFuLmNhZXNkby5j\nYWVzLnVjZGF2aXMuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\noncKoZfTvuljnXWOq5Zp8Ud3mJ3tUehd4TUpaDnzqnWJjM3XeWutNSqFDDctBtFC\nJ1JFiGaCxwR1+xsW94CAa8yp8jbEDiSsfxxbzAdbrwccRItDdTB7QnxWXvvWIolk\nu86/CliLuprxJ2sSoUNvJJ76YWxQjEagxgw7XTucs34pCtksPZ2fdujdYh5telEA\nyNl3FmSDTHMj5Cnd7jHPMhAX9ssIhYZdjmYLCXpMCzzv6cEAjQY4nB9d2K9un/TZ\nFFH5THWmYTIkeF3is6jMCoajmIs4bZXAglr3fHvPLeTwQTvkYa+hFErbF7zFiet5\nuyatGrioEJUz3eYenVQu1QIDAQABo00wSzAqBgNVHREEIzAhgh9odWdobWFuLmNh\nZXNkby5jYWVzLnVjZGF2aXMuZWR1MB0GA1UdDgQWBBSrHCQS00L0JmmSYbRKmuIF\ngDbNRjANBgkqhkiG9w0BAQUFAAOCAQEAf5WSqhyPXjm8SeReeYIvzv+aW/gC/Tq7\nsd6YIVxABcwVjNzNSeKj0LUZ4GlaiQ5pZH0q9ElSuVko45izyPoUGQFpJdAZLO5b\nv+eGtwmZd07NQHlg1YX2ZaTTgZACJwURWEWoBmkfbBbTNr/YCzs0b+Ra5niLsn6U\n0g/Fc9T0gcUbH/akIynzlRRs38XB9fOCRx5QJgM5p0JtFz2I4k0LYHIRz1YJ6bwe\nY8SgFZAdahFs7LfRAbMZdeB+fy1HMehTqyz/nzexQrGL2yN8sQ0Vj9Mv4WjsTy4Y\n9NztXGlqzlb89qu1vezmYvtMjDijXV170bDdhiqSIZTx1humy4vGcw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "JabbR Collaborative Chat Client", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://stonybrook.campus.auth.edublogs.org/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Edublogs", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Edublogs", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://edublogs.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://stonybrook.campus.auth.edublogs.org/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "GB", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gb@incsub.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Edublogs Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@edublogs.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://you.stonybrook.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://you.stonybrook.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://you.stonybrook.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://you.stonybrook.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://you.stonybrook.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://you.stonybrook.edu/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "13", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://you.stonybrook.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "14", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://you.stonybrook.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "15", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://you.stonybrook.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "16", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://you.stonybrook.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "17", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://you.stonybrook.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "18", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://you.stonybrook.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://stonybrook.campus.auth.edublogs.org/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Stonybrook University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC+DCCAeCgAwIBAgIBADANBgkqhkiG9w0BAQUFADAeMRwwGgYDVQQDExNzZXJ2\nZXIuZWR1YmxvZ3Mub3JnMB4XDTEwMDYyNTA4MTA1MVoXDTIwMDYyMjA4MTA1MVow\nHjEcMBoGA1UEAxMTc2VydmVyLmVkdWJsb2dzLm9yZzCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAOaYDriYsPgqMP6ouII952HxrBuaeEiBOkU3Te5kYFv6\nB/EKWUbqpEXnC7FCx0H+nb1/LS4QcG0MPcIay/tNsm2YpiNoKy+a29f4uG7kVvta\nYV8UJc0BT00CHA3KSMuM00cFJkT2UxiY0YSP9Sgm5aZ8vZQYEE5trLyARIUM3J8A\na+q4C0bDxRCcf8fYA9YrobmhgKT8fuhkT3MvOnoiWG8TwM8DDpFn/YCxSS7cno7n\nbfc0BbQ5ca7bgGW2oB3jwjURG9ICddwMbOvQHq1j6v2nJFBZd0N0mzKdsVAl3wSO\nXq4nhk2U2GAbsMfLufOp83V0DiTjXat6m8NYi0sBvjcCAwEAAaNBMD8wHgYDVR0R\nBBcwFYITc2VydmVyLmVkdWJsb2dzLm9yZzAdBgNVHQ4EFgQUqgrJUTjleYcd5it2\nMBXfCp7Kw/swDQYJKoZIhvcNAQEFBQADggEBAC+00yHK1AF/hPIjDXk8QYoHWdPF\n+wG3MPe78x1eo2o+r24/1gBniHSaTyEgTlfSi6GJgZm/mR2nkc4B13ARXPORHM40\nMJQEam/7018/v38DBZjW514kjpxkw3RfSvfw5qDliMnLhMPUVd0eYdExzT1nLAAU\nXa6dJE/AGlotJKUdcVNCU+HdkUJ7YiJ8D9GOOrjxguDgvdv0Oea5WTn0StxVLsUH\nGzqBsxkby8F8ArSNnf61vvK6Ki7ayLDAF1eeLBFmAoEmA80xRhXHGvOPNYGyx9C0\nHqC5bwUfTUv2MOSaztChadCPF7WVsL2Rhp3bBKzxaBcVV1bwtWRbTQk5bXA=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:sn"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Stonybrook University", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://idp.sru.edu/idp/shibboleth", 
    {
      "entity_id": "https://idp.sru.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "error_url": "https://idp.sru.edu/identity/feedback.htm", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.sru.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.sru.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.sru.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.sru.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "sru.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Slippery Rock University of Pennsylvania", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Slippery Rock University of Pennsylvania", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDUjCCAjoCCQC4QuY3Kem21zANBgkqhkiG9w0BAQUFADBrMRQwEgYDVQQDDAtp\nZHAuc3J1LmVkdTEhMB8GA1UECgwYU2xpcHBlcnkgUm9jayBVbml2ZXJzaXR5MQsw\nCQYDVQQGEwJVUzELMAkGA1UECAwCUEExFjAUBgNVBAcMDVNsaXBwZXJ5IFJvY2sw\nHhcNMTMwNTExMTYyMjI2WhcNMTQwNTExMTYyMjI2WjBrMRQwEgYDVQQDDAtpZHAu\nc3J1LmVkdTEhMB8GA1UECgwYU2xpcHBlcnkgUm9jayBVbml2ZXJzaXR5MQswCQYD\nVQQGEwJVUzELMAkGA1UECAwCUEExFjAUBgNVBAcMDVNsaXBwZXJ5IFJvY2swggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQD3fFM/uu4LyqEZLgqHRAtVSfxK\nMdzmk5oQymQ+3wDlfZhZ4U37eJKxrUIQpJrYMpPaGavLqllWfT+YpAqai1L28W32\nWdhb3t4soeMZ0SqpDdwOjwhpi5BumTgxxehR0wTbnM1mce7Dcm97chv7S+6g00G+\nJracU4eavR5HYAe1VBCyL4pikCUAumgMTXClY/uUoIRQ8i53Apx3gAm1Yt5K+eiu\ngY78ImJS67uprvTsBn7jb3pUFhjMRVxhMhmZuYjapGraZn1TRtmDOjM6gJd5B7IS\nO/5e8sK6Pl1E2+z+R0ti7I/hsR0eZ4He4yMoCdFqqybaHHvANEfl6NFb97fZAgMB\nAAEwDQYJKoZIhvcNAQEFBQADggEBALgr/gAqImcBgGUln30vP7I7uCU9iyw/wZBr\nw4Kr5hszYbfoKk/UCpc84eyF2HOk4yfv5GJX7rcKbsz0frWSMt21LDLAytWrLktN\nlgJNjFcB0Sq5hCpIZ/nDbEveFJGw820KK4T1429H1WAzahf/Nu52kZOZC2nVahe4\n5lstrvfFwyPEE49TSKPh3wipsW0UTL262Smps/9tbPImBgVNEYfNHuwujNLuefAY\nFNTCh5GCTEEwP+oWWYizGWNo/1pJmSZZlvj/3d/JoNWbc+q2b3ig6FSTXkonXgdA\n+FrbfgLPw5cs4D4ECPBvlgj6hTbyG7HWRgT9XH6S67PDWvpvpWM=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.sru.edu:9443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.sru.edu:9443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "sru.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDUjCCAjoCCQC4QuY3Kem21zANBgkqhkiG9w0BAQUFADBrMRQwEgYDVQQDDAtp\nZHAuc3J1LmVkdTEhMB8GA1UECgwYU2xpcHBlcnkgUm9jayBVbml2ZXJzaXR5MQsw\nCQYDVQQGEwJVUzELMAkGA1UECAwCUEExFjAUBgNVBAcMDVNsaXBwZXJ5IFJvY2sw\nHhcNMTMwNTExMTYyMjI2WhcNMTQwNTExMTYyMjI2WjBrMRQwEgYDVQQDDAtpZHAu\nc3J1LmVkdTEhMB8GA1UECgwYU2xpcHBlcnkgUm9jayBVbml2ZXJzaXR5MQswCQYD\nVQQGEwJVUzELMAkGA1UECAwCUEExFjAUBgNVBAcMDVNsaXBwZXJ5IFJvY2swggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQD3fFM/uu4LyqEZLgqHRAtVSfxK\nMdzmk5oQymQ+3wDlfZhZ4U37eJKxrUIQpJrYMpPaGavLqllWfT+YpAqai1L28W32\nWdhb3t4soeMZ0SqpDdwOjwhpi5BumTgxxehR0wTbnM1mce7Dcm97chv7S+6g00G+\nJracU4eavR5HYAe1VBCyL4pikCUAumgMTXClY/uUoIRQ8i53Apx3gAm1Yt5K+eiu\ngY78ImJS67uprvTsBn7jb3pUFhjMRVxhMhmZuYjapGraZn1TRtmDOjM6gJd5B7IS\nO/5e8sK6Pl1E2+z+R0ti7I/hsR0eZ4He4yMoCdFqqybaHHvANEfl6NFb97fZAgMB\nAAEwDQYJKoZIhvcNAQEFBQADggEBALgr/gAqImcBgGUln30vP7I7uCU9iyw/wZBr\nw4Kr5hszYbfoKk/UCpc84eyF2HOk4yfv5GJX7rcKbsz0frWSMt21LDLAytWrLktN\nlgJNjFcB0Sq5hCpIZ/nDbEveFJGw820KK4T1429H1WAzahf/Nu52kZOZC2nVahe4\n5lstrvfFwyPEE49TSKPh3wipsW0UTL262Smps/9tbPImBgVNEYfNHuwujNLuefAY\nFNTCh5GCTEEwP+oWWYizGWNo/1pJmSZZlvj/3d/JoNWbc+q2b3ig6FSTXkonXgdA\n+FrbfgLPw5cs4D4ECPBvlgj6hTbyG7HWRgT9XH6S67PDWvpvpWM=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.sru.edu:9443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.sru.edu:9443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Slippery Rock University of Pennsylvania", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Slippery Rock University of Pennsylvania", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.sru.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Henry Magusiak", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "henry.magusiak@sru.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shibboleth-towson-horizons.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-towson-horizons.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Symplicity Towson Horizons", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID2DCCAsACCQD4SYQ36W+KZDANBgkqhkiG9w0BAQUFADCBrTELMAkGA1UEBhMC\nVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQHEwlBcmxpbmd0b24xHzAdBgNV\nBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xMjAwBgNVBAMTKXNoaWJib2xldGgt\ndG93c29uLWhvcml6b25zLnN5bXBsaWNpdHkuY29tMSIwIAYJKoZIhvcNAQkBFhNz\naGliQHN5bXBsaWNpdHkuY29tMB4XDTEyMDgyMDAzNDMwMloXDTE1MDgyMDAzNDMw\nMlowga0xCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhWaXJnaW5pYTESMBAGA1UEBxMJ\nQXJsaW5ndG9uMR8wHQYDVQQKExZTeW1wbGljaXR5IENvcnBvcmF0aW9uMTIwMAYD\nVQQDEylzaGliYm9sZXRoLXRvd3Nvbi1ob3Jpem9ucy5zeW1wbGljaXR5LmNvbTEi\nMCAGCSqGSIb3DQEJARYTc2hpYkBzeW1wbGljaXR5LmNvbTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBALqb+pkmMCgvj3Z9C9so2A1rtVPX3Xb533eOgED4\nv6vT0iUEkTtjUTG9s8wsw8IOHo87OIoZ5I+81BPIgyWBpHlgoLLm0ngyobEFp8wA\n67cDSyIsaZefx3hk3FQXXlaqr0ZcsL3to0V+W/jsDpugeGiQl3x0kx9sxU1dHQLs\npT+qssUij4QL1fxBBSs7Xca/cPuT6WCmyQxs8f48ANpYb6th0/ToDi/Hw7EwWR3R\nzvw2V4j2d8sicjrGo9fTglwd0Fkiu6hUgbJ8EKMbmp61MpV0JZeJKDFxEy/vR9iM\nZ3xCqFWMxx0NeiMH5Mm0P8kODLB6yISjgaTE0KWB/stHtksCAwEAATANBgkqhkiG\n9w0BAQUFAAOCAQEAec7isFmsfNrpZFzEC9qzb3LUGft+iZX1pF2BbUx/tk6jc3UP\nRDkrdng6jM/tQvWPYgqiNz5JD7B/65205wOfeg0tLsnNbhUKzyFlgBrBTAdQFj/r\nis8yF9e2Qz4d6mbKpNBA+dl6QFfz5rejaNPDz3TnUVwo71lu06QjWcFBnAG3eZ1D\nR3+wiTJJmh38dJkq4Nzs6csJPtcOKZgd7YpUiQibgxro/BVfx769MQ3rpYOu7fy1\nuBgW1aIV0asUVUTCQxhvsrkEV9BPO6pNeRw04PM0kAtXm63k7jAdbo3+No8xiWty\nedIfsZDWTiIm1VqflwgOfD50FnlOgrak9UY32w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-towson-horizons.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-towson-horizons.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://student.ohsu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "The Longsight Group LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Longsight", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.longsight.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://student.ohsu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Sam Ottenhoff", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ottenhoff@longsight.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "John Ansorge", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ansorgej@ohsu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Longsight Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@longsight.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://student.ohsu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://student.ohsu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://student.ohsu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://student.ohsu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://student.ohsu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://student.ohsu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://student.ohsu.edu/Shibboleth.sso/Login"
              }, 
              {
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://student.ohsu.edu/sites/all/themes/ohsu_blue/images/ohsu_logo.png", 
                    "width": "275", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "65"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "OHSU Portal", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJANVoFYcfyU7+MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHN0dWRlbnQub2hzdS5lZHUwHhcNMTMwOTExMjAwNTQ3WhcNMzMwOTA2MjAw\nNTQ3WjAbMRkwFwYDVQQDExBzdHVkZW50Lm9oc3UuZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAuDUPRJFGLDByLERWpvlFqmIyIXiRMcaiJ53FMx0a\nxLthOI3zNyWpuYk5xnjiTIhu7jZFFv3ZR3gyh4ZRmxePiHFXr7lmCkhjwD4GoZAi\nXI5QylZbu8lg6r90R6Lpj2vTn2kd2IXMCSNDJv0r7slmXEDLCX5BMe6oVnOtNs6S\nfmSHNfO1v4vuISgT/C7LmgS1wav7i1sZ/OsnamFgp9h7TZ0EISQy0+8lQOAPDHSO\nTG01UBaWMftlipM/QMrHe701e39Eep+r92BFYRMyvSIdmsLa1m4ucJnuimQASb7R\nDF7G7lDTDSJJOKXtzvrZp8e4sPw8BxI04KndQAk3I/fBvQIDAQABoz4wPDAbBgNV\nHREEFDASghBzdHVkZW50Lm9oc3UuZWR1MB0GA1UdDgQWBBTvbLKtjnLlGBRySbGU\nIkwwfzV1WjANBgkqhkiG9w0BAQUFAAOCAQEAOQ/e4BxpaFuGElkc7s4Co88cMzkn\nD6UpfEvjANVSdj3et6IBcR5sLZFkaXhVg+pjESRn2U3PcEuOggWsBgEQXwJAVi+e\nL7jfyd4oQM4zp5QtWy2JYIAmdPt7fyWDSoDxAWMaSC5PQ/Kx5zpzDq/7+PAgGRVn\nUbi1fPlWgV3DPOzqPW7qacthUQ1p1QKRGhIUC2a52GorqQBQE5kmZRVIqyqIkmbk\nf6HWZMraOxpE4l9/KQb44IABWmTIxkIs43tNYJHF+IijBLF16a0ixZcGXDJh3wES\nZlM4tN38iZXT0iCxvfLF5KByZsXwNhm2WpV3UslqHcDIjJ1ySK2Z97WwTA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:sn"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "OHSU Portal", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://studentonboarding.dev.clemson.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Clemson University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://studentonboarding.dev.clemson.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Kathy E. Wright", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kewrig@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Hugh B. Johnson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hbj@clemson.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studentonboarding.dev.clemson.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studentonboarding.dev.clemson.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studentonboarding.dev.clemson.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studentonboarding.dev.clemson.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studentonboarding.dev.clemson.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://studentonboarding.dev.clemson.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Clemson University Student Onboarding - DEV", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDDDCCAfSgAwIBAgIJAIB+6ql9AdcCMA0GCSqGSIb3DQEBBQUAMCIxIDAeBgNV\nBAMTF2RldnNpc2xpbjAxLmNsZW1zb24uZWR1MB4XDTEyMDczMTE5NDk0MVoXDTIy\nMDcyOTE5NDk0MVowIjEgMB4GA1UEAxMXZGV2c2lzbGluMDEuY2xlbXNvbi5lZHUw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDOyYKs+BR/DkQg7vlOC5S1\n0FG/ZXW40nqESz7/KT63SudticupFjiQ17RR8gHjzG/VoviYfXV76Ntg+08LWxcs\njRl47v5NrkVx1Zq+Mx9vv27EJQKci0S4JFpgPIj5mG8pFeP5yrQXxAf2lRsM4AP3\nBx9XHT3j0lUE6TKzDShWn9CWsIvj/DwfFZKUJcC/vyIkwxo0QiGdqKTYbX6nKJyw\n/lB/PNa+yB1H1s99SgPg2OwTRIUs/tRCWUBFXojSZjFM2w0A++tC+kdya+fqmszr\nyxAlToLVJnrORmIw+qjrKbc8dk8VeLaI9OtLcjf6k4n2w5LZDilhMyG33+ncy/Id\nAgMBAAGjRTBDMCIGA1UdEQQbMBmCF2RldnNpc2xpbjAxLmNsZW1zb24uZWR1MB0G\nA1UdDgQWBBQnk+lJUECkeSUo7Jj4KMHgOWMLajANBgkqhkiG9w0BAQUFAAOCAQEA\nthTKYkv9ZsGraM30o1FXQr6r/2pgMZ0uJDt8PkNsGDJ9fZ9uFHE93gCNcBRYv/v7\nTX+J2jc7KFUN853BvkPzuuUvDPaarMcB8bPbgQfNizgomXL4x59asF2L4ZpN/h9Q\nyKq516dcYs7Q16t4mVwRzPXfxiQA1tZhxFdpBP9fNwwu8sPZF3ra/PAHMi4xaNKq\n1Ybx7DTL3ZzKP8RmOv3Xuin3YNw05WZa3S1lH1TKju1LvUvPdJkBBk1u+09cOxUY\nJY9Px5rlQ6wiV5alflrzlvPGfupCL8ftWRUndbOWa1UFmbwQBJUauqYD13S2Ga3o\nFiLq72IiiNFnBj5fO9ToPw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonAffiliation"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Clemson University Student Onboarding - DEV", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://csub.academicworks.com/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Academic Works, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Academic Works, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.academicworks.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://csub.academicworks.com/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Help Desk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@academicworks.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://csub.academicworks.com/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "AcademicWorks - California State University, Bakersfield", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC+jCCAeKgAwIBAgIJAKhcDSF1XMh2MA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTEWlwLTEwLTEyMC0yMjEtMTA5MB4XDTEyMDcxNzIxNDMyOFoXDTIyMDcxNTIx\nNDMyOFowHDEaMBgGA1UEAxMRaXAtMTAtMTIwLTIyMS0xMDkwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQCuNlK6MlE9iScDtuLv1TqydzmyL5wG9UZZ5fRF\nqfaNxd4cxYh1rnguhG6Vl5RAsTG8M6GzxwF0Uf/NEjpXPc73bfZya1iEZJ05zq6h\n6pW9Y002w7WvZANj5qh8jF1KnwbctkCRZMPRtR17StmIfeHAHN6kM4J5HJbB2Gwh\nXxHF6K4oXI/vJoUFlTmiOwMm4SgNkpKsRxprnekJN7v339PYfUvKqIwzcPi0ehAy\nO00A/70zrlJChpxB4SpQIMhaWypyAE63Y4L2BJCflM3yYA3bzPPorolX3lgWdUCh\nrMBbGmCg7EAZT2Gi/slsTpXHiAwjfleSvVCPn0b19JGTlS9RAgMBAAGjPzA9MBwG\nA1UdEQQVMBOCEWlwLTEwLTEyMC0yMjEtMTA5MB0GA1UdDgQWBBSXTuMyUUaJ4buF\nIXqDca9Wros0bTANBgkqhkiG9w0BAQUFAAOCAQEALjFkCUjcoWFHuIqyDHk/DiwM\nsDgTqauQVWk3h+kjiBL9Wcc3ZpswsKG/L9lZrN876mzFDzVG5hO1o/rpvDjlmH+B\n3TzDkbI64UqGQILGtku7wpgUCOv4Vl233f7CGXT53ExWTvWxwSI95euSkT8AsD2P\n6BVdlmro3+1pNWr5vlFa9S/1NdTvQZIwabpjJhb7Z8kc5zoRUJtlk1dGtOHLw2OD\nZgrE+6qApYTZGdG2mDNxvmSqHnKWt3PqSUgkv7go/kp8khc4ynPLXONZrcRuAFPN\nUbgAJ/cbGoum4Mc7ow1kjUElIbxWNzGOgSH3OURsrcOm8IUJnMe3GqATmvUFJQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://csub.academicworks.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://csub.academicworks.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://csub.academicworks.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://csub.academicworks.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://csub.academicworks.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://csub.academicworks.com/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.indianactsi.org", 
    {
      "entity_id": "https://www.indianactsi.org", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://id.incommon.org/category/research-and-scholarship", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Indiana University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Indiana University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.indiana.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Anurag Shankar", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ashankar@iu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ganesh Shankar", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gshankar@iu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Anurag Shankar", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ashankar@iu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.indianactsi.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.indianactsi.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.indianactsi.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.indianactsi.org/Shibboleth.sso/SAML2/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Indiana CTSI HUB", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "The Indiana Clinical and Translational Sciences Institute (CTSI) is a statewide collaboration of Indiana University, Purdue University and the University of Notre Dame, as well as public and private partnerships, which facilitates the translation of scientific discoveries in the lab into clinical trials and new patient treatments in Indiana and beyond.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.indianactsi.org/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.indianactsi.org/privpolicy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://www.indianactsi.org/images/indianactsi.png", 
                    "width": "248", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "48"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFlzCCBH+gAwIBAgICAd0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MTIxOTE5MzYxM1oXDTEwMTIy\nMDE5MzYxM1owHjEcMBoGA1UEAxMTd3d3LmluZGlhbmFjdHNpLm9yZzCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMul91iK/w7aDZKx5qD5ncj2pEAsxl3a\n5xmeOjFwHrbDTiCq4wkuwDx32emekuz4oFgrdnzKqrCy/Kv72OeJkBdKVqj2kg8h\nBK/kC9+91+RidN7oGWphmt8ZdKvLv998rug0mdh+ES+IoaQymCNmRaKd0TuittMa\nqQfw1do+RG3/pLB1GLtZ9lOQFvi0Abl1ZM1861AHM0oEdCgSK/0SNkvIMedBhvKV\nWx51t3SAzC7FMeNoYS/WdGET64n5JbgM/XHtDrygFJHlc5o5wqfcZpwTLRgc/VmW\nOmPgSsye/GuAPwyswBVOys4QgZAsO8UVU/ter9y7zmrwAIwIer0+CEsCAwEAAaOC\nAqUwggKhMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQG\nCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUVc0P5TC7RiG0B2kh6olh2Enr\naZYwfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNV\nBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJ\nbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEE\ngaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUH\nMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2Jy\naWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0\ncDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNy\nbHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQB\nATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHgYDVR0RBBcwFYITd3d3LmluZGlhbmFj\ndHNpLm9yZzANBgkqhkiG9w0BAQUFAAOCAQEABAetPsUTDh95xPIA3vh2uXKuoI0v\nnjrqPfHBvwbZ+RRux13fM0+l7ng4s8Op0FULlC2RwQ7uUPU4u+qTA5t5jPZ3FzPA\nhGsgLga6w9YIFOBdkKCnQxdneh6HGnc/ZcG6rOPSUwCrnnqpJCjFylMEI5n/uxzZ\nvVMh7RYjumfslRomfbBoKERJnPGoOKTYXN8V6cOegd60PmHCqs8j2ouRPbO+tD+L\neA/PFu3zfbO40EMfRuExQs0S8qjh//kr6hy/RAafJKpYXyNv6qC1W5XyiYpN5rly\nPm8hfv13OrKqSIGFwX2uXd+aPQFntENO2+S9lTaIu1DMHAQPuFOiPUdBLw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE3zCCA8egAwIBAgIJAO8d6UMFIVuYMA0GCSqGSIb3DQEBBQUAMIGlMQswCQYD\nVQQGEwJVUzEQMA4GA1UECBMHSW5kaWFuYTEVMBMGA1UEBxMMSW5kaWFuYXBvbGlz\nMRswGQYDVQQKExJJbmRpYW5hIFVuaXZlcnNpdHkxDTALBgNVBAsTBFVJVFMxHDAa\nBgNVBAMTE3d3dy5pbmRpYW5hY3RzaS5vcmcxIzAhBgkqhkiG9w0BCQEWFGFzaGFu\na2FyQGluZGlhbmEuZWR1MB4XDTEwMTIxMzE5NTUwM1oXDTIwMTIxMjE5NTUwM1ow\ngaUxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdJbmRpYW5hMRUwEwYDVQQHEwxJbmRp\nYW5hcG9saXMxGzAZBgNVBAoTEkluZGlhbmEgVW5pdmVyc2l0eTENMAsGA1UECxME\nVUlUUzEcMBoGA1UEAxMTd3d3LmluZGlhbmFjdHNpLm9yZzEjMCEGCSqGSIb3DQEJ\nARYUYXNoYW5rYXJAaW5kaWFuYS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQDIBKwnepjt7lubme4VpYMtXvwEZp4CwhPI+d3/Y6JLrts8rjsCv14m\nS71KcQUcMFK+hlNaoByb7RYFW3CZa/7ZOyiHX/Jw2QjjfjO8CFVlTIP7iyRNQ7Ds\n+yHLTzI0vs2M5trF49V8ZdrZbKqzbAVenUnCltk639aV6aC3CQ6JUqFAWSjBSBNn\nuqAZVhbDkiCKr3is87vQnXB8/89k07rVr6bFra/sj4SMKti/+wKLmm/Nhj3ol2Jy\ndGz3y4xycvmvCh4Yc7QaAYk+GIjtfDkYktaDMn1aXn8NGe5XG9w6H+9emPdOodHP\nPQaSJNCTFein/marSOjzlH/j+08cV5Q1AgMBAAGjggEOMIIBCjAdBgNVHQ4EFgQU\nxi7A1Jrmm2tIaw9bEYZPD5nKlfYwgdoGA1UdIwSB0jCBz4AUxi7A1Jrmm2tIaw9b\nEYZPD5nKlfahgaukgagwgaUxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdJbmRpYW5h\nMRUwEwYDVQQHEwxJbmRpYW5hcG9saXMxGzAZBgNVBAoTEkluZGlhbmEgVW5pdmVy\nc2l0eTENMAsGA1UECxMEVUlUUzEcMBoGA1UEAxMTd3d3LmluZGlhbmFjdHNpLm9y\nZzEjMCEGCSqGSIb3DQEJARYUYXNoYW5rYXJAaW5kaWFuYS5lZHWCCQDvHelDBSFb\nmDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQBmGaZw7t9ms9G2tJ80\naq6if46VhYs3xDEO2BYGMYPRT+wlrRC3RdgtNBnzmGpWnkMmE55bGr2bQhiAmLan\n2Nr/sOHzofnCb2Ugmm2e4gNnbJkFvFxyRIPS09jxJVxe7P4qZwlFY5VBxpCcWNCR\noIO0d1+iVoLX86/oE5OGnL8efeLt01Lo1PW/Xev+6RqqD+/hFUt+7AYI08I/mdOp\nuaVofHplNMxdpovIjpnI6X9uwiD1HlQTexL73/UFxVyAPFv6aKvUlyc2QnY7SAvi\nWr6//y2YMx9SQ4JrxvgD+nxtlUqAg0jht3EBVTOsVAod0iv7GNGGiCPa1HZVXX3x\ng5qX", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "The Indiana Clinical and Translational Sciences Institute (CTSI) is a statewide collaboration of Indiana University, Purdue University and the University of Notre Dame, as well as public and private partnerships, which facilitates the translation of scientific discoveries in the lab into clinical trials and new patient treatments in Indiana and beyond.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Indiana CTSI HUB", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://nexus.wpi.edu/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Worcester Polytechnic Institute", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Worcester Polytechnic Institute", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.wpi.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://nexus.wpi.edu/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jesse Banning", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jbanning@wpi.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Nexus Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "nexus-support@wpi.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nexus.wpi.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nexus.wpi.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nexus.wpi.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nexus.wpi.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nexus.wpi.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://nexus.wpi.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://nexus.wpi.edu/Shibboleth.sso/DS"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://nexus.wpi.edu/faq.php", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "https://nexus.wpi.edu/about.php", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "WPI Student Project Nexus", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Nexus is a Student Project directory hosted by Worcester Polytechnic Institute for matching undergraduate students with faculty-sponsored research projects at our partner institutions.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEjDCCA3SgAwIBAgIJAIeNvppyO8UHMA0GCSqGSIb3DQEBBQUAMIGKMQswCQYD\nVQQGEwJVUzEWMBQGA1UECBMNTWFzc2FjaHVzZXR0czESMBAGA1UEBxMJV29yY2Vz\ndGVyMQwwCgYDVQQKEwNXUEkxDDAKBgNVBAsTA0NDQzEWMBQGA1UEAxMNbmV4dXMu\nd3BpLmVkdTEbMBkGCSqGSIb3DQEJARYMcm9vdEB3cGkuZWR1MB4XDTEyMDYwMTE3\nMzEyNVoXDTIyMDYwMTE3MzEyNVowgYoxCzAJBgNVBAYTAlVTMRYwFAYDVQQIEw1N\nYXNzYWNodXNldHRzMRIwEAYDVQQHEwlXb3JjZXN0ZXIxDDAKBgNVBAoTA1dQSTEM\nMAoGA1UECxMDQ0NDMRYwFAYDVQQDEw1uZXh1cy53cGkuZWR1MRswGQYJKoZIhvcN\nAQkBFgxyb290QHdwaS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQC1YU78kASvt6LmsyJCWUe8p2FLCPGB+xJbAkxbih4o/Azlfeo9x+emBlswnWyp\niQag5+XCLUr7xruLzRG8xLpRnUU7UMIiu73INOau1B3iVAlnnEWXrKjRWRaNBqxj\nmf6J+FFKndc9Q7aHwT3ASSp+ez/dlv553BlZmHu8fTAvdZUzZY8wtCM8+mrlVyEr\ndXkA60BjwNzMDkCgHzuirITz+2OQs8fX7fpRDZAU2QE9/hxlFKoA4IfSOOhkohwa\nkBL7Wt0McKnuV5zGS+LRXYQEkW8T92Z/EcfxTnA7hOgws0mG2m7wlZeod4H/NDcj\nK/1a0Iw9pCGws/nChN244S8JAgMBAAGjgfIwge8wHQYDVR0OBBYEFJQKqRAMVs24\n/buulI8vzLZR/fxoMIG/BgNVHSMEgbcwgbSAFJQKqRAMVs24/buulI8vzLZR/fxo\noYGQpIGNMIGKMQswCQYDVQQGEwJVUzEWMBQGA1UECBMNTWFzc2FjaHVzZXR0czES\nMBAGA1UEBxMJV29yY2VzdGVyMQwwCgYDVQQKEwNXUEkxDDAKBgNVBAsTA0NDQzEW\nMBQGA1UEAxMNbmV4dXMud3BpLmVkdTEbMBkGCSqGSIb3DQEJARYMcm9vdEB3cGku\nZWR1ggkAh42+mnI7xQcwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEA\nXAd/ACRsMu+HxDHgcf12+AV/mI1CaJSicZuK2rpxqKXgDIxx/KG8z0Q13t+XbDI4\ne7qu5VdU2mvvrakvToT6nf7s7qJtwgJ58iztVt5D/42xpjxz/6mLJ1sh/b2r5MKR\nxDciGhC8wtP+LU6TyF5E2UL2jmilo21npKCZGe36unWQ90qRyDPW8l85h2ZJSkcp\nde2t+2zwPiK/uG7wFnUMYkuH+UAwGIziInBKt9A//FSYMhGdqxVJrizl/59vOP5u\nsal2FLAvi3c2D8NxBk5TyR72pvd/34hGSPjavwvpSleUOmUTewBrY4ja8HunFgFa\nY8vSy9Q/48RlFoE0pIN6RA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Nexus is a Student Project directory hosted by Worcester Polytechnic Institute for matching undergraduate students with faculty-sponsored research projects at our partner institutions.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:sn"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "WPI Student Project Nexus", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shib.bu.edu/idp/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Boston University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Boston University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.bu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shib.bu.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "contact_person": [
        {
          "given_name": {
            "text": "BU IT Help Center", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ithelp@bu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "BU IT Help Center", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ithelp@bu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "idpsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "bu.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Boston University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.bu.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.bu.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.bu.edu/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDFzCCAf+gAwIBAgIUe//QyolSjXGskJVe42L94YYJ7rswDQYJKoZIhvcNAQEF\nBQAwFjEUMBIGA1UEAxMLc2hpYi5idS5lZHUwHhcNMTEwNjIxMTYwMTQ5WhcNMzEw\nNjIxMTYwMTQ5WjAWMRQwEgYDVQQDEwtzaGliLmJ1LmVkdTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBAJMwoK7RFLBGDxf9l3FSw+KPpjXTDFc7gPrEqNFi\n9dSgn7MSLBUoXRDkDquuVUgXPwZsaoKdkS2U7SelLJlUgn+/n3BuTI3o4el7k+5p\no14VxS3XLADqKlNcQ5O7EP5fhOpx6WIbEWl25I3urDD7Q73cEOskzW9i/Du+xxs2\nS+s8xLalhhHmsmNUS1646CisfLU7+07VnwfN9uQqWoPu16aBqqRklAHHvXmZXV03\nzKNJuwTQWkLZ2q1Zv8i+S4O/viZylTvqR1AgtEfNv6MXST6v/4g1Ymq0atckPCsc\nx2hmOQo4zuDua42lvKyYh1enVviu6okydt/0vL1jtnGA/EkCAwEAAaNdMFswOgYD\nVR0RBDMwMYILc2hpYi5idS5lZHWGImh0dHBzOi8vc2hpYi5idS5lZHUvaWRwL3No\naWJib2xldGgwHQYDVR0OBBYEFAeldMor+2SpjIAE1QpLTkcGsHKcMA0GCSqGSIb3\nDQEBBQUAA4IBAQBOBkJybdEPPbufV795YrqaCAblz3nBZK4MhA6FrRc6hAuia9EB\n9qi0v/TgPFfJ1NpAk4DnRFgmhN4rE7yEFQNeF/6QKf6EknfOYO48J1yMe0gT0aoM\nedMjBzWMvyKaCOJbXcEYcgCKgL0lZ0r8Tiv94Zn9DEvYvox33742MAAImQQQ8FdK\nN5TIK/J7ALA8/xVFgo6XluioA6DYDq7CrJUPrc6LEDApexF5i7pyns7FV+d3EzlF\nTazioztaYa7yyphC1XgYol9So698mI3wfTQz9QEA6E9iuayzj+kJU7QAQ5pdA19w\n5cQaCFdIkECu3Ruv8jGs5oF5Zo37L1gK2j11", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://riceuniversity.us.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.qualtrics.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://riceuniversity.us.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Michael Page", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@qualtrics.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Qualtrics Labs, Inc.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFbDCCA1QCCQC8OqKPlGUkRDANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJV\nUzENMAsGA1UECBMEVXRhaDEOMAwGA1UEBxMFUHJvdm8xGDAWBgNVBAoTD1F1YWx0\ncmljcywgSW5jLjEgMB4GCSqGSIb3DQEJARYRZGJhQHF1YWx0cmljcy5jb20wHhcN\nMTAwNDA3MTkzMzA0WhcNMjAwNDA3MTkzMzA0WjCBhzELMAkGA1UEBhMCVVMxDTAL\nBgNVBAgTBFV0YWgxDjAMBgNVBAcTBVByb3ZvMRgwFgYDVQQKEw9RdWFsdHJpY3Ms\nIEluYy4xGDAWBgNVBAMMDyoucXVhbHRyaWNzLmNvbTElMCMGCSqGSIb3DQEJARYW\nc3NvYWRtaW5AcXVhbHRyaWNzLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC\nAgoCggIBAM7T6YYEDd91lehKK/51V3Li6zk/wqHZ1OZ4rHw22AtTasl0qrEwdXbL\nsCUmO4rEXhAnjgpIZPFHs+1sFpSCalerYa+ROJX5B5N9MnENYr6E8KHa8spbVBEl\n2/ZE6RlPdHBs+iCDuoTTqOa2sZ8vqTpTF3grVdgeW3KfBOO9yENa04lA6xhPAQs3\nkihDQvPoWnlXtQA3gmtb+sGZmKYXonBVwIDsrDbhpoFcHJJRrFEEawSHOI3IeHBo\nhR1jhfb95E3cQ0s7gQ+FbR+lkzwb3i3WrCkZr3w2KpudJEzy/kT7JBLvfELW8eR4\nj2XRKyRhxNHOKc/AC8fNIrGam0CAqK9elpJnB6zmALQUYXVGddv3sd9ITIfZQ9Ox\ng9ChVqsNAY6VIlg5+/Q3Ega+BR/P/OpMnG9xW+cyLslzjiUf4c0K6I2pObcJkJMw\nqGHOSbD9lGa/WxaEAFC1+6oDNRbC3S2mbo4gW6LPVbtCxC0IMxOyaOKBwe3sW9v+\nrumd02ZuJRtbTbarde7N6aUmm2hXfDQntCIXWUJ+9b+YvjcWUlUN0KvVq8jFn1Z7\nkD1po2eY+lc9VHYoh1jdP08G9H8CZdJTDwR4KDPG0U2rD+xXmxO+9CEeQev1d/Iu\nqcadQxRka7hbhIijtVJgjO3jP6AwiHXFGpBvApyIuuXJU8CyKSsXAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggIBAAcXtiFXJ5Vm0mwhiDRoTGwIGz+Ryg13X6X9w6GfVENt\nNexDExwzPgxnW1gG7u9FUx2tl2geZ8BJOqk3pGnLSZI4QF/nVnB+hTPMLOwXjtMk\nMF5FXlM7QvOKOTzzK7+2wug2ssZi5ZpQVGODhPsytu+GjMJwydLj6RRAnJV/9wmu\nivZhIbQyrOs0XBxuYO0n9OzlOa9JVFtUxnckT93UYIjcCVEu2r+m20Zm8BEofKTr\nTz3vodizFV5uHbmQ19iLxDrZsu9rbpEHojWMgnKnq1XoC7TmlxB1/OQctUnjpRPT\nWySZkTdWX4cKBjQHzCHJyl0Z4hAP4m3fWFLXVK3w8U1e+Mbfm0jUT9+amUfdzL+8\n9ZjwnFvpuFNWsS33yYWp51+rVdtU0jYII1f8XWNRn4EV54MwoOWrEXKDZ0qmbxi5\nnVR/F5QofEGv/ZYMgcFaX5OMP5lRE8IjQu9Eq26zZA6YuR5fZfiTHZppwc6Ey9Zc\nGpRsLwFSwma0/Vtlfxr/KtaKsk2zlOOJ6RF33MUyZvw8N+tybY0yHJ40aBZKFr9r\nr3j//DUU8zi4qvNP5z19kS08sZ7mtNK2sKBPWVSYB2HDtyrBSRupHBYeIxlfGKd6\nuVUusHTyyVjDKbuMHCw+DEp0VXmCIAv5Jf+SKZ7DOkw8cxcdL67gEc9NjAmsfmKy", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://riceuniversity.us.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://riceuniversity.us.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml1-acs.php/default-sp"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://abroad.lsu.edu/sp/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Terra Dotta, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Terra Dotta, LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.terradotta.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://abroad.lsu.edu/sp/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Jason Johnson", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jasonj@terradotta.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://abroad.lsu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Terra Dotta Software SP for Louisiana State University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC4jCCAcqgAwIBAgIJALldpggjWmriMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCTE4OTYxMC0yNDAeFw0xMzA0MTAwMjU3MTJaFw0yMzA0MDgwMjU3MTJaMBQx\nEjAQBgNVBAMTCTE4OTYxMC0yNDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAPZ9So31RPtzb0EFP8tWOhnjKXaKe9IBO175r12EM9bMUNBLgAtfYH49qoea\nDD+/eG988zmZA8ixxZsPUrFR7qi7PJXW5c5iBqZDKPvO3HWBi3cMBoBnWn4zEU9r\ncb/AzMMFjn/0/4yilRmuRCOoiLUH1FcDwQcKhwwqNZiZBQ2tREKiTlcEVzQaOzLJ\nrAPgFZaE/nJzCI5KKWgT36wrbHcqGM4c/dIvwXFyGne2N3BXmRefl6s+wdAEPRPx\nhcqgqekaBYZCF5Og1UnLH0oOZqn0OIAFqtR7pyxxQjF+oZTnBi+LNOB5QF8q7Rd/\noUFh7ZA3HJjy2IZzCG7WttoNx5ECAwEAAaM3MDUwFAYDVR0RBA0wC4IJMTg5NjEw\nLTI0MB0GA1UdDgQWBBQMICIjrW9osFKSLrfuCIpPThXzGzANBgkqhkiG9w0BAQUF\nAAOCAQEAuoFcI1J3tuZ03o1yAWihDNDNFANxlLTc3swxpnQ5+UJmN9/C0t0Gjx5V\n5PWon/+NNXqwP60TrTL+ZeGYVpH0hn4E6iZqCH6vgT1+tiMkOUJiWuo3d3ObCsym\nrp030CFc9DcMSyrQxZpDkQ8FOeJi7R/td1qloHujNVuAXOgdf9Su8vXLA8Xv/2pZ\nlmAD/jn7hhQUpwPhO+7OrBqZVxbFg/twa2l9pmOd2ZrY+KNoUApITDcIHXKsjkeq\ntsESY0foXrbIo7/lqaHpKtbQtTZu6Ik+uBWEoL16okV//gouO/ZtCLAxuUHWXZ41\n3p5sQ6ShQElMY9pzRJ/aza/3I4ySXA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://abroad.lsu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://abroad.lsu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://abroad.lsu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://abroad.lsu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://abroad.lsu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://abroad.lsu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://comanage.psu.edu/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "The Pennsylvania State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Penn State", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.psu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://comanage.psu.edu/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Chris Hubing", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cjh@psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Phil Devan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "pmd@psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Rich Cropp", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "rac@psu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://comanage.psu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://comanage.psu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://comanage.psu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://comanage.psu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://comanage.psu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Penn State prototype COmanage instance", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFNjCCBB6gAwIBAgIQEqyrTGzYSsT1F3RqaMChtjANBgkqhkiG9w0BAQUFADBR\nMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSW50ZXJuZXQyMREwDwYDVQQLEwhJbkNv\nbW1vbjEbMBkGA1UEAxMSSW5Db21tb24gU2VydmVyIENBMB4XDTExMDgxNjAwMDAw\nMFoXDTE0MDkwMTIzNTk1OVowgasxCzAJBgNVBAYTAlVTMQ4wDAYDVQQREwUxNjgw\nMjELMAkGA1UECBMCUEExGDAWBgNVBAcTD1VuaXZlcnNpdHkgUGFyazEqMCgGA1UE\nChMhVGhlIFBlbm5zeWx2YW5pYSBTdGF0ZSBVbml2ZXJzaXR5MR4wHAYDVQQLExVF\nbWVyZ2luZyBUZWNobm9sb2dpZXMxGTAXBgNVBAMTEGNvbWFuYWdlLnBzdS5lZHUw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDvarcY2cp4NplMtUjmiMG0\n8EvluHCnUMgqp6Hrn9hrJ8VJj5hLIsiJqnqzX0JrjL6IdLw8RFL/vR40TdHJccmL\nNwzL2+lmzcx5axUAoPiKzDak/V50H7NAZrKxkpBrcDFSwdlqZMHyZreKQ3V5HZdY\n4ggyLHUgggYOFM+uNx7p6Qzkerq/nYuM23FVDN8phnGTMZL5RxBMJDRpLSqW3tAL\nqnz+ocgntS3z9zCJ/7AzjIry0YV3ikrs/IHyEXovhFaUlB/2sKvBVkSinWueUepp\nc0En7Dq62Go5EcRZrokzzSbNei6Y3JVldrcQzhBDLz0W5HTdxP1CUjhPox/8Yebt\nAgMBAAGjggGtMIIBqTAfBgNVHSMEGDAWgBRIT1r6L0qaXuBQ82t7VaXe9b40XTAd\nBgNVHQ4EFgQUYbASm05zJYjt/1XG5GBQzAUqKP4wDgYDVR0PAQH/BAQDAgWgMAwG\nA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMF0GA1Ud\nIARWMFQwUgYMKwYBBAGuIwEEAwEBMEIwQAYIKwYBBQUHAgEWNGh0dHBzOi8vd3d3\nLmluY29tbW9uLm9yZy9jZXJ0L3JlcG9zaXRvcnkvY3BzX3NzbC5wZGYwPQYDVR0f\nBDYwNDAyoDCgLoYsaHR0cDovL2NybC5pbmNvbW1vbi5vcmcvSW5Db21tb25TZXJ2\nZXJDQS5jcmwwbwYIKwYBBQUHAQEEYzBhMDkGCCsGAQUFBzAChi1odHRwOi8vY2Vy\ndC5pbmNvbW1vbi5vcmcvSW5Db21tb25TZXJ2ZXJDQS5jcnQwJAYIKwYBBQUHMAGG\nGGh0dHA6Ly9vY3NwLmluY29tbW9uLm9yZzAbBgNVHREEFDASghBjb21hbmFnZS5w\nc3UuZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQAyW+oDkDE6SUovM1xj5/Y7xdadeUDs\nq915LhD3NVqxCn8iyQ2iJxOaqaF+xsc42mmsL8BGzvg/uBkrFVbDKF2jDYHqcFdK\nqB/tGS7Q4nkwP5h+phLuRisxt7Qt1dOxJpN61gW6Orv2L7iO4ZKLeMA1ljunfx2F\nNsbLbnDB0wYzb+2jkxKIAODydN1UGpybIYZIcSJzLZkxLxkejoXXYaVF/LQIxsCT\niMsPxFzd+wsTkuE+tg81Z/YFbkMMItDiQLNJC2axQ/llHQZtbXpCNdgrR6eBxz1Y\n3m8xCq34O2Os6aSJTEAvxHZ5wE7I88iIZp68zudQHJqCAzBpkxtlGG23", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Penn State prototype COmanage instance", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://students.heinz.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://students.heinz.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Robert Taylor", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "rttaylor@andrew.cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://students.heinz.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Heinz College Student Access", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDCTCCAfGgAwIBAgIJANjCH53s/64YMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFnN0dWRlbnRzLmhlaW56LmNtdS5lZHUwHhcNMTMwNzI0MTg0NjU0WhcNMjMw\nNzIyMTg0NjU0WjAhMR8wHQYDVQQDExZzdHVkZW50cy5oZWluei5jbXUuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzqefs3Iu2MaUzJxRdY9RIVPO\n/7Qb/uv/RZkr7V+vzwThH+IKB1b6co2NsfnBc8Bbe66JYDwMAAEbqCqONibFiN+T\nD9KTzmPq8kDCCWyyLzXHNszCTLXos5agRRLW7ai6TWfstxe0YHmDcMLDyfvXZg0A\nZ1LU4e+vC9qOEfbYjQg5TiHSllx4HfAnrV1wn2LQTwfw5N0bbyrpiMV89qwEzP07\nGKTNz8wG8ZetW1YkLbo8V+m8cgV8eJdiUn33KnM1uvicJKpucOkzu6JzWwhL8P74\n5APTfVd+t2SJReB719NFORA3muv4XOtEfKNL6Xvu3AjDgPbUTfp61bmwsb+WfwID\nAQABo0QwQjAhBgNVHREEGjAYghZzdHVkZW50cy5oZWluei5jbXUuZWR1MB0GA1Ud\nDgQWBBQgEt8/AK6vd/mFVLRv8C5cJwQMITANBgkqhkiG9w0BAQUFAAOCAQEABbN6\nzhexhWVFiIoym7WLuBOg8m+tm5fXHadAcrPwH9EtSiDRBcdz7Dl/NkbUVxQXXIDe\nSkDB1V/Apl1BqnkV/dbPymxYAOWN7Ol6emn4G8VQVp1irmlpT+XonXQXZF1Xvlh9\n/l44cs8lfUhnpVSP/tDMqo6Un6BGHz8sDMsa44FGCEf5wt+KptHDTnFv1iWOWyyo\n7AXFoR7f2yUg1BIWzB+bv5izIZqhqlMY0NMnSpGpjFTuwktXDnc8Y8RLnKZIWV83\nB+ODVgUojteDcGLcUOPD+/9gnBbvEgWqRJ7sS9hN3sfc5zr6wXOQI2Go2pn+p1iY\nq3I+8QjnS6q+8ueTTw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://students.heinz.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://students.heinz.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://students.heinz.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://students.heinz.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://students.heinz.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://students.heinz.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shib.ou.edu/idp/shibboleth", 
    {
      "entity_id": "https://shib.ou.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ou.edu:443/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ou.edu:443/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ou.edu:443/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ou.edu:443/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ou.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "University of Oklahoma", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAigCCQDc5lzkFlIc/jANBgkqhkiG9w0BAQUFADBiMRQwEgYDVQQDEwtz\naGliLm91LmVkdTEfMB0GA1UEChMWVW5pdmVyc2l0eSBvZiBPa2xhaG9tYTELMAkG\nA1UEBhMCVVMxCzAJBgNVBAgTAk9LMQ8wDQYDVQQHEwZOb3JtYW4wHhcNMTExMjA5\nMTMwMzM3WhcNMTIxMjA4MTMwMzM3WjBiMRQwEgYDVQQDEwtzaGliLm91LmVkdTEf\nMB0GA1UEChMWVW5pdmVyc2l0eSBvZiBPa2xhaG9tYTELMAkGA1UEBhMCVVMxCzAJ\nBgNVBAgTAk9LMQ8wDQYDVQQHEwZOb3JtYW4wggEiMA0GCSqGSIb3DQEBAQUAA4IB\nDwAwggEKAoIBAQDWSD/N2sPHJ2Sg//K+mVAi6Oep5tXdxsmVIC6jegFaQVHSYpL8\nGPULb89CyxekyjMIkNfXOnh9Ycfw+PgOVIspVejmdFyM9O9Lp7XYgG4xi9RwL406\nsbIbVUx74HPGAbp/z6XQqus4TemAeJlfzvlRsmwQkiC4IU2iUc0vM8X2OnXGcQ1M\n1nf/lRDYjxFeeSFFKv/SSZQgApXiORb8BgOxJTP2huppWiq+JAX5dSLArlZPfZTE\nA81ULTd0D9HFsViThTb426UHR1CvuUbfb+saA65WWk9s1jLFD5omksXGP0qkglPV\n+rrc+MbQltnM3arxyFSEfm2nvNqdVStbt+M7AgMBAAEwDQYJKoZIhvcNAQEFBQAD\nggEBAJJsqc/AA4p+CPPKnQnQoU0uIUt6V9IBuk6z3JjXPjy5gFYtLJ7RBslMui8x\nwhi6eTdUdHpASv7T7WKBBKFSA/NeiZ3TCpYMmdQsPdznzsVS/wsD+pU4PALCfqd6\njJ9ntDEDOezYSTxAdbU8KmPxb5VZr7QseHAtf5OwZQI5131bVjkIjcM8pH4Sx2gk\ngyHNLf2byp1u1gSTRBbC8m1bESeQRTphQtsM+o3m6JUR3k9bV2tfgXLV8zaFWWuM\naQgoBThl3ubE6tZmNvkC76OAzv+E+bRNfLV9lm+5Y66Ar9rSQHKur9xGm59GtmI/\nGhy0tfpx50Ku5N+Baf2OZmHjuv4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.ou.edu:9443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.ou.edu:9443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ou.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQDCCAigCCQDc5lzkFlIc/jANBgkqhkiG9w0BAQUFADBiMRQwEgYDVQQDEwtz\naGliLm91LmVkdTEfMB0GA1UEChMWVW5pdmVyc2l0eSBvZiBPa2xhaG9tYTELMAkG\nA1UEBhMCVVMxCzAJBgNVBAgTAk9LMQ8wDQYDVQQHEwZOb3JtYW4wHhcNMTExMjA5\nMTMwMzM3WhcNMTIxMjA4MTMwMzM3WjBiMRQwEgYDVQQDEwtzaGliLm91LmVkdTEf\nMB0GA1UEChMWVW5pdmVyc2l0eSBvZiBPa2xhaG9tYTELMAkGA1UEBhMCVVMxCzAJ\nBgNVBAgTAk9LMQ8wDQYDVQQHEwZOb3JtYW4wggEiMA0GCSqGSIb3DQEBAQUAA4IB\nDwAwggEKAoIBAQDWSD/N2sPHJ2Sg//K+mVAi6Oep5tXdxsmVIC6jegFaQVHSYpL8\nGPULb89CyxekyjMIkNfXOnh9Ycfw+PgOVIspVejmdFyM9O9Lp7XYgG4xi9RwL406\nsbIbVUx74HPGAbp/z6XQqus4TemAeJlfzvlRsmwQkiC4IU2iUc0vM8X2OnXGcQ1M\n1nf/lRDYjxFeeSFFKv/SSZQgApXiORb8BgOxJTP2huppWiq+JAX5dSLArlZPfZTE\nA81ULTd0D9HFsViThTb426UHR1CvuUbfb+saA65WWk9s1jLFD5omksXGP0qkglPV\n+rrc+MbQltnM3arxyFSEfm2nvNqdVStbt+M7AgMBAAEwDQYJKoZIhvcNAQEFBQAD\nggEBAJJsqc/AA4p+CPPKnQnQoU0uIUt6V9IBuk6z3JjXPjy5gFYtLJ7RBslMui8x\nwhi6eTdUdHpASv7T7WKBBKFSA/NeiZ3TCpYMmdQsPdznzsVS/wsD+pU4PALCfqd6\njJ9ntDEDOezYSTxAdbU8KmPxb5VZr7QseHAtf5OwZQI5131bVjkIjcM8pH4Sx2gk\ngyHNLf2byp1u1gSTRBbC8m1bESeQRTphQtsM+o3m6JUR3k9bV2tfgXLV8zaFWWuM\naQgoBThl3ubE6tZmNvkC76OAzv+E+bRNfLV9lm+5Y66Ar9rSQHKur9xGm59GtmI/\nGhy0tfpx50Ku5N+Baf2OZmHjuv4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.ou.edu:9443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.ou.edu:9443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Oklahoma", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Oklahoma", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ou.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "David Horton", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "david-horton@ouhsc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Aaron Bighourse", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bighorse@ou.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "given_name": {
            "text": "Pat Amburn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "pat-amburn@ouhsc.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://fresca.calstate.edu/shibboleth-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "San Francisco State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "San Francisco State University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.sfsu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://fresca.calstate.edu/shibboleth-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Andrew Roderick", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "roderick@sfsu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Taylor Judd", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tjudd@sfsu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Fresca Helpdesk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "csu.fresca@gmail.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDADCCAeigAwIBAgIJANAe0RIIzcs9MA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE2ZyZXNjYS5jYWxzdGF0ZS5lZHUwHhcNMTAwNDE0MTgxMTI0WhcNMjAwNDEx\nMTgxMTI0WjAeMRwwGgYDVQQDExNmcmVzY2EuY2Fsc3RhdGUuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApc3Cx3nEafgzYXDHchPQQDCs0MsewpCE\n3EDwmnWF8Y+MXuGQ8n35eAnZ+bcLIOIRBepcom2ON3eaEzgY3LZOvePr1nVRLHdL\nvoK89EUkL4Sfeg58FpIqLPOgEuNQs+cML0na+mv+E/UX5OFnX+0ihNTQSL5bSl0v\n/ePokwmaX1gk0K6mO0zCaYOBPAGQ2k6wRQL5HjpNTgDSflx8qfTe2GLR1zuawvaj\n7TMJBwt65fI2k/dOfQ68dlDkahm0Nzq+L+xsAUwLX2XTzPf2Y6bvPPvb9va6J4bu\nM5XbCFhx25wbGSKQz5/N53XuEp1hC/KzRMn6RuXnmCDiWafEA6s8PwIDAQABo0Ew\nPzAeBgNVHREEFzAVghNmcmVzY2EuY2Fsc3RhdGUuZWR1MB0GA1UdDgQWBBScr1Bw\nG6kvU27MXO07Q7pQZwBApzANBgkqhkiG9w0BAQUFAAOCAQEApOzRghL6rftm4UQ7\nqS2hb394yvGD35ZUux6TJJbFJ+Pc0F06r3Mgl41JTsZEVtMWeVzkcptY4k/7mN3a\nzE+aY+v4q6ep+Uc7zeYlUsWLRWQ8wJc+b3trQ7xpotYGRjrjVD0r5pPosxRtSJlN\nvGeWxBIZKQ98StYgDJ6YXGL4InXWzqVB+iY1YyBxiSzp/nYzACSEJnNqwD0p1sXv\nv7muibgldi6r8/ratERC3uLb/f6P08AZ3zg34C0Lnmh4/sVKTLvG/4lYUOnW7+J9\nc1TXM5BnvF0EpTeWeRudd4C0W2XLi10+kCuT5zizuWi4bcov9NWODFzDYbY+YqHf\nq4fKLg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fresca.calstate.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fresca.calstate.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fresca.calstate.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fresca.calstate.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://fresca.calstate.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://projecteuclid.org/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Cornell University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Cornell University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cornell.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://projecteuclid.org/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Shinwoo Kim", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sk274@cornell.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "David Ruddy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dwr4@cornell.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Martin Lessmeister", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mhl10@cornell.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://projecteuclid.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://projecteuclid.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://projecteuclid.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://projecteuclid.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://projecteuclid.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://projecteuclid.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://projecteuclid.org/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Project Euclid", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Project Euclid (http://projecteuclid.org) is an on-line publishing system for theoretical and applied mathematics and statistics.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://projecteuclid.org/DPubS?Service=UI&version=1.0&verb=Display&handle=euclid&page=about&aboutPage=about_mission", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://projecteuclid.org/DPubS?Service=UI&version=1.0&verb=Display&handle=euclid&page=about&aboutPage=about_privacy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "lang": "en", 
                    "text": "https://projecteuclid.org/collection/euclid/images/logo.gif", 
                    "width": "200", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "70"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDNjCCAh6gAwIBAgIJANq1a2ZDBykIMA0GCSqGSIb3DQEBBQUAMDAxLjAsBgNV\nBAMTJXNmLWxpYi1hcHAtMDA4LnNlcnZlcmZhcm0uY29ybmVsbC5lZHUwHhcNMTMw\nNTMxMTUwNjIyWhcNMjMwNTI5MTUwNjIyWjAwMS4wLAYDVQQDEyVzZi1saWItYXBw\nLTAwOC5zZXJ2ZXJmYXJtLmNvcm5lbGwuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOC\nAQ8AMIIBCgKCAQEAs3Hxfw7oGscg+A30MSnTHdbuukajMhIlCtrm+bfsayPDApUE\nQLxW643U876lLNxMA5wmU0NV07gjj87yqv7ECGPLq95tIoTcTzI0MXLr8s3GTzwT\nM9N0LEWdp37CRH2kgvYA3Cf5Oba8FxpEDHgc6rzAc2LccucdpWvi8Zon9OLZuEsH\nqAjQlfIeuSB7YIe6z2/7VbZM9CcAb80cwYButlqMdIOcS7jBqofGq9YvovXJr7F0\nvEXJtiL7fW28Lmv2SHdS2mL/34ud2fj5CEDaXAzKWCiDR0L7a1qYNW7upxD+w6no\nrDAYfWrO8E6mcXv1d8P1JKLzsaZKopsuHE3BtQIDAQABo1MwUTAwBgNVHREEKTAn\ngiVzZi1saWItYXBwLTAwOC5zZXJ2ZXJmYXJtLmNvcm5lbGwuZWR1MB0GA1UdDgQW\nBBSu8boXmoNWqSqD0y4uSmiE8p1EHzANBgkqhkiG9w0BAQUFAAOCAQEAQXOGXl4Y\nfTXnrJQuD1xaOmLgUkLpN4eq89OisGTsdefpvAJ1SD6QSaIj1UFchfQ6Qb4vK2Fp\nE1Ss6sZNU0rCE/C1EpQplAkQve8+IhQdIOQM7B/Yp4lHWd+3snJLF+fmIczVu9DB\nodqQ2YbmpxPDBzZMRAIppajebSXLz2r65Uj8+cB28v4WhCt7v/T3M8w4h591pePO\nxW2fpyIqGsGpuVRd2EOkYGmm7nqrAH9WGyUsRT1YHFY25mjgExVPYpah7eTsNYql\nfQHR5b61zSESkl8vo6eFRgzRnETr/fNIj08nhs3UCEfuYVy1yVKv2lHLzIvDTot/\nTyOzJ1GTj16SNA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Project Euclid (http://projecteuclid.org) is an on-line publishing system for theoretical and applied mathematics and statistics.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Project Euclid", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibprodapp.loyola.edu/idp/shibboleth", 
    {
      "entity_id": "https://shibprodapp.loyola.edu/idp/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibprodapp.loyola.edu/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibprodapp.loyola.edu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibprodapp.loyola.edu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibprodapp.loyola.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "loyola.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQzCCAiugAwIBAgIUWLSGsZvWl23rl/5DUpC+PY0gdCowDQYJKoZIhvcNAQEF\nBQAwITEfMB0GA1UEAxMWc2hpYnByb2RhcHAubG95b2xhLmVkdTAeFw0xMTAyMTcx\nNjUyMDVaFw0zMTAyMTcxNjUyMDVaMCExHzAdBgNVBAMTFnNoaWJwcm9kYXBwLmxv\neW9sYS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCQk81WTkU5\n3/Uns2puutfJt6fcr6cp8g0PLhU7TdS824eRZRquLENS9zP8Qutne8pziezilohM\nM+iDrOcqfyjXTG/NZYkzNy7pbx31YYUYMsEvP5OwIky/+GZrBUiAv15y9P5pJ+v7\nOT/BoJU97ZbRmyLgLlyXEtJQqZ4dbaSTNN9BKUUeIF34ejVY6KmUlk4MECa52MhV\nhANAQrzk154KLBPE/bM4TKZ1je7C2KTDo1dsyrN/nbRbvN3fZp5pEvsLNVgxSd85\nWwOKpSO1nxns53JrroU+1JyjcT1N3JEHokmZV94md61d82fPn8KvRI8klAQtjHmn\nlNL/cUXlcDQ/AgMBAAGjczBxMFAGA1UdEQRJMEeCFnNoaWJwcm9kYXBwLmxveW9s\nYS5lZHWGLWh0dHBzOi8vc2hpYnByb2RhcHAubG95b2xhLmVkdS9pZHAvc2hpYmJv\nbGV0aDAdBgNVHQ4EFgQU41Dh0cyz/KaBIxUJgmD2l3POdowwDQYJKoZIhvcNAQEF\nBQADggEBAGGNbwqn2yK4GO3IQAzqmc3t4g6hxVV4RiArdcl/vXka6T6/qabXADa2\n4FET0JtmQb82iwVWYB1trIFv0Vx/uNIzOW8runPeH845ue+KUJhLiOs+L5uO1qxj\nht/rW5SFnbRAX0v4KyQ3YUpnnL0335rWfuCVnyni2pzAfSzYb5/wJMvP74wI+FuJ\n/mtQFyJMOEnJVoUFX46HaugtDOQBrFR+lsjVgZxqlEFsVAkEumReRKRD7lKKFjV8\nFvQGSFkWMaNqaxat36IGB684E28xf/OPEJ+0L/x83anw+zz7oPZHhUVnK72ps3al\ntni4iLs+Rp8r9iFpwZc5M51492MyihM=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibprodapp.loyola.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibprodapp.loyola.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "loyola.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDQzCCAiugAwIBAgIUWLSGsZvWl23rl/5DUpC+PY0gdCowDQYJKoZIhvcNAQEF\nBQAwITEfMB0GA1UEAxMWc2hpYnByb2RhcHAubG95b2xhLmVkdTAeFw0xMTAyMTcx\nNjUyMDVaFw0zMTAyMTcxNjUyMDVaMCExHzAdBgNVBAMTFnNoaWJwcm9kYXBwLmxv\neW9sYS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCQk81WTkU5\n3/Uns2puutfJt6fcr6cp8g0PLhU7TdS824eRZRquLENS9zP8Qutne8pziezilohM\nM+iDrOcqfyjXTG/NZYkzNy7pbx31YYUYMsEvP5OwIky/+GZrBUiAv15y9P5pJ+v7\nOT/BoJU97ZbRmyLgLlyXEtJQqZ4dbaSTNN9BKUUeIF34ejVY6KmUlk4MECa52MhV\nhANAQrzk154KLBPE/bM4TKZ1je7C2KTDo1dsyrN/nbRbvN3fZp5pEvsLNVgxSd85\nWwOKpSO1nxns53JrroU+1JyjcT1N3JEHokmZV94md61d82fPn8KvRI8klAQtjHmn\nlNL/cUXlcDQ/AgMBAAGjczBxMFAGA1UdEQRJMEeCFnNoaWJwcm9kYXBwLmxveW9s\nYS5lZHWGLWh0dHBzOi8vc2hpYnByb2RhcHAubG95b2xhLmVkdS9pZHAvc2hpYmJv\nbGV0aDAdBgNVHQ4EFgQU41Dh0cyz/KaBIxUJgmD2l3POdowwDQYJKoZIhvcNAQEF\nBQADggEBAGGNbwqn2yK4GO3IQAzqmc3t4g6hxVV4RiArdcl/vXka6T6/qabXADa2\n4FET0JtmQb82iwVWYB1trIFv0Vx/uNIzOW8runPeH845ue+KUJhLiOs+L5uO1qxj\nht/rW5SFnbRAX0v4KyQ3YUpnnL0335rWfuCVnyni2pzAfSzYb5/wJMvP74wI+FuJ\n/mtQFyJMOEnJVoUFX46HaugtDOQBrFR+lsjVgZxqlEFsVAkEumReRKRD7lKKFjV8\nFvQGSFkWMaNqaxat36IGB684E28xf/OPEJ+0L/x83anw+zz7oPZHhUVnK72ps3al\ntni4iLs+Rp8r9iFpwZc5M51492MyihM=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibprodapp.loyola.edu:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibprodapp.loyola.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Loyola University Maryland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Loyola University Maryland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.loyola.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "James McCartin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jmccartin@loyola.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://vclsandbox.vcl.gmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "George Mason University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "George Mason University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.gmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://vclsandbox.vcl.gmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Barry Freese", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bfreese@gmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://vclsandbox.vcl.gmu.edu/Shibboleth.sso/DS"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "GMU VCL", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDAzCCAeugAwIBAgIJAM3q2k8ihI8LMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFFNBTkQtVkNMLnZjbC5nbXUuZWR1MB4XDTEzMDIxMTIxMjQ1N1oXDTIzMDIw\nOTIxMjQ1N1owHzEdMBsGA1UEAxMUU0FORC1WQ0wudmNsLmdtdS5lZHUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQChNUdoJbg+6mau8+XBDRX6uv+wS6HT\nkePvHMpo+0/mbnHHF8Xi+xqaCqAPCA63a9wnot6rT5qIiNVj6el80ajPgU8gNNks\nEpNHeTP4vJS4jWXZ0QLuLfQB6PskmzzWwojJYVeqCbBJgmPmuH0YpBZH0O3yg92I\nCki39bEBDUdQM93kjgRwgJO1i0S4AF0LnaeOCQtDX++53ziYYH7BvPqIJLJsc1il\nxSv35qidJWwCgi4vIBDHVWGgq6dY4uV5FnUob28i/c/QvWDZmCIV9I5+zgZnKTUT\na0oYidFvuzh0y4I9CXxWcu8qJefZBWyGYAHRWQF8lXSlgYGbUAnhk0u3AgMBAAGj\nQjBAMB8GA1UdEQQYMBaCFFNBTkQtVkNMLnZjbC5nbXUuZWR1MB0GA1UdDgQWBBS4\ncTtYVRx40EI1BmcIS9/zrc+1KDANBgkqhkiG9w0BAQUFAAOCAQEAJc6S0p99ExxO\n2zB22r/2C8iAKlW4e9MTIYke7oo7Fc2k8BUUvOH/Xb9QGEvP3GmEGn8v6T8q6u8L\ni2IW05FlFZFogzjvPDLKTwPsoh3H34FMGV0cn2pYKY9VjXzfQfkYjTI20wI559sn\njP8Nf5amjKaDnGufCr9xvvFKMTnJSlUhiXTPDH916co6qNui0wZADOGZNtearatB\n3n+fwVmmyt9tlqR9NhyKlTJZjPqk9Ta9mjgMqI9mfApWBLI3Zp1754bpltlQoUKQ\nUFL77kf/TADoy7rMxW3mRSQx+9sber0Kzmbx0eCqRquwjaMUlB2yq62pHK9u3qmr\njmYRVtX9NQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:displayName"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:sn"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "GMU VCL", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://idp.apu.edu/shibboleth", 
    {
      "entity_id": "https://idp.apu.edu/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.apu.edu/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.apu.edu/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.apu.edu/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.apu.edu/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "apu.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Azusa Pacific University", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Identity Provider for Azusa Pacific University's Faculty, Staff, Students and Alumni.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDsDCCApgCCQCjgzJFa0BoNzANBgkqhkiG9w0BAQUFADCBmTELMAkGA1UEBhMC\nVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExDjAMBgNVBAcMBUF6dXNhMSEwHwYDVQQK\nDBhBenVzYSBQYWNpZmljIFVuaXZlcnNpdHkxDDAKBgNVBAsMA0lNVDEUMBIGA1UE\nAwwLaWRwLmFwdS5lZHUxHjAcBgkqhkiG9w0BCQEWD3N1cHBvcnRAYXB1LmVkdTAe\nFw0xMjA3MTgxNjExMTFaFw0yMjA3MTYxNjExMTFaMIGZMQswCQYDVQQGEwJVUzET\nMBEGA1UECAwKQ2FsaWZvcm5pYTEOMAwGA1UEBwwFQXp1c2ExITAfBgNVBAoMGEF6\ndXNhIFBhY2lmaWMgVW5pdmVyc2l0eTEMMAoGA1UECwwDSU1UMRQwEgYDVQQDDAtp\nZHAuYXB1LmVkdTEeMBwGCSqGSIb3DQEJARYPc3VwcG9ydEBhcHUuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuNJT1fDYUrwYvxXbg7bAXncDOkYz\n3me6vdO2/WN8Yq7P1vyTmapKy7V8ckIW/F0mCLGKsskeZX7RW5zKOvjgx6xlJMzU\nl8HROk8l2KdC6sTbocX9A+56Oz5aKQRHxeRcrcUNWO5XWZApOyTr6sIJQ0kRzijS\nBtHBQfd4zT5RPiealoIJ5QTCQ6By9ot5fyKDQMEcugPMcTH8tn9chgE4kyTR3wc+\nFSWYUe7Jpl5sn5IwzBtlvxx9I3o6y3O+QXC/zOYjpF+l0XOFWC9WQ6LkqhTzUTBA\n7jOaOWjT0DLRlp+Hx6v2/FZDyZbC9anWM0FA2ooIPTxFbGLgc9UW3jPsTwIDAQAB\nMA0GCSqGSIb3DQEBBQUAA4IBAQCyEGM2Pkw4ew1bYldINc8bfwlxcnZIiGcsCTwf\nlPdkw4Qgf08kwCrDMj75g5J9YaGiK9yLaShTahbsP/G8UzLLbqlaTtKZkwTD/ZD9\n1cFpK4X/V3PoiO4BtzCLsUFR0hNi9RcxEahNBfERs5zWEoL0E6SPbEBYASsOPnNg\nuASqOe8zF+6kXJQf1LVb9y+VXT0TeqUrROQhsoQlDyaCrEYZNnp3fvzeCNoqUSzH\nDcuZ4AsMi4iOwJWnfPD7+R9RHW5E8or/a1lmGLcPkS4KaEvMmJ139KFuFFU2sfAI\nMtHJYXN/BoS3/iNepB1mnnaprpvPqcp56isQ48gVvWuqEEVF", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.apu.edu:8443/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.apu.edu:8443/profile/SAML2/SOAP/ArtifactResolution"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "apu.edu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDsDCCApgCCQCjgzJFa0BoNzANBgkqhkiG9w0BAQUFADCBmTELMAkGA1UEBhMC\nVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExDjAMBgNVBAcMBUF6dXNhMSEwHwYDVQQK\nDBhBenVzYSBQYWNpZmljIFVuaXZlcnNpdHkxDDAKBgNVBAsMA0lNVDEUMBIGA1UE\nAwwLaWRwLmFwdS5lZHUxHjAcBgkqhkiG9w0BCQEWD3N1cHBvcnRAYXB1LmVkdTAe\nFw0xMjA3MTgxNjExMTFaFw0yMjA3MTYxNjExMTFaMIGZMQswCQYDVQQGEwJVUzET\nMBEGA1UECAwKQ2FsaWZvcm5pYTEOMAwGA1UEBwwFQXp1c2ExITAfBgNVBAoMGEF6\ndXNhIFBhY2lmaWMgVW5pdmVyc2l0eTEMMAoGA1UECwwDSU1UMRQwEgYDVQQDDAtp\nZHAuYXB1LmVkdTEeMBwGCSqGSIb3DQEJARYPc3VwcG9ydEBhcHUuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuNJT1fDYUrwYvxXbg7bAXncDOkYz\n3me6vdO2/WN8Yq7P1vyTmapKy7V8ckIW/F0mCLGKsskeZX7RW5zKOvjgx6xlJMzU\nl8HROk8l2KdC6sTbocX9A+56Oz5aKQRHxeRcrcUNWO5XWZApOyTr6sIJQ0kRzijS\nBtHBQfd4zT5RPiealoIJ5QTCQ6By9ot5fyKDQMEcugPMcTH8tn9chgE4kyTR3wc+\nFSWYUe7Jpl5sn5IwzBtlvxx9I3o6y3O+QXC/zOYjpF+l0XOFWC9WQ6LkqhTzUTBA\n7jOaOWjT0DLRlp+Hx6v2/FZDyZbC9anWM0FA2ooIPTxFbGLgc9UW3jPsTwIDAQAB\nMA0GCSqGSIb3DQEBBQUAA4IBAQCyEGM2Pkw4ew1bYldINc8bfwlxcnZIiGcsCTwf\nlPdkw4Qgf08kwCrDMj75g5J9YaGiK9yLaShTahbsP/G8UzLLbqlaTtKZkwTD/ZD9\n1cFpK4X/V3PoiO4BtzCLsUFR0hNi9RcxEahNBfERs5zWEoL0E6SPbEBYASsOPnNg\nuASqOe8zF+6kXJQf1LVb9y+VXT0TeqUrROQhsoQlDyaCrEYZNnp3fvzeCNoqUSzH\nDcuZ4AsMi4iOwJWnfPD7+R9RHW5E8or/a1lmGLcPkS4KaEvMmJ139KFuFFU2sfAI\nMtHJYXN/BoS3/iNepB1mnnaprpvPqcp56isQ48gVvWuqEEVF", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.apu.edu:8443/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.apu.edu:8443/profile/SAML1/SOAP/AttributeQuery"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Azusa Pacific University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Azusa Pacific University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.apu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Joshua Riffle", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jriffle@apu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shibboleth-mba-olin-csm.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://shibboleth-mba-olin-csm.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Symplicity MBA Olin CSM", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFvTCCBKWgAwIBAgICAnIwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgxNDE4MjQwNVoXDTExMDgx\nNTE4MjQwNVowMTEvMC0GA1UEAxMmc2hpYmJvbGV0aC1tYmEtb2xpbi1jc20uc3lt\ncGxpY2l0eS5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCmGtOp\n9IM6ZswZbY32miCFM3ZneF7t1y6ltOSh5rThdmys/fdVLXrmJeuX7ZjX6qIfWx5I\nmQRfb7J2yaEfCqCuXPFF4fHBze7D4gLYqA/N4yIOluVnTFjKekq8FaGqKyW7XUf9\nLk54Y3e5pM6adThYxT8v1Cr92B1HhzTi9+C6hFhf8R35+qCTa62bJeLBawCl6xzB\n85FJHVcarjOcoHbTm3u+jZ9YRWxIyTTIgHy11jV00LpPua2pDpJ/PKnrGHSgS2bJ\nstXRztdBexj1H8/lWaPGmu1bEinX5e/dvql/IsoDOphfxtcF7VPpuGeRN68+Jbvp\n3MZJIipJnKfpRx31AgMBAAGjggK4MIICtDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0T\nAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYE\nFLk5AgPYEBcD3S5VoAQ4qQK2qLhpMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2N\nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVk\nZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3Jp\ndHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5j\nb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2Et\nY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNV\nHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9u\nY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1Ud\nIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29t\nbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMDEGA1Ud\nEQQqMCiCJnNoaWJib2xldGgtbWJhLW9saW4tY3NtLnN5bXBsaWNpdHkuY29tMA0G\nCSqGSIb3DQEBBQUAA4IBAQAWJy8TH5VqVsK/1HpCxcPnLFdaJtqEaiE0p5GB6cLI\nggKacv2L2ORxNI1comsUmiolpKKNAO0iP7XS8F0tIHIgMsM35KOPHRKyCrXWWfiQ\nLGt7yxCBaQ+TXxv0MMnFNVamflQoyjfrgCgP1GdyP4km0GynRTML4eUT+h/Tuwj2\nWzQobz8FhoufyKeFVFBBegdyaI96zG3fUy9V+bmD/XPsAJH7gIbGXK0L3ynHV9Iv\nCtZ2CymgWY5hpdHdI/87TckfJNaVbHTd6VSaW2Gb/M/cLu1CExpwTs7OdEAoTIg5\n+9Ja6WII2mb3JWkpdSkgbF2VWxfgnnGU2mxKvrayVrgH", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-mba-olin-csm.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth-mba-olin-csm.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://uwkstrn01.cac.washington.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of Washington", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of Washington", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.washington.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://uwkstrn01.cac.washington.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Applications Engineering, CI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ae-rt@uw.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/Login"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.washington.edu/online/privacy/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UW MyPlan Training Site", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UW MyPlan Training Site", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIJANqJLb2dXiDfMA0GCSqGSIb3DQEBBQUAMCcxJTAjBgNV\nBAMTHHV3a3N0cm4wMS5jYWMud2FzaGluZ3Rvbi5lZHUwHhcNMTMxMTE5MjM0NTAy\nWhcNMjMxMTE3MjM0NTAyWjAnMSUwIwYDVQQDExx1d2tzdHJuMDEuY2FjLndhc2hp\nbmd0b24uZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvnw3wXv/\nsvYMnhgHFG6pct1WjAoDHT+UMJRifrpajN7YWGtU0lxS30u4xmB/h68vcDkWeLkZ\nSjIWJxpJBT4WzG0l+OxTRswG8YWNjun93032uM5iAke8PlHHt/QqxrSx8Js0ZXFL\n0cEU/s7Wj7wRIdpUrS6Yf0yZZtYQy6hzvoJ0ApW/Yeq7uZTZrxtBjtdfFRagxBT9\nv367djcG7KoJmdMSrkcC6jyyJpgqgUXmKFo/FUSLp6YAzZY0QZfbXu5/5tqKCf6q\n32GEkr2rLyNGxf2Ft53I+wjGHrH23Yqnn9nWKyvaSmg1fFduStpF0N1/dlvw/ASc\nzkxR7gBusoxfOwIDAQABo0owSDAnBgNVHREEIDAeghx1d2tzdHJuMDEuY2FjLndh\nc2hpbmd0b24uZWR1MB0GA1UdDgQWBBTWOEaRRgTwSVKAzC3Xwzdu19a/4jANBgkq\nhkiG9w0BAQUFAAOCAQEApr4SR7UeUx1yEbl4REAMSOlJx8kBR4PRxiHM7JTUE7Pp\ngG+Yd1kEOi9Y/hPiPhMjiJAoIwvmQdTKHnt0M+d0+p96/xC1y+fBdXpakiPbx+bf\n84i0usYC1tOVlcC5T1K/B7pZKq2bZDzqPMwGewM6Dd2Dira/lJsaOjHZtRtP6qXF\nIGdSWy8gyIBLdHtb+JhoYkF227JPaWohnommrTPHeSrF8piIC02R4ykNKkMp7jAi\ngJr92U81E7qflK0CRZtEXKoMkkIG16TtoYfcCIRtKSLGMFLIFidicwsJMNmRw/Iy\nyWPd7yBgCL8RkAeHEM7gKXg/CGe7sY48d2kpSalebQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uwkstrn01.cac.washington.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://dmp2-production.cdlib.org", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "University of California - Office of the President", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ucop.edu/welcome.html", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://dmp2-production.cdlib.org", 
      "contact_person": [
        {
          "given_name": {
            "text": "ken weiss", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ken.weiss@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Perry Willett", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "perry.willett@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Marisa Strong", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "marisa.strong@ucop.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://dmp2-production.cdlib.org/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "dmp2-production", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDFDCCAfygAwIBAgIJANLFG7xxo2T5MA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDmRtcDIuY2RsaWIub3JnMB4XDTEzMDYyNzIwMjgwOFoXDTIzMDYyNTIwMjgw\nOFowGTEXMBUGA1UEAxMOZG1wMi5jZGxpYi5vcmcwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQDVYAkFXfMT7dFn6WpaiYJx2HTX+kAqhc/T0yp1gQkMHAGj\nmce5yjGc9Y9fAzEReRmGWyZV7MhoLTVNgza9tbZYEcPqenM8rPtS2z9iTnUFRh69\nzUBATgtge6gwLOULeOJMbzNOO3e74quyMHLP1rfZcU0mUVU4UU1JTcOi+HOJz1FN\nMjgiYc5Dp9RZDzEHIVo0c/RXp6jrMrGsYHW42TH1EemLhibFnZHvCmPlZeSI9RQk\nQOCuoM20Y2F4UcPz/58OFk1AebKmw8NrW/4RvwQz8PiYzwDOEZFEmP+xSQcSUTPt\njS7W/j1zP1dYc6EShYzb+Vw1Prtv5UUtOdMXdZIVAgMBAAGjXzBdMDwGA1UdEQQ1\nMDOCDmRtcDIuY2RsaWIub3JnhiFodHRwczovL2RtcDItcHJvZHVjdGlvbi5jZGxp\nYi5vcmcwHQYDVR0OBBYEFOQIFoShOj7M9NhpJuSoMTNd52m1MA0GCSqGSIb3DQEB\nBQUAA4IBAQA1i/IsvUeoUg0DFkJw4C+EhUagKmqgjRel9lQvV0lGzWHc7tmIu3PY\nYwjX0/o6TsaQ1t5m00hjsOkePLlZAlWiQvR5VgAeHW0n/v2Sivu/bbK/uluaFIZl\n5VZvvg9XCOLeVNcjLwG68H3fNWFrvYw6vAQ4O2nGSKU85t6GE/IwnfOOQmNSbgQs\nTclTd6jllavlTBbWLjpJnri8mTYw1eMwuCJQOJd/6enZmsIQPQ89hHfhzKzlNgYF\n80rd2Z1biagQcnuhbLEeKO/MrB0PLbunGpguWXFeusC2KFrvGBb6lQCznSP5p5pY\nAszhg1R1jxqErrtpIsbk2NSvXaitPFxD", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dmp2-production.cdlib.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dmp2-production.cdlib.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dmp2-production.cdlib.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cdl-dmp2-p01.ucop.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cdl-dmp2-p01.ucop.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://cdl-dmp2-p01.ucop.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://v2.dmptool.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://v2.dmptool.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://v2.dmptool.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dmp2.cdlib.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dmp2.cdlib.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dmp2.cdlib.org/Shibboleth.sso/SAML2/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://utexas.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Qualtrics Labs, Inc.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.qualtrics.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://utexas.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/metadata.php/default-sp", 
      "contact_person": [
        {
          "given_name": {
            "text": "Michael Page", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth@qualtrics.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Qualtrics Labs, Inc.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFbDCCA1QCCQC8OqKPlGUkRDANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJV\nUzENMAsGA1UECBMEVXRhaDEOMAwGA1UEBxMFUHJvdm8xGDAWBgNVBAoTD1F1YWx0\ncmljcywgSW5jLjEgMB4GCSqGSIb3DQEJARYRZGJhQHF1YWx0cmljcy5jb20wHhcN\nMTAwNDA3MTkzMzA0WhcNMjAwNDA3MTkzMzA0WjCBhzELMAkGA1UEBhMCVVMxDTAL\nBgNVBAgTBFV0YWgxDjAMBgNVBAcTBVByb3ZvMRgwFgYDVQQKEw9RdWFsdHJpY3Ms\nIEluYy4xGDAWBgNVBAMMDyoucXVhbHRyaWNzLmNvbTElMCMGCSqGSIb3DQEJARYW\nc3NvYWRtaW5AcXVhbHRyaWNzLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC\nAgoCggIBAM7T6YYEDd91lehKK/51V3Li6zk/wqHZ1OZ4rHw22AtTasl0qrEwdXbL\nsCUmO4rEXhAnjgpIZPFHs+1sFpSCalerYa+ROJX5B5N9MnENYr6E8KHa8spbVBEl\n2/ZE6RlPdHBs+iCDuoTTqOa2sZ8vqTpTF3grVdgeW3KfBOO9yENa04lA6xhPAQs3\nkihDQvPoWnlXtQA3gmtb+sGZmKYXonBVwIDsrDbhpoFcHJJRrFEEawSHOI3IeHBo\nhR1jhfb95E3cQ0s7gQ+FbR+lkzwb3i3WrCkZr3w2KpudJEzy/kT7JBLvfELW8eR4\nj2XRKyRhxNHOKc/AC8fNIrGam0CAqK9elpJnB6zmALQUYXVGddv3sd9ITIfZQ9Ox\ng9ChVqsNAY6VIlg5+/Q3Ega+BR/P/OpMnG9xW+cyLslzjiUf4c0K6I2pObcJkJMw\nqGHOSbD9lGa/WxaEAFC1+6oDNRbC3S2mbo4gW6LPVbtCxC0IMxOyaOKBwe3sW9v+\nrumd02ZuJRtbTbarde7N6aUmm2hXfDQntCIXWUJ+9b+YvjcWUlUN0KvVq8jFn1Z7\nkD1po2eY+lc9VHYoh1jdP08G9H8CZdJTDwR4KDPG0U2rD+xXmxO+9CEeQev1d/Iu\nqcadQxRka7hbhIijtVJgjO3jP6AwiHXFGpBvApyIuuXJU8CyKSsXAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggIBAAcXtiFXJ5Vm0mwhiDRoTGwIGz+Ryg13X6X9w6GfVENt\nNexDExwzPgxnW1gG7u9FUx2tl2geZ8BJOqk3pGnLSZI4QF/nVnB+hTPMLOwXjtMk\nMF5FXlM7QvOKOTzzK7+2wug2ssZi5ZpQVGODhPsytu+GjMJwydLj6RRAnJV/9wmu\nivZhIbQyrOs0XBxuYO0n9OzlOa9JVFtUxnckT93UYIjcCVEu2r+m20Zm8BEofKTr\nTz3vodizFV5uHbmQ19iLxDrZsu9rbpEHojWMgnKnq1XoC7TmlxB1/OQctUnjpRPT\nWySZkTdWX4cKBjQHzCHJyl0Z4hAP4m3fWFLXVK3w8U1e+Mbfm0jUT9+amUfdzL+8\n9ZjwnFvpuFNWsS33yYWp51+rVdtU0jYII1f8XWNRn4EV54MwoOWrEXKDZ0qmbxi5\nnVR/F5QofEGv/ZYMgcFaX5OMP5lRE8IjQu9Eq26zZA6YuR5fZfiTHZppwc6Ey9Zc\nGpRsLwFSwma0/Vtlfxr/KtaKsk2zlOOJ6RF33MUyZvw8N+tybY0yHJ40aBZKFr9r\nr3j//DUU8zi4qvNP5z19kS08sZ7mtNK2sKBPWVSYB2HDtyrBSRupHBYeIxlfGKd6\nuVUusHTyyVjDKbuMHCw+DEp0VXmCIAv5Jf+SKZ7DOkw8cxcdL67gEc9NjAmsfmKy", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utexas.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://utexas.qualtrics.com/WRSAML/simplesaml/www/module.php/saml/sp/saml1-acs.php/default-sp"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://c19-shib.symplicity.com/sso/", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Symplicity Corporation", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://c19-shib.symplicity.com/sso/", 
      "contact_person": [
        {
          "given_name": {
            "text": "Symplicity NOC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shib@symplicity.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Symplicity Basic Shibboleth c19", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDtDCCApwCCQDCWqQxvHUbxjANBgkqhkiG9w0BAQUFADCBmzELMAkGA1UEBhMC\nVVMxETAPBgNVBAgTCFZpcmdpbmlhMRIwEAYDVQQHEwlBcmxpbmd0b24xHzAdBgNV\nBAoTFlN5bXBsaWNpdHkgQ29ycG9yYXRpb24xIDAeBgNVBAMTF2MxOS1zaGliLnN5\nbXBsaWNpdHkuY29tMSIwIAYJKoZIhvcNAQkBFhNzaGliQHN5bXBsaWNpdHkuY29t\nMB4XDTEzMDQxOTE1NTUxMFoXDTE2MDQxODE1NTUxMFowgZsxCzAJBgNVBAYTAlVT\nMREwDwYDVQQIEwhWaXJnaW5pYTESMBAGA1UEBxMJQXJsaW5ndG9uMR8wHQYDVQQK\nExZTeW1wbGljaXR5IENvcnBvcmF0aW9uMSAwHgYDVQQDExdjMTktc2hpYi5zeW1w\nbGljaXR5LmNvbTEiMCAGCSqGSIb3DQEJARYTc2hpYkBzeW1wbGljaXR5LmNvbTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANfrkt2txI6Ch2UgUjtWFF/z\nU48Eq5YZSK6AQf8GH5yFTAC5zvY8KFEio5OKNQ2EzCzxFD5HZS5DSbFfhoLPmrzK\nY3cKAbiGLxZiz/HLI10Xz5roj27jRjyf0IqZKiIVhvyWZJteCvnWsU2XjazXdh7E\nveRmrr7gGUQ/ipMPIa2Js+VjU6u4nlDYYYoAgQqnvaAgQ2wsm9/HN6k2FpL7nP6n\n8pgNVbm4zep0MOjWpkci7EEi0xSIQoQfH3g77Dq700gPvVbXiT4IZzsC64Jae5Tl\nxfham8wQQQbBg8GYf8vO+BpLV/dQab+gOIfpB11T8BvK04Gz6+V2524R45kZapsC\nAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAxxPbIpw1FeKbq1v6NGfxNkVrX10mPorh\n9BSg7f0nfvWUASxFw/NEpjKUgTXVj4T8Q0ZFIPGJc5UNUzetJgjUFwGl4PBlTjhI\nVwGGHBqvhshhbmgjFDTwFq/GwNOiQ7/8Dl9OyzGBqRiO3rldRLa/JeEPCgBphRJQ\nolpBhuvCxarJdMYIbIdI+I4bvlnqtpkK9bpZ6+9zG7kXo6VDL3+Xe+wAdykVa0CI\nXoCZjiHTOtGbd5N6KPxQ1TSjAwQYSjNUwADBdbihf7q40C/vsimvgKWgx/wQnkS4\nd/GY27I1SiKMpPKV6z88t+Np+zvDJvHCQkJWvcor5XarKm4pPUaOLg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://c19-shib.symplicity.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://c19-shib.symplicity.com/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://tools.iso.cmu.edu/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Carnegie Mellon University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.cmu.edu/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://tools.iso.cmu.edu/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Vlad Grigorescu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "vladg@cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Chris Ries", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cmries@cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ted Pham", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "telamon@cmu.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://tools.iso.cmu.edu/Shibboleth.sso/Login"
              }, 
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Host tools.iso.cmu.edu", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC+jCCAeKgAwIBAgIJALKf8fuVv3ToMA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTEXRvb2xzLmlzby5jbXUuZWR1MB4XDTEyMDcxNjE4NDg0MloXDTIyMDcxNDE4\nNDg0MlowHDEaMBgGA1UEAxMRdG9vbHMuaXNvLmNtdS5lZHUwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDbynDxFYWqb/rEvMDkHP3Jol6Ei3i1FOVrKhtK\nq5pVTlIIjD+go0MJ4MU7pcM/V1j/EBJiTpwFoJDNXTOwYLxJBelZc2rYbXCdin13\nEgbNT6W53e9nYo6q1o6JxxFY9oPZihuwoQ5fFWiBpBG3jRymAYfS0wNLjsmA4ncw\nm7lO0hWhXOb1f3c3InuPiObhcxMinBNlcs0U+JmIDl5C8TBtgjabbchRqEa5e0Xh\nZ3fhCVGiHMBPFJ4FRwFiKdAUeaQr4Uqb4ibrCJl0r5FNk/Y/yg0QJ7HDbzGEphkr\n3jfREk1Qa5Js9ZNb8BSpIA4vm8URlylTlZqwDKGiKFzc9yetAgMBAAGjPzA9MBwG\nA1UdEQQVMBOCEXRvb2xzLmlzby5jbXUuZWR1MB0GA1UdDgQWBBRQ0WOjurfyDPvq\n+OFC9KE/Pc2FbzANBgkqhkiG9w0BAQUFAAOCAQEAYk9wNxTM5mYPQOwAAWeHrrwx\nWfYf4ee1HveDgY3tjKrZPmC1r08lArFU3pSGJSmZ/4iGbOR0BaEfdLd4W4+b/kfa\nV7yInhq5hVIqcldzse+hzs7Ei5kiwvqWwmlnTd89x+pBXbqGRe9C4AgHfITr1njt\nn0abUBVQpBFaMjOa/XOLEA1o8WjdwyoJiXpN7sokSJGc9nZAQKT/T5ljutwperkj\nFxNfs66n/Gdi7HQO56ofTHZeiWWGh9ngS3DdYmlIzQ1FSWOlHGh5+smBSY+5tUbF\nYFGNNouV4u71UoZjdA0zEsDOOIvGeEFTS0SrUhxw6devGePwE0twX3zp32qqLQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://tools.iso.cmu.edu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://tools.iso.cmu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://tools.iso.cmu.edu/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://tools.iso.cmu.edu/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://tools.iso.cmu.edu/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://tools.iso.cmu.edu/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.athenaonline.com/shibboleth", 
    {
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "AthenaOnline.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "AthenaOnline.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.athenaonline.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "entity_id": "https://www.athenaonline.com/shibboleth", 
      "contact_person": [
        {
          "given_name": {
            "text": "Tony Perry", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "cperry@athenaonline.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Jon Peters", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jpeters@athenaonline.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "c