; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zfh,+experimental-zvfh,+f,+d -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zfh,+experimental-zvfh,+f,+d -riscv-v-vector-bits-min=128  -verify-machineinstrs < %s | FileCheck %s

declare half @llvm.vector.reduce.fadd.v1f16(half, <1 x half>)

define half @vreduce_fadd_v1f16(<1 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.f.s ft0, v8
; CHECK-NEXT:    fadd.h fa0, fa0, ft0
; CHECK-NEXT:    ret
  %v = load <1 x half>, <1 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v1f16(half %s, <1 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v1f16(<1 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x half>, <1 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v1f16(half %s, <1 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v2f16(half, <2 x half>)

define half @vreduce_fadd_v2f16(<2 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, <2 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v2f16(half %s, <2 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v2f16(<2 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, <2 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v2f16(half %s, <2 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v4f16(half, <4 x half>)

define half @vreduce_fadd_v4f16(<4 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v4f16(half %s, <4 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v4f16(<4 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v4f16(half %s, <4 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v8f16(half, <8 x half>)

define half @vreduce_fadd_v8f16(<8 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, <8 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v8f16(half %s, <8 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v8f16(<8 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, <8 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v8f16(half %s, <8 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v16f16(half, <16 x half>)

define half @vreduce_fadd_v16f16(<16 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, <16 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v16f16(half %s, <16 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v16f16(<16 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, <16 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v16f16(half %s, <16 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v32f16(half, <32 x half>)

define half @vreduce_fadd_v32f16(<32 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, <32 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v32f16(half %s, <32 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v32f16(<32 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vfredosum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, <32 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v32f16(half %s, <32 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v64f16(half, <64 x half>)

define half @vreduce_fadd_v64f16(<64 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, <64 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v64f16(half %s, <64 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v64f16(<64 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, <64 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v64f16(half %s, <64 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v128f16(half, <128 x half>)

define half @vreduce_fadd_v128f16(<128 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfadd.vv v8, v8, v16
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, <128 x half>* %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v128f16(half %s, <128 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v128f16(<128 x half>* %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vfredosum.vs v16, v16, v24
; CHECK-NEXT:    vfmv.f.s ft0, v16
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, ft0
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, <128 x half>* %x
  %red = call half @llvm.vector.reduce.fadd.v128f16(half %s, <128 x half> %v)
  ret half %red
}

declare float @llvm.vector.reduce.fadd.v1f32(float, <1 x float>)

define float @vreduce_fadd_v1f32(<1 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.f.s ft0, v8
; CHECK-NEXT:    fadd.s fa0, fa0, ft0
; CHECK-NEXT:    ret
  %v = load <1 x float>, <1 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v1f32(<1 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x float>, <1 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v1f32(<1 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.f.s ft0, v9
; CHECK-NEXT:    fadd.s fa0, fa0, ft0
; CHECK-NEXT:    ret
  %v = load <1 x half>, <1 x half>* %x
  %e = fpext <1 x half> %v to <1 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v1f32(<1 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x half>, <1 x half>* %x
  %e = fpext <1 x half> %v to <1 x float>
  %red = call float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v2f32(float, <2 x float>)

define float @vreduce_fadd_v2f32(<2 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, <2 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v2f32(<2 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, <2 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v2f32(<2 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, <2 x half>* %x
  %e = fpext <2 x half> %v to <2 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v2f32(<2 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, <2 x half>* %x
  %e = fpext <2 x half> %v to <2 x float>
  %red = call float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v4f32(float, <4 x float>)

define float @vreduce_fadd_v4f32(<4 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v4f32(<4 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v4f32(<4 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %e = fpext <4 x half> %v to <4 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v4f32(<4 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %e = fpext <4 x half> %v to <4 x float>
  %red = call float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v8f32(float, <8 x float>)

define float @vreduce_fadd_v8f32(<8 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, <8 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v8f32(<8 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, <8 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v8f32(<8 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, <8 x half>* %x
  %e = fpext <8 x half> %v to <8 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v8f32(<8 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, <8 x half>* %x
  %e = fpext <8 x half> %v to <8 x float>
  %red = call float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v16f32(float, <16 x float>)

define float @vreduce_fadd_v16f32(<16 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, <16 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v16f32(<16 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, <16 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v16f32(<16 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v10
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, <16 x half>* %x
  %e = fpext <16 x half> %v to <16 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v16f32(<16 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v10
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, <16 x half>* %x
  %e = fpext <16 x half> %v to <16 x float>
  %red = call float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v32f32(float, <32 x float>)

define float @vreduce_fadd_v32f32(<32 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, <32 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v32f32(<32 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, <32 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v32f32(<32 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v12
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, <32 x half>* %x
  %e = fpext <32 x half> %v to <32 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v32f32(<32 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v12
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, <32 x half>* %x
  %e = fpext <32 x half> %v to <32 x float>
  %red = call float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v64f32(float, <64 x float>)

define float @vreduce_fadd_v64f32(<64 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vfadd.vv v8, v8, v16
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x float>, <64 x float>* %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v64f32(<64 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vfredosum.vs v16, v16, v24
; CHECK-NEXT:    vfmv.f.s ft0, v16
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, ft0
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x float>, <64 x float>* %x
  %red = call float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v64f32(<64 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, mu
; CHECK-NEXT:    vslidedown.vx v16, v8, a0
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfwadd.vv v24, v8, v16
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v8, fa0
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v24, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, <64 x half>* %x
  %e = fpext <64 x half> %v to <64 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v64f32(<64 x half>* %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, mu
; CHECK-NEXT:    vslidedown.vx v8, v16, a0
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v16, v16, v24
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s ft0, v16
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, ft0
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v16
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, <64 x half>* %x
  %e = fpext <64 x half> %v to <64 x float>
  %red = call float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %e)
  ret float %red
}

declare double @llvm.vector.reduce.fadd.v1f64(double, <1 x double>)

define double @vreduce_fadd_v1f64(<1 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.f.s ft0, v8
; CHECK-NEXT:    fadd.d fa0, fa0, ft0
; CHECK-NEXT:    ret
  %v = load <1 x double>, <1 x double>* %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v1f64(<1 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x double>, <1 x double>* %x
  %red = call double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v1f64(<1 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s ft0, v9
; CHECK-NEXT:    fadd.d fa0, fa0, ft0
; CHECK-NEXT:    ret
  %v = load <1 x float>, <1 x float>* %x
  %e = fpext <1 x float> %v to <1 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v1f64(<1 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x float>, <1 x float>* %x
  %e = fpext <1 x float> %v to <1 x double>
  %red = call double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v2f64(double, <2 x double>)

define double @vreduce_fadd_v2f64(<2 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, <2 x double>* %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v2f64(<2 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, <2 x double>* %x
  %red = call double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v2f64(<2 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, <2 x float>* %x
  %e = fpext <2 x float> %v to <2 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v2f64(<2 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, <2 x float>* %x
  %e = fpext <2 x float> %v to <2 x double>
  %red = call double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v4f64(double, <4 x double>)

define double @vreduce_fadd_v4f64(<4 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v4f64(<4 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v4f64(<4 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %e = fpext <4 x float> %v to <4 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v4f64(<4 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %e = fpext <4 x float> %v to <4 x double>
  %red = call double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v8f64(double, <8 x double>)

define double @vreduce_fadd_v8f64(<8 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, <8 x double>* %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v8f64(<8 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, <8 x double>* %x
  %red = call double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v8f64(<8 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v10
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, <8 x float>* %x
  %e = fpext <8 x float> %v to <8 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v8f64(<8 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v10
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, <8 x float>* %x
  %e = fpext <8 x float> %v to <8 x double>
  %red = call double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v16f64(double, <16 x double>)

define double @vreduce_fadd_v16f64(<16 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, <16 x double>* %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v16f64(<16 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, <16 x double>* %x
  %red = call double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v16f64(<16 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfwredusum.vs v8, v8, v12
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, <16 x float>* %x
  %e = fpext <16 x float> %v to <16 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v16f64(<16 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v12
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, <16 x float>* %x
  %e = fpext <16 x float> %v to <16 x double>
  %red = call double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v32f64(double, <32 x double>)

define double @vreduce_fadd_v32f64(<32 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vfadd.vv v8, v8, v16
; CHECK-NEXT:    vfredusum.vs v8, v8, v24
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, <32 x double>* %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v32f64(<32 x double>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v24
; CHECK-NEXT:    vfmv.f.s ft0, v8
; CHECK-NEXT:    vfmv.s.f v8, ft0
; CHECK-NEXT:    vfredosum.vs v8, v16, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, <32 x double>* %x
  %red = call double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v32f64(<32 x float>* %x, double %s) {
; RV32-LABEL: vreduce_fwadd_v32f64:
; RV32:       # %bb.0:
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; RV32-NEXT:    vle32.v v8, (a0)
; RV32-NEXT:    vsetivli zero, 16, e32, m8, ta, mu
; RV32-NEXT:    vslidedown.vi v16, v8, 16
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; RV32-NEXT:    vfwadd.vv v24, v8, v16
; RV32-NEXT:    fcvt.d.w ft0, zero
; RV32-NEXT:    fneg.d ft0, ft0
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; RV32-NEXT:    vfmv.s.f v8, ft0
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV32-NEXT:    vfredusum.vs v8, v24, v8
; RV32-NEXT:    vfmv.f.s ft0, v8
; RV32-NEXT:    fadd.d fa0, fa0, ft0
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_fwadd_v32f64:
; RV64:       # %bb.0:
; RV64-NEXT:    li a1, 32
; RV64-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; RV64-NEXT:    vle32.v v8, (a0)
; RV64-NEXT:    vsetivli zero, 16, e32, m8, ta, mu
; RV64-NEXT:    vslidedown.vi v16, v8, 16
; RV64-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; RV64-NEXT:    vfwadd.vv v24, v8, v16
; RV64-NEXT:    fmv.d.x ft0, zero
; RV64-NEXT:    fneg.d ft0, ft0
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; RV64-NEXT:    vfmv.s.f v8, ft0
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV64-NEXT:    vfredusum.vs v8, v24, v8
; RV64-NEXT:    vfmv.f.s ft0, v8
; RV64-NEXT:    fadd.d fa0, fa0, ft0
; RV64-NEXT:    ret
; CHECK-LABEL: vreduce_fwadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 16, e32, m8, ta, mu
; CHECK-NEXT:    vslidedown.vi v16, v8, 16
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfwadd.vv v24, v8, v16
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v8, fa0
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vfredusum.vs v8, v24, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, <32 x float>* %x
  %e = fpext <32 x float> %v to <32 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v32f64(<32 x float>* %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vsetivli zero, 16, e32, m8, ta, mu
; CHECK-NEXT:    vslidedown.vi v8, v16, 16
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v16, v16, v24
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s ft0, v16
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.s.f v16, ft0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfwredosum.vs v8, v8, v16
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, <32 x float>* %x
  %e = fpext <32 x float> %v to <32 x double>
  %red = call double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %e)
  ret double %red
}

declare half @llvm.vector.reduce.fmin.v2f16(<2 x half>)

define half @vreduce_fmin_v2f16(<2 x half>* %x) {
; CHECK-LABEL: vreduce_fmin_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI68_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI68_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, <2 x half>* %x
  %red = call half @llvm.vector.reduce.fmin.v2f16(<2 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmin.v4f16(<4 x half>)

define half @vreduce_fmin_v4f16(<4 x half>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI69_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI69_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call half @llvm.vector.reduce.fmin.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmin_v4f16_nonans(<4 x half>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI70_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI70_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call nnan half @llvm.vector.reduce.fmin.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmin_v4f16_nonans_noinfs(<4 x half>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f16_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI71_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI71_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call nnan ninf half @llvm.vector.reduce.fmin.v4f16(<4 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmin.v128f16(<128 x half>)

define half @vreduce_fmin_v128f16(<128 x half>* %x) {
; CHECK-LABEL: vreduce_fmin_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    lui a0, %hi(.LCPI72_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI72_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v16, (a0), zero
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, <128 x half>* %x
  %red = call half @llvm.vector.reduce.fmin.v128f16(<128 x half> %v)
  ret half %red
}

declare float @llvm.vector.reduce.fmin.v2f32(<2 x float>)

define float @vreduce_fmin_v2f32(<2 x float>* %x) {
; CHECK-LABEL: vreduce_fmin_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI73_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI73_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, <2 x float>* %x
  %red = call float @llvm.vector.reduce.fmin.v2f32(<2 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmin.v4f32(<4 x float>)

define float @vreduce_fmin_v4f32(<4 x float>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI74_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI74_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call float @llvm.vector.reduce.fmin.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmin_v4f32_nonans(<4 x float>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI75_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI75_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call nnan float @llvm.vector.reduce.fmin.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmin_v4f32_nonans_noinfs(<4 x float>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f32_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI76_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI76_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call nnan ninf float @llvm.vector.reduce.fmin.v4f32(<4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmin.v128f32(<128 x float>)

define float @vreduce_fmin_v128f32(<128 x float>* %x) {
; CHECK-LABEL: vreduce_fmin_v128f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a2, a0, 384
; CHECK-NEXT:    vle32.v v16, (a2)
; CHECK-NEXT:    addi a2, a0, 256
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    vle32.v v0, (a2)
; CHECK-NEXT:    vfmin.vv v16, v24, v16
; CHECK-NEXT:    vfmin.vv v8, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    lui a0, %hi(.LCPI77_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI77_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v16, (a0), zero
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x float>, <128 x float>* %x
  %red = call float @llvm.vector.reduce.fmin.v128f32(<128 x float> %v)
  ret float %red
}

declare double @llvm.vector.reduce.fmin.v2f64(<2 x double>)

define double @vreduce_fmin_v2f64(<2 x double>* %x) {
; CHECK-LABEL: vreduce_fmin_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI78_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI78_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, <2 x double>* %x
  %red = call double @llvm.vector.reduce.fmin.v2f64(<2 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmin.v4f64(<4 x double>)

define double @vreduce_fmin_v4f64(<4 x double>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI79_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI79_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v10, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call double @llvm.vector.reduce.fmin.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmin_v4f64_nonans(<4 x double>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI80_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI80_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v10, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call nnan double @llvm.vector.reduce.fmin.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmin_v4f64_nonans_noinfs(<4 x double>* %x) {
; CHECK-LABEL: vreduce_fmin_v4f64_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI81_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI81_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v10, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call nnan ninf double @llvm.vector.reduce.fmin.v4f64(<4 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmin.v32f64(<32 x double>)

define double @vreduce_fmin_v32f64(<32 x double>* %x) {
; CHECK-LABEL: vreduce_fmin_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    lui a0, %hi(.LCPI82_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI82_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v16, (a0), zero
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vfredmin.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, <32 x double>* %x
  %red = call double @llvm.vector.reduce.fmin.v32f64(<32 x double> %v)
  ret double %red
}

declare half @llvm.vector.reduce.fmax.v2f16(<2 x half>)

define half @vreduce_fmax_v2f16(<2 x half>* %x) {
; CHECK-LABEL: vreduce_fmax_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI83_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI83_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, <2 x half>* %x
  %red = call half @llvm.vector.reduce.fmax.v2f16(<2 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmax.v4f16(<4 x half>)

define half @vreduce_fmax_v4f16(<4 x half>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI84_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI84_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call half @llvm.vector.reduce.fmax.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmax_v4f16_nonans(<4 x half>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI85_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI85_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call nnan half @llvm.vector.reduce.fmax.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmax_v4f16_nonans_noinfs(<4 x half>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f16_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI86_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI86_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, <4 x half>* %x
  %red = call nnan ninf half @llvm.vector.reduce.fmax.v4f16(<4 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmax.v128f16(<128 x half>)

define half @vreduce_fmax_v128f16(<128 x half>* %x) {
; CHECK-LABEL: vreduce_fmax_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    lui a0, %hi(.LCPI87_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI87_0)
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, mu
; CHECK-NEXT:    vlse16.v v16, (a0), zero
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, <128 x half>* %x
  %red = call half @llvm.vector.reduce.fmax.v128f16(<128 x half> %v)
  ret half %red
}

declare float @llvm.vector.reduce.fmax.v2f32(<2 x float>)

define float @vreduce_fmax_v2f32(<2 x float>* %x) {
; CHECK-LABEL: vreduce_fmax_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI88_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI88_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, <2 x float>* %x
  %red = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmax.v4f32(<4 x float>)

define float @vreduce_fmax_v4f32(<4 x float>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI89_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI89_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmax_v4f32_nonans(<4 x float>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI90_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI90_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call nnan float @llvm.vector.reduce.fmax.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmax_v4f32_nonans_noinfs(<4 x float>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f32_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI91_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI91_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call nnan ninf float @llvm.vector.reduce.fmax.v4f32(<4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmax.v128f32(<128 x float>)

define float @vreduce_fmax_v128f32(<128 x float>* %x) {
; CHECK-LABEL: vreduce_fmax_v128f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a2, a0, 384
; CHECK-NEXT:    vle32.v v16, (a2)
; CHECK-NEXT:    addi a2, a0, 256
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    vle32.v v0, (a2)
; CHECK-NEXT:    vfmax.vv v16, v24, v16
; CHECK-NEXT:    vfmax.vv v8, v8, v0
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    lui a0, %hi(.LCPI92_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI92_0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, mu
; CHECK-NEXT:    vlse32.v v16, (a0), zero
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x float>, <128 x float>* %x
  %red = call float @llvm.vector.reduce.fmax.v128f32(<128 x float> %v)
  ret float %red
}

declare double @llvm.vector.reduce.fmax.v2f64(<2 x double>)

define double @vreduce_fmax_v2f64(<2 x double>* %x) {
; CHECK-LABEL: vreduce_fmax_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI93_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI93_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v9, (a0), zero
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, <2 x double>* %x
  %red = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmax.v4f64(<4 x double>)

define double @vreduce_fmax_v4f64(<4 x double>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI94_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI94_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v10, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmax_v4f64_nonans(<4 x double>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI95_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI95_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v10, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call nnan double @llvm.vector.reduce.fmax.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmax_v4f64_nonans_noinfs(<4 x double>* %x) {
; CHECK-LABEL: vreduce_fmax_v4f64_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    lui a0, %hi(.LCPI96_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI96_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v10, (a0), zero
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, <4 x double>* %x
  %red = call nnan ninf double @llvm.vector.reduce.fmax.v4f64(<4 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmax.v32f64(<32 x double>)

define double @vreduce_fmax_v32f64(<32 x double>* %x) {
; CHECK-LABEL: vreduce_fmax_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    lui a0, %hi(.LCPI97_0)
; CHECK-NEXT:    addi a0, a0, %lo(.LCPI97_0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vlse64.v v16, (a0), zero
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vfredmax.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, <32 x double>* %x
  %red = call double @llvm.vector.reduce.fmax.v32f64(<32 x double> %v)
  ret double %red
}

define float @vreduce_nsz_fadd_v4f32(<4 x float>* %x, float %s) {
; CHECK-LABEL: vreduce_nsz_fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, <4 x float>* %x
  %red = call reassoc nsz float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %v)
  ret float %red
}
