; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=i686 | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=atom | FileCheck %s --check-prefix=CHECK --check-prefix=ATOM
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=slm | FileCheck %s --check-prefix=CHECK --check-prefix=SLM
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=sandybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=ivybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=haswell | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=broadwell | FileCheck %s --check-prefix=CHECK --check-prefix=BROADWELL
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=skylake | FileCheck %s --check-prefix=CHECK --check-prefix=SKYLAKE
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=skx | FileCheck %s --check-prefix=CHECK --check-prefix=SKX
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=btver2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=i686-unknown-unknown -print-schedule -mcpu=znver1 | FileCheck %s --check-prefix=CHECK --check-prefix=ZNVER1

define void @test_f2xm1() optsize {
; GENERIC-LABEL: test_f2xm1:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    f2xm1
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_f2xm1:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    f2xm1 # sched: [99:49.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_f2xm1:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    f2xm1 # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_f2xm1:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    f2xm1 # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_f2xm1:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    f2xm1 # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_f2xm1:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    f2xm1 # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_f2xm1:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    f2xm1 # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_f2xm1:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    f2xm1 # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_f2xm1:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    f2xm1 # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_f2xm1:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    f2xm1 # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "f2xm1", ""() nounwind
  ret void
}

define void @test_fabs() optsize {
; GENERIC-LABEL: test_fabs:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fabs
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fabs:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fabs # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fabs:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fabs # sched: [1:0.50]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fabs:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fabs # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fabs:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fabs # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fabs:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fabs # sched: [1:0.33]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fabs:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fabs # sched: [1:0.33]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fabs:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fabs # sched: [1:0.33]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fabs:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fabs # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fabs:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fabs # sched: [2:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fabs", ""() nounwind
  ret void
}

define void @test_fadd(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fadd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fadd %st(0), %st(1)
; GENERIC-NEXT:    fadd %st(2)
; GENERIC-NEXT:    fadds (%ecx)
; GENERIC-NEXT:    faddl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fadd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fadd %st(0), %st(1)
; ATOM-NEXT:    fadd %st(2)
; ATOM-NEXT:    fadds (%ecx)
; ATOM-NEXT:    faddl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fadd:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; SLM-NEXT:    fadd %st(2) # sched: [3:1.00]
; SLM-NEXT:    fadds (%ecx) # sched: [6:1.00]
; SLM-NEXT:    faddl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fadd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; SANDY-NEXT:    fadd %st(2) # sched: [3:1.00]
; SANDY-NEXT:    fadds (%ecx) # sched: [10:1.00]
; SANDY-NEXT:    faddl (%eax) # sched: [10:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fadd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; HASWELL-NEXT:    fadd %st(2) # sched: [3:1.00]
; HASWELL-NEXT:    fadds (%ecx) # sched: [10:1.00]
; HASWELL-NEXT:    faddl (%eax) # sched: [10:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fadd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; BROADWELL-NEXT:    fadd %st(2) # sched: [3:1.00]
; BROADWELL-NEXT:    fadds (%ecx) # sched: [9:1.00]
; BROADWELL-NEXT:    faddl (%eax) # sched: [9:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fadd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; SKYLAKE-NEXT:    fadd %st(2) # sched: [3:1.00]
; SKYLAKE-NEXT:    fadds (%ecx) # sched: [10:1.00]
; SKYLAKE-NEXT:    faddl (%eax) # sched: [10:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fadd:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; SKX-NEXT:    fadd %st(2) # sched: [3:1.00]
; SKX-NEXT:    fadds (%ecx) # sched: [10:1.00]
; SKX-NEXT:    faddl (%eax) # sched: [10:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fadd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fadd %st(2) # sched: [3:1.00]
; BTVER2-NEXT:    fadds (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    faddl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fadd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fadd %st(0), %st(1) # sched: [3:1.00]
; ZNVER1-NEXT:    fadd %st(2) # sched: [3:1.00]
; ZNVER1-NEXT:    fadds (%ecx) # sched: [10:1.00]
; ZNVER1-NEXT:    faddl (%eax) # sched: [10:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fadd %st(0), %st(1) \0A\09 fadd %st(2), %st(0) \0A\09 fadds $0 \0A\09 faddl $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_faddp_fiadd(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_faddp_fiadd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    faddp %st(1)
; GENERIC-NEXT:    faddp %st(2)
; GENERIC-NEXT:    fiadds (%ecx)
; GENERIC-NEXT:    fiaddl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_faddp_fiadd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    faddp %st(1)
; ATOM-NEXT:    faddp %st(2)
; ATOM-NEXT:    fiadds (%ecx)
; ATOM-NEXT:    fiaddl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_faddp_fiadd:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    faddp %st(1) # sched: [3:1.00]
; SLM-NEXT:    faddp %st(2) # sched: [3:1.00]
; SLM-NEXT:    fiadds (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fiaddl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_faddp_fiadd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    faddp %st(1) # sched: [3:1.00]
; SANDY-NEXT:    faddp %st(2) # sched: [3:1.00]
; SANDY-NEXT:    fiadds (%ecx) # sched: [13:2.00]
; SANDY-NEXT:    fiaddl (%eax) # sched: [13:2.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_faddp_fiadd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    faddp %st(1) # sched: [3:1.00]
; HASWELL-NEXT:    faddp %st(2) # sched: [3:1.00]
; HASWELL-NEXT:    fiadds (%ecx) # sched: [13:2.00]
; HASWELL-NEXT:    fiaddl (%eax) # sched: [13:2.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_faddp_fiadd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    faddp %st(1) # sched: [3:1.00]
; BROADWELL-NEXT:    faddp %st(2) # sched: [3:1.00]
; BROADWELL-NEXT:    fiadds (%ecx) # sched: [12:2.00]
; BROADWELL-NEXT:    fiaddl (%eax) # sched: [12:2.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_faddp_fiadd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    faddp %st(1) # sched: [3:1.00]
; SKYLAKE-NEXT:    faddp %st(2) # sched: [3:1.00]
; SKYLAKE-NEXT:    fiadds (%ecx) # sched: [13:2.00]
; SKYLAKE-NEXT:    fiaddl (%eax) # sched: [13:2.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_faddp_fiadd:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    faddp %st(1) # sched: [3:1.00]
; SKX-NEXT:    faddp %st(2) # sched: [3:1.00]
; SKX-NEXT:    fiadds (%ecx) # sched: [13:2.00]
; SKX-NEXT:    fiaddl (%eax) # sched: [13:2.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_faddp_fiadd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    faddp %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    faddp %st(2) # sched: [3:1.00]
; BTVER2-NEXT:    fiadds (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fiaddl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_faddp_fiadd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    faddp %st(1) # sched: [3:1.00]
; ZNVER1-NEXT:    faddp %st(2) # sched: [3:1.00]
; ZNVER1-NEXT:    fiadds (%ecx) # sched: [10:1.00]
; ZNVER1-NEXT:    fiaddl (%eax) # sched: [10:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "faddp \0A\09 faddp %st(2), %st(0) \0A\09 fiadds $0 \0A\09 fiaddl $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_fbld_fbstp(i8* %a0) optsize {
; GENERIC-LABEL: test_fbld_fbstp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fbld (%eax)
; GENERIC-NEXT:    fbstp (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fbld_fbstp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fbld (%eax)
; ATOM-NEXT:    fbstp (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fbld_fbstp:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fbld (%eax) # sched: [100:1.00]
; SLM-NEXT:    fbstp (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fbld_fbstp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fbld (%eax) # sched: [100:0.33]
; SANDY-NEXT:    fbstp (%eax) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fbld_fbstp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fbld (%eax) # sched: [47:?]
; HASWELL-NEXT:    fbstp (%eax) # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fbld_fbstp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fbld (%eax) # sched: [100:0.25]
; BROADWELL-NEXT:    fbstp (%eax) # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fbld_fbstp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fbld (%eax) # sched: [100:0.25]
; SKYLAKE-NEXT:    fbstp (%eax) # sched: [1:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fbld_fbstp:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fbld (%eax) # sched: [100:0.25]
; SKX-NEXT:    fbstp (%eax) # sched: [1:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fbld_fbstp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fbld (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    fbstp (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fbld_fbstp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fbld (%eax) # sched: [100:?]
; ZNVER1-NEXT:    fbstp (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fbld $0 \0A\09 fbstp $0", "*m"(i8 *%a0) nounwind
  ret void
}

define void @test_fchs() optsize {
; GENERIC-LABEL: test_fchs:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fchs
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fchs:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fchs # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fchs:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fchs # sched: [1:0.50]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fchs:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fchs # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fchs:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fchs # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fchs:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fchs # sched: [1:0.33]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fchs:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fchs # sched: [1:0.33]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fchs:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fchs # sched: [1:0.33]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fchs:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fchs # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fchs:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fchs # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fchs", ""() nounwind
  ret void
}

define void @test_fclex() optsize {
; GENERIC-LABEL: test_fclex:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    fnclex
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fclex:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    fnclex # sched: [25:12.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fclex:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    fnclex # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fclex:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    fnclex # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fclex:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    fnclex # sched: [1:1.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fclex:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    fnclex # sched: [4:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fclex:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    fnclex # sched: [4:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fclex:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    fnclex # sched: [4:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fclex:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    fnclex # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fclex:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    fnclex # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fclex", ""() nounwind
  ret void
}

define void @test_fnclex() optsize {
; GENERIC-LABEL: test_fnclex:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fnclex
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fnclex:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fnclex # sched: [25:12.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fnclex:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fnclex # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fnclex:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fnclex # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fnclex:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fnclex # sched: [1:1.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fnclex:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fnclex # sched: [4:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fnclex:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fnclex # sched: [4:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fnclex:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fnclex # sched: [4:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fnclex:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fnclex # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fnclex:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fnclex # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fnclex", ""() nounwind
  ret void
}

define void @test_fcmov() optsize {
; GENERIC-LABEL: test_fcmov:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fcmovb %st(1), %st(0)
; GENERIC-NEXT:    fcmovbe %st(1), %st(0)
; GENERIC-NEXT:    fcmove %st(1), %st(0)
; GENERIC-NEXT:    fcmovnb %st(1), %st(0)
; GENERIC-NEXT:    fcmovnbe %st(1), %st(0)
; GENERIC-NEXT:    fcmovne %st(1), %st(0)
; GENERIC-NEXT:    fcmovnu %st(1), %st(0)
; GENERIC-NEXT:    fcmovu %st(1), %st(0)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fcmov:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fcmovb %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmovbe %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmove %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmovnb %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmovnbe %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmovne %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmovnu %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    fcmovu %st(1), %st(0) # sched: [9:4.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fcmov:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fcmovb %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmove %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmovne %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    fcmovu %st(1), %st(0) # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fcmov:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fcmovb %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmove %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmovne %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    fcmovu %st(1), %st(0) # sched: [3:2.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fcmov:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fcmovb %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmove %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmovne %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    fcmovu %st(1), %st(0) # sched: [3:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fcmov:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fcmovb %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmove %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmovne %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    fcmovu %st(1), %st(0) # sched: [3:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fcmov:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fcmovb %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmove %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmovne %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcmovu %st(1), %st(0) # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fcmov:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fcmovb %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmove %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmovne %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    fcmovu %st(1), %st(0) # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fcmov:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fcmovb %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmovbe %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmove %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmovnb %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmovnbe %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmovne %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmovnu %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    fcmovu %st(1), %st(0) # sched: [3:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fcmov:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fcmovb %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmovbe %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmove %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmovnb %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmovnbe %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmovne %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmovnu %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    fcmovu %st(1), %st(0) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fcmovb %st(1), %st(0) \0A\09 fcmovbe %st(1), %st(0) \0A\09 fcmove %st(1), %st(0) \0A\09 fcmovnb %st(1), %st(0) \0A\09 fcmovnbe %st(1), %st(0) \0A\09 fcmovne %st(1), %st(0) \0A\09 fcmovnu %st(1), %st(0) \0A\09 fcmovu %st(1), %st(0)", ""() nounwind
  ret void
}

define void @test_fcom(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fcom:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fcom %st(1)
; GENERIC-NEXT:    fcom %st(3)
; GENERIC-NEXT:    fcoms (%ecx)
; GENERIC-NEXT:    fcoml (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fcom:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fcom %st(1)
; ATOM-NEXT:    fcom %st(3)
; ATOM-NEXT:    fcoms (%ecx)
; ATOM-NEXT:    fcoml (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fcom:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fcom %st(1) # sched: [3:1.00]
; SLM-NEXT:    fcom %st(3) # sched: [3:1.00]
; SLM-NEXT:    fcoms (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fcoml (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fcom:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fcom %st(1) # sched: [1:1.00]
; SANDY-NEXT:    fcom %st(3) # sched: [1:1.00]
; SANDY-NEXT:    fcoms (%ecx) # sched: [8:1.00]
; SANDY-NEXT:    fcoml (%eax) # sched: [8:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fcom:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fcom %st(1) # sched: [1:1.00]
; HASWELL-NEXT:    fcom %st(3) # sched: [1:1.00]
; HASWELL-NEXT:    fcoms (%ecx) # sched: [8:1.00]
; HASWELL-NEXT:    fcoml (%eax) # sched: [8:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fcom:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fcom %st(1) # sched: [1:1.00]
; BROADWELL-NEXT:    fcom %st(3) # sched: [1:1.00]
; BROADWELL-NEXT:    fcoms (%ecx) # sched: [7:1.00]
; BROADWELL-NEXT:    fcoml (%eax) # sched: [7:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fcom:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fcom %st(1) # sched: [1:1.00]
; SKYLAKE-NEXT:    fcom %st(3) # sched: [1:1.00]
; SKYLAKE-NEXT:    fcoms (%ecx) # sched: [8:1.00]
; SKYLAKE-NEXT:    fcoml (%eax) # sched: [8:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fcom:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fcom %st(1) # sched: [1:1.00]
; SKX-NEXT:    fcom %st(3) # sched: [1:1.00]
; SKX-NEXT:    fcoms (%ecx) # sched: [8:1.00]
; SKX-NEXT:    fcoml (%eax) # sched: [8:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fcom:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fcom %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fcom %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    fcoms (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fcoml (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fcom:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fcom %st(1) # sched: [1:1.00]
; ZNVER1-NEXT:    fcom %st(3) # sched: [1:1.00]
; ZNVER1-NEXT:    fcoms (%ecx) # sched: [8:1.00]
; ZNVER1-NEXT:    fcoml (%eax) # sched: [8:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fcom \0A\09 fcom %st(3) \0A\09 fcoms $0 \0A\09 fcoml $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fcomp_fcompp(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fcomp_fcompp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fcomp %st(1)
; GENERIC-NEXT:    fcomp %st(3)
; GENERIC-NEXT:    fcomps (%ecx)
; GENERIC-NEXT:    fcompl (%eax)
; GENERIC-NEXT:    fcompp
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fcomp_fcompp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fcomp %st(1)
; ATOM-NEXT:    fcomp %st(3)
; ATOM-NEXT:    fcomps (%ecx)
; ATOM-NEXT:    fcompl (%eax)
; ATOM-NEXT:    fcompp # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fcomp_fcompp:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fcomp %st(1) # sched: [3:1.00]
; SLM-NEXT:    fcomp %st(3) # sched: [3:1.00]
; SLM-NEXT:    fcomps (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fcompl (%eax) # sched: [6:1.00]
; SLM-NEXT:    fcompp # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fcomp_fcompp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fcomp %st(1) # sched: [1:1.00]
; SANDY-NEXT:    fcomp %st(3) # sched: [1:1.00]
; SANDY-NEXT:    fcomps (%ecx) # sched: [8:1.00]
; SANDY-NEXT:    fcompl (%eax) # sched: [8:1.00]
; SANDY-NEXT:    fcompp # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fcomp_fcompp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fcomp %st(1) # sched: [1:1.00]
; HASWELL-NEXT:    fcomp %st(3) # sched: [1:1.00]
; HASWELL-NEXT:    fcomps (%ecx) # sched: [8:1.00]
; HASWELL-NEXT:    fcompl (%eax) # sched: [8:1.00]
; HASWELL-NEXT:    fcompp # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fcomp_fcompp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fcomp %st(1) # sched: [1:1.00]
; BROADWELL-NEXT:    fcomp %st(3) # sched: [1:1.00]
; BROADWELL-NEXT:    fcomps (%ecx) # sched: [7:1.00]
; BROADWELL-NEXT:    fcompl (%eax) # sched: [7:1.00]
; BROADWELL-NEXT:    fcompp # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fcomp_fcompp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fcomp %st(1) # sched: [1:1.00]
; SKYLAKE-NEXT:    fcomp %st(3) # sched: [1:1.00]
; SKYLAKE-NEXT:    fcomps (%ecx) # sched: [8:1.00]
; SKYLAKE-NEXT:    fcompl (%eax) # sched: [8:1.00]
; SKYLAKE-NEXT:    fcompp # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fcomp_fcompp:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fcomp %st(1) # sched: [1:1.00]
; SKX-NEXT:    fcomp %st(3) # sched: [1:1.00]
; SKX-NEXT:    fcomps (%ecx) # sched: [8:1.00]
; SKX-NEXT:    fcompl (%eax) # sched: [8:1.00]
; SKX-NEXT:    fcompp # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fcomp_fcompp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fcomp %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fcomp %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    fcomps (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fcompl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    fcompp # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fcomp_fcompp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fcomp %st(1) # sched: [1:1.00]
; ZNVER1-NEXT:    fcomp %st(3) # sched: [1:1.00]
; ZNVER1-NEXT:    fcomps (%ecx) # sched: [8:1.00]
; ZNVER1-NEXT:    fcompl (%eax) # sched: [8:1.00]
; ZNVER1-NEXT:    fcompp # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fcomp \0A\09 fcomp %st(3) \0A\09 fcomps $0 \0A\09 fcompl $1 \0A\09 fcompp", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fcomi_fcomip() optsize {
; GENERIC-LABEL: test_fcomi_fcomip:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fcomi %st(3)
; GENERIC-NEXT:    fcompi %st(3)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fcomi_fcomip:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fcomi %st(3) # sched: [9:4.50]
; ATOM-NEXT:    fcompi %st(3) # sched: [9:4.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fcomi_fcomip:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fcomi %st(3) # sched: [3:1.00]
; SLM-NEXT:    fcompi %st(3) # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fcomi_fcomip:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fcomi %st(3) # sched: [3:1.00]
; SANDY-NEXT:    fcompi %st(3) # sched: [3:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fcomi_fcomip:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fcomi %st(3) # sched: [1:0.50]
; HASWELL-NEXT:    fcompi %st(3) # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fcomi_fcomip:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fcomi %st(3) # sched: [3:1.00]
; BROADWELL-NEXT:    fcompi %st(3) # sched: [3:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fcomi_fcomip:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fcomi %st(3) # sched: [3:1.00]
; SKYLAKE-NEXT:    fcompi %st(3) # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fcomi_fcomip:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fcomi %st(3) # sched: [3:1.00]
; SKX-NEXT:    fcompi %st(3) # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fcomi_fcomip:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fcomi %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    fcompi %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fcomi_fcomip:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fcomi %st(3) # sched: [9:0.50]
; ZNVER1-NEXT:    fcompi %st(3) # sched: [9:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fcomi %st(3) \0A\09 fcomip %st(3)", ""() nounwind
  ret void
}

define void @test_fcos() optsize {
; GENERIC-LABEL: test_fcos:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fcos
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fcos:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fcos # sched: [174:87.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fcos:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fcos # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fcos:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fcos # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fcos:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fcos # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fcos:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fcos # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fcos:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fcos # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fcos:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fcos # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fcos:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fcos # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fcos:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fcos # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fcos", ""() nounwind
  ret void
}

define void @test_fdecstp() optsize {
; GENERIC-LABEL: test_fdecstp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fdecstp
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fdecstp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fdecstp # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fdecstp:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fdecstp # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fdecstp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fdecstp # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fdecstp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fdecstp # sched: [2:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fdecstp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fdecstp # sched: [2:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fdecstp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fdecstp # sched: [2:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fdecstp:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fdecstp # sched: [2:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fdecstp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fdecstp # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fdecstp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fdecstp # sched: [11:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fdecstp", ""() nounwind
  ret void
}

define void @test_fdiv(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fdiv:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fdiv %st(0), %st(1)
; GENERIC-NEXT:    fdiv %st(2)
; GENERIC-NEXT:    fdivs (%ecx)
; GENERIC-NEXT:    fdivl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fdiv:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fdiv %st(0), %st(1)
; ATOM-NEXT:    fdiv %st(2)
; ATOM-NEXT:    fdivs (%ecx)
; ATOM-NEXT:    fdivl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fdiv:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fdiv %st(0), %st(1) # sched: [34:34.00]
; SLM-NEXT:    fdiv %st(2) # sched: [34:34.00]
; SLM-NEXT:    fdivs (%ecx) # sched: [37:34.00]
; SLM-NEXT:    fdivl (%eax) # sched: [37:34.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fdiv:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fdiv %st(0), %st(1) # sched: [24:1.00]
; SANDY-NEXT:    fdiv %st(2) # sched: [24:1.00]
; SANDY-NEXT:    fdivs (%ecx) # sched: [31:1.00]
; SANDY-NEXT:    fdivl (%eax) # sched: [31:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fdiv:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fdiv %st(0), %st(1) # sched: [24:1.00]
; HASWELL-NEXT:    fdiv %st(2) # sched: [20:1.00]
; HASWELL-NEXT:    fdivs (%ecx) # sched: [31:1.00]
; HASWELL-NEXT:    fdivl (%eax) # sched: [31:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fdiv:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fdiv %st(0), %st(1) # sched: [15:1.00]
; BROADWELL-NEXT:    fdiv %st(2) # sched: [20:1.00]
; BROADWELL-NEXT:    fdivs (%ecx) # sched: [21:1.00]
; BROADWELL-NEXT:    fdivl (%eax) # sched: [21:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fdiv:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fdiv %st(0), %st(1) # sched: [15:1.00]
; SKYLAKE-NEXT:    fdiv %st(2) # sched: [20:1.00]
; SKYLAKE-NEXT:    fdivs (%ecx) # sched: [22:1.00]
; SKYLAKE-NEXT:    fdivl (%eax) # sched: [22:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fdiv:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fdiv %st(0), %st(1) # sched: [15:1.00]
; SKX-NEXT:    fdiv %st(2) # sched: [20:1.00]
; SKX-NEXT:    fdivs (%ecx) # sched: [22:1.00]
; SKX-NEXT:    fdivl (%eax) # sched: [22:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fdiv:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fdiv %st(0), %st(1) # sched: [19:19.00]
; BTVER2-NEXT:    fdiv %st(2) # sched: [19:19.00]
; BTVER2-NEXT:    fdivs (%ecx) # sched: [24:19.00]
; BTVER2-NEXT:    fdivl (%eax) # sched: [24:19.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fdiv:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fdiv %st(0), %st(1) # sched: [15:1.00]
; ZNVER1-NEXT:    fdiv %st(2) # sched: [15:1.00]
; ZNVER1-NEXT:    fdivs (%ecx) # sched: [22:1.00]
; ZNVER1-NEXT:    fdivl (%eax) # sched: [22:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fdiv %st(0), %st(1) \0A\09 fdiv %st(2), %st(0) \0A\09 fdivs $0 \0A\09 fdivl $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fdivp_fidiv(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_fdivp_fidiv:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fdivp %st(1)
; GENERIC-NEXT:    fdivp %st(2)
; GENERIC-NEXT:    fidivs (%ecx)
; GENERIC-NEXT:    fidivl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fdivp_fidiv:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fdivp %st(1)
; ATOM-NEXT:    fdivp %st(2)
; ATOM-NEXT:    fidivs (%ecx)
; ATOM-NEXT:    fidivl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fdivp_fidiv:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fdivp %st(1) # sched: [34:34.00]
; SLM-NEXT:    fdivp %st(2) # sched: [34:34.00]
; SLM-NEXT:    fidivs (%ecx) # sched: [37:34.00]
; SLM-NEXT:    fidivl (%eax) # sched: [37:34.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fdivp_fidiv:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fdivp %st(1) # sched: [24:1.00]
; SANDY-NEXT:    fdivp %st(2) # sched: [24:1.00]
; SANDY-NEXT:    fidivs (%ecx) # sched: [34:1.00]
; SANDY-NEXT:    fidivl (%eax) # sched: [34:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fdivp_fidiv:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fdivp %st(1) # sched: [24:1.00]
; HASWELL-NEXT:    fdivp %st(2) # sched: [24:1.00]
; HASWELL-NEXT:    fidivs (%ecx) # sched: [34:1.00]
; HASWELL-NEXT:    fidivl (%eax) # sched: [34:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fdivp_fidiv:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fdivp %st(1) # sched: [15:1.00]
; BROADWELL-NEXT:    fdivp %st(2) # sched: [15:1.00]
; BROADWELL-NEXT:    fidivs (%ecx) # sched: [24:1.00]
; BROADWELL-NEXT:    fidivl (%eax) # sched: [24:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fdivp_fidiv:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fdivp %st(1) # sched: [15:1.00]
; SKYLAKE-NEXT:    fdivp %st(2) # sched: [15:1.00]
; SKYLAKE-NEXT:    fidivs (%ecx) # sched: [25:1.00]
; SKYLAKE-NEXT:    fidivl (%eax) # sched: [25:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fdivp_fidiv:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fdivp %st(1) # sched: [15:1.00]
; SKX-NEXT:    fdivp %st(2) # sched: [15:1.00]
; SKX-NEXT:    fidivs (%ecx) # sched: [25:1.00]
; SKX-NEXT:    fidivl (%eax) # sched: [25:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fdivp_fidiv:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fdivp %st(1) # sched: [19:19.00]
; BTVER2-NEXT:    fdivp %st(2) # sched: [19:19.00]
; BTVER2-NEXT:    fidivs (%ecx) # sched: [24:19.00]
; BTVER2-NEXT:    fidivl (%eax) # sched: [24:19.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fdivp_fidiv:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fdivp %st(1) # sched: [15:1.00]
; ZNVER1-NEXT:    fdivp %st(2) # sched: [15:1.00]
; ZNVER1-NEXT:    fidivs (%ecx) # sched: [22:1.00]
; ZNVER1-NEXT:    fidivl (%eax) # sched: [22:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fdivp \0A\09 fdivp %st(2), %st(0) \0A\09 fidivs $0 \0A\09 fidivl $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_fdivr(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fdivr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fdivr %st(0), %st(1)
; GENERIC-NEXT:    fdivr %st(2)
; GENERIC-NEXT:    fdivrs (%ecx)
; GENERIC-NEXT:    fdivrl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fdivr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fdivr %st(0), %st(1)
; ATOM-NEXT:    fdivr %st(2)
; ATOM-NEXT:    fdivrs (%ecx)
; ATOM-NEXT:    fdivrl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fdivr:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fdivr %st(0), %st(1) # sched: [34:34.00]
; SLM-NEXT:    fdivr %st(2) # sched: [34:34.00]
; SLM-NEXT:    fdivrs (%ecx) # sched: [37:34.00]
; SLM-NEXT:    fdivrl (%eax) # sched: [37:34.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fdivr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fdivr %st(0), %st(1) # sched: [24:1.00]
; SANDY-NEXT:    fdivr %st(2) # sched: [24:1.00]
; SANDY-NEXT:    fdivrs (%ecx) # sched: [31:1.00]
; SANDY-NEXT:    fdivrl (%eax) # sched: [31:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fdivr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fdivr %st(0), %st(1) # sched: [20:1.00]
; HASWELL-NEXT:    fdivr %st(2) # sched: [24:1.00]
; HASWELL-NEXT:    fdivrs (%ecx) # sched: [27:1.00]
; HASWELL-NEXT:    fdivrl (%eax) # sched: [27:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fdivr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fdivr %st(0), %st(1) # sched: [20:1.00]
; BROADWELL-NEXT:    fdivr %st(2) # sched: [15:1.00]
; BROADWELL-NEXT:    fdivrs (%ecx) # sched: [26:1.00]
; BROADWELL-NEXT:    fdivrl (%eax) # sched: [26:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fdivr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fdivr %st(0), %st(1) # sched: [20:1.00]
; SKYLAKE-NEXT:    fdivr %st(2) # sched: [15:1.00]
; SKYLAKE-NEXT:    fdivrs (%ecx) # sched: [27:1.00]
; SKYLAKE-NEXT:    fdivrl (%eax) # sched: [27:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fdivr:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fdivr %st(0), %st(1) # sched: [20:1.00]
; SKX-NEXT:    fdivr %st(2) # sched: [15:1.00]
; SKX-NEXT:    fdivrs (%ecx) # sched: [27:1.00]
; SKX-NEXT:    fdivrl (%eax) # sched: [27:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fdivr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fdivr %st(0), %st(1) # sched: [19:19.00]
; BTVER2-NEXT:    fdivr %st(2) # sched: [19:19.00]
; BTVER2-NEXT:    fdivrs (%ecx) # sched: [24:19.00]
; BTVER2-NEXT:    fdivrl (%eax) # sched: [24:19.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fdivr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fdivr %st(0), %st(1) # sched: [15:1.00]
; ZNVER1-NEXT:    fdivr %st(2) # sched: [15:1.00]
; ZNVER1-NEXT:    fdivrs (%ecx) # sched: [22:1.00]
; ZNVER1-NEXT:    fdivrl (%eax) # sched: [22:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fdivr %st(0), %st(1) \0A\09 fdivr %st(2), %st(0) \0A\09 fdivrs $0 \0A\09 fdivrl $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fdivrp_fidivr(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_fdivrp_fidivr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fdivrp %st(1)
; GENERIC-NEXT:    fdivrp %st(2)
; GENERIC-NEXT:    fidivrs (%ecx)
; GENERIC-NEXT:    fidivrl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fdivrp_fidivr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fdivrp %st(1)
; ATOM-NEXT:    fdivrp %st(2)
; ATOM-NEXT:    fidivrs (%ecx)
; ATOM-NEXT:    fidivrl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fdivrp_fidivr:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fdivrp %st(1) # sched: [34:34.00]
; SLM-NEXT:    fdivrp %st(2) # sched: [34:34.00]
; SLM-NEXT:    fidivrs (%ecx) # sched: [37:34.00]
; SLM-NEXT:    fidivrl (%eax) # sched: [37:34.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fdivrp_fidivr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fdivrp %st(1) # sched: [24:1.00]
; SANDY-NEXT:    fdivrp %st(2) # sched: [24:1.00]
; SANDY-NEXT:    fidivrs (%ecx) # sched: [34:1.00]
; SANDY-NEXT:    fidivrl (%eax) # sched: [34:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fdivrp_fidivr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fdivrp %st(1) # sched: [20:1.00]
; HASWELL-NEXT:    fdivrp %st(2) # sched: [20:1.00]
; HASWELL-NEXT:    fidivrs (%ecx) # sched: [30:1.00]
; HASWELL-NEXT:    fidivrl (%eax) # sched: [30:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fdivrp_fidivr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fdivrp %st(1) # sched: [20:1.00]
; BROADWELL-NEXT:    fdivrp %st(2) # sched: [20:1.00]
; BROADWELL-NEXT:    fidivrs (%ecx) # sched: [29:1.00]
; BROADWELL-NEXT:    fidivrl (%eax) # sched: [29:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fdivrp_fidivr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fdivrp %st(1) # sched: [20:1.00]
; SKYLAKE-NEXT:    fdivrp %st(2) # sched: [20:1.00]
; SKYLAKE-NEXT:    fidivrs (%ecx) # sched: [30:1.00]
; SKYLAKE-NEXT:    fidivrl (%eax) # sched: [30:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fdivrp_fidivr:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fdivrp %st(1) # sched: [20:1.00]
; SKX-NEXT:    fdivrp %st(2) # sched: [20:1.00]
; SKX-NEXT:    fidivrs (%ecx) # sched: [30:1.00]
; SKX-NEXT:    fidivrl (%eax) # sched: [30:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fdivrp_fidivr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fdivrp %st(1) # sched: [19:19.00]
; BTVER2-NEXT:    fdivrp %st(2) # sched: [19:19.00]
; BTVER2-NEXT:    fidivrs (%ecx) # sched: [24:19.00]
; BTVER2-NEXT:    fidivrl (%eax) # sched: [24:19.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fdivrp_fidivr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fdivrp %st(1) # sched: [15:1.00]
; ZNVER1-NEXT:    fdivrp %st(2) # sched: [15:1.00]
; ZNVER1-NEXT:    fidivrs (%ecx) # sched: [22:1.00]
; ZNVER1-NEXT:    fidivrl (%eax) # sched: [22:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fdivrp \0A\09 fdivrp %st(2), %st(0) \0A\09 fidivrs $0 \0A\09 fidivrl $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_ffree() optsize {
; GENERIC-LABEL: test_ffree:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    ffree %st(0)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_ffree:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    ffree %st(0) # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_ffree:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    ffree %st(0) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_ffree:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    ffree %st(0) # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_ffree:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    ffree %st(0) # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ffree:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    ffree %st(0) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_ffree:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    ffree %st(0) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_ffree:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    ffree %st(0) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_ffree:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    ffree %st(0) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_ffree:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    ffree %st(0) # sched: [11:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "ffree %st(0)", ""() nounwind
  ret void
}

define void @test_ficom(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_ficom:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    ficoms (%ecx)
; GENERIC-NEXT:    ficoml (%eax)
; GENERIC-NEXT:    ficomps (%ecx)
; GENERIC-NEXT:    ficompl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_ficom:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    ficoms (%ecx)
; ATOM-NEXT:    ficoml (%eax)
; ATOM-NEXT:    ficomps (%ecx)
; ATOM-NEXT:    ficompl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_ficom:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    ficoms (%ecx) # sched: [6:1.00]
; SLM-NEXT:    ficoml (%eax) # sched: [6:1.00]
; SLM-NEXT:    ficomps (%ecx) # sched: [6:1.00]
; SLM-NEXT:    ficompl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_ficom:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    ficoms (%ecx) # sched: [11:2.00]
; SANDY-NEXT:    ficoml (%eax) # sched: [11:2.00]
; SANDY-NEXT:    ficomps (%ecx) # sched: [11:2.00]
; SANDY-NEXT:    ficompl (%eax) # sched: [11:2.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_ficom:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    ficoms (%ecx) # sched: [11:2.00]
; HASWELL-NEXT:    ficoml (%eax) # sched: [11:2.00]
; HASWELL-NEXT:    ficomps (%ecx) # sched: [11:2.00]
; HASWELL-NEXT:    ficompl (%eax) # sched: [11:2.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ficom:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    ficoms (%ecx) # sched: [10:2.00]
; BROADWELL-NEXT:    ficoml (%eax) # sched: [10:2.00]
; BROADWELL-NEXT:    ficomps (%ecx) # sched: [10:2.00]
; BROADWELL-NEXT:    ficompl (%eax) # sched: [10:2.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_ficom:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    ficoms (%ecx) # sched: [11:2.00]
; SKYLAKE-NEXT:    ficoml (%eax) # sched: [11:2.00]
; SKYLAKE-NEXT:    ficomps (%ecx) # sched: [11:2.00]
; SKYLAKE-NEXT:    ficompl (%eax) # sched: [11:2.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_ficom:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    ficoms (%ecx) # sched: [11:2.00]
; SKX-NEXT:    ficoml (%eax) # sched: [11:2.00]
; SKX-NEXT:    ficomps (%ecx) # sched: [11:2.00]
; SKX-NEXT:    ficompl (%eax) # sched: [11:2.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_ficom:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    ficoms (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    ficoml (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    ficomps (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    ficompl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_ficom:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    ficoms (%ecx) # sched: [12:1.50]
; ZNVER1-NEXT:    ficoml (%eax) # sched: [12:1.50]
; ZNVER1-NEXT:    ficomps (%ecx) # sched: [12:1.50]
; ZNVER1-NEXT:    ficompl (%eax) # sched: [12:1.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "ficoms $0 \0A\09 ficoml $1 \0A\09 ficomps $0 \0A\09 ficompl $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_fild(i16 *%a0, i32 *%a1, i64 *%a2) optsize {
; GENERIC-LABEL: test_fild:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    filds (%edx)
; GENERIC-NEXT:    fildl (%ecx)
; GENERIC-NEXT:    fildll (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fild:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    filds (%edx) # sched: [5:5.00]
; ATOM-NEXT:    fildl (%ecx) # sched: [5:5.00]
; ATOM-NEXT:    fildll (%eax) # sched: [5:5.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fild:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    filds (%edx) # sched: [3:1.00]
; SLM-NEXT:    fildl (%ecx) # sched: [3:1.00]
; SLM-NEXT:    fildll (%eax) # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fild:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    filds (%edx) # sched: [10:1.00]
; SANDY-NEXT:    fildl (%ecx) # sched: [10:1.00]
; SANDY-NEXT:    fildll (%eax) # sched: [10:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fild:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    filds (%edx) # sched: [10:1.00]
; HASWELL-NEXT:    fildl (%ecx) # sched: [10:1.00]
; HASWELL-NEXT:    fildll (%eax) # sched: [10:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fild:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    filds (%edx) # sched: [9:1.00]
; BROADWELL-NEXT:    fildl (%ecx) # sched: [9:1.00]
; BROADWELL-NEXT:    fildll (%eax) # sched: [9:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fild:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    filds (%edx) # sched: [10:1.00]
; SKYLAKE-NEXT:    fildl (%ecx) # sched: [10:1.00]
; SKYLAKE-NEXT:    fildll (%eax) # sched: [10:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fild:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    filds (%edx) # sched: [10:1.00]
; SKX-NEXT:    fildl (%ecx) # sched: [10:1.00]
; SKX-NEXT:    fildll (%eax) # sched: [10:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fild:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    filds (%edx) # sched: [5:1.00]
; BTVER2-NEXT:    fildl (%ecx) # sched: [5:1.00]
; BTVER2-NEXT:    fildll (%eax) # sched: [5:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fild:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    filds (%edx) # sched: [11:1.00]
; ZNVER1-NEXT:    fildl (%ecx) # sched: [11:1.00]
; ZNVER1-NEXT:    fildll (%eax) # sched: [11:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "filds $0 \0A\09 fildl $1 \0A\09 fildll $2", "*m,*m,*m"(i16 *%a0, i32 *%a1, i64 *%a2) nounwind
  ret void
}

define void @test_fincstp() optsize {
; GENERIC-LABEL: test_fincstp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fincstp
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fincstp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fincstp # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fincstp:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fincstp # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fincstp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fincstp # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fincstp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fincstp # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fincstp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fincstp # sched: [1:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fincstp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fincstp # sched: [1:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fincstp:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fincstp # sched: [1:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fincstp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fincstp # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fincstp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fincstp # sched: [11:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fincstp", ""() nounwind
  ret void
}

define void @test_finit() optsize {
; GENERIC-LABEL: test_finit:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    fninit
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_finit:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    fninit # sched: [63:31.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_finit:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    fninit # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_finit:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    fninit # sched: [5:1.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_finit:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    fninit # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_finit:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    fninit # sched: [75:6.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_finit:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    fninit # sched: [75:6.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_finit:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    fninit # sched: [75:6.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_finit:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    fninit # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_finit:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    fninit # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "finit", ""() nounwind
  ret void
}

define void @test_fninit() optsize {
; GENERIC-LABEL: test_fninit:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fninit
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fninit:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fninit # sched: [63:31.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fninit:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fninit # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fninit:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fninit # sched: [5:1.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fninit:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fninit # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fninit:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fninit # sched: [75:6.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fninit:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fninit # sched: [75:6.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fninit:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fninit # sched: [75:6.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fninit:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fninit # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fninit:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fninit # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fninit", ""() nounwind
  ret void
}

define void @test_fist_fistp_fisttp(i16* %a0, i32* %a1, i64 *%a2) optsize {
; GENERIC-LABEL: test_fist_fistp_fisttp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fists (%edx)
; GENERIC-NEXT:    fistl (%ecx)
; GENERIC-NEXT:    fistps (%edx)
; GENERIC-NEXT:    fistpl (%ecx)
; GENERIC-NEXT:    fistpll (%eax)
; GENERIC-NEXT:    fisttps (%edx)
; GENERIC-NEXT:    fisttpl (%ecx)
; GENERIC-NEXT:    fisttpll (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fist_fistp_fisttp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fists (%edx) # sched: [6:3.00]
; ATOM-NEXT:    fistl (%ecx) # sched: [6:3.00]
; ATOM-NEXT:    fistps (%edx) # sched: [6:3.00]
; ATOM-NEXT:    fistpl (%ecx) # sched: [6:3.00]
; ATOM-NEXT:    fistpll (%eax) # sched: [6:3.00]
; ATOM-NEXT:    fisttps (%edx) # sched: [2:1.00]
; ATOM-NEXT:    fisttpl (%ecx) # sched: [2:1.00]
; ATOM-NEXT:    fisttpll (%eax) # sched: [2:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fist_fistp_fisttp:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fists (%edx) # sched: [1:1.00]
; SLM-NEXT:    fistl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    fistps (%edx) # sched: [1:1.00]
; SLM-NEXT:    fistpl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    fistpll (%eax) # sched: [1:1.00]
; SLM-NEXT:    fisttps (%edx) # sched: [1:1.00]
; SLM-NEXT:    fisttpl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    fisttpll (%eax) # sched: [1:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fist_fistp_fisttp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fists (%edx) # sched: [9:1.00]
; SANDY-NEXT:    fistl (%ecx) # sched: [9:1.00]
; SANDY-NEXT:    fistps (%edx) # sched: [9:1.00]
; SANDY-NEXT:    fistpl (%ecx) # sched: [9:1.00]
; SANDY-NEXT:    fistpll (%eax) # sched: [9:1.00]
; SANDY-NEXT:    fisttps (%edx) # sched: [5:1.00]
; SANDY-NEXT:    fisttpl (%ecx) # sched: [5:1.00]
; SANDY-NEXT:    fisttpll (%eax) # sched: [5:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fist_fistp_fisttp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fists (%edx) # sched: [4:1.00]
; HASWELL-NEXT:    fistl (%ecx) # sched: [4:1.00]
; HASWELL-NEXT:    fistps (%edx) # sched: [4:1.00]
; HASWELL-NEXT:    fistpl (%ecx) # sched: [4:1.00]
; HASWELL-NEXT:    fistpll (%eax) # sched: [4:1.00]
; HASWELL-NEXT:    fisttps (%edx) # sched: [4:1.00]
; HASWELL-NEXT:    fisttpl (%ecx) # sched: [4:1.00]
; HASWELL-NEXT:    fisttpll (%eax) # sched: [4:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fist_fistp_fisttp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fists (%edx) # sched: [4:1.00]
; BROADWELL-NEXT:    fistl (%ecx) # sched: [4:1.00]
; BROADWELL-NEXT:    fistps (%edx) # sched: [4:1.00]
; BROADWELL-NEXT:    fistpl (%ecx) # sched: [4:1.00]
; BROADWELL-NEXT:    fistpll (%eax) # sched: [4:1.00]
; BROADWELL-NEXT:    fisttps (%edx) # sched: [4:1.00]
; BROADWELL-NEXT:    fisttpl (%ecx) # sched: [4:1.00]
; BROADWELL-NEXT:    fisttpll (%eax) # sched: [4:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fist_fistp_fisttp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fists (%edx) # sched: [4:1.00]
; SKYLAKE-NEXT:    fistl (%ecx) # sched: [4:1.00]
; SKYLAKE-NEXT:    fistps (%edx) # sched: [4:1.00]
; SKYLAKE-NEXT:    fistpl (%ecx) # sched: [4:1.00]
; SKYLAKE-NEXT:    fistpll (%eax) # sched: [4:1.00]
; SKYLAKE-NEXT:    fisttps (%edx) # sched: [4:1.00]
; SKYLAKE-NEXT:    fisttpl (%ecx) # sched: [4:1.00]
; SKYLAKE-NEXT:    fisttpll (%eax) # sched: [4:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fist_fistp_fisttp:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fists (%edx) # sched: [4:1.00]
; SKX-NEXT:    fistl (%ecx) # sched: [4:1.00]
; SKX-NEXT:    fistps (%edx) # sched: [4:1.00]
; SKX-NEXT:    fistpl (%ecx) # sched: [4:1.00]
; SKX-NEXT:    fistpll (%eax) # sched: [4:1.00]
; SKX-NEXT:    fisttps (%edx) # sched: [4:1.00]
; SKX-NEXT:    fisttpl (%ecx) # sched: [4:1.00]
; SKX-NEXT:    fisttpll (%eax) # sched: [4:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fist_fistp_fisttp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fists (%edx) # sched: [1:1.00]
; BTVER2-NEXT:    fistl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    fistps (%edx) # sched: [1:1.00]
; BTVER2-NEXT:    fistpl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    fistpll (%eax) # sched: [1:1.00]
; BTVER2-NEXT:    fisttps (%edx) # sched: [1:1.00]
; BTVER2-NEXT:    fisttpl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    fisttpll (%eax) # sched: [1:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fist_fistp_fisttp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fists (%edx) # sched: [12:0.50]
; ZNVER1-NEXT:    fistl (%ecx) # sched: [12:0.50]
; ZNVER1-NEXT:    fistps (%edx) # sched: [12:0.50]
; ZNVER1-NEXT:    fistpl (%ecx) # sched: [12:0.50]
; ZNVER1-NEXT:    fistpll (%eax) # sched: [12:0.50]
; ZNVER1-NEXT:    fisttps (%edx) # sched: [12:0.50]
; ZNVER1-NEXT:    fisttpl (%ecx) # sched: [12:0.50]
; ZNVER1-NEXT:    fisttpll (%eax) # sched: [12:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fists $0 \0A\09 fistl $1 \0A\09 fistps $0 \0A\09 fistpl $1 \0A\09 fistpll $2 \0A\09 fisttps $0 \0A\09 fisttpl $1 \0A\09 fisttpll $2", "*m,*m,*m"(i16* %a0, i32* %a1, i64 *%a2) nounwind
  ret void
}

define void @test_fld(i16* %a0, i32* %a1, i64 *%a2) optsize {
; GENERIC-LABEL: test_fld:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fld %st(0)
; GENERIC-NEXT:    flds (%edx)
; GENERIC-NEXT:    fldl (%ecx)
; GENERIC-NEXT:    fldt (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fld:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fld %st(0) # sched: [1:1.00]
; ATOM-NEXT:    flds (%edx) # sched: [1:1.00]
; ATOM-NEXT:    fldl (%ecx) # sched: [1:1.00]
; ATOM-NEXT:    fldt (%eax) # sched: [4:2.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fld:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fld %st(0) # sched: [1:0.50]
; SLM-NEXT:    flds (%edx) # sched: [3:1.00]
; SLM-NEXT:    fldl (%ecx) # sched: [3:1.00]
; SLM-NEXT:    fldt (%eax) # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fld:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fld %st(0) # sched: [1:1.00]
; SANDY-NEXT:    flds (%edx) # sched: [9:1.00]
; SANDY-NEXT:    fldl (%ecx) # sched: [9:1.00]
; SANDY-NEXT:    fldt (%eax) # sched: [9:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fld:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fld %st(0) # sched: [1:0.50]
; HASWELL-NEXT:    flds (%edx) # sched: [7:0.50]
; HASWELL-NEXT:    fldl (%ecx) # sched: [7:0.50]
; HASWELL-NEXT:    fldt (%eax) # sched: [7:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fld:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fld %st(0) # sched: [1:0.25]
; BROADWELL-NEXT:    flds (%edx) # sched: [6:0.50]
; BROADWELL-NEXT:    fldl (%ecx) # sched: [6:0.50]
; BROADWELL-NEXT:    fldt (%eax) # sched: [6:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fld:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fld %st(0) # sched: [1:0.25]
; SKYLAKE-NEXT:    flds (%edx) # sched: [7:0.50]
; SKYLAKE-NEXT:    fldl (%ecx) # sched: [7:0.50]
; SKYLAKE-NEXT:    fldt (%eax) # sched: [7:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fld:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fld %st(0) # sched: [1:0.25]
; SKX-NEXT:    flds (%edx) # sched: [7:0.50]
; SKX-NEXT:    fldl (%ecx) # sched: [7:0.50]
; SKX-NEXT:    fldt (%eax) # sched: [7:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fld:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fld %st(0) # sched: [1:0.50]
; BTVER2-NEXT:    flds (%edx) # sched: [5:1.00]
; BTVER2-NEXT:    fldl (%ecx) # sched: [5:1.00]
; BTVER2-NEXT:    fldt (%eax) # sched: [5:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fld:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fld %st(0) # sched: [1:0.50]
; ZNVER1-NEXT:    flds (%edx) # sched: [8:0.50]
; ZNVER1-NEXT:    fldl (%ecx) # sched: [8:0.50]
; ZNVER1-NEXT:    fldt (%eax) # sched: [1:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fld %st(0) \0A\09 flds $0 \0A\09 fldl $1 \0A\09 fldt $2", "*m,*m,*m"(i16* %a0, i32* %a1, i64 *%a2) nounwind
  ret void
}

define void @test_fldcw_fldenv(i8* %a0) optsize {
; GENERIC-LABEL: test_fldcw_fldenv:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fldcw (%eax)
; GENERIC-NEXT:    fldenv (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fldcw_fldenv:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fldcw (%eax) # sched: [5:2.50]
; ATOM-NEXT:    fldenv (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fldcw_fldenv:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fldcw (%eax) # sched: [3:1.00]
; SLM-NEXT:    fldenv (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fldcw_fldenv:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fldcw (%eax) # sched: [8:2.00]
; SANDY-NEXT:    fldenv (%eax) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fldcw_fldenv:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fldcw (%eax) # sched: [7:1.00]
; HASWELL-NEXT:    fldenv (%eax) # sched: [61:14.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fldcw_fldenv:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fldcw (%eax) # sched: [7:1.00]
; BROADWELL-NEXT:    fldenv (%eax) # sched: [60:14.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fldcw_fldenv:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fldcw (%eax) # sched: [7:1.00]
; SKYLAKE-NEXT:    fldenv (%eax) # sched: [62:14.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fldcw_fldenv:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fldcw (%eax) # sched: [7:1.00]
; SKX-NEXT:    fldenv (%eax) # sched: [62:14.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fldcw_fldenv:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fldcw (%eax) # sched: [5:1.00]
; BTVER2-NEXT:    fldenv (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fldcw_fldenv:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fldcw (%eax) # sched: [100:?]
; ZNVER1-NEXT:    fldenv (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fldcw $0 \0A\09 fldenv $0", "*m"(i8* %a0) nounwind
  ret void
}

define void @test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz() optsize {
; GENERIC-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fld1
; GENERIC-NEXT:    fldl2e
; GENERIC-NEXT:    fldl2t
; GENERIC-NEXT:    fldln2
; GENERIC-NEXT:    fldpi
; GENERIC-NEXT:    fldz
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fld1 # sched: [6:3.00]
; ATOM-NEXT:    fldl2e # sched: [10:5.00]
; ATOM-NEXT:    fldl2t # sched: [10:5.00]
; ATOM-NEXT:    fldln2 # sched: [10:5.00]
; ATOM-NEXT:    fldpi # sched: [10:5.00]
; ATOM-NEXT:    fldz # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fld1 # sched: [1:?]
; SLM-NEXT:    fldl2e # sched: [100:1.00]
; SLM-NEXT:    fldl2t # sched: [100:1.00]
; SLM-NEXT:    fldln2 # sched: [100:1.00]
; SLM-NEXT:    fldpi # sched: [100:1.00]
; SLM-NEXT:    fldz # sched: [1:?]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fld1 # sched: [1:?]
; SANDY-NEXT:    fldl2e # sched: [100:0.33]
; SANDY-NEXT:    fldl2t # sched: [100:0.33]
; SANDY-NEXT:    fldln2 # sched: [100:0.33]
; SANDY-NEXT:    fldpi # sched: [100:0.33]
; SANDY-NEXT:    fldz # sched: [1:?]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fld1 # sched: [1:?]
; HASWELL-NEXT:    fldl2e # sched: [100:0.25]
; HASWELL-NEXT:    fldl2t # sched: [100:0.25]
; HASWELL-NEXT:    fldln2 # sched: [100:0.25]
; HASWELL-NEXT:    fldpi # sched: [1:0.50]
; HASWELL-NEXT:    fldz # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fld1 # sched: [1:?]
; BROADWELL-NEXT:    fldl2e # sched: [100:0.25]
; BROADWELL-NEXT:    fldl2t # sched: [100:0.25]
; BROADWELL-NEXT:    fldln2 # sched: [100:0.25]
; BROADWELL-NEXT:    fldpi # sched: [100:0.25]
; BROADWELL-NEXT:    fldz # sched: [1:?]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fld1 # sched: [1:?]
; SKYLAKE-NEXT:    fldl2e # sched: [100:0.25]
; SKYLAKE-NEXT:    fldl2t # sched: [100:0.25]
; SKYLAKE-NEXT:    fldln2 # sched: [100:0.25]
; SKYLAKE-NEXT:    fldpi # sched: [100:0.25]
; SKYLAKE-NEXT:    fldz # sched: [1:?]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fld1 # sched: [1:?]
; SKX-NEXT:    fldl2e # sched: [100:0.25]
; SKX-NEXT:    fldl2t # sched: [100:0.25]
; SKX-NEXT:    fldln2 # sched: [100:0.25]
; SKX-NEXT:    fldpi # sched: [100:0.25]
; SKX-NEXT:    fldz # sched: [1:?]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fld1 # sched: [1:?]
; BTVER2-NEXT:    fldl2e # sched: [100:0.17]
; BTVER2-NEXT:    fldl2t # sched: [100:0.17]
; BTVER2-NEXT:    fldln2 # sched: [100:0.17]
; BTVER2-NEXT:    fldpi # sched: [100:0.17]
; BTVER2-NEXT:    fldz # sched: [1:?]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fld1_fldl2e_fldl2t_fldlg2_fldln2_fldpi_fldz:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fld1 # sched: [11:1.00]
; ZNVER1-NEXT:    fldl2e # sched: [100:?]
; ZNVER1-NEXT:    fldl2t # sched: [100:?]
; ZNVER1-NEXT:    fldln2 # sched: [100:?]
; ZNVER1-NEXT:    fldpi # sched: [11:1.00]
; ZNVER1-NEXT:    fldz # sched: [8:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fld1 \0A\09 fldl2e \0A\09 fldl2t \0A\09 fldln2 \0A\09 fldpi \0A\09 fldz", ""() nounwind
  ret void
}

define void @test_fmul(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fmul:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fmul %st(0), %st(1)
; GENERIC-NEXT:    fmul %st(2)
; GENERIC-NEXT:    fmuls (%ecx)
; GENERIC-NEXT:    fmull (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fmul:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fmul %st(0), %st(1)
; ATOM-NEXT:    fmul %st(2)
; ATOM-NEXT:    fmuls (%ecx)
; ATOM-NEXT:    fmull (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fmul:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fmul %st(0), %st(1) # sched: [5:2.00]
; SLM-NEXT:    fmul %st(2) # sched: [5:2.00]
; SLM-NEXT:    fmuls (%ecx) # sched: [8:2.00]
; SLM-NEXT:    fmull (%eax) # sched: [8:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fmul:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fmul %st(0), %st(1) # sched: [5:1.00]
; SANDY-NEXT:    fmul %st(2) # sched: [5:1.00]
; SANDY-NEXT:    fmuls (%ecx) # sched: [12:1.00]
; SANDY-NEXT:    fmull (%eax) # sched: [12:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fmul:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fmul %st(0), %st(1) # sched: [5:1.00]
; HASWELL-NEXT:    fmul %st(2) # sched: [5:1.00]
; HASWELL-NEXT:    fmuls (%ecx) # sched: [12:1.00]
; HASWELL-NEXT:    fmull (%eax) # sched: [12:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fmul:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fmul %st(0), %st(1) # sched: [5:1.00]
; BROADWELL-NEXT:    fmul %st(2) # sched: [5:1.00]
; BROADWELL-NEXT:    fmuls (%ecx) # sched: [11:1.00]
; BROADWELL-NEXT:    fmull (%eax) # sched: [11:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fmul:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fmul %st(0), %st(1) # sched: [4:1.00]
; SKYLAKE-NEXT:    fmul %st(2) # sched: [4:1.00]
; SKYLAKE-NEXT:    fmuls (%ecx) # sched: [11:1.00]
; SKYLAKE-NEXT:    fmull (%eax) # sched: [11:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fmul:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fmul %st(0), %st(1) # sched: [4:1.00]
; SKX-NEXT:    fmul %st(2) # sched: [4:1.00]
; SKX-NEXT:    fmuls (%ecx) # sched: [11:1.00]
; SKX-NEXT:    fmull (%eax) # sched: [11:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fmul:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fmul %st(0), %st(1) # sched: [2:1.00]
; BTVER2-NEXT:    fmul %st(2) # sched: [2:1.00]
; BTVER2-NEXT:    fmuls (%ecx) # sched: [7:1.00]
; BTVER2-NEXT:    fmull (%eax) # sched: [7:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fmul:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fmul %st(0), %st(1) # sched: [5:1.00]
; ZNVER1-NEXT:    fmul %st(2) # sched: [5:1.00]
; ZNVER1-NEXT:    fmuls (%ecx) # sched: [12:1.00]
; ZNVER1-NEXT:    fmull (%eax) # sched: [12:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fmul %st(0), %st(1) \0A\09 fmul %st(2), %st(0) \0A\09 fmuls $0 \0A\09 fmull $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fmulp_fimul(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_fmulp_fimul:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fmulp %st(1)
; GENERIC-NEXT:    fmulp %st(2)
; GENERIC-NEXT:    fimuls (%ecx)
; GENERIC-NEXT:    fimull (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fmulp_fimul:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fmulp %st(1)
; ATOM-NEXT:    fmulp %st(2)
; ATOM-NEXT:    fimuls (%ecx)
; ATOM-NEXT:    fimull (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fmulp_fimul:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fmulp %st(1) # sched: [5:2.00]
; SLM-NEXT:    fmulp %st(2) # sched: [5:2.00]
; SLM-NEXT:    fimuls (%ecx) # sched: [8:2.00]
; SLM-NEXT:    fimull (%eax) # sched: [8:2.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fmulp_fimul:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fmulp %st(1) # sched: [5:1.00]
; SANDY-NEXT:    fmulp %st(2) # sched: [5:1.00]
; SANDY-NEXT:    fimuls (%ecx) # sched: [15:1.00]
; SANDY-NEXT:    fimull (%eax) # sched: [15:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fmulp_fimul:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fmulp %st(1) # sched: [5:1.00]
; HASWELL-NEXT:    fmulp %st(2) # sched: [5:1.00]
; HASWELL-NEXT:    fimuls (%ecx) # sched: [15:1.00]
; HASWELL-NEXT:    fimull (%eax) # sched: [15:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fmulp_fimul:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fmulp %st(1) # sched: [5:1.00]
; BROADWELL-NEXT:    fmulp %st(2) # sched: [5:1.00]
; BROADWELL-NEXT:    fimuls (%ecx) # sched: [14:1.00]
; BROADWELL-NEXT:    fimull (%eax) # sched: [14:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fmulp_fimul:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fmulp %st(1) # sched: [4:1.00]
; SKYLAKE-NEXT:    fmulp %st(2) # sched: [4:1.00]
; SKYLAKE-NEXT:    fimuls (%ecx) # sched: [14:1.00]
; SKYLAKE-NEXT:    fimull (%eax) # sched: [14:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fmulp_fimul:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fmulp %st(1) # sched: [4:1.00]
; SKX-NEXT:    fmulp %st(2) # sched: [4:1.00]
; SKX-NEXT:    fimuls (%ecx) # sched: [14:1.00]
; SKX-NEXT:    fimull (%eax) # sched: [14:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fmulp_fimul:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fmulp %st(1) # sched: [2:1.00]
; BTVER2-NEXT:    fmulp %st(2) # sched: [2:1.00]
; BTVER2-NEXT:    fimuls (%ecx) # sched: [7:1.00]
; BTVER2-NEXT:    fimull (%eax) # sched: [7:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fmulp_fimul:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fmulp %st(1) # sched: [5:1.00]
; ZNVER1-NEXT:    fmulp %st(2) # sched: [5:1.00]
; ZNVER1-NEXT:    fimuls (%ecx) # sched: [12:1.00]
; ZNVER1-NEXT:    fimull (%eax) # sched: [12:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fmulp \0A\09 fmulp %st(2), %st(0) \0A\09 fimuls $0 \0A\09 fimull $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_fnop() optsize {
; GENERIC-LABEL: test_fnop:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fnop
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fnop:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fnop # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fnop:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fnop # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fnop:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fnop # sched: [1:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fnop:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fnop # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fnop:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fnop # sched: [1:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fnop:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fnop # sched: [1:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fnop:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fnop # sched: [1:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fnop:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fnop # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fnop:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fnop # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fnop", ""() nounwind
  ret void
}

define void @test_fpatan() optsize {
; GENERIC-LABEL: test_fpatan:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fpatan
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fpatan:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fpatan # sched: [183:91.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fpatan:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fpatan # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fpatan:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fpatan # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fpatan:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fpatan # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fpatan:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fpatan # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fpatan:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fpatan # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fpatan:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fpatan # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fpatan:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fpatan # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fpatan:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fpatan # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fpatan", ""() nounwind
  ret void
}

define void @test_fprem_fprem1() optsize {
; GENERIC-LABEL: test_fprem_fprem1:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fprem
; GENERIC-NEXT:    fprem1
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fprem_fprem1:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fprem # sched: [55:27.50]
; ATOM-NEXT:    fprem1 # sched: [71:35.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fprem_fprem1:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fprem # sched: [100:1.00]
; SLM-NEXT:    fprem1 # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fprem_fprem1:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fprem # sched: [100:0.33]
; SANDY-NEXT:    fprem1 # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fprem_fprem1:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fprem # sched: [19:?]
; HASWELL-NEXT:    fprem1 # sched: [19:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fprem_fprem1:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fprem # sched: [100:0.25]
; BROADWELL-NEXT:    fprem1 # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fprem_fprem1:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fprem # sched: [100:0.25]
; SKYLAKE-NEXT:    fprem1 # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fprem_fprem1:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fprem # sched: [100:0.25]
; SKX-NEXT:    fprem1 # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fprem_fprem1:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fprem # sched: [100:0.17]
; BTVER2-NEXT:    fprem1 # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fprem_fprem1:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fprem # sched: [100:?]
; ZNVER1-NEXT:    fprem1 # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fprem \0A\09 fprem1", ""() nounwind
  ret void
}

define void @test_fptan() optsize {
; GENERIC-LABEL: test_fptan:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fptan
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fptan:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fptan # sched: [168:84.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fptan:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fptan # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fptan:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fptan # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fptan:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fptan # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fptan:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fptan # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fptan:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fptan # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fptan:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fptan # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fptan:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fptan # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fptan:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fptan # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fptan", ""() nounwind
  ret void
}

define void @test_frndint() optsize {
; GENERIC-LABEL: test_frndint:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    frndint
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_frndint:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    frndint # sched: [46:23.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_frndint:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    frndint # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_frndint:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    frndint # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_frndint:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    frndint # sched: [11:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_frndint:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    frndint # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_frndint:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    frndint # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_frndint:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    frndint # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_frndint:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    frndint # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_frndint:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    frndint # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "frndint", ""() nounwind
  ret void
}

define void @test_frstor(i8* %a0) optsize {
; GENERIC-LABEL: test_frstor:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    frstor (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_frstor:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    frstor (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_frstor:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    frstor (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_frstor:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    frstor (%eax) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_frstor:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    frstor (%eax) # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_frstor:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    frstor (%eax) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_frstor:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    frstor (%eax) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_frstor:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    frstor (%eax) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_frstor:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    frstor (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_frstor:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    frstor (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "frstor $0", "*m"(i8* %a0) nounwind
  ret void
}

define void @test_fsave(i8* %a0) optsize {
; GENERIC-LABEL: test_fsave:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    fnsave (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsave:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    fnsave (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsave:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    fnsave (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsave:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    fnsave (%eax) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsave:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    fnsave (%eax) # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsave:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    fnsave (%eax) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsave:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    fnsave (%eax) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsave:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    fnsave (%eax) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsave:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    fnsave (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsave:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    fnsave (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsave $0", "*m"(i8* %a0) nounwind
  ret void
}

define void @test_fnsave(i8* %a0) optsize {
; GENERIC-LABEL: test_fnsave:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fnsave (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fnsave:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fnsave (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fnsave:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fnsave (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fnsave:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fnsave (%eax) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fnsave:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fnsave (%eax) # sched: [1:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fnsave:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fnsave (%eax) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fnsave:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fnsave (%eax) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fnsave:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fnsave (%eax) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fnsave:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fnsave (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fnsave:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fnsave (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fnsave $0", "*m"(i8* %a0) nounwind
  ret void
}

define void @test_fscale() optsize {
; GENERIC-LABEL: test_fscale:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fscale
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fscale:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fscale # sched: [77:38.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fscale:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fscale # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fscale:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fscale # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fscale:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fscale # sched: [75:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fscale:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fscale # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fscale:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fscale # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fscale:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fscale # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fscale:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fscale # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fscale:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fscale # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fscale", ""() nounwind
  ret void
}

define void @test_fsin() optsize {
; GENERIC-LABEL: test_fsin:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsin
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsin:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsin # sched: [174:87.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsin:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fsin # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsin:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsin # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsin:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsin # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsin:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsin # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsin:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsin # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsin:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fsin # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsin:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsin # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsin:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsin # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsin", ""() nounwind
  ret void
}

define void @test_fsincos() optsize {
; GENERIC-LABEL: test_fsincos:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsincos
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsincos:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsincos # sched: [174:87.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsincos:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fsincos # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsincos:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsincos # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsincos:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsincos # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsincos:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsincos # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsincos:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsincos # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsincos:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fsincos # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsincos:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsincos # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsincos:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsincos # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsincos", ""() nounwind
  ret void
}

define void @test_fsqrt() optsize {
; GENERIC-LABEL: test_fsqrt:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsqrt
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsqrt:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsqrt # sched: [71:35.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsqrt:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fsqrt # sched: [15:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsqrt:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsqrt # sched: [14:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsqrt:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsqrt # sched: [15:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsqrt:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsqrt # sched: [15:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsqrt:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsqrt # sched: [15:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsqrt:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fsqrt # sched: [15:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsqrt:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsqrt # sched: [21:21.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsqrt:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsqrt # sched: [20:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsqrt", ""() nounwind
  ret void
}

define void @test_fst_fstp(i16* %a0, i32* %a1, i64 *%a2) optsize {
; GENERIC-LABEL: test_fst_fstp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fst %st(0)
; GENERIC-NEXT:    fsts (%edx)
; GENERIC-NEXT:    fstl (%ecx)
; GENERIC-NEXT:    fstp %st(0)
; GENERIC-NEXT:    fstpl (%edx)
; GENERIC-NEXT:    fstpl (%ecx)
; GENERIC-NEXT:    fstpt (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fst_fstp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fst %st(0) # sched: [2:1.00]
; ATOM-NEXT:    fsts (%edx) # sched: [2:1.00]
; ATOM-NEXT:    fstl (%ecx) # sched: [2:1.00]
; ATOM-NEXT:    fstp %st(0) # sched: [2:1.00]
; ATOM-NEXT:    fstpl (%edx) # sched: [2:1.00]
; ATOM-NEXT:    fstpl (%ecx) # sched: [2:1.00]
; ATOM-NEXT:    fstpt (%eax) # sched: [5:2.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fst_fstp:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fst %st(0) # sched: [1:0.50]
; SLM-NEXT:    fsts (%edx) # sched: [1:1.00]
; SLM-NEXT:    fstl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    fstp %st(0) # sched: [1:0.50]
; SLM-NEXT:    fstpl (%edx) # sched: [1:1.00]
; SLM-NEXT:    fstpl (%ecx) # sched: [1:1.00]
; SLM-NEXT:    fstpt (%eax) # sched: [1:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fst_fstp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fst %st(0) # sched: [1:1.00]
; SANDY-NEXT:    fsts (%edx) # sched: [6:1.00]
; SANDY-NEXT:    fstl (%ecx) # sched: [6:1.00]
; SANDY-NEXT:    fstp %st(0) # sched: [1:1.00]
; SANDY-NEXT:    fstpl (%edx) # sched: [6:1.00]
; SANDY-NEXT:    fstpl (%ecx) # sched: [6:1.00]
; SANDY-NEXT:    fstpt (%eax) # sched: [6:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fst_fstp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fst %st(0) # sched: [1:0.50]
; HASWELL-NEXT:    fsts (%edx) # sched: [1:1.00]
; HASWELL-NEXT:    fstl (%ecx) # sched: [1:1.00]
; HASWELL-NEXT:    fstp %st(0) # sched: [1:0.50]
; HASWELL-NEXT:    fstpl (%edx) # sched: [1:1.00]
; HASWELL-NEXT:    fstpl (%ecx) # sched: [1:1.00]
; HASWELL-NEXT:    fstpt (%eax) # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fst_fstp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fst %st(0) # sched: [1:0.25]
; BROADWELL-NEXT:    fsts (%edx) # sched: [1:1.00]
; BROADWELL-NEXT:    fstl (%ecx) # sched: [1:1.00]
; BROADWELL-NEXT:    fstp %st(0) # sched: [1:0.25]
; BROADWELL-NEXT:    fstpl (%edx) # sched: [1:1.00]
; BROADWELL-NEXT:    fstpl (%ecx) # sched: [1:1.00]
; BROADWELL-NEXT:    fstpt (%eax) # sched: [1:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fst_fstp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fst %st(0) # sched: [1:0.25]
; SKYLAKE-NEXT:    fsts (%edx) # sched: [1:1.00]
; SKYLAKE-NEXT:    fstl (%ecx) # sched: [1:1.00]
; SKYLAKE-NEXT:    fstp %st(0) # sched: [1:0.25]
; SKYLAKE-NEXT:    fstpl (%edx) # sched: [1:1.00]
; SKYLAKE-NEXT:    fstpl (%ecx) # sched: [1:1.00]
; SKYLAKE-NEXT:    fstpt (%eax) # sched: [1:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fst_fstp:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fst %st(0) # sched: [1:0.25]
; SKX-NEXT:    fsts (%edx) # sched: [1:1.00]
; SKX-NEXT:    fstl (%ecx) # sched: [1:1.00]
; SKX-NEXT:    fstp %st(0) # sched: [1:0.25]
; SKX-NEXT:    fstpl (%edx) # sched: [1:1.00]
; SKX-NEXT:    fstpl (%ecx) # sched: [1:1.00]
; SKX-NEXT:    fstpt (%eax) # sched: [1:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fst_fstp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fst %st(0) # sched: [1:0.50]
; BTVER2-NEXT:    fsts (%edx) # sched: [1:1.00]
; BTVER2-NEXT:    fstl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    fstp %st(0) # sched: [1:0.50]
; BTVER2-NEXT:    fstpl (%edx) # sched: [1:1.00]
; BTVER2-NEXT:    fstpl (%ecx) # sched: [1:1.00]
; BTVER2-NEXT:    fstpt (%eax) # sched: [1:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fst_fstp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %edx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fst %st(0) # sched: [5:0.50]
; ZNVER1-NEXT:    fsts (%edx) # sched: [1:0.50]
; ZNVER1-NEXT:    fstl (%ecx) # sched: [1:0.50]
; ZNVER1-NEXT:    fstp %st(0) # sched: [5:0.50]
; ZNVER1-NEXT:    fstpl (%edx) # sched: [1:0.50]
; ZNVER1-NEXT:    fstpl (%ecx) # sched: [1:0.50]
; ZNVER1-NEXT:    fstpt (%eax) # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fst %st(0) \0A\09 fsts $0 \0A\09 fstl $1 \0A\09 fstp %st(0) \0A\09 fstpl $0 \0A\09 fstpl $1 \0A\09 fstpt $2", "*m,*m,*m"(i16* %a0, i32* %a1, i64 *%a2) nounwind
  ret void
}

define void @test_fstcw_fstenv_fstsw(i8* %a0) optsize {
; GENERIC-LABEL: test_fstcw_fstenv_fstsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    fnstcw (%eax)
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    fnstenv (%eax)
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    fnstsw (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fstcw_fstenv_fstsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    fnstcw (%eax) # sched: [8:4.00]
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    fnstenv (%eax)
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    fnstsw (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fstcw_fstenv_fstsw:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    fnstcw (%eax) # sched: [1:0.50]
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    fnstenv (%eax) # sched: [100:1.00]
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    fnstsw (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fstcw_fstenv_fstsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    fnstcw (%eax) # sched: [7:1.00]
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    fnstenv (%eax) # sched: [100:0.33]
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    fnstsw (%eax) # sched: [7:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fstcw_fstenv_fstsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    fnstenv (%eax) # sched: [115:19.50]
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    fnstsw (%eax) # sched: [4:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fstcw_fstenv_fstsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    fnstenv (%eax) # sched: [115:19.50]
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    fnstsw (%eax) # sched: [4:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fstcw_fstenv_fstsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    fnstenv (%eax) # sched: [106:19.50]
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    fnstsw (%eax) # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fstcw_fstenv_fstsw:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    fnstenv (%eax) # sched: [106:19.50]
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    fnstsw (%eax) # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fstcw_fstenv_fstsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    fnstcw (%eax) # sched: [1:0.50]
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    fnstenv (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    fnstsw (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fstcw_fstenv_fstsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    fnstcw (%eax) # sched: [100:?]
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    fnstenv (%eax) # sched: [100:?]
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    fnstsw (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fstcw $0 \0A\09 fstenv $0 \0A\09 fstsw $0", "*m"(i8* %a0) nounwind
  ret void
}

define void @test_fnstcw_fnstenv_fnstsw(i8* %a0) optsize {
; GENERIC-LABEL: test_fnstcw_fnstenv_fnstsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fnstcw (%eax)
; GENERIC-NEXT:    fnstenv (%eax)
; GENERIC-NEXT:    fnstsw (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fnstcw_fnstenv_fnstsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fnstcw (%eax) # sched: [8:4.00]
; ATOM-NEXT:    fnstenv (%eax)
; ATOM-NEXT:    fnstsw (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fnstcw_fnstenv_fnstsw:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fnstcw (%eax) # sched: [1:0.50]
; SLM-NEXT:    fnstenv (%eax) # sched: [100:1.00]
; SLM-NEXT:    fnstsw (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fnstcw_fnstenv_fnstsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fnstcw (%eax) # sched: [7:1.00]
; SANDY-NEXT:    fnstenv (%eax) # sched: [100:0.33]
; SANDY-NEXT:    fnstsw (%eax) # sched: [7:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fnstcw_fnstenv_fnstsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; HASWELL-NEXT:    fnstenv (%eax) # sched: [115:19.50]
; HASWELL-NEXT:    fnstsw (%eax) # sched: [4:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fnstcw_fnstenv_fnstsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; BROADWELL-NEXT:    fnstenv (%eax) # sched: [115:19.50]
; BROADWELL-NEXT:    fnstsw (%eax) # sched: [4:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fnstcw_fnstenv_fnstsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; SKYLAKE-NEXT:    fnstenv (%eax) # sched: [106:19.50]
; SKYLAKE-NEXT:    fnstsw (%eax) # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fnstcw_fnstenv_fnstsw:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fnstcw (%eax) # sched: [2:1.00]
; SKX-NEXT:    fnstenv (%eax) # sched: [106:19.50]
; SKX-NEXT:    fnstsw (%eax) # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fnstcw_fnstenv_fnstsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fnstcw (%eax) # sched: [1:0.50]
; BTVER2-NEXT:    fnstenv (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    fnstsw (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fnstcw_fnstenv_fnstsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fnstcw (%eax) # sched: [100:?]
; ZNVER1-NEXT:    fnstenv (%eax) # sched: [100:?]
; ZNVER1-NEXT:    fnstsw (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fnstcw $0 \0A\09 fnstenv $0 \0A\09 fnstsw $0", "*m"(i8* %a0) nounwind
  ret void
}

define void @test_fsub(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fsub:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsub %st(0), %st(1)
; GENERIC-NEXT:    fsub %st(2)
; GENERIC-NEXT:    fsubs (%ecx)
; GENERIC-NEXT:    fsubl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsub:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsub %st(0), %st(1)
; ATOM-NEXT:    fsub %st(2)
; ATOM-NEXT:    fsubs (%ecx)
; ATOM-NEXT:    fsubl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsub:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; SLM-NEXT:    fsub %st(2) # sched: [3:1.00]
; SLM-NEXT:    fsubs (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fsubl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsub:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; SANDY-NEXT:    fsub %st(2) # sched: [3:1.00]
; SANDY-NEXT:    fsubs (%ecx) # sched: [10:1.00]
; SANDY-NEXT:    fsubl (%eax) # sched: [10:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsub:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; HASWELL-NEXT:    fsub %st(2) # sched: [3:1.00]
; HASWELL-NEXT:    fsubs (%ecx) # sched: [10:1.00]
; HASWELL-NEXT:    fsubl (%eax) # sched: [10:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsub:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; BROADWELL-NEXT:    fsub %st(2) # sched: [3:1.00]
; BROADWELL-NEXT:    fsubs (%ecx) # sched: [9:1.00]
; BROADWELL-NEXT:    fsubl (%eax) # sched: [9:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsub:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; SKYLAKE-NEXT:    fsub %st(2) # sched: [3:1.00]
; SKYLAKE-NEXT:    fsubs (%ecx) # sched: [10:1.00]
; SKYLAKE-NEXT:    fsubl (%eax) # sched: [10:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsub:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; SKX-NEXT:    fsub %st(2) # sched: [3:1.00]
; SKX-NEXT:    fsubs (%ecx) # sched: [10:1.00]
; SKX-NEXT:    fsubl (%eax) # sched: [10:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsub:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fsub %st(2) # sched: [3:1.00]
; BTVER2-NEXT:    fsubs (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fsubl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsub:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsub %st(0), %st(1) # sched: [3:1.00]
; ZNVER1-NEXT:    fsub %st(2) # sched: [3:1.00]
; ZNVER1-NEXT:    fsubs (%ecx) # sched: [10:1.00]
; ZNVER1-NEXT:    fsubl (%eax) # sched: [10:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsub %st(0), %st(1) \0A\09 fsub %st(2), %st(0) \0A\09 fsubs $0 \0A\09 fsubl $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fsubp_fisub(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_fsubp_fisub:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsubp %st(1)
; GENERIC-NEXT:    fsubp %st(2)
; GENERIC-NEXT:    fisubs (%ecx)
; GENERIC-NEXT:    fisubl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsubp_fisub:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsubp %st(1)
; ATOM-NEXT:    fsubp %st(2)
; ATOM-NEXT:    fisubs (%ecx)
; ATOM-NEXT:    fisubl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsubp_fisub:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fsubp %st(1) # sched: [3:1.00]
; SLM-NEXT:    fsubp %st(2) # sched: [3:1.00]
; SLM-NEXT:    fisubs (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fisubl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsubp_fisub:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsubp %st(1) # sched: [3:1.00]
; SANDY-NEXT:    fsubp %st(2) # sched: [3:1.00]
; SANDY-NEXT:    fisubs (%ecx) # sched: [13:2.00]
; SANDY-NEXT:    fisubl (%eax) # sched: [13:2.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsubp_fisub:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsubp %st(1) # sched: [3:1.00]
; HASWELL-NEXT:    fsubp %st(2) # sched: [3:1.00]
; HASWELL-NEXT:    fisubs (%ecx) # sched: [13:2.00]
; HASWELL-NEXT:    fisubl (%eax) # sched: [13:2.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsubp_fisub:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsubp %st(1) # sched: [3:1.00]
; BROADWELL-NEXT:    fsubp %st(2) # sched: [3:1.00]
; BROADWELL-NEXT:    fisubs (%ecx) # sched: [12:2.00]
; BROADWELL-NEXT:    fisubl (%eax) # sched: [12:2.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsubp_fisub:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsubp %st(1) # sched: [3:1.00]
; SKYLAKE-NEXT:    fsubp %st(2) # sched: [3:1.00]
; SKYLAKE-NEXT:    fisubs (%ecx) # sched: [13:2.00]
; SKYLAKE-NEXT:    fisubl (%eax) # sched: [13:2.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsubp_fisub:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fsubp %st(1) # sched: [3:1.00]
; SKX-NEXT:    fsubp %st(2) # sched: [3:1.00]
; SKX-NEXT:    fisubs (%ecx) # sched: [13:2.00]
; SKX-NEXT:    fisubl (%eax) # sched: [13:2.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsubp_fisub:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsubp %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fsubp %st(2) # sched: [3:1.00]
; BTVER2-NEXT:    fisubs (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fisubl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsubp_fisub:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsubp %st(1) # sched: [3:1.00]
; ZNVER1-NEXT:    fsubp %st(2) # sched: [3:1.00]
; ZNVER1-NEXT:    fisubs (%ecx) # sched: [10:1.00]
; ZNVER1-NEXT:    fisubl (%eax) # sched: [10:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsubp \0A\09 fsubp %st(2), %st(0) \0A\09 fisubs $0 \0A\09 fisubl $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_fsubr(float *%a0, double *%a1) optsize {
; GENERIC-LABEL: test_fsubr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsubr %st(0), %st(1)
; GENERIC-NEXT:    fsubr %st(2)
; GENERIC-NEXT:    fsubrs (%ecx)
; GENERIC-NEXT:    fsubrl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsubr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsubr %st(0), %st(1)
; ATOM-NEXT:    fsubr %st(2)
; ATOM-NEXT:    fsubrs (%ecx)
; ATOM-NEXT:    fsubrl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsubr:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; SLM-NEXT:    fsubr %st(2) # sched: [3:1.00]
; SLM-NEXT:    fsubrs (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fsubrl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsubr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; SANDY-NEXT:    fsubr %st(2) # sched: [3:1.00]
; SANDY-NEXT:    fsubrs (%ecx) # sched: [10:1.00]
; SANDY-NEXT:    fsubrl (%eax) # sched: [10:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsubr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; HASWELL-NEXT:    fsubr %st(2) # sched: [3:1.00]
; HASWELL-NEXT:    fsubrs (%ecx) # sched: [10:1.00]
; HASWELL-NEXT:    fsubrl (%eax) # sched: [10:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsubr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; BROADWELL-NEXT:    fsubr %st(2) # sched: [3:1.00]
; BROADWELL-NEXT:    fsubrs (%ecx) # sched: [9:1.00]
; BROADWELL-NEXT:    fsubrl (%eax) # sched: [9:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsubr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; SKYLAKE-NEXT:    fsubr %st(2) # sched: [3:1.00]
; SKYLAKE-NEXT:    fsubrs (%ecx) # sched: [10:1.00]
; SKYLAKE-NEXT:    fsubrl (%eax) # sched: [10:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsubr:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; SKX-NEXT:    fsubr %st(2) # sched: [3:1.00]
; SKX-NEXT:    fsubrs (%ecx) # sched: [10:1.00]
; SKX-NEXT:    fsubrl (%eax) # sched: [10:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsubr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fsubr %st(2) # sched: [3:1.00]
; BTVER2-NEXT:    fsubrs (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fsubrl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsubr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsubr %st(0), %st(1) # sched: [3:1.00]
; ZNVER1-NEXT:    fsubr %st(2) # sched: [3:1.00]
; ZNVER1-NEXT:    fsubrs (%ecx) # sched: [10:1.00]
; ZNVER1-NEXT:    fsubrl (%eax) # sched: [10:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsubr %st(0), %st(1) \0A\09 fsubr %st(2), %st(0) \0A\09 fsubrs $0 \0A\09 fsubrl $1", "*m,*m"(float *%a0, double *%a1) nounwind
  ret void
}

define void @test_fsubrp_fisubr(i16 *%a0, i32 *%a1) optsize {
; GENERIC-LABEL: test_fsubrp_fisubr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fsubrp %st(1)
; GENERIC-NEXT:    fsubrp %st(2)
; GENERIC-NEXT:    fisubrs (%ecx)
; GENERIC-NEXT:    fisubrl (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fsubrp_fisubr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fsubrp %st(1)
; ATOM-NEXT:    fsubrp %st(2)
; ATOM-NEXT:    fisubrs (%ecx)
; ATOM-NEXT:    fisubrl (%eax)
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fsubrp_fisubr:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; SLM-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; SLM-NEXT:    fisubrs (%ecx) # sched: [6:1.00]
; SLM-NEXT:    fisubrl (%eax) # sched: [6:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fsubrp_fisubr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; SANDY-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; SANDY-NEXT:    fisubrs (%ecx) # sched: [13:2.00]
; SANDY-NEXT:    fisubrl (%eax) # sched: [13:2.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fsubrp_fisubr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; HASWELL-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; HASWELL-NEXT:    fisubrs (%ecx) # sched: [13:2.00]
; HASWELL-NEXT:    fisubrl (%eax) # sched: [13:2.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fsubrp_fisubr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; BROADWELL-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; BROADWELL-NEXT:    fisubrs (%ecx) # sched: [12:2.00]
; BROADWELL-NEXT:    fisubrl (%eax) # sched: [12:2.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fsubrp_fisubr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; SKYLAKE-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; SKYLAKE-NEXT:    fisubrs (%ecx) # sched: [13:2.00]
; SKYLAKE-NEXT:    fisubrl (%eax) # sched: [13:2.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fsubrp_fisubr:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; SKX-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; SKX-NEXT:    fisubrs (%ecx) # sched: [13:2.00]
; SKX-NEXT:    fisubrl (%eax) # sched: [13:2.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fsubrp_fisubr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; BTVER2-NEXT:    fisubrs (%ecx) # sched: [8:1.00]
; BTVER2-NEXT:    fisubrl (%eax) # sched: [8:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fsubrp_fisubr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %ecx # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fsubrp %st(1) # sched: [3:1.00]
; ZNVER1-NEXT:    fsubrp %st(2) # sched: [3:1.00]
; ZNVER1-NEXT:    fisubrs (%ecx) # sched: [10:1.00]
; ZNVER1-NEXT:    fisubrl (%eax) # sched: [10:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fsubrp \0A\09 fsubrp %st(2), %st(0) \0A\09 fisubrs $0 \0A\09 fisubrl $1", "*m,*m"(i16 *%a0, i32 *%a1) nounwind
  ret void
}

define void @test_ftst() optsize {
; GENERIC-LABEL: test_ftst:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    ftst
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_ftst:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    ftst # sched: [9:4.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_ftst:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    ftst # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_ftst:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    ftst # sched: [3:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_ftst:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    ftst # sched: [1:1.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ftst:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    ftst # sched: [3:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_ftst:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    ftst # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_ftst:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    ftst # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_ftst:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    ftst # sched: [3:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_ftst:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    ftst # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "ftst", ""() nounwind
  ret void
}

define void @test_fucom_fucomp_fucompp() optsize {
; GENERIC-LABEL: test_fucom_fucomp_fucompp:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fucom %st(1)
; GENERIC-NEXT:    fucom %st(3)
; GENERIC-NEXT:    fucomp %st(1)
; GENERIC-NEXT:    fucomp %st(3)
; GENERIC-NEXT:    fucompp
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fucom_fucomp_fucompp:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fucom %st(1) # sched: [1:1.00]
; ATOM-NEXT:    fucom %st(3) # sched: [1:1.00]
; ATOM-NEXT:    fucomp %st(1) # sched: [1:1.00]
; ATOM-NEXT:    fucomp %st(3) # sched: [1:1.00]
; ATOM-NEXT:    fucompp # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fucom_fucomp_fucompp:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fucom %st(1) # sched: [3:1.00]
; SLM-NEXT:    fucom %st(3) # sched: [3:1.00]
; SLM-NEXT:    fucomp %st(1) # sched: [3:1.00]
; SLM-NEXT:    fucomp %st(3) # sched: [3:1.00]
; SLM-NEXT:    fucompp # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fucom_fucomp_fucompp:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fucom %st(1) # sched: [1:1.00]
; SANDY-NEXT:    fucom %st(3) # sched: [1:1.00]
; SANDY-NEXT:    fucomp %st(1) # sched: [1:1.00]
; SANDY-NEXT:    fucomp %st(3) # sched: [1:1.00]
; SANDY-NEXT:    fucompp # sched: [3:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fucom_fucomp_fucompp:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fucom %st(1) # sched: [1:1.00]
; HASWELL-NEXT:    fucom %st(3) # sched: [1:1.00]
; HASWELL-NEXT:    fucomp %st(1) # sched: [1:1.00]
; HASWELL-NEXT:    fucomp %st(3) # sched: [1:1.00]
; HASWELL-NEXT:    fucompp # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fucom_fucomp_fucompp:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fucom %st(1) # sched: [1:1.00]
; BROADWELL-NEXT:    fucom %st(3) # sched: [1:1.00]
; BROADWELL-NEXT:    fucomp %st(1) # sched: [1:1.00]
; BROADWELL-NEXT:    fucomp %st(3) # sched: [1:1.00]
; BROADWELL-NEXT:    fucompp # sched: [3:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fucom_fucomp_fucompp:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fucom %st(1) # sched: [1:1.00]
; SKYLAKE-NEXT:    fucom %st(3) # sched: [1:1.00]
; SKYLAKE-NEXT:    fucomp %st(1) # sched: [1:1.00]
; SKYLAKE-NEXT:    fucomp %st(3) # sched: [1:1.00]
; SKYLAKE-NEXT:    fucompp # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fucom_fucomp_fucompp:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fucom %st(1) # sched: [1:1.00]
; SKX-NEXT:    fucom %st(3) # sched: [1:1.00]
; SKX-NEXT:    fucomp %st(1) # sched: [1:1.00]
; SKX-NEXT:    fucomp %st(3) # sched: [1:1.00]
; SKX-NEXT:    fucompp # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fucom_fucomp_fucompp:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fucom %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fucom %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    fucomp %st(1) # sched: [3:1.00]
; BTVER2-NEXT:    fucomp %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    fucompp # sched: [3:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fucom_fucomp_fucompp:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fucom %st(1) # sched: [1:1.00]
; ZNVER1-NEXT:    fucom %st(3) # sched: [1:1.00]
; ZNVER1-NEXT:    fucomp %st(1) # sched: [1:1.00]
; ZNVER1-NEXT:    fucomp %st(3) # sched: [1:1.00]
; ZNVER1-NEXT:    fucompp # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fucom \0A\09 fucom %st(3) \0A\09 fucomp \0A\09 fucomp %st(3) \0A\09 fucompp", ""() nounwind
  ret void
}

define void @test_fucomi_fucomip() optsize {
; GENERIC-LABEL: test_fucomi_fucomip:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fucomi %st(3)
; GENERIC-NEXT:    fucompi %st(3)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fucomi_fucomip:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fucomi %st(3) # sched: [9:4.50]
; ATOM-NEXT:    fucompi %st(3) # sched: [9:4.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fucomi_fucomip:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fucomi %st(3) # sched: [3:1.00]
; SLM-NEXT:    fucompi %st(3) # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fucomi_fucomip:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fucomi %st(3) # sched: [3:1.00]
; SANDY-NEXT:    fucompi %st(3) # sched: [3:1.00]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fucomi_fucomip:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fucomi %st(3) # sched: [1:0.50]
; HASWELL-NEXT:    fucompi %st(3) # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fucomi_fucomip:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fucomi %st(3) # sched: [3:1.00]
; BROADWELL-NEXT:    fucompi %st(3) # sched: [3:1.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fucomi_fucomip:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fucomi %st(3) # sched: [3:1.00]
; SKYLAKE-NEXT:    fucompi %st(3) # sched: [3:1.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fucomi_fucomip:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fucomi %st(3) # sched: [3:1.00]
; SKX-NEXT:    fucompi %st(3) # sched: [3:1.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fucomi_fucomip:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fucomi %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    fucompi %st(3) # sched: [3:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fucomi_fucomip:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fucomi %st(3) # sched: [9:0.50]
; ZNVER1-NEXT:    fucompi %st(3) # sched: [9:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fucomi %st(3) \0A\09 fucomip %st(3)", ""() nounwind
  ret void
}

define void @test_fwait() optsize {
; GENERIC-LABEL: test_fwait:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    wait
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fwait:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    wait # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fwait:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    wait # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fwait:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    wait # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fwait:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    wait # sched: [1:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fwait:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    wait # sched: [2:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fwait:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    wait # sched: [2:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fwait:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    wait # sched: [2:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fwait:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    wait # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fwait:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    wait # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fwait", ""() nounwind
  ret void
}

define void @test_fxam() optsize {
; GENERIC-LABEL: test_fxam:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fxam
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fxam:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fxam # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fxam:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fxam # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fxam:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fxam # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fxam:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fxam # sched: [1:2.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fxam:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fxam # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fxam:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fxam # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fxam:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fxam # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fxam:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fxam # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fxam:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fxam # sched: [1:1.00]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fxam", ""() nounwind
  ret void
}

define void @test_fxch() optsize {
; GENERIC-LABEL: test_fxch:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fxch %st(1)
; GENERIC-NEXT:    fxch %st(3)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fxch:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fxch %st(1) # sched: [1:1.00]
; ATOM-NEXT:    fxch %st(3) # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fxch:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fxch %st(1) # sched: [1:0.50]
; SLM-NEXT:    fxch %st(3) # sched: [1:0.50]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fxch:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fxch %st(1) # sched: [1:0.33]
; SANDY-NEXT:    fxch %st(3) # sched: [1:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fxch:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fxch %st(1) # sched: [17:4.00]
; HASWELL-NEXT:    fxch %st(3) # sched: [17:4.00]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fxch:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fxch %st(1) # sched: [14:4.00]
; BROADWELL-NEXT:    fxch %st(3) # sched: [14:4.00]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fxch:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fxch %st(1) # sched: [17:4.00]
; SKYLAKE-NEXT:    fxch %st(3) # sched: [17:4.00]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fxch:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fxch %st(1) # sched: [17:4.00]
; SKX-NEXT:    fxch %st(3) # sched: [17:4.00]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fxch:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fxch %st(1) # sched: [1:0.50]
; BTVER2-NEXT:    fxch %st(3) # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fxch:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fxch %st(1) # sched: [1:0.25]
; ZNVER1-NEXT:    fxch %st(3) # sched: [1:0.25]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fxch \0A\09 fxch %st(3)", ""() nounwind
  ret void
}

define void @test_fxrstor_fxsave(i8* %a0) optsize {
; GENERIC-LABEL: test_fxrstor_fxsave:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fxrstor (%eax)
; GENERIC-NEXT:    fxsave (%eax)
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fxrstor_fxsave:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [1:1.00]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fxrstor (%eax) # sched: [141:70.50]
; ATOM-NEXT:    fxsave (%eax) # sched: [140:70.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fxrstor_fxsave:
; SLM:       # %bb.0:
; SLM-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [3:1.00]
; SLM-NEXT:    #APP
; SLM-NEXT:    fxrstor (%eax) # sched: [100:1.00]
; SLM-NEXT:    fxsave (%eax) # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fxrstor_fxsave:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fxrstor (%eax) # sched: [5:2.00]
; SANDY-NEXT:    fxsave (%eax) # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fxrstor_fxsave:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fxrstor (%eax) # sched: [64:16.50]
; HASWELL-NEXT:    fxsave (%eax) # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fxrstor_fxsave:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fxrstor (%eax) # sched: [63:16.50]
; BROADWELL-NEXT:    fxsave (%eax) # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fxrstor_fxsave:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fxrstor (%eax) # sched: [63:16.50]
; SKYLAKE-NEXT:    fxsave (%eax) # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fxrstor_fxsave:
; SKX:       # %bb.0:
; SKX-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:0.50]
; SKX-NEXT:    #APP
; SKX-NEXT:    fxrstor (%eax) # sched: [63:16.50]
; SKX-NEXT:    fxsave (%eax) # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fxrstor_fxsave:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fxrstor (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    fxsave (%eax) # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fxrstor_fxsave:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl {{[0-9]+}}(%esp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fxrstor (%eax) # sched: [100:?]
; ZNVER1-NEXT:    fxsave (%eax) # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fxrstor $0 \0A\09 fxsave $0", "*m"(i8 *%a0) nounwind
  ret void
}

define void @test_fxtract() optsize {
; GENERIC-LABEL: test_fxtract:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fxtract
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fxtract:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fxtract # sched: [25:12.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fxtract:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fxtract # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fxtract:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fxtract # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fxtract:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fxtract # sched: [15:?]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fxtract:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fxtract # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fxtract:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fxtract # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fxtract:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fxtract # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fxtract:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fxtract # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fxtract:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fxtract # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fxtract", ""() nounwind
  ret void
}

define void @test_fyl2x() optsize {
; GENERIC-LABEL: test_fyl2x:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fyl2x
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fyl2x:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fyl2x # sched: [146:73.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fyl2x:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fyl2x # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fyl2x:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fyl2x # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fyl2x:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fyl2x # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fyl2x:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fyl2x # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fyl2x:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fyl2x # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fyl2x:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fyl2x # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fyl2x:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fyl2x # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fyl2x:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fyl2x # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fyl2x", ""() nounwind
  ret void
}

define void @test_fyl2xp1() optsize {
; GENERIC-LABEL: test_fyl2xp1:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    fyl2xp1
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retl
;
; ATOM-LABEL: test_fyl2xp1:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    fyl2xp1 # sched: [147:73.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retl # sched: [79:39.50]
;
; SLM-LABEL: test_fyl2xp1:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    fyl2xp1 # sched: [100:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retl # sched: [4:1.00]
;
; SANDY-LABEL: test_fyl2xp1:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    fyl2xp1 # sched: [100:0.33]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retl # sched: [5:1.00]
;
; HASWELL-LABEL: test_fyl2xp1:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    fyl2xp1 # sched: [100:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retl # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fyl2xp1:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    fyl2xp1 # sched: [100:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retl # sched: [6:0.50]
;
; SKYLAKE-LABEL: test_fyl2xp1:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    fyl2xp1 # sched: [100:0.25]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retl # sched: [6:0.50]
;
; SKX-LABEL: test_fyl2xp1:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    fyl2xp1 # sched: [100:0.25]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retl # sched: [6:0.50]
;
; BTVER2-LABEL: test_fyl2xp1:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    fyl2xp1 # sched: [100:0.17]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retl # sched: [4:1.00]
;
; ZNVER1-LABEL: test_fyl2xp1:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    fyl2xp1 # sched: [100:?]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retl # sched: [1:0.50]
  tail call void asm sideeffect "fyl2xp1", ""() nounwind
  ret void
}
