(* Cache *)

module type S =
  sig
    type key
    and thing
    and t
    val create : int option -> t
    val find : t -> key -> thing
    val mem : t -> key -> bool
    val add : t -> key -> thing -> unit
    val remove : t -> key -> unit
  end
;;

module Make :
  functor (K : Map.OrderedType) ->
    functor (T : Map.OrderedType) ->
      sig
        type key = K.t
        and thing = T.t
        type t
        val create : int option -> t
        val decay : t -> unit
        val statistics : t -> int * int * float
        val find : t -> key -> thing
        val remove : t -> key -> unit
        val mem : t -> key -> bool
        val kick : t -> unit
        val add : t -> key -> thing -> unit
      end
;;
