(* Debug *)
(* $Id: debug.ml,v 1.2 2004/10/24 20:27:24 berke Exp $ *)

let sf = Printf.sprintf;;

let mutex = Mutex.create ();;

let level = ref 0;;

let enable = ref false;;

let debug l x =
  if !enable && l >= !level then
    begin
      Mutex.lock mutex;
      Printf.eprintf "debug(%03d,%05d): %s\n%!" l (Thread.id (Thread.self ())) x;
      Mutex.unlock mutex
    end
  else
   ()
;;
