# Contributing

Contributions are welcome, and they are greatly appreciated!. You can contribute
code, documentation, tests, bug reports. Every little bit helps, and credit will
always be given. If you plan to make a contribution it would be great if you
first announce that on [the issue
tracker](https://github.com/textX/Arpeggio/issues).

You can contribute in many ways:


## Types of Contributions


### Report Bugs

Report bugs at https://github.com/textX/Arpeggio/issues.

If you are reporting a bug, please include:

- Your operating system name and version.
- Any details about your local setup that might be helpful in troubleshooting.
- Detailed steps to reproduce the bug.


### Fix Bugs

Look through the GitHub issues for bugs. Anything tagged with "bug"
and "help wanted" is open to whoever wants to implement it.


### Implement Features

Look through the GitHub issues for features. Anything tagged with "enhancement"
and "help wanted" is open to whoever wants to implement it.


### Write Documentation

Arpeggio could always use more documentation, whether as part of the official
Arpeggio docs, in docstrings, or even on the web in blog posts, articles, and
such.

#### How to Test the Documentation Locally

Arpeggio is currently using `mkdocs`, a documentation generator, to generate the docs into html files. 

To test the docs locally, you need to follow the first 3 instructions at the
[Get Started!](#get-started) section

1. Fork the repo (one-time effort)
2. Clone your fork locally (one-time effort)
3. Create a virtualenv for the fork and install the relevant libraries (one-time effort)

Once you complete the above 3 instructions, you can now:

4. Activate the virtualenv
5. Run `mkdocs serve` at the root folder

`mkdocs` will run a webserver that serves the documentation at 127.0.0.1:8000

To make changes to the configurations, you can look at `mkdocs.yml`. For more
information on how to use mkdocs, visit this [site](https://www.mkdocs.org).


### Submit Feedback

The best way to send feedback is to file an issue at https://github.com/textX/Arpeggio/issues.

If you are proposing a feature:

- Explain in detail how it would work.
- Keep the scope as narrow as possible, to make it easier to implement.
- Remember that this is a volunteer-driven project, and that contributions
  are welcome :)


## Get Started!

Ready to contribute? Here's how to set up `Arpeggio` for local development.

1. Fork the `Arpeggio` repo on GitHub.
2. Clone your fork locally:

        $ git clone git@github.com:your_name_here/Arpeggio.git

3. Install your local copy into a virtualenv. This is how you set up your fork
   for local development:

        $ cd Arpeggio/
        $ python -m venv venv
        $ source venv/bin/activate
        $ ./install-dev.sh 
        
    Previous stuff is needed only the first time. To continue working on Arpeggio
    later you just do:
    
        $ cd Arpeggio/ 
        $ source venv/bin/activate
        
    Note that on Windows sourcing syntax is a bit different. Check the docs for
    virtualenv.
        
    An excellent overview of available tools for Python environments management
    can be found
    [here](https://stackoverflow.com/questions/41573587/what-is-the-difference-between-venv-pyvenv-pyenv-virtualenv-virtualenvwrappe)
    
    To verify that everything is setup properly run tests:
    
        $ flake8
        $ py.test tests/functional/

4. Create a branch for local development::

        $ git checkout -b name-of-your-bugfix-or-feature

   Now you can make your changes locally.

5. When you're done making changes, check that your changes pass flake8, the
   tests, and have a look at the coverage:

        $ flake8
        $ py.test tests/functional/
        $ coverage run --source textx -m py.test tests/functional
        $ coverage report
        
   You can run all this at once with provided script `runtests.sh`
   
        $ ./runtests.sh

   In case you have doubts, have also a look at the html rendered version of
   the coverage results:

        $ coverage html

6. Commit your changes and push your branch to GitHub:

        $ git add .
        $ git commit -m "Your detailed description of your changes."
        $ git push origin name-of-your-bugfix-or-feature

7. Submit a pull request through the GitHub website.


## Pull Request Guidelines

Before you submit a pull request, check that it meets these guidelines:

1. The pull request should include tests.
2. If the pull request adds/changes functionality, the docs should be updated. 
3. The pull request should work for Python 2.7, 3.4-3.9. Check
   https://travis-ci.org/textX/Arpeggio/pull_requests and make sure that
   the tests pass for all supported Python versions.


## Tips

To run a subset of tests:

```
$ py.test tests/functional/mytest.py
```

or a single test:

```
$ py.test tests/functional/mytest.py::some_test
```

## Credit

This guide is based on the guide generated by
[Cookiecutter](https://github.com/audreyr/cookiecutter) and
[cookiecutter-pypackage](https://github.com/audreyr/cookiecutter-pypackage)
project template.
