//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_7.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot7(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[7] = {8.511544299759415e-02,7.721379200427774e-01,2.180591888450458e+00,4.389792886731011e+00,7.554091326101782e+00,
    1.198999303982387e+01,1.852827749585251e+01};
  constexpr double aw[7] = {5.364059097120906e-01,2.731056090642467e-01,6.850553422346542e-02,7.850054726457971e-03,3.550926135519249e-04,
    4.716484355018926e-06,8.628591168125084e-09};
  constexpr double x[2688] = {  2.187235449243685e-02, -7.216449908844757e-04,  1.766322980898774e-05, -3.788598193822189e-07,  7.472865435056214e-09,
 -1.381072040123164e-10,  2.402904284587878e-12, -3.925318517977418e-14,  5.937257612886869e-16, -8.068773109352462e-18,  9.035027649788086e-20, -5.809925062741621e-22,
  1.917916231932218e-01, -5.816314014756365e-03,  1.187707192919499e-04, -1.791317024252973e-06,  1.643625989010003e-08,  7.390060250982390e-11, -7.100367954512990e-12,
  1.704941632551193e-13, -2.272358399805795e-15,  1.601474004149456e-18,  8.259441143270304e-19, -2.497754871034135e-20,  5.050466488132147e-01, -1.279423859250741e-02,
  1.635866432924753e-04, -5.168896847830135e-08, -4.332662456669450e-08,  7.391586628446417e-10,  2.993528596873103e-12, -3.462808746677262e-13,  5.073075209939575e-15,
  5.700888756913151e-17, -3.384808893092452e-18,  3.802949577631861e-20,  9.105779456266846e-01, -1.704174118926619e-02,  4.405210630803340e-05,  3.206019101508534e-06,
 -2.414182832243934e-08, -1.043232842745426e-09,  1.366497531882922e-11,  3.922597153456752e-13, -7.878672693026652e-15, -1.535443009333224e-16,  4.544659434604632e-18,
  5.769095163979387e-20,  1.337902220470671e+00, -1.544516429812154e-02, -1.325189014338238e-04,  1.797052485440749e-06,  5.706265302779759e-08, -3.390768749609117e-11,
 -2.320583503130131e-11, -2.486231124976777e-13,  7.755054519938264e-15,  2.100043899345689e-16, -1.360821142574701e-18, -1.241827497164250e-19,  1.706616199984202e+00,
 -8.845843247793110e-03, -1.643829875549629e-04, -1.768238198219510e-06,  5.402174402218704e-09,  7.042287351556878e-10,  1.500626823492906e-11,  9.192292040913722e-14,
 -4.011387597994247e-15, -1.446062009765191e-16, -1.969435906537675e-18,  1.536403706887918e-20,  1.941567804621391e+00, -2.021622446896800e-03, -5.084012463247011e-05,
 -1.086771004556638e-06, -2.043717656929403e-08, -3.351822575891532e-10, -4.518909176500251e-12, -3.913236722806935e-14,  2.346787467600234e-16,  2.167154529259654e-17,
  6.506054629516426e-19,  1.418268570486816e-20,  1.924220922830611e-02, -5.966830794996899e-04,  1.375237107241545e-05, -2.785960056829655e-07,  5.208435311502835e-09,
 -9.172444936119920e-11,  1.530796400100492e-12, -2.425844515581833e-14,  3.615374908556653e-16, -5.022545153541604e-18,  6.170435350185047e-20, -6.292726028464087e-22,
  1.702969515148359e-01, -4.947601174298139e-03,  9.887566269825675e-05, -1.524293836620341e-06,  1.655530102078531e-08, -4.720499284062867e-11, -3.301274836473575e-12,
  1.032498689509960e-13, -1.836518255295267e-15,  1.786113628907653e-17,  1.013505796152134e-19, -9.323303972735486e-21,  4.564680098790541e-01, -1.149867744416778e-02,
  1.592993319520029e-04, -6.256967494298135e-07, -2.851062836467235e-08,  7.140502729928164e-10, -4.285872148271703e-12, -1.734752717246212e-13,  5.159667701961672e-15,
 -3.844359212711492e-17, -1.347458594447962e-18,  4.463038077492622e-20,  8.433482766628716e-01, -1.654345567300993e-02,  7.958476022985203e-05,  2.673821078910317e-06,
 -4.100131464140777e-08, -6.157357439339967e-10,  2.055531186327218e-11,  8.947328206224483e-14, -9.867741249186125e-15,  4.137386890020604e-17,  4.328368621094203e-18,
 -5.941077740831134e-20,  1.274159421752714e+00, -1.640379349635436e-02, -1.056017263738368e-04,  2.672590548595611e-06,  5.042355271960442e-08, -6.400031618511338e-10,
 -2.569457216821197e-11,  9.910856572740105e-14,  1.300277894600811e-14,  4.706233927835317e-17, -6.442162216804825e-18, -7.637472076938367e-20,  1.668471962714134e+00,
 -1.024311257415196e-02, -1.845534413019673e-04, -1.549011016288129e-06,  2.319955355052880e-08,  1.075463325698298e-09,  1.490620586857521e-11, -1.322588349482976e-13,
 -1.026012898502027e-14, -1.856331846098716e-16,  6.300936812469330e-19,  1.121273424121166e-19,  1.932576708299651e+00, -2.486616874747861e-03, -6.608461075177543e-05,
 -1.473633660225511e-06, -2.830590436078155e-08, -4.550012503163098e-10, -5.348234300721971e-12, -1.267468647912938e-14,  1.667902671145331e-15,  6.400979046916242e-17,
  1.569767142115839e-18,  2.823186857073738e-20,  1.705617281862375e-02, -4.987475350202651e-04,  1.085457799916443e-05, -2.081501969009986e-07,  3.692424651560921e-09,
 -6.198016803668480e-11,  9.894469895387583e-13, -1.515635588523683e-14,  2.190531844744619e-16, -3.043037773632025e-18,  3.912344525420423e-20, -3.795815630970199e-22,
  1.519789438989625e-01, -4.225354233322222e-03,  8.213076070136857e-05, -1.270395470553155e-06,  1.502131404021558e-08, -9.777886693864252e-11, -1.134553529719231e-12,
  5.492771025951629e-14, -1.192854098945775e-15,  1.653063379431679e-17, -1.099529873231160e-19, -1.317936217290973e-21,  4.129649651452105e-01, -1.026102897890846e-02,
  1.495033741367163e-04, -9.745426727594717e-07, -1.556174427976096e-08,  5.699967055492823e-10, -7.093426923231430e-12, -3.744253677428609e-14,  3.221318984618408e-15,
 -5.950611164912262e-17,  1.234135779284392e-19,  2.174083947841050e-20,  7.786342636269266e-01, -1.579034659501261e-02,  1.074157690123097e-04,  1.946324493119519e-06,
 -4.835451498614231e-08, -1.256030129984228e-10,  1.906709759880508e-11, -1.751826951928300e-13, -6.036788176120177e-15,  1.480718161965005e-16,  8.771354841596052e-19,
 -7.781599388623354e-20,  1.207075552708190e+00, -1.710779011058538e-02, -6.921629364646227e-05,  3.345252229700696e-06,  3.192436010936950e-08, -1.176677571959289e-09,
 -1.721819289924381e-11,  4.888985836266586e-13,  9.698778461760717e-15, -2.270768174519436e-16, -5.870695722610082e-18,  1.104055546066694e-19,  1.624440144300159e+00,
 -1.178583059092687e-02, -2.001468589844218e-04, -9.883081498708652e-07,  4.776991484790364e-08,  1.345948158660088e-09,  5.702277268889044e-12, -5.509926370114966e-13,
 -1.500102958107030e-14, -2.992805997437795e-17,  7.779807555810656e-18,  1.932997247611759e-19,  1.921449052425459e+00, -3.094464343709591e-03, -8.680847269503746e-05,
 -2.006282554444424e-06, -3.867626165141626e-08, -5.789592705554801e-10, -4.507826782168144e-12,  9.235221794657442e-14,  5.436536759524531e-15,  1.552143940666078e-16,
  3.042453053038102e-18,  3.445149396330360e-20,  1.522033994428166e-02, -4.209842709008653e-04,  8.674158348186687e-06, -1.578292244194527e-07,  2.659615050315500e-09,
 -4.262502709993381e-11,  6.487229510445223e-13, -9.625474877121675e-15,  1.343358558985915e-16, -1.738817635675606e-18,  2.757611325178495e-20, -1.801759350848948e-22,
  1.363006320267761e-01, -3.625357264247087e-03,  6.825999150815268e-05, -1.046726481306107e-06,  1.289794592846884e-08, -1.103476370355803e-10, -4.784254208644870e-14,
  2.539104573819581e-14, -6.798328175366193e-16,  1.212098322182763e-17, -9.052453872405966e-20,  1.431765163421036e-21,  3.742339275894813e-01, -9.115207533780884e-03,
  1.366606462992693e-04, -1.141752516394595e-06, -5.897098060266684e-09,  3.969164012708825e-10, -7.004837515763876e-12,  3.383509196996943e-14,  1.345654833982438e-15,
 -4.110017666369480e-17,  6.740509036188455e-19,  4.770337010394153e-21,  7.173208221216547e-01, -1.485078832721858e-02,  1.261219088038724e-04,  1.175423035398553e-06,
 -4.677931046875025e-08,  2.563334334666644e-10,  1.227235633755151e-11, -2.821637010196529e-13, -7.694897710124004e-16,  1.295399010867198e-16, -1.380931873130205e-18,
 -2.172141178750518e-20,  1.137800918658406e+00, -1.749417405820080e-02, -2.684386806098131e-05,  3.650495919384518e-06,  5.511476805506312e-09, -1.399458383800202e-09,
 -6.669575712527418e-13,  6.354312496521157e-13, -1.124492950578381e-15, -3.229132664815102e-16,  1.716215246241268e-18,  1.948921960259992e-19,  1.574040426119669e+00,
 -1.341938666278447e-02, -2.065248937040316e-04, -7.411885281554283e-09,  7.453231596789213e-08,  1.244974017511865e-09, -1.608790053079810e-11, -9.726179372835995e-13,
 -8.617095050973359e-15,  4.252713076453229e-16,  1.364655194745265e-17,  7.829663107319676e-21,  1.907513729317174e+00, -3.896665781440817e-03, -1.149945230128579e-04,
 -2.722306656313908e-06, -5.100108925262062e-08, -6.303895126985295e-10,  1.536142755528861e-12,  3.817114817304188e-13,  1.350068746257227e-14,  2.969552913081224e-16,
  3.574564853989055e-18, -3.289573972258957e-20,  1.366413665277274e-02, -3.585031074513086e-04,  7.009907576639652e-06, -1.213330173850985e-07,  1.943268968760463e-09,
 -2.985468358209822e-11,  4.314108867851636e-13, -6.130781913519636e-15,  8.967140260091509e-17, -8.006193829233548e-19,  1.854600423637646e-20, -2.862043411782354e-22,
  1.228165440550115e-01, -3.126179058007899e-03,  5.686500983812790e-05, -8.578749173337247e-07,  1.072602279747546e-08, -1.050415475715977e-10,  4.198490588045161e-13,
  1.003623790730419e-14, -2.947752846772270e-16,  9.557562866179336e-18, -4.994979214682216e-20, -2.185625021978370e-22,  3.398713530915519e-01, -8.077784627258290e-03,
  1.226269275169656e-04, -1.181339745464510e-06,  4.568512226275416e-10,  2.438596875857651e-10, -5.638658853186273e-12,  5.861327846295778e-14,  3.681152156217568e-16,
 -1.363721110824279e-17,  6.094282925699458e-19, -7.603472964157699e-21,  6.600076166193086e-01, -1.379763648524042e-02,  1.359498421558525e-04,  4.812854957006793e-07,
 -3.934480822379973e-08,  4.571782028398145e-10,  4.645500848891954e-12, -2.438628170839884e-13,  2.792642851825185e-15,  6.795388522819064e-17, -1.483913192471561e-18,
  7.458250057746126e-21,  1.067671498734537e+00, -1.753430562331786e-02,  1.658079281033817e-05,  3.519742849985509e-06, -2.126021394681632e-08, -1.215906989793485e-09,
  1.505756217806786e-11,  4.417920088335687e-13, -9.723311000461377e-15, -1.164724206736951e-16,  7.370711307852769e-18,  2.952494499346153e-20,  1.517088803617413e+00,
 -1.504996023467118e-02, -1.987311871001465e-04,  1.353719813966475e-06,  9.327715390705566e-08,  5.186918566125300e-10, -4.416352298849507e-11, -9.053086266164935e-13,
  1.537426373035233e-14,  8.400926953204147e-16,  3.363877063242105e-18, -4.912791227444586e-19,  1.889859453978166e+00, -4.962088083903051e-03, -1.529555386054488e-04,
 -3.632535846002858e-06, -6.207707491870832e-08, -4.057157452388301e-10,  2.004303967754845e-11,  1.006009620755056e-12,  2.585174971183031e-14,  3.443749522107787e-16,
 -3.471624834848035e-18, -3.480770681018458e-19,  1.233375209904936e-02, -3.077612538372164e-04,  5.722437293664979e-06, -9.450773108328189e-08,  1.437388477402440e-09,
 -2.125872691355568e-11,  2.964426534754089e-13, -3.608876432446435e-15,  7.040785463621227e-17, -3.943524665364028e-19, -2.724566463440137e-22, -5.562835600420918e-22,
  1.111603827585026e-01, -2.709675193152867e-03,  4.753287853010977e-05, -7.024374240183897e-07,  8.744503118993571e-09, -9.235637588431340e-11,  6.173660179606563e-13,
  5.641721673024690e-15,  1.480540860986183e-18,  6.317768134792641e-18, -1.375854891637380e-19, -3.625424396381715e-21,  3.094330710273192e-01, -7.153023503347502e-03,
  1.086334106505512e-04, -1.141787752897234e-06,  4.119205159405075e-09,  1.292515254353015e-10, -3.877655235733685e-12,  6.637960539618684e-14,  2.038956210967546e-16,
  6.567458322086218e-19,  3.061068144359323e-20, -1.763062707401905e-20,  6.070146901342703e-01, -1.269691426394354e-02,  1.382636759924992e-04, -7.114004585043210e-08,
 -2.957907019911839e-08,  4.986950665560196e-10, -6.423787885907854e-13, -1.263143223497793e-13,  4.224760584617466e-15,  1.195261298727301e-17, -1.447749054200828e-18,
 -9.463724917334717e-21,  9.980566517495156e-01, -1.724019681255225e-02,  5.604773218526727e-05,  3.008213006965854e-06, -4.115331943395389e-08, -7.430975675203604e-10,
  2.284114251548607e-11,  1.188298654641847e-13, -8.925155806615704e-15,  1.364446182182286e-16,  3.779709201741955e-18, -1.710512662727634e-19,  1.453848487080922e+00,
 -1.654908301598882e-02, -1.733965116792186e-04,  2.864295206858418e-06,  9.140403048638406e-08, -7.621255038842988e-10, -5.817106653372831e-11,  4.771465182516401e-14,
  4.189735525126111e-14,  4.508901074879359e-16, -2.358516582555872e-17, -5.829809554928158e-19,  1.867263370190047e+00, -6.377371120740299e-03, -2.026579737796933e-04,
 -4.653158230092061e-06, -6.257412478428030e-08,  5.163838386209960e-10,  6.124152260570623e-11,  1.964434815960760e-12,  3.043975965177636e-14, -2.836187607414065e-16,
 -3.300910500095702e-17, -1.031802421219833e-18,  1.118759582460652e-02, -2.661571112961620e-04,  4.713471994453088e-06, -7.455430497128588e-08,  1.076431156068926e-09,
 -1.511650586097433e-11,  2.245012776775508e-13, -1.634580520661733e-15,  4.991600300305319e-17, -9.083486917266522e-19, -2.463476299068353e-20, -4.394687168244538e-22,
  1.010320025286836e-01, -2.360885532711832e-03,  3.988490626946102e-05, -5.764412902363876e-07,  7.059093380354732e-09, -7.547475073978535e-11,  8.006606259729861e-13,
  7.925756613208544e-15,  8.759791642084752e-17, -2.711862737070085e-18, -3.110630872194319e-19, -3.162025103419194e-21,  2.824741390175087e-01, -6.337474804034731e-03,
  9.539808689995179e-05, -1.059611433125559e-06,  5.927956851315802e-09,  5.922027212180410e-11, -1.931496376179112e-12,  7.195410803386120e-14,  5.694295734704059e-17,
 -1.399005577859972e-17, -7.363473339554859e-19, -1.378708826990063e-20,  5.584234734724640e-01, -1.160151735975980e-02,  1.348942087996840e-04, -4.663783191806230e-07,
 -1.996671936206035e-08,  4.560848689990384e-10, -2.307775053423568e-12,  3.463369658927188e-15,  3.468248285744944e-15, -5.861406855487285e-17, -2.116759484862738e-18,
 -1.365994742425770e-20,  9.302042084257727e-01, -1.665954694864274e-02,  8.780344118029325e-05,  2.261265063975292e-06, -5.040887387991724e-08, -1.820641282819130e-10,
  2.302484446170308e-11, -7.490154647451955e-14, -3.262381811964087e-15,  1.236429045566621e-16, -4.279060719532707e-18, -1.524792215768377e-19,  1.385128464759425e+00,
 -1.777554452664066e-02, -1.309908233985926e-04,  4.132263966862132e-06,  6.312812048262150e-08, -1.983267795700747e-09, -3.716331438238476e-11,  1.426469627614619e-12,
  3.665142355064753e-14, -8.083018452521234e-16, -3.309957899199930e-17,  2.557769088336986e-19,  1.838135499951330e+00, -8.237602782483157e-03, -2.638481045483296e-04,
 -5.471411150545304e-06, -3.260514610933111e-08,  2.735368579202996e-09,  1.259682227406623e-10,  2.422194991943554e-12, -1.576639082297308e-14, -2.628717767500765e-15,
 -8.345223697012499e-17, -8.425129114470769e-19,  1.019310217578848e-02, -2.317562934536333e-04,  3.913093432929144e-06, -5.947007143131888e-08,  8.250515338843133e-10,
 -1.013494461103561e-11,  1.946602418724227e-13, -7.767388702014456e-16, -3.307931418530252e-18, -2.059513695632389e-18, -2.547344522677977e-20,  5.908217217405451e-22,
  9.218537782168426e-02, -2.067662938485417e-03,  3.359906798624350e-05, -4.744485830268622e-07,  5.760657438130076e-09, -5.346011751726932e-11,  1.028936307415370e-12,
  6.595578499912402e-15, -2.511303184030369e-16, -1.599171636152444e-17, -2.859130159339088e-19,  6.105716407678769e-21,  2.585724572554126e-01, -5.623462013682749e-03,
  8.328462348404282e-05, -9.571269915880250e-07,  6.810267369303653e-09,  3.655505545549269e-11, -1.269977470027481e-14,  5.920092398654818e-14, -1.066737680087367e-15,
 -4.896486370290695e-17, -7.934147728021531e-19,  1.646132864138644e-20,  5.141334899350368e-01, -1.054950612359950e-02,  1.276726987339162e-04, -7.156538594248192e-07,
 -1.133668524406831e-08,  4.118500760276462e-10, -1.094801360801849e-12,  6.375660427257157e-14, -2.153413480611761e-16, -1.437931037226556e-16, -1.723403015287360e-18,
  4.423500088722107e-20,  8.651232505156851e-01, -1.586237584171685e-02,  1.100740927333837e-04,  1.454730777845488e-06, -4.874277476710861e-08,  3.362302949848015e-10,
  1.983855057702302e-11, -1.511458155710869e-13, -3.024545867293897e-15, -1.261394169065823e-16, -6.549170670353628e-18,  7.394669643558425e-20,  1.312264447695556e+00,
 -1.861120535911623e-02, -7.676736609467430e-05,  4.792066872591125e-06,  1.831905400174588e-08, -2.298525438701286e-09,  1.321179682012898e-11,  1.916857439038451e-12,
 -1.109198808608144e-14, -1.645662263263999e-15, -3.711919211474162e-18,  9.379219105340047e-19,  1.800542126796617e+00, -1.061455328531832e-02, -3.302400794556160e-04,
 -5.370492837727870e-06,  5.707532063894418e-08,  6.404082439787501e-09,  1.677352248116149e-10, -2.600313501107320e-13, -1.707391235969406e-13, -5.653246137152573e-15,
 -2.850819255248733e-17,  4.561278426516889e-18,  9.324465308683772e-03, -2.030954921654562e-04,  3.272767953621248e-06, -4.764554335874846e-08,  6.669370813175715e-10,
 -5.809734173172561e-12,  1.593344731666202e-13, -2.182012723880212e-15, -8.446960188607336e-17, -1.989688763425466e-18,  4.446991520082188e-20,  2.671073548016800e-21,
  8.441836927359817e-02, -1.820149350288202e-03,  2.842788671636322e-05, -3.894509460256003e-07,  4.946178339430647e-09, -2.805004286419553e-11,  1.003324786164763e-12,
 -1.203279559321252e-14, -9.213552923344434e-16, -1.680955335802459e-17,  3.885832695758185e-19,  2.536753658021295e-20,  2.373411127737969e-01, -5.001216834419986e-03,
  7.247828168302358e-05, -8.418588903582283e-07,  7.645105695941156e-09,  5.048866276460447e-11,  8.711040078791677e-13, -6.911855853836122e-15, -3.081478007687855e-15,
 -4.994184311830604e-17,  1.188207981866815e-18,  7.606478153269300e-20,  4.739203026482571e-01, -9.564940028484355e-03,  1.182652106829517e-04, -8.320444232615853e-07,
 -3.243483013612897e-09,  4.010895812726871e-10, -2.474898415995694e-13, -3.347225063117169e-14, -5.855736820291891e-15, -1.390314427247645e-16,  2.926531580112535e-18,
  1.739143729520293e-19,  8.035276505328317e-01, -1.492454309399810e-02,  1.231527109120000e-04,  7.528074541132670e-07, -3.767982799704948e-08,  7.448880530823530e-10,
  1.327200080109803e-11, -3.592971258373285e-13, -1.065555907730376e-14, -2.296315571905863e-16,  3.784228082307089e-18,  3.996388536883854e-19,  1.236958218900595e+00,
 -1.899363887889567e-02, -1.891855020272676e-05,  4.751467720330241e-06, -2.056995552831281e-08, -1.431218596773689e-09,  5.328010768078904e-11,  6.676099642760058e-13,
 -6.287482026293291e-14, -9.549905476836260e-16,  3.785829553450926e-17,  9.027476404352252e-19,  1.752428377299853e+00, -1.348764357801300e-02, -3.843102876468650e-04,
 -3.229879322746971e-06,  2.208463726090584e-07,  9.541787834970854e-09,  5.487547508943193e-11, -8.644723389008865e-12, -3.218909538926930e-13, -1.494343504635331e-16,
  3.562478630425313e-16,  1.109808623270954e-17,  8.561072572373126e-03, -1.790265365373505e-04,  2.761814495444605e-06, -3.772328185647394e-08,  5.822389991206108e-10,
 -3.072017943575379e-12,  5.353551145446297e-14, -5.433472994754382e-15, -9.246678507025091e-17,  2.420815456060299e-18,  1.714652323858922e-19,  1.850649462148851e-21,
  7.756487260872486e-02, -1.610109509901624e-03,  2.421456357981463e-05, -3.136719023296215e-07,  4.579672961277463e-09, -1.173799248670768e-11,  1.979058329710989e-13,
 -4.578635848531969e-14, -9.468624157555932e-16,  2.370123412494116e-17,  1.594743739988452e-18,  1.777252878394678e-20,  2.184349614260232e-01, -4.459637417298850e-03,
  6.314620751827387e-05, -7.106060302952427e-07,  8.785392830128222e-09,  5.677385088344898e-11, -8.660913765344182e-13, -1.178409811301752e-13, -3.118884609249664e-15,
  7.309123787917345e-17,  4.851122883171756e-18,  5.508823497143960e-20,  4.374891022017376e-01, -8.659034445306578e-03,  1.082310819614002e-04, -8.208362760014218e-07,
  4.518176359094541e-09,  3.593164553416809e-10, -4.304046511860719e-12, -2.617146479174726e-13, -6.682889961658216e-15,  1.510165692560891e-16,  1.134648430496708e-17,
  1.293111945042420e-19,  7.458442758452408e-01, -1.391221097756243e-02,  1.291056301130673e-04,  2.822249940394353e-07, -2.063643402406060e-08,  8.984984159620715e-10,
 -2.377015854548017e-12, -7.650481345823488e-13, -1.142594373654715e-14,  3.212803660675460e-16,  2.337382315760805e-17,  3.176985067541761e-19,  1.161031897174585e+00,
 -1.892422203778084e-02,  3.541166429360226e-05,  4.264806683359810e-06, -3.615865319107789e-08, -1.749770550739645e-10,  4.115680761267332e-11, -1.527556236228030e-12,
 -6.095548385589347e-14,  1.281622821132713e-15,  6.996033520878583e-17,  2.798219504936562e-19,  1.692187284259224e+00, -1.664261186622563e-02, -3.956113561291557e-04,
  1.799739952745012e-06,  3.996360402139090e-07,  6.904431094357660e-09, -3.078541742131238e-10, -1.550614120476682e-11,  1.565513390511715e-14,  1.977785540653999e-14,
  4.558734038539755e-16, -1.393382236619533e-17,  7.886506147201827e-03, -1.585888611908924e-04,  2.363076062888353e-06, -2.888540081474031e-08,  5.201159791179662e-10,
 -3.817762097001340e-12, -1.172161415854077e-13, -5.651874327191498e-15,  1.159942267843609e-16,  8.366137995926591e-18,  4.591077680310035e-20, -8.739013546288528e-21,
  7.148976282585756e-02, -1.430222112025116e-03,  2.088193002283017e-05, -2.425000553964858e-07,  4.275878743714149e-09, -2.455225531887876e-11, -1.289504570502016e-12,
 -4.987692374276363e-14,  1.038728730471140e-15,  7.925386756133816e-17,  4.302400435336361e-19, -8.202052705435212e-20,  2.015562155445206e-01, -3.986114504700030e-03,
  5.549268698702420e-05, -5.633652821917552e-07,  9.402837468764182e-09, -1.106473631351641e-11, -4.891318803320034e-12, -1.372389947217740e-13,  2.970102878476456e-15,
  2.431148299944732e-16,  1.347805534217632e-18, -2.503070920032281e-19,  4.045246704826145e-01, -7.830861103697835e-03,  9.902611065915198e-05, -6.994973094211733e-07,
  9.986245763634523e-09,  1.521945514076722e-10, -1.316182176484098e-11, -2.987343425318912e-13,  6.877229056576507e-15,  5.523101100429387e-16,  3.378334435774695e-18,
 -5.795830984185089e-19,  6.922763750584229e-01, -1.287012516616218e-02,  1.310729438546133e-04,  8.487900734349583e-08, -5.115534060203263e-09,  5.605586747054774e-10,
 -2.582507452675966e-11, -7.571608357207285e-13,  1.724509424366923e-14,  1.171463773100314e-15,  7.281734389453886e-18, -1.257442028054654e-18,  1.086211820300363e+00,
 -1.844605626578989e-02,  8.312876822987104e-05,  3.694167617110012e-06, -3.413334591591050e-08,  1.408428725048889e-10, -1.821734553523680e-11, -2.222326361041854e-12,
  3.107277992064438e-14,  3.449442744269495e-15,  9.923257138396071e-18, -3.509775935412712e-18,  1.619586995496240e+00, -1.960522416306655e-02, -3.327734958598647e-04,
  8.759915468446518e-06,  4.320777419480734e-07, -4.897447066670599e-09, -6.135017611799829e-10, -2.027027926263768e-12,  7.999176952770016e-13,  1.457269220941261e-14,
 -8.812306954655324e-16, -3.371443414892804e-17,  7.287955176924483e-03, -1.409363006098314e-04,  2.063246404301992e-06, -2.136997654686650e-08,  4.061362780948457e-10,
 -7.841184226061024e-12, -1.808167808242283e-13,  2.335630447548251e-15,  3.376554430841015e-16,  7.311353099714135e-19, -4.158629722278170e-19, -6.620816876289777e-21,
  6.608613181542712e-02, -1.273693845947537e-03,  1.835970069211046e-05, -1.800697768635941e-07,  3.392615209346116e-09, -6.595103925793654e-11, -1.816237586777403e-12,
  2.388994415792514e-14,  3.142202852034934e-15,  7.273843640713112e-18, -3.922668499148321e-18, -6.260733879416016e-20,  1.864603545146335e-01, -3.566720572040258e-03,
  4.960413190195306e-05, -4.220794330077909e-07,  7.785562779442256e-09, -1.559915790494966e-10, -6.160869208574585e-12,  8.237377248456621e-14,  9.444608775110254e-15,
  2.329208122698801e-17, -1.203632816020390e-17, -1.935454030093818e-19,  3.747364671944582e-01, -7.069403488978036e-03,  9.162949253951819e-05, -5.346926185061851e-07,
  9.399041125395899e-09, -2.213370761089257e-10, -1.561320668004766e-11,  2.053262233335917e-13,  2.162447631559094e-14,  4.871930045971248e-17, -2.792041291008719e-17,
 -4.546478835388455e-19,  6.428983394946477e-01, -1.181825509143782e-02,  1.318453724090984e-04,  5.345188157610088e-08, -1.334737297618428e-09, -2.134754374251460e-10,
 -3.330950050944276e-11,  3.937102138713740e-13,  4.805615898773822e-14,  5.917159880702983e-17, -6.158047604504041e-17, -9.882233621912694e-19,  1.014025280444007e+00,
 -1.761302242104053e-02,  1.241481787022322e-04,  3.129107801526525e-06, -3.967873505084926e-08, -8.218218509859737e-10, -4.933876248260697e-11,  4.800005968483011e-13,
  1.179837451650934e-13,  1.377988046189931e-16, -1.671753421343871e-16, -2.137772723475801e-18,  1.536657182488415e+00, -2.174192425885851e-02, -1.919184060387403e-04,
  1.412566145074582e-05,  1.982275362825524e-07, -1.722355459455541e-08, -2.937043456599142e-10,  2.324323493596251e-11,  4.906965808833078e-13, -3.169597272998538e-14,
 -8.408394599890693e-16,  4.248830151581325e-17,  6.755736349487869e-03, -1.253588726072891e-04,  1.839968738104134e-06, -1.631884382470955e-08,  2.171867217945544e-10,
 -1.027161811551438e-11,  1.577252081225904e-14,  1.022580815491045e-14,  6.300843618758079e-17, -1.407150300172735e-17, -1.316772589198263e-19,  1.814899612668338e-20,
  6.127257989282543e-02, -1.134650495258981e-03,  1.647445266890156e-05, -1.382847154384387e-07,  1.747473670059677e-09, -9.104998310415473e-11,  7.301248643493465e-14,
  9.716061810392412e-14,  5.651904108586480e-16, -1.322900056006338e-16, -1.232942917937487e-18,  1.717172886944966e-19,  1.729576792355457e-01, -3.188312640612001e-03,
  4.516118896385087e-05, -3.291286596867176e-07,  3.540982891139018e-09, -2.447489349042044e-10, -1.931255251801753e-13,  3.014353224850623e-13,  1.573409481612534e-15,
 -4.043376417284987e-16, -3.703220292819936e-18,  5.312536002044232e-19,  3.478873059622865e-01, -6.359929716560811e-03,  8.591206845099625e-05, -4.367789726398272e-07,
  2.072214789272677e-09, -4.553717989019519e-10, -1.527108764974278e-12,  7.014188291800607e-13,  3.203773538783811e-15, -9.382908476166415e-16, -8.111589182671765e-18,
  1.253799392644326e-18,  5.977376488879943e-01, -1.076186529519928e-02,  1.320945356070658e-04, -3.877123516405627e-08, -1.186421811311826e-08, -7.227220240413831e-10,
 -3.979584267104129e-12,  1.474974481199326e-12,  6.156782378277261e-15, -2.071827552901892e-15, -1.505380654422255e-17,  2.837626043009375e-18,  9.457800270473075e-01,
 -1.648204696700073e-02,  1.571676542237002e-04,  2.310256649280502e-06, -6.481603867887762e-08, -1.460636904951649e-09,  8.381129210471360e-12,  3.054158968091028e-12,
  9.661579817443872e-15, -5.150064661241882e-15, -2.012157879964003e-17,  7.658654752124678e-18,  1.447732243656388e+00, -2.257281336797645e-02, -1.533984297620290e-05,
  1.439678326784060e-05, -1.598293919569745e-07, -1.586943892079916e-08,  3.839974796982845e-10,  1.853597610521732e-11, -7.172641828286622e-13, -2.095901222915889e-14,
  1.215073872050429e-15,  2.180291048475326e-17,  6.282563694959258e-03, -1.113783527431440e-04,  1.658542551069416e-06, -1.437133380223529e-08,  3.791932144256136e-11,
 -6.693964809564465e-12,  2.561926027166172e-13,  4.705430568581860e-15, -3.473704826593472e-16, -4.342704365359448e-18,  4.964090277311212e-19,  2.514919592951618e-21,
  5.698755440688209e-02, -1.009150461108830e-03,  1.492550076298319e-05, -1.238928912554857e-07,  1.562222784333117e-10, -5.897229409965552e-11,  2.350552132495680e-12,
  4.451027047977025e-14, -3.280432381649951e-15, -4.003388500282935e-17,  4.684889118095230e-18,  2.265357004096165e-20,  1.609028782785556e-01, -2.842217752805173e-03,
  4.139693803700255e-05, -3.090856122983971e-07, -7.443294825021987e-10, -1.557216936739100e-10,  6.830412719811269e-12,  1.365152903712071e-13, -1.008685189261961e-14,
 -1.168575949082076e-16,  1.441757770399370e-17,  6.172620466906571e-20,  3.237888916552584e-01, -5.693707418016399e-03,  8.058052904517539e-05, -4.719883947448919e-07,
 -5.882811109174144e-09, -2.754796758670291e-10,  1.465860629693811e-11,  3.092399694611867e-13, -2.339771221359632e-14, -2.471386220268537e-16,  3.370823659631262e-17,
  1.059676495076269e-19,  5.567947903625448e-01, -9.711261066956588e-03,  1.300339246315074e-04, -3.358560069587848e-07, -2.410128125164672e-08, -3.673420370100379e-10,
  2.945443225132155e-11,  6.036220808700735e-13, -5.042940448558040e-14, -4.437284029177901e-16,  7.465826138873725e-17,  5.318851886511611e-20,  8.825145444719092e-01,
 -1.513345307352178e-02,  1.778160771418483e-04,  1.078009973281785e-06, -8.560566592735949e-08, -3.593849597773692e-10,  7.290099528280460e-11,  8.579207565281695e-13,
 -1.175752004462123e-13, -4.822393749706659e-16,  1.850734454264124e-16, -1.037047637473749e-18,  1.358201448079253e+00, -2.206816228934640e-02,  1.335834300302692e-04,
  9.925464798928455e-06, -3.580996558436339e-07, -3.364744768371855e-09,  5.379640246211014e-10, -6.844514486982364e-12, -6.058386780320749e-13,  2.151446043482171e-14,
  4.436892727109766e-16, -3.891045051547489e-17,  5.862498782981755e-03, -9.879739840413149e-05,  1.486457576170297e-06, -1.447991527638051e-08, -3.041910224189293e-11,
 -2.323131058452854e-13,  2.348172564695059e-13, -5.376890213072445e-15, -1.951751421430703e-16,  9.911939528378660e-18,  9.032713802669508e-20, -1.416204644759294e-20,
  5.318031311766123e-02, -8.957193292285231e-04,  1.342542248094758e-05, -1.275580588034944e-07, -4.205056973906062e-10,  4.511868170912085e-13,  2.155320851164703e-12,
 -5.025985885151229e-14, -1.821619726614352e-15,  9.358338603478888e-17,  8.164713855811094e-19, -1.335280822873682e-19,  1.501723474044582e-01, -2.526255913353149e-03,
  3.754447045156663e-05, -3.363716848506871e-07, -2.100771958848485e-09,  1.754064070381214e-11,  6.250669724738473e-12, -1.519099452082738e-13, -5.452881249427304e-15,
  2.879040940735934e-16,  2.264064545624308e-18, -4.096667440901233e-19,  3.022648350589021e-01, -5.073604953190576e-03,  7.423634928589022e-05, -5.896701747608109e-07,
 -7.612486552490298e-09,  9.626386268041696e-11,  1.323013169810553e-11, -3.473763063644454e-13, -1.200695326085463e-14,  6.703101252860056e-16,  4.219722614689740e-18,
 -9.495216380196416e-19,  5.199951059775140e-01, -8.693959983028937e-03,  1.235796825247032e-04, -7.393727152306340e-07, -2.394403553376431e-08,  3.645151595340732e-10,
  2.511279210715396e-11, -7.609349498392737e-13, -2.316962653634867e-14,  1.462335403176371e-15,  4.902912525850285e-18, -2.052001320808169e-18,  8.248749166762362e-01,
 -1.368238316907906e-02,  1.826091831174622e-04, -2.533462337232459e-07, -7.544810089423899e-08,  1.282691699974507e-09,  5.040404891793207e-11, -2.019840420945175e-12,
 -3.803430095227432e-14,  3.499097351998057e-15, -1.248952306058567e-17, -4.694579629953259e-18,  1.272681411632699e+00, -2.062148218566590e-02,  2.181114020365871e-04,
  4.264191826491283e-06, -3.198951840933766e-07,  5.817451787106269e-09,  1.981604414979845e-10, -1.336620640829224e-11,  1.420323896229793e-13,  1.324133186085472e-14,
 -5.618658899701587e-16, -1.596604896528927e-18,  5.489982042584477e-03, -8.760770235637796e-05,  1.310455763385391e-06, -1.475722604679997e-08,  6.850420385514107e-12,
  3.218609802106487e-12,  4.927399864710699e-14, -6.244675956534975e-15,  1.071221352130750e-16,  4.668310600812021e-18, -2.398233692574651e-19,  3.037675218045930e-22,
  4.980240727351579e-02, -7.945368852754135e-04,  1.186225399861070e-05, -1.319603806223833e-07, -2.903426341413070e-11,  3.178961162394608e-11,  4.254225559359062e-13,
 -5.800564030017688e-14,  1.013519812732013e-15,  4.330603817480039e-17, -2.260360198973346e-18,  3.867737337101333e-21,  1.406417562231594e-01, -2.242545976261772e-03,
  3.333977842009456e-05, -3.607050779695761e-07, -6.558434783514903e-10,  1.062272276452635e-10,  1.060634315322709e-12, -1.724610320240783e-13,  3.139498696486050e-15,
  1.279690047462643e-16, -6.927100601597195e-18,  1.870675998497654e-20,  2.831107701711367e-01, -4.509849120570034e-03,  6.653862920216391e-05, -6.826211962007267e-07,
 -3.431137629295734e-09,  2.753473428934128e-10,  1.581560782723341e-12, -3.798147758391413e-13,  7.447555735672324e-15,  2.756709693775392e-16, -1.601168406250711e-17,
  7.218959479529333e-20,  4.871321039640311e-01, -7.746598338517931e-03,  1.127331452524637e-04, -1.039553384785978e-06, -1.258632282928843e-08,  6.740441745011996e-10,
  7.653181769766546e-13, -7.617833464156065e-13,  1.704858432626231e-14,  5.123257276322904e-16, -3.441133651516106e-17,  2.704696170416389e-19,  7.730218903320765e-01,
 -1.225191611647421e-02,  1.733300560116872e-04, -1.209870623679777e-06, -4.253403010683909e-08,  1.781176068387091e-09, -6.733380077129043e-12, -1.609499854760275e-12,
  4.639542619258026e-14,  7.684947294536468e-16, -7.873508661633978e-17,  1.205695320740858e-18,  1.193899569100202e+00, -1.874897908923386e-02,  2.429321850278002e-04,
  2.212151237531826e-07, -1.823252610273861e-07,  6.887690098746223e-09, -6.996618548615780e-11, -5.169522509605706e-12,  2.687893384211556e-13, -3.523845156109225e-15,
 -1.911276381171302e-16,  1.074198757581425e-17,  5.159406262369245e-03, -7.782549190016244e-05,  1.136216527914358e-06, -1.411950117362187e-08,  7.131758514657372e-11,
  2.783524558111151e-12, -6.447497150326749e-14, -1.778230770920340e-15,  1.307530691881481e-16, -2.172375178242722e-18, -7.301020031503040e-20,  4.518715606977347e-21,
  4.680408093475220e-02, -7.059313521951763e-04,  1.029739857721187e-05, -1.272575084844623e-07,  6.002062585951641e-10,  2.703184715914233e-11, -6.244529980369913e-13,
 -1.611790356163264e-14,  1.218771306287429e-15, -2.064056752904417e-17, -6.710560258786642e-19,  4.239247698399112e-20,  1.321775587477010e-01, -1.993156718208082e-03,
  2.901903510022791e-05, -3.542200150523888e-07,  1.402297485872436e-09,  8.756884624171005e-11, -2.016287388415014e-12, -4.530586095146476e-14,  3.648445280684843e-15,
 -6.442618878883422e-17, -1.941284630496176e-18,  1.285614969582719e-19,  2.660833444475763e-01, -4.010822948450883e-03,  5.819765567574886e-05, -6.944560731166340e-07,
  1.757086577269908e-09,  2.177332043116356e-10, -5.015585403390768e-12, -8.950686204115210e-14,  8.111991177234029e-15, -1.541390038439163e-16, -4.010880164751908e-18,
  2.913545090715237e-19,  4.578669227193820e-01, -6.897055195755639e-03,  9.948147584693817e-05, -1.138100170981211e-06, -2.900791852061697e-10,  5.066292033708970e-10,
 -1.180850213658161e-11, -1.432817406452204e-13,  1.642181138480803e-14, -3.535428577599444e-16, -6.799446296016163e-18,  6.024968835712073e-19,  7.266826436321592e-01,
 -1.093233163275265e-02,  1.558412067452742e-04, -1.626372257900186e-06, -1.127018168619619e-08,  1.253623609466566e-09, -3.041756009916605e-11, -1.542257014590530e-13,
  3.447851472410964e-14, -9.336305318885329e-16, -7.035724023139630e-18,  1.255934243757759e-18,  1.122750202595388e+00, -1.683479888098741e-02,  2.322374938278577e-04,
 -1.718778156191922e-06, -6.868861933579809e-08,  4.293581024348865e-09, -1.192923701966488e-10,  6.938401242051631e-13,  9.391003419517573e-14, -4.434128073227761e-15,
  7.596969413541188e-17,  1.617970371133903e-18,  4.865242887580241e-03, -6.939046575378320e-05,  9.751657197692019e-07, -1.262660816569503e-08,  1.095722569643302e-10,
  1.027513747171413e-12, -6.951985478285537e-14,  9.159555388431598e-16,  3.798720976227212e-17, -2.228504411708436e-18,  4.108677120793656e-20,  6.974635880885799e-22,
  4.413571973368631e-02, -6.294619439462351e-04,  8.842881584267785e-06, -1.142275206410184e-07,  9.738667755717200e-10,  1.024399709516382e-11, -6.602120875757975e-13,
  8.850825912693122e-15,  3.474669714704488e-16, -2.077382356897434e-17,  3.894567331061535e-19,  6.280597101610387e-21,  1.246430065800591e-01, -1.777510833974809e-03,
  2.495162018780076e-05, -3.206262001465926e-07,  2.624930385936615e-09,  3.470821264757067e-11, -2.051154418432007e-12,  2.848219352021411e-14,  9.966348893482596e-16,
 -6.216948606960371e-17,  1.208505172231256e-18,  1.729064285881746e-20,  2.509194911164843e-01, -3.577811541000083e-03,  5.015416641623791e-05, -6.384422425219428e-07,
  4.832569374838225e-09,  9.091906098149013e-11, -4.820210042344879e-12,  7.070840250004082e-14,  2.043757655860938e-15, -1.379590263857916e-16,  2.855677453002276e-18,
  3.204368549968240e-20,  4.317846840687549e-01, -6.155244052167980e-03,  8.607941810811479e-05, -1.077534943565834e-06,  6.937206003075114e-09,  2.219100429610914e-10,
 -1.050427402251657e-11,  1.670112322324285e-13,  3.524230894131294e-15, -2.772078897829155e-16,  6.378347405556707e-18,  3.968873079336463e-20,  6.853210323401918e-01,
 -9.765085096630349e-03,  1.359422252296532e-04, -1.645404201868739e-06,  6.664840082072855e-09,  5.656045659035836e-10, -2.424399293698151e-11,  4.367276609057836e-13,
  4.862319751369027e-15, -5.661568496590277e-16,  1.580207965874641e-17, -3.621834408053284e-20,  1.058977197271662e+00, -1.507251627019030e-02,  2.073769990305782e-04,
 -2.275333492012469e-06, -8.662250197581256e-09,  1.878411872050841e-09, -7.726592289523145e-11,  1.779469017678240e-12, -7.066271097870489e-15, -1.312442829815731e-15,
  6.003500790094846e-17, -1.249579920026366e-18,  4.602367508118179e-03, -6.216439029555476e-05,  8.345778057751949e-07, -1.078934429648911e-08,  1.159541866975798e-10,
 -2.579520266506035e-13, -3.651738581565697e-14,  1.183517571612692e-15, -1.130887170325961e-17, -5.885880534810386e-19,  3.134160534303386e-20, -6.552475384284060e-22,
  4.175106480700269e-02, -5.639264601636606e-04,  7.569882417609378e-06, -9.776840408557740e-08,  1.044342955901307e-09, -1.948440213530161e-12, -3.465446538333903e-13,
  1.116475317394595e-14, -1.094956631479721e-16, -5.390248033648774e-18,  2.917025505320581e-19, -6.181079536979707e-21,  1.179088790738261e-01, -1.592537041975335e-03,
  2.137118849468301e-05, -2.754357873545296e-07,  2.902532175877242e-09, -3.065561432734639e-12, -1.074295459814502e-12,  3.423814920026093e-14, -3.539487358890663e-16,
 -1.549773284958333e-17,  8.697361924325861e-19, -1.897495177601161e-20,  2.373641809787527e-01, -3.205807916185808e-03,  4.299847929603880e-05, -5.521043566533749e-07,
  5.676133601873238e-09,  2.601139692006351e-12, -2.510874658103701e-12,  7.896616107352367e-14, -8.857844292503878e-16, -3.189351271017006e-17,  1.915743012892001e-18,
 -4.396958407051698e-20,  4.084620927018935e-01, -5.516186685875624e-03,  7.392173463525447e-05, -9.430131665895714e-07,  9.266302598240685e-09,  3.119810622947874e-11,
 -5.402559996815782e-12,  1.680575647151950e-13, -2.120065381473789e-15, -5.526380600165761e-17,  3.790875428540054e-18, -9.480722322772931e-20,  6.483141767399915e-01,
 -8.754038321308692e-03,  1.171197703817718e-04, -1.475610304385272e-06,  1.317498113721600e-08,  1.333632286432798e-10, -1.209081602467801e-11,  3.771006633414566e-13,
 -5.658586126704355e-15, -7.705180559698228e-17,  7.457664523067565e-18, -2.187441808537720e-19,  1.001831950847215e+00, -1.352279109248720e-02,  1.801990512920935e-04,
 -2.198074735835671e-06,  1.413260168243199e-08,  5.666862447448986e-10, -3.501067178804047e-11,  1.157453946052136e-12, -2.358091865554399e-14,  9.189957662056397e-17,
  1.475282709713901e-17, -6.737063090679505e-19,  4.366286885316496e-03, -5.597476599077323e-05,  7.159413963601534e-07, -9.012613704669756e-09,  1.044478242067762e-10,
 -7.899043869780533e-13, -1.022561305013580e-14,  6.698652869040716e-16, -1.655328024687599e-17,  1.349351608470238e-19,  7.120581417804632e-21, -3.674637684427409e-22,
  3.960944071314330e-02, -5.077816275724851e-04,  6.494438375167635e-06, -8.172500531879216e-08,  9.449693521470390e-10, -7.021816688542423e-12, -9.910955049503689e-14,
  6.294196848122812e-15, -1.556737751220783e-16,  1.307099257421994e-18,  6.509584038890670e-20, -3.412032609632387e-21,  1.118608356084322e-01, -1.434011216021743e-03,
  1.833886596334807e-05, -2.305882830001036e-07,  2.652986606292247e-09, -1.893941074740876e-11, -3.193596503711204e-13,  1.913599683291408e-14, -4.744659276742232e-16,
  4.230344499031839e-18,  1.863828381890704e-19, -1.011939871422274e-20,  2.251891273366850e-01, -2.886791036082342e-03,  3.691114146190224e-05, -4.634592023090022e-07,
  5.285219461468075e-09, -3.495265240725786e-11, -7.847622296593223e-13,  4.347199129321354e-14, -1.084292293935877e-15,  1.061173060677292e-17,  3.803184981916282e-19,
 -2.206975433828394e-20,  3.875119967912046e-01, -4.967548027510196e-03,  6.349691796308852e-05, -7.953583814681823e-07,  8.930575623655572e-09, -5.064498684958289e-11,
 -1.781346625866874e-12,  9.014797965328867e-14, -2.279252098336769e-15,  2.549387946731033e-17,  6.467746110363790e-19, -4.285970248162253e-20,  6.150650106971500e-01,
 -7.884209312758000e-03,  1.007230786387032e-04, -1.256033082140672e-06,  1.368520298676421e-08, -5.150187237802841e-11, -4.171592411491271e-12,  1.926678154900384e-13,
 -5.029897754923140e-15,  6.829902903944111e-17,  8.503639713114349e-19, -8.090218603606879e-20,  9.504631660995723e-01, -1.218224874271413e-02,  1.554315741534703e-04,
 -1.917383054073349e-06,  1.927203994431673e-08,  3.598869147684097e-11, -1.213217099779832e-11,  5.238533279251730e-13, -1.498485143252026e-14,  2.813619684454757e-16,
 -1.365726898772119e-18, -1.368054617272908e-19,  4.153196374605305e-03, -5.065269022491470e-05,  6.172674794508074e-07, -7.475795782259639e-09,  8.742954339622903e-11,
 -8.643054934761945e-13,  2.086698584479045e-15,  2.478488411669254e-16, -9.476912230565456e-18,  2.016886113452857e-19, -1.604867896206980e-21, -6.953042074483807e-23,
  3.767636217177097e-02, -4.595031432869942e-04,  5.599543152511528e-06, -6.780774852702798e-08,  7.923426716956920e-10, -7.793168239460056e-12,  1.665062293625384e-14,
  2.336386044781041e-15, -8.868086102402219e-17,  1.893095503211726e-18, -1.549152833670322e-20, -6.333402963034116e-22,  1.064016662365580e-01, -1.297677620582479e-03,
  1.581307242706594e-05, -1.914337801667444e-07,  2.232811064993480e-09, -2.171588777016018e-11,  3.292806013538013e-14,  7.144815384371614e-15, -2.673848891100668e-16,
  5.747139512856922e-18, -4.979802843292610e-20, -1.798144534467664e-21,  2.141992718458399e-01, -2.612368356799219e-03,  3.183160083715094e-05, -3.851628996528507e-07,
  4.477906733732220e-09, -4.268226848316663e-11,  1.615121953988036e-14,  1.634459352368829e-14, -5.997884034670786e-16,  1.305341763998329e-17, -1.237018091960586e-19,
 -3.608024744456915e-21,  3.686006214963434e-01, -4.495409141573152e-03,  5.477101659285375e-05, -6.621733162778535e-07,  7.656016195199738e-09, -7.039778523468142e-11,
 -1.217926247842908e-13,  3.406360467995685e-14, -1.222128085226455e-15,  2.719507674081082e-17, -2.933340471156369e-19, -5.914503453845703e-21,  5.850494012234190e-01,
 -7.135097638718108e-03,  8.691713903188917e-05, -1.049212651562170e-06,  1.200699685479639e-08, -1.027031129120644e-10, -6.451159175308173e-13,  7.246199891640946e-14,
 -2.549347057143287e-15,  5.919599684842752e-17, -7.709213935430543e-19, -6.846730445089067e-21,  9.040827242586584e-01, -1.102561542183075e-02,  1.342571300730010e-04,
 -1.614965930774236e-06,  1.802580503462674e-08, -1.245798855240051e-10, -2.776377698732935e-12,  1.883896823150303e-13, -6.660925500606688e-15,  1.711991211423989e-16,
 -3.040190206814593e-18,  1.896075119079168e-20,  3.959925607677378e-03, -4.605089432374115e-05,  5.353946787964668e-07, -6.210667201632524e-09,  7.105577712718337e-11,
 -7.590506783597423e-13,  5.761759773709188e-15,  4.484119217153231e-17, -3.750445996706451e-18,  1.132467012536881e-19, -2.193998594906892e-21,  1.849256952462306e-23,
  3.592307782980889e-02, -4.177576676936665e-04,  4.856890454244765e-06, -5.633823034088448e-08,  6.443657112453840e-10, -6.871411755062742e-12,  5.153215324822247e-14,
  4.376084269688043e-16, -3.508656389324733e-17,  1.057286101974101e-18, -2.056174961612710e-20,  1.774182272659540e-22,  1.014502305150573e-01, -1.179786992110557e-03,
  1.371617253498931e-05, -1.590874915723574e-07,  1.818356252044666e-09, -1.931693274702991e-11,  1.409976357406314e-13,  1.426277352828464e-15, -1.056896662593980e-16,
  3.172916956806305e-18, -6.222280679940495e-20,  5.634547354080879e-22,  2.042314665795417e-01, -2.375049486658470e-03,  2.761176561519051e-05, -3.202027295143840e-07,
  3.655699985595682e-09, -3.857654440959626e-11,  2.678546852550127e-13,  3.547301743828360e-15, -2.364011534130967e-16,  7.064919082649972e-18, -1.405928979880187e-19,
  1.374582738515023e-21,  3.514477951795907e-01, -4.087049603360101e-03,  4.751365558365319e-05, -5.508440157337911e-07,  6.276766091463665e-09, -6.547838829807389e-11,
  4.139192492411237e-13,  8.114189068070960e-15, -4.780807291089074e-16,  1.424078393302434e-17, -2.905579107818557e-19,  3.179814532946170e-21,  5.578243461857786e-01,
 -6.487015572425117e-03,  7.541028623395295e-05, -8.738273674122945e-07,  9.922369608769428e-09, -1.013061717686836e-10,  5.186285269660879e-13,  1.890910785542882e-14,
 -9.779881536233193e-16,  2.922811753460740e-17, -6.240052159013671e-19,  8.069504846057462e-21,  8.620122908939072e-01, -1.002437923648342e-02,  1.165180665734305e-04,
 -1.348680997575526e-06,  1.519194014518820e-08, -1.470921457747136e-10,  2.860900574783629e-13,  5.259033297156640e-14, -2.404658183206313e-15,  7.406966904223483e-17,
 -1.749654677193178e-18,  2.985764007150741e-20,  3.783842161887130e-03, -4.204762541225517e-05,  4.672120642182191e-07, -5.187483991465565e-09,  5.730312185415927e-11,
 -6.160567299885992e-13,  5.839939357930399e-15, -2.500850939346409e-17, -1.018565734058130e-18,  4.534922840690555e-20, -1.186204138457933e-21,  2.156647481326521e-23,
  3.432570993270097e-02, -3.814415067919746e-04,  4.238380103574418e-06, -4.705832542564164e-08,  5.197719395782096e-10, -5.584552162758397e-12,  5.275837681582765e-14,
 -2.171218867948785e-16, -9.603256194779176e-18,  4.227743297080427e-19, -1.105751142649509e-20,  2.018344811011673e-22,  9.693911175409960e-02, -1.077227342036145e-03,
  1.196955441262322e-05, -1.328927438764518e-07,  1.467506326976848e-09, -1.574622084634169e-11,  1.476484826810727e-13, -5.532335524186723e-16, -2.936170521326862e-17,
  1.264501548692769e-18, -3.307746322345062e-20,  6.089755374018805e-22,  1.951500509563042e-01, -2.168586994882885e-03,  2.409601205539205e-05, -2.675134495662044e-07,
  2.952947810847204e-09, -3.161156785514865e-11,  2.925204098482972e-13, -9.027434465461310e-16, -6.704820421896166e-17,  2.797555487461313e-18, -7.327062918192129e-20,
  1.369206630307129e-21,  3.358202349264506e-01, -3.731769335482510e-03,  4.146477755037713e-05, -4.603010691192262e-07,  5.077748586465816e-09, -5.414605595844955e-11,
  4.896881924746492e-13, -9.352433580750208e-16, -1.388957112295990e-16,  5.570729034506370e-18, -1.465292357709092e-19,  2.807352776743750e-21,  5.330200511302899e-01,
 -5.923127029437572e-03,  6.581259664432986e-05, -7.304748615447809e-07,  8.048880383046429e-09, -8.522476081178922e-11,  7.378091235363085e-13,  3.237074205025401e-16,
 -2.905276760027438e-16,  1.115000533350459e-17, -2.969537746274749e-19,  5.946755218112509e-21,  8.236821076303673e-01, -9.153058393658127e-03,  1.016975000763889e-04,
 -1.128400124743673e-06,  1.240198525930537e-08, -1.292104008348529e-10,  9.996822387098166e-13,  7.141789354567831e-15, -7.161653635887488e-16,  2.645976455543037e-17,
 -7.331723071284700e-19,  1.615239352604361e-20,  3.622753634933912e-03, -3.854423000411719e-05,  4.100806527678412e-07, -4.361875735968073e-09,  4.631316574667499e-11,
 -4.867604690018884e-13,  4.873381032903203e-15, -3.896586556233977e-17, -3.939460776264769e-20,  1.378052172381419e-20, -4.699177695514469e-22,  1.110554746681638e-23,
  3.286437050358142e-02, -3.496599414230999e-04,  3.720108538561080e-06, -3.956924422751275e-08,  4.201208644440177e-10, -4.414619833913775e-12,  4.414828963080435e-14,
 -3.506344904840456e-16, -4.697196717990745e-19,  1.287970459392521e-19, -4.371946613892512e-21,  1.034008476519106e-22,  9.281214891151755e-02, -9.874733123801207e-04,
  1.050593527895732e-05, -1.117462226186044e-07,  1.186363238586969e-09, -1.246058345994182e-11,  1.243041131833095e-13, -9.727630355808891e-16, -2.016708854416083e-18,
  3.870650076297109e-19, -1.302159591023073e-20,  3.085437822278879e-22,  1.868419817827489e-01, -1.987901970354657e-03,  2.114967388063616e-05, -2.249546300376649e-07,
  2.387950901962245e-09, -2.506132462288912e-11,  2.489344914300797e-13, -1.897257072452873e-15, -6.484438225697659e-18,  8.616741829318532e-19, -2.861805221096194e-20,
  6.806520750509087e-22,  3.215234576275930e-01, -3.420842645898952e-03,  3.639491901299710e-05, -3.870978266909320e-07,  4.108292667778775e-09, -4.305969044756233e-11,
  4.246245394261143e-13, -3.088156476255285e-15, -1.823883777259598e-17,  1.726123988037602e-18, -5.643374091102807e-20,  1.352380875620110e-21,  5.103279562669638e-01,
 -5.429623092257718e-03,  5.776643082552374e-05, -6.143784152222216e-07,  6.518076885330387e-09, -6.815871076329946e-11,  6.633642783424586e-13, -4.395438118546860e-15,
 -4.952853966484254e-17,  3.459652325379172e-18, -1.113164604953114e-19,  2.711025466272861e-21,  7.886157899667137e-01, -8.390456007455320e-03,  8.926632763210970e-05,
 -9.493075083196859e-07,  1.006361232553167e-08, -1.046997130805791e-10,  9.886811322774296e-13, -5.011178749682266e-15, -1.510951522861524e-16,  8.048240403019110e-18,
 -2.573335705269663e-19,  6.537838796250918e-21,  3.474823361364136e-03, -3.546105805997064e-05,  3.618825219134805e-07, -3.692760622140884e-09,  3.765999793998820e-11,
 -3.826847336847723e-13,  3.818204126478962e-15, -3.510869543864404e-17,  2.140577167498617e-19,  2.403192311749710e-21, -1.483559914863963e-22,  4.304336381281369e-24,
  3.152239814244082e-02, -3.216904766980073e-04,  3.282872948660922e-06, -3.349940420674594e-08,  3.416344595061890e-10, -3.471300652244094e-12,  3.462118080599759e-14,
 -3.177107653603082e-16,  1.909617348284008e-18,  2.294644675992588e-20, -1.381146558360567e-21,  3.999065951556251e-23,  8.902228977645622e-02, -9.084848910473047e-04,
  9.271147232145449e-06, -9.460526920502637e-08,  9.647840780503823e-10, -9.801564956286123e-12,  9.767452537821659e-14, -8.924632593706932e-16,  5.195618712756912e-18,
  7.183278244791113e-20, -4.117892546855698e-21,  1.187678029748001e-22,  1.792125414282931e-01, -1.828888953465086e-03,  1.866392292909169e-05, -1.904508008610998e-07,
  1.942141552404495e-09, -1.972578295673897e-11,  1.962877990801210e-13, -1.780021542238075e-15,  9.771012953068631e-18,  1.692539541275448e-19, -9.056552927628612e-21,
  2.598102734967920e-22,  3.083944819565453e-01, -3.147208535815018e-03,  3.211743355681529e-05, -3.277309670039791e-07,  3.341859136714197e-09, -3.392790320529044e-11,
  3.368018943923264e-13, -3.015501511016213e-15,  1.482742025941528e-17,  3.629801602492161e-19, -1.783836864340674e-20,  5.087392216126521e-22,  4.894894071986501e-01,
 -4.995307090411222e-03,  5.097732312023978e-05, -5.201734054307873e-07,  5.303608575290216e-09, -5.380452696157216e-11,  5.318587633805417e-13, -4.652238501582462e-15,
  1.787484201758366e-17,  7.833113119802945e-19, -3.493391886342119e-20,  9.924488532403191e-22,  7.564137446439635e-01, -7.719305878424258e-03,  7.877567094169267e-05,
 -8.038071321896629e-07,  8.193629229647081e-09, -8.299275057939247e-11,  8.128325776042369e-13, -6.733823387939384e-15,  7.940531542068365e-18,  1.951045192726761e-18,
 -7.844807490639812e-20,  2.245984599395940e-21,  3.338502333001451e-03, -3.273355780837057e-05,  3.209474322404539e-07, -3.146770897723321e-09,  3.084726185714524e-11,
 -3.020234643294086e-13,  2.937701503360451e-15, -2.771805239834059e-17,  2.292368236113495e-19, -8.148642870575107e-22, -3.366327019323498e-23,  1.370871094343158e-24,
  3.028574083105046e-02, -2.969475374915696e-04,  2.911524237409794e-06, -2.854640868764261e-08,  2.798347383378867e-10, -2.739782790330387e-12,  2.664569934724082e-14,
 -2.512441991407511e-16,  2.070843716151614e-18, -7.069505383219026e-21, -3.158407198259812e-22,  1.273374185123986e-23,  8.552985039494694e-02, -8.386084564544373e-04,
  8.222424464044151e-06, -8.061774380806157e-08,  7.902743636035746e-10, -7.736986797058246e-12,  7.522501111116895e-14, -7.082931907937066e-16,  5.795101072540247e-18,
 -1.799206337846258e-20, -9.560814876524183e-22,  3.779172981002796e-23,  1.721818423678141e-01, -1.688219347574420e-03,  1.655272435416869e-05, -1.622929607344738e-07,
  1.590896815046173e-09, -1.557402629044250e-11,  1.513508108750330e-13, -1.421578114835828e-15,  1.148186910313879e-17, -2.935007743924745e-20, -2.149041615835640e-21,
  8.252012429169315e-23,  2.962958379048070e-01, -2.905140023315431e-03,  2.848443480211763e-05, -2.792781247931819e-07,  2.737607803520070e-09, -2.679617183261910e-11,
  2.602056903883220e-13, -2.434077167121251e-15,  1.923148839535696e-17, -3.073976603385814e-20, -4.348722870064035e-21,  1.608594108170617e-22,  4.702862170041206e-01,
 -4.611091738601111e-03,  4.521100661240174e-05, -4.432737214570327e-07,  4.345028265704956e-09, -4.252021341606179e-11,  4.123340904438967e-13, -3.829531583775519e-15,
  2.904898217342427e-17,  7.206180664373257e-21, -8.770181045135928e-21,  3.103260186281523e-22,  7.267388308511552e-01, -7.125574162589037e-03,  6.986505948209299e-05,
 -6.849909087350263e-07,  6.713939956540559e-09, -6.567130961944683e-11,  6.350140907743101e-13, -5.806054244139270e-15,  3.992784283776305e-17,  2.036420727957619e-19,
 -2.014257652825104e-20,  6.797509929888109e-22,  3.212475376013332e-03, -3.030906833669793e-05,  2.859599059653769e-07, -2.697957080625270e-09,  2.545311950036355e-11,
 -2.400369301961151e-13,  2.258588450883797e-15, -2.101886624854085e-17,  1.864934153003772e-19, -1.343331233194063e-21, -1.085272300092204e-25,  3.437721832958408e-25,
  2.914246777835785e-02, -2.749534062281610e-04,  2.594129543830392e-06, -2.447493293533367e-08,  2.309016873523890e-10, -2.177515548959649e-12,  2.048813250554598e-14,
 -1.906248239690330e-16,  1.689562727450399e-18, -1.210043414073113e-20, -3.877118471964224e-24,  3.204895233562115e-24,  8.230113713622567e-02, -7.764949127102234e-04,
  7.326071678942004e-06, -6.911955411517231e-08,  6.520872400033405e-10, -6.149413020866121e-12,  5.785438165687788e-14, -5.380326487660093e-16,  4.757852722661865e-18,
 -3.364978410835490e-20, -2.861872367213403e-23,  9.579476337057774e-24,  1.656820555330308e-01, -1.563177345412172e-03,  1.474826015138285e-05, -1.391458980299056e-07,
  1.312725096418925e-09, -1.237916104666453e-11,  1.164469556485995e-13, -1.082057179107170e-15,  9.531083036056984e-18, -6.593028411123654e-20, -1.190294900399008e-22,
  2.113017988660912e-23,  2.851108038153657e-01, -2.689963901322506e-03,  2.537926093785175e-05, -2.394464230425811e-07,  2.258964872554306e-09, -2.130148017635141e-11,
  2.003270129160537e-13, -1.859029436726342e-15,  1.626808501143279e-17, -1.082947932688354e-19, -3.809911926642282e-22,  4.169520127479485e-23,  4.525331248218464e-01,
 -4.269560287446699e-03,  4.028242792963523e-05, -3.800534032148066e-07,  3.585435682486688e-09, -3.380750444409546e-11,  3.178037967921769e-13, -2.942452499615993e-15,
  2.545304496244616e-17, -1.575065415512580e-19, -1.101066629525434e-21,  8.139956382687155e-23,  6.993047688461095e-01, -6.597801762940422e-03,  6.224890137219160e-05,
 -5.872998546550576e-07,  5.540507647347190e-09, -5.223500252103498e-11,  4.906019455868604e-13, -4.520520444926285e-15,  3.813001000840780e-17, -1.955200051088528e-19,
 -3.388893182330837e-21,  1.788091937959213e-22,  3.095618732336440e-03, -2.814431444784939e-05,  2.558785175968819e-07, -2.326356412962319e-09,  2.115006871639289e-11,
 -1.922629175390770e-13,  1.746465439164436e-15, -1.580385158133907e-17,  1.405600950880949e-19, -1.163856574379222e-21,  6.924418895598536e-24,  4.037896183278921e-26,
  2.808238464192455e-02, -2.553155062287208e-04,  2.321241587082258e-06, -2.110390185343438e-08,  1.918660715944259e-10, -1.744138985477570e-12,  1.584309559482489e-14,
 -1.433547931873231e-16,  1.274559912260871e-18, -1.053634979074260e-20,  6.205885258749219e-23,  3.897491449017911e-25,  7.930736021206550e-02, -7.210355913345245e-04,
  6.555409887542528e-06, -5.959944906710522e-08,  5.418479629328279e-10, -4.925593346359152e-12,  4.474099999421448e-14, -4.047732494787970e-16,  3.596125305960466e-18,
 -2.962341765704728e-20,  1.706495307304109e-22,  1.243763610344075e-24,  1.596552236873995e-01, -1.451531084588284e-03,  1.319682589472277e-05, -1.199808246671177e-07,
  1.090803848739647e-09, -9.915730764518382e-12,  9.006411519959465e-14, -8.146018841040764e-16,  7.227909094316823e-18, -5.917990057984464e-20,  3.276014358402651e-22,
  3.000250038602357e-24,  2.747396452469579e-01, -2.497839568488423e-03,  2.270950578248755e-05, -2.064666816875240e-07,  1.877086057337277e-09, -1.706307622189278e-11,
  1.549715019210033e-13, -1.401077618450530e-15,  1.240560603019384e-17, -1.005510596777774e-19,  5.184598381724829e-22,  6.582390403368491e-24,  4.360718307471096e-01,
 -3.964617016417174e-03,  3.604494566370158e-05, -3.277076420592958e-07,  2.979337811195341e-09, -2.708224176486332e-11,  2.459370341246969e-13, -2.221882789691736e-15,
  1.960207664020113e-17, -1.560579932790312e-19,  6.973033372576852e-22,  1.442588957743415e-23,  6.738669372901607e-01, -6.126569371623946e-03,  5.570067723966305e-05,
 -5.064102324656268e-07,  4.603982111558780e-09, -4.184870115653072e-11,  3.799356281302358e-13, -3.427415619891750e-15,  3.000944350029159e-17, -2.296919186624302e-19,
  6.634213100016001e-22,  3.567096771647994e-23,  2.986966481840486e-03, -2.620347675126342e-05,  2.298727406622503e-07, -2.016581774378498e-09,  1.769058856290472e-11,
 -1.551863310336500e-13,  1.361021081282369e-15, -1.192133402041668e-17,  1.037897013650432e-19, -8.807160589157611e-22,  6.737296522070793e-24, -2.998777840547674e-26,
  2.709672892837843e-02, -2.377088965719296e-04,  2.085326158432753e-06, -1.829373368494204e-08,  1.604829018786060e-10, -1.407795967532270e-12,  1.234665951604392e-14,
 -1.081433636572828e-16,  9.414128563082183e-19, -7.984254414507619e-21,  6.092913530683410e-23, -2.659972208766942e-25,  7.652377350075834e-02, -6.713128292230439e-04,
  5.889162005193651e-06, -5.166326596669215e-08,  4.532191101192311e-10, -3.975746259774100e-12,  3.486783024695138e-14, -3.053899598895545e-16,  2.657844347093707e-18,
 -2.251617652863360e-20,  1.709199908302925e-22, -7.144414087885903e-25,  1.540515299346342e-01, -1.351433203931598e-03,  1.185558910607833e-05, -1.040043454823066e-07,
  9.123841687193647e-10, -8.003636152564777e-12,  7.019201246121467e-14, -6.147274938139409e-16,  5.347835384483325e-18, -4.521757301457127e-20,  3.401276170283611e-22,
 -1.311404936296708e-24,  2.650966357812030e-01, -2.325588041586231e-03,  2.040146424055397e-05, -1.789738866760290e-07,  1.570058245040594e-09, -1.377285565979581e-11,
  1.207855078347305e-13, -1.057677600493471e-15,  9.195110914075818e-18, -7.750265005191884e-20,  5.741538342528772e-22, -1.897229163364914e-24,  4.207662683266679e-01,
 -3.691216219531157e-03,  3.238158008064107e-05, -2.840706353674116e-07,  2.492023703624783e-09, -2.186040094839081e-11,  1.917047896335383e-13, -1.678324797021362e-15,
  1.457413447362331e-17, -1.221742843930388e-19,  8.808015789522443e-22, -2.018999427332282e-24,  6.502150713923687e-01, -5.704079907339138e-03,  5.003963677489746e-05,
 -4.389776470824186e-07,  3.850948512194826e-09, -3.378074329035578e-11,  2.962186289778846e-13, -2.592174321155726e-15,  2.245746753529127e-17, -1.861396479223839e-19,
  1.263098100275046e-21,  1.211049507096994e-25,  2.885683774532760e-03, -2.445670380097472e-05,  2.072750872198820e-07, -1.756694495278744e-09,  1.488829126916533e-11,
 -1.261795959604448e-13,  1.069309483695879e-15, -9.058209284610709e-18,  7.657661517954983e-20, -6.415336166035282e-22,  5.181944777197427e-24, -3.614804234772253e-26,
  2.617792716689097e-02, -2.218627752948774e-04,  1.880328047053692e-06, -1.593612608700055e-08,  1.350614370194714e-10, -1.144657552687187e-12,  9.700394537864646e-15,
 -8.217229992096696e-17,  6.946463147982938e-19, -5.818525678610660e-21,  4.696328950492633e-23, -3.264325357615801e-25,  7.392898879178728e-02, -6.265618558476380e-04,
  5.310227589760862e-06, -4.500515550135051e-08,  3.814264976628659e-10, -3.232622087117275e-12,  2.739477646645310e-14, -2.320585803504385e-16,  1.961564961231050e-18,
 -1.642453794352479e-20,  1.323529826731585e-22, -9.128339453163887e-25,  1.488279172458522e-01, -1.261344129738096e-03,  1.069012473868448e-05, -9.060077284571684e-08,
  7.678572160701211e-10, -6.507651936095872e-12,  5.514872333513526e-14, -4.671484343505892e-16,  3.948241108946009e-18, -3.303880730373608e-20,  2.654975634684869e-22,
 -1.806585889438902e-24,  2.561076815597160e-01, -2.170559977495962e-03,  1.839589716394847e-05, -1.559086097501525e-07,  1.321352300942247e-09, -1.119855804102907e-11,
  9.490095004061842e-14, -8.038466413532689e-16,  6.792521625260726e-18, -5.678240367039475e-20,  4.542316864571808e-22, -3.021497704032952e-24,  4.064988344439380e-01,
 -3.445152818269940e-03,  2.919830714517355e-05, -2.474610164374686e-07,  2.097274375961026e-09, -1.777452990284412e-11,  1.506267468063220e-13, -1.275782449508717e-15,
  1.077658714222312e-17, -8.993321963235680e-20,  7.138124167852523e-22, -4.557818696848799e-24,  6.281674377364650e-01, -5.323835236218056e-03,  4.512048792718738e-05,
 -3.824044131247928e-07,  3.240941735639404e-09, -2.746710723276157e-11,  2.327598984523361e-13, -1.971184745234646e-15,  1.663898453371262e-17, -1.383763271420680e-19,
  1.080585579257683e-21, -6.284992633387437e-24,  2.791045327095351e-03, -2.287895796636200e-05,  1.875450432694439e-07, -1.537357702992771e-09,  1.260213508092795e-11,
 -1.033028105142992e-13,  8.467816679402234e-16, -6.940282133517253e-18,  5.684561552824714e-20, -4.641723833315659e-22,  3.741672455500763e-24, -2.868913980063141e-26,
  2.531939983757572e-02, -2.075500096659809e-04,  1.701343898603716e-06, -1.394637843486367e-08,  1.143222191224211e-10, -9.371273999640881e-13,  7.681708402024864e-15,
 -6.295970101056915e-17,  5.156770099939334e-19, -4.210527457532301e-21,  3.393257397629694e-23, -2.599039607665854e-25,  7.150442488718869e-02, -5.861412265562617e-04,
  4.804759108792786e-06, -3.938591652362902e-08,  3.228569596125392e-10, -2.646537833974817e-12,  2.169386900983466e-14, -1.778034007719111e-16,  1.456280584369423e-18,
 -1.188921882327728e-20,  9.576483662221040e-23, -7.318501856721106e-25,  1.439469794426319e-01, -1.179972557256279e-03,  9.672556092748076e-06, -7.928857154458506e-08,
  6.499497540891052e-10, -5.327797109588985e-12,  4.367230583760461e-14, -3.579366398125714e-16,  2.931528172625477e-18, -2.392857954279980e-20,  1.925676586229661e-22,
 -1.465970366215547e-24,  2.477084128758879e-01, -2.030533259712594e-03,  1.664483358484531e-05, -1.364422251173963e-07,  1.118453603527762e-09, -9.168235737359582e-12,
  7.515250810857995e-14, -6.159403920692414e-16,  5.044279750146460e-18, -4.116084513078875e-20,  3.307687763049644e-22, -2.502211827022919e-24,  3.931673603183410e-01,
 -3.222899830021524e-03,  2.641898676785305e-05, -2.165636147499179e-07,  1.775230107162900e-09, -1.455198692215211e-11,  1.192830637930032e-13, -9.776107666348193e-16,
  8.005356180529609e-18, -6.528816382118778e-20,  5.233759939742441e-22, -3.916394907122280e-24,  6.075661537159937e-01, -4.980385075505437e-03,  4.082557147174635e-05,
 -3.346583029450915e-07,  2.743283778690585e-09, -2.248733948543552e-11,  1.843283880440949e-13, -1.510650063791744e-15,  1.236769866099029e-17, -1.007591771324845e-19,
  8.037658331830440e-22, -5.879969094212555e-24,  2.702418017591827e-03, -2.144911316920873e-05,  1.702417807120223e-07, -1.351210349487041e-09,  1.072456629346844e-11,
 -8.512089739658493e-14,  6.756008809505171e-16, -5.362019513268669e-18,  4.254786302614934e-20, -3.372790373619870e-22,  2.661827588453178e-24, -2.063980629816638e-26,
  2.451540347676334e-02, -1.945789511980745e-04,  1.544374673187853e-06, -1.225771389956979e-08,  9.728956356611130e-11, -7.721873919451448e-13,  6.128817443193673e-15,
 -4.864235942994991e-17,  3.859780421934828e-19, -3.059615910539421e-21,  2.414479044912136e-23, -1.871557663887298e-25,  6.923386169216786e-02, -5.495097075688440e-04,
  4.361462891055192e-06, -3.461696518385938e-08,  2.747551015613380e-10, -2.180731550674948e-12,  1.730836768615631e-14, -1.373705247198678e-16,  1.090030238241187e-18,
 -8.640269710011107e-21,  6.817278509696590e-23, -5.280538230693009e-25,  1.393760635297792e-01, -1.106228918051984e-03,  8.780147663547514e-06, -6.968810086879158e-08,
  5.531149556408953e-10, -4.390073870972228e-12,  3.484380785583157e-14, -2.765427076343267e-16,  2.194331246628635e-18, -1.739260774559390e-20,  1.371909250751218e-22,
 -1.061358799801742e-24,  2.398426394463752e-01, -1.903632925322872e-03,  1.510914956958030e-05, -1.199214385791635e-07,  9.518173112936606e-10, -7.554574381869905e-12,
  5.996027107059298e-14, -4.758815230504516e-16,  3.775989771354705e-18, -2.992617782785948e-20,  2.359466739761828e-22, -1.821764523213390e-24,  3.806826596970587e-01,
 -3.021481279434632e-03,  2.398152078756876e-05, -1.903415183441040e-07,  1.510741971294555e-09, -1.199075853495859e-11,  9.516996764108041e-14, -7.553234365951445e-16,
  5.993101946200996e-18, -4.748999134262410e-20,  3.741389978841693e-22, -2.879123456167680e-24,  5.882733987666567e-01, -4.669130616485231e-03,  3.705892659059861e-05,
 -2.941369902229406e-07,  2.334567321464840e-09, -1.852945687519475e-11,  1.470670372292606e-13, -1.167196946240989e-15,  9.260560362391869e-18, -7.335865322981485e-20,
  5.770705625197388e-22, -4.411124094889345e-24,  };
  constexpr double w[2688] = {  4.125397897105281e-01, -8.775915291518570e-03,  2.125993707836983e-04, -5.309630852812400e-06,  1.310764936618184e-07,
 -3.162089900106441e-09,  7.440512041499163e-11, -1.710621198990803e-12,  3.849017915444706e-14, -8.493420932834433e-16,  1.840128523080625e-17, -3.918882324036007e-19,
  3.662103066131541e-01, -2.094515240235570e-02,  1.096740961093201e-03, -4.934749164344090e-05,  1.992870668618686e-06, -7.403456751818108e-08,  2.567732998169028e-09,
 -8.396991180205459e-11,  2.607582041283766e-12, -7.730266742319673e-14,  2.196678398422178e-15, -5.998741240062789e-17,  2.921270295484196e-01, -3.617674168787876e-02,
  3.078753931138735e-03, -2.069447117151798e-04,  1.181867624585239e-05, -5.954398931340104e-07,  2.708219266888997e-08, -1.129369351361032e-09,  4.366114407669771e-11,
 -1.577758011851022e-12,  5.363300554943125e-14, -1.722157530233961e-15,  2.130011580727295e-01, -4.462180759655505e-02,  5.531946075931796e-03, -5.083415941923087e-04,
  3.793756261409057e-05, -2.413402401047924e-06,  1.348220294627628e-07, -6.747812453662154e-09,  3.069498491539924e-10, -1.282755712929339e-11,  4.966100571408367e-13,
 -1.791037619655735e-14,  1.426865367191401e-01, -4.233984870148624e-02,  6.947419043854743e-03, -8.082085878766070e-04,  7.383941588853800e-05, -5.599680524506573e-06,
  3.648632922567271e-07, -2.091119957968300e-08,  1.072189963247320e-09, -4.981599486410876e-11,  2.118431167726152e-12, -8.301560547102654e-14,  8.421988828706795e-02,
 -3.097292722241338e-02,  6.138696817786757e-03, -8.400658855030433e-04,  8.830460470587287e-05, -7.563904449092012e-06,  5.480895345823002e-07, -3.447371751992755e-08,
  1.917862399805253e-09, -9.573077474242494e-11,  4.335854795140220e-12, -1.795729325266128e-13,  3.457728226940190e-02, -1.418955243153588e-02,  3.116327637199998e-03,
 -4.666320691904042e-04,  5.304347002799931e-05, -4.863392397243124e-06,  3.739116209901759e-07, -2.476522462454382e-08,  1.441348335453608e-09, -7.484061620960696e-11,
  3.508721145706716e-12, -1.497602925440333e-13,  3.804788893387870e-01, -7.298577618072062e-03,  1.596552828575629e-04, -3.635415977925282e-06,  8.242778515933013e-08,
 -1.835852436202355e-09,  4.000141484603926e-11, -8.539905371697382e-13,  1.786923770521877e-14, -3.676439230197548e-16,  7.427897872643032e-18, -1.480293303102678e-19,
  2.968673082675932e-01, -1.409200059954572e-02,  6.560325600888383e-04, -2.661637278335552e-05,  9.776679040535355e-07, -3.326595731105964e-08,  1.062859966422905e-09,
 -3.217652701983852e-11,  9.289873677786603e-13, -2.570360743036782e-14,  6.841090029181023e-16, -1.755593476616804e-17,  1.845328089743363e-01, -1.898480574646879e-02,
  1.427655415997683e-03, -8.626354177830445e-05,  4.485512059603378e-06, -2.077292476275034e-07,  8.751383262060827e-09, -3.402010182617607e-10,  1.232804584543380e-11,
 -4.196114525444151e-13,  1.349384865058454e-14, -4.115469619099797e-16,  9.525089991304642e-02, -1.722716936972210e-02,  1.913354364684129e-03, -1.603162689964436e-04,
  1.104728291468580e-05, -6.551281855657564e-07,  3.437955682857923e-08, -1.626741996361403e-09,  7.034038881211247e-11, -2.807478276927676e-12,  1.042388341580574e-13,
 -3.619058085395942e-15,  4.315087440585505e-02, -1.165499062314748e-02,  1.769948552260855e-03, -1.928923379943914e-04,  1.666303022237939e-05, -1.203578278520112e-06,
  7.513928009095541e-08, -4.146574813704158e-09,  2.055770875273250e-10, -9.268817125796527e-12,  3.836845903732342e-13, -1.467664997546278e-14,  1.778684257706285e-02,
 -6.256593004957796e-03,  1.191745162276485e-03, -1.576128054956476e-04,  1.608712971703704e-05, -1.343215167311442e-06,  9.518180348570230e-08, -5.870348959655368e-09,
  3.209635864502030e-10, -1.577594814989665e-11,  7.047712014233210e-13, -2.883245792895037e-14,  5.752735804787999e-03, -2.331051919617111e-03,  5.057310263952302e-04,
 -7.490290269865755e-05,  8.432102407518121e-06, -7.664572722334902e-07,  5.847372096253130e-08, -3.846079377974994e-09,  2.224447551061898e-10, -1.148473342980185e-11,
  5.356518402134263e-13, -2.275504626810981e-14,  3.535911277264895e-01, -6.175902698636448e-03,  1.228809409055978e-04, -2.565252167874587e-06,  5.366283810779794e-08,
 -1.108598870841095e-09,  2.245092254437502e-11, -4.472438761651704e-13,  8.721874612826552e-15, -1.682060793330868e-16,  3.183752416151095e-18, -5.879802059947204e-20,
  2.492914839097583e-01, -9.898268467383715e-03,  4.123140593764291e-04, -1.516550757584703e-05,  5.087756982664421e-07, -1.590721624267997e-08,  4.694147467482708e-10,
 -1.318226530226433e-11,  3.544066404935814e-13, -9.162185258745809e-15,  2.285700681287387e-16, -5.514446179995973e-18,  1.262632408625916e-01, -1.073910738877475e-02,
  7.157204055505911e-04, -3.890500794191607e-05,  1.842036305099487e-06, -7.838056215951247e-08,  3.055925394519015e-09, -1.106038316378221e-10,  3.751117935058544e-12,
 -1.200441967757346e-13,  3.644636406322505e-15, -1.053493605733354e-16,  4.799238286925094e-02, -7.376919258324711e-03,  7.294967921544268e-04, -5.542420117346418e-05,
  3.508980143516170e-06, -1.930758240011110e-07,  9.475421967626106e-09, -4.220440471896899e-10,  1.727485875838268e-11, -6.558613364448660e-13,  2.326373106853968e-14,
 -7.746375558238963e-16,  1.479145689347879e-02, -3.567518866888765e-03,  4.953451995845268e-04, -5.008799986924856e-05,  4.058277452684950e-06, -2.772486337688523e-07,
  1.648180447080355e-08, -8.709702488970124e-10,  4.154533122022853e-11, -1.809551691258461e-12,  7.261929311496012e-14, -2.701470427783963e-15,  4.092067099772150e-03,
 -1.358912093557763e-03,  2.462806552425316e-04, -3.122639924498098e-05,  3.074378135292966e-06, -2.488414581573147e-07,  1.716280436378815e-08, -1.033747127736885e-09,
  5.535376340638330e-11, -2.670956076001606e-12,  1.173783306624436e-13, -4.732270330861324e-15,  9.861503438896716e-04, -3.930642842825405e-04,  8.396188276949089e-05,
 -1.226624860966395e-05,  1.364372767317085e-06, -1.227140195159712e-07,  9.274755398986343e-09, -6.049783618429653e-10,  3.472969035689662e-11, -1.781063013176871e-12,
  8.256540287113358e-14, -3.488161390644058e-15,  3.306772540206274e-01, -5.302904908614353e-03,  9.660229633706358e-05, -1.858500843212150e-06,  3.600682608688038e-08,
 -6.933387035254846e-10,  1.307514396876058e-11, -2.447015357943488e-13,  4.455453326429668e-15, -7.991612261910027e-17,  1.482077085934915e-18, -2.386390092859290e-20,
  2.153106956529192e-01, -7.210056749735962e-03,  2.703596632450212e-04, -9.063938186895689e-06,  2.789203832665089e-07, -8.040674583671810e-09,  2.197846443510596e-10,
 -5.738508628738738e-12,  1.439513628553885e-13, -3.482655502333762e-15,  8.151386678392922e-17, -1.851275875701614e-18,  9.237906519808861e-02, -6.477387444343897e-03,
  3.844887075594734e-04, -1.884008886967796e-05,  8.132064115126975e-07, -3.181077570502483e-08,  1.147893276238670e-09, -3.866659675388101e-11,  1.226458084847053e-12,
 -3.686574083597411e-14,  1.055327360763366e-15, -2.886801992759785e-17,  2.698622432767323e-02, -3.476254910971856e-03,  3.050863288518006e-04, -2.093803854461455e-05,
  1.213612582208947e-06, -6.174051505048116e-08,  2.823623541735240e-09, -1.179705071174345e-10,  4.554833496637093e-12, -1.639224073192737e-13,  5.535512110113240e-15,
 -1.761786312627632e-16,  5.779197605964560e-03, -1.219283129166836e-03,  1.530125576131371e-04, -1.422356787122913e-05,  1.072498724617256e-06, -6.882625684976612e-08,
  3.872264756194498e-09, -1.948599689830038e-10,  8.897535612810729e-12, -3.726462873129547e-13,  1.443618414208966e-14, -5.202244160197303e-16,  1.042873903268743e-03,
 -3.215334605121219e-04,  5.477809090114329e-05, -6.595522497080782e-06,  6.215211171685233e-07, -4.844992136710800e-08,  3.234536050401260e-09, -1.893594678364405e-10,
  9.889367303463159e-12, -4.667711339964274e-13,  2.011509258770059e-14, -7.969773938978951e-16,  1.756420664216875e-04, -6.849080792378658e-05,  1.433912847972316e-05,
 -2.058716967039099e-06,  2.255732810113224e-07, -2.002486368145635e-08,  1.496242904294401e-09, -9.661593120909315e-11,  5.496795601894856e-12, -2.796420411443571e-13,
  1.287031678413757e-14, -5.402140401633410e-16,  3.108825889457594e-01, -4.610454319256079e-03,  7.734883308582741e-05, -1.378345926700352e-06,  2.479642959744606e-08,
 -4.479382922734091e-10,  7.858254937943452e-12, -1.384646041851586e-13,  2.437620646967269e-15, -3.692569125780513e-17,  7.538790531486866e-19, -1.183206095399293e-20,
  1.902004106482684e-01, -5.416979687470698e-03,  1.838607162606372e-04, -5.647676769743094e-06,  1.601096866465405e-07, -4.270195697562955e-09,  1.084569114540909e-10,
 -2.639281959582708e-12,  6.188945749257669e-14, -1.405270798623671e-15,  3.086016238534197e-17, -6.606131536263358e-19,  7.144836308865532e-02, -4.124787795819266e-03,
  2.194860202573695e-04, -9.723239889671792e-06,  3.833977739613222e-07, -1.380498603890076e-08,  4.614750003137672e-10, -1.447260448414763e-11,  4.292869429316834e-13,
 -1.211866773822204e-14,  3.268252041645230e-16, -8.452801154462633e-18,  1.673812305703857e-02, -1.784987330880335e-03,  1.390326791809619e-04, -8.600813799101212e-06,
  4.554543809099908e-07, -2.137303726968097e-08,  9.086397770819061e-10, -3.551553816842013e-11,  1.289904006198790e-12, -4.387972515275030e-14,  1.406599428893146e-15,
 -4.266431970203151e-17,  2.575549780629707e-03, -4.653154108289345e-04,  5.226407476970142e-05, -4.429481401692673e-06,  3.086485098200788e-07, -1.848860648146073e-08,
  9.787707432307670e-10, -4.665294015556074e-11,  2.029084822844321e-12, -8.133915500221178e-14,  3.028717827093149e-15, -1.053037540133488e-16,  2.995662002620848e-04,
 -8.397253836752365e-05,  1.326179784165453e-05, -1.499976336582612e-06,  1.340992023965526e-07, -9.993499121604254e-09,  6.417171323320794e-10, -3.631580484970290e-11,
  1.841026446651487e-12, -8.464499345544346e-14,  3.563876469228544e-15, -1.383194605771851e-16,  3.287700081391844e-05, -1.244370086446627e-05,  2.537272377697399e-06,
 -3.562154574350622e-07,  3.829367276980649e-08, -3.344285545177530e-09,  2.463652125862269e-10, -1.571254690705824e-11,  8.842420476046671e-13, -4.455182790612225e-14,
  2.032860476758372e-15, -8.467075739020330e-17,  2.935822994612592e-01, -4.051699870517757e-03,  6.292344264201960e-05, -1.044199495701692e-06,  1.745062930558102e-08,
 -2.980940888522258e-10,  4.909359327581442e-12, -7.686922284667751e-14,  1.533949991133609e-15, -1.637363411801188e-17,  2.815167852581122e-19, -1.059540718796665e-20,
  1.710989872180936e-01, -4.179314700097851e-03,  1.290388006142039e-04, -3.649349872973253e-06,  9.573480589030615e-08, -2.369683419356398e-09,  5.609673066140065e-11,
 -1.277032862315562e-12,  2.796772927345620e-14, -5.994472828891545e-16,  1.238739419281614e-17, -2.476201919487652e-19,  5.784578912451326e-02, -2.748991093828982e-03,
  1.321323604734449e-04, -5.310162080472291e-06,  1.918188179908199e-07, -6.368203386749386e-09,  1.974839916447601e-10, -5.774519178707579e-12,  1.601184399970009e-13,
 -4.249538300596237e-15,  1.079884846489887e-16, -2.636152894209038e-18,  1.130908914352302e-02, -9.878631600198631e-04,  6.852233296847037e-05, -3.818048196129392e-06,
  1.845980469372008e-07, -7.980901384801693e-09,  3.149396141049975e-10, -1.149721239221768e-11,  3.919883510209583e-13, -1.257839626225243e-14,  3.818906497440512e-16,
 -1.101187454356966e-17,  1.303621058213893e-03, -1.974443375109392e-04,  1.971475254350128e-05, -1.513019930739183e-06,  9.686168135436341e-08, -5.386587603323795e-09,
  2.669559715227843e-10, -1.199446980438133e-11,  4.946251350576009e-13, -1.889512959471130e-14,  6.734530615049966e-16, -2.250224307114867e-17,  9.854975507302848e-05,
 -2.448657887787399e-05,  3.531326502897481e-06, -3.708171957489229e-07,  3.115178105525230e-08, -2.201491552088253e-09,  1.350291276987568e-10, -7.342149658722294e-12,
  3.593833406386558e-13, -1.602002777077754e-14,  6.562633658579412e-16, -2.485816583302314e-17,  6.569440814568491e-06, -2.385405207924875e-06,  4.695503277825880e-07,
 -6.402560582795494e-08,  6.716849118098389e-09, -5.745957735320671e-10,  4.158603936926908e-11, -2.611935435099606e-12,  1.450384887201472e-13, -7.222300788465158e-15,
  3.261383701296446e-16, -1.345909097889928e-17,  2.783090679797999e-01, -3.594102095169199e-03,  5.189053082423909e-05, -8.069210715470208e-07,  1.251921918879039e-08,
 -2.010405039980004e-10,  3.365775948657523e-12, -3.596262485480226e-14,  1.033547662957381e-15, -1.453220646861401e-17, -1.846750188550191e-19, -9.768673838539083e-21,
  1.562015448912603e-01, -3.299313652060389e-03,  9.308077017813348e-05, -2.434155592933433e-06,  5.935703948604991e-08, -1.368294283212023e-09,  3.020137372559293e-11,
 -6.494625978867014e-13,  1.320826411965423e-14, -2.663461098152735e-16,  5.351485217041638e-18, -9.652958017363635e-20,  4.862308542060880e-02, -1.902887978663818e-03,
  8.332761490248285e-05, -3.048567710191956e-06,  1.012396545157945e-07, -3.106171826704634e-09,  8.938031542273744e-11, -2.448154710848006e-12,  6.334291376348365e-14,
 -1.579728085541633e-15,  3.807354372765859e-17, -8.720706521156178e-19,  8.221517198959817e-03, -5.826586681111897e-04,  3.624249112918621e-05, -1.819177229134295e-06,
  8.035980377704930e-08, -3.200482100979728e-09,  1.171226155223117e-10, -3.992270534521798e-12,  1.275703217388621e-13, -3.855542289706375e-15,  1.107443445874400e-16,
 -3.028960750811943e-18,  7.429763946032183e-04, -9.239034326547322e-05,  8.180679697411550e-06, -5.655279909531190e-07,  3.312163794436496e-08, -1.702729536049949e-09,
  7.866511084883908e-11, -3.318296579137278e-12,  1.292186288216687e-13, -4.685618026417665e-15,  1.592478576116511e-16, -5.094590903490603e-18,  3.758143134244134e-05,
 -8.035501386770757e-06,  1.042804558221993e-06, -1.004573041686462e-07,  7.853436332113219e-09, -5.219218070527723e-10,  3.035472288516859e-11, -1.575665262659541e-12,
  7.404145640389930e-14, -3.183586845957218e-15,  1.263076357978334e-16, -4.650098853031543e-18,  1.431386697961075e-06, -4.899444951216653e-07,  9.197657666520311e-08,
 -1.206994962061904e-08,  1.226973771692252e-09, -1.022351277046977e-10,  7.236106210983585e-12, -4.458924585070216e-13,  2.435475148409770e-14, -1.195438677439384e-15,
  5.330469388755582e-17, -2.175394322606345e-18,  2.647060207305265e-01, -3.214583349230958e-03,  4.329006490356101e-05, -6.346730429761766e-07,  9.241648468213864e-09,
 -1.291612909828961e-10,  2.728695972117542e-12, -1.341381954344824e-14,  2.920881754212523e-16, -2.830325556615830e-17, -4.212202259156833e-19,  1.792480331684719e-21,
  1.443289264425042e-01, -2.657213345823656e-03,  6.877862879069086e-05, -1.669411485447165e-06,  3.798053217244550e-08, -8.214830624097734e-10,  1.674524349816132e-11,
 -3.459005321448915e-13,  6.642287622988823e-15, -1.169935998547906e-16,  2.500969512764445e-18, -4.293542249452257e-20,  4.214656574741598e-02, -1.359126306094645e-03,
  5.473623174499293e-05, -1.828937132178210e-06,  5.600890321239253e-08, -1.598210687243694e-09,  4.239004756444326e-11, -1.098476941973279e-12,  2.666634342161258e-14,
 -6.118669515669570e-16,  1.433815384076393e-17, -3.092971445890592e-19,  6.358003538486178e-03, -3.622137440816969e-04,  2.042238200749814e-05, -9.238632249490096e-07,
  3.733853629477792e-08, -1.372739287348354e-09,  4.648401544206029e-11, -1.482104573906327e-12,  4.438430390336042e-14, -1.258986755692860e-15,  3.427285230328003e-17,
 -8.877838889254646e-19,  4.713143105836684e-04, -4.713137198390958e-05,  3.712798389057456e-06, -2.302599750237818e-07,  1.230519346534008e-08, -5.832337624787848e-10,
  2.502960092381447e-11, -9.883410633284046e-13,  3.622552979862055e-14, -1.242515866346327e-15,  4.014202384968732e-17, -1.225432616700999e-18,  1.671124943140067e-05,
 -2.973790919386969e-06,  3.432132486407364e-07, -2.998943302306575e-08,  2.161847158084751e-09, -1.340233676652446e-10,  7.337640696453276e-12, -3.612527167209183e-13,
  1.620055013496114e-14, -6.683031114534266e-16,  2.555441688246761e-17, -9.103575352986489e-19,  3.497288002614473e-07, -1.098958273697634e-07,  1.935554039877076e-08,
 -2.415169082307961e-09,  2.357148950653683e-10, -1.899120771082504e-11,  1.306841516698081e-12, -7.862621809226496e-14,  4.207464999468175e-15, -2.028918229855680e-16,
  8.908192582303414e-18, -3.586583019087999e-19,  2.524954115613319e-01, -2.896387217340482e-03,  3.648713455614895e-05, -5.040360686119121e-07,  7.283962248759750e-09,
 -6.816943441504446e-11,  2.310637518074582e-12, -2.302283957895403e-14, -9.415664883085874e-16, -3.561950510819506e-17,  2.905099234040338e-19,  3.364476857138392e-20,
  1.346867547986397e-01, -2.177906898498407e-03,  5.191232143617838e-05, -1.174229053794065e-06,  2.489508411517293e-08, -5.150869982117793e-10,  9.520720027067424e-12,
 -1.847563107144434e-13,  3.829085586396271e-15, -4.933612623930356e-17,  9.636493462669167e-19, -3.120219222026208e-20,  3.746554214494076e-02, -9.959068367939509e-04,
  3.726518066250284e-05, -1.142180914261839e-06,  3.215146625723915e-08, -8.704822820725538e-10,  2.092501415198594e-11, -5.090949550703963e-13,  1.233423734004090e-14,
 -2.424622496204854e-16,  5.401309116761088e-18, -1.313956539863758e-19,  5.177702827597413e-03, -2.347767303774205e-04,  1.217825393176186e-05, -4.971484051305067e-07,
  1.835946180097792e-08, -6.286344126933831e-10,  1.957622762880887e-11, -5.835440015759797e-13,  1.656708003959971e-14, -4.353527293421014e-16,  1.122761859088474e-17,
 -2.802747747088545e-19,  3.284699608164629e-04, -2.584761202940074e-05,  1.830763345943848e-06, -1.015460908950333e-07,  4.940960497956074e-09, -2.160153902015372e-10,
  8.579850288386220e-12, -3.164650061835980e-13,  1.090495060361844e-14, -3.523825724552867e-16,  1.079678948838457e-17, -3.139334484042943e-19,  8.651497787049295e-06,
 -1.234712809021777e-06,  1.260504633539146e-07, -9.888708700019548e-09,  6.520924789705537e-10, -3.745075128304969e-11,  1.916932547342731e-12, -8.896273031560391e-14,
  3.785787473281606e-15, -1.490205429660988e-16,  5.464876805834995e-18, -1.875206851306959e-19,  9.919440017857271e-08, -2.750490151077507e-08,  4.452417262142673e-09,
 -5.202165959544328e-10,  4.818287018653463e-11, -3.719450371251171e-12,  2.470026454854811e-13, -1.442242407951183e-14,  7.523408514173695e-16, -3.549275383674456e-17,
  1.529040931007924e-18, -6.055227748254951e-20,  2.414580335132005e-01, -2.626788061759818e-03,  3.110195377461529e-05, -3.956808849548170e-07,  6.400843107557870e-09,
 -2.487620148348878e-11,  1.087113186300830e-12, -6.794822740806958e-14, -1.573384999297013e-15,  1.407671050523610e-17,  2.279498789090023e-18,  4.239171949960322e-20,
  1.267251025015189e-01, -1.812909918480145e-03,  3.990751116360942e-05, -8.474353130111038e-07,  1.652463958707228e-08, -3.362629120761881e-10,  5.833618936709486e-12,
 -8.585165031575743e-14,  2.422644167007141e-15, -3.730120068126676e-17, -3.035919761355823e-19, -2.206805534908378e-20,  3.400215113265437e-02, -7.450318555480913e-04,
  2.614790870061308e-05, -7.438832669742713e-07,  1.881007656073702e-08, -5.015660811706784e-10,  1.112241193942316e-11, -2.223220834678468e-13,  6.301028934151229e-15,
 -1.208251457281676e-16,  1.131713286356397e-18, -6.680964610322832e-20,  4.401634779069205e-03, -1.570334893098570e-04,  7.629836811750291e-06, -2.830878585824861e-07,
  9.419358603232528e-09, -3.068630645490374e-10,  8.803717191908532e-12, -2.371200998724736e-13,  6.666786409713659e-15, -1.638325192018569e-16,  3.647825349770658e-18,
 -9.746379851157953e-20,  2.481948921443950e-04, -1.499995198791778e-05,  9.734122996721479e-07, -4.829376281334523e-08,  2.125157875275989e-09, -8.629594083533306e-11,
  3.164627096104387e-12, -1.082534403426890e-13,  3.527957024744396e-15, -1.070704955887738e-16,  3.080500824933318e-18, -8.607181849615644e-20,  5.169571453069047e-06,
 -5.676699099575973e-07,  5.153154881222289e-08, -3.599620272422588e-09,  2.155219521295962e-10, -1.141737217000341e-11,  5.429939598483832e-13, -2.361529445426542e-14,
  9.492523554441839e-16, -3.546393490778153e-17,  1.241035016722750e-18, -4.085613503888466e-20,  3.391744859738516e-08, -7.836233694337866e-09,  1.140313291713630e-09,
 -1.224780705353823e-10,  1.061760731515913e-11, -7.767449731163225e-13,  4.933352240244545e-14, -2.774995789038091e-15,  1.402474850297450e-16, -6.439530273981568e-18,
  2.710175645006485e-19, -1.051784472805885e-20,  2.314208560904029e-01, -2.395256272363083e-03,  2.695445051955053e-05, -2.965664865967083e-07,  5.985214507705963e-09,
 -2.614281115048245e-11, -1.304473948690070e-12, -9.042707539885586e-14,  7.822070974981313e-16,  1.133351715599801e-16,  1.640090190024288e-18, -9.744406890619393e-20,
  1.200533075153506e-01, -1.530297195600214e-03,  3.112546981623501e-05, -6.299128156265018e-07,  1.104432481911572e-08, -2.177016294990506e-10,  4.288783269994871e-12,
 -3.337148756254349e-14,  7.361999095529866e-16, -5.609121433287040e-17, -2.258819862496274e-19,  3.275330211039129e-20,  3.139018071849456e-02, -5.671158084626892e-04,
  1.873812005449578e-05, -5.104249516205105e-07,  1.104535434296232e-08, -2.903688707544390e-10,  7.101858057836881e-12, -8.594400061836929e-14,  2.269459256678406e-15,
 -1.101139815791871e-16,  1.228885527355370e-19,  3.066522817892366e-20,  3.877147745152450e-03, -1.074224552516372e-04,  4.966439201337551e-06, -1.718811835384648e-07,
  4.961750307592236e-09, -1.557594778565731e-10,  4.424574876710385e-12, -9.677698106588716e-14,  2.600768807475579e-15, -7.813811577583978e-17,  1.188137428208532e-18,
 -2.086697232614503e-20,  2.007709625319946e-04, -9.061391112613936e-06,  5.519659007144410e-07, -2.481148702863156e-08,  9.666412668200519e-10, -3.682584563166914e-11,
  1.269056103495634e-12, -3.910385224593124e-14,  1.207068188306879e-15, -3.578959953673747e-17,  9.226303429686471e-19, -2.418405343924775e-20,  3.514386535721649e-06,
 -2.832406347414931e-07,  2.329144387187158e-08, -1.445371086411000e-09,  7.768246483214235e-11, -3.795640583235647e-12,  1.672998267290805e-13, -6.759132798718398e-15,
  2.559961886058477e-16, -9.060261844455226e-18,  2.998876676780071e-19, -9.443228140466918e-21,  1.443141322300257e-08, -2.569174349221066e-09,  3.305982409742970e-10,
 -3.199268236340378e-11,  2.555309843616834e-12, -1.750679724926779e-13,  1.052452805171312e-14, -5.653100339384782e-16,  2.748368764348386e-17, -1.220612851887420e-18,
  4.991759611789701e-20, -1.890172267600509e-21,  2.222507904071572e-01, -2.192282561158712e-03,  2.394534976337698e-05, -2.074462187137255e-07,  4.975625583446697e-09,
 -8.104635046952180e-11, -2.845567591111363e-12,  1.279308058989399e-15,  4.595188313507443e-15,  5.210674593797751e-17, -5.070369029086160e-18, -1.378467005644682e-19,
  1.143861016038916e-01, -1.308821233592880e-03,  2.450039908355706e-05, -4.827369362093575e-07,  7.649806519910972e-09, -1.251615259638477e-10,  3.389294046666810e-12,
 -4.011628524309197e-14, -9.663056209772156e-16, -2.353690683142937e-17,  1.924173606648525e-18,  3.954021501548118e-20,  2.938646599089864e-02, -4.390917254625682e-04,
  1.350974898175083e-05, -3.716138504580176e-07,  6.774804703317644e-09, -1.441246307678871e-10,  5.147147147908332e-12, -7.140226015626640e-14, -1.026365485281237e-15,
 -5.263193733811972e-17,  3.039460838542968e-18,  6.491221728596000e-20,  3.515493486687397e-03, -7.479490514001147e-05,  3.293904515503821e-06, -1.124274714119689e-07,
  2.727644889068512e-09, -7.498046989966941e-11,  2.516697612435378e-12, -5.026217819280001e-14,  5.575383368631441e-16, -3.492087554637279e-17,  1.204778903071902e-18,
  9.678126365641286e-21,  1.717801859411185e-04, -5.620488262401480e-06,  3.272240293117648e-07, -1.388934796962478e-08,  4.643040863481021e-10, -1.612097960152037e-11,
  5.623180078674770e-13, -1.557945702098517e-14,  3.959545947651289e-16, -1.291358077567229e-17,  3.548388412478018e-19, -5.586109782771094e-21,  2.667925662720603e-06,
 -1.497723971203789e-07,  1.146329140863316e-08, -6.424696274544610e-10,  3.034447833283216e-11, -1.360900188109106e-12,  5.645173633078118e-14, -2.094001901828726e-15,
  7.335014235677434e-17, -2.503435160447641e-18,  7.854965534546173e-20, -2.268397787182737e-21,  7.729910428714912e-09, -9.628552405954627e-10,  1.095939667396112e-10,
 -9.399299859773658e-12,  6.787150350011070e-13, -4.305631522501604e-14,  2.426309661916885e-15, -1.231154273516787e-16,  5.709971718289568e-18, -2.438363166361855e-19,
  9.624911607336802e-21, -3.533943297277099e-22,  2.138507392558058e-01, -2.009469804831126e-03,  2.186891522141422e-05, -1.441963927100671e-07,  2.762116841844399e-09,
 -1.321609994608701e-10, -7.916250058350326e-13,  1.326187618726392e-13,  2.192387807247387e-15, -1.762168701061842e-16, -3.588294124757030e-18,  2.185709101457678e-19,
  1.095088552838645e-01, -1.134072366829273e-03,  1.937244172799464e-05, -3.763953693004149e-07,  5.849751784437141e-09, -6.099266809058232e-11,  1.822331065881543e-12,
 -6.821617924101469e-14, -3.024230112209012e-16,  5.495877988534370e-17,  1.098046370478312e-18, -7.687373702942453e-20,  2.782037555301995e-02, -3.471876106489158e-04,
  9.625334516026485e-06, -2.803249368985469e-07,  4.942448494602619e-09, -4.911437640766438e-11,  2.590527520712030e-12, -1.081042379313658e-13, -4.552608180104867e-16,
  7.856834240402695e-17,  2.121016271519174e-18, -1.157289818514797e-19,  3.261393093825866e-03, -5.319318671672736e-05,  2.166526428739407e-06, -7.795397699382223e-08,
  1.724793490195422e-09, -3.026815143629185e-11,  1.239060794380566e-12, -4.288130728594205e-14,  1.914851287226533e-16,  1.220146032821006e-17,  8.186154954733983e-19,
 -3.289840940062763e-20,  1.536294217734375e-04, -3.563482075702899e-06,  1.965069656498444e-07, -8.433755774753733e-09,  2.474068849299907e-10, -6.770074141119210e-12,
  2.507768153405790e-13, -8.004930204435965e-15,  1.388362009516940e-16, -2.561686889356044e-18,  1.673549294175939e-19, -4.607239618530280e-21,  2.212847240125021e-06,
 -8.232395362382922e-08,  5.962041998082358e-09, -3.171380540036521e-10,  1.300900533604229e-11, -5.099795882521585e-13,  2.054830228807958e-14, -7.333455046307821e-16,
  2.219013005572494e-17, -6.913247766055553e-19,  2.346222535275496e-20, -6.462166467914880e-22,  5.112236425700863e-09, -4.021543573807456e-10,  4.129886289418952e-11,
 -3.148265520665296e-12,  2.006696506245817e-13, -1.159822444279231e-14,  6.111387507839972e-16, -2.905248329379368e-17,  1.265280536828339e-18, -5.160576530247037e-20,
  1.968417380798855e-21, -6.939338178268991e-23,  2.061525991138919e-01, -1.840889637588129e-03,  2.031676893308414e-05, -1.208561061260490e-07,  2.438460260308622e-10,
 -1.050035892517323e-10,  2.875259454126423e-12,  9.484066350474167e-14, -4.112622075817678e-15, -1.056063675419352e-16,  6.209782595185742e-18,  1.019466860893737e-19,
  1.052560584342942e-01, -9.956491657436741e-04,  1.538294849490269e-05, -2.908259477696082e-07,  4.915184970476139e-09, -3.931654215870838e-11,  9.323242784866118e-14,
 -4.490875500207507e-14,  1.592930357863828e-15,  2.852631237199317e-17, -2.030939192314272e-18, -2.709612199303234e-20,  2.656614666493433e-02, -2.823539941411525e-04,
  6.711634479711069e-06, -2.067477315910478e-07,  4.340537257633707e-09, -2.198805299730294e-11, -1.633507784023849e-13, -7.232084579927169e-14,  2.508529930540171e-15,
  4.955072881816665e-17, -3.113577880832748e-18, -5.674784757799362e-20,  3.077972770152827e-03, -3.917108560641316e-05,  1.380844900783232e-06, -5.397342813989598e-08,
  1.325419962299585e-09, -1.369394828817562e-11,  2.165438366832002e-13, -2.666633057933199e-14,  8.156294151747646e-16,  1.152704772757329e-17, -7.541486134889255e-19,
 -2.001344117517871e-20,  1.419623320429990e-04, -2.337462173151549e-06,  1.154558885235673e-07, -5.299338207734880e-09,  1.564048227404911e-10, -2.988350732154850e-12,
  8.177606344624891e-14, -4.162209832519684e-15,  1.158786827771513e-16, -6.508164189046445e-20, -3.034891233382988e-20, -2.890665415710968e-21,  1.958998069127208e-06,
 -4.694253189009361e-08,  3.139325792142708e-09, -1.695742210613835e-10,  6.414545102266844e-12, -2.007079525311442e-13,  7.229304887396324e-15, -2.868536731106839e-16,
  8.685523053708521e-18, -1.802430730007386e-19,  4.931244900403905e-21, -2.407131324969407e-22,  3.984119041643405e-09, -1.818513831333181e-10,  1.711395168932812e-11,
 -1.208231318167889e-12,  6.743678618835593e-14, -3.409379919198904e-15,  1.665565501498306e-16, -7.566991379659833e-18,  3.071584729326031e-19, -1.147662655908762e-20,
  4.192964084251623e-22, -1.481911397223531e-23,  1.991048417490604e-01, -1.684222205773705e-03,  1.883450790173823e-05, -1.293978396675764e-07, -1.036292144773909e-09,
 -2.072254734401895e-11,  3.472710544733533e-12, -4.826737193780172e-14, -3.465585869667567e-15,  1.155905020859733e-16,  2.618697306591755e-18, -1.903734031659712e-19,
  1.014992937529239e-01, -8.852689410857903e-04,  1.233843615488576e-05, -2.186694740491846e-07,  4.081074169438787e-09, -4.603346080175047e-11, -4.098203693417395e-13,
  6.825667421754507e-15,  1.217982544350846e-15, -3.998775297496952e-17, -7.290788376978382e-19,  6.054923466729145e-20,  2.553002164656111e-02, -2.374416983353689e-04,
  4.630690914896414e-06, -1.415433331211296e-07,  3.748115752024191e-09, -4.039661136081846e-11, -9.767182268422220e-13,  1.145792279656348e-14,  2.029522648489012e-15,
 -6.330687071917970e-17, -1.342549928441709e-18,  9.863703497677959e-20,  2.939762526874295e-03, -3.037455160170231e-05,  8.517210445447572e-07, -3.487350229963391e-08,
  1.059066845916008e-09, -1.435411729955034e-11, -1.483161175956136e-13, -3.601548817521452e-16,  6.422319365095649e-16, -1.841590189977145e-17, -3.840641562800173e-19,
  2.683312703868410e-20,  1.341117674257392e-04, -1.629657227505760e-06,  6.516138936739184e-08, -3.200591926257643e-09,  1.089361675231213e-10, -2.019853839027905e-12,
  1.423167482344091e-14, -8.635931546706253e-16,  7.780237241533367e-17, -2.014456257792010e-18, -2.871473656638255e-20,  2.124635194966478e-21,  1.810693555647502e-06,
 -2.847805959172382e-08,  1.612052341327916e-09, -9.186034923943285e-11,  3.625316742593147e-12, -9.722391103443952e-14,  2.292050165045296e-15, -8.982141246750836e-17,
  4.028909748222929e-18, -1.055310697414213e-19,  6.717907667240332e-22,  9.692566817487966e-24,  3.459195972219001e-09, -8.865383751222669e-11,  7.384946747245040e-12,
 -5.135706443236740e-13,  2.651876526028317e-14, -1.135352237623651e-15,  4.746157634747203e-17, -2.071061187089865e-18,  8.497238573137875e-20, -2.961575914885917e-21,
  9.058762683194170e-23, -2.908105756444658e-24,  1.926590647571335e-01, -1.540044200528477e-03,  1.718155924416085e-05, -1.453974377601600e-07, -7.738351241610360e-10,
  3.805433189718104e-11,  1.249117817771141e-12, -8.744400431558241e-14,  7.943532279187062e-16,  8.326911904273691e-17, -2.949006969738248e-18, -2.775258468798448e-20,
  9.814048529810561e-02, -7.960203954081334e-04,  1.007440140481687e-05, -1.611458653327166e-07,  3.094306633435149e-09, -5.058187507550409e-11,  9.829282444755409e-14,
  2.183684725604875e-14, -1.920219317547451e-16, -2.690393326389648e-17,  9.615484327681542e-19,  6.931701332085132e-21,  2.464493769381816e-02, -2.062394637322380e-04,
  3.261755358651912e-06, -8.909846004222762e-08,  2.760052581018994e-09, -5.492463884194214e-11, -1.167687148751765e-13,  3.741786642179725e-14, -2.856951142647999e-16,
 -4.555495610681660e-17,  1.565235117122930e-18,  1.466465816752750e-20,  2.829617951246359e-03, -2.496959651426444e-05,  5.248820650564633e-07, -2.038858308955931e-08,
  7.447689022774834e-10, -1.637529835170533e-11,  2.140153082259567e-14,  8.803128348843903e-15, -3.710802074602758e-17, -1.367122565945164e-17,  4.445310234846835e-19,
  4.678388324726320e-21,  1.284303823918571e-04, -1.235336873727794e-06,  3.592692973344952e-08, -1.766290936962804e-09,  7.115170229372008e-11, -1.757458440105896e-12,
  1.349345623012281e-14,  4.263951204931837e-16,  6.490515312688177e-18, -1.452525423693750e-18,  4.310104263811065e-20,  4.437298063370519e-22,  1.716810429223577e-06,
 -1.913654414175067e-08,  8.014730848762429e-10, -4.705808133511308e-11,  2.088421330676130e-12, -6.110811269542187e-14,  1.058270085738452e-15, -1.462338009102945e-17,
  9.529663737315085e-19, -5.848751123506585e-20,  1.584645513257316e-21,  2.884193044866209e-24,  3.192025851694459e-09, -4.841537062859600e-11,  3.176145963790193e-12,
 -2.242816604157288e-13,  1.175024978477476e-14, -4.632807551431288e-16,  1.539051108740505e-17, -5.413015618231485e-19,  2.251793800818009e-20, -9.008460559661376e-22,
  2.814051922624909e-23, -6.397767400319654e-25,  1.867625304622731e-01, -1.409716686257534e-03,  1.539080484521884e-05, -1.508146549596495e-07,  1.123252542624749e-10,
  4.347682399941369e-11, -5.544107803058636e-13, -3.634712134857672e-14,  1.791569292882087e-15, -1.661229155111052e-17, -1.411661271626356e-18,  6.027186969604090e-20,
  9.510643611061412e-02, -7.223936364635661e-04,  8.405253816801722e-06, -1.194153440575927e-07,  2.149363480665937e-09, -4.221165576929569e-11,  5.300769297359139e-13,
  7.348079589230902e-15, -5.205312339748708e-16,  4.881923807613940e-18,  4.421190074085869e-19, -1.898293498240583e-20,  2.386634698966158e-02, -1.837542485860550e-04,
  2.421690281221886e-06, -5.355531190892791e-08,  1.708217141394774e-09, -4.726912145927453e-11,  6.422154744575299e-13,  1.387206255121913e-14, -8.627080043219442e-16,
  7.582149333336171e-18,  7.570291089873646e-19, -3.179655173269488e-20,  2.736842025817723e-03, -2.157093418856720e-05,  3.412125275084942e-07, -1.098762720835915e-08,
  4.401954096964358e-10, -1.336859156513105e-11,  2.018549299618314e-13,  3.136346947260691e-15, -2.235599796787537e-16,  1.689820180882736e-18,  2.238694145860788e-19,
 -9.104759423000351e-21,  1.239535964931153e-04, -1.015887075127773e-06,  2.047007339514403e-08, -8.874798852598233e-10,  4.016833729394299e-11, -1.303139755165888e-12,
  2.286674426792538e-14,  1.275734494404655e-16, -1.601672218301612e-17,  5.152907394578913e-20,  2.259904022285441e-20, -8.631300731875859e-22,  1.650201565556514e-06,
 -1.449992839272324e-08,  4.011263556069621e-10, -2.213856753743149e-11,  1.098190670989036e-12, -3.869724689207129e-14,  8.431330105204482e-16, -6.274973957807119e-18,
 -1.184518136932087e-19, -6.673892520530718e-21,  7.870224398160272e-22, -2.681709931389990e-23,  3.035859793442758e-09, -3.117021408479549e-11,  1.360778389030191e-12,
 -9.433878477282503e-14,  5.268732698195816e-15, -2.177549101792818e-16,  6.720491414406540e-18, -1.687670161580965e-19,  4.831271395280990e-21, -2.067810493901796e-22,
  9.004061315368846e-24, -2.857295347178215e-25,  1.813585774542022e-01, -1.293738688857056e-03,  1.361747885308166e-05, -1.430235266695689e-07,  7.964719643470689e-10,
  2.361344758189139e-11, -9.096724249284805e-13,  5.146933405242495e-15,  7.262568376419319e-16, -3.069392118427941e-17,  3.684295027954810e-19,  1.654234192623303e-20,
  9.234301675160747e-02, -6.603583666533187e-04,  7.153103938319585e-06, -9.104910578863170e-08,  1.440298717149357e-09, -2.865598183338259e-11,  5.447840314700542e-13,
 -4.533573888177863e-15, -1.982315105234629e-16,  9.325242085342233e-18, -1.128345749996672e-19, -5.126021029945450e-21,  2.316657546484746e-02, -1.665527106493106e-04,
  1.914766442325925e-06, -3.286873498601509e-08,  9.339328072791596e-10, -2.991617125644169e-11,  7.123531693480074e-13, -5.968479751235861e-15, -3.347637308965634e-16,
  1.546401602740949e-17, -1.846387345178347e-19, -8.814339261176774e-21,  2.655327143472688e-03, -1.926742394271414e-05,  2.436982154684011e-07, -5.803761268060117e-09,
  2.246089174221496e-10, -8.178722169127463e-12,  2.068171368699586e-13, -2.019877438503017e-15, -8.511461225969722e-17,  4.181432759141616e-18, -4.864356812518733e-20,
 -2.592695748288431e-21,  1.201631806569451e-04, -8.855847567891746e-07,  1.291394734792689e-08, -4.232287402200536e-10,  1.960797711949161e-11, -7.631578433434260e-13,
  2.038915907069851e-14, -2.478962762097636e-16, -5.863534726431193e-18,  3.377024213234508e-19, -3.561625953434892e-21, -2.562935730523323e-22,  1.597290092177217e-06,
 -1.210687012554303e-08,  2.187265727803008e-10, -9.728212182277476e-12,  5.098288409262932e-13, -2.105662703573372e-14,  6.093200656380913e-16, -9.902767679977079e-18,
 -3.791076036817490e-20,  5.750862225416187e-21, -2.266587336123241e-23, -8.323602556864214e-24,  2.927431685430780e-09, -2.366014816422838e-11,  6.153958992402084e-13,
 -3.747666407215265e-14,  2.212210949433405e-15, -1.006208055263275e-16,  3.414723783729142e-18, -8.406218662571965e-20,  1.485067363622593e-21, -2.863815901121942e-23,
  1.426972469011942e-24, -7.850149302190464e-26,  1.763909765069868e-01, -1.191418767905602e-03,  1.198962173710165e-05, -1.276036717785588e-07,  1.071779984663960e-09,
  5.240424222170054e-12, -5.810159546098894e-13,  1.433412558603868e-14, -3.209832413429246e-17, -1.114122778462544e-17,  4.413819061156152e-19, -6.789399836181619e-21,
  8.980961436928417e-02, -6.071513266129089e-04,  6.182030528831697e-06, -7.193133473663543e-08,  9.851194916916557e-10, -1.754930994229005e-11,  3.717368579458396e-13,
 -6.619726684484147e-15,  3.094176914406172e-17,  3.310677913475776e-18, -1.360507733918813e-19,  2.084348991358848e-21,  2.252880871732188e-02, -1.525980356762613e-04,
  1.593068964901234e-06, -2.185610467041017e-08,  4.887374757514513e-10, -1.558445133251823e-11,  4.661003584531032e-13, -9.619309739490631e-15,  4.516198805271493e-17,
  5.462607756882768e-18, -2.267885832325713e-19,  3.507907466446811e-21,  2.581787463612435e-03, -1.754611689611151e-05,  1.910288661725509e-07, -3.272072596686304e-09,
  1.050279679530586e-10, -4.079541834369450e-12,  1.312821325858839e-13, -2.835842928247374e-15,  1.725774936797268e-17,  1.441682647806868e-18, -6.265370943898696e-20,
  9.771832732694362e-22,  1.168015015014966e-04, -7.982548550888743e-07,  9.292929818069651e-09, -2.076292373786779e-10,  8.609267088137308e-12, -3.684310431305911e-13,
  1.237180266955150e-14, -2.812803474116911e-16,  2.374286916145346e-18,  1.109418027184721e-19, -5.330222071758537e-21,  8.353275102290031e-23,  1.551782398959204e-06,
 -1.071265223087966e-08,  1.393494817235566e-10, -4.239915174116102e-12,  2.125123609680032e-13, -9.724845843935258e-15,  3.421501639704225e-16, -8.423665659596886e-18,
  1.043259574798432e-19,  1.645557147116923e-21, -1.107972136153220e-22,  1.660642683111635e-24,  2.840469070787076e-09, -2.006176781482375e-11,  3.240873319906448e-13,
 -1.444087480081610e-14,  8.533950652806978e-16, -4.222986009951682e-17,  1.620784167111449e-18, -4.677782939954419e-20,  9.417617225497213e-22, -1.034237897720866e-23,
  1.425177819103982e-26, -4.610060828566572e-27,  1.718078541693632e-01, -1.101331547175650e-03,  1.056263268092148e-05, -1.102436681541704e-07,  1.067875996700770e-09,
 -4.267974703284094e-12, -2.336636393324823e-13,  9.670808092810742e-15, -1.924919087066843e-16,  1.773603603687820e-19,  1.379037981336886e-19, -5.342427917076239e-21,
  8.747480148688144e-02, -5.609036603696073e-04,  5.403248713198063e-06, -5.855249532578719e-08,  7.092606580136314e-10, -1.066264497835037e-11,  2.117892747751841e-13,
 -4.580239633307896e-15,  7.590557657807285e-17, -1.792190071940844e-19, -4.242447112190904e-20,  1.656404276472984e-21,  2.194240549960018e-02, -1.407898162894884e-04,
  1.369158389315223e-06, -1.600888460237471e-08,  2.685087297714336e-10, -7.339717305499215e-12,  2.359488047035598e-13, -6.453981979702815e-15,  1.184893458255481e-16,
 -3.235084939932941e-19, -6.937499444132154e-20,  2.770249423478917e-21,  2.514444180699470e-03, -1.615159433657601e-05,  1.596386858061743e-07, -2.098572406693933e-09,
  4.898336773402097e-11, -1.786311390671920e-12,  6.448837988912243e-14, -1.846098493022302e-15,  3.523072501832173e-17, -1.446976025690967e-19, -1.858033685760935e-20,
  7.733411844549259e-22,  1.137440734731511e-04, -7.320036435140442e-07,  7.430094653047117e-09, -1.151860876262983e-10,  3.627228616178977e-12, -1.550200070402199e-13,
  5.912086422837358e-15, -1.746804485959144e-16,  3.501440838596009e-18, -2.225084425342646e-20, -1.487728151385956e-21,  6.736919167274580e-23,  1.510904465014199e-06,
 -9.755820980689664e-09,  1.036967362386477e-10, -2.022502560480969e-12,  8.311018328154350e-14, -3.938122725304184e-15,  1.567936902316171e-16, -4.825245736179957e-18,
  1.046263267755552e-19, -1.051135259998313e-21, -2.626160643725375e-23,  1.510923067835073e-24,  2.764567844911896e-09, -1.798254317093371e-11,  2.106183373600400e-13,
 -5.818290685672574e-15,  3.078340024536200e-16, -1.598699962926687e-17,  6.769433657982758e-19, -2.259221480552709e-20,  5.722126037638615e-22, -9.784567392968145e-24,
  5.692850877514169e-26,  2.228651187995776e-27,  1.675635511006446e-01, -1.021839779043379e-03,  9.338643077859055e-06, -9.406531311740548e-08,  9.449047161143233e-10,
 -7.288475587192635e-12, -4.283051125761567e-14,  4.298895404416657e-15, -1.312966388318216e-16,  2.304463015706295e-18, -2.602713128496252e-21, -1.415927122992902e-21,
  8.531344184281280e-02, -5.203098814551883e-04,  4.762457439669685e-06, -4.867300697526193e-08,  5.378098001209781e-10, -6.858792979473185e-12,  1.149460751071832e-13,
 -2.464305174968440e-15,  5.272926228413248e-17, -8.224454988405434e-19,  1.323103231416930e-21,  4.440441416298749e-22,  2.140002667427489e-02, -1.305413733463350e-04,
  1.198831120837547e-06, -1.263344019827216e-08,  1.658201121869667e-10, -3.441819952221303e-12,  1.039233830045383e-13, -3.188040899523483e-15,  7.991262071545685e-17,
 -1.345998152294466e-18,  3.140315984391885e-21,  7.207439060401278e-22,  2.452248353185892e-03, -1.496413997894173e-05,  1.382089362327785e-07, -1.531938808085858e-09,
  2.517134579695102e-11, -7.400022269026638e-13,  2.710143676393855e-14, -8.909267236190040e-16,  2.304094522315688e-17, -4.017104613992166e-19,  1.456795692332588e-21,
  1.937702653413634e-22,  1.109273225451393e-04, -6.772981289629603e-07,  6.314712653891298e-09, -7.569194461412825e-11,  1.610756587334434e-12, -6.018859770252452e-14,
  2.415645741669787e-15, -8.221107357155804e-17,  2.182184051470029e-18, -3.986423959144524e-20,  2.260508160749682e-22,  1.570213560972841e-23,  1.473412067116782e-06,
 -9.005580961902192e-09,  8.535821145368176e-11, -1.158006652289130e-12,  3.282403151606446e-14, -1.457495181027804e-15,  6.205280286127155e-17, -2.180747081747080e-18,
  6.007845095693460e-20, -1.183537222626298e-21,  1.063623121364394e-23,  2.917412844221001e-25,  2.695657631860481e-09, -1.651263928117129e-11,  1.621521226519478e-13,
 -2.749966367643585e-15,  1.087036984731928e-16, -5.568083661628670e-18,  2.517750218069794e-19, -9.332741802511926e-21,  2.774282373521464e-22, -6.336098464251449e-24,
  9.645174823749632e-26, -2.791287948344793e-28,  1.636188093004969e-01, -9.514000248821579e-04,  8.295672215969935e-06, -8.013550515523946e-08,  7.964672304704485e-10,
 -7.273090071944035e-12,  3.053349031343102e-14,  1.321199066955671e-15, -5.958559622346044e-17,  1.540812438323330e-18, -2.504361087412632e-20,  5.783590747857600e-23,
  8.330489636131699e-02, -4.844097972797063e-04,  4.225913235943153e-06, -4.103593803474828e-08,  4.235049662433238e-10, -4.763701175785609e-12,  6.535107780503533e-14,
 -1.214244289263977e-15,  2.702197093286836e-17, -5.619866562306204e-19,  8.394427942618946e-21, -1.800688368084354e-23,  2.089614006309021e-02, -1.215165090705162e-04,
  1.061244312214151e-06, -1.042120017270768e-08,  1.160052333522678e-10, -1.772630850049881e-12,  4.360620040764311e-14, -1.339819865927699e-15,  3.842840191305791e-17,
 -8.909634892409205e-19,  1.415022588282788e-20, -4.335791696066081e-23,  2.394495136188154e-03, -1.392608674207071e-05,  1.218482677215042e-07, -1.219404664413861e-09,
  1.523138817790990e-11, -3.182577753052205e-13,  1.045248533700485e-14, -3.626514055753143e-16,  1.086498658205911e-17, -2.578722518822482e-19,  4.224449565138757e-21,
 -1.778699547363569e-23,  1.083139324185739e-04, -6.300499022099770e-07,  5.529688998674693e-09, -5.705686611779352e-11,  8.357458446635069e-13, -2.318481164660138e-14,
  8.934250992561922e-16, -3.273317684635464e-17,  1.004981843720886e-18, -2.439972518750593e-20,  4.174315642278291e-22, -2.497002121854230e-24,  1.438677703264260e-06,
 -8.371149984987162e-09,  7.386505057670155e-11, -8.024286636074526e-13,  1.458861116942969e-14, -5.197412047505939e-16,  2.217662950323756e-17, -8.438140699652813e-19,
  2.660284612762059e-20, -6.685288219326746e-22,  1.227132926331436e-23, -1.084742026357740e-25,  2.632025321313288e-09, -1.532456012811367e-11,  1.367719505391260e-13,
 -1.646530741389114e-15,  4.098533844278426e-17, -1.843269836892743e-18,  8.551348360307010e-20, -3.405860957964404e-21,  1.126720905035398e-22, -3.039877808191088e-24,
  6.399466631983414e-26, -9.075479070805755e-28,  1.599401413118652e-01, -8.886752599527653e-04,  7.405862076895252e-06, -6.850661629300620e-08,  6.604095610639595e-10,
 -6.267215080287357e-12,  4.785953158951620e-14,  1.209164798685561e-16, -2.049182971652051e-17,  6.934396475039185e-19, -1.604701540067708e-20,  2.488089746230648e-22,
  8.143190676718666e-02, -4.524637612525980e-04,  3.771242625669488e-06, -3.494685190481309e-08,  3.415951303958072e-10, -3.522011765172152e-12,  4.085766014846373e-14,
 -6.123304687540540e-16,  1.230921009237778e-17, -2.752961050277796e-19,  5.521832465835917e-21, -8.024935047438796e-23,  2.042630331707436e-02, -1.134975981011631e-04,
  9.463110823197310e-07, -8.802472424495998e-09,  8.858548425936473e-11, -1.063202121207163e-12,  1.922342693621537e-14, -5.215076390308207e-16,  1.555368810671163e-17,
 -4.154046449874158e-19,  9.000476381300906e-21, -1.375993223679227e-22,  2.340652991472419e-03, -1.300609890239297e-05,  1.085037769808990e-07, -1.015838106938107e-09,
  1.072304652564026e-11, -1.574305115050407e-13,  3.988774867679762e-15, -1.334003746354065e-16,  4.296081373956410e-18, -1.181642532945581e-19,  2.608661729508358e-21,
 -4.099714685344295e-23,  1.058781539018060e-04, -5.883527831006959e-07,  4.912995490404583e-09, -4.648503178311078e-11,  5.279676133979804e-13, -9.810210123816537e-15,
  3.164151308302621e-16, -1.169607361651614e-17,  3.900079677139903e-19, -1.093235199789505e-20,  2.463040876516485e-22, -4.026076767227418e-24,  1.406318715380781e-06,
 -7.815413926460011e-09,  6.536871688146294e-11, -6.298071406893435e-13,  8.016708130413369e-15, -1.939354657127503e-16,  7.464687154593741e-18, -2.934244932816348e-19,
  1.005362515545807e-20, -2.884191732851254e-22,  6.709145216344241e-24, -1.169131508525211e-25,  2.572803087188593e-09, -1.430048250140021e-11,  1.200193725519164e-13,
 -1.200409236226544e-15,  1.865347297991975e-17, -6.132216873551307e-19,  2.726145327670609e-20, -1.131760490534812e-21,  4.028041810503979e-23, -1.207819962159496e-24,
  3.000925366360996e-26, -5.920592271048258e-28,  1.564989691125596e-01, -8.325461690149226e-04,  6.643248296672306e-06, -5.888033491488677e-08,  5.465262299879981e-10,
 -5.132912004753459e-12,  4.505229814132797e-14, -2.391864845337474e-16, -4.652844579521394e-18,  2.461538143020903e-19, -7.061798913868939e-21,  1.505118978483917e-22,
  7.967986016204875e-02, -4.238833886291236e-04,  3.382507361867990e-06, -2.999670553511612e-08,  2.797681617628814e-10, -2.710458462716305e-12,  2.800281039916110e-14,
 -3.408909835484886e-16,  5.586167196764159e-18, -1.176846720742876e-19,  2.588444582775107e-21, -4.996160877024024e-23,  1.998681697960105e-02, -1.063270071589213e-04,
  8.485536352184773e-07, -7.534257369965387e-09,  7.099245607495209e-11, -7.324380541467945e-13,  9.771513925680192e-15, -2.046617031687991e-16,  5.740518492583158e-18,
 -1.625940164124334e-19,  4.053848034226302e-21, -8.282474109259731e-23,  2.290291290807313e-03, -1.218412307351563e-05,  9.725318255122469e-08, -8.652913002100986e-10,
  8.295149300568248e-12, -9.428134321763117e-14,  1.663050894565918e-15, -4.712750829087424e-17,  1.524915425802170e-18, -4.541596371897221e-20,  1.156595988543031e-21,
 -2.400357646195097e-23,  1.036000037233594e-04, -5.511491884346708e-07,  4.400469699206073e-09, -3.928460694430451e-11,  3.871430554498352e-13, -5.039603984376390e-15,
  1.161687701128218e-16, -3.929733571530804e-18,  1.354532686138096e-19, -4.132476361937001e-21,  1.068995674202363e-22, -2.259759130763713e-24,  1.376057849045606e-06,
 -7.320757519046664e-09,  5.847787554791528e-11, -5.250814271963080e-13,  5.417200665846629e-15, -8.499303769202343e-17,  2.507703711503731e-18, -9.512202546267060e-20,
  3.411764394439555e-21, -1.063335670196321e-22,  2.808649008234879e-24, -6.115145158469421e-26,  2.517436406625540e-09, -1.339361897046072e-11,  1.070915138108514e-13,
 -9.731164758230274e-16,  1.097368188296162e-17, -2.265981086106634e-19,  8.469978533738047e-21, -3.512433183590262e-22,  1.311016405096770e-23, -4.224511051534570e-25,
  1.162394475304559e-26, -2.688909788793467e-28,  1.532708015494267e-01, -7.820852161481813e-04,  5.985946619002325e-06, -5.090092466759587e-08,  4.540796966834538e-10,
 -4.142322121437330e-12,  3.728023977192938e-14, -2.896489695473376e-16,  4.512931658077160e-19,  6.725074128043880e-20, -2.512858992538668e-21,  6.427039227924119e-23,
  7.803626925569297e-02, -3.981909721076673e-04,  3.047725931118645e-06, -2.592049839671740e-08,  2.315965986634125e-10, -2.136026864034792e-12,  2.044393491688410e-14,
 -2.136692387969039e-16,  2.768666827303774e-18, -4.894555358955485e-20,  1.049673127349824e-21, -2.241560827336937e-23,  1.957453909291170e-02, -9.988195137139342e-05,
  7.645111322504129e-07, -6.504460587634644e-09,  5.831257313784259e-11, -5.503781662604267e-13,  5.919458458254901e-15, -8.947597086406045e-17,  2.073995532199816e-18,
 -5.761144010312586e-20,  1.537385019528856e-21, -3.594073872633519e-23,  2.243048099135767e-03, -1.144550641635184e-05,  8.760979665493208e-08, -7.458513391180484e-10,
  6.724869995325425e-12, -6.592609916221668e-14,  8.339756097582700e-16, -1.733862043404346e-17,  5.113345043200461e-19, -1.564505889461483e-20,  4.321045140600693e-22,
 -1.026650481476378e-23,  1.014629684678896e-04, -5.177326203508184e-07,  3.963300377005437e-09, -3.377527504413924e-11,  3.073603465391591e-13, -3.194394360702929e-15,
  4.935001427591715e-17, -1.316905976603097e-18,  4.385766936320500e-20, -1.398918013958229e-21,  3.933541023485288e-23, -9.472465212215748e-25,  1.347672490861910e-06,
 -6.876776619805586e-09,  5.264942154225430e-11, -4.494572832380883e-13,  4.154648374966528e-15, -4.730955985160090e-17,  9.253005031991281e-19, -2.998709369455682e-20,
  1.075053925230002e-21, -3.526001545007763e-23,  1.009331937880072e-24, -2.477344927015505e-26,  2.465505271543415e-09, -1.258089795812933e-11,  9.634639169804842e-14,
 -8.253918794994789e-16,  7.873313508556760e-18, -1.052758592832060e-19,  2.746735180738393e-21, -1.046921655668388e-22,  3.979656455807386e-24, -1.347278006636468e-25,
  3.974266152873743e-27, -1.013003829399646e-28,  1.502345338072532e-01, -7.365233718834971e-04,  5.416143299949207e-06, -4.425251292292817e-08,  3.795393768988771e-10,
 -3.341624161683421e-12,  2.962519167858675e-14, -2.512893045576882e-16,  1.603434310876638e-18,  8.355775282459394e-21, -7.325862012369235e-22,  2.261979008886334e-23,
  7.649038388343719e-02, -3.749934372987434e-04,  2.757584636502076e-06, -2.253193058335710e-08,  1.933437543123948e-10, -1.708534087035184e-12,  1.548481371442561e-14,
 -1.467802135561014e-16,  1.570790796925244e-18, -2.179899466818647e-20,  4.068466584792217e-22, -8.686329903266867e-24,  1.918677047418926e-02, -9.406300558188466e-05,
  6.917153175944055e-07, -5.652538752942399e-09,  4.855470240800970e-11, -4.324343572300064e-13,  4.100772342997639e-15, -4.699991955268654e-17,  8.025943751292853e-19,
 -1.961199680247884e-20,  5.266424717915262e-22, -1.321861729167066e-23,  2.198613603787587e-03, -1.077869358936881e-05,  7.926479618352507e-08, -6.478515373118829e-10,
  5.574897785745831e-12, -5.030767141903540e-14,  5.123124553558107e-16, -7.385880482982148e-18,  1.725383339731121e-19, -5.048829857882826e-21,  1.448960927384680e-22,
 -3.727811826779435e-24,  9.945299595889510e-05, -4.875683183466303e-07,  3.585575324507969e-09, -2.931444747657166e-11,  2.529856822139111e-13, -2.331315181586451e-15,
  2.631655190348178e-17, -4.831313768704844e-19,  1.384577755308839e-20, -4.399839129368726e-22,  1.299700228868145e-23, -3.391409893946337e-25,  1.320975125382660e-06,
 -6.476090382194675e-09,  4.762682491771226e-11, -3.895740416061666e-13,  3.378497356734123e-15, -3.223062131494124e-17,  4.215285357305412e-19, -9.862267864770046e-21,
  3.250211730777432e-22, -1.084793451855565e-23,  3.272530115187283e-25, -8.673175560001211e-27,  2.416663328906176e-09, -1.184774490974723e-11,  8.713744098516426e-14,
 -7.134671575133183e-16,  6.248313813036708e-18, -6.371052583533122e-20,  1.045313599755417e-21, -3.139142203998447e-23,  1.152377989302736e-24, -4.009229501308696e-26,
  1.242239376549018e-27, -3.383882475233045e-29,  1.473718747702335e-01, -6.952199511238487e-04,  4.919462308889353e-06, -3.867819756224705e-08,  3.192775575269105e-10,
 -2.709138055266470e-12,  2.332170027561395e-14, -1.992553041274592e-16,  1.560467324579884e-18, -6.944141670639271e-21, -1.462779219416953e-22,  6.746830279246799e-24,
  7.503289003905615e-02, -3.539641757096612e-04,  2.504696654933713e-06, -1.969290724339774e-08,  1.625831648028503e-10, -1.381165601237234e-12,  1.197941723612279e-14,
 -1.065483442108530e-16,  1.006020722539879e-18, -1.114964148571863e-20,  1.651841113771625e-22, -3.179539733512043e-24,  1.882117412368304e-02, -8.878802261524241e-05,
  6.282769063805790e-07, -4.939907953921850e-09,  4.079628573612845e-11, -3.474367973243287e-13,  3.061644448668545e-15, -2.947571752693407e-17,  3.665864992212240e-19,
 -6.917144609582593e-21,  1.714301142987184e-22, -4.395460269681142e-24,  2.156719874484878e-03, -1.017422815876587e-05,  7.199455976047443e-08, -5.660952470613234e-10,
  4.677583306982955e-12, -4.000468426815705e-14,  3.618972087435495e-16, -3.915218639310039e-18,  6.441780704406394e-20, -1.603943954258352e-21,  4.535064157573245e-23,
 -1.218821691781583e-24,  9.755795672394771e-05, -4.602253375028796e-07,  3.256650326982928e-09, -2.560922609893770e-11,  2.117872973854468e-13, -1.823649926061010e-15,
  1.718442295807156e-17, -2.168553787386013e-19,  4.579907244463153e-21, -1.332336365473932e-22,  3.987739952894825e-24, -1.094591716766231e-25,  1.295804422194581e-06,
 -6.112902198874388e-09,  4.325656631498652e-11, -3.402019168173566e-13,  2.817504318133868e-15, -2.453866413289929e-17,  2.466883951872625e-19, -3.787616534956627e-21,
  9.919108478144633e-23, -3.180972043608584e-24,  9.853662706700989e-26, -2.750588966277437e-27,  2.370614606145422e-09, -1.118328147779481e-11,  7.913737216777032e-14,
 -6.225628195893817e-16,  5.170707737216782e-18, -4.605546339065983e-20,  5.200108573508282e-22, -1.035958890524507e-23,  3.289176445802710e-25, -1.134880630464239e-26,
  3.628366631781588e-28, -1.036802732303387e-29,  1.446668842310190e-01, -6.576378919649885e-04,  4.484280117692827e-06, -3.397460588356620e-08,  2.702681672865613e-10,
 -2.210983831539421e-12,  1.839872564289850e-14, -1.539972995881512e-16,  1.257770849158670e-18, -8.836414795719136e-21,  1.471671324111860e-23,  1.570760532681375e-24,
  7.365567160782796e-02, -3.348296420644930e-04,  2.283126160057920e-06, -1.729789518491364e-08,  1.376106348338738e-10, -1.126153216996874e-12,  9.394164249481335e-15,
 -7.972874936675515e-17,  6.968758035031700e-19, -6.602502744627541e-21,  7.638624699728672e-23, -1.194917056243423e-24,  1.847571403131000e-02, -8.398832982722258e-05,
  5.726973635354128e-07, -4.339024192402072e-09,  3.452151419175624e-11, -2.827263295715806e-13,  2.370733206469705e-15, -2.071052531196716e-17,  2.052396171478616e-19,
 -2.791369331710203e-21,  5.641254761184608e-23, -1.380712882640851e-24,  2.117133571244204e-03, -9.624229861084446e-06,  6.562549732378430e-08, -4.972164100741360e-10,
  3.956481057524039e-12, -3.244476658453259e-14,  2.744423903812608e-16, -2.511771618088779e-18,  2.946232120320999e-20, -5.422568466208272e-22,  1.378834074880637e-23,
 -3.716279518436043e-25,  9.576729332184987e-05, -4.353464071642661e-07,  2.968535143685172e-09, -2.249181891040145e-11,  1.790168780512512e-13, -1.471054699614266e-15,
  1.261757912448918e-17, -1.237949980668610e-19,  1.771294830494276e-21, -4.102330171553729e-23,  1.170121415753094e-24, -3.284101127819959e-26,  1.272020098301505e-06,
 -5.782448364825005e-09,  3.942938473658308e-11, -2.987570857848639e-13,  2.378833469007419e-15, -1.961566716911612e-17,  1.721498045142118e-19, -1.873961295447945e-21,
  3.350021844437206e-23, -9.231733778012769e-25,  2.819588044145415e-26, -8.116651736110035e-28,  2.327102261710588e-09, -1.057872509899821e-11,  7.213457937790623e-14,
 -5.466035035863686e-16,  4.355754319732047e-18, -3.616258734297050e-20,  3.316039570391679e-22, -4.278532967849724e-24,  9.872757794115603e-26, -3.131727671360962e-27,
  1.007328287717117e-28, -2.974525934024407e-30,  1.421055986150166e-01, -6.233241309448706e-04,  4.101145241143674e-06, -2.998146861336398e-08,  2.301372002833833e-10,
 -1.816896659178868e-12,  1.460386340254353e-14, -1.186272232898265e-16,  9.613928852599318e-19, -7.438881586875028e-21,  4.485091516460243e-23,  1.185472404838173e-25,
  7.235161909963785e-02, -3.173591374191202e-04,  2.088056488086725e-06, -1.526477585756697e-08,  1.171735058532560e-10, -9.251630043328863e-13,  7.441918560803762e-15,
 -6.072834970517728e-17,  5.039581939582923e-19, -4.341842427588078e-21,  4.159213238589624e-23, -5.036912778615851e-25,  1.814860681782407e-02, -7.960604481583725e-05,
  5.237660442832715e-07, -3.829009610612563e-09,  2.939248215484902e-11, -2.321250952176117e-13,  1.870213965791516e-15, -1.541046845869315e-17,  1.341935513140980e-19,
 -1.387581303566956e-21,  2.054779253385707e-23, -4.310908143208587e-25,  2.079650328371835e-03, -9.122063209934499e-06,  6.001840712188220e-08, -4.387681973587350e-10,
  3.368240929045619e-12, -2.661046708305853e-14,  2.149837557860921e-16, -1.800314291867489e-18,  1.689077859176375e-20, -2.172186912730910e-22,  4.333414752120437e-24,
 -1.092244696661822e-25,  9.407176079975848e-05, -4.126311752740453e-07,  2.714898362196646e-09, -1.984754236884211e-11,  1.523715311765785e-13, -1.204523281189194e-15,
  9.773822717093714e-18, -8.394968888214485e-20,  8.749908512164279e-22, -1.411218593432114e-23,  3.424506677086295e-25, -9.392855282572798e-27,  1.249499345360083e-06,
 -5.480735022592211e-09,  3.606040431497056e-11, -2.636257630692945e-13,  2.024105275258841e-15, -1.601696022246286e-17,  1.309118365772172e-19, -1.171219996339393e-21,
  1.411747833036127e-23, -2.845642629493293e-25,  7.893710339579732e-27, -2.274209353984541e-28,  2.285901576176967e-09, -1.002675300481066e-11,  6.597092486243484e-14,
 -4.823004499597488e-16,  3.703870700621441e-18, -2.936633945550625e-20,  2.434227014247082e-22, -2.346812352529417e-24,  3.500620582210625e-26, -8.826624172276993e-28,
  2.710273803508367e-29, -8.114358693544833e-31,  1.396757267044108e-01, -5.918941255130893e-04,  3.762320382095946e-06, -2.657200326982409e-08,  1.970521096240122e-10,
 -1.503021277301011e-12,  1.167522819475216e-14, -9.179996557292824e-17,  7.258365774068345e-19, -5.674609507972530e-21,  4.114696458059478e-23, -1.972030632454830e-25,
  7.111447454747696e-02, -3.013568695050413e-04,  1.915547156873140e-06, -1.352886867585531e-08,  1.003274180986473e-10, -7.652732797842278e-13,  5.945867666364582e-15,
 -4.681895256995459e-17,  3.731295055028805e-19, -3.029524204615807e-21,  2.582887922714618e-23, -2.517634164241829e-25,  1.783828273118412e-02, -7.559205184823098e-05,
  4.804939234326429e-07, -3.393569671703123e-09,  2.516621070243603e-11, -1.919739002870664e-13,  1.492281936103331e-15, -1.178685348552474e-17,  9.551465449134910e-20,
 -8.353240552945291e-22,  9.103952600180328e-24, -1.447143778847953e-25,  2.044090265935718e-03, -8.662099372384698e-06,  5.505984070004389e-08, -3.888698009405005e-10,
  2.883833284699073e-12, -2.200091060122344e-14,  1.711602291396430e-16, -1.358940418961751e-18,  1.131700685377367e-20, -1.103687456251080e-22,  1.554567403959645e-24,
 -3.251751100097046e-26,  9.246322225576263e-05, -3.918249771802916e-07,  2.490599761848919e-09, -1.759032402798551e-11,  1.304510343503443e-13, -9.953863042303373e-16,
  7.753878440640488e-18, -6.207241401144044e-20,  5.390254514388071e-22, -6.064156560678031e-24,  1.078908166496532e-25, -2.647355833298405e-27,  1.228134082672806e-06,
 -5.204378556750645e-09,  3.308116255988013e-11, -2.336424179790809e-13,  1.732758856261069e-15, -1.322524795096427e-17,  1.032445395838948e-19, -8.377941296866697e-22,
  7.763412132182851e-24, -1.045724006602079e-25,  2.281297465642741e-27, -6.193470387262733e-29,  2.246814810029797e-09, -9.521171252022124e-12,  6.052048122586616e-14,
 -4.274400884279207e-16,  3.170194933022076e-18, -2.420945633143949e-20,  1.897820127053661e-22, -1.580341829598985e-24,  1.638458444171163e-26, -2.791281400462488e-28,
  7.314276336636884e-30, -2.138806384006144e-31,  1.373664006317055e-01, -5.630196102743833e-04,  3.461428388216705e-06, -2.364525744765636e-08,  1.695983398930667e-10,
 -1.251213809412620e-12,  9.401453806819499e-15, -7.154215650896845e-17,  5.489368448764629e-19, -4.216323947355586e-21,  3.168031749513829e-23, -2.123697514372582e-25,
  6.993870468293681e-02, -2.866557038493118e-04,  1.762351037778378e-06, -1.203874296625907e-08,  8.634934513250135e-11, -6.370485247072473e-13,  4.787011056950587e-15,
 -3.644373959648536e-17,  2.803420131339408e-19, -2.181008021047747e-21,  1.735046476670050e-23, -1.469948512075027e-25,  1.754335380965532e-02, -7.190442628644012e-05,
  4.420663518521373e-07, -3.019786519252449e-09,  2.165982312356846e-11, -1.597996762755293e-13,  1.200959561169827e-15, -9.151557208619201e-18,  7.077936871430481e-20,
 -5.654783455340433e-22,  5.007564644551496e-24, -5.776905390692635e-26,  2.010294336846354e-03, -8.239534047281262e-06,  5.065641979245755e-08, -3.460376652981212e-10,
  2.482008734455946e-12, -1.831204771703682e-14,  1.376547288116569e-16, -1.050614753682936e-18,  8.199221646422184e-21, -6.835975266680864e-23,  7.009955390782769e-25,
 -1.068519865536938e-26,  9.093448325638012e-05, -3.727104820533810e-07,  2.291413434899288e-09, -1.565281642157866e-11,  1.122727691479875e-13, -8.283771022879355e-16,
  6.229373206249051e-18, -4.766391502825828e-20,  3.773101722261982e-22, -3.351281464674492e-24,  4.099514185052359e-26, -7.814187991991921e-28,  1.207828750154823e-06,
 -4.950492047299437e-09,  3.043548517227757e-11, -2.079071950766116e-13,  1.491264724572961e-15, -1.100376400023760e-17,  8.279885129310678e-20, -6.361669947390272e-22,
  5.153443300614130e-24, -5.026669973507278e-26,  7.520174370791075e-28, -1.708534773292224e-29,  2.209667138052715e-09, -9.056697494703536e-12,  5.568032350906947e-14,
 -3.803570878735724e-16,  2.728242184453392e-18, -2.013407953523222e-20,  1.516786085942210e-22, -1.174676073077474e-24,  9.932497706183282e-27, -1.126307340847742e-28,
  2.129589807342643e-30, -5.592189992777393e-32,  1.351679707199585e-01, -5.364188502158751e-04,  3.193178871361250e-06, -2.112026580661577e-08,  1.466778488026287e-10,
 -1.047764074962889e-12,  7.623019542889272e-15, -5.617779689382545e-17,  4.178138951946033e-19, -3.123938859276854e-21,  2.327219756510031e-23, -1.673828634483125e-25,
  6.881939647025319e-02, -2.731121975972843e-04,  1.625774521616391e-06, -1.075316853657976e-08,  7.467955055267943e-11, -5.334596916192225e-13,  3.881263173841935e-15,
 -2.860665170376312e-17,  2.129250117357947e-19, -1.598654007853319e-21,  1.214403303736077e-23, -9.483343599800256e-26,  1.726258767180783e-02, -6.850718688827173e-05,
  4.078076342420976e-07, -2.697313992624781e-09,  1.873255174080452e-11, -1.338131697535130e-13,  9.736150123225725e-16, -7.177959562603627e-18,  5.351647076611988e-20,
 -4.053576773020907e-22,  3.204401828164774e-24, -2.894514505647600e-26,  1.978121322316328e-03, -7.850244106187464e-06,  4.673071004491695e-08, -3.090854472406164e-10,
  2.146566338675877e-12, -1.533379256552854e-14,  1.115748567996421e-16, -8.229644508832345e-19,  6.152985464370096e-21, -4.729002557272274e-23,  3.977872063642983e-25,
 -4.316406216504379e-27,  8.947915584559885e-05, -3.551011800849060e-07,  2.113836224006090e-09, -1.398129989115045e-11,  9.709878961391056e-14, -6.936244438672931e-16,
  5.047613834084051e-18, -3.725807293771683e-20,  2.798077025367778e-22, -2.199928306194343e-24,  2.021510602777301e-26, -2.680940874479808e-28,  1.188498500224175e-06,
 -4.716598140304223e-09,  2.807683171902510e-11, -1.857053326931493e-13,  1.289708210233895e-15, -9.213203858427659e-18,  6.705728896177602e-20, -4.955696474450105e-22,
  3.748974399982793e-24, -3.055916026379188e-26,  3.176935494366977e-28, -5.183472604090657e-30,  2.174303334961637e-09, -8.628799336801262e-12,  5.136527280747257e-14,
 -3.397394565065319e-16,  2.359470831100877e-18, -1.685582582122128e-20,  1.227225217647791e-22, -9.090315940241099e-25,  6.972388906813923e-27, -6.064342249533804e-29,
  7.569364469177684e-31, -1.534184566388393e-32,  };
  int offset = -7;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 7;
    if (std::isnan(t)) {
      fill_n(rr+offset, 7, 0.5);
      fill_n(ww+offset, 7, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 7; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=7; ++j) {
        const int boxof = it*84+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
