/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.compress;

import java.io.IOException;
import yuku.alkitab.yes2.io.RandomAccessFileRandomInputStream;
import yuku.alkitab.yes2.io.RandomInputStream;
import yuku.bintex.ValueMap;
import yuku.snappy.codec.Snappy;

public class SnappyInputStream
extends RandomInputStream {
    public final String TAG = SnappyInputStream.class.getSimpleName();
    private final RandomAccessFileRandomInputStream input;
    private final Snappy snappy;
    private final long baseOffset;
    private final int block_size;
    private final int[] compressed_block_sizes;
    private final int[] compressed_block_offsets;
    private int current_block_index = 0;
    private int current_block_skip = 0;
    private byte[] compressed_buf;
    private int uncompressed_block_index = -1;
    private byte[] uncompressed_buf;
    private int uncompressed_len = -1;

    public SnappyInputStream(RandomAccessFileRandomInputStream input, long baseOffset, int block_size, int[] compressed_block_sizes, int[] compressed_block_offsets) throws IOException {
        this.input = input;
        this.block_size = block_size;
        this.snappy = new Snappy.Factory().newInstance();
        this.baseOffset = baseOffset;
        this.compressed_block_sizes = compressed_block_sizes;
        this.compressed_block_offsets = compressed_block_offsets;
        this.compressed_buf = new byte[this.snappy.maxCompressedLength(block_size)];
        this.uncompressed_buf = new byte[block_size];
    }

    @Override
    public void seek(long n) throws IOException {
        int offset = (int)n;
        int block_index = offset / this.block_size;
        int block_skip = offset - block_index * this.block_size;
        this.current_block_index = block_index;
        this.current_block_skip = block_skip;
        this.prepareBuffer();
    }

    private void prepareBuffer() throws IOException {
        int block_index = this.current_block_index;
        if (this.uncompressed_block_index != block_index) {
            this.input.seek(this.baseOffset + (long)this.compressed_block_offsets[block_index]);
            this.input.read(this.compressed_buf, 0, this.compressed_block_sizes[block_index]);
            this.uncompressed_len = this.snappy.decompress(this.compressed_buf, 0, this.uncompressed_buf, 0, this.compressed_block_sizes[block_index]);
            if (this.uncompressed_len < 0) {
                throw new IOException("Error in decompressing: " + this.uncompressed_len);
            }
            this.uncompressed_block_index = block_index;
        }
    }

    @Override
    public int read() throws IOException {
        int can_read;
        if (this.uncompressed_len == -1) {
            this.prepareBuffer();
        }
        if ((can_read = this.uncompressed_len - this.current_block_skip) == 0) {
            if (this.current_block_index >= this.compressed_block_sizes.length) {
                return -1;
            }
            ++this.current_block_index;
            this.current_block_skip = 0;
            this.prepareBuffer();
        }
        int res = 0xFF & this.uncompressed_buf[this.current_block_skip];
        ++this.current_block_skip;
        return res;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.uncompressed_len == -1) {
            this.prepareBuffer();
        }
        int res = 0;
        int want_read = length;
        while (want_read > 0) {
            int can_read = this.uncompressed_len - this.current_block_skip;
            if (can_read == 0) {
                if (this.current_block_index >= this.compressed_block_sizes.length) {
                    if (res == 0) {
                        return -1;
                    }
                    return res;
                }
                ++this.current_block_index;
                this.current_block_skip = 0;
                this.prepareBuffer();
                can_read = this.uncompressed_len;
            }
            int will_read = want_read > can_read ? can_read : want_read;
            System.arraycopy(this.uncompressed_buf, this.current_block_skip, buffer, offset, will_read);
            this.current_block_skip += will_read;
            offset += will_read;
            want_read -= will_read;
            res += will_read;
        }
        return res;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.current_block_index * this.block_size + this.current_block_skip;
    }

    @Override
    public long skip(long n) throws IOException {
        this.seek(this.getFilePointer() + n);
        return n;
    }

    public static SnappyInputStream getInstanceFromAttributes(RandomAccessFileRandomInputStream input, ValueMap sectionAttributes, long sectionContentOffset) throws IOException {
        int compressionVersion = sectionAttributes.getInt("compression.version", 0);
        if (compressionVersion > 1) {
            throw new IOException("Compression version " + compressionVersion + " is not supported");
        }
        ValueMap compressionInfo = sectionAttributes.getSimpleMap("compression.info");
        int block_size = compressionInfo.getInt("block_size");
        int[] compressed_block_sizes = compressionInfo.getIntArray("compressed_block_sizes");
        int[] compressed_block_offsets = new int[compressed_block_sizes.length + 1];
        int c = 0;
        int len = compressed_block_sizes.length;
        for (int i = 0; i < len; ++i) {
            compressed_block_offsets[i] = c;
            c += compressed_block_sizes[i];
        }
        compressed_block_offsets[compressed_block_sizes.length] = c;
        return new SnappyInputStream(input, sectionContentOffset, block_size, compressed_block_sizes, compressed_block_offsets);
    }
}

