/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.util;

import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import yuku.alkitabconverter.util.IntArrayList;
import yuku.bintex.BintexReader;

public class DesktopShiftTb {
    public static final String TAG = DesktopShiftTb.class.getSimpleName();
    static TIntIntHashMap tbToFkjv = new TIntIntHashMap(2048);

    public static int shiftFromTb(int ari) {
        int fkjv = tbToFkjv.get(ari);
        if (fkjv == 0) {
            return ari;
        }
        int flag = fkjv >> 24;
        if (flag != 0 && flag != 1) {
            return ari;
        }
        return fkjv & 0xFFFFFF;
    }

    public static IntArrayList shiftFromTb(IntArrayList aris) {
        if (aris == null) {
            return null;
        }
        IntArrayList res = new IntArrayList(aris.size());
        int len = aris.size();
        for (int i = 0; i < len; ++i) {
            res.add(DesktopShiftTb.shiftFromTb(aris.get(i)));
        }
        return res;
    }

    static {
        try {
            BintexReader br = new BintexReader(DesktopShiftTb.class.getResourceAsStream("shift_tb_bt.bt"));
            int n = br.readInt();
            int from = 0;
            int to = 0;
            int flag = 0;
            for (int i = 0; i < n; ++i) {
                int mode = br.readUint8();
                if (mode == 2) {
                    ++from;
                    ++to;
                    flag = 0;
                } else if (mode == 1) {
                    from = br.readInt();
                    to = br.readInt();
                    flag = br.readUint8();
                } else if (mode == 0) {
                    from += br.readUint8();
                    to += br.readUint8();
                    flag = br.readUint8();
                }
                tbToFkjv.put(from, flag << 24 | to);
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read shift_tb_bt");
        }
    }
}

