//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotSpecular/SpecularDataWidget.cpp
//! @brief     Implements class SpecularDataWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/PlotSpecular/SpecularDataWidget.h"
#include "GUI/Model/Data/SpecularDataItem.h"
#include "GUI/Support/Util/ActionFactory.h"
#include "GUI/View/PlotSpecular/SpecularDataCanvas.h"
#include "GUI/View/PlotSpecular/SpecularDataPropertyWidget.h"
#include <QBoxLayout>
#include <QMenu>

SpecularDataWidget::SpecularDataWidget(QWidget* parent)
    : DataAccessWidget(parent)
    , m_specular_canvas(new SpecularDataCanvas)
    , m_propertyWidget(new SpecularDataPropertyWidget(this))
{
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    m_propertyWidget->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::MinimumExpanding);

    auto* hlayout = new QHBoxLayout(this);
    hlayout->setContentsMargins(0, 0, 0, 0);
    hlayout->setSpacing(0);
    hlayout->addWidget(m_specular_canvas);
    hlayout->addWidget(m_propertyWidget);

    connect(m_specular_canvas, &SpecularDataCanvas::customContextMenuRequested, this,
            &SpecularDataWidget::onContextMenuRequest);

    m_togglePropertiesAction =
        ActionFactory::createTogglePropertiesPanelAction(this, m_propertyWidget);

    m_propertyWidget->setVisible(false);
}

void SpecularDataWidget::setJobOrRealItem(QObject* job_or_real_Item)
{
    DataAccessWidget::setJobOrRealItem(job_or_real_Item);
    m_specular_canvas->setJobOrRealItem(job_or_real_Item);
    m_propertyWidget->setJobOrRealItem(job_or_real_Item);
}

QList<QAction*> SpecularDataWidget::actionList()
{
    return m_specular_canvas->actionList() + QList<QAction*>{m_togglePropertiesAction};
}

void SpecularDataWidget::onContextMenuRequest(const QPoint& point)
{
    QMenu menu;
    for (auto* action : actionList())
        menu.addAction(action);
    menu.exec(point);
}
