/*
 * Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _MESSAGES_CENTER_H_
#define _MESSAGES_CENTER_H_

#include <QAbstractTableModel>
#include <QDateTime>
#include <QString>

class QImage;

class MessagesModel : public QAbstractTableModel {
  Q_OBJECT
  public:
  struct Message {
    enum Type {
      Information,
      Error
    };
    Type type;
    QDateTime date;
    QString who;
    QString what;
  };
  public:
    static MessagesModel* instance();
  public:
    void tellError( const QString& _who, const QString& _err );
    void tellInfo( const QString& _who, const QString& _info );
  signals:
    void errorReceived();
    void infoReceived();
    void messageReceived();
  public:
    // Reimplemented from qabstractitemmodel
    virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
    virtual QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
  private:
    QPixmap icon(Message::Type _type) const;
  private:
    MessagesModel();
    ~MessagesModel();
    struct Private;
    Private* const d;
};

#endif
