#ifndef RPCSOCKETMANAGER_H
#define RPCSOCKETMANAGER_H

#include <set>

#include "socket.h"

namespace rpc {

/**
	@author Rikard Bjorklind <olof@linux.nu>
*/
class SocketManager{
public:
    ~SocketManager();

	/**
	 * Add the socket to our internal set.
	 */
	void addSocket(Socket*);
	
	/**
	 * Remove the specified socket from our internal set.
	 */
	void removeSocket(Socket*);

	/**
	 * Perform a select on all the sockets that we are managing. This call
	 * blocks until something is available to read.
	 */
	void select();

	static SocketManager* instance() {if(!inst) inst=new SocketManager;return inst;}

	const std::set<Socket*>& getSockets() const { return sockets; }
	
	Socket* findSocket( int socketId );
	
private:
	/**
	 * Singleton has private ctor so that it can only be accessed by
	 * the instance method.
	 */
	SocketManager();
	
	/// One and only instance of the socketmanager
	static SocketManager* inst;
	
	/// The sockets that we are managing
	std::set<Socket*> sockets;
};

}

#define g_SocketManager SocketManager::instance()

#endif
