//
// C++ Interface: filetransfer
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FILETRANSFER_H__
#define FILETRANSFER_H__

#include "global.h"
#include "log.h"
#include <QString>

struct FileTransfer
{
    enum Type {UPLOAD=0,DOWNLOAD=1};
    Type type;
    qint64 pos;
    qint64 startpos;
    qint64 actual;
    qint64 size;
    qint64 averageSpeed;
    qint64 secondsLeft;
    qint64 bytesLeft;
    QString filename;
    QString localfilename;
    QString tth;
	QString status;
	
    int userid;

    //! This method might be quite incorrect, we have to check dc++ behaviour a little better.   
    bool operator==(const FileTransfer& ft) const {
        // quick rejection test
		logger->debug("comparing files");
		if(type==ft.type) logger->debug("type samma");
        if(type!=ft.type) return false;
        // Use TTH if available for both
        //if(!tth.isEmpty() && !ft.tth.isEmpty()) {
		//	logger->debug("tthcomp:" + QString::number(tth==ft.tth?1:0 ));;    
        //    return tth==ft.tth;
        //}
		logger->debug("userid: " + QString::number(userid) + ", " + QString::number(ft.userid) + ", " + filename + ", " + ft.filename);
        // No tth, use filename, user
        return userid==ft.userid && filename==ft.filename;
    }
    QString toString() const
    {
		return QString("Type: ") + QString::number(type) + "\nFilename: " + filename + "\nsize: " + QString::number(size) + " userid:"+QString::number(userid);
    }      
};


#endif
