// [AsmJit]
// Complete JIT Assembler for C++ Language.
//
// [License]
// Zlib - See COPYING file in this package.

// [Guard]
#ifndef _ASMJIT_CORE_H
#define _ASMJIT_CORE_H

// [Dependencies - AsmJit]
#include "core/build.h"

#include "core/assembler.h"
#include "core/assert.h"
#include "core/buffer.h"
#include "core/compiler.h"
#include "core/compilercontext.h"
#include "core/compilerfunc.h"
#include "core/compileritem.h"
#include "core/cpuinfo.h"
#include "core/defs.h"
#include "core/func.h"
#include "core/intutil.h"
#include "core/lock.h"
#include "core/logger.h"
#include "core/memorymanager.h"
#include "core/memorymarker.h"
#include "core/operand.h"
#include "core/podvector.h"
#include "core/stringbuilder.h"
#include "core/stringutil.h"
#include "core/virtualmemory.h"
#include "core/zonememory.h"

// [Guard]
#endif // _ASMJIT_CORE_H
