# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 <Marc Gariépy> <mgariepy@revolutionlinux.com> Révolution Linux
#This program is free software: you can redistribute it and/or modify it 
#under the terms of the GNU General Public License version 3  or (at your option) 
#any later version, as published by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but 
#WITHOUT ANY WARRANTY; without even the implied warranties of 
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along 
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import sys
import os
import gtk
import grp
import glob, csv


class GroupsModel(gtk.ListStore):
    (
        GROUP_NAME,
        GROUP_GID,
    ) = range(2)

    def __init__(self):
        gtk.ListStore.__init__(self, str, int)

        self.fill_model(self.get_groups())

    def add_group(self, name, gid):
        # TODO: need to validate the data.
        gr_name = []
        gr_gid = []
        for item in self.get_groups():
            gr_name.append(item.gr_name)
            gr_gid.append(item.gr_gid)

        if gid not in gr_gid and name not in gr_name:
            self.append([name, gid])
            return True
        else:
            return False

    def fill_model(self, list):
        for item in list:
            self.append([item.gr_name, item.gr_gid])

    def remove_groups(self,list):
        for item in list:
            iter_to_remove = self.iter_for_group(item.gr_name)
            if iter_to_remove:
                self.remove(iter_to_remove)

    def append_group_if_valid(self,name):
        system_groups = self.get_groups()
        for group in system_groups:
            if group.gr_name == name:
                self.append([group.gr_name, group.gr_gid])

    def get_groups(self):
        groups = grp.getgrall()
        gr_list = []
        for group in groups:
            if group.gr_gid >= 1000 and group.gr_name != "nogroup":
                gr_list.append(group)
        return gr_list
    
    def get_system_groups(self):
        groups = grp.getgrall()
        gr_list = []
        for group in groups:
            if group.gr_gid < 1000:
                gr_list.append(group)
        return gr_list

    def iter_for_group(self, name):
        # return the iter of the group or None
        iter = self.get_iter_first()
        while iter:
            if self.get_value(iter, self.GROUP_NAME) == name:
                return iter
            iter = self.iter_next(iter)
        return None

class MenusModel(gtk.ListStore):
    (
        MENU_NAME,
        MENU_PATH
    ) = range(2)

    def __init__(self):
        gtk.ListStore.__init__(self, str, str)

        self.fill_model(self.get_menus_list())

    def add_menu(self, name, path):
        self.append([name, path])
        return True

    def create_tar_gz(self,directory,destination):
        """This function create a tar.gz file of the directory"""
        import tarfile
        if os.path.exists(destination):
            # We have user confirmation to overwrite.
            os.remove(destination)
        target = tarfile.TarFile.open(destination, "w:gz")
        target.add(directory,arcname=os.path.basename("."))
        target.close()
        return True

    def fill_model(self, list):
        for item in list:
            self.append([item["name"], item["path"]])

    def get_menus_list(self):
        dir_list = []
        for path in ["/etc/edubuntu-menueditor","/usr/share/edubuntu-menueditor/menus"]:
            for dir in os.listdir(path):
                if os.path.isdir(os.path.join(path,dir)):
                    dir_list.append({"name":dir, "path":os.path.join(path,dir)})
        dir_list.sort()
        return dir_list

    def import_archive(self, name, archive_path):
        # this function will create the directory "name" in
        # /etc/edubuntu-menueditor/name then extract files from the archive.
        import tarfile
        dest = os.path.join("/etc/edubuntu-menueditor",name)
        # if the path doesn't exist, create it, else, return False.
        if not os.path.exists(dest):
            tar = tarfile.open(archive_path,"r:gz")
            os.mkdir(dest)
            tar.extractall(dest)
            tar.close()
            for root, dirs, files in os.walk(os.path.join("/etc/edubuntu-menueditor",name)):
                for dir in dirs:
                    os.chown(os.path.join(root,dir),0,0)
                for file in files:
                    os.chown(os.path.join(root,file),0,0)
            os.chmod(dest,0755)
            os.chown(dest,0,0)
            self.add_menu(name,dest)
            return True
        else:
            return False

class GroupsManagerModel(gtk.ListStore):
    (
        GROUP,
        MENU_NAME,
        MENU_PATH,
        XDG_DATA_PATH,
        XDG_CONFIG_PATH,
        FILE_PATH
    ) = range(6)

    def __init__(self,groups_model):
        gtk.ListStore.__init__(self, str, str, str, str, str, str)
        self.COMMENT_STRING="#This file is managed by ProfileManager, Do not edit by hand"
        self.groups_model = groups_model
        self.fill_model(self.file_parser())

    def file_parser(self):
        # my two row in config file will be like the following:
        # type-group-profilename     ;type       ;path                                  ;   ;group  ;COMMENT1
        # XDG_DATA-group-datadir1    ;XDG_DATA   ;/etc/profile-manager/datadir1/share/  ;   ;group  ;COMMENT1
        # XDG_CONFIG-group-datadir1  ;XDG_CONFIG ;/etc/profile-manager/datadir1/xdg/    ;   ;group  ;COMMENT1
        # i need to have :
        # 1- "name" : name
        # test = {row["names"]:{"GROUP":"group","XDG_DATA":"xdg_data_path","XDG_CONFIG":"xdg_config_path","FILE_PATH":file_path}}
        content_dict = {}
        for file in glob.glob("/etc/desktop-profiles/*.listing"):
            with open(file) as content:
                data = {}
                name = ""
                csvreader = csv.DictReader(content,delimiter=";", \
                            fieldnames=["name","type","path","priority","group","comment"])
                for row in csvreader:
                    # is it our file? if yes, parse it.
                    if row["comment"] == self.COMMENT_STRING:
                        # test the name to be consistant
                        if name == "":
                            name = row["name"].split(row["type"] + "-")[1]
                        elif name != row["name"].split(row["type"] + "-")[1]:
                            #TODO: add stuff here to control what append when the name doesn't match.
                            name = ""
                            print "name doesn't match name : %s, row : %s" % (name, row["name"].split(row["type"] + "-")[1])
                        # test the group to be consistant
                        if data.has_key("GROUP"):
                            if not data["GROUP"] == row["group"]:\
                                #TODO: add stuff here to control what appen if the groups doesn't match.
                                break
                                print "Key error, the two groups doesn't match data : %s , row : %s" % (data["GROUP"], row["group"])
                        else:
                            data["GROUP"] = row["group"]
                        # add the file path to the dict
                        if not data.has_key("FILE_PATH"):
                            data["FILE_PATH"] = file

                        data[row["type"]] = row["path"]
                if data.has_key("GROUP") and data.has_key("XDG_DATA") and \
                        data.has_key("XDG_CONFIG") and data.has_key("FILE_PATH") \
                        and name != "":
                    content_dict[name] = data
        return content_dict

    def fill_model(self, dict_data):
        for entry in dict_data:
            #if os.path.dirname(dict_data[entry]["XDG_DATA"] == os.path.dirname(dict_data[entry]["XDG_CONFIG"]:
            menu_path = os.path.dirname(dict_data[entry]["XDG_DATA"])
            menu_name = os.path.basename(menu_path)
            self.append([dict_data[entry]["GROUP"], menu_name, menu_path, \
                dict_data[entry]["XDG_DATA"],dict_data[entry]["XDG_CONFIG"],\
                dict_data[entry]["FILE_PATH"]])
            iter_to_remove = self.groups_model.iter_for_group(dict_data[entry]["GROUP"])
            if iter_to_remove:
                self.groups_model.remove(iter_to_remove)
   
    def cleanup_groups(self):
        iter = self.get_iter_first()
        while iter:
            iter_to_remove = self.groups_model.iter_for_group(self.get_value(iter, self.GROUP))
            if iter_to_remove:
                self.groups_model.remove(iter_to_remove)
            iter = self.iter_next(iter)

    def save_all_new_files(self):
        # if the file exist (self.FILE_PATH), i suppose it's right.
        # if it doesn't, create it!
        iter = self.get_iter_first()
        while iter:
            content = ""
            group = ""
            file = self.get_value(iter, self.FILE_PATH)
            if not os.path.exists(file):
                group = self.get_value(iter, self.GROUP)
                content = "XDG_DATA-"+ group + "-" +self.get_value(iter, self.MENU_NAME) + ";XDG_DATA;" + self.get_value(iter, self.XDG_DATA_PATH) + ";10;" + group + ";" + self.COMMENT_STRING + "\n"
                content += "XDG_CONFIG-" + group + "-" + self.get_value(iter, self.MENU_NAME) + ";XDG_CONFIG;" + self.get_value(iter, self.XDG_CONFIG_PATH) + ";10;" + group + ";" + self.COMMENT_STRING + "\n"
                opened_file = open(file,"w")
                opened_file.write(content)
                opened_file.close()
            iter = self.iter_next(iter)

