/*
 * mkparser.c --- Make Parser for ESE Key Daemon
 *
 * $Id: mkparser.c 63 2010-07-04 20:23:51Z kb $
 *
 * (c) 2004 Krzysztof Burghardt.
 *
 * Released under the GNU Public License.
 */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "../config.h"

int main (int argc, char *argv[])
{
    char name[128];
    int value = 0;
    char *buff = NULL;
    size_t len = 0;

    FILE *fp = fopen (argv[1], "r");

    if (!fp)
        return -1;

    printf ("/* autogenerated by mkparser - DO NOT EDIT */\n\n");
    printf ("#include \"esekey.h\"\n\n");

    printf ("char*\n");
    printf ("parse(struct input_event ev)\n");
    printf ("{\n");
    printf ("    static char *ret_val;\n\n");
    printf ("    if (ev.type == EV_KEY) {\n\n");
    printf ("        switch (ev.code) {\n\n");

    while (!feof (fp))
    {
        getline (&buff, &len, fp);
        sscanf (buff, "#define KEY_%s %i", name, &value);
        if (value)
        {
            printf ("            case %i:\n", value);
            printf ("                return \"%s\";\n", name);
            value = 0;
        }
    }

    printf ("            default:\n");
    printf ("                if (!ret_val) ret_val = malloc (12);\n");
    printf ("                sprintf(ret_val, \"KEY_%%d\", ev.code);\n");
    printf ("                return ret_val;\n");

    printf ("\n        }\n\n");
    printf ("    }\n\n");
    printf ("    return NULL;\n\n");
    printf ("}\n");
    printf ("\n");

    fclose (fp);

    return 0;

}
