/* $Id: RecordType.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 *  RecordType: one VHDL Record type.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/RecordType.hpp"
#include "frontend/ast/RecordTypeElement.hpp"

namespace ast {

RecordType::RecordType(
	std::string *id,
	std::list<RecordTypeElement*> *elems,
	Location loc
) 	: 	TypeDeclaration(id, loc, BASE_TYPE_RECORD),
		elements(elems) 
{

	universal_integer cnt = 0;
	// set parent of elements, and element counter
	for (std::list<RecordTypeElement*>::const_iterator i = 
		elems->begin(); i != elems->end(); i++, cnt++) {
		
		(*i)->parent = this;
		(*i)->offset = cnt;
	}
}


}; /* namespace ast */
