/*
 * $Id: sig_power.h,v 1.14 2012-03-06 14:46:50 siflkres Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_POWER_H_INCLUDED
#define __SIG_POWER_H_INCLUDED

#include "sig_boolean.h"
#include "sig_std_logic.h"
#include "sig_gen.h"

struct sig_power_board {
	enum sig_gen_type type;
	struct sig_std_logic *n_ps_on;
	struct sig_boolean *_plus_5Vsb;
	struct sig_boolean *pwr_ok;
	struct sig_boolean *_plus_3_3V;
	struct sig_boolean *_plus_5V;
	struct sig_boolean *_minus_5V;
	struct sig_boolean *_plus_12V;
	struct sig_boolean *_minus_12V;
	struct sig_boolean *gnd;
};

struct sig_power_board_at {
	struct sig_boolean *_plus_5V;
	struct sig_boolean *_minus_5V;
	struct sig_boolean *_plus_12V;
	struct sig_boolean *_minus_12V;
	struct sig_boolean *gnd;
};

struct sig_power_device {
	enum sig_gen_type type;
	struct sig_boolean *power_5V;
	struct sig_boolean *power_12V;
	struct sig_boolean *gnd;
};

extern struct sig_power_board *
sig_power_board_create(const char *name);
extern void
sig_power_board_destroy(struct sig_power_board *sig);

extern struct sig_power_board_at *
sig_power_board_at_create(const char *name);
extern void
sig_power_board_at_destroy(struct sig_power_board_at *sig);

extern struct sig_power_device *
sig_power_device_create(const char *name);
extern void
sig_power_device_destroy(struct sig_power_device *sig);

extern void
sig_power_board_suspend(struct sig_power_board *b, FILE *fSig);
extern void
sig_power_board_resume(struct sig_power_board *b, FILE *fSig);

extern void
sig_power_board_at_suspend(struct sig_power_board_at *b, FILE *fSig);
extern void
sig_power_board_at_resume(struct sig_power_board_at *b, FILE *fSig);

extern void
sig_power_device_suspend(struct sig_power_device *b, FILE *fSig);
extern void
sig_power_device_resume(struct sig_power_device *b, FILE *fSig);

#endif /* ! __SIG_POWER_H_INCLUDED */
