/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.TiffTools;

public class OIBReader
extends FormatReader {
    private static final String NO_POI_MSG = "Jakarta POI is required to read OIB files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noPOI = false;
    private static ReflectedUniverse r = OIBReader.createReflectedUniverse();
    private Vector nImages;
    private Vector width;
    private Vector height;
    private Vector nChannels;
    private Vector tSize;
    private Vector zSize;
    private Vector bpp;
    private Vector pixels;
    private Vector names;
    private Vector rgb;
    private String[] labels = new String[9];
    private String[] dims = new String[9];
    private String[] starts = new String[9];
    private String[] stops = new String[9];

    private static ReflectedUniverse createReflectedUniverse() {
        r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import org.apache.poi.poifs.filesystem.POIFSFileSystem");
            r.exec("import org.apache.poi.poifs.filesystem.DirectoryEntry");
            r.exec("import org.apache.poi.poifs.filesystem.DocumentEntry");
            r.exec("import org.apache.poi.poifs.filesystem.DocumentInputStream");
            r.exec("import java.util.Iterator");
        }
        catch (ReflectException exc) {
            noPOI = true;
        }
        return r;
    }

    public OIBReader() {
        super("Fluoview FV1000 OIB", "oib");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 208 && block[1] == 207 && block[2] == 17 && block[3] == 224;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        try {
            Integer ii = new Integer(no);
            String directory = (String)((Hashtable)this.pixels.get(this.series)).get(ii);
            String name = (String)((Hashtable)this.names.get(this.series)).get(ii);
            r.setVar("dirName", directory);
            r.exec("root = fs.getRoot()");
            r.exec("dir = root.getEntry(dirName)");
            r.setVar("entryName", name);
            r.exec("document = dir.getEntry(entryName)");
            r.exec("dis = new DocumentInputStream(document)");
            r.exec("numBytes = dis.available()");
            int numBytes = (Integer)r.getVar("numBytes");
            byte[] b = new byte[numBytes + 4];
            r.setVar("data", b);
            r.exec("dis.read(data)");
            RandomAccessStream stream = new RandomAccessStream(b);
            Hashtable[] ifds = TiffTools.getIFDs(stream);
            TiffTools.getSamples(ifds[0], stream, buf);
            stream.close();
            return buf;
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        String[] vars = new String[]{"dirName", "root", "dir", "document", "dis", "numBytes", "data", "fis", "fs", "iter", "isInstance", "isDocument", "entry", "documentName", "entryName"};
        for (int i = 0; i < vars.length; ++i) {
            r.setVar(vars[i], null);
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        block42: {
            if (debug) {
                this.debug("OIBReader.initFile(" + id + ")");
            }
            if (noPOI) {
                throw new FormatException(NO_POI_MSG);
            }
            super.initFile(id);
            this.width = new Vector();
            this.height = new Vector();
            this.nChannels = new Vector();
            this.zSize = new Vector();
            this.tSize = new Vector();
            this.pixels = new Vector();
            this.names = new Vector();
            this.nImages = new Vector();
            this.bpp = new Vector();
            this.bpp.add(new Integer(0));
            this.rgb = new Vector();
            try {
                int i;
                this.in = new RandomAccessStream(id);
                if (this.in.length() % 4096L != 0L) {
                    this.in.setExtend(4096 - (int)(this.in.length() % 4096L));
                }
                r.setVar("fis", this.in);
                r.exec("fs = new POIFSFileSystem(fis)");
                r.exec("dir = fs.getRoot()");
                this.parseDir(0, r.getVar("dir"));
                int numSeries = this.width.size();
                this.status("Sorting images");
                for (i = 0; i < numSeries; ++i) {
                    Vector<String> newKeys = new Vector<String>();
                    Vector<Integer> comps = new Vector<Integer>();
                    Enumeration keys = ((Hashtable)this.names.get(i)).keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        String value = (String)((Hashtable)this.names.get(i)).get(key);
                        int comp = Integer.parseInt(value.substring(value.indexOf("0")));
                        int size = newKeys.size();
                        for (int j = 0; j < size; ++j) {
                            if (comp < (Integer)comps.get(j)) {
                                newKeys.add(j, value);
                                comps.add(j, new Integer(comp));
                                j = size;
                                continue;
                            }
                            if (j != size - 1) continue;
                            newKeys.add(value);
                            comps.add(new Integer(comp));
                            j = size;
                        }
                        if (newKeys.size() != 0) continue;
                        newKeys.add(value);
                        comps.add(new Integer(comp));
                    }
                    Hashtable newNames = new Hashtable();
                    for (int j = 0; j < newKeys.size(); ++j) {
                        newNames.put(new Integer(j), newKeys.get(j));
                    }
                    this.names.setElementAt(newNames, i);
                }
                this.status("Populating metadata");
                for (i = 0; i < this.labels.length; ++i) {
                    if (this.labels[i] == null) {
                        this.labels[i] = "";
                    }
                    if (this.dims[i] == null) {
                        this.dims[i] = "0";
                    }
                    if (this.starts[i] == null) {
                        this.starts[i] = "0";
                    }
                    if (this.stops[i] != null) continue;
                    this.stops[i] = "0";
                }
                for (i = 0; i < this.labels.length; ++i) {
                    if (this.labels[i].equals("\"X\"") || this.labels[i].equals("\"Y\"")) continue;
                    if (this.labels[i].equals("\"C\"")) {
                        if (!this.starts[i].equals(this.stops[i])) {
                            this.nChannels.add(new Integer(this.dims[i]));
                            continue;
                        }
                        this.nChannels.add(new Integer(1));
                        continue;
                    }
                    if (this.labels[i].equals("\"Z\"")) {
                        if (!this.starts[i].equals(this.stops[i])) {
                            this.zSize.add(new Integer(this.dims[i]));
                            continue;
                        }
                        this.zSize.add(new Integer(1));
                        continue;
                    }
                    if (this.labels[i].equals("\"T\"")) {
                        if (!this.starts[i].equals(this.stops[i])) {
                            this.tSize.add(new Integer(this.dims[i]));
                            continue;
                        }
                        this.tSize.add(new Integer(1));
                        continue;
                    }
                    if (this.dims[i].equals("0")) continue;
                    if (this.nChannels.size() > 0) {
                        int ch = (Integer)this.nChannels.get(this.nChannels.size() - 1);
                        this.nChannels.setElementAt(new Integer(ch *= Integer.parseInt(this.dims[i])), this.nChannels.size() - 1);
                        continue;
                    }
                    this.nChannels.add(new Integer(this.dims[i]));
                }
                this.core = new CoreMetadata(numSeries);
                for (i = 0; i < numSeries; ++i) {
                    this.core.indexed[i] = false;
                    this.core.falseColor[i] = false;
                    this.core.sizeX[i] = (Integer)this.width.get(i);
                    this.core.sizeY[i] = (Integer)this.height.get(i);
                    this.core.sizeZ[i] = i < this.zSize.size() ? (Integer)this.zSize.get(i) : 1;
                    this.core.sizeC[i] = i < this.nChannels.size() ? (Integer)this.nChannels.get(i) : 1;
                    this.core.sizeT[i] = i < this.tSize.size() ? (Integer)this.tSize.get(i) : 1;
                    if (this.core.sizeZ[i] == 0) {
                        int n = i;
                        this.core.sizeZ[n] = this.core.sizeZ[n] + 1;
                    }
                    if (this.core.sizeT[i] == 0) {
                        int n = i;
                        this.core.sizeT[n] = this.core.sizeT[n] + 1;
                    }
                    this.core.currentOrder[i] = this.core.sizeZ[i] > this.core.sizeT[i] ? "XYCZT" : "XYCTZ";
                    this.core.imageCount[i] = (Integer)this.nImages.get(i);
                    if (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i]) {
                        int diff = this.core.imageCount[i] - this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i];
                        if (diff % this.core.sizeZ[i] == 0 && this.core.sizeZ[i] > 1) {
                            while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i]) {
                                int n = i;
                                this.core.sizeT[n] = this.core.sizeT[n] + 1;
                            }
                        } else if (diff % this.core.sizeT[i] == 0 && this.core.sizeT[i] > 1) {
                            while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i]) {
                                int n = i;
                                this.core.sizeZ[n] = this.core.sizeZ[n] + 1;
                            }
                        } else if (diff % this.core.sizeC[i] == 0) {
                            if (this.core.sizeZ[i] > this.core.sizeT[i]) {
                                while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeC[i] * this.core.sizeT[i]) {
                                    int n = i;
                                    this.core.sizeZ[n] = this.core.sizeZ[n] + 1;
                                }
                            } else {
                                while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeC[i] * this.core.sizeT[i]) {
                                    int n = i;
                                    this.core.sizeT[n] = this.core.sizeT[n] + 1;
                                }
                            }
                        }
                    }
                    int oldSeries = this.getSeries();
                    this.setSeries(i);
                    while (this.core.imageCount[i] < this.core.sizeZ[i] * this.core.sizeT[i] * this.getEffectiveSizeC()) {
                        int n = i;
                        this.core.imageCount[n] = this.core.imageCount[n] + 1;
                    }
                    this.nImages.setElementAt(new Integer(this.core.imageCount[i]), i);
                    this.setSeries(oldSeries);
                    this.core.rgb[i] = (Boolean)this.rgb.get(i);
                    this.core.interleaved[i] = false;
                    this.core.metadataComplete[i] = true;
                }
                Integer ii = new Integer(0);
                String directory = (String)((Hashtable)this.pixels.get(this.series)).get(ii);
                String name = (String)((Hashtable)this.names.get(this.series)).get(ii);
                r.setVar("dirName", directory);
                r.exec("root = fs.getRoot()");
                r.exec("dir = root.getEntry(dirName)");
                r.setVar("entryName", name);
                r.exec("document = dir.getEntry(entryName)");
                r.exec("dis = new DocumentInputStream(document)");
                r.exec("numBytes = dis.available()");
                int numBytes = (Integer)r.getVar("numBytes");
                byte[] b = new byte[numBytes + 4];
                r.setVar("data", b);
                r.exec("dis.read(data)");
                RandomAccessStream stream = new RandomAccessStream(b);
                Hashtable[] ifds = TiffTools.getIFDs(stream);
                Arrays.fill(this.core.littleEndian, !TiffTools.isLittleEndian(ifds[0]));
            }
            catch (ReflectException e) {
                throw new FormatException(e);
            }
            try {
                this.initMetadata();
            }
            catch (FormatException exc) {
                if (debug) {
                    this.trace(exc);
                }
            }
            catch (IOException exc) {
                if (!debug) break block42;
                this.trace(exc);
            }
        }
    }

    private void initMetadata() throws FormatException, IOException {
        block3: for (int i = 0; i < this.width.size(); ++i) {
            switch ((Integer)this.bpp.get(0) % 3) {
                case 2: {
                    this.core.pixelType[i] = 3;
                    continue block3;
                }
                default: {
                    this.core.pixelType[i] = 1;
                }
            }
        }
        MetadataStore store = this.getMetadataStore();
        String name = (String)this.getMeta("[File Info] - DataName");
        if (name == null) {
            name = this.currentId;
        }
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.width.size(); ++i) {
            String acquisition = "[Acquisition Parameters Common] - ";
            String stamp = (String)this.getMeta(acquisition + "ImageCaputreDate");
            if (stamp != null) {
                stamp = stamp.substring(1, stamp.length() - 1);
                SimpleDateFormat parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = parse.parse(stamp, new ParsePosition(0));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                stamp = fmt.format(date);
            }
            store.setImage(name, stamp, null, new Integer(i));
            String pre = "[Reference Image Parameter] - ";
            String x = (String)this.getMeta(pre + "WidthConvertValue");
            String y = (String)this.getMeta(pre + "HeightConvertValue");
            store.setDimensions(x == null ? null : new Float(x), y == null ? null : new Float(y), null, null, null, new Integer(i));
            for (int j = 0; j < this.core.sizeC[i]; ++j) {
                String prefix = "[Channel " + (j + 1) + " Parameters] - ";
                String gain = (String)this.getMeta(prefix + "AnalogPMTGain");
                String offset = (String)this.getMeta(prefix + "AnalogPMTOffset");
                String voltage = (String)this.getMeta(prefix + "AnalogPMTVoltage");
                if (gain != null) {
                    gain = gain.replaceAll("\"", "");
                }
                if (offset != null) {
                    offset = offset.replaceAll("\"", "");
                }
                if (voltage != null) {
                    voltage = voltage.replaceAll("\"", "");
                }
                store.setDetector(null, null, null, null, null, voltage == null ? null : new Float(voltage), null, null, new Integer(j));
                store.setLogicalChannel(j, null, null, null, null, null, null, null, null, offset == null ? null : new Float(offset), gain == null ? null : new Float(gain), null, null, null, null, null, null, null, null, null, null, null, null, null, new Integer(i));
            }
            String laserCount = (String)this.getMeta(acquisition + "Number of use Laser");
            int numLasers = laserCount == null ? 0 : Integer.parseInt(laserCount);
            for (int j = 0; j < numLasers; ++j) {
                String wave = (String)this.getMeta(acquisition + "LaserWavelength0" + (j + 1));
                if (wave == null) {
                    wave = "0";
                }
                store.setLaser(null, null, new Integer(wave), null, null, null, null, null, null, null, new Integer(j));
            }
        }
    }

    protected void parseDir(int depth, Object dir) throws IOException, FormatException, ReflectException {
        r.setVar("dir", dir);
        r.exec("dirName = dir.getName()");
        r.setVar("depth", depth);
        r.exec("iter = dir.getEntries()");
        Iterator iter = (Iterator)r.getVar("iter");
        while (iter.hasNext()) {
            r.setVar("entry", iter.next());
            r.exec("isInstance = entry.isDirectoryEntry()");
            r.exec("isDocument = entry.isDocumentEntry()");
            boolean isInstance = (Boolean)r.getVar("isInstance");
            boolean isDocument = (Boolean)r.getVar("isDocument");
            r.setVar("dir", dir);
            r.exec("dirName = dir.getName()");
            if (isInstance) {
                this.status("Parsing embedded folder (" + (depth + 1) + ")");
                this.parseDir(depth + 1, r.getVar("entry"));
                continue;
            }
            if (!isDocument) continue;
            this.status("Parsing embedded file (" + depth + ")");
            r.exec("entryName = entry.getName()");
            if (debug) {
                this.print(depth + 1, "Found document: " + r.getVar("entryName"));
            }
            r.exec("dis = new DocumentInputStream(entry)");
            r.exec("numBytes = dis.available()");
            int numbytes = (Integer)r.getVar("numBytes");
            byte[] data = new byte[numbytes + 4];
            r.setVar("data", data);
            r.exec("dis.read(data)");
            String entryName = (String)r.getVar("entryName");
            String dirName = (String)r.getVar("dirName");
            byte[] b = new byte[]{data[0], data[1], data[2], data[3]};
            if (data[0] != 66 || data[1] != 77) {
                if (TiffTools.checkHeader(b) != null) {
                    boolean isRGB;
                    RandomAccessStream ras = new RandomAccessStream(data);
                    Hashtable ifd = TiffTools.getIFDs(ras)[0];
                    ras.close();
                    int w = (int)TiffTools.getImageWidth(ifd);
                    int h = (int)TiffTools.getImageLength(ifd);
                    boolean bl = isRGB = TiffTools.getSamplesPerPixel(ifd) > 1;
                    if (!isRGB) {
                        int p = TiffTools.getPhotometricInterpretation(ifd);
                        isRGB = p == 3 || p == -32733 || p == 2;
                    }
                    boolean added = false;
                    for (int i = 0; i < this.width.size(); ++i) {
                        if ((Integer)this.width.get(i) != w || (Integer)this.height.get(i) != h) continue;
                        int num = (Integer)this.nImages.get(i);
                        ((Hashtable)this.pixels.get(i)).put(new Integer(num), dirName);
                        ((Hashtable)this.names.get(i)).put(new Integer(num), entryName);
                        this.nImages.setElementAt(new Integer(++num), i);
                        added = true;
                    }
                    if (!added) {
                        Hashtable<Integer, String> ht = new Hashtable<Integer, String>();
                        ht.put(new Integer(0), dirName);
                        this.pixels.add(ht);
                        ht = new Hashtable();
                        ht.put(new Integer(0), entryName);
                        this.names.add(ht);
                        this.nImages.add(new Integer(1));
                        this.width.add(new Integer(w));
                        this.height.add(new Integer(h));
                        this.rgb.add(new Boolean(isRGB));
                    }
                } else if (!entryName.equals("OibInfo.txt")) {
                    String ini = DataTools.stripString(new String(data));
                    StringTokenizer st = new StringTokenizer(ini, "\n");
                    String prefix = "";
                    while (st.hasMoreTokens()) {
                        String line = st.nextToken().trim();
                        if (!line.startsWith("[") && line.indexOf("=") > 0) {
                            String key = line.substring(0, line.indexOf("=")).trim();
                            String value = line.substring(line.indexOf("=") + 1).trim();
                            if (prefix.equals("[FileInformation] - ") && key.equals("Resolution")) {
                                int max = Integer.parseInt(value);
                                int bytes = (Integer)this.bpp.get(0);
                                while (Math.pow(2.0, bytes) < (double)max) {
                                    ++bytes;
                                }
                                bytes /= 8;
                                for (int i = 0; i < this.bpp.size(); ++i) {
                                    this.bpp.setElementAt(new Integer(bytes), i);
                                }
                            }
                            if (prefix.indexOf("Red") != -1 || prefix.indexOf("Green") != -1 || prefix.indexOf("Blue") != -1) continue;
                            this.addMeta(prefix + key, value);
                            if (!prefix.startsWith("[Axis ") || !prefix.endsWith("Parameters Common] - ")) continue;
                            int ndx = Integer.parseInt(prefix.substring(6, prefix.indexOf("P")).trim());
                            if (key.equals("AxisCode")) {
                                this.labels[ndx] = value;
                                continue;
                            }
                            if (key.equals("MaxSize")) {
                                this.dims[ndx] = value;
                                continue;
                            }
                            if (key.equals("StartPosition")) {
                                this.starts[ndx] = value;
                                continue;
                            }
                            if (!key.equals("EndPosition")) continue;
                            this.stops[ndx] = value;
                            continue;
                        }
                        if (line.indexOf("[") == 2) {
                            line = line.substring(2, line.length());
                        }
                        prefix = line + " - ";
                    }
                    data = null;
                }
            }
            r.exec("dis.close()");
        }
    }

    protected void print(int depth, String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(s);
        this.debug(sb.toString());
    }
}

