/**
 * JNA-InChI - Library for calling InChI from Java
 * Copyright © 2018 Daniel Lowe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.github.dan2097.jnainchi.inchi;
import java.util.Arrays;
import java.util.List;

import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
/**
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class tagINCHIStereo0D extends Structure implements ByReference {
  /**
   * 4 atoms always<br>
   * C type : AT_NUM[4]
   */
  public short[] neighbor = new short[4];
  /**
   * central tetrahedral atom or a central<br>
   * C type : AT_NUM
   */
  public short central_atom;
  /**
   * inchi_StereoType0D<br>
   * C type : S_CHAR
   */
  public byte type;
  /**
   * inchi_StereoParity0D: may be a combination of two parities:<br>
   * C type : S_CHAR
   */
  public byte parity;

  protected List<String> getFieldOrder() {
    return Arrays.asList("neighbor", "central_atom", "type", "parity");
  }
  
  public tagINCHIStereo0D() {
    super();
  }
  
  /**
   * @param neighbor 4 atoms always<br>
   * C type : AT_NUM[4]<br>
   * @param central_atom central tetrahedral atom or a central<br>
   * C type : AT_NUM<br>
   * @param type inchi_StereoType0D<br>
   * C type : S_CHAR<br>
   * @param parity inchi_StereoParity0D: may be a combination of two parities:<br>
   * C type : S_CHAR
   */
  public tagINCHIStereo0D(short neighbor[], short central_atom, byte type, byte parity) {
    super();
    if ((neighbor.length != this.neighbor.length)) 
      throw new IllegalArgumentException("Wrong array size !");
    this.neighbor = neighbor;
    this.central_atom = central_atom;
    this.type = type;
    this.parity = parity;
  }

}
