/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef HEADER_SERVERMAINWINDOW
#define HEADER_SERVERMAINWINDOW

#include <QMainWindow>
#include <QObject>
#include <QToolButton>
#include <QToolBar>
#include <QSystemTrayIcon>
#include <QStatusBar>
#include <QMenu>
#include <QSettings>
#include <QMessageBox>
#include <QAction>
#include <QProgressBar>
#include <QDesktopWidget>
#include <QApplication>
#include <QSystemTrayIcon>
#include "../../commons/startup/update_manager.h"
#include "../../commons/startup/user_mode.h"
#include "../../commons/win32/qtwin.h"
#include "server_central_window.h"
#include "../../commons/constants.h"
#include "../../commons/about_dialog.h"

class ServerMainWindow : public QMainWindow
{
    Q_OBJECT

public: 
    ServerMainWindow(QWidget *parent = 0);
    void centerOnScreen();
    ServerCentralWindow *centralWindow;
    void createActions();
    void createTrayIcon();

private:
    QSystemTrayIcon *trayIcon;
    QMenu *trayIconMenu;
    QAction *minimizeAction;
    QAction *maximizeAction;
    QAction *restoreAction;
    QAction *switchModeAction;
    QAction *quitAction;
    QAction *aboutAction;
    QAction *updateAction;
    QStatusBar *toolBar;
    AboutDialog *aboutDialog;

public slots:
    void switchMode();
    void displayUpdateManager();
    void iconActivated(QSystemTrayIcon::ActivationReason reason);
    void displayAbout();
    void showMessage(QString title, QString content, int duration);
    void switchUserMode();

protected:
    void closeEvent(QCloseEvent *event);
};


#endif
