#include "launcher.h"
#include <vector>
#include <string>
#include <fstream>
#include <dirent.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include <wait.h>

#include "logger.h"
using namespace std;

Launcher::Launcher(AppletWindowParams params):Applet(params), margin_side(0), margin_top(0), margin_bottom(0), app_width(200), app_height(200){
}

static bool FileList(const std::string& path, const std::string& ext, vector<string>& files){
    DIR *dir = opendir(path.c_str());
    if (!dir)
	return false;
    struct dirent *entry;
    vector<string> ret;
    while (entry = readdir(dir)){
	string file(entry->d_name);
	if (ext.size() < file.size() && file.substr(file.size()-ext.size()) == ext)
	    files.push_back(file); 
    }     
    closedir(dir);
    return true;
}

void Launcher::LoadApps(const std::string& apps_path, const std::string& icons_path){
    vector<string> files;
    if (!FileList(apps_path, ".desktop", files))
	LOG(FATAL) << "Cannot open directory: " << apps_path;

    apps.clear();
    for (int i=0; i<files.size(); ++i){
	App app;
	if (!LoadDesktopFile(apps_path + "/" + files[i], app))
	    LOG(FATAL) << "Cannot load desktop file: " << apps_path + "/" + files[i];
	app.icon = icons_path + "/" + app.icon;
	if (app.icon.size() < 4 || app.icon[app.icon.size()-4] !='.')
	    app.icon += ".png";
	apps.push_back(app);
    }
    DrawApps();
}
void Launcher::DrawApps(){
    int num_columns = (win.Width() - 2*margin_side) / app_width;
    for (int i=0; i<apps.size(); ++i){
	int x = margin_side + (i%num_columns) * app_width,
	    y = margin_top + (i/num_columns) * app_height;
	int icon_width, icon_height;
	win.AddImage(x, y, apps[i].icon, &icon_width, &icon_height, MyWindow::CENTER);
	//win.AddText(x + icon_width/2, y + icon_height+3, apps[i].name, MyWindow::TOP_CENTER);
    }
}

static void trim(string& s){
    int trim = 0;
    while (s[trim] == ' ') ++trim;
    s = s.substr(trim);
    trim = s.size() -1;
    while (s[trim] == ' ') --trim;
    s = s.substr(0, trim+1);
    for (int i=0; i<s.size(); ++i)
	s[i] = tolower(s[i]);
}

bool Launcher::LoadDesktopFile(const std::string& path, App& app){
    ifstream in(path.c_str());
    app.name = app.icon = app.exec = "";
    while (in.good()){
	char buf[256];
	in.getline(buf, 256);
	string line(buf);
	if (line.find('=') == string::npos)
	    continue;
	string var = line.substr(0, line.find('='));
	string val = line.substr(line.find('=')+1);
	trim(var);
	trim(val);
	if (var == "name")
	    app.name = val;
	else if (var == "icon")
	    app.icon = val;
	else if (var == "exec")
	    app.exec = val;
    }
    return !app.name.empty() && !app.icon.empty() && !app.exec.empty();
}

static bool ExecCommand(const string& s){
    switch (fork()){
	case -1: return false;
	case 0:  execlp("/bin/sh","/bin/sh","-c",s.c_str(),(char *)NULL);
		 return false;
	default: break;
    }
    
    return true;

}
AppAction Launcher::OnMousePress(int x, int y){
    x-=margin_side;
    y-=margin_top;
    x/=app_width;
    y/=app_height; 
    int num_columns = (win.Width() - 2*margin_side) / app_width;
    ExecCommand(apps[y*num_columns + x].exec);
    return "";
}
void Launcher::OnRotate(Rotation rot){
    win.Clear();
    DrawApps();
}

void Launcher::SetAppWidth(int w){
    app_width = w;
}
void Launcher::SetAppHeight(int h){
    app_height = h;
}
void Launcher::SetMarginTop(int x){
    margin_top = x;
}
void Launcher::SetMarginBottom(int x){
    margin_bottom = x;
}
void Launcher::SetMarginSide(int x){
    margin_side = x;
}


