// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --check-globals --global-value-regex ".offload_maptypes.*" ".offload_sizes.*" --global-hex-value-regex ".offload_maptypes.*"
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

// powerpc64le-ibm-linux-gnu

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-PPC64LE
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t \
// RUN:     -verify %s -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-PPC64LE

// i386-pc-linux-gnu

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-I386
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple i386-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -std=c++11 -include-pch %t -verify %s \
// RUN:     -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-I386

struct S1 {
  int i;
};
struct S2 {
  S1 s;
  struct S2 *ps;
};

// Map flags used in @.offload_maptypes* below:
//
//   TO          = 0x1
//   FROM        = 0x2
//   ALWAYS      = 0x4
//   PTR_AND_OBJ = 0x10
//   CLOSE       = 0x400
//   OMPX_HOLD   = 0x2000
//   MEMBER_OF_1 = 0x1000000000000
//   MEMBER_OF_7 = 0x7000000000000

//.
// CHECK-PPC64LE: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-PPC64LE: @.offload_maptypes = private unnamed_addr constant [1 x i64] [i64 [[#0x2001]]]
// CHECK-PPC64LE: @.offload_sizes.1 = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-PPC64LE: @.offload_maptypes.2 = private unnamed_addr constant [1 x i64] [i64 [[#0x2405]]]
// CHECK-PPC64LE: @.offload_sizes.3 = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-PPC64LE: @.offload_maptypes.4 = private unnamed_addr constant [1 x i64] [i64 [[#0x2003]]]
// CHECK-PPC64LE: @.offload_maptypes.5 = private unnamed_addr constant [11 x i64] [i64 [[#0x2000]], i64 [[#0x1000000002003]], i64 [[#0x1000000002010]], i64 [[#0x2010]], i64 [[#0x2013]], i64 [[#0x3]], i64 [[#0x2000]], i64 [[#0x7000000002003]], i64 [[#0x7000000002010]], i64 [[#0x2010]], i64 [[#0x2013]]]
//.
// CHECK-I386: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-I386: @.offload_maptypes = private unnamed_addr constant [1 x i64] [i64 [[#0x2001]]]
// CHECK-I386: @.offload_sizes.1 = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-I386: @.offload_maptypes.2 = private unnamed_addr constant [1 x i64] [i64 [[#0x2405]]]
// CHECK-I386: @.offload_sizes.3 = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-I386: @.offload_maptypes.4 = private unnamed_addr constant [1 x i64] [i64 [[#0x2003]]]
// CHECK-I386: @.offload_maptypes.5 = private unnamed_addr constant [11 x i64] [i64 [[#0x2000]], i64 [[#0x1000000002003]], i64 [[#0x1000000002010]], i64 [[#0x2010]], i64 [[#0x2013]], i64 [[#0x3]], i64 [[#0x2000]], i64 [[#0x7000000002003]], i64 [[#0x7000000002010]], i64 [[#0x2010]], i64 [[#0x2013]]]
//.
// CHECK-PPC64LE-LABEL: @_Z3fooi(
// CHECK-PPC64LE-NEXT:  entry:
// CHECK-PPC64LE-NEXT:    [[ARG_ADDR:%.*]] = alloca i32, align 4
// CHECK-PPC64LE-NEXT:    [[LB:%.*]] = alloca [5 x float], align 4
// CHECK-PPC64LE-NEXT:    [[PS1:%.*]] = alloca %struct.S2*, align 8
// CHECK-PPC64LE-NEXT:    [[PS2:%.*]] = alloca %struct.S2*, align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS1:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS2:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS3:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [1 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS29:%.*]] = alloca [11 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS30:%.*]] = alloca [11 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS31:%.*]] = alloca [11 x i8*], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [11 x i64], align 8
// CHECK-PPC64LE-NEXT:    store i32 [[ARG:%.*]], i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP1:%.*]] = bitcast i8** [[TMP0]] to [5 x float]**
// CHECK-PPC64LE-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP1]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to [5 x float]**
// CHECK-PPC64LE-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP3]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP4]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1:[0-9]+]], i64 -1, i32 1, i8** [[TMP5]], i8** [[TMP6]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC]], i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP8]], i8** [[TMP9]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to [5 x float]**
// CHECK-PPC64LE-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP11]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to [5 x float]**
// CHECK-PPC64LE-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP13]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS3]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP15]], i8** [[TMP16]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.1, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP17:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC4:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC4]], i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP18]], i8** [[TMP19]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.1, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK-PPC64LE-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP21]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32**
// CHECK-PPC64LE-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP23]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.3, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP27:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC8:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC8]], i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP28]], i8** [[TMP29]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.3, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP30:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP31:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[S:%.*]] = getelementptr inbounds [[STRUCT_S2:%.*]], %struct.S2* [[TMP31]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP32:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP33:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP33]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP34:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS9:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP34]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP35:%.*]] = load %struct.S2*, %struct.S2** [[PS9]], align 8
// CHECK-PPC64LE-NEXT:    [[PS10:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP35]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP36:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS11:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP36]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP37:%.*]] = load %struct.S2*, %struct.S2** [[PS11]], align 8
// CHECK-PPC64LE-NEXT:    [[PS12:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP37]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP38:%.*]] = load %struct.S2*, %struct.S2** [[PS12]], align 8
// CHECK-PPC64LE-NEXT:    [[PS13:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP38]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP39:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS14:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP39]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP40:%.*]] = load %struct.S2*, %struct.S2** [[PS14]], align 8
// CHECK-PPC64LE-NEXT:    [[PS15:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP40]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP41:%.*]] = load %struct.S2*, %struct.S2** [[PS15]], align 8
// CHECK-PPC64LE-NEXT:    [[PS16:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP41]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP42:%.*]] = load %struct.S2*, %struct.S2** [[PS16]], align 8
// CHECK-PPC64LE-NEXT:    [[S17:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP42]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP43:%.*]] = getelementptr %struct.S2*, %struct.S2** [[PS]], i32 1
// CHECK-PPC64LE-NEXT:    [[TMP44:%.*]] = bitcast %struct.S1* [[S]] to i8*
// CHECK-PPC64LE-NEXT:    [[TMP45:%.*]] = bitcast %struct.S2** [[TMP43]] to i8*
// CHECK-PPC64LE-NEXT:    [[TMP46:%.*]] = ptrtoint i8* [[TMP45]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP47:%.*]] = ptrtoint i8* [[TMP44]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP48:%.*]] = sub i64 [[TMP46]], [[TMP47]]
// CHECK-PPC64LE-NEXT:    [[TMP49:%.*]] = sdiv exact i64 [[TMP48]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-PPC64LE-NEXT:    [[TMP50:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP51:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[S18:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP51]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP52:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP53:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS19:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP53]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP54:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS20:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP54]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP55:%.*]] = load %struct.S2*, %struct.S2** [[PS20]], align 8
// CHECK-PPC64LE-NEXT:    [[PS21:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP55]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP56:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS22:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP56]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP57:%.*]] = load %struct.S2*, %struct.S2** [[PS22]], align 8
// CHECK-PPC64LE-NEXT:    [[PS23:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP57]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP58:%.*]] = load %struct.S2*, %struct.S2** [[PS23]], align 8
// CHECK-PPC64LE-NEXT:    [[PS24:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP58]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP59:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS25:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP59]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP60:%.*]] = load %struct.S2*, %struct.S2** [[PS25]], align 8
// CHECK-PPC64LE-NEXT:    [[PS26:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP60]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP61:%.*]] = load %struct.S2*, %struct.S2** [[PS26]], align 8
// CHECK-PPC64LE-NEXT:    [[PS27:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP61]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP62:%.*]] = load %struct.S2*, %struct.S2** [[PS27]], align 8
// CHECK-PPC64LE-NEXT:    [[S28:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP62]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP63:%.*]] = getelementptr %struct.S2*, %struct.S2** [[PS19]], i32 1
// CHECK-PPC64LE-NEXT:    [[TMP64:%.*]] = bitcast %struct.S1* [[S18]] to i8*
// CHECK-PPC64LE-NEXT:    [[TMP65:%.*]] = bitcast %struct.S2** [[TMP63]] to i8*
// CHECK-PPC64LE-NEXT:    [[TMP66:%.*]] = ptrtoint i8* [[TMP65]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP67:%.*]] = ptrtoint i8* [[TMP64]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP68:%.*]] = sub i64 [[TMP66]], [[TMP67]]
// CHECK-PPC64LE-NEXT:    [[TMP69:%.*]] = sdiv exact i64 [[TMP68]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-PPC64LE-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP71:%.*]] = bitcast i8** [[TMP70]] to %struct.S2**
// CHECK-PPC64LE-NEXT:    store %struct.S2* [[TMP30]], %struct.S2** [[TMP71]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP73:%.*]] = bitcast i8** [[TMP72]] to %struct.S1**
// CHECK-PPC64LE-NEXT:    store %struct.S1* [[S]], %struct.S1** [[TMP73]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP74:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store i64 [[TMP49]], i64* [[TMP74]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP75]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP77:%.*]] = bitcast i8** [[TMP76]] to %struct.S2**
// CHECK-PPC64LE-NEXT:    store %struct.S2* [[TMP30]], %struct.S2** [[TMP77]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to %struct.S1**
// CHECK-PPC64LE-NEXT:    store %struct.S1* [[S]], %struct.S1** [[TMP79]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    store i64 4, i64* [[TMP80]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP81:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 1
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP81]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 2
// CHECK-PPC64LE-NEXT:    [[TMP83:%.*]] = bitcast i8** [[TMP82]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS]], %struct.S2*** [[TMP83]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 2
// CHECK-PPC64LE-NEXT:    [[TMP85:%.*]] = bitcast i8** [[TMP84]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS10]], %struct.S2*** [[TMP85]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-PPC64LE-NEXT:    store i64 8, i64* [[TMP86]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 2
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP87]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 3
// CHECK-PPC64LE-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS10]], %struct.S2*** [[TMP89]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 3
// CHECK-PPC64LE-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS13]], %struct.S2*** [[TMP91]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK-PPC64LE-NEXT:    store i64 8, i64* [[TMP92]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 3
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP93]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 4
// CHECK-PPC64LE-NEXT:    [[TMP95:%.*]] = bitcast i8** [[TMP94]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS13]], %struct.S2*** [[TMP95]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 4
// CHECK-PPC64LE-NEXT:    [[TMP97:%.*]] = bitcast i8** [[TMP96]] to %struct.S1**
// CHECK-PPC64LE-NEXT:    store %struct.S1* [[S17]], %struct.S1** [[TMP97]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-PPC64LE-NEXT:    store i64 4, i64* [[TMP98]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 4
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP99]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 5
// CHECK-PPC64LE-NEXT:    [[TMP101:%.*]] = bitcast i8** [[TMP100]] to i32**
// CHECK-PPC64LE-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP101]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 5
// CHECK-PPC64LE-NEXT:    [[TMP103:%.*]] = bitcast i8** [[TMP102]] to i32**
// CHECK-PPC64LE-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP103]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP104:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-PPC64LE-NEXT:    store i64 4, i64* [[TMP104]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 5
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP105]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 6
// CHECK-PPC64LE-NEXT:    [[TMP107:%.*]] = bitcast i8** [[TMP106]] to %struct.S2**
// CHECK-PPC64LE-NEXT:    store %struct.S2* [[TMP50]], %struct.S2** [[TMP107]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 6
// CHECK-PPC64LE-NEXT:    [[TMP109:%.*]] = bitcast i8** [[TMP108]] to %struct.S1**
// CHECK-PPC64LE-NEXT:    store %struct.S1* [[S18]], %struct.S1** [[TMP109]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-PPC64LE-NEXT:    store i64 [[TMP69]], i64* [[TMP110]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 6
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP111]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP112:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 7
// CHECK-PPC64LE-NEXT:    [[TMP113:%.*]] = bitcast i8** [[TMP112]] to %struct.S2**
// CHECK-PPC64LE-NEXT:    store %struct.S2* [[TMP50]], %struct.S2** [[TMP113]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 7
// CHECK-PPC64LE-NEXT:    [[TMP115:%.*]] = bitcast i8** [[TMP114]] to %struct.S1**
// CHECK-PPC64LE-NEXT:    store %struct.S1* [[S18]], %struct.S1** [[TMP115]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK-PPC64LE-NEXT:    store i64 4, i64* [[TMP116]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 7
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP117]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 8
// CHECK-PPC64LE-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS19]], %struct.S2*** [[TMP119]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 8
// CHECK-PPC64LE-NEXT:    [[TMP121:%.*]] = bitcast i8** [[TMP120]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS21]], %struct.S2*** [[TMP121]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 8
// CHECK-PPC64LE-NEXT:    store i64 8, i64* [[TMP122]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 8
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP123]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 9
// CHECK-PPC64LE-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS21]], %struct.S2*** [[TMP125]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 9
// CHECK-PPC64LE-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS24]], %struct.S2*** [[TMP127]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 9
// CHECK-PPC64LE-NEXT:    store i64 8, i64* [[TMP128]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 9
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP129]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 10
// CHECK-PPC64LE-NEXT:    [[TMP131:%.*]] = bitcast i8** [[TMP130]] to %struct.S2***
// CHECK-PPC64LE-NEXT:    store %struct.S2** [[PS24]], %struct.S2*** [[TMP131]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 10
// CHECK-PPC64LE-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to %struct.S1**
// CHECK-PPC64LE-NEXT:    store %struct.S1* [[S28]], %struct.S1** [[TMP133]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 10
// CHECK-PPC64LE-NEXT:    store i64 4, i64* [[TMP134]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP135:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 10
// CHECK-PPC64LE-NEXT:    store i8* null, i8** [[TMP135]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 11, i8** [[TMP136]], i8** [[TMP137]], i64* [[TMP138]], i64* getelementptr inbounds ([11 x i64], [11 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    [[TMP139:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC32:%.*]] = add nsw i32 [[TMP139]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC32]], i32* [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 11, i8** [[TMP140]], i8** [[TMP141]], i64* [[TMP142]], i64* getelementptr inbounds ([11 x i64], [11 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null)
// CHECK-PPC64LE-NEXT:    ret void
//
// CHECK-I386-LABEL: @_Z3fooi(
// CHECK-I386-NEXT:  entry:
// CHECK-I386-NEXT:    [[ARG_ADDR:%.*]] = alloca i32, align 4
// CHECK-I386-NEXT:    [[LB:%.*]] = alloca [5 x float], align 4
// CHECK-I386-NEXT:    [[PS1:%.*]] = alloca %struct.S2*, align 4
// CHECK-I386-NEXT:    [[PS2:%.*]] = alloca %struct.S2*, align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS1:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS2:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS3:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [1 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS29:%.*]] = alloca [11 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS30:%.*]] = alloca [11 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS31:%.*]] = alloca [11 x i8*], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [11 x i64], align 4
// CHECK-I386-NEXT:    store i32 [[ARG:%.*]], i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP1:%.*]] = bitcast i8** [[TMP0]] to [5 x float]**
// CHECK-I386-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP1]], align 4
// CHECK-I386-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to [5 x float]**
// CHECK-I386-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP3]], align 4
// CHECK-I386-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP4]], align 4
// CHECK-I386-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1:[0-9]+]], i64 -1, i32 1, i8** [[TMP5]], i8** [[TMP6]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK-I386-NEXT:    store i32 [[INC]], i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP8]], i8** [[TMP9]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to [5 x float]**
// CHECK-I386-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP11]], align 4
// CHECK-I386-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to [5 x float]**
// CHECK-I386-NEXT:    store [5 x float]* [[LB]], [5 x float]** [[TMP13]], align 4
// CHECK-I386-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS3]], i32 0, i32 0
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK-I386-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP15]], i8** [[TMP16]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.1, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP17:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC4:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK-I386-NEXT:    store i32 [[INC4]], i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP18]], i8** [[TMP19]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.1, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK-I386-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP21]], align 4
// CHECK-I386-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32**
// CHECK-I386-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP23]], align 4
// CHECK-I386-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 0
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK-I386-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.3, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP27:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC8:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK-I386-NEXT:    store i32 [[INC8]], i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 1, i8** [[TMP28]], i8** [[TMP29]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.3, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.4, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP30:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[TMP31:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[S:%.*]] = getelementptr inbounds [[STRUCT_S2:%.*]], %struct.S2* [[TMP31]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP32:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[TMP33:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP33]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP34:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS9:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP34]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP35:%.*]] = load %struct.S2*, %struct.S2** [[PS9]], align 4
// CHECK-I386-NEXT:    [[PS10:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP35]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP36:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS11:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP36]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP37:%.*]] = load %struct.S2*, %struct.S2** [[PS11]], align 4
// CHECK-I386-NEXT:    [[PS12:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP37]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP38:%.*]] = load %struct.S2*, %struct.S2** [[PS12]], align 4
// CHECK-I386-NEXT:    [[PS13:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP38]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP39:%.*]] = load %struct.S2*, %struct.S2** [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS14:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP39]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP40:%.*]] = load %struct.S2*, %struct.S2** [[PS14]], align 4
// CHECK-I386-NEXT:    [[PS15:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP40]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP41:%.*]] = load %struct.S2*, %struct.S2** [[PS15]], align 4
// CHECK-I386-NEXT:    [[PS16:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP41]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP42:%.*]] = load %struct.S2*, %struct.S2** [[PS16]], align 4
// CHECK-I386-NEXT:    [[S17:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP42]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP43:%.*]] = getelementptr %struct.S2*, %struct.S2** [[PS]], i32 1
// CHECK-I386-NEXT:    [[TMP44:%.*]] = bitcast %struct.S1* [[S]] to i8*
// CHECK-I386-NEXT:    [[TMP45:%.*]] = bitcast %struct.S2** [[TMP43]] to i8*
// CHECK-I386-NEXT:    [[TMP46:%.*]] = ptrtoint i8* [[TMP45]] to i64
// CHECK-I386-NEXT:    [[TMP47:%.*]] = ptrtoint i8* [[TMP44]] to i64
// CHECK-I386-NEXT:    [[TMP48:%.*]] = sub i64 [[TMP46]], [[TMP47]]
// CHECK-I386-NEXT:    [[TMP49:%.*]] = sdiv exact i64 [[TMP48]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-I386-NEXT:    [[TMP50:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[TMP51:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[S18:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP51]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP52:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[TMP53:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS19:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP53]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP54:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS20:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP54]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP55:%.*]] = load %struct.S2*, %struct.S2** [[PS20]], align 4
// CHECK-I386-NEXT:    [[PS21:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP55]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP56:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS22:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP56]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP57:%.*]] = load %struct.S2*, %struct.S2** [[PS22]], align 4
// CHECK-I386-NEXT:    [[PS23:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP57]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP58:%.*]] = load %struct.S2*, %struct.S2** [[PS23]], align 4
// CHECK-I386-NEXT:    [[PS24:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP58]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP59:%.*]] = load %struct.S2*, %struct.S2** [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS25:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP59]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP60:%.*]] = load %struct.S2*, %struct.S2** [[PS25]], align 4
// CHECK-I386-NEXT:    [[PS26:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP60]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP61:%.*]] = load %struct.S2*, %struct.S2** [[PS26]], align 4
// CHECK-I386-NEXT:    [[PS27:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP61]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP62:%.*]] = load %struct.S2*, %struct.S2** [[PS27]], align 4
// CHECK-I386-NEXT:    [[S28:%.*]] = getelementptr inbounds [[STRUCT_S2]], %struct.S2* [[TMP62]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP63:%.*]] = getelementptr %struct.S2*, %struct.S2** [[PS19]], i32 1
// CHECK-I386-NEXT:    [[TMP64:%.*]] = bitcast %struct.S1* [[S18]] to i8*
// CHECK-I386-NEXT:    [[TMP65:%.*]] = bitcast %struct.S2** [[TMP63]] to i8*
// CHECK-I386-NEXT:    [[TMP66:%.*]] = ptrtoint i8* [[TMP65]] to i64
// CHECK-I386-NEXT:    [[TMP67:%.*]] = ptrtoint i8* [[TMP64]] to i64
// CHECK-I386-NEXT:    [[TMP68:%.*]] = sub i64 [[TMP66]], [[TMP67]]
// CHECK-I386-NEXT:    [[TMP69:%.*]] = sdiv exact i64 [[TMP68]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-I386-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP71:%.*]] = bitcast i8** [[TMP70]] to %struct.S2**
// CHECK-I386-NEXT:    store %struct.S2* [[TMP30]], %struct.S2** [[TMP71]], align 4
// CHECK-I386-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP73:%.*]] = bitcast i8** [[TMP72]] to %struct.S1**
// CHECK-I386-NEXT:    store %struct.S1* [[S]], %struct.S1** [[TMP73]], align 4
// CHECK-I386-NEXT:    [[TMP74:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-I386-NEXT:    store i64 [[TMP49]], i64* [[TMP74]], align 4
// CHECK-I386-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 0
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP75]], align 4
// CHECK-I386-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP77:%.*]] = bitcast i8** [[TMP76]] to %struct.S2**
// CHECK-I386-NEXT:    store %struct.S2* [[TMP30]], %struct.S2** [[TMP77]], align 4
// CHECK-I386-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to %struct.S1**
// CHECK-I386-NEXT:    store %struct.S1* [[S]], %struct.S1** [[TMP79]], align 4
// CHECK-I386-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP80]], align 4
// CHECK-I386-NEXT:    [[TMP81:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 1
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP81]], align 4
// CHECK-I386-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 2
// CHECK-I386-NEXT:    [[TMP83:%.*]] = bitcast i8** [[TMP82]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS]], %struct.S2*** [[TMP83]], align 4
// CHECK-I386-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 2
// CHECK-I386-NEXT:    [[TMP85:%.*]] = bitcast i8** [[TMP84]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS10]], %struct.S2*** [[TMP85]], align 4
// CHECK-I386-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP86]], align 4
// CHECK-I386-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 2
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP87]], align 4
// CHECK-I386-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 3
// CHECK-I386-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS10]], %struct.S2*** [[TMP89]], align 4
// CHECK-I386-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 3
// CHECK-I386-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS13]], %struct.S2*** [[TMP91]], align 4
// CHECK-I386-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP92]], align 4
// CHECK-I386-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 3
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP93]], align 4
// CHECK-I386-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 4
// CHECK-I386-NEXT:    [[TMP95:%.*]] = bitcast i8** [[TMP94]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS13]], %struct.S2*** [[TMP95]], align 4
// CHECK-I386-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 4
// CHECK-I386-NEXT:    [[TMP97:%.*]] = bitcast i8** [[TMP96]] to %struct.S1**
// CHECK-I386-NEXT:    store %struct.S1* [[S17]], %struct.S1** [[TMP97]], align 4
// CHECK-I386-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP98]], align 4
// CHECK-I386-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 4
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP99]], align 4
// CHECK-I386-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 5
// CHECK-I386-NEXT:    [[TMP101:%.*]] = bitcast i8** [[TMP100]] to i32**
// CHECK-I386-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP101]], align 4
// CHECK-I386-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 5
// CHECK-I386-NEXT:    [[TMP103:%.*]] = bitcast i8** [[TMP102]] to i32**
// CHECK-I386-NEXT:    store i32* [[ARG_ADDR]], i32** [[TMP103]], align 4
// CHECK-I386-NEXT:    [[TMP104:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP104]], align 4
// CHECK-I386-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 5
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP105]], align 4
// CHECK-I386-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 6
// CHECK-I386-NEXT:    [[TMP107:%.*]] = bitcast i8** [[TMP106]] to %struct.S2**
// CHECK-I386-NEXT:    store %struct.S2* [[TMP50]], %struct.S2** [[TMP107]], align 4
// CHECK-I386-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 6
// CHECK-I386-NEXT:    [[TMP109:%.*]] = bitcast i8** [[TMP108]] to %struct.S1**
// CHECK-I386-NEXT:    store %struct.S1* [[S18]], %struct.S1** [[TMP109]], align 4
// CHECK-I386-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-I386-NEXT:    store i64 [[TMP69]], i64* [[TMP110]], align 4
// CHECK-I386-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 6
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP111]], align 4
// CHECK-I386-NEXT:    [[TMP112:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 7
// CHECK-I386-NEXT:    [[TMP113:%.*]] = bitcast i8** [[TMP112]] to %struct.S2**
// CHECK-I386-NEXT:    store %struct.S2* [[TMP50]], %struct.S2** [[TMP113]], align 4
// CHECK-I386-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 7
// CHECK-I386-NEXT:    [[TMP115:%.*]] = bitcast i8** [[TMP114]] to %struct.S1**
// CHECK-I386-NEXT:    store %struct.S1* [[S18]], %struct.S1** [[TMP115]], align 4
// CHECK-I386-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP116]], align 4
// CHECK-I386-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 7
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP117]], align 4
// CHECK-I386-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 8
// CHECK-I386-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS19]], %struct.S2*** [[TMP119]], align 4
// CHECK-I386-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 8
// CHECK-I386-NEXT:    [[TMP121:%.*]] = bitcast i8** [[TMP120]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS21]], %struct.S2*** [[TMP121]], align 4
// CHECK-I386-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 8
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP122]], align 4
// CHECK-I386-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 8
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP123]], align 4
// CHECK-I386-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 9
// CHECK-I386-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS21]], %struct.S2*** [[TMP125]], align 4
// CHECK-I386-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 9
// CHECK-I386-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS24]], %struct.S2*** [[TMP127]], align 4
// CHECK-I386-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 9
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP128]], align 4
// CHECK-I386-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 9
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP129]], align 4
// CHECK-I386-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 10
// CHECK-I386-NEXT:    [[TMP131:%.*]] = bitcast i8** [[TMP130]] to %struct.S2***
// CHECK-I386-NEXT:    store %struct.S2** [[PS24]], %struct.S2*** [[TMP131]], align 4
// CHECK-I386-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 10
// CHECK-I386-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to %struct.S1**
// CHECK-I386-NEXT:    store %struct.S1* [[S28]], %struct.S1** [[TMP133]], align 4
// CHECK-I386-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 10
// CHECK-I386-NEXT:    store i64 4, i64* [[TMP134]], align 4
// CHECK-I386-NEXT:    [[TMP135:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 10
// CHECK-I386-NEXT:    store i8* null, i8** [[TMP135]], align 4
// CHECK-I386-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 11, i8** [[TMP136]], i8** [[TMP137]], i64* [[TMP138]], i64* getelementptr inbounds ([11 x i64], [11 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    [[TMP139:%.*]] = load i32, i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC32:%.*]] = add nsw i32 [[TMP139]], 1
// CHECK-I386-NEXT:    store i32 [[INC32]], i32* [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [11 x i8*], [11 x i8*]* [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [11 x i64], [11 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i32 11, i8** [[TMP140]], i8** [[TMP141]], i64* [[TMP142]], i64* getelementptr inbounds ([11 x i64], [11 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null)
// CHECK-I386-NEXT:    ret void
//
void foo(int arg) {
  float lb[5];
  S2 *ps1;
  S2 *ps2;

  #pragma omp target data map(ompx_hold, to: lb)
  {++arg;}

  #pragma omp target data map(always close ompx_hold, to: lb)
  {++arg;}

  #pragma omp target data map(ompx_hold, tofrom : arg)
  {++arg;}

  // Make sure the struct picks up ompx_hold even if another element of the
  // struct doesn't have ompx_hold.
  #pragma omp target data map(tofrom : ps1->s, arg)                           \
                          map(ompx_hold, tofrom : ps1->ps->ps->ps->s, ps2->s) \
                          map(tofrom : ps2->ps->ps->ps->s)
  {
    ++(arg);
  }
}

#endif
