/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

/* someday this function will someday hold all the 'while' read loop for all logtool	*/
int lt_loop() {
	
	int fmt;
	int dpv = -2;

	/* some modules we may or may not use	*/
	int mod_snort = FALSE;
	int mod_iptables = FALSE;
	int mod_syslog = FALSE;
	
	mod_syslog = mod_varcheck("modsys_use");
	mod_snort = mod_varcheck("modsn_use");
	mod_iptables = mod_varcheck("modipt_use");
	
	/* some sanity checking for CSV output module	*/
	if(cf.outfmt == OUTPUT_CSV) {
		/* until we get CSV tweaked to understand funky modules, we just revert
		 * back to syslog processing	*/
		mod_snort = FALSE;
		mod_iptables = FALSE;
	}
	
	/* Open up stdin and read the input one line at a time till EOF */
	while(fgets(event.raw, LSIZE, stdin) != NULL) {
		/* 
		 * this function will see if it's a multilog generated file, and 
		 * do a quick pre-parse into syslog format if it is 
		 */
		lt_parse_multilog();
		
		/* Figure out what format of log-line we were given (bomb out if really bad) */
		if((fmt = lt_fmtcheck(event.raw)) == -1) {
			/* if we got an error, we need to stop now */
			continue; 
		}
		
		/* do our regex checking - we may be excluding this line of text */
		if(lt_do_regexcheck() == FALSE) continue;
		
		/* if it's not an unknown event, parse it and store value of dpv */
		if (fmt != EVENT_UNKNOWN) {
			dpv = lt_do_parse();
		}
		/* if we couldn't parse this properly, then we continue */
		if (dpv == -1 || dpv == FALSE) {
			continue;
		}

		/* depending what the format was, call the appropriate module	*/
		switch(fmt) {
			/* these functions should set event.pmsg with the appro	*/
			/* the appropriate \033 escape sequences (see the file	*/
			/* logtool.h for a listing of how we interpet these) 	*/
			/* later in the parsing process.			*/
			case EVENT_UNKNOWN:
				ltm_unknown();
				break;
				/* 
				 * from here down, we fallback to other processing 
				 * if the module in question is turned off in config
				 */
			case EVENT_SYSLOG:
				if(mod_syslog == TRUE) ltm_syslog();
				else ltm_unknown();
				break;
				/* 
				 * we're doing double fallbacks here, since syslog
				 * would be second best to what we got, but if 
				 * user disabled it, we want to go all the way down
				 * to 'unknown' processing;  Ugly, I know it...
				 */
			case EVENT_SNORT:
				if(mod_snort == TRUE) 
					ltm_snort();
				else if(mod_syslog == TRUE) 
					ltm_syslog();
				else 
					ltm_unknown();
				break;
			case EVENT_IPTABLES:
				if(mod_iptables == TRUE) 
					ltm_iptables();
				else if(mod_syslog == TRUE) 
					ltm_syslog();
				else 
					ltm_unknown();
				break;
				/* 
				 * these are our only modules to date.  I need to either
				 * write more, or get some friggin contributors. :)
				 */
			default:
				continue;
		}
		/* now, event.pmsg should be ready to be fed to the appropo output module	*/
		switch(cf.outfmt) {
			case OUTPUT_ANSI:
				lto_ansi();
				break;
			case OUTPUT_ASCII:
				lto_ascii();
				break;
			case OUTPUT_CSV:
				/* we only do syslog's and unknown's here	*/
				lto_csv();
				break;
			case OUTPUT_HTML:
				lto_html();
				break;
			case OUTPUT_RAW:
				lto_raw();
				break;
			case OUTPUT_CURSES:
				/* 
				 * in truth, we'll probably never be here, as a curses
				 * module is likely going to have to be a standalone
				 *
				 * Oh, did I mention none of this is written yet? :)
				 */
				break;
			default:
				break;
		}
	}
	return 0;
}
