with GNATCOLL.Tribooleans; use GNATCOLL.Tribooleans;
with Ada.Text_IO;          use Ada.Text_IO;

procedure Test_Tribools is
  BT : Boolean := True;
  BF : Boolean := False;

  T : constant Triboolean := True;
  F : constant Triboolean := False;
  I : constant Triboolean := Indeterminate;
begin
  Put_Line ("BT=T ? " & Boolean'Image (BT = T));
  Put_Line ("BT eq T ? " & Image (Equal (BT, T)));

  Put_Line ("BT=F ? " & Boolean'Image (BT = F));
  Put_Line ("BT eq F ? " & Image (Equal (BT, F)));

  Put_Line ("BT=I ? " & Boolean'Image (BT = I));
  Put_Line ("BT eq I ? " & Image (Equal (BT, I)));

  Put_Line ("BF=T ? " & Boolean'Image (BF = T));
  Put_Line ("BF eq T ? " & Image (Equal (BF, T)));

  Put_Line ("BF=F ? " & Boolean'Image (BF = F));
  Put_Line ("BF eq F ? " & Image (Equal (BF, F)));

  Put_Line ("BF=I ? " & Boolean'Image (BF = I));
  Put_Line ("BF eq I ? " & Image (Equal (BF, I)));


  Put_Line ("BF and F = " & Image (BF and F));
  Put_Line ("BF and T = " & Image (BF and T));
  Put_Line ("BF and I = " & Image (BF and I));
  Put_Line ("BT and F = " & Image (BT and F));
  Put_Line ("BT and T = " & Image (BT and T));
  Put_Line ("BT and I = " & Image (BT and I));
  Put_Line ("T and F = " & Image (T and F));
  Put_Line ("T and T = " & Image (T and T));
  Put_Line ("T and I = " & Image (T and I));
  Put_Line ("F and F = " & Image (F and F));
  Put_Line ("F and T = " & Image (F and T));
  Put_Line ("F and I = " & Image (F and I));
  Put_Line ("I and F = " & Image (I and F));
  Put_Line ("I and T = " & Image (I and T));
  Put_Line ("I and I = " & Image (I and I));

  Put_Line ("BF or F = " & Image (BF or F));
  Put_Line ("BF or T = " & Image (BF or T));
  Put_Line ("BF or I = " & Image (BF or I));
  Put_Line ("BT or F = " & Image (BT or F));
  Put_Line ("BT or T = " & Image (BT or T));
  Put_Line ("BT or I = " & Image (BT or I));
  Put_Line ("T or F = " & Image (T or F));
  Put_Line ("T or T = " & Image (T or T));
  Put_Line ("T or I = " & Image (T or I));
  Put_Line ("F or F = " & Image (F or F));
  Put_Line ("F or T = " & Image (F or T));
  Put_Line ("F or I = " & Image (F or I));
  Put_Line ("I or F = " & Image (I or F));
  Put_Line ("I or T = " & Image (I or T));
  Put_Line ("I or I = " & Image (I or I));

  Put_Line ("BF xor F = " & Image (BF xor F));
  Put_Line ("BF xor T = " & Image (BF xor T));
  Put_Line ("BF xor I = " & Image (BF xor I));
  Put_Line ("BT xor F = " & Image (BT xor F));
  Put_Line ("BT xor T = " & Image (BT xor T));
  Put_Line ("BT xor I = " & Image (BT xor I));
  Put_Line ("T xor F = " & Image (T xor F));
  Put_Line ("T xor T = " & Image (T xor T));
  Put_Line ("T xor I = " & Image (T xor I));
  Put_Line ("F xor F = " & Image (F xor F));
  Put_Line ("F xor T = " & Image (F xor T));
  Put_Line ("F xor I = " & Image (F xor I));
  Put_Line ("I xor F = " & Image (I xor F));
  Put_Line ("I xor T = " & Image (I xor T));
  Put_Line ("I xor I = " & Image (I xor I));

  Put_Line ("not F = " & Image (not F));
  Put_Line ("not T = " & Image (not T));
  Put_Line ("not I = " & Image (not I));

end Test_Tribools;
