/*
 * @(#)JUnitTestListenerUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.testserver.junit;

import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.autodoc.v1.testserver.*;

import java.util.*;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.AssertionFailedError;


/**
 * Tests the JUnitTestListener class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/05/29 13:05:52 $
 */
public class JUnitTestListenerUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = JUnitTestListenerUTest.class;
    
    public JUnitTestListenerUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testNeedMoreTests()
    {}
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    static class MyMonitor implements Monitor
    {
        public Vector addedInfo = new Vector();
        public Vector sentInfo = new Vector();
        public Vector testInfo = new Vector();
        
        public void addTestData( TestInfo info )
        {
            this.addedInfo.addElement( info );
            this.testInfo.addElement( info );
        }
        
        
        public TestData getTestData( TestInfo info )
        {
            return new DefaultTestData( info );
        }
        
        
        public void sendTestData( TestInfo info )
        {
            if (this.addedInfo.contains( info ))
            {
                this.addedInfo.removeElement( info );
                this.sentInfo.addElement( info );
            }
            else
            {
                throw new IllegalStateException("");
            }
        }
        
        
        public void clear()
        {
            this.addedInfo = new Vector();
            this.sentInfo = new Vector();
            this.testInfo = new Vector();
        }
    }
    
    
    static class MyMonitorFinder implements MonitorFinder
    {
        public MyMonitor monitor = new MyMonitor();
        public Monitor getMonitor()
        {
            return this.monitor;
        }
    }
    
    
    static class MyJUnitTestListener extends JUnitTestListener
    {
        public static MyMonitorFinder finder = new MyMonitorFinder();
        public Vector start = new Vector();
        public Vector end = new Vector();
        public Vector error = new Vector();
        public Vector thr = new Vector();
        public Vector failure = new Vector();
        
        public MyJUnitTestListener()
        {
            super( finder );
        }
        
        protected void startTest( TestData data )
        {
            this.start.addElement( data );
        }
        
        protected void endTest( TestData data )
        {
            this.end.addElement( data );
        }
        
        protected void addError( TestData data, Throwable t )
        {
            this.error.addElement( data );
            this.thr.addElement( t );
        }
        
        protected void addFailure( TestData data, AssertionFailedError t )
        {
            this.failure.addElement( data );
            this.thr.addElement( t );
        }
    }
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static TestSuite suite()
    {
        InterfaceTestSuite suite = JUnitTestListenerUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                MyJUnitTestListener.finder.monitor.clear();
                return new MyJUnitTestListener();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

