/*
 * @(#)AssertConstructorUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.junit.v1;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.AssertionFailedError;


/**
 * Tests the AssertConstructor class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 1, 2002
 * @version   $Date: 2003/02/10 22:52:22 $
 */
public class AssertConstructorUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AssertConstructorUTest.class;
    
    public AssertConstructorUTest( String name )
    {
        super( name );
    }

    


    //-------------------------------------------------------------------------
    // Tests
    
    public void testAssertHasDefaultConstructor1()
    {
        AssertConstructor.assertHasDefaultConstructor( Object.class );
    }
    
    
    public void testAssertHasDefaultConstructor2()
    {
        boolean failed = true;
        try
        {
            AssertConstructor.assertHasDefaultConstructor( Integer.class );
        }
        catch (AssertionFailedError e)
        {
            failed = false;
        }
        if (failed)
        {
            fail( "Did not cause an assertion failure." );
        }
    }
    
    
    public void testAssertHasDefaultConstructor3()
    {
        AssertConstructor.assertHasDefaultConstructor( new Object() );
    }
    
    
    public void testAssertHasDefaultConstructor4()
    {
        boolean failed = true;
        try
        {
            AssertConstructor.assertHasDefaultConstructor( new Integer( 1 ) );
        }
        catch (AssertionFailedError e)
        {
            failed = false;
        }
        if (failed)
        {
            fail( "Did not cause an assertion failure." );
        }
    }
    
    public void testAssertHasDefaultConstructor1a()
    {
        AssertConstructor.assertHasDefaultConstructor( "A", Object.class );
    }
    
    
    public void testAssertHasDefaultConstructor2a()
    {
        boolean failed = true;
        try
        {
            AssertConstructor.assertHasDefaultConstructor( ":A:",
                Integer.class );
        }
        catch (AssertionFailedError e)
        {
            assertTrue(
                "Did not throw an error with the message text.",
                e.getMessage().indexOf( ":A:" ) >= 0 );
            failed = false;
        }
        if (failed)
        {
            fail( "Did not cause an assertion failure." );
        }
    }
    
    
    public void testAssertHasDefaultConstructor3a()
    {
        AssertConstructor.assertHasDefaultConstructor( "A", new Object() );
    }
    
    
    public void testAssertHasDefaultConstructor4a()
    {
        boolean failed = true;
        try
        {
            AssertConstructor.assertHasDefaultConstructor( ":A:",
                new Integer( 1 ) );
        }
        catch (AssertionFailedError e)
        {
            assertTrue(
                "Did not throw an error with the message text.",
                e.getMessage().indexOf( ":A:" ) >= 0 );
            failed = false;
        }
        if (failed)
        {
            fail( "Did not cause an assertion failure." );
        }
    }

    
    
    public void testAssertHasConstructor1()
    {
        AssertConstructor.assertHasConstructor( Object.class, new Class[0],
            AssertConstructor.ANY_PROTECTION );
    }
    
    
    public void testAssertHasConstructor2()
    {
        boolean failed = true;
        try
        {
            AssertConstructor.assertHasConstructor( Object.class,
                new Class[0], AssertConstructor.PRIVATE );
        }
        catch (AssertionFailedError e)
        {
            failed = false;
        }
        if (failed)
        {
            fail( "Did not cause an assertion failure." );
        }
    }


    public void testAssertHasConstructor3()
    {
        AssertConstructor.assertHasConstructor( Integer.class,
            new Class[] { Integer.TYPE },
            AssertConstructor.PUBLIC );
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

