package org.jboss.cache.loader;

import org.jboss.cache.Fqn;
import org.jboss.cache.util.TestingUtil;
import static org.testng.AssertJUnit.assertEquals;
import org.testng.annotations.Test;

/**
 * Runs the same tests as {@link FileCacheLoaderTest}, but with Berkeley DB instead of a file-based CacheLoader
 *
 * @author Bela Ban
 * @version $Id: BdbjeCacheLoaderTest.java 5906 2008-05-29 07:24:18Z mircea.markus $
 */
@Test(groups = "functional")
public class BdbjeCacheLoaderTest extends CacheLoaderTestsBase
{
   protected void configureCache() throws Exception
   {
      String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
      String tmpCLLoc = tmpDir + "/JBossCache-FileCacheLoaderTest";

      cache.getConfiguration().setCacheLoaderConfig(getSingleCacheLoaderConfig("", "org.jboss.cache.loader.bdbje.BdbjeCacheLoader", "location=" + tmpCLLoc, false, true, false));
      TestingUtil.recursiveFileRemove(tmpCLLoc);
   }

   public void testTransaction() throws Exception
   {
      // to help recreate the issue in
      // http://www.jboss.com/index.html?module=bb&op=viewtopic&p=4048003#4048003

      Fqn fqn = Fqn.fromString("/a/b/c");
      String key = "key", value = "value";

      cache.put(fqn, key, value);
      cache.getTransactionManager().begin();
      assertEquals(value, cache.get(fqn, key));
      cache.getTransactionManager().commit();

      // now repeat this.

      cache.getTransactionManager().begin();
      assertEquals(value, cache.get(fqn, key));
      cache.getTransactionManager().commit();
   }

}
