/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2010-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include "utils.h"

static void __attribute__ ((constructor)) get_pagesize(void) {
	pagesize = sysconf(_SC_PAGESIZE);
}

int safe_realloc(void** __restrict__ ptr, size_t* __restrict__ size) {
	void* tmp = realloc(*ptr, *size);
	if (tmp == NULL) {
		free(*ptr);
		*ptr = NULL;
		*size = 0;
		return ENOMEM;
	}
	*ptr = tmp;
	return 0;
}

#if !defined(__FreeBSD__)
SA_INLINE void strlcpy(char* __restrict__ dest, const char* __restrict__ src, const size_t n) {
	strncpy(dest, src, n);
	if (strlen(src) >= n)
		dest[n] = '\0';
}
#endif
