# @datasource namespaces multirow
# Data for all namespaces in the package
# @column name
# @column overview

# @private write_to_file
# this procedure is only used here; inadvertently
# replicated some other proc, don't move to tcl library

proc ::template::util::write_to_file { file_name output} {

  set write_channel [open $file_name w ]
  puts $write_channel $output
  close $write_channel

  upvar \#[template::adp_level] file_list file_list
  lappend file_list $file_name
}

# obsolete
# uses ns_library to find the server root, may not always be accurate
proc ::template::util::server_root {} {

  set path_length [expr [llength [file split [ns_library private]]] - 1]
  set svr_root "/[join [lreplace [file split [ns_library private]] $path_length $path_length] / ]"
  return $svr_root 
}

proc ::template::util::write_from_template { template file_name} {

  upvar template_name template_name
  set template_name $template
  uplevel {
      set read_template [template::util::read_file $template_name]
      set code [template::adp_compile -string $read_template]
      set output [template::adp_eval code]
  }
  upvar output output
  ns_log notice "
  writing $file_name from the template $template\n"
  template::util::write_to_file $file_name "$output"
}
    

set tcl_lvl [info level]
set adp_lvl [adp_level]
set file_list [list]
set doc_root $::acs::rootdir/packages/acs-templating/www/doc

#debugging:
template::util::display_value doc_root

set namespace_template [template::util::read_file \
	$doc_root/gen/namespace-template.adp]

set dir [ns_library private]

# debugging
set svr_root $::acs::rootdir


set dir [list $svr_root/packages/cms/tcl $svr_root/packages/acs-templating/tcl]
template::util::display_value dir

set parsed_list [doc::parse_tcl_library $dir]


set info_list [list]

foreach namespace_entry $parsed_list {

    # this sets the variables namespace_info, namespace_public and namespace_private
    foreach namespace_element $namespace_entry {
	set namespace_[lindex $namespace_element 0] "[lindex $namespace_element 1]"
    }

    # namespace_info is a paired list with the following format:
    # { name <namespace name> 
    #   overview <namespace description> 
    #   author <namespace's primary author>
    #   see <a list of rows> }

    # info_list will be used later when creating the index page for namespaces
    lappend info_list $namespace_info

    # the following will be used later when we generate the file for this namespace
    array set info $namespace_info


    # setting the see multirow for the namespace page
    if {[llength [lindex $namespace_info 7]] > 0 } {
	template::util::list_to_multirow see [lindex $namespace_info 7]
    } else {
	
	# there's no text for the see directive, but we'll set the multirow
	# so its absence doesn't break our template
	template::multirow create see name type url
    }

    set namespace_name [lindex $namespace_info 1]

    # while we're creating this namespace's multirow, we'll also
    # write the pages for each 
    # first thing to do is create the multirows with the proc info
    
    foreach public_private {public private} {

	if { [llength [set namespace_$public_private] ] > 0} {

	    template::util::list_to_multirow $public_private [set namespace_$public_private]

	} else {
	    # go ahead and make this multirow even if there is no info for it,
	    # otherwise the template compiler will break

	    template::multirow create $public_private data
	}
    }
	
    set namespace_page $doc_root/TclDocs/[doc::util::dbl_colon_fix $namespace_name].html

    # a hack for some bug in template::adp_eval
    # that shows __adp_stub as not existing
    set __adp_stub $doc_root/gen/generate-docs
    
    set namespace_code [template::adp_compile -string $namespace_template]

    #debug
    template::util::display_value namespace_code
    
    set namespace_output [template::adp_eval namespace_code]

    ns_log notice "\nwriting $namespace_page\n"
    
    template::util::write_to_file $namespace_page $namespace_output
}

template::util::list_to_multirow namespaces $info_list

template::util::write_from_template \
    $doc_root/gen/package-template.adp $doc_root/TclDocs/namespaces.html

# generated by doc::parse_tcl_library is a list of namespace names,
# namespace_list; need to take this list and create a multirow
# with namespace names and url-adjusted names with no double-colons
set temp_list $namespace_list
set namespace_list [list]
foreach element $temp_list {
    lappend namespace_list [list name "$element" url_name [doc::util::dbl_colon_fix $element]]
}

template::util::list_to_multirow namespace_urls $namespace_list


template::util::write_from_template \
    $doc_root/gen/namespace-list.adp $doc_root/TclDocs/namespace-list.html


