/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTASSIGNEDIDENTITYACCESS_H_
#define OPENDRIM_ACCOUNTASSIGNEDIDENTITYACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_AccountAssignedIdentity.h"
#include "assocOpenDRIM_AccountAssignedIdentity.h"

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AccountAssignedIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AccountAssignedIdentity& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountAssignedIdentity& newInstance, const OpenDRIM_AccountAssignedIdentity& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountAssignedIdentity& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountAssignedIdentity& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_associatorIdentityInfoToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& IdentityInfo_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_associatorManagedElementToIdentityInfo(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& IdentityInfo_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_referenceIdentityInfoToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& IdentityInfo_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_AccountAssignedIdentity>& OpenDRIM_AccountAssignedIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_referenceManagedElementToIdentityInfo(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& IdentityInfo_instances, vector<OpenDRIM_AccountAssignedIdentity>& OpenDRIM_AccountAssignedIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountAssignedIdentity_populate(OpenDRIM_AccountAssignedIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_ACCOUNTASSIGNEDIDENTITYACCESS_H_*/
