/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareInstallationService.h"

CMPIObjectPath* SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SoftwareInstallationService& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SoftwareInstallationService_classnames[0], OpenDRIM_SoftwareInstallationService_NAMESPACE);

	if (!instance.SystemCreationClassName_isNULL)
		op.addKey("SystemCreationClassName", instance.SystemCreationClassName);

	if (!instance.SystemName_isNULL)
		op.addKey("SystemName", instance.SystemName);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	_L_;
	return op.getHdl();
}

CMPIInstance* SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SoftwareInstallationService& instance) {
	_E_;
	Objectpath op(broker, SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.InstanceID_isNULL)
		ci.setProperty("InstanceID", instance.InstanceID);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.PrimaryOwnerName_isNULL)
		ci.setProperty("PrimaryOwnerName", instance.PrimaryOwnerName);

	if (!instance.PrimaryOwnerContact_isNULL)
		ci.setProperty("PrimaryOwnerContact", instance.PrimaryOwnerContact);

	if (!instance.StartMode_isNULL)
		ci.setProperty("StartMode", instance.StartMode);

	if (!instance.Started_isNULL)
		ci.setProperty("Started", instance.Started);

	_L_;
	return ci.getHdl();
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SoftwareInstallationService& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SoftwareInstallationService& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (inst.getProperty("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("PrimaryOwnerName", instance.PrimaryOwnerName) == OK)
		instance.PrimaryOwnerName_isNULL = false;

	if (inst.getProperty("PrimaryOwnerContact", instance.PrimaryOwnerContact) == OK)
		instance.PrimaryOwnerContact_isNULL = false;

	if (inst.getProperty("StartMode", instance.StartMode) == OK)
		instance.StartMode_isNULL = false;

	if (inst.getProperty("Started", instance.Started) == OK)
		instance.Started_isNULL = false;

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_SoftwareInstallationService_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_SoftwareInstallationService_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	Objectpath Source;
	data = in->ft->getArg(in, "Source", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Source);	
		args.setSource(Source);
	}			

	Objectpath Target;
	data = in->ft->getArg(in, "Target", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Target);	
		args.setTarget(Target);
	}			

	Objectpath Collection;
	data = in->ft->getArg(in, "Collection", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Collection);	
		args.setCollection(Collection);
	}			

	vector<unsigned short> InstallCharacteristics;
	data = in->ft->getArg(in, "InstallCharacteristics", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstallCharacteristics);	
		args.setInstallCharacteristics(InstallCharacteristics);
	}			

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_SoftwareInstallationService_CheckSoftwareIdentity_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	vector<unsigned short> InstallCharacteristics;
	errorMessage = args.getInstallCharacteristics(InstallCharacteristics);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, InstallCharacteristics);
		out->ft->addArg(out, "InstallCharacteristics", &value, CMPI_uint16A);
	}

	_L_;
}
void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	vector<unsigned short> InstallOptions;
	data = in->ft->getArg(in, "InstallOptions", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstallOptions);	
		args.setInstallOptions(InstallOptions);
	}			

	vector<string> InstallOptionsValues;
	data = in->ft->getArg(in, "InstallOptionsValues", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstallOptionsValues);	
		args.setInstallOptionsValues(InstallOptionsValues);
	}			

	Objectpath Source;
	data = in->ft->getArg(in, "Source", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Source);	
		args.setSource(Source);
	}			

	Objectpath Target;
	data = in->ft->getArg(in, "Target", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Target);	
		args.setTarget(Target);
	}			

	Objectpath Collection;
	data = in->ft->getArg(in, "Collection", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Collection);	
		args.setCollection(Collection);
	}			

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_SoftwareInstallationService_InstallFromSoftwareIdentity_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_SoftwareInstallationService_InstallFromURI_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string URI;
	data = in->ft->getArg(in, "URI", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, URI);	
		args.setURI(URI);
	}			

	Objectpath Target;
	data = in->ft->getArg(in, "Target", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Target);	
		args.setTarget(Target);
	}			

	vector<unsigned short> InstallOptions;
	data = in->ft->getArg(in, "InstallOptions", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstallOptions);	
		args.setInstallOptions(InstallOptions);
	}			

	vector<string> InstallOptionsValues;
	data = in->ft->getArg(in, "InstallOptionsValues", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstallOptionsValues);	
		args.setInstallOptionsValues(InstallOptionsValues);
	}			

	_L_;
}

void SoftwareUpdate_OpenDRIM_SoftwareInstallationService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_SoftwareInstallationService_InstallFromURI_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
