#
#VID 6107efb9-aae3-11da-aea1-000854d03344
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56350);
 script_cve_id("CVE-2006-0300");
 script_bugtraq_id(16764);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: gtar";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gtar

CVE-2006-0300
Buffer overflow in tar 1.14 through 1.15.90 allows user-complicit
attackers to cause a denial of service (application crash) and
possibly execute code via unspecified vectors involving PAX extended
headers.

Solution:
Update your system with the appropriate patches or
software upgrades.

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gtar";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gtar");
if(!isnull(bver) && revcomp(a:bver, b:"1.15.1_2")<0) {
    security_note(0, data:"Package gtar version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
