###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_xss_vuln_jul09.nasl 3325 2009-07-08 10:48:29Z jul $
#
# Google Chrome Cross-Site Scripting Vulnerability - July09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800828);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2352");
  script_bugtraq_id(35572);
  script_name("Google Chrome Cross-Site Scripting Vulnerability - July09");
  desc = "

  Overview: This host has Google Chrome installed and is prone to Cross-Site
  Scripting vulnerability.

  Vulnerability Insight:
  Error exists when application fails to block 'javascript:' URIs in Refresh
  headers in HTTP responses.

  Impact:
  Successful exploitation will let the remote attackers to conduct Cross-Site
  Scripting attacks via vectors related to injecting a Refresh header or
  specifying the content of a Refresh header.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 1.0.154.48 and prior.

  Fix:
  No solution or patch is available as on 08th July, 2009. Information regarding
  this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://websecurity.com.ua/
  http://www.securityfocus.com/archive/1/504723/100/0/threaded
  http://www.securityfocus.com/archive/1/504718/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version <= 1.0.154.48
if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.48")){
  security_hole(0);
}
