#pragma once

#include <asn1c/asn_application.h>

/* for f in ranap/RANAP_*.h; printf "#include \"$f\"\n" */
#include <osmocom/ranap/RANAP_APN.h>
#include <osmocom/ranap/RANAP_AccuracyFulfilmentIndicator.h>
#include <osmocom/ranap/RANAP_AllocationOrRetentionPriority.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-ExtendedGuaranteedBitrateInf.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-ExtendedGuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-ExtendedGuaranteedBitrates.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-ExtendedMaxBitrateInf.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-ExtendedMaxBitrateList.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-ExtendedMaxBitrates.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-GuaranteedBitrateInf.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-GuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-GuaranteedBitrateType.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-GuaranteedBitrates.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-MaxBitrateInf.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-MaxBitrateList.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-MaxBitrateType.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-MaxBitrates.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-SupportedGuaranteedBitrateInf.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-SupportedGuaranteedBitrates.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-SupportedMaxBitrateInf.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameter-SupportedMaxBitrates.h>
#include <osmocom/ranap/RANAP_Alt-RAB-Parameters.h>
#include <osmocom/ranap/RANAP_AlternativeRABConfigurationRequest.h>
#include <osmocom/ranap/RANAP_AreaIdentity.h>
#include <osmocom/ranap/RANAP_Ass-RAB-Parameter-ExtendedGuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_Ass-RAB-Parameter-ExtendedMaxBitrateList.h>
#include <osmocom/ranap/RANAP_Ass-RAB-Parameter-GuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_Ass-RAB-Parameter-MaxBitrateList.h>
#include <osmocom/ranap/RANAP_Ass-RAB-Parameters.h>
#include <osmocom/ranap/RANAP_AuthorisedPLMNs.h>
#include <osmocom/ranap/RANAP_AuthorisedSNAs.h>
#include <osmocom/ranap/RANAP_BindingID.h>
#include <osmocom/ranap/RANAP_BroadcastAssistanceDataDecipheringKeys.h>
#include <osmocom/ranap/RANAP_CGI.h>
#include <osmocom/ranap/RANAP_CI.h>
#include <osmocom/ranap/RANAP_CN-DeactivateTrace.h>
#include <osmocom/ranap/RANAP_CN-DomainIndicator.h>
#include <osmocom/ranap/RANAP_CN-ID.h>
#include <osmocom/ranap/RANAP_CN-InvokeTrace.h>
#include <osmocom/ranap/RANAP_CNMBMSLinkingInformation.h>
#include <osmocom/ranap/RANAP_CSFB-Information.h>
#include <osmocom/ranap/RANAP_CSG-Id-List.h>
#include <osmocom/ranap/RANAP_CSG-Id.h>
#include <osmocom/ranap/RANAP_CSG-Membership-Status.h>
#include <osmocom/ranap/RANAP_Cause.h>
#include <osmocom/ranap/RANAP_CauseMisc.h>
#include <osmocom/ranap/RANAP_CauseNAS.h>
#include <osmocom/ranap/RANAP_CauseNon-Standard.h>
#include <osmocom/ranap/RANAP_CauseProtocol.h>
#include <osmocom/ranap/RANAP_CauseRadioNetwork.h>
#include <osmocom/ranap/RANAP_CauseRadioNetworkExtension.h>
#include <osmocom/ranap/RANAP_CauseTransmissionNetwork.h>
#include <osmocom/ranap/RANAP_Cell-Access-Mode.h>
#include <osmocom/ranap/RANAP_Cell-Capacity-Class-Value.h>
#include <osmocom/ranap/RANAP_Cell-Id.h>
#include <osmocom/ranap/RANAP_CellBased.h>
#include <osmocom/ranap/RANAP_CellIdList.h>
#include <osmocom/ranap/RANAP_CellLoadInformation.h>
#include <osmocom/ranap/RANAP_CellLoadInformationGroup.h>
#include <osmocom/ranap/RANAP_CellType.h>
#include <osmocom/ranap/RANAP_ChosenEncryptionAlgorithm.h>
#include <osmocom/ranap/RANAP_ChosenIntegrityProtectionAlgorithm.h>
#include <osmocom/ranap/RANAP_ClassmarkInformation2.h>
#include <osmocom/ranap/RANAP_ClassmarkInformation3.h>
#include <osmocom/ranap/RANAP_ClientType.h>
#include <osmocom/ranap/RANAP_CommonID.h>
#include <osmocom/ranap/RANAP_Correlation-ID.h>
#include <osmocom/ranap/RANAP_Criticality.h>
#include <osmocom/ranap/RANAP_CriticalityDiagnostics-IE-List.h>
#include <osmocom/ranap/RANAP_CriticalityDiagnostics.h>
#include <osmocom/ranap/RANAP_D-RNTI.h>
#include <osmocom/ranap/RANAP_DCH-ID.h>
#include <osmocom/ranap/RANAP_DL-GTP-PDU-SequenceNumber.h>
#include <osmocom/ranap/RANAP_DL-N-PDU-SequenceNumber.h>
#include <osmocom/ranap/RANAP_DRX-CycleLengthCoefficient.h>
#include <osmocom/ranap/RANAP_DSCH-ID.h>
#include <osmocom/ranap/RANAP_DataPDUType.h>
#include <osmocom/ranap/RANAP_DataVolumeList.h>
#include <osmocom/ranap/RANAP_DataVolumeReference.h>
#include <osmocom/ranap/RANAP_DataVolumeReport.h>
#include <osmocom/ranap/RANAP_DataVolumeReportList.h>
#include <osmocom/ranap/RANAP_DataVolumeReportRequest.h>
#include <osmocom/ranap/RANAP_DataVolumeReportingIndication.h>
#include <osmocom/ranap/RANAP_DeliveryOfErroneousSDU.h>
#include <osmocom/ranap/RANAP_DeliveryOrder.h>
#include <osmocom/ranap/RANAP_DeltaRAListofIdleModeUEs.h>
#include <osmocom/ranap/RANAP_DirectInformationTransfer.h>
#include <osmocom/ranap/RANAP_DirectReportingIndicator.h>
#include <osmocom/ranap/RANAP_DirectTransfer-IE-ContainerList.h>
#include <osmocom/ranap/RANAP_DirectTransfer.h>
#include <osmocom/ranap/RANAP_DirectTransferInformationItem-RANAP-RelocInf.h>
#include <osmocom/ranap/RANAP_E-DCH-MAC-d-Flow-ID.h>
#include <osmocom/ranap/RANAP_E-UTRAN-Service-Handover.h>
#include <osmocom/ranap/RANAP_EARFCN-Extended.h>
#include <osmocom/ranap/RANAP_ENB-ID.h>
#include <osmocom/ranap/RANAP_EUTRANFrequencies.h>
#include <osmocom/ranap/RANAP_EncryptionAlgorithm.h>
#include <osmocom/ranap/RANAP_EncryptionInformation.h>
#include <osmocom/ranap/RANAP_EncryptionKey.h>
#include <osmocom/ranap/RANAP_End-Of-CSFB.h>
#include <osmocom/ranap/RANAP_EnhancedRelocationCompleteConfirm.h>
#include <osmocom/ranap/RANAP_EnhancedRelocationCompleteFailure.h>
#include <osmocom/ranap/RANAP_EnhancedRelocationCompleteRequest.h>
#include <osmocom/ranap/RANAP_EnhancedRelocationCompleteResponse.h>
#include <osmocom/ranap/RANAP_EquipmentsToBeTraced.h>
#include <osmocom/ranap/RANAP_ErrorIndication.h>
#include <osmocom/ranap/RANAP_Event.h>
#include <osmocom/ranap/RANAP_Event1F-Parameters.h>
#include <osmocom/ranap/RANAP_Event1I-Parameters.h>
#include <osmocom/ranap/RANAP_ExtendedGuaranteedBitrate.h>
#include <osmocom/ranap/RANAP_ExtendedMaxBitrate.h>
#include <osmocom/ranap/RANAP_ExtendedRNC-ID.h>
#include <osmocom/ranap/RANAP_ForwardSRNS-Context.h>
#include <osmocom/ranap/RANAP_ForwardingIndication.h>
#include <osmocom/ranap/RANAP_FrameSequenceNumber.h>
#include <osmocom/ranap/RANAP_FrequenceLayerConvergenceFlag.h>
#include <osmocom/ranap/RANAP_GA-AltitudeAndDirection.h>
#include <osmocom/ranap/RANAP_GA-EllipsoidArc.h>
#include <osmocom/ranap/RANAP_GA-Point.h>
#include <osmocom/ranap/RANAP_GA-PointWithAltitude.h>
#include <osmocom/ranap/RANAP_GA-PointWithAltitudeAndUncertaintyEllipsoid.h>
#include <osmocom/ranap/RANAP_GA-PointWithUnCertainty.h>
#include <osmocom/ranap/RANAP_GA-PointWithUnCertaintyEllipse.h>
#include <osmocom/ranap/RANAP_GA-Polygon.h>
#include <osmocom/ranap/RANAP_GA-UncertaintyEllipse.h>
#include <osmocom/ranap/RANAP_GANSS-PositioningDataSet.h>
#include <osmocom/ranap/RANAP_GANSS-PositioningMethodAndUsage.h>
#include <osmocom/ranap/RANAP_GERAN-BSC-Container.h>
#include <osmocom/ranap/RANAP_GERAN-Cell-ID.h>
#include <osmocom/ranap/RANAP_GERAN-Classmark.h>
#include <osmocom/ranap/RANAP_GERAN-Iumode-RAB-Failed-RABAssgntResponse-Item.h>
#include <osmocom/ranap/RANAP_GERAN-Iumode-RAB-Failed-RABAssgntResponse-List.h>
#include <osmocom/ranap/RANAP_GTP-TEI.h>
#include <osmocom/ranap/RANAP_GeographicalArea.h>
#include <osmocom/ranap/RANAP_GeographicalCoordinates.h>
#include <osmocom/ranap/RANAP_GlobalCN-ID.h>
#include <osmocom/ranap/RANAP_GlobalRNC-ID.h>
#include <osmocom/ranap/RANAP_GuaranteedBitrate.h>
#include <osmocom/ranap/RANAP_HS-DSCH-MAC-d-Flow-ID.h>
#include <osmocom/ranap/RANAP_HigherBitratesThan16MbpsFlag.h>
#include <osmocom/ranap/RANAP_HorizontalSpeedAndBearing.h>
#include <osmocom/ranap/RANAP_HorizontalVelocity.h>
#include <osmocom/ranap/RANAP_HorizontalVelocityWithUncertainty.h>
#include <osmocom/ranap/RANAP_HorizontalWithVerticalVelocity.h>
#include <osmocom/ranap/RANAP_HorizontalWithVerticalVelocityAndUncertainty.h>
#include <osmocom/ranap/RANAP_IE-Extensions.h>
#include <osmocom/ranap/RANAP_IE.h>
#include <osmocom/ranap/RANAP_IMEI.h>
#include <osmocom/ranap/RANAP_IMEIGroup.h>
#include <osmocom/ranap/RANAP_IMEIList.h>
#include <osmocom/ranap/RANAP_IMEISV.h>
#include <osmocom/ranap/RANAP_IMEISVGroup.h>
#include <osmocom/ranap/RANAP_IMEISVList.h>
#include <osmocom/ranap/RANAP_IMSI.h>
#include <osmocom/ranap/RANAP_IPMulticastAddress.h>
#include <osmocom/ranap/RANAP_IRAT-Measurement-Configuration.h>
#include <osmocom/ranap/RANAP_IRATmeasurementParameters.h>
#include <osmocom/ranap/RANAP_ImmediateMDT.h>
#include <osmocom/ranap/RANAP_IncludeVelocity.h>
#include <osmocom/ranap/RANAP_InformationExchangeID.h>
#include <osmocom/ranap/RANAP_InformationExchangeType.h>
#include <osmocom/ranap/RANAP_InformationRequestType.h>
#include <osmocom/ranap/RANAP_InformationRequested.h>
#include <osmocom/ranap/RANAP_InformationTransferConfirmation.h>
#include <osmocom/ranap/RANAP_InformationTransferFailure.h>
#include <osmocom/ranap/RANAP_InformationTransferID.h>
#include <osmocom/ranap/RANAP_InformationTransferIndication.h>
#include <osmocom/ranap/RANAP_InformationTransferType.h>
#include <osmocom/ranap/RANAP_InitialUE-Message.h>
#include <osmocom/ranap/RANAP_InitiatingMessage.h>
#include <osmocom/ranap/RANAP_IntegrityProtectionAlgorithm.h>
#include <osmocom/ranap/RANAP_IntegrityProtectionInformation.h>
#include <osmocom/ranap/RANAP_IntegrityProtectionKey.h>
#include <osmocom/ranap/RANAP_InterSystemInformation-TransparentContainer.h>
#include <osmocom/ranap/RANAP_InterSystemInformationTransferType.h>
#include <osmocom/ranap/RANAP_InterfacesToTraceItem.h>
#include <osmocom/ranap/RANAP_Iu-ReleaseCommand.h>
#include <osmocom/ranap/RANAP_Iu-ReleaseComplete.h>
#include <osmocom/ranap/RANAP_Iu-ReleaseRequest.h>
#include <osmocom/ranap/RANAP_IuSigConId-IE-ContainerList.h>
#include <osmocom/ranap/RANAP_IuSignallingConnectionIdentifier.h>
#include <osmocom/ranap/RANAP_IuTransportAssociation.h>
#include <osmocom/ranap/RANAP_JoinedMBMSBearerService-IEs.h>
#include <osmocom/ranap/RANAP_KeyStatus.h>
#include <osmocom/ranap/RANAP_L3-Information.h>
#include <osmocom/ranap/RANAP_LA-LIST.h>
#include <osmocom/ranap/RANAP_LABased.h>
#include <osmocom/ranap/RANAP_LAC.h>
#include <osmocom/ranap/RANAP_LAI-List.h>
#include <osmocom/ranap/RANAP_LAI.h>
#include <osmocom/ranap/RANAP_LAListofIdleModeUEs.h>
#include <osmocom/ranap/RANAP_LHN-ID.h>
#include <osmocom/ranap/RANAP_LastKnownServiceArea.h>
#include <osmocom/ranap/RANAP_LastVisitedUTRANCell-Item.h>
#include <osmocom/ranap/RANAP_LeftMBMSBearerService-IEs.h>
#include <osmocom/ranap/RANAP_Links-to-log.h>
#include <osmocom/ranap/RANAP_ListOF-SNAs.h>
#include <osmocom/ranap/RANAP_ListOfInterfacesToTrace.h>
#include <osmocom/ranap/RANAP_LoadValue.h>
#include <osmocom/ranap/RANAP_LocationRelatedDataFailure.h>
#include <osmocom/ranap/RANAP_LocationRelatedDataRequest.h>
#include <osmocom/ranap/RANAP_LocationRelatedDataRequestType.h>
#include <osmocom/ranap/RANAP_LocationRelatedDataRequestTypeSpecificToGERANIuMode.h>
#include <osmocom/ranap/RANAP_LocationRelatedDataResponse.h>
#include <osmocom/ranap/RANAP_LocationReport.h>
#include <osmocom/ranap/RANAP_LocationReportingControl.h>
#include <osmocom/ranap/RANAP_LocationReportingTransferInformation.h>
#include <osmocom/ranap/RANAP_LoggedMDT.h>
#include <osmocom/ranap/RANAP_LoggingDuration.h>
#include <osmocom/ranap/RANAP_LoggingInterval.h>
#include <osmocom/ranap/RANAP_M1Report.h>
#include <osmocom/ranap/RANAP_M2Report.h>
#include <osmocom/ranap/RANAP_M4-Collection-Parameters.h>
#include <osmocom/ranap/RANAP_M4-Period.h>
#include <osmocom/ranap/RANAP_M4-Threshold.h>
#include <osmocom/ranap/RANAP_M4Report.h>
#include <osmocom/ranap/RANAP_M5-Period.h>
#include <osmocom/ranap/RANAP_M5Report.h>
#include <osmocom/ranap/RANAP_M6-Period.h>
#include <osmocom/ranap/RANAP_M6Report.h>
#include <osmocom/ranap/RANAP_M7-Period.h>
#include <osmocom/ranap/RANAP_M7Report.h>
#include <osmocom/ranap/RANAP_MBMS-PTP-RAB-ID.h>
#include <osmocom/ranap/RANAP_MBMSBearerServiceType.h>
#include <osmocom/ranap/RANAP_MBMSCNDe-Registration.h>
#include <osmocom/ranap/RANAP_MBMSCNDe-RegistrationRequest.h>
#include <osmocom/ranap/RANAP_MBMSCNDe-RegistrationResponse.h>
#include <osmocom/ranap/RANAP_MBMSCountingInformation.h>
#include <osmocom/ranap/RANAP_MBMSHCIndicator.h>
#include <osmocom/ranap/RANAP_MBMSIPMulticastAddressandAPNRequest.h>
#include <osmocom/ranap/RANAP_MBMSIPMulticastAddressandAPNlist.h>
#include <osmocom/ranap/RANAP_MBMSLinkingInformation.h>
#include <osmocom/ranap/RANAP_MBMSRABEstablishmentIndication.h>
#include <osmocom/ranap/RANAP_MBMSRABRelease.h>
#include <osmocom/ranap/RANAP_MBMSRABReleaseFailure.h>
#include <osmocom/ranap/RANAP_MBMSRABReleaseRequest.h>
#include <osmocom/ranap/RANAP_MBMSRegistrationFailure.h>
#include <osmocom/ranap/RANAP_MBMSRegistrationRequest.h>
#include <osmocom/ranap/RANAP_MBMSRegistrationRequestType.h>
#include <osmocom/ranap/RANAP_MBMSRegistrationResponse.h>
#include <osmocom/ranap/RANAP_MBMSServiceArea.h>
#include <osmocom/ranap/RANAP_MBMSSessionDuration.h>
#include <osmocom/ranap/RANAP_MBMSSessionIdentity.h>
#include <osmocom/ranap/RANAP_MBMSSessionRepetitionNumber.h>
#include <osmocom/ranap/RANAP_MBMSSessionStart.h>
#include <osmocom/ranap/RANAP_MBMSSessionStartFailure.h>
#include <osmocom/ranap/RANAP_MBMSSessionStartResponse.h>
#include <osmocom/ranap/RANAP_MBMSSessionStop.h>
#include <osmocom/ranap/RANAP_MBMSSessionStopResponse.h>
#include <osmocom/ranap/RANAP_MBMSSessionUpdate.h>
#include <osmocom/ranap/RANAP_MBMSSessionUpdateFailure.h>
#include <osmocom/ranap/RANAP_MBMSSessionUpdateResponse.h>
#include <osmocom/ranap/RANAP_MBMSSynchronisationInformation.h>
#include <osmocom/ranap/RANAP_MBMSUELinkingRequest.h>
#include <osmocom/ranap/RANAP_MBMSUELinkingResponse.h>
#include <osmocom/ranap/RANAP_MDT-Activation.h>
#include <osmocom/ranap/RANAP_MDT-Configuration.h>
#include <osmocom/ranap/RANAP_MDT-PLMN-List.h>
#include <osmocom/ranap/RANAP_MDT-Report-Parameters.h>
#include <osmocom/ranap/RANAP_MDTAreaScope.h>
#include <osmocom/ranap/RANAP_MDTMode.h>
#include <osmocom/ranap/RANAP_MSISDN.h>
#include <osmocom/ranap/RANAP_Management-Based-MDT-Allowed.h>
#include <osmocom/ranap/RANAP_MaxBitrate.h>
#include <osmocom/ranap/RANAP_MaxSDU-Size.h>
#include <osmocom/ranap/RANAP_MeasBand.h>
#include <osmocom/ranap/RANAP_MeasurementQuantity.h>
#include <osmocom/ranap/RANAP_MeasurementsToActivate.h>
#include <osmocom/ranap/RANAP_MessageStructure.h>
#include <osmocom/ranap/RANAP_NAS-PDU.h>
#include <osmocom/ranap/RANAP_NAS-SequenceNumber.h>
#include <osmocom/ranap/RANAP_NAS-SynchronisationIndicator.h>
#include <osmocom/ranap/RANAP_NRTLoadInformationValue.h>
#include <osmocom/ranap/RANAP_NewBSS-To-OldBSS-Information.h>
#include <osmocom/ranap/RANAP_NewRAListofIdleModeUEs.h>
#include <osmocom/ranap/RANAP_NonSearchingIndication.h>
#include <osmocom/ranap/RANAP_NotEmptyRAListofIdleModeUEs.h>
#include <osmocom/ranap/RANAP_NumberOfIuInstances.h>
#include <osmocom/ranap/RANAP_NumberOfSteps.h>
#include <osmocom/ranap/RANAP_OMC-ID.h>
#include <osmocom/ranap/RANAP_Offload-RAB-Parameters-APN.h>
#include <osmocom/ranap/RANAP_Offload-RAB-Parameters-ChargingCharacteristics.h>
#include <osmocom/ranap/RANAP_Offload-RAB-Parameters.h>
#include <osmocom/ranap/RANAP_OldBSS-ToNewBSS-Information.h>
#include <osmocom/ranap/RANAP_Out-Of-UTRAN.h>
#include <osmocom/ranap/RANAP_Outcome.h>
#include <osmocom/ranap/RANAP_Overload.h>
#include <osmocom/ranap/RANAP_P-TMSI.h>
#include <osmocom/ranap/RANAP_PDP-Type-extension.h>
#include <osmocom/ranap/RANAP_PDP-Type.h>
#include <osmocom/ranap/RANAP_PDP-TypeInformation-extension.h>
#include <osmocom/ranap/RANAP_PDP-TypeInformation.h>
#include <osmocom/ranap/RANAP_PDUType14FrameSequenceNumber.h>
#include <osmocom/ranap/RANAP_PLMNidentity.h>
#include <osmocom/ranap/RANAP_PLMNs-in-shared-network.h>
#include <osmocom/ranap/RANAP_Paging.h>
#include <osmocom/ranap/RANAP_PagingAreaID.h>
#include <osmocom/ranap/RANAP_PagingCause.h>
#include <osmocom/ranap/RANAP_PeriodicLocationInfo.h>
#include <osmocom/ranap/RANAP_PeriodicReportingIndicator.h>
#include <osmocom/ranap/RANAP_PermanentNAS-UE-ID.h>
#include <osmocom/ranap/RANAP_PermittedEncryptionAlgorithms.h>
#include <osmocom/ranap/RANAP_PermittedIntegrityProtectionAlgorithms.h>
#include <osmocom/ranap/RANAP_Port-Number.h>
#include <osmocom/ranap/RANAP_PositionData.h>
#include <osmocom/ranap/RANAP_PositionDataSpecificToGERANIuMode.h>
#include <osmocom/ranap/RANAP_PositioningDataDiscriminator.h>
#include <osmocom/ranap/RANAP_PositioningDataSet.h>
#include <osmocom/ranap/RANAP_PositioningMethodAndUsage.h>
#include <osmocom/ranap/RANAP_PositioningPriority.h>
#include <osmocom/ranap/RANAP_Pre-emptionCapability.h>
#include <osmocom/ranap/RANAP_Pre-emptionVulnerability.h>
#include <osmocom/ranap/RANAP_Presence.h>
#include <osmocom/ranap/RANAP_Priority-Class-Indicator.h>
#include <osmocom/ranap/RANAP_PriorityLevel.h>
#include <osmocom/ranap/RANAP_PrivateIE-ID.h>
#include <osmocom/ranap/RANAP_PrivateMessage.h>
#include <osmocom/ranap/RANAP_ProcedureCode.h>
#include <osmocom/ranap/RANAP_ProtocolError-IE-ContainerList.h>
#include <osmocom/ranap/RANAP_ProtocolExtensionContainer.h>
#include <osmocom/ranap/RANAP_ProtocolExtensionField.h>
#include <osmocom/ranap/RANAP_ProtocolExtensionID.h>
#include <osmocom/ranap/RANAP_ProtocolIE-Container.h>
#include <osmocom/ranap/RANAP_ProtocolIE-ContainerPair.h>
#include <osmocom/ranap/RANAP_ProtocolIE-FieldPair.h>
#include <osmocom/ranap/RANAP_ProtocolIE-ID.h>
#include <osmocom/ranap/RANAP_ProvidedData.h>
#include <osmocom/ranap/RANAP_QueuingAllowed.h>
#include <osmocom/ranap/RANAP_RAB-AssignmentRequest.h>
#include <osmocom/ranap/RANAP_RAB-AssignmentResponse.h>
#include <osmocom/ranap/RANAP_RAB-AsymmetryIndicator.h>
#include <osmocom/ranap/RANAP_RAB-ContextItem-RANAP-RelocInf.h>
#include <osmocom/ranap/RANAP_RAB-ContextItem.h>
#include <osmocom/ranap/RANAP_RAB-ContextList-RANAP-RelocInf.h>
#include <osmocom/ranap/RANAP_RAB-ContextList.h>
#include <osmocom/ranap/RANAP_RAB-DataForwardingItem-SRNS-CtxReq.h>
#include <osmocom/ranap/RANAP_RAB-DataForwardingItem.h>
#include <osmocom/ranap/RANAP_RAB-DataForwardingList-SRNS-CtxReq.h>
#include <osmocom/ranap/RANAP_RAB-DataForwardingList.h>
#include <osmocom/ranap/RANAP_RAB-DataVolumeReportItem.h>
#include <osmocom/ranap/RANAP_RAB-DataVolumeReportList.h>
#include <osmocom/ranap/RANAP_RAB-DataVolumeReportRequestItem.h>
#include <osmocom/ranap/RANAP_RAB-DataVolumeReportRequestList.h>
#include <osmocom/ranap/RANAP_RAB-FailedItem-EnhRelocInfoRes.h>
#include <osmocom/ranap/RANAP_RAB-FailedItem.h>
#include <osmocom/ranap/RANAP_RAB-FailedList-EnhRelocInfoRes.h>
#include <osmocom/ranap/RANAP_RAB-FailedList.h>
#include <osmocom/ranap/RANAP_RAB-ID.h>
#include <osmocom/ranap/RANAP_RAB-IE-ContainerList.h>
#include <osmocom/ranap/RANAP_RAB-IE-ContainerPairList.h>
#include <osmocom/ranap/RANAP_RAB-ModifyItem.h>
#include <osmocom/ranap/RANAP_RAB-ModifyList.h>
#include <osmocom/ranap/RANAP_RAB-ModifyRequest.h>
#include <osmocom/ranap/RANAP_RAB-Parameter-ExtendedGuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_RAB-Parameter-ExtendedMaxBitrateList.h>
#include <osmocom/ranap/RANAP_RAB-Parameter-GuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_RAB-Parameter-MaxBitrateList.h>
#include <osmocom/ranap/RANAP_RAB-Parameters.h>
#include <osmocom/ranap/RANAP_RAB-QueuedItem.h>
#include <osmocom/ranap/RANAP_RAB-QueuedList.h>
#include <osmocom/ranap/RANAP_RAB-ReleaseFailedList.h>
#include <osmocom/ranap/RANAP_RAB-ReleaseItem.h>
#include <osmocom/ranap/RANAP_RAB-ReleaseList.h>
#include <osmocom/ranap/RANAP_RAB-ReleaseRequest.h>
#include <osmocom/ranap/RANAP_RAB-ReleasedItem-IuRelComp.h>
#include <osmocom/ranap/RANAP_RAB-ReleasedItem.h>
#include <osmocom/ranap/RANAP_RAB-ReleasedList-IuRelComp.h>
#include <osmocom/ranap/RANAP_RAB-ReleasedList.h>
#include <osmocom/ranap/RANAP_RAB-RelocationReleaseItem.h>
#include <osmocom/ranap/RANAP_RAB-RelocationReleaseList.h>
#include <osmocom/ranap/RANAP_RAB-SetupItem-EnhRelocInfoReq.h>
#include <osmocom/ranap/RANAP_RAB-SetupItem-EnhRelocInfoRes.h>
#include <osmocom/ranap/RANAP_RAB-SetupItem-EnhancedRelocCompleteReq.h>
#include <osmocom/ranap/RANAP_RAB-SetupItem-EnhancedRelocCompleteRes.h>
#include <osmocom/ranap/RANAP_RAB-SetupItem-RelocReq.h>
#include <osmocom/ranap/RANAP_RAB-SetupItem-RelocReqAck.h>
#include <osmocom/ranap/RANAP_RAB-SetupList-EnhRelocInfoReq.h>
#include <osmocom/ranap/RANAP_RAB-SetupList-EnhRelocInfoRes.h>
#include <osmocom/ranap/RANAP_RAB-SetupList-EnhancedRelocCompleteReq.h>
#include <osmocom/ranap/RANAP_RAB-SetupList-EnhancedRelocCompleteRes.h>
#include <osmocom/ranap/RANAP_RAB-SetupList-RelocReq.h>
#include <osmocom/ranap/RANAP_RAB-SetupList-RelocReqAck.h>
#include <osmocom/ranap/RANAP_RAB-SetupOrModifiedItem.h>
#include <osmocom/ranap/RANAP_RAB-SetupOrModifiedList.h>
#include <osmocom/ranap/RANAP_RAB-SetupOrModifyItemFirst.h>
#include <osmocom/ranap/RANAP_RAB-SetupOrModifyItemSecond.h>
#include <osmocom/ranap/RANAP_RAB-SetupOrModifyList.h>
#include <osmocom/ranap/RANAP_RAB-SubflowCombinationBitRate.h>
#include <osmocom/ranap/RANAP_RAB-ToBeReleasedItem-EnhancedRelocCompleteRes.h>
#include <osmocom/ranap/RANAP_RAB-ToBeReleasedList-EnhancedRelocCompleteRes.h>
#include <osmocom/ranap/RANAP_RAB-TrCH-Mapping.h>
#include <osmocom/ranap/RANAP_RAB-TrCH-MappingItem.h>
#include <osmocom/ranap/RANAP_RABDataVolumeReport.h>
#include <osmocom/ranap/RANAP_RABParametersList.h>
#include <osmocom/ranap/RANAP_RABased.h>
#include <osmocom/ranap/RANAP_RABs-ContextFailedtoTransferItem.h>
#include <osmocom/ranap/RANAP_RABs-ContextFailedtoTransferList.h>
#include <osmocom/ranap/RANAP_RABs-failed-to-reportItem.h>
#include <osmocom/ranap/RANAP_RABs-failed-to-reportList.h>
#include <osmocom/ranap/RANAP_RAC.h>
#include <osmocom/ranap/RANAP_RAI-List.h>
#include <osmocom/ranap/RANAP_RAI.h>
#include <osmocom/ranap/RANAP_RAListofIdleModeUEs.h>
#include <osmocom/ranap/RANAP_RAListwithNoIdleModeUEsAnyMore.h>
#include <osmocom/ranap/RANAP_RANAP-EnhancedRelocationInformationRequest.h>
#include <osmocom/ranap/RANAP_RANAP-EnhancedRelocationInformationResponse.h>
#include <osmocom/ranap/RANAP_RANAP-PDU.h>
#include <osmocom/ranap/RANAP_RANAP-RelocationInformation.h>
#include <osmocom/ranap/RANAP_RAT-Type.h>
#include <osmocom/ranap/RANAP_RAofIdleModeUEs.h>
#include <osmocom/ranap/RANAP_RIM-Transfer.h>
#include <osmocom/ranap/RANAP_RIMInformation.h>
#include <osmocom/ranap/RANAP_RIMRoutingAddress.h>
#include <osmocom/ranap/RANAP_RNC-ID.h>
#include <osmocom/ranap/RANAP_RNCTraceInformation.h>
#include <osmocom/ranap/RANAP_RNSAPRelocationParameters.h>
#include <osmocom/ranap/RANAP_RRC-Container.h>
#include <osmocom/ranap/RANAP_RSRQ-Extension.h>
#include <osmocom/ranap/RANAP_RSRQ-Type.h>
#include <osmocom/ranap/RANAP_RSRVCC-HO-Indication.h>
#include <osmocom/ranap/RANAP_RSRVCC-Information.h>
#include <osmocom/ranap/RANAP_RSRVCC-Operation-Possible.h>
#include <osmocom/ranap/RANAP_RTLoadValue.h>
#include <osmocom/ranap/RANAP_RateControlAllowed.h>
#include <osmocom/ranap/RANAP_RedirectAttemptFlag.h>
#include <osmocom/ranap/RANAP_RedirectionCompleted.h>
#include <osmocom/ranap/RANAP_RedirectionIndication.h>
#include <osmocom/ranap/RANAP_RejectCauseValue.h>
#include <osmocom/ranap/RANAP_RelocationCancel.h>
#include <osmocom/ranap/RANAP_RelocationCancelAcknowledge.h>
#include <osmocom/ranap/RANAP_RelocationCommand.h>
#include <osmocom/ranap/RANAP_RelocationComplete.h>
#include <osmocom/ranap/RANAP_RelocationDetect.h>
#include <osmocom/ranap/RANAP_RelocationFailure.h>
#include <osmocom/ranap/RANAP_RelocationPreparationFailure.h>
#include <osmocom/ranap/RANAP_RelocationRequest.h>
#include <osmocom/ranap/RANAP_RelocationRequestAcknowledge.h>
#include <osmocom/ranap/RANAP_RelocationRequired.h>
#include <osmocom/ranap/RANAP_RelocationRequirement.h>
#include <osmocom/ranap/RANAP_RelocationType.h>
#include <osmocom/ranap/RANAP_RepetitionNumber0.h>
#include <osmocom/ranap/RANAP_RepetitionNumber1.h>
#include <osmocom/ranap/RANAP_ReportAmount.h>
#include <osmocom/ranap/RANAP_ReportArea.h>
#include <osmocom/ranap/RANAP_ReportChangeOfSAI.h>
#include <osmocom/ranap/RANAP_ReportInterval.h>
#include <osmocom/ranap/RANAP_RequestType.h>
#include <osmocom/ranap/RANAP_Requested-RAB-Parameter-ExtendedGuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_Requested-RAB-Parameter-ExtendedMaxBitrateList.h>
#include <osmocom/ranap/RANAP_Requested-RAB-Parameter-GuaranteedBitrateList.h>
#include <osmocom/ranap/RANAP_Requested-RAB-Parameter-MaxBitrateList.h>
#include <osmocom/ranap/RANAP_Requested-RAB-Parameter-Values.h>
#include <osmocom/ranap/RANAP_RequestedGANSSAssistanceData.h>
#include <osmocom/ranap/RANAP_RequestedGPSAssistanceData.h>
#include <osmocom/ranap/RANAP_RequestedLocationRelatedDataType.h>
#include <osmocom/ranap/RANAP_RequestedMBMSIPMulticastAddressandAPNRequest.h>
#include <osmocom/ranap/RANAP_RequestedMulticastServiceList.h>
#include <osmocom/ranap/RANAP_Reset.h>
#include <osmocom/ranap/RANAP_ResetAcknowledge.h>
#include <osmocom/ranap/RANAP_ResetResource.h>
#include <osmocom/ranap/RANAP_ResetResourceAckItem.h>
#include <osmocom/ranap/RANAP_ResetResourceAckList.h>
#include <osmocom/ranap/RANAP_ResetResourceAcknowledge.h>
#include <osmocom/ranap/RANAP_ResetResourceItem.h>
#include <osmocom/ranap/RANAP_ResetResourceList.h>
#include <osmocom/ranap/RANAP_ResidualBitErrorRatio.h>
#include <osmocom/ranap/RANAP_ResponseTime.h>
#include <osmocom/ranap/RANAP_SAC.h>
#include <osmocom/ranap/RANAP_SAI.h>
#include <osmocom/ranap/RANAP_SAPI.h>
#include <osmocom/ranap/RANAP_SDU-ErrorRatio.h>
#include <osmocom/ranap/RANAP_SDU-FormatInformationParameters.h>
#include <osmocom/ranap/RANAP_SDU-FormatInformationParameterItem.h>
#include <osmocom/ranap/RANAP_SDU-Parameters.h>
#include <osmocom/ranap/RANAP_SDU-ParameterItem.h>
#include <osmocom/ranap/RANAP_SNA-Access-Information.h>
#include <osmocom/ranap/RANAP_SNAC.h>
#include <osmocom/ranap/RANAP_SRB-ID.h>
#include <osmocom/ranap/RANAP_SRB-TrCH-Mapping.h>
#include <osmocom/ranap/RANAP_SRB-TrCH-MappingItem.h>
#include <osmocom/ranap/RANAP_SRNS-ContextRequest.h>
#include <osmocom/ranap/RANAP_SRNS-ContextResponse.h>
#include <osmocom/ranap/RANAP_SRNS-DataForwardCommand.h>
#include <osmocom/ranap/RANAP_SRVCC-CSKeysRequest.h>
#include <osmocom/ranap/RANAP_SRVCC-CSKeysResponse.h>
#include <osmocom/ranap/RANAP_SRVCC-HO-Indication.h>
#include <osmocom/ranap/RANAP_SRVCC-Information.h>
#include <osmocom/ranap/RANAP_SRVCC-Operation-Possible.h>
#include <osmocom/ranap/RANAP_SecurityModeCommand.h>
#include <osmocom/ranap/RANAP_SecurityModeComplete.h>
#include <osmocom/ranap/RANAP_SecurityModeReject.h>
#include <osmocom/ranap/RANAP_Service-Handover.h>
#include <osmocom/ranap/RANAP_Session-Re-establishment-Indicator.h>
#include <osmocom/ranap/RANAP_SessionUpdateID.h>
#include <osmocom/ranap/RANAP_Shared-Network-Information.h>
#include <osmocom/ranap/RANAP_SignallingIndication.h>
#include <osmocom/ranap/RANAP_Source-ToTarget-TransparentContainer.h>
#include <osmocom/ranap/RANAP_SourceBSS-ToTargetBSS-TransparentContainer.h>
#include <osmocom/ranap/RANAP_SourceCellID.h>
#include <osmocom/ranap/RANAP_SourceID.h>
#include <osmocom/ranap/RANAP_SourceRNC-ID.h>
#include <osmocom/ranap/RANAP_SourceRNC-ToTargetRNC-TransparentContainer.h>
#include <osmocom/ranap/RANAP_SourceStatisticsDescriptor.h>
#include <osmocom/ranap/RANAP_SourceUTRANCellID.h>
#include <osmocom/ranap/RANAP_SourceeNodeB-ToTargeteNodeB-TransparentContainer.h>
#include <osmocom/ranap/RANAP_SubflowSDU-Size.h>
#include <osmocom/ranap/RANAP_SubscriberProfileIDforRFP.h>
#include <osmocom/ranap/RANAP_SuccessfulOutcome.h>
#include <osmocom/ranap/RANAP_SupportedBitrate.h>
#include <osmocom/ranap/RANAP_SupportedRAB-ParameterBitrateList.h>
#include <osmocom/ranap/RANAP_TAC.h>
#include <osmocom/ranap/RANAP_TAI.h>
#include <osmocom/ranap/RANAP_TBCD-STRING.h>
#include <osmocom/ranap/RANAP_TMGI.h>
#include <osmocom/ranap/RANAP_TMSI.h>
#include <osmocom/ranap/RANAP_TNLInformationEnhRelInfoReq.h>
#include <osmocom/ranap/RANAP_TNLInformationEnhRelInfoRes.h>
#include <osmocom/ranap/RANAP_Target-ToSource-TransparentContainer.h>
#include <osmocom/ranap/RANAP_TargetBSS-ToSourceBSS-TransparentContainer.h>
#include <osmocom/ranap/RANAP_TargetCellId.h>
#include <osmocom/ranap/RANAP_TargetENB-ID.h>
#include <osmocom/ranap/RANAP_TargetID.h>
#include <osmocom/ranap/RANAP_TargetRNC-ID.h>
#include <osmocom/ranap/RANAP_TargetRNC-ToSourceRNC-TransparentContainer.h>
#include <osmocom/ranap/RANAP_TargeteNodeB-ToSourceeNodeB-TransparentContainer.h>
#include <osmocom/ranap/RANAP_TemporaryUE-ID.h>
#include <osmocom/ranap/RANAP_Time-UE-StayedInCell-EnhancedGranularity.h>
#include <osmocom/ranap/RANAP_Time-UE-StayedInCell.h>
#include <osmocom/ranap/RANAP_TimeToMBMSDataTransfer.h>
#include <osmocom/ranap/RANAP_TimingDifferenceULDL.h>
#include <osmocom/ranap/RANAP_TrCH-ID-List.h>
#include <osmocom/ranap/RANAP_TrCH-ID.h>
#include <osmocom/ranap/RANAP_TraceDepth.h>
#include <osmocom/ranap/RANAP_TraceInformation.h>
#include <osmocom/ranap/RANAP_TracePropagationParameters.h>
#include <osmocom/ranap/RANAP_TraceRecordingSessionInformation.h>
#include <osmocom/ranap/RANAP_TraceRecordingSessionReference.h>
#include <osmocom/ranap/RANAP_TraceReference.h>
#include <osmocom/ranap/RANAP_TraceType.h>
#include <osmocom/ranap/RANAP_TrafficClass.h>
#include <osmocom/ranap/RANAP_TrafficHandlingPriority.h>
#include <osmocom/ranap/RANAP_TransferDelay.h>
#include <osmocom/ranap/RANAP_TransportLayerAddress.h>
#include <osmocom/ranap/RANAP_TransportLayerInformation.h>
#include <osmocom/ranap/RANAP_TriggerID.h>
#include <osmocom/ranap/RANAP_TriggeringMessage.h>
#include <osmocom/ranap/RANAP_TunnelInformation.h>
#include <osmocom/ranap/RANAP_TypeOfError.h>
#include <osmocom/ranap/RANAP_UE-AggregateMaximumBitRate.h>
#include <osmocom/ranap/RANAP_UE-AggregateMaximumBitRateDownlink.h>
#include <osmocom/ranap/RANAP_UE-AggregateMaximumBitRateUplink.h>
#include <osmocom/ranap/RANAP_UE-History-Information.h>
#include <osmocom/ranap/RANAP_UE-ID.h>
#include <osmocom/ranap/RANAP_UESBI-Iu.h>
#include <osmocom/ranap/RANAP_UESBI-IuA.h>
#include <osmocom/ranap/RANAP_UESBI-IuB.h>
#include <osmocom/ranap/RANAP_UESpecificInformationIndication.h>
#include <osmocom/ranap/RANAP_UL-GTP-PDU-SequenceNumber.h>
#include <osmocom/ranap/RANAP_UL-N-PDU-SequenceNumber.h>
#include <osmocom/ranap/RANAP_UP-ModeVersions.h>
#include <osmocom/ranap/RANAP_UPInformation.h>
#include <osmocom/ranap/RANAP_UPInitialisationFrame.h>
#include <osmocom/ranap/RANAP_USCH-ID.h>
#include <osmocom/ranap/RANAP_UTRAN-CellID.h>
#include <osmocom/ranap/RANAP_UeRadioCapabilityMatchRequest.h>
#include <osmocom/ranap/RANAP_UeRadioCapabilityMatchResponse.h>
#include <osmocom/ranap/RANAP_UnsuccessfulLinking-IEs.h>
#include <osmocom/ranap/RANAP_UnsuccessfulOutcome.h>
#include <osmocom/ranap/RANAP_UnsuccessfullyTransmittedDataVolume.h>
#include <osmocom/ranap/RANAP_UplinkInformationExchangeFailure.h>
#include <osmocom/ranap/RANAP_UplinkInformationExchangeRequest.h>
#include <osmocom/ranap/RANAP_UplinkInformationExchangeResponse.h>
#include <osmocom/ranap/RANAP_UserPlaneInformation.h>
#include <osmocom/ranap/RANAP_UserPlaneMode.h>
#include <osmocom/ranap/RANAP_VelocityEstimate.h>
#include <osmocom/ranap/RANAP_VerticalAccuracyCode.h>
#include <osmocom/ranap/RANAP_VerticalSpeedDirection.h>
#include <osmocom/ranap/RANAP_VerticalVelocity.h>
#include <osmocom/ranap/RANAP_VoiceSupportMatchIndicator.h>

#if (ASN1C_ENVIRONMENT_VERSION < 924)
# error "You are compiling with the wrong version of ASN1C"
#endif

#include <osmocom/core/logging.h>
#include <osmocom/core/utils.h>
#include <osmocom/ranap/ranap_ies_defs.h>

struct gprs_ra_id;

#define RANAP_DEBUG(x, args ...) DEBUGP(_ranap_DRANAP, x, ## args)
extern int _ranap_DRANAP;

extern int asn1_xer_print;

extern const struct value_string ranap_presence_vals[5];
extern const struct value_string ranap_procedure_code_vals[48];

char *ranap_cause_str(const RANAP_Cause_t *cause);

struct msgb *ranap_generate_initiating_message(e_RANAP_ProcedureCode procedureCode,
					  RANAP_Criticality_t criticality,
					  asn_TYPE_descriptor_t *td, void *sptr);

struct msgb *ranap_generate_successful_outcome(
					   e_RANAP_ProcedureCode procedureCode,
					   RANAP_Criticality_t criticality,
					   asn_TYPE_descriptor_t * td,
					   void *sptr);

struct msgb *ranap_generate_unsuccessful_outcome(
					e_RANAP_ProcedureCode procedureCode,
					RANAP_Criticality_t criticality,
					asn_TYPE_descriptor_t * td,
					void *sptr);

struct msgb *ranap_generate_outcome(
				e_RANAP_ProcedureCode procedureCode,
				RANAP_Criticality_t criticality,
				asn_TYPE_descriptor_t * td,
				void *sptr);

RANAP_IE_t *ranap_new_ie(RANAP_ProtocolIE_ID_t id, RANAP_Criticality_t criticality,
			 asn_TYPE_descriptor_t *type, void *sptr);

RANAP_ProtocolIE_FieldPair_t *ranap_new_ie_pair(RANAP_ProtocolIE_ID_t id,
				RANAP_Criticality_t criticality1,
				asn_TYPE_descriptor_t *type1, void *sptr1,
				RANAP_Criticality_t criticality2,
				asn_TYPE_descriptor_t *type2, void *sptr2);

void ranap_set_log_area(int log_area);

int ranap_parse_lai(struct gprs_ra_id *ra_id, const RANAP_LAI_t *lai);
int ranap_ip_from_transp_layer_addr(const BIT_STRING_t *in, uint32_t *ip);

/* The generated version does not work, this is a custom one */
int ranap_decode_rab_setupormodifieditemies_fromlist(
    RANAP_RAB_SetupOrModifiedItemIEs_t *raB_SetupOrModifiedItemIEs,
    ANY_t *any_p);
